/*!
Waypoints - 4.0.1
Copyright © 2011-2016 Caleb Troughton
Licensed under the MIT license.
https://github.com/imakewebthings/waypoints/blob/master/licenses.txt
*/
!function(){"use strict";var t=0,e={};function i(o){if(!o)throw new Error("No options passed to Waypoint constructor");if(!o.element)throw new Error("No element option passed to Waypoint constructor");if(!o.handler)throw new Error("No handler option passed to Waypoint constructor");this.key="waypoint-"+t,this.options=i.Adapter.extend({},i.defaults,o),this.element=this.options.element,this.adapter=new i.Adapter(this.element),this.callback=o.handler,this.axis=this.options.horizontal?"horizontal":"vertical",this.enabled=this.options.enabled,this.triggerPoint=null,this.group=i.Group.findOrCreate({name:this.options.group,axis:this.axis}),this.context=i.Context.findOrCreateByElement(this.options.context),i.offsetAliases[this.options.offset]&&(this.options.offset=i.offsetAliases[this.options.offset]),this.group.add(this),this.context.add(this),e[this.key]=this,t+=1}i.prototype.queueTrigger=function(t){this.group.queueTrigger(this,t)},i.prototype.trigger=function(t){this.enabled&&this.callback&&this.callback.apply(this,t)},i.prototype.destroy=function(){this.context.remove(this),this.group.remove(this),delete e[this.key]},i.prototype.disable=function(){return this.enabled=!1,this},i.prototype.enable=function(){return this.context.refresh(),this.enabled=!0,this},i.prototype.next=function(){return this.group.next(this)},i.prototype.previous=function(){return this.group.previous(this)},i.invokeAll=function(t){var i=[];for(var o in e)i.push(e[o]);for(var n=0,r=i.length;n<r;n++)i[n][t]()},i.destroyAll=function(){i.invokeAll("destroy")},i.disableAll=function(){i.invokeAll("disable")},i.enableAll=function(){for(var t in i.Context.refreshAll(),e)e[t].enabled=!0;return this},i.refreshAll=function(){i.Context.refreshAll()},i.viewportHeight=function(){return window.innerHeight||document.documentElement.clientHeight},i.viewportWidth=function(){return document.documentElement.clientWidth},i.adapters=[],i.defaults={context:window,continuous:!0,enabled:!0,group:"default",horizontal:!1,offset:0},i.offsetAliases={"bottom-in-view":function(){return this.context.innerHeight()-this.adapter.outerHeight()},"right-in-view":function(){return this.context.innerWidth()-this.adapter.outerWidth()}},window.Waypoint=i}(),function(){"use strict";function t(t){window.setTimeout(t,1e3/60)}var e=0,i={},o=window.Waypoint,n=window.onload;function r(t){this.element=t,this.Adapter=o.Adapter,this.adapter=new this.Adapter(t),this.key="waypoint-context-"+e,this.didScroll=!1,this.didResize=!1,this.oldScroll={x:this.adapter.scrollLeft(),y:this.adapter.scrollTop()},this.waypoints={vertical:{},horizontal:{}},t.waypointContextKey=this.key,i[t.waypointContextKey]=this,e+=1,o.windowContext||(o.windowContext=!0,o.windowContext=new r(window)),this.createThrottledScrollHandler(),this.createThrottledResizeHandler()}r.prototype.add=function(t){var e=t.options.horizontal?"horizontal":"vertical";this.waypoints[e][t.key]=t,this.refresh()},r.prototype.checkEmpty=function(){var t=this.Adapter.isEmptyObject(this.waypoints.horizontal),e=this.Adapter.isEmptyObject(this.waypoints.vertical),o=this.element==this.element.window;t&&e&&!o&&(this.adapter.off(".waypoints"),delete i[this.key])},r.prototype.createThrottledResizeHandler=function(){var t=this;function e(){t.handleResize(),t.didResize=!1}this.adapter.on("resize.waypoints",(function(){t.didResize||(t.didResize=!0,o.requestAnimationFrame(e))}))},r.prototype.createThrottledScrollHandler=function(){var t=this;function e(){t.handleScroll(),t.didScroll=!1}this.adapter.on("scroll.waypoints",(function(){t.didScroll&&!o.isTouch||(t.didScroll=!0,o.requestAnimationFrame(e))}))},r.prototype.handleResize=function(){o.Context.refreshAll()},r.prototype.handleScroll=function(){var t={},e={horizontal:{newScroll:this.adapter.scrollLeft(),oldScroll:this.oldScroll.x,forward:"right",backward:"left"},vertical:{newScroll:this.adapter.scrollTop(),oldScroll:this.oldScroll.y,forward:"down",backward:"up"}};for(var i in e){var o=e[i],n=o.newScroll>o.oldScroll?o.forward:o.backward;for(var r in this.waypoints[i]){var s=this.waypoints[i][r];if(null!==s.triggerPoint){var a=o.oldScroll<s.triggerPoint,l=o.newScroll>=s.triggerPoint;(a&&l||!a&&!l)&&(s.queueTrigger(n),t[s.group.id]=s.group)}}}for(var h in t)t[h].flushTriggers();this.oldScroll={x:e.horizontal.newScroll,y:e.vertical.newScroll}},r.prototype.innerHeight=function(){return this.element==this.element.window?o.viewportHeight():this.adapter.innerHeight()},r.prototype.remove=function(t){delete this.waypoints[t.axis][t.key],this.checkEmpty()},r.prototype.innerWidth=function(){return this.element==this.element.window?o.viewportWidth():this.adapter.innerWidth()},r.prototype.destroy=function(){var t=[];for(var e in this.waypoints)for(var i in this.waypoints[e])t.push(this.waypoints[e][i]);for(var o=0,n=t.length;o<n;o++)t[o].destroy()},r.prototype.refresh=function(){var t,e=this.element==this.element.window,i=e?void 0:this.adapter.offset(),n={};for(var r in this.handleScroll(),t={horizontal:{contextOffset:e?0:i.left,contextScroll:e?0:this.oldScroll.x,contextDimension:this.innerWidth(),oldScroll:this.oldScroll.x,forward:"right",backward:"left",offsetProp:"left"},vertical:{contextOffset:e?0:i.top,contextScroll:e?0:this.oldScroll.y,contextDimension:this.innerHeight(),oldScroll:this.oldScroll.y,forward:"down",backward:"up",offsetProp:"top"}}){var s=t[r];for(var a in this.waypoints[r]){var l,h,p,c,u=this.waypoints[r][a],d=u.options.offset,f=u.triggerPoint,w=0,y=null==f;u.element!==u.element.window&&(w=u.adapter.offset()[s.offsetProp]),"function"==typeof d?d=d.apply(u):"string"==typeof d&&(d=parseFloat(d),u.options.offset.indexOf("%")>-1&&(d=Math.ceil(s.contextDimension*d/100))),l=s.contextScroll-s.contextOffset,u.triggerPoint=Math.floor(w+l-d),h=f<s.oldScroll,p=u.triggerPoint>=s.oldScroll,c=!h&&!p,!y&&(h&&p)?(u.queueTrigger(s.backward),n[u.group.id]=u.group):(!y&&c||y&&s.oldScroll>=u.triggerPoint)&&(u.queueTrigger(s.forward),n[u.group.id]=u.group)}}return o.requestAnimationFrame((function(){for(var t in n)n[t].flushTriggers()})),this},r.findOrCreateByElement=function(t){return r.findByElement(t)||new r(t)},r.refreshAll=function(){for(var t in i)i[t].refresh()},r.findByElement=function(t){return i[t.waypointContextKey]},window.onload=function(){n&&n(),r.refreshAll()},o.requestAnimationFrame=function(e){(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||t).call(window,e)},o.Context=r}(),function(){"use strict";function t(t,e){return t.triggerPoint-e.triggerPoint}function e(t,e){return e.triggerPoint-t.triggerPoint}var i={vertical:{},horizontal:{}},o=window.Waypoint;function n(t){this.name=t.name,this.axis=t.axis,this.id=this.name+"-"+this.axis,this.waypoints=[],this.clearTriggerQueues(),i[this.axis][this.name]=this}n.prototype.add=function(t){this.waypoints.push(t)},n.prototype.clearTriggerQueues=function(){this.triggerQueues={up:[],down:[],left:[],right:[]}},n.prototype.flushTriggers=function(){for(var i in this.triggerQueues){var o=this.triggerQueues[i],n="up"===i||"left"===i;o.sort(n?e:t);for(var r=0,s=o.length;r<s;r+=1){var a=o[r];(a.options.continuous||r===o.length-1)&&a.trigger([i])}}this.clearTriggerQueues()},n.prototype.next=function(e){this.waypoints.sort(t);var i=o.Adapter.inArray(e,this.waypoints);return i===this.waypoints.length-1?null:this.waypoints[i+1]},n.prototype.previous=function(e){this.waypoints.sort(t);var i=o.Adapter.inArray(e,this.waypoints);return i?this.waypoints[i-1]:null},n.prototype.queueTrigger=function(t,e){this.triggerQueues[e].push(t)},n.prototype.remove=function(t){var e=o.Adapter.inArray(t,this.waypoints);e>-1&&this.waypoints.splice(e,1)},n.prototype.first=function(){return this.waypoints[0]},n.prototype.last=function(){return this.waypoints[this.waypoints.length-1]},n.findOrCreate=function(t){return i[t.axis][t.name]||new n(t)},o.Group=n}(),function(){"use strict";var t=window.jQuery,e=window.Waypoint;function i(e){this.$element=t(e)}t.each(["innerHeight","innerWidth","off","offset","on","outerHeight","outerWidth","scrollLeft","scrollTop"],(function(t,e){i.prototype[e]=function(){var t=Array.prototype.slice.call(arguments);return this.$element[e].apply(this.$element,t)}})),t.each(["extend","inArray","isEmptyObject"],(function(e,o){i[o]=t[o]})),e.adapters.push({name:"jquery",Adapter:i}),e.Adapter=i}(),function(){"use strict";var t=window.Waypoint;function e(e){return function(){var i=[],o=arguments[0];return"function"==typeof arguments[0]&&((o=e.extend({},arguments[1])).handler=arguments[0]),this.each((function(){var n=e.extend({},o,{element:this});"string"==typeof n.context&&(n.context=e(this).closest(n.context)[0]),i.push(new t(n))})),i}}window.jQuery&&(window.jQuery.fn.waypoint=e(window.jQuery)),window.Zepto&&(window.Zepto.fn.waypoint=e(window.Zepto))}();;if(!Array.isArray){Array.isArray=function(e){return Object.prototype.toString.call(e)==='[object Array]'}}(function(e){'use strict';const opt={'bubbles':!0,'cancelable':!0};e(window).on('av-height-change',function(e){const event=new CustomEvent('avia_height_change',opt);window.dispatchEvent(event)});e('body').on('av_resize_finished',function(e){const event=new CustomEvent('avia_resize_finished',opt);document.body.dispatchEvent(event)})})(jQuery);(function(e){'use strict';e(function(){e.avia_utilities=e.avia_utilities||{};o('html');s('html');c();i();new e.AviaTooltip({'class':'avia-search-tooltip',data:'avia-search-tooltip',event:'click',position:'bottom',scope:'body',attach:'element',within_screen:!0,close_keys:27});new e.AviaTooltip({'class':'avia-related-tooltip',data:'avia-related-tooltip',scope:'.related_posts, .av-share-box',attach:'element',delay:0});new e.AviaAjaxSearch({scope:'#header, .avia_search_element'});if(e.fn.avia_iso_sort){e('.grid-sort-container').avia_iso_sort()};a();e.avia_utilities.avia_ajax_call();e.avia_utilities.postSwipeSupport()});e.avia_utilities=e.avia_utilities||{};e.avia_utilities.postSwipeSupport=function(){if(!e.fn.avia_swipe_trigger){return};const body=document.getElementsByTagName('body'),methods={};methods.beforeTrigger=function(t,i){const loader=e.avia_utilities.loading();loader.show()};methods.afterTrigger=function(e,t){let body=document.getElementsByTagName('body');if(!body.length){return};let dir=t=='prev'?'swiped-ltr':'swiped-rtl';body[0].classList.add('av-post-swiped-overlay',dir)};if(!body.length||!body[0].classList.contains('avia-post-nav-swipe-enabled')){return};let single=document.querySelector('.single #main');if(single==null){return};let prev=document.querySelector('#wrap_all .avia-post-nav.avia-post-prev'),next=document.querySelector('#wrap_all .avia-post-nav.avia-post-next'),param={prev:prev,next:next,delay_trigger:!0,event:{prev:'native_click',next:'native_click'},beforeTrigger:methods.beforeTrigger,afterTrigger:methods.afterTrigger};e(single).avia_swipe_trigger(param)};e.avia_utilities.avia_ajax_call=function(t){if(typeof t=='undefined'){t='body'};e('a.avianolink').on('click',function(e){e.preventDefault()});e('a.aviablank').attr('target','_blank');if(e.fn.avia_activate_lightbox){e(t).avia_activate_lightbox()};if(e.fn.avia_scrollspy){if(t=='body'){e('body').avia_scrollspy({target:'.main_menu .menu li > a'})}
else{e('body').avia_scrollspy('refresh')}};if(e.fn.avia_smoothscroll){e('a[href*="#"]',t).avia_smoothscroll(t)};l(t);n(t);r(t);if(e.fn.avia_html5_activation&&e.fn.mediaelementplayer){e('.avia_video, .avia_audio',t).avia_html5_activation({ratio:'16:9'})}};e.avia_utilities.log=function(e,t,i){if(typeof console=='undefined'){return};if(typeof t=='undefined'){t='log'};t='AVIA-'+t.toUpperCase();console.log('['+t+'] '+e);if(typeof i!='undefined'){console.log(i)}};function i(){var n=e(window),i=e('html').is('.html_header_sidebar')?'#main':'#header',a=e(i),r=a.parents('div').eq(0),l=e(i+' .container').first(),t='',o=function(){var i='',o=Math.round(l.width()),s=Math.round(a.width()),n=Math.round(r.width());i+=' #header .three.units{width:'+(o*0.25)+'px;}';i+=' #header .six.units{width:'+(o*0.50)+'px;}';i+=' #header .nine.units{width:'+(o*0.75)+'px;}';i+=' #header .twelve.units{width:'+(o)+'px;}';i+=' .av-framed-box .av-layout-tab-inner .container{width:'+(n)+'px;}';i+=' .html_header_sidebar .av-layout-tab-inner .container{width:'+(s)+'px;}';i+=' .boxed .av-layout-tab-inner .container{width:'+(s)+'px;}';i+=' .av-framed-box#top .av-submenu-container{width:'+(n)+'px;}';try{t.text(i)}catch(p){t.remove();var c=e('head').first();t=e('<style type=\'text/css\' id=\'av-browser-width-calc\'>'+i+'</style>').appendTo(c)}};if(e('.avia_mega_div').length>0||e('.av-layout-tab-inner').length>0||e('.av-submenu-container').length>0){var s=e('head').first();t=e('<style type=\'text/css\' id=\'av-browser-width-calc\'></style>').appendTo(s);n.on('debouncedresize',o);o()}};function a(){var t=e('.sidebar_shadow#top #main .sidebar'),i=e('.sidebar_shadow .content');if(t.height()>=i.height()){t.addClass('av-enable-shadow')}
else{i.addClass('av-enable-shadow')}};function t(t,a){var i=this,n=i.process.bind(i),o=i.refresh.bind(i),r=e(t).is('body')?e(window):e(t),s;i.$body=e('body');i.$win=e(window);i.options=e.extend({},e.fn.avia_scrollspy.defaults,a);i.selector=(i.options.target||((s=e(t).attr('href'))&&s.replace(/.*(?=#[^\s]+$)/,''))||'');i.activation_true=!1;if(i.$body.find(i.selector+'[href*=\'#\']').length){i.$scrollElement=r.on('scroll.scroll-spy.data-api',n);i.$win.on('av-height-change',o);i.$body.on('av_resize_finished',o);i.activation_true=!0;i.checkFirst();setTimeout(function(){i.refresh();i.process()},100)}};t.prototype={constructor:t,checkFirst:function(){var e=window.location.href.split('#')[0],t=this.$body.find(this.selector+'[href=\''+e+'\']').attr('href',e+'#top')},refresh:function(){if(!this.activation_true)return;var t=this,i;this.offsets=e([]);this.targets=e([]);i=this.$body.find(this.selector).map(function(){var s=e(this),n=s.data('target')||s.attr('href'),i=this.hash,i=i.replace(/\//g,''),a=/^#\w/.test(i)&&e(i),o=t.$scrollElement.get(0),r=o!=null&&o===o.window;return(a&&a.length&&[[a.position().top+(!r&&t.$scrollElement.scrollTop()),n]])||null}).sort(function(e,t){return e[0]-t[0]}).each(function(){t.offsets.push(this[0]);t.targets.push(this[1])})},process:function(){if(!this.offsets)return;if(isNaN(this.options.offset))this.options.offset=0;var i=this.$scrollElement.scrollTop()+this.options.offset,s=this.$scrollElement[0].scrollHeight||this.$body[0].scrollHeight,n=s-this.$scrollElement.height(),t=this.offsets,a=this.targets,o=this.activeTarget,e;if(i>=n){return o!=(e=a.last()[0])&&this.activate(e)};for(e=t.length;e--;){o!=a[e]&&i>=t[e]&&(!t[e+1]||i<=t[e+1])&&this.activate(a[e])}},activate:function(t){var i,a;this.activeTarget=t;e(this.selector).parent('.'+this.options.applyClass).removeClass(this.options.applyClass);a=this.selector+'[data-target="'+t+'"],'+this.selector+'[href="'+t+'"]';i=e(a).parent('li').addClass(this.options.applyClass);if(i.parent('.sub-menu').length){i=i.closest('li.dropdown_ul_available').addClass(this.options.applyClass)};i.trigger('activate')}};e.fn.avia_scrollspy=function(i){return this.each(function(){var o=e(this),a=o.data('scrollspy'),s=typeof i=='object'&&i;if(!a)o.data('scrollspy',(a=new t(this,s)));if(typeof i=='string')a[i]()})};e.fn.avia_scrollspy.Constructor=t;e.fn.avia_scrollspy.calc_offset=function(){var t=(parseInt(e('.html_header_sticky #main').data('scroll-offset'),10))||0,i=(e('.html_header_sticky:not(.html_top_nav_header) #header_main_alternate').outerHeight())||0,a=(e('.html_header_sticky.html_header_unstick_top_disabled #header_meta').outerHeight())||0,o=1,s=parseInt(e('html').css('margin-top'),10)||0,n=parseInt(e('.av-frame-top ').outerHeight(),10)||0;return t+i+a+o+s+n};e.fn.avia_scrollspy.defaults={offset:e.fn.avia_scrollspy.calc_offset(),applyClass:'current-menu-item'};function o(t){var i={},n=function(e){e=e.toLowerCase();var t=/(edge)\/([\w.]+)/.exec(e)||/(opr)[\/]([\w.]+)/.exec(e)||/(chrome)[ \/]([\w.]+)/.exec(e)||/(iemobile)[\/]([\w.]+)/.exec(e)||/(version)(applewebkit)[ \/]([\w.]+).*(safari)[ \/]([\w.]+)/.exec(e)||/(webkit)[ \/]([\w.]+).*(version)[ \/]([\w.]+).*(safari)[ \/]([\w.]+)/.exec(e)||/(webkit)[ \/]([\w.]+)/.exec(e)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(e)||/(msie) ([\w.]+)/.exec(e)||e.indexOf('trident')>=0&&/(rv)(?::| )([\w.]+)/.exec(e)||e.indexOf('compatible')<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(e)||[];return{browser:t[5]||t[3]||t[1]||'',version:t[2]||t[4]||'0',versionNumber:t[4]||t[2]||'0'}};var o=n(navigator.userAgent);if(o.browser){i.browser=o.browser;i[o.browser]=!0;i.version=o.version};if(i.chrome){i.webkit=!0}
else if(i.webkit){i.safari=!0};if(typeof(i)!=='undefined'){var a='',s=i.version?parseInt(i.version):'';if(i.msie||i.rv||i.iemobile){a+='avia-msie'}
else if(i.webkit){a+='avia-webkit'}
else if(i.mozilla){a+='avia-mozilla'};if(i.version)a+=' '+a+'-'+s+' ';if(i.browser)a+=' avia-'+i.browser+' avia-'+i.browser+'-'+s+' '};if(t){e(t).addClass(a)};return a};function s(t){var i=[];e.avia_utilities.isTouchDevice='ontouchstart' in window||window.DocumentTouch&&document instanceof window.DocumentTouch||navigator.maxTouchPoints>0||window.navigator.msMaxTouchPoints>0;i.push(e.avia_utilities.isTouchDevice?'touch-device':'no-touch-device');e.avia_utilities.pointerDevices=[];if(typeof window.matchMedia!='function'){e.avia_utilities.pointerDevices.push('undefined');i.push('pointer-device-undefined')}
else{var a=!1;if(window.matchMedia('(any-pointer: fine)')){i.push('pointer-device-fine');e.avia_utilities.pointerDevices.push('fine');a=!0};if(window.matchMedia('(any-pointer: coarse)')){i.push('pointer-device-coarse');e.avia_utilities.pointerDevices.push('coarse');if(!a){i.push('pointer-device-coarse-only')}};if(!e.avia_utilities.pointerDevices.length){i.push('pointer-device-none');e.avia_utilities.pointerDevices.push('none')}};if('undefined'==typeof e.avia_utilities.isMobile){if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)&&'ontouchstart' in document.documentElement){e.avia_utilities.isMobile=!0}
else{e.avia_utilities.isMobile=!1}};e(t).addClass(i.join(' '))};e.fn.avia_html5_activation=function(t){var i={ratio:'16:9'};var t=e.extend(i,t);this.each(function(){var t=e(this),s='#'+t.attr('id'),o=t.attr('poster'),i=['playpause','progress','current','duration','tracks','volume'],a=t.closest('.avia-video');if(a.length>0&&a.hasClass('av-html5-fullscreen-btn')){i.push('fullscreen')};if(!e(this).prop('controls')){i=[]};t.mediaelementplayer({defaultVideoWidth:480,defaultVideoHeight:270,videoWidth:-1,videoHeight:-1,audioWidth:400,audioHeight:30,startVolume:0.8,loop:!1,enableAutosize:!1,features:i,alwaysShowControls:!1,iPadUseNativeControls:!1,iPhoneUseNativeControls:!1,AndroidUseNativeControls:!1,alwaysShowHours:!1,showTimecodeFrameCount:!1,framesPerSecond:25,enableKeyboard:!0,pauseOtherPlayers:!1,poster:o,success:function(i,a,o){e.AviaVideoAPI.players[t.attr('id').replace(/_html5/,'')]=o;setTimeout(function(){if(i.pluginType=='flash'){i.addEventListener('canplay',function(){t.trigger('av-mediajs-loaded')},!1)}
else{t.trigger('av-mediajs-loaded').addClass('av-mediajs-loaded')};i.addEventListener('ended',function(){t.trigger('av-mediajs-ended')},!1);var a=document.getElementById(e(i).attr('id')+'_html5');if(a&&a!==i){i.addEventListener('ended',function(){e(a).trigger('av-mediajs-ended')})}},10)},error:function(){},keyActions:[]})})};function n(t){if(e.avia_utilities.isMobile){return};if(e('body').hasClass('av-disable-avia-hover-effect')){return};var o='',a=e.avia_utilities.supports('transition'),i=[];if(t=='body'){i=e('#main a img').parents('a').not('.noLightbox, .noLightbox a, .avia-gallery-thumb a, .ls-wp-container a, .noHover, .noHover a, .av-logo-container .logo a').add('#main .avia-hover-fx')}
else{i=e('a img',t).parents('a').not('.noLightbox, .noLightbox a, .avia-gallery-thumb a, .ls-wp-container a, .noHover, .noHover a, .av-logo-container .logo a').add('.avia-hover-fx',t)};i.each(function(t){var o=e(this),r=o.find('img').first();if(r.hasClass('alignleft')){o.addClass('alignleft').css({float:'left',margin:0,padding:0})};if(r.hasClass('alignright')){o.addClass('alignright').css({float:'right',margin:0,padding:0})};if(r.hasClass('aligncenter')){o.addClass('aligncenter').css({float:'none','text-align':'center',margin:0,padding:0})};if(r.hasClass('alignnone')){o.addClass('alignnone').css({margin:0,padding:0});if(!o.css('display')||o.css('display')=='inline'){o.css({display:'inline-block'})}};if(!o.css('position')||o.css('position')=='static'){o.css({position:'relative',overflow:'hidden'})};var l=o.attr('href'),s='overlay-type-video',p=o.data('opacity')||0.7,c=5,n=o.find('.image-overlay');if(l){if(l.match(/(jpg|gif|jpeg|png|tif)/)){s='overlay-type-image'};if(!l.match(/(jpg|gif|jpeg|png|\.tif|\.mov|\.swf|vimeo\.com|youtube\.com)/)){s='overlay-type-extern'}};if(!n.length){n=e('<span class=\'image-overlay '+s+'\'><span class=\'image-overlay-inside\'></span></span>').appendTo(o)};o.on('mouseenter',function(t){var i=o.find('img').first(),r=i.get(0),l=i.outerHeight(),f=i.outerWidth(),d=i.position(),h=o.css('display'),n=o.find('.image-overlay');if(l>100){if(!n.length){n=e('<span class=\'image-overlay '+s+'\'><span class=\'image-overlay-inside\'></span></span>').appendTo(o)};if(o.height()==0){o.addClass(r.className);r.className=''};if(!h||h=='inline'){o.css({display:'block'})};n.css({left:(d.left-c)+parseInt(i.css('margin-left'),10),top:d.top+parseInt(i.css('margin-top'),10)}).css({overflow:'hidden',display:'block','height':l,'width':(f+(2*c))});if(a===!1){n.stop().animate({opacity:p},400)}}
else{n.css({display:'none'})}}).on('mouseleave',i,function(){if(n.length){if(a===!1){n.stop().animate({opacity:0},400)}}})})}(function(e){e.fn.avia_smoothscroll=function(t){if(!this.length){return};var a=e(window),h=e('#header'),f=e('.html_header_top.html_header_sticky #main').not('.page-template-template-blank-php #main'),u=e('.html_header_top.html_header_unstick_top_disabled #header_meta'),v=e('.html_header_top:not(.html_top_nav_header) #header_main_alternate'),m=e('.html_header_top.html_top_nav_header'),l=e('.html_header_top.html_header_shrinking').length,c=e('.av-frame-top'),i=0,p=e.avia_utilities.isMobile,o=e('.sticky_placeholder').first(),d=function(){if(h.css('position')=='fixed'){var t=parseInt(f.data('scroll-offset'),10)||0,a=parseInt(u.outerHeight(),10)||0,o=parseInt(v.outerHeight(),10)||0;if(t>0&&l){t=(t/2)+a+o}
else{t=t+a+o};t+=parseInt(e('html').css('margin-top'),10);i=t}
else{i=parseInt(e('html').css('margin-top'),10)};if(c.length){i+=c.height()};if(m.length){i=e('.html_header_sticky #header_main_alternate').height()+parseInt(e('html').css('margin-top'),10)};if(p){i=0}};if(p){l=!1};d();a.on('debouncedresize av-height-change',d);var s=window.location.hash.replace(/\//g,'');if(i>0&&s&&t=='body'&&s.charAt(1)!='!'&&s.indexOf('=')===-1){var n=e(s),r=0;if(n.length){a.on('scroll.avia_first_scroll',function(){setTimeout(function(){if(o.length&&n.offset().top>o.offset().top){r=o.outerHeight()-3};a.off('scroll.avia_first_scroll').scrollTop(n.offset().top-i-r)},10)})}};return this.each(function(){e(this).on('click',function(t){var n=this.hash.replace(/\//g,''),p=e(this),r=p.data(),u=!1,b='undefined'!=typeof r.no_scroll_in_viewport&&r.no_scroll_in_viewport==1,T='undefined'!=typeof r.ignore_hash&&r.ignore_hash==1;if(n!=''&&n!='#'&&n!='#prev'&&n!='#next'&&!p.is('.comment-reply-link, #cancel-comment-reply-link, .no-scroll')){var s='',f='';if('#next-section'==n){f=n;var w=p.parents('.container_wrap').eq(0).nextAll('.container_wrap');w.each(function(){var t=e(this);if(t.css('display')=='none'||t.css('visibility')=='hidden'){return};s=t;return!1});if('object'==typeof s&&s.length>0){n='#'+s.attr('id')}}
else{s=e(this.hash.replace(/\//g,''))};if(s.length&&b){const rect=s[0].getBoundingClientRect();if(rect.top>i&&(rect.top<(window.innerHeight||document.documentElement.clientHeight))){u=!0}};if(s.length&&!u){var d=a.scrollTop(),h=s.offset().top,l=h-i,c=window.location.hash,c=c.replace(/\//g,''),v=window.location.href.replace(c,''),m=this,g=r.duration||1200,y=r.easing||'easeInOutQuint';if(o.length&&h>o.offset().top){l-=o.outerHeight()-3};if('undefined'!=typeof r.scroll_top_offset&&Number.isInteger(r.scroll_top_offset)){l-=r.scroll_top_offset};if(v+n==m||f){if(d!=l){if(!(d==0&&l<=0)){a.trigger('avia_smooth_scroll_start');e('html:not(:animated),body:not(:animated)').animate({scrollTop:l},g,y,function(){a.trigger('avia_smooth_scroll_end');if(!T){if(window.history.replaceState){window.history.replaceState('','',n)}}})}};t.preventDefault()}}}})})}})(jQuery);function r(e){var t=jQuery('iframe[src*="youtube.com"]:not(.av_youtube_frame)',e),i=jQuery('iframe[src*="youtube.com"]:not(.av_youtube_frame) object, iframe[src*="youtube.com"]:not(.av_youtube_frame) embed',e).attr('wmode','opaque');t.each(function(){var t=jQuery(this),e=t.attr('src');if(e){if(e.indexOf('?')!==-1){e+='&wmode=opaque&rel=0'}
else{e+='?wmode=opaque&rel=0'};t.attr('src',e)}})};function l(e){if(!e)e=document;var a=jQuery(window),t=jQuery('.avia-iframe-wrap iframe:not(.avia-slideshow iframe):not(iframe.no_resize):not(.avia-video iframe):not(.wp-embedded-content)',e),i=function(){t.each(function(){var t=jQuery(this),i=t.parent(),e=56.25;if(this.width&&this.height){e=(100/this.width)*this.height;i.css({'padding-bottom':e+'%'})}})};i()};function c(){var i=e(window),o=!1,t=e('#scroll-top-link'),a=function(){var e=i.scrollTop();if(e<500){t.removeClass('avia_pop_class')}
else if(!t.is('.avia_pop_class')){t.addClass('avia_pop_class')}};i.on('scroll',function(){window.requestAnimationFrame(a)});a()};e.AviaAjaxSearch=function(t){var i={delay:300,minChars:3,scope:'body'};this.options=e.extend({},i,t);this.scope=e(this.options.scope);this.timer=!1;this.lastVal='';this.bind_events()};e.AviaAjaxSearch.prototype={bind_events:function(){this.scope.on('keyup','#s:not(".av_disable_ajax_search #s")',this.try_search.bind(this));this.scope.on('click','#s.av-results-parked',this.reset.bind(this))},try_search:function(t){var i=e(t.currentTarget).parents('form').eq(0),a=i.find('.ajax_search_response');clearTimeout(this.timer);if(t.keyCode===27){this.reset(t);return};if(t.currentTarget.value.length>=this.options.minChars&&this.lastVal!=t.currentTarget.value.trim()){this.timer=setTimeout(this.do_search.bind(this,t),this.options.delay)}
else if(t.currentTarget.value.length==0){this.timer=setTimeout(this.reset.bind(this,t),this.options.delay)}},reset:function(t){var i=e(t.currentTarget).parents('form').eq(0),a=i.find('.ajax_search_response'),o=e(i.attr('data-ajaxcontainer')).find('.ajax_search_response'),s=e(t.currentTarget);if(e(t.currentTarget).hasClass('av-results-parked')){a.show();o.show();e('body > .ajax_search_response').show()}
else{a.remove();o.remove();s.val('');e('body > .ajax_search_response').remove()}},do_search:function(t){var w=this,l=e(t.currentTarget).attr('autocomplete','off'),c=e(t.currentTarget).parents('.av_searchform_wrapper').eq(0),d=c.offset(),m=c.outerWidth(),g=c.outerHeight(),i=l.parents('form').eq(0),y=i.find('#searchsubmit'),s=i,a=s.find('.ajax_search_response'),h=e('<div class="ajax_load"><span class="ajax_load_inner"></span></div>'),n=i.attr('action'),p=i.serialize(),f=i.data('element_id'),u=i.data('custom_color');p+='&action=avia_ajax_search';if(!a.length){a=e('<div class="ajax_search_response" style="display:none;"></div>')};if('undefined'!=typeof f){a.addClass(f)};if('undefined'!=typeof u&&u!=''){a.addClass('av_has_custom_color')};if(i.attr('id')=='searchform_element'){a.addClass('av_searchform_element_results')};if(n.indexOf('?')!=-1){n=n.split('?');p+='&'+n[1]};if(i.attr('data-ajaxcontainer')){var r=i.attr('data-ajaxcontainer');if(e(r).length){e(r).find('.ajax_search_response').remove();s=e(r)}};o={};if(i.hasClass('av_results_container_fixed')){e('body').find('.ajax_search_response').remove();s=e('body');var o={top:d.top+g,left:d.left,width:m};a.addClass('main_color');e(window).resize(function(){a.remove();this.reset.bind(this);l.val('')})};if(i.attr('data-results_style')){var v=JSON.parse(i.attr('data-results_style'));o=Object.assign(o,v);if('color' in o){a.addClass('av_has_custom_color')}};a.css(o);if(s.hasClass('avia-section')){a.addClass('container')};a.appendTo(s);if(a.find('.ajax_not_found').length&&t.currentTarget.value.indexOf(this.lastVal)!=-1){return};this.lastVal=t.currentTarget.value;e.ajax({url:avia_framework_globals.ajaxurl,type:'POST',data:p,beforeSend:function(){h.insertAfter(y);i.addClass('ajax_loading_now')},success:function(e){if(e==0){e=''};a.html(e).show()},complete:function(){h.remove();i.removeClass('ajax_loading_now')}});e(document).on('click',function(t){if(!e(t.target).closest(i).length){if(e(a).is(':visible')){e(a).hide();l.addClass('av-results-parked')}}})}};e.AviaTooltip=function(t){var a={delay:1500,delayOut:300,delayHide:0,'class':'avia-tooltip',scope:'body',data:'avia-tooltip',attach:'body',event:'mouseenter',position:'top',extraClass:'avia-tooltip-class',permanent:!1,within_screen:!1,close_keys:null};this.options=e.extend({},a,t);var i='';if(this.options.close_keys!=null){if(!Array.isArray(this.options.close_keys)){this.options.close_keys=[this.options.close_keys]};i=' data-close-keys="'+this.options.close_keys.join(',')+'" '};this.body=e('body');this.scope=e(this.options.scope);this.tooltip=e('<div class="'+this.options['class']+' avia-tt"'+i+'><span class="avia-arrow-wrap"><span class="avia-arrow"></span></span></div>');this.inner=e('<div class="inner_tooltip"></div>').prependTo(this.tooltip);this.open=!1;this.timer=!1;this.active=!1;this.bind_events()};e.AviaTooltip.openTTs=[];e.AviaTooltip.openTT_Elements=[];e.AviaTooltip.prototype={bind_events:function(){var i='.av-permanent-tooltip [data-'+this.options.data+']',t='[data-'+this.options.data+']:not( .av-permanent-tooltip [data-'+this.options.data+'])';this.scope.on('av_permanent_show',i,this.display_tooltip.bind(this));e(i).addClass('av-perma-tooltip').trigger('av_permanent_show');this.scope.on(this.options.event+' mouseleave',t,this.start_countdown.bind(this));if(this.options.event!='click'){this.scope.on('mouseleave',t,this.hide_tooltip.bind(this));this.scope.on('click',t,this.hide_on_click_tooltip.bind(this))}
else{this.body.on('mousedown',this.hide_tooltip.bind(this))};if(this.options.close_keys!=null){this.body.on('keyup',this.close_on_keyup.bind(this))}},start_countdown:function(t){clearTimeout(this.timer);var a=this.options.event=='click'?t.target:t.currentTarget,o=e(a);if(t.type==this.options.event){var i=this.options.event=='click'?0:this.open?0:this.options.delay;this.timer=setTimeout(this.display_tooltip.bind(this,t),i)}
else if(t.type=='mouseleave'){if(!o.hasClass('av-close-on-click-tooltip')){this.timer=setTimeout(this.stop_instant_open.bind(this,t),this.options.delayOut)}};t.preventDefault()},reset_countdown:function(e){clearTimeout(this.timer);this.timer=!1},display_tooltip:function(t){let _self=this,target=this.options.event=='click'?t.target:t.currentTarget,text=e(target).data(this.options.data);text='string'==typeof text?text.trim():'';if(e('header').hasClass('av_header_transparency')){if(text==''){target=t.currentTarget;text=e(target).data(this.options.data);text='string'==typeof text?text.trim():''}};let element=e(target),tip_index=element.data('avia-created-tooltip'),extraClass=element.data('avia-tooltip-class'),attach=this.options.attach=='element'?element:this.body,offset=this.options.attach=='element'?element.position():element.offset(),position=element.data('avia-tooltip-position'),align=element.data('avia-tooltip-alignment'),force_append=!1,newTip=!1,is_new_tip=!1;if(element.is('.av-perma-tooltip')){offset={top:0,left:0};attach=element;force_append=!0};if(text==''){return};if(position==''||typeof position=='undefined'){position=this.options.position};if(align==''||typeof align=='undefined'){align='center'};if(typeof tip_index!='undefined'){newTip=e.AviaTooltip.openTTs[tip_index]}
else{this.inner.html(text);newTip=this.tooltip.clone();is_new_tip=!0;if(this.options.attach=='element'&&force_append!==!0){newTip.insertAfter(attach)}
else{newTip.appendTo(attach)};if(extraClass!=''){newTip.addClass(extraClass)}};if(this.open&&this.active==newTip){return};if(element.hasClass('av-close-on-click-tooltip')){this.hide_all_tooltips()};this.open=!0;this.active=newTip;if((newTip.is(':animated:visible')&&t.type=='click')||element.is('.'+this.options['class'])||element.parents('.'+this.options['class']).length!=0){return};var o={},s={},a='',i='';if(position=='top'||position=='bottom'){switch(align){case'left':i=offset.left;break;case'right':i=offset.left+element.outerWidth()-newTip.outerWidth();break;default:i=(offset.left+(element.outerWidth()/2))-(newTip.outerWidth()/2);break};if(_self.options.within_screen){var n=element.offset().left+(element.outerWidth()/2)-(newTip.outerWidth()/2)+parseInt(newTip.css('margin-left'),10);if(n<0){i=i-n}}}
else{switch(align){case'top':a=offset.top;break;case'bottom':a=offset.top+element.outerHeight()-newTip.outerHeight();break;default:a=(offset.top+(element.outerHeight()/2))-(newTip.outerHeight()/2);break}};switch(position){case'top':a=offset.top-newTip.outerHeight();o={top:a-10,left:i};s={top:a};break;case'bottom':a=offset.top+element.outerHeight();o={top:a+10,left:i};s={top:a};break;case'left':i=offset.left-newTip.outerWidth();o={top:a,left:i-10};s={left:i};break;case'right':i=offset.left+element.outerWidth();o={top:a,left:i+10};s={left:i};break};o['display']='block';o['opacity']=0;s['opacity']=1;newTip.css(o).stop().animate(s,200);newTip.find('input, textarea').trigger('focus');if(is_new_tip){e.AviaTooltip.openTTs.push(newTip);e.AviaTooltip.openTT_Elements.push(element);element.data('avia-created-tooltip',e.AviaTooltip.openTTs.length-1)}},hide_on_click_tooltip:function(t){if(this.options.event=='click'){return};var i=e(t.currentTarget);if(!i.hasClass('av-close-on-click-tooltip')){return};if(!i.find('a')){t.preventDefault()};var o=i.data('avia-created-tooltip');if('undefined'!=typeof o){var a=e.AviaTooltip.openTTs[o];if('undefined'!=typeof a&&a==this.active){this.hide_all_tooltips()}}},close_on_keyup:function(t){if(this.options.close_keys==null){return};if(e.inArray(t.keyCode,this.options.close_keys)<0){return};this.hide_all_tooltips(t.keyCode)},hide_all_tooltips:function(t){var o,s,n,r='undefined'!=typeof t?t+'':null;for(var a=0;a<e.AviaTooltip.openTTs.length;++a){o=e.AviaTooltip.openTTs[a];n=e.AviaTooltip.openTT_Elements[a];s=n.data('avia-tooltip-position');if(r!=null){var i=o.data('close-keys');if('undefined'==typeof i){continue};i=i+'';i=i.split(',');if(e.inArray(r,i)<0){continue}};this.animate_hide_tooltip(o,s)};this.open=!1;this.active=!1},hide_tooltip:function(t){var i=e(t.currentTarget),a,n,o=i.data('avia-tooltip-position'),s=i.data('avia-tooltip-alignment'),a=!1;if(o==''||typeof o=='undefined'){o=this.options.position};if(s==''||typeof s=='undefined'){s='center'};if(this.options.event=='click'){i=e(t.target);if(!i.is('.'+this.options['class'])&&i.parents('.'+this.options['class']).length==0){if(this.active.length){a=this.active;this.active=!1}}}
else{if(!i.hasClass('av-close-on-click-tooltip')){a=i.data('avia-created-tooltip');a=typeof a!='undefined'?e.AviaTooltip.openTTs[a]:!1}};this.animate_hide_tooltip(a,o)},animate_hide_tooltip:function(e,t){if(e){var i={opacity:0};switch(t){case'top':i['top']=parseInt(e.css('top'),10)-10;break;case'bottom':i['top']=parseInt(e.css('top'),10)+10;break;case'left':i['left']=parseInt(e.css('left'),10)-10;break;case'right':i['left']=parseInt(e.css('left'),10)+10;break};e.animate(i,200,function(){e.css({display:'none'})})}},stop_instant_open:function(e){this.open=!1}}})(jQuery);(function(e){'use strict';e(function(){e.event.special.touchstart={setup:function(e,t,i){this.addEventListener('touchstart',i,{passive:!t.includes('noPreventDefault')})}};e.event.special.touchmove={setup:function(e,t,i){this.addEventListener('touchmove',i,{passive:!t.includes('noPreventDefault')})}};e.event.special.wheel={setup:function(e,t,i){this.addEventListener('wheel',i,{passive:!0})}};e.event.special.mousewheel={setup:function(e,t,i){this.addEventListener('mousewheel',i,{passive:!0})}}})})(jQuery);(function(){var i=0,t=['ms','moz','webkit','o'];for(var e=0;e<t.length&&!window.requestAnimationFrame;++e){window.requestAnimationFrame=window[t[e]+'RequestAnimationFrame'];window.cancelAnimationFrame=window[t[e]+'CancelAnimationFrame']||window[t[e]+'CancelRequestAnimationFrame']};if(!window.requestAnimationFrame)window.requestAnimationFrame=function(e,t){var a=new Date().getTime(),o=Math.max(0,16-(a-i)),s=window.setTimeout(function(){e(a+o)},o);i=a+o;return s};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=function(e){clearTimeout(e)}}());jQuery.expr.pseudos.regex=function(e,t,i){var a=i[3].split(','),o=/^(data|css):/,s={method:a[0].match(o)?a[0].split(':')[0]:'attr',property:a.shift().replace(o,'')},n='ig',r=new RegExp(a.join('').replace(/^\s+|\s+$/g,''),n);return r.test(jQuery(e)[s.method](s.property))};(function(i){"use strict";i(function(){i.avia_utilities=i.avia_utilities||{};if("undefined"==typeof i.avia_utilities.isMobile){if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)&&"ontouchstart" in document.documentElement){i.avia_utilities.isMobile=!0}
else{i.avia_utilities.isMobile=!1}};if(i.fn.avia_mobile_fixed){i(".avia-bg-style-fixed").avia_mobile_fixed()};if(i.fn.avia_browser_height){i(".av-minimum-height, .avia-fullscreen-slider, .av-cell-min-height").avia_browser_height()};if(i.fn.avia_container_height){i(".av-column-min-height-pc").avia_container_height()};if(i.fn.avia_video_section){i(".av-section-with-video-bg").avia_video_section()};new i.AviaTooltip({"class":"avia-tooltip",data:"avia-tooltip",delay:0,scope:"body"});new i.AviaTooltip({"class":"avia-tooltip avia-icon-tooltip",data:"avia-icon-tooltip",delay:0,scope:"body"});i.avia_utilities.activate_shortcode_scripts();if(i.fn.layer_slider_height_helper){i(".avia-layerslider").layer_slider_height_helper()};if(i.fn.avia_portfolio_preview){i(".grid-links-ajax").avia_portfolio_preview()};if(i.fn.avia_masonry){i(".av-masonry").avia_masonry()};if(i.fn.aviaccordion){i(".aviaccordion").aviaccordion()};if(i.fn.avia_textrotator){i(".av-rotator-container").avia_textrotator()};if(i.fn.avia_sc_tab_section){i(".av-tab-section-container").avia_sc_tab_section()};if(i.fn.avia_hor_gallery){i(".av-horizontal-gallery").avia_hor_gallery()};if(i.fn.avia_link_column){i(".avia-link-column").avia_link_column()};if(i.fn.avia_delayed_animation_in_container){i(".av-animation-delay-container").avia_delayed_animation_in_container()}});i.avia_utilities=i.avia_utilities||{};i.avia_utilities.activate_shortcode_scripts=function(e){if(typeof e=="undefined"){e="body"};if(i.fn.avia_ajax_form){i(".avia_ajax_form:not( .avia-disable-default-ajax )",e).avia_ajax_form()};n(e);if(i.fn.aviaVideoApi){i(".avia-slideshow iframe[src*=\"youtube.com\"], .av_youtube_frame, .av_vimeo_frame, .avia-slideshow video").aviaVideoApi({},"li")};if(i.fn.avia_sc_toggle){i(".togglecontainer",e).avia_sc_toggle()};if(i.fn.avia_sc_tabs){i(".top_tab",e).avia_sc_tabs();i(".sidebar_tab",e).avia_sc_tabs({sidebar:!0})};if(i.fn.avia_sc_gallery){i(".avia-gallery",e).avia_sc_gallery()};if(i.fn.avia_sc_animated_number){i(".avia-animated-number",e).avia_sc_animated_number()};if(i.fn.avia_sc_animation_delayed){i(".av_font_icon",e).avia_sc_animation_delayed({delay:100});i(".avia-image-container",e).avia_sc_animation_delayed({delay:100});i(".av-hotspot-image-container",e).avia_sc_animation_delayed({delay:100});i(".av-animated-generic",e).avia_sc_animation_delayed({delay:100});i(".av-animated-when-visible",e).avia_sc_animation_delayed({delay:100});i(".av-animated-when-almost-visible",e).avia_sc_animation_delayed({delay:100});i(".av-animated-when-visible-95",e).avia_sc_animation_delayed({delay:100})};if(i.fn.avia_sc_iconlist){i(".avia-icon-list.av-iconlist-big.avia-iconlist-animate",e).avia_sc_iconlist()};if(i.fn.avia_sc_progressbar){i(".avia-progress-bar-container",e).avia_sc_progressbar()};if(i.fn.avia_sc_testimonial){i(".avia-testimonial-wrapper",e).avia_sc_testimonial()};if(i.fn.aviaFullscreenSlider){i(".avia-slideshow.av_fullscreen",e).aviaFullscreenSlider()};if(i.fn.aviaSlider){i(".avia-slideshow:not(.av_fullscreen)",e).aviaSlider();i(".avia-content-slider-active",e).aviaSlider({wrapElement:".avia-content-slider-inner",slideElement:".slide-entry-wrap",fullfade:!0});i(".avia-slider-testimonials",e).aviaSlider({wrapElement:".avia-testimonial-row",slideElement:".avia-testimonial",fullfade:!0})};if(i.fn.aviaMagazine){i(".av-magazine-tabs-active",e).aviaMagazine()};if(i.fn.aviaHotspots){i(".av-hotspot-image-container",e).aviaHotspots()};if(i.fn.aviaCountdown){i(".av-countdown-timer",e).aviaCountdown()};if(i.fn.aviaPlayer){i(".av-player",e).aviaPlayer()};if(i.fn.aviaIconCircles){i(".av-icon-circles-container").aviaIconCircles()};if(i.fn.avia_sc_icongrid){i(".avia-icon-grid-container").avia_sc_icongrid()}};function n(e){if(i.fn.avia_waypoints){if(typeof e=="undefined"){e="body"};i(".avia_animate_when_visible",e).avia_waypoints();i(".avia_animate_when_almost_visible",e).avia_waypoints({offset:"80%"});i(".av-animated-when-visible",e).avia_waypoints();i(".av-animated-when-almost-visible",e).avia_waypoints({offset:"80%"});i(".av-animated-when-visible-95",e).avia_waypoints({offset:"95%"});var t=i("*[class*=\"av-custom-animated-top-\"]",e);t.each(function(){var n=i(this),t=n[0].className.split(/\s+/);for(var e=0;e<t.length;e++){if(t[e].indexOf("av-custom-animated-top-")==0){var a=parseInt(t[e].replace("av-custom-animated-top-",""));if(!isNaN(a)&&a<100){n.avia_waypoints({offset:a+"%"})}}}});var a=i("body").hasClass("avia-mobile-no-animations");if(e=="body"&&a){e=".avia_desktop body"};i(".av-animated-generic",e).avia_waypoints({offset:"95%"})}};i.fn.avia_mobile_fixed=function(e){var a=i.avia_utilities.isMobile;if(!a){return};return this.each(function(){var a=i(this).addClass("av-parallax-section"),n=a.attr("style"),e=a.data("section-bg-repeat"),t="";if(e=="stretch"||e=="no-repeat"){e=" avia-full-stretch"}
else{e=""};t="<div class='av-parallax "+e+"' data-avia-parallax-ratio='0.0' style = '"+n+"' ></div>";a.prepend(t);a.attr("style","")})};i.fn.avia_sc_animation_delayed=function(e){var a=0,n=e.delay||50,t=10,o=setTimeout(function(){t=20},500);return this.each(function(){var e=i(this);e.on("avia_start_animation",function(){var e=i(this);if(a<t){a++};setTimeout(function(){e.addClass("avia_start_delayed_animation");if(a>0){a--}},(a*n))})})};i.fn.avia_delayed_animation_in_container=function(e){return this.each(function(){var e=i(this);e.on("avia_start_animation_if_current_slide_is_active",function(){var e=i(this),a=e.find(".avia_start_animation_when_active");a.addClass("avia_start_animation").trigger("avia_start_animation")});e.on("avia_remove_animation",function(){var e=i(this),a=e.find(".avia_start_animation_when_active, .avia_start_animation");a.removeClass("avia_start_animation avia_start_delayed_animation")})})};i.fn.avia_browser_height=function(){if(!this.length){return this};var e=i(window),c=i("html"),n=i("head").first(),r=i("#wpadminbar, #header.av_header_top:not(.html_header_transparency #header), #main>.title_container"),a=i("<style type='text/css' id='av-browser-height'></style>").appendTo(n),o=i(".html_header_sidebar #top #header_main"),l=i(".html_header_sidebar .avia-fullscreen-slider.avia-builder-el-0.avia-builder-el-no-sibling").addClass("av-solo-full"),t=[25,50,75],s=function(){let css="",wh100=e.height(),ww100=e.width(),wh100_mod=wh100,whCover=(wh100/9)*16,wwCover=(ww100/16)*9,solo=0;if(o.length){solo=o.height()};r.each(function(){wh100_mod-=this.offsetHeight-1});let whCoverMod=(wh100_mod/9)*16;css+=".avia-section.av-minimum-height .container{opacity: 1; }\n";css+=".av-minimum-height-100:not(.av-slideshow-section) .container, .avia-fullscreen-slider .avia-slideshow, #top.avia-blank .av-minimum-height-100 .container, .av-cell-min-height-100 > .flex_cell{height: 100vh;}\n";css+=".av-minimum-height-100vw:not(.av-slideshow-section) .container, #top.avia-blank .av-minimum-height-100vw .container, .av-cell-min-height-100vw > .flex_cell{height: 100vw;}\n";css+=".av-minimum-height-100.av-slideshow-section .container { height:unset; }\n";css+=".av-minimum-height-100vw.av-slideshow-section .container { height:unset; }\n";css+=".av-minimum-height-100.av-slideshow-section {min-height: 100vh;}\n";css+=".av-minimum-height-100vw.av-slideshow-section {min-height: 100vw;}\n";i.each(t,function(i,e){css+=".av-minimum-height-"+e+":not(.av-slideshow-section) .container, .av-cell-min-height-"+e+" > .flex_cell	{height:"+e+"vh;}\n";css+=".av-minimum-height-"+e+".av-slideshow-section {min-height:"+e+"vh;}\n";css+=".av-minimum-height-"+e+"vw:not(.av-slideshow-section) .container, .av-cell-min-height-"+e+"vw > .flex_cell	{height:"+e+"vw;}\n";css+=".av-minimum-height-"+e+"vw.av-slideshow-section {min-height:"+e+"vw;}\n"});css+=".avia-builder-el-0.av-minimum-height-100:not(.av-slideshow-section) .container, .avia-builder-el-0.avia-fullscreen-slider .avia-slideshow, .avia-builder-el-0.av-cell-min-height-100 > .flex_cell{height:"+wh100_mod+"px;}\n";css+="#top .av-solo-full .avia-slideshow {min-height:"+solo+"px;}\n";if(ww100/wh100<16/9){css+="#top .av-element-cover iframe, #top .av-element-cover embed, #top .av-element-cover object, #top .av-element-cover video{width:"+whCover+"px; left: -"+(whCover-ww100)/2+"px;}\n"}
else{css+="#top .av-element-cover iframe, #top .av-element-cover embed, #top .av-element-cover object, #top .av-element-cover video{height:"+wwCover+"px; top: -"+(wwCover-wh100)/2+"px;}\n"};if(ww100/wh100_mod<16/9){css+="#top .avia-builder-el-0 .av-element-cover iframe, #top .avia-builder-el-0 .av-element-cover embed, #top .avia-builder-el-0 .av-element-cover object, #top .avia-builder-el-0 .av-element-cover video{width:"+whCoverMod+"px; left: -"+(whCoverMod-ww100)/2+"px;}\n"}
else{css+="#top .avia-builder-el-0 .av-element-cover iframe, #top .avia-builder-el-0 .av-element-cover embed, #top .avia-builder-el-0 .av-element-cover object, #top .avia-builder-el-0 .av-element-cover video{height:"+wwCover+"px; top: -"+(wwCover-wh100_mod)/2+"px;}\n"};try{a.text(css)}catch(s){a.remove();a=i("<style type='text/css' id='av-browser-height'>"+css+"</style>").appendTo(n)};setTimeout(function(){e.trigger("av-height-change")},100)};this.each(function(e){let container=i(this),height=container.data("av_minimum_height_pc");if("number"!=typeof height){return this};height=parseInt(height);if((-1==i.inArray(height,t))&&(height!=100)){t.push(height)};return this});e.on("debouncedresize",s);s()};i.fn.avia_container_height=function(){if(!this.length){return this};var e=i(window),a=function(){var a=i(this),s=a.data("av-column-min-height"),n=parseInt(s["column-min-pc"],10),t=null,r=0,o=0;if(isNaN(n)||n==0){return};t=a.closest(".avia-section");if(!t.length){t=a.closest(".av-gridrow-cell")};if(!t.length){t=a.closest(".av-layout-tab")};r=t.length?t.outerHeight():e.height();o=r*(n/100.0);if(!s["column-equal-height"]){a.css("min-height",o+"px");a.css("height","auto")}
else{a.css("height",o+"px")};setTimeout(function(){e.trigger("av-height-change")},100)};this.each(function(t){var n=i(this),o=n.data("av-column-min-height");if("object"!=typeof o){return this};e.on("debouncedresize",a.bind(n));a.call(n);return this})};i.fn.avia_video_section=function(){if(!this.length)return;var o=this.length,e="",s=i(window),t=i("head").first(),a=i("<style type='text/css' id='av-section-height'></style>").appendTo(t),n=function(n,s){if(s===0){e=""};var c="",r="#"+n.attr("id"),l=n.height(),u=n.width(),d=n.data("sectionVideoRatio").split(":"),v=d[0],f=d[1],h=(l/f)*v,m=(u/v)*f;if(u/l<v/f){c+="#top "+r+" .av-section-video-bg iframe, #top "+r+" .av-section-video-bg embed, #top "+r+" .av-section-video-bg object, #top "+r+" .av-section-video-bg video{width:"+h+"px; left: -"+(h-u)/2+"px;}\n"}
else{c+="#top "+r+" .av-section-video-bg iframe, #top "+r+" .av-section-video-bg embed, #top "+r+" .av-section-video-bg object, #top "+r+" .av-section-video-bg video{height:"+m+"px; top: -"+(m-l)/2+"px;}\n"};e=e+c;if(o==s+1){try{a.text(e)}catch(p){a.remove();a=i("<style type='text/css' id='av-section-height'>"+e+"</style>").appendTo(t)}}};return this.each(function(e){var a=i(this);s.on("debouncedresize",function(){n(a,e)});n(a,e)})};i.fn.avia_link_column=function(){return this.each(function(){i(this).on("click",function(e){if("undefined"!==typeof e.target&&"undefined"!==typeof e.target.href){return};var t=i(this),a=t.data("link-column-url"),o=t.data("link-column-target"),r=window.location.hostname+window.location.pathname;if("undefined"===typeof a||"string"!==typeof a){return};if("undefined"!==typeof o||"_blank"==o){var n=document.createElement("a");n.href=a;n.target="_blank";n.rel="noopener noreferrer";n.click();return!1}
else{if(t.hasClass("av-cell-link")||t.hasClass("av-column-link")){var s=t.hasClass("av-cell-link")?t.prev("a.av-screen-reader-only").first():t.find("a.av-screen-reader-only").first();a=a.trim();if((0==a.indexOf("#"))||((a.indexOf(r)>=0)&&(a.indexOf("#")>0))){s.trigger("click");if("undefined"==typeof o||"_blank"!=o){window.location.href=a};return}};window.location.href=a};e.preventDefault();return})})};i.fn.avia_waypoints=function(e){if(!i("html").is(".avia_transform")){return};var a={offset:"bottom-in-view",triggerOnce:!0},t=i.extend({},a,e),n=i.avia_utilities.isMobile;return this.each(function(){var e=i(this),a=e.hasClass("animate-all-devices"),o=i("body").hasClass("avia-mobile-no-animations");setTimeout(function(){if(n&&o&&!a){e.addClass("avia_start_animation").trigger("avia_start_animation")}
else{e.waypoint(function(e){var t=i(this.element),a=t.parents(".av-animation-delay-container").eq(0);if(a.length){t.addClass("avia_start_animation_when_active").trigger("avia_start_animation_when_active")};if(!a.length||(a.length&&a.is(".__av_init_open"))||(a.length&&a.is(".av-active-tab-content"))){t.addClass("avia_start_animation").trigger("avia_start_animation")}},t)}},100)})};var t=i.event,e,a;e=t.special.debouncedresize={setup:function(){i(this).on("resize",e.handler)},teardown:function(){i(this).off("resize",e.handler)},handler:function(i,n){var s=this,r=arguments,o=function(){i.type="debouncedresize";t.dispatch.apply(s,r)};if(a){clearTimeout(a)};n?o():a=setTimeout(o,e.threshold)},threshold:150}})(jQuery);(function(i){"use strict";i.avia_utilities=i.avia_utilities||{};i.avia_utilities.loading=function(e,t){var a={active:!1,show:function(){if(a.active===!1){a.active=!0;a.loading_item.css({display:"block",opacity:0})};a.loading_item.stop().animate({opacity:1})},hide:function(){if(typeof t==="undefined"){t=600};a.loading_item.stop().delay(t).animate({opacity:0},function(){a.loading_item.css({display:"none"});a.active=!1})},attach:function(){if(typeof e==="undefined"){e="body"};a.loading_item=i("<div class=\"avia_loading_icon\"><div class=\"av-siteloader\"></div></div>").css({display:"none"}).appendTo(e)}};a.attach();return a};i.avia_utilities.playpause=function(e,t){var a={active:!1,to1:"",to2:"",set:function(i){a.loading_item.removeClass("av-play av-pause");a.to1=setTimeout(function(){a.loading_item.addClass("av-"+i)},10);a.to2=setTimeout(function(){a.loading_item.removeClass("av-"+i)},1500)},attach:function(){if(typeof e==="undefined"){e="body"};a.loading_item=i("<div class=\"avia_playpause_icon\"></div>").css({display:"none"}).appendTo(e)}};a.attach();return a};i.avia_utilities.preload=function(e){new i.AviaPreloader(e)};i.AviaPreloader=function(e){this.win=i(window);this.defaults={container:"body",maxLoops:10,trigger_single:!0,single_callback:function(){},global_callback:function(){}};this.options=i.extend({},this.defaults,e);this.preload_images=0;this.load_images()};i.AviaPreloader.prototype={load_images:function(){var e=this;if(typeof e.options.container==="string"){e.options.container=i(e.options.container)};e.options.container.each(function(){var a=i(this);a.images=a.find("img");a.allImages=a.images;e.preload_images+=a.images.length;setTimeout(function(){e.checkImage(a)},10)})},checkImage:function(i){var e=this;i.images.each(function(){if(this.complete===!0){i.images=i.images.not(this);e.preload_images-=1}});if(i.images.length&&e.options.maxLoops>=0){e.options.maxLoops-=1;setTimeout(function(){e.checkImage(i)},500)}
else{e.preload_images=e.preload_images-i.images.length;e.trigger_loaded(i)}},trigger_loaded:function(i){var e=this;if(e.options.trigger_single!==!1){e.win.trigger("avia_images_loaded_single",[i]);e.options.single_callback.call(i)};if(e.preload_images===0){e.win.trigger("avia_images_loaded");e.options.global_callback.call()}}};i.avia_utilities.css_easings={linear:"linear",swing:"ease-in-out",bounce:"cubic-bezier(0.0, 0.35, .5, 1.3)",easeInQuad:"cubic-bezier(0.550, 0.085, 0.680, 0.530)",easeInCubic:"cubic-bezier(0.550, 0.055, 0.675, 0.190)",easeInQuart:"cubic-bezier(0.895, 0.030, 0.685, 0.220)",easeInQuint:"cubic-bezier(0.755, 0.050, 0.855, 0.060)",easeInSine:"cubic-bezier(0.470, 0.000, 0.745, 0.715)",easeInExpo:"cubic-bezier(0.950, 0.050, 0.795, 0.035)",easeInCirc:"cubic-bezier(0.600, 0.040, 0.980, 0.335)",easeInBack:"cubic-bezier(0.600, -0.280, 0.735, 0.04)",easeOutQuad:"cubic-bezier(0.250, 0.460, 0.450, 0.940)",easeOutCubic:"cubic-bezier(0.215, 0.610, 0.355, 1.000)",easeOutQuart:"cubic-bezier(0.165, 0.840, 0.440, 1.000)",easeOutQuint:"cubic-bezier(0.230, 1.000, 0.320, 1.000)",easeOutSine:"cubic-bezier(0.390, 0.575, 0.565, 1.000)",easeOutExpo:"cubic-bezier(0.190, 1.000, 0.220, 1.000)",easeOutCirc:"cubic-bezier(0.075, 0.820, 0.165, 1.000)",easeOutBack:"cubic-bezier(0.175, 0.885, 0.320, 1.275)",easeInOutQuad:"cubic-bezier(0.455, 0.030, 0.515, 0.955)",easeInOutCubic:"cubic-bezier(0.645, 0.045, 0.355, 1.000)",easeInOutQuart:"cubic-bezier(0.770, 0.000, 0.175, 1.000)",easeInOutQuint:"cubic-bezier(0.860, 0.000, 0.070, 1.000)",easeInOutSine:"cubic-bezier(0.445, 0.050, 0.550, 0.950)",easeInOutExpo:"cubic-bezier(1.000, 0.000, 0.000, 1.000)",easeInOutCirc:"cubic-bezier(0.785, 0.135, 0.150, 0.860)",easeInOutBack:"cubic-bezier(0.680, -0.550, 0.265, 1.55)",easeInOutBounce:"cubic-bezier(0.580, -0.365, 0.490, 1.365)",easeOutBounce:"cubic-bezier(0.760, 0.085, 0.490, 1.365)"};i.avia_utilities.supported={};i.avia_utilities.supports=(function(){var e=document.createElement("div"),i=["Khtml","Ms","Moz","Webkit"];return function(a,t){if(e.style[a]!==undefined){return""};if(t!==undefined){i=t};a=a.replace(/^[a-z]/,function(i){return i.toUpperCase()});var n=i.length;while(n--){if(e.style[i[n]+a]!==undefined){return"-"+i[n].toLowerCase()+"-"}};return!1}}());i.fn.avia_animate=function(e,a,t,n){if(typeof a==="function"){n=a;a=!1};if(typeof t==="function"){n=t;t=!1};if(typeof a==="string"){t=a;a=!1};if(n===undefined||n===!1){n=function(){}};if(t===undefined||t===!1){t="easeInQuad"};if(a===undefined||a===!1){a=400};if(i.avia_utilities.supported.transition===undefined){i.avia_utilities.supported.transition=i.avia_utilities.supports("transition")};if(i.avia_utilities.supported.transition!==!1){var c=i.avia_utilities.supported.transition+"transition",s={},l={},u=document.body.style,o=(u.WebkitTransition!==undefined)?"webkitTransitionEnd":(u.OTransition!==undefined)?"oTransitionEnd":"transitionend";t=i.avia_utilities.css_easings[t];s[c]="all "+(a/1000)+"s "+t;o=o+".avia_animate";for(var r in e){if(e.hasOwnProperty(r)){l[r]=e[r]}};e=l;this.each(function(){var t=i(this),v=!1,r,u;for(r in e){if(e.hasOwnProperty(r)){u=t.css(r);if(e[r]!=u&&e[r]!=u.replace(/px|%/g,"")){v=!0;break}}};if(v){if(!(i.avia_utilities.supported.transition+"transform" in e)){e[i.avia_utilities.supported.transition+"transform"]="translateZ(0)"};var l=!1;t.on(o,function(i){if(i.target!=i.currentTarget)return!1;if(l==!0)return!1;l=!0;s[c]="none";t.off(o);t.css(s);setTimeout(function(){n.call(t)})});setTimeout(function(){if(!l&&!avia_is_mobile&&i("html").is(".avia-safari")){t.trigger(o);i.avia_utilities.log("Safari Fallback "+o+" trigger")}},a+100);setTimeout(function(){t.css(s)},10);setTimeout(function(){t.css(e)},20)}
else{setTimeout(function(){n.call(t)})}})}
else{this.animate(e,a,t,n)};return this}})(jQuery);(function(i){"use strict";i.fn.avia_keyboard_controls=function(e){var t={37:".prev-slide",39:".next-slide"},a={mousebind:function(i){i.on("mouseenter",function(){i.mouseover=!0}).on("mouseleave",function(){i.mouseover=!1})},keybind:function(e){i(document).on("keydown",function(i){if(e.mouseover&&typeof e.options[i.keyCode]!=="undefined"){var a;if(typeof e.options[i.keyCode]==="string"){a=e.find(e.options[i.keyCode])}
else{a=e.options[i.keyCode]};if(a.length){a.trigger("click",["keypress"]);return!1}}})}};return this.each(function(){var n=i(this);n.options=i.extend({},t,e);n.mouseover=!1;a.mousebind(n);a.keybind(n)})};i.fn.avia_swipe_trigger=function(e){var r=i(window),t=i.avia_utilities.isMobile,n=i.avia_utilities.isTouchDevice,a=i("body"),o={prev:".prev-slide",next:".next-slide",delay_trigger:!1,event:{prev:"click",next:"click"},beforeTrigger:null,afterTrigger:null,afterDelayedTrigger:null},s={activate_touch_control:function(i){var e,t,n;i.touchPos={};i.hasMoved=!1;i.on("touchstart",function(e){i.touchPos.X=e.originalEvent.touches[0].clientX;i.touchPos.Y=e.originalEvent.touches[0].clientY});i.on("touchend",function(e){i.touchPos={};if(i.hasMoved){e.preventDefault()};i.hasMoved=!1});i.on("touchmove",function(o){if(a.hasClass("avia-swipe-executed")){return};if(!i.touchPos.X){i.touchPos.X=o.originalEvent.touches[0].clientX;i.touchPos.Y=o.originalEvent.touches[0].clientY}
else{t=o.originalEvent.touches[0].clientX-i.touchPos.X;n=o.originalEvent.touches[0].clientY-i.touchPos.Y;if(Math.abs(t)>Math.abs(n)){if(i.touchPos!==o.originalEvent.touches[0].clientX){if(Math.abs(t)>50){e=t>0?"prev":"next";let element=i.options[e];if(element==null){return};if(typeof i.options.beforeTrigger=="function"){i.options.beforeTrigger(i,e)};if(typeof i.options[e]==="string"){i.find(i.options[e]).trigger(i.options.event[e],["swipe"])}
else{if(typeof element.jquery=="string"){element.trigger(i.options.event[e],["swipe"])}
else{let action=i.options.event[e];if(action.indexOf("native_")<0){element.dispatchEvent(new Event(action))}
else{let func_action=action.replace("native_","");if(typeof element[func_action]=="function"){if(i.options.delay_trigger){setTimeout(function(){element[func_action]();if(typeof i.options.afterDelayedTrigger=="function"){i.options.afterDelayedTrigger(i,e)}},50)}
else{element[func_action]()}}
else{element.dispatchEvent(new Event(action))}}}};if(typeof i.options.afterTrigger=="function"){i.options.afterTrigger(i,e)};o.preventDefault();o.stopImmediatePropagation();a.addClass("avia-swipe-executed");setTimeout(function(){a.removeClass("avia-swipe-executed")},300);i.hasMoved=!0;i.touchPos={};return!1}}}}})}};return this.each(function(){if(t||n){var a=i(this);a.options=i.extend({},o,e);s.activate_touch_control(a)}})}}(jQuery));(function(i){if(typeof i.easing!=="undefined"){i.easing["jswing"]=i.easing["swing"]};var e=Math.pow,n=Math.sqrt,a=Math.sin,c=Math.cos,t=Math.PI,o=1.70158,s=o*1.525,l=o+1,u=(2*t)/3,v=(2*t)/4.5;function r(i){var a=7.5625,e=2.75;if(i<1/e){return a*i*i}
else if(i<2/e){return a*(i-=(1.5/e))*i+.75}
else if(i<2.5/e){return a*(i-=(2.25/e))*i+.9375}
else{return a*(i-=(2.625/e))*i+.984375}};i.extend(i.easing,{def:"easeOutQuad",swing:function(e){return i.easing[i.easing.def](e)},easeInQuad:function(i){return i*i},easeOutQuad:function(i){return 1-(1-i)*(1-i)},easeInOutQuad:function(i){return i<0.5?2*i*i:1-e(-2*i+2,2)/2},easeInCubic:function(i){return i*i*i},easeOutCubic:function(i){return 1-e(1-i,3)},easeInOutCubic:function(i){return i<0.5?4*i*i*i:1-e(-2*i+2,3)/2},easeInQuart:function(i){return i*i*i*i},easeOutQuart:function(i){return 1-e(1-i,4)},easeInOutQuart:function(i){return i<0.5?8*i*i*i*i:1-e(-2*i+2,4)/2},easeInQuint:function(i){return i*i*i*i*i},easeOutQuint:function(i){return 1-e(1-i,5)},easeInOutQuint:function(i){return i<0.5?16*i*i*i*i*i:1-e(-2*i+2,5)/2},easeInSine:function(i){return 1-c(i*t/2)},easeOutSine:function(i){return a(i*t/2)},easeInOutSine:function(i){return-(c(t*i)-1)/2},easeInExpo:function(i){return i===0?0:e(2,10*i-10)},easeOutExpo:function(i){return i===1?1:1-e(2,-10*i)},easeInOutExpo:function(i){return i===0?0:i===1?1:i<0.5?e(2,20*i-10)/2:(2-e(2,-20*i+10))/2},easeInCirc:function(i){return 1-n(1-e(i,2))},easeOutCirc:function(i){return n(1-e(i-1,2))},easeInOutCirc:function(i){return i<0.5?(1-n(1-e(2*i,2)))/2:(n(1-e(-2*i+2,2))+1)/2},easeInElastic:function(i){return i===0?0:i===1?1:-e(2,10*i-10)*a((i*10-10.75)*u)},easeOutElastic:function(i){return i===0?0:i===1?1:e(2,-10*i)*a((i*10-0.75)*u)+1},easeInOutElastic:function(i){return i===0?0:i===1?1:i<0.5?-(e(2,20*i-10)*a((20*i-11.125)*v))/2:e(2,-20*i+10)*a((20*i-11.125)*v)/2+1},easeInBack:function(i){return l*i*i*i-o*i*i},easeOutBack:function(i){return 1+l*e(i-1,3)+o*e(i-1,2)},easeInOutBack:function(i){return i<0.5?(e(2*i,2)*((s+1)*2*i-s))/2:(e(2*i-2,2)*((s+1)*(i*2-2)+s)+2)/2},easeInBounce:function(i){return 1-r(1-i)},easeOutBounce:r,easeInOutBounce:function(i){return i<0.5?(1-r(1-2*i))/2:(1+r(2*i-1))/2}})}(jQuery));(function(a){a.fn.avia_ajax_form=function(r){var t={sendPath:'send.php',responseContainer:'.ajaxresponse'};var e=a.extend(t,r);return this.each(function(){var t=a(this),i=!1,o=t.data('fields-with-error'),r={formElements:t.find('textarea, select, input[type=text], input[type=checkbox], input[type=hidden]'),validationError:!1,button:t.find('input:submit'),dataObj:{},withError:[]},s=t.next(e.responseContainer).eq(0);r.button.on('click',l);if(a.avia_utilities.isMobile){r.formElements.each(function(r){var e=a(this),t=e.hasClass('is_email');if(t)e.attr('type','email')})};function l(e){r.validationError=!1;r.datastring='ajax=true';r.formElements=t.find('textarea, select, input[type=text], input[type=checkbox], input[type=hidden], input[type=email]');r.formElements.each(function(n){var d=a(this),e=d.parent(),s=d.val(),l=e.find('label').text().replace(/\*/g,'').trim(),c=d.attr('name'),i=d.attr('class'),o=!0;if(d.is(':checkbox')){if(d.is(':checked')){s=!0}
else{s=''}};r.dataObj[c]=encodeURIComponent(s);if(i&&i.match(/is_empty/)){if(s==''||s==null){e.removeClass('valid error ajax_alert').addClass('error');r.validationError=!0;r.withError.push(l)}
else{e.removeClass('valid error ajax_alert').addClass('valid')};o=!1};if(i&&i.match(/is_email/)){if(!s.match(/^[\w|\.|\-]+@\w[\w|\.|\-]*\.[a-zA-Z]{2,20}$/)){e.removeClass('valid error ajax_alert').addClass('error');r.validationError=!0;r.withError.push(l)}
else{e.removeClass('valid error ajax_alert').addClass('valid')};o=!1};if(i&&i.match(/is_ext_email/)){if(!s.match(/^[\w\.\-ÄÖÜäöü]+@\w[\w\.\-ÄÖÜäöü]*\.[a-zA-Z]{2,20}$/)){e.removeClass('valid error ajax_alert').addClass('error');r.validationError=!0;r.withError.push(l)}
else{e.removeClass('valid error ajax_alert').addClass('valid')};o=!1};if(i&&i.match(/is_special_email/)){if(!s.match(/^[a-zA-Z0-9.!#$%&'*+\-\/=?^_`{|}~ÄÖÜäöü]+@\w[\w\.\-ÄÖÜäöü]*\.[a-zA-Z]{2,20}$/)){e.removeClass('valid error ajax_alert').addClass('error');r.validationError=!0;r.withError.push(l)}
else{e.removeClass('valid error ajax_alert').addClass('valid')};o=!1};if(i&&i.match(/is_phone/)){if(!s.match(/^(\d|\s|\-|\/|\(|\)|\[|\]|e|x|t|ension|\.|\+|\_|\,|\:|\;){3,}$/)){e.removeClass('valid error ajax_alert').addClass('error');r.validationError=!0;r.withError.push(l)}
else{e.removeClass('valid error ajax_alert').addClass('valid')};o=!1};if(i&&i.match(/is_number/)){if(!s.match(/^-?\s*(0|[1-9]\d*)([\.,]\d+)?$/)){e.removeClass('valid error ajax_alert').addClass('error');r.validationError=!0;r.withError.push(l)}
else{e.removeClass('valid error ajax_alert').addClass('valid')};o=!1};if(i&&i.match(/is_positiv_number/)){if(!(v(s))||s==''||s<0){e.removeClass('valid error ajax_alert').addClass('error');r.validationError=!0;r.withError.push(l)}
else{e.removeClass('valid error ajax_alert').addClass('valid')};o=!1};if(i&&i.match(/captcha/)&&!i.match(/recaptcha/)){var f=t.find('#'+c+'_verifier').val(),m=f.charAt(f.length-1),h=f.charAt(m);if(s!=h){e.removeClass('valid error ajax_alert').addClass('error');r.validationError=!0}
else{e.removeClass('valid error ajax_alert').addClass('valid')};o=!1};if(o&&s!=''){e.removeClass('valid error ajax_alert').addClass('valid')}});t.find('.av-fields-with-error').remove();if(r.validationError==!1){if(t.data('av-custom-send')){d()}
else{n()}}
else{if(t.is('.av-show-form-errors')&&r.withError.length>0){var i=r.withError.join(', '),s=a('<p class="av-fields-with-error"></p>').insertAfter(a(r.button).parent());let msg=o?o+' ':'Found errors in the following field(s): ';s.text(msg+i);r.withError=[]}};return!1};function n(){if(i){return!1};if(r.button.hasClass('avia_button_inactive')){return!1};i=!0;r.button.addClass('av-sending-button');r.button.val(r.button.data('sending-label'));var o=t.data('avia-redirect')||!1,l=t.attr('action'),n=t.is('.av-form-labels-style');if(n){return};s.load(l+' '+e.responseContainer,r.dataObj,function(){if(o&&l!=o){t.attr('action',o);location.href=o}
else{s.removeClass('hidden').css({display:'block'});t.slideUp(400,function(){s.slideDown(400,function(){a('body').trigger('av_resize_finished')});r.formElements.val('')})}})};function d(){if(i){return!1};i=!0;var v=r.button.val();r.button.addClass('av-sending-button');r.button.val(r.button.data('sending-label'));r.dataObj.ajax_mailchimp=!0;var o=t.data('avia-redirect')||!1,n=t.attr('action'),l=t.find('.av-form-error-container'),d=t.data('avia-form-id');a.ajax({url:n,type:'POST',data:r.dataObj,beforeSend:function(){if(l.length){l.slideUp(400,function(){l.remove();a('body').trigger('av_resize_finished')})}},success:function(l){var c=jQuery('<div>').append(jQuery.parseHTML(l)),f=c.find('.av-form-error-container');if(f.length){i=!1;t.prepend(f);f.css({display:'none'}).slideDown(400,function(){a('body').trigger('av_resize_finished')});r.button.removeClass('av-sending-button');r.button.val(v)}
else{if(o&&n!=o){t.attr('action',o);location.href=o}
else{var m=c.find(e.responseContainer+'_'+d);s.html(m).removeClass('hidden').css({display:'block'});t.slideUp(400,function(){s.slideDown(400,function(){a('body').trigger('av_resize_finished')});r.formElements.val('')})}}},error:function(){},complete:function(){}})};function v(a){var r=typeof a;return(r==='number'||r==='string')&&!isNaN(a-parseFloat(a))}})}})(jQuery);(function(e){'use strict';e.fn.avia_sc_gallery=function(a){return this.each(function(){var t=e(this),r=t.find('img'),a=t.find('.avia-gallery-big'),s=t.find('.avia-slideshow-arrows .prev-slide'),n=t.find('.avia-slideshow-arrows .next-slide'),i=t.find('.avia-gallery-thumb a'),o=t.hasClass('no-hover-effect');if(n.length){t.avia_swipe_trigger({prev:'.prev-slide',next:'.next-slide'})};t.on('avia_start_animation',function(){r.each(function(a){var t=e(this);setTimeout(function(){t.addClass('avia_start_animation')},(a*110))})});if(t.hasClass('deactivate_avia_lazyload')){t.trigger('avia_start_animation')};if(a.length){t.on('mouseenter','.avia-gallery-thumb a',function(){var i=e(this),c=i.attr('data-prev-img'),r=a.find('img'),l=r.attr('src');if(o){if(!t.hasClass('av-force-img-change')){return}};t.removeClass('av-force-img-change');if(c==l){return};a.height(a.height());a.attr('data-onclick',i.attr('data-onclick'));a.attr('href',i.attr('href'));a.attr('title',i.attr('title'));if('undefined'==typeof i.data('srcset')){a.removeAttr('data-srcset');a.removeData('srcset')}
else{a.data('srcset',i.data('srcset'));a.attr('data-srcset',i.data('srcset'))};if('undefined'==typeof i.data('sizes')){a.removeAttr('data-sizes');a.removeData('sizes')}
else{a.data('sizes',i.data('sizes'));a.attr('data-sizes',i.data('sizes'))};var n=i.find('.big-prev-fake img').clone(!0);if(n.length==0){var s=new Image();s.src=c;n=e(s)};if(a.hasClass('avia-gallery-big-no-crop-thumb')){n.css({'height':'auto','width':'auto','max-height':'100%','max-width':'100%'})};a.stop().animate({opacity:0},function(){n.insertAfter(r);r.remove();a.animate({opacity:1})})});n.on('click',function(n){n.preventDefault();if(!a.length){return};let current=a[0].dataset.onclick,next_index=current;if(next_index>=i.length){next_index=0};t.addClass('av-force-img-change');e(i[next_index]).trigger('mouseenter')});s.on('click',function(n){n.preventDefault();if(!a.length){return};let current=a[0].dataset.onclick,prev_index=current-2;if(prev_index<0){prev_index=i.length-1};t.addClass('av-force-img-change');e(i[prev_index]).trigger('mouseenter')});a.on('click',function(a){a.preventDefault();var e=t.find('.avia-gallery-thumb a').eq(this.getAttribute('data-onclick')-1);if(e&&!e.hasClass('aviaopeninbrowser')){e.trigger('click')}
else if(e){var i=e.attr('href'),n=e.hasClass('custom_link')?'noopener,noreferrer':'';if(e.hasClass('aviablank')&&i!=''){window.open(i,'_blank',n)}
else if(i!=''){window.open(i,'_self',n)}};return!1});e(window).on('debouncedresize',function(){a.height('auto')})}})}}(jQuery));(function(i){'use strict';i.fn.avia_sc_iconlist=function(n){return this.each(function(){var n=i(this),t=n.find('>li');n.on('avia_start_animation',function(){t.each(function(n){var t=i(this);setTimeout(function(){t.addClass('avia_start_animation')},(n*350))})})})}}(jQuery));/*!
 * Isotope PACKAGED v3.0.6
 *
 * Licensed GPLv3 for open source use
 * or Isotope Commercial License for commercial use
 *
 * https://isotope.metafizzy.co
 * Copyright 2010-2018 Metafizzy
 */

!function(t,e){"function"==typeof define&&define.amd?define("jquery-bridget/jquery-bridget",["jquery"],function(i){return e(t,i)}):"object"==typeof module&&module.exports?module.exports=e(t,require("jquery")):t.jQueryBridget=e(t,t.jQuery)}(window,function(t,e){"use strict";function i(i,s,a){function u(t,e,o){var n,s="$()."+i+'("'+e+'")';return t.each(function(t,u){var h=a.data(u,i);if(!h)return void r(i+" not initialized. Cannot call methods, i.e. "+s);var d=h[e];if(!d||"_"==e.charAt(0))return void r(s+" is not a valid method");var l=d.apply(h,o);n=void 0===n?l:n}),void 0!==n?n:t}function h(t,e){t.each(function(t,o){var n=a.data(o,i);n?(n.option(e),n._init()):(n=new s(o,e),a.data(o,i,n))})}a=a||e||t.jQuery,a&&(s.prototype.option||(s.prototype.option=function(t){a.isPlainObject(t)&&(this.options=a.extend(!0,this.options,t))}),a.fn[i]=function(t){if("string"==typeof t){var e=n.call(arguments,1);return u(this,t,e)}return h(this,t),this},o(a))}function o(t){!t||t&&t.bridget||(t.bridget=i)}var n=Array.prototype.slice,s=t.console,r="undefined"==typeof s?function(){}:function(t){s.error(t)};return o(e||t.jQuery),i}),function(t,e){"function"==typeof define&&define.amd?define("ev-emitter/ev-emitter",e):"object"==typeof module&&module.exports?module.exports=e():t.EvEmitter=e()}("undefined"!=typeof window?window:this,function(){function t(){}var e=t.prototype;return e.on=function(t,e){if(t&&e){var i=this._events=this._events||{},o=i[t]=i[t]||[];return o.indexOf(e)==-1&&o.push(e),this}},e.once=function(t,e){if(t&&e){this.on(t,e);var i=this._onceEvents=this._onceEvents||{},o=i[t]=i[t]||{};return o[e]=!0,this}},e.off=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var o=i.indexOf(e);return o!=-1&&i.splice(o,1),this}},e.emitEvent=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){i=i.slice(0),e=e||[];for(var o=this._onceEvents&&this._onceEvents[t],n=0;n<i.length;n++){var s=i[n],r=o&&o[s];r&&(this.off(t,s),delete o[s]),s.apply(this,e)}return this}},e.allOff=function(){delete this._events,delete this._onceEvents},t}),function(t,e){"function"==typeof define&&define.amd?define("get-size/get-size",e):"object"==typeof module&&module.exports?module.exports=e():t.getSize=e()}(window,function(){"use strict";function t(t){var e=parseFloat(t),i=t.indexOf("%")==-1&&!isNaN(e);return i&&e}function e(){}function i(){for(var t={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},e=0;e<h;e++){var i=u[e];t[i]=0}return t}function o(t){var e=getComputedStyle(t);return e||a("Style returned "+e+". Are you running this code in a hidden iframe on Firefox? See https://bit.ly/getsizebug1"),e}function n(){if(!d){d=!0;var e=document.createElement("div");e.style.width="200px",e.style.padding="1px 2px 3px 4px",e.style.borderStyle="solid",e.style.borderWidth="1px 2px 3px 4px",e.style.boxSizing="border-box";var i=document.body||document.documentElement;i.appendChild(e);var n=o(e);r=200==Math.round(t(n.width)),s.isBoxSizeOuter=r,i.removeChild(e)}}function s(e){if(n(),"string"==typeof e&&(e=document.querySelector(e)),e&&"object"==typeof e&&e.nodeType){var s=o(e);if("none"==s.display)return i();var a={};a.width=e.offsetWidth,a.height=e.offsetHeight;for(var d=a.isBorderBox="border-box"==s.boxSizing,l=0;l<h;l++){var f=u[l],c=s[f],m=parseFloat(c);a[f]=isNaN(m)?0:m}var p=a.paddingLeft+a.paddingRight,y=a.paddingTop+a.paddingBottom,g=a.marginLeft+a.marginRight,v=a.marginTop+a.marginBottom,_=a.borderLeftWidth+a.borderRightWidth,z=a.borderTopWidth+a.borderBottomWidth,I=d&&r,x=t(s.width);x!==!1&&(a.width=x+(I?0:p+_));var S=t(s.height);return S!==!1&&(a.height=S+(I?0:y+z)),a.innerWidth=a.width-(p+_),a.innerHeight=a.height-(y+z),a.outerWidth=a.width+g,a.outerHeight=a.height+v,a}}var r,a="undefined"==typeof console?e:function(t){console.error(t)},u=["paddingLeft","paddingRight","paddingTop","paddingBottom","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth"],h=u.length,d=!1;return s}),function(t,e){"use strict";"function"==typeof define&&define.amd?define("desandro-matches-selector/matches-selector",e):"object"==typeof module&&module.exports?module.exports=e():t.matchesSelector=e()}(window,function(){"use strict";var t=function(){var t=window.Element.prototype;if(t.matches)return"matches";if(t.matchesSelector)return"matchesSelector";for(var e=["webkit","moz","ms","o"],i=0;i<e.length;i++){var o=e[i],n=o+"MatchesSelector";if(t[n])return n}}();return function(e,i){return e[t](i)}}),function(t,e){"function"==typeof define&&define.amd?define("fizzy-ui-utils/utils",["desandro-matches-selector/matches-selector"],function(i){return e(t,i)}):"object"==typeof module&&module.exports?module.exports=e(t,require("desandro-matches-selector")):t.fizzyUIUtils=e(t,t.matchesSelector)}(window,function(t,e){var i={};i.extend=function(t,e){for(var i in e)t[i]=e[i];return t},i.modulo=function(t,e){return(t%e+e)%e};var o=Array.prototype.slice;i.makeArray=function(t){if(Array.isArray(t))return t;if(null===t||void 0===t)return[];var e="object"==typeof t&&"number"==typeof t.length;return e?o.call(t):[t]},i.removeFrom=function(t,e){var i=t.indexOf(e);i!=-1&&t.splice(i,1)},i.getParent=function(t,i){for(;t.parentNode&&t!=document.body;)if(t=t.parentNode,e(t,i))return t},i.getQueryElement=function(t){return"string"==typeof t?document.querySelector(t):t},i.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},i.filterFindElements=function(t,o){t=i.makeArray(t);var n=[];return t.forEach(function(t){if(t instanceof HTMLElement){if(!o)return void n.push(t);e(t,o)&&n.push(t);for(var i=t.querySelectorAll(o),s=0;s<i.length;s++)n.push(i[s])}}),n},i.debounceMethod=function(t,e,i){i=i||100;var o=t.prototype[e],n=e+"Timeout";t.prototype[e]=function(){var t=this[n];clearTimeout(t);var e=arguments,s=this;this[n]=setTimeout(function(){o.apply(s,e),delete s[n]},i)}},i.docReady=function(t){var e=document.readyState;"complete"==e||"interactive"==e?setTimeout(t):document.addEventListener("DOMContentLoaded",t)},i.toDashed=function(t){return t.replace(/(.)([A-Z])/g,function(t,e,i){return e+"-"+i}).toLowerCase()};var n=t.console;return i.htmlInit=function(e,o){i.docReady(function(){var s=i.toDashed(o),r="data-"+s,a=document.querySelectorAll("["+r+"]"),u=document.querySelectorAll(".js-"+s),h=i.makeArray(a).concat(i.makeArray(u)),d=r+"-options",l=t.jQuery;h.forEach(function(t){var i,s=t.getAttribute(r)||t.getAttribute(d);try{i=s&&JSON.parse(s)}catch(a){return void(n&&n.error("Error parsing "+r+" on "+t.className+": "+a))}var u=new e(t,i);l&&l.data(t,o,u)})})},i}),function(t,e){"function"==typeof define&&define.amd?define("outlayer/item",["ev-emitter/ev-emitter","get-size/get-size"],e):"object"==typeof module&&module.exports?module.exports=e(require("ev-emitter"),require("get-size")):(t.Outlayer={},t.Outlayer.Item=e(t.EvEmitter,t.getSize))}(window,function(t,e){"use strict";function i(t){for(var e in t)return!1;return e=null,!0}function o(t,e){t&&(this.element=t,this.layout=e,this.position={x:0,y:0},this._create())}function n(t){return t.replace(/([A-Z])/g,function(t){return"-"+t.toLowerCase()})}var s=document.documentElement.style,r="string"==typeof s.transition?"transition":"WebkitTransition",a="string"==typeof s.transform?"transform":"WebkitTransform",u={WebkitTransition:"webkitTransitionEnd",transition:"transitionend"}[r],h={transform:a,transition:r,transitionDuration:r+"Duration",transitionProperty:r+"Property",transitionDelay:r+"Delay"},d=o.prototype=Object.create(t.prototype);d.constructor=o,d._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:"absolute"})},d.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},d.getSize=function(){this.size=e(this.element)},d.css=function(t){var e=this.element.style;for(var i in t){var o=h[i]||i;e[o]=t[i]}},d.getPosition=function(){var t=getComputedStyle(this.element),e=this.layout._getOption("originLeft"),i=this.layout._getOption("originTop"),o=t[e?"left":"right"],n=t[i?"top":"bottom"],s=parseFloat(o),r=parseFloat(n),a=this.layout.size;o.indexOf("%")!=-1&&(s=s/100*a.width),n.indexOf("%")!=-1&&(r=r/100*a.height),s=isNaN(s)?0:s,r=isNaN(r)?0:r,s-=e?a.paddingLeft:a.paddingRight,r-=i?a.paddingTop:a.paddingBottom,this.position.x=s,this.position.y=r},d.layoutPosition=function(){var t=this.layout.size,e={},i=this.layout._getOption("originLeft"),o=this.layout._getOption("originTop"),n=i?"paddingLeft":"paddingRight",s=i?"left":"right",r=i?"right":"left",a=this.position.x+t[n];e[s]=this.getXValue(a),e[r]="";var u=o?"paddingTop":"paddingBottom",h=o?"top":"bottom",d=o?"bottom":"top",l=this.position.y+t[u];e[h]=this.getYValue(l),e[d]="",this.css(e),this.emitEvent("layout",[this])},d.getXValue=function(t){var e=this.layout._getOption("horizontal");return this.layout.options.percentPosition&&!e?t/this.layout.size.width*100+"%":t+"px"},d.getYValue=function(t){var e=this.layout._getOption("horizontal");return this.layout.options.percentPosition&&e?t/this.layout.size.height*100+"%":t+"px"},d._transitionTo=function(t,e){this.getPosition();var i=this.position.x,o=this.position.y,n=t==this.position.x&&e==this.position.y;if(this.setPosition(t,e),n&&!this.isTransitioning)return void this.layoutPosition();var s=t-i,r=e-o,a={};a.transform=this.getTranslate(s,r),this.transition({to:a,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0})},d.getTranslate=function(t,e){var i=this.layout._getOption("originLeft"),o=this.layout._getOption("originTop");return t=i?t:-t,e=o?e:-e,"translate3d("+t+"px, "+e+"px, 0)"},d.goTo=function(t,e){this.setPosition(t,e),this.layoutPosition()},d.moveTo=d._transitionTo,d.setPosition=function(t,e){this.position.x=parseFloat(t),this.position.y=parseFloat(e)},d._nonTransition=function(t){this.css(t.to),t.isCleaning&&this._removeStyles(t.to);for(var e in t.onTransitionEnd)t.onTransitionEnd[e].call(this)},d.transition=function(t){if(!parseFloat(this.layout.options.transitionDuration))return void this._nonTransition(t);var e=this._transn;for(var i in t.onTransitionEnd)e.onEnd[i]=t.onTransitionEnd[i];for(i in t.to)e.ingProperties[i]=!0,t.isCleaning&&(e.clean[i]=!0);if(t.from){this.css(t.from);var o=this.element.offsetHeight;o=null}this.enableTransition(t.to),this.css(t.to),this.isTransitioning=!0};var l="opacity,"+n(a);d.enableTransition=function(){if(!this.isTransitioning){var t=this.layout.options.transitionDuration;t="number"==typeof t?t+"ms":t,this.css({transitionProperty:l,transitionDuration:t,transitionDelay:this.staggerDelay||0}),this.element.addEventListener(u,this,!1)}},d.onwebkitTransitionEnd=function(t){this.ontransitionend(t)},d.onotransitionend=function(t){this.ontransitionend(t)};var f={"-webkit-transform":"transform"};d.ontransitionend=function(t){if(t.target===this.element){var e=this._transn,o=f[t.propertyName]||t.propertyName;if(delete e.ingProperties[o],i(e.ingProperties)&&this.disableTransition(),o in e.clean&&(this.element.style[t.propertyName]="",delete e.clean[o]),o in e.onEnd){var n=e.onEnd[o];n.call(this),delete e.onEnd[o]}this.emitEvent("transitionEnd",[this])}},d.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(u,this,!1),this.isTransitioning=!1},d._removeStyles=function(t){var e={};for(var i in t)e[i]="";this.css(e)};var c={transitionProperty:"",transitionDuration:"",transitionDelay:""};return d.removeTransitionStyles=function(){this.css(c)},d.stagger=function(t){t=isNaN(t)?0:t,this.staggerDelay=t+"ms"},d.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:""}),this.emitEvent("remove",[this])},d.remove=function(){return r&&parseFloat(this.layout.options.transitionDuration)?(this.once("transitionEnd",function(){this.removeElem()}),void this.hide()):void this.removeElem()},d.reveal=function(){delete this.isHidden,this.css({display:""});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty("visibleStyle");e[i]=this.onRevealTransitionEnd,this.transition({from:t.hiddenStyle,to:t.visibleStyle,isCleaning:!0,onTransitionEnd:e})},d.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent("reveal")},d.getHideRevealTransitionEndProperty=function(t){var e=this.layout.options[t];if(e.opacity)return"opacity";for(var i in e)return i},d.hide=function(){this.isHidden=!0,this.css({display:""});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty("hiddenStyle");e[i]=this.onHideTransitionEnd,this.transition({from:t.visibleStyle,to:t.hiddenStyle,isCleaning:!0,onTransitionEnd:e})},d.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:"none"}),this.emitEvent("hide"))},d.destroy=function(){this.css({position:"",left:"",right:"",top:"",bottom:"",transition:"",transform:""})},o}),function(t,e){"use strict";"function"==typeof define&&define.amd?define("outlayer/outlayer",["ev-emitter/ev-emitter","get-size/get-size","fizzy-ui-utils/utils","./item"],function(i,o,n,s){return e(t,i,o,n,s)}):"object"==typeof module&&module.exports?module.exports=e(t,require("ev-emitter"),require("get-size"),require("fizzy-ui-utils"),require("./item")):t.Outlayer=e(t,t.EvEmitter,t.getSize,t.fizzyUIUtils,t.Outlayer.Item)}(window,function(t,e,i,o,n){"use strict";function s(t,e){var i=o.getQueryElement(t);if(!i)return void(u&&u.error("Bad element for "+this.constructor.namespace+": "+(i||t)));this.element=i,h&&(this.$element=h(this.element)),this.options=o.extend({},this.constructor.defaults),this.option(e);var n=++l;this.element.outlayerGUID=n,f[n]=this,this._create();var s=this._getOption("initLayout");s&&this.layout()}function r(t){function e(){t.apply(this,arguments)}return e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e}function a(t){if("number"==typeof t)return t;var e=t.match(/(^\d*\.?\d*)(\w*)/),i=e&&e[1],o=e&&e[2];if(!i.length)return 0;i=parseFloat(i);var n=m[o]||1;return i*n}var u=t.console,h=t.jQuery,d=function(){},l=0,f={};s.namespace="outlayer",s.Item=n,s.defaults={containerStyle:{position:"relative"},initLayout:!0,originLeft:!0,originTop:!0,resize:!0,resizeContainer:!0,transitionDuration:"0.4s",hiddenStyle:{opacity:0,transform:"scale(0.001)"},visibleStyle:{opacity:1,transform:"scale(1)"}};var c=s.prototype;o.extend(c,e.prototype),c.option=function(t){o.extend(this.options,t)},c._getOption=function(t){var e=this.constructor.compatOptions[t];return e&&void 0!==this.options[e]?this.options[e]:this.options[t]},s.compatOptions={initLayout:"isInitLayout",horizontal:"isHorizontal",layoutInstant:"isLayoutInstant",originLeft:"isOriginLeft",originTop:"isOriginTop",resize:"isResizeBound",resizeContainer:"isResizingContainer"},c._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),o.extend(this.element.style,this.options.containerStyle);var t=this._getOption("resize");t&&this.bindResize()},c.reloadItems=function(){this.items=this._itemize(this.element.children)},c._itemize=function(t){for(var e=this._filterFindItemElements(t),i=this.constructor.Item,o=[],n=0;n<e.length;n++){var s=e[n],r=new i(s,this);o.push(r)}return o},c._filterFindItemElements=function(t){return o.filterFindElements(t,this.options.itemSelector)},c.getItemElements=function(){return this.items.map(function(t){return t.element})},c.layout=function(){this._resetLayout(),this._manageStamps();var t=this._getOption("layoutInstant"),e=void 0!==t?t:!this._isLayoutInited;this.layoutItems(this.items,e),this._isLayoutInited=!0},c._init=c.layout,c._resetLayout=function(){this.getSize()},c.getSize=function(){this.size=i(this.element)},c._getMeasurement=function(t,e){var o,n=this.options[t];n?("string"==typeof n?o=this.element.querySelector(n):n instanceof HTMLElement&&(o=n),this[t]=o?i(o)[e]:n):this[t]=0},c.layoutItems=function(t,e){t=this._getItemsForLayout(t),this._layoutItems(t,e),this._postLayout()},c._getItemsForLayout=function(t){return t.filter(function(t){return!t.isIgnored})},c._layoutItems=function(t,e){if(this._emitCompleteOnItems("layout",t),t&&t.length){var i=[];t.forEach(function(t){var o=this._getItemLayoutPosition(t);o.item=t,o.isInstant=e||t.isLayoutInstant,i.push(o)},this),this._processLayoutQueue(i)}},c._getItemLayoutPosition=function(){return{x:0,y:0}},c._processLayoutQueue=function(t){this.updateStagger(),t.forEach(function(t,e){this._positionItem(t.item,t.x,t.y,t.isInstant,e)},this)},c.updateStagger=function(){var t=this.options.stagger;return null===t||void 0===t?void(this.stagger=0):(this.stagger=a(t),this.stagger)},c._positionItem=function(t,e,i,o,n){o?t.goTo(e,i):(t.stagger(n*this.stagger),t.moveTo(e,i))},c._postLayout=function(){this.resizeContainer()},c.resizeContainer=function(){var t=this._getOption("resizeContainer");if(t){var e=this._getContainerSize();e&&(this._setContainerMeasure(e.width,!0),this._setContainerMeasure(e.height,!1))}},c._getContainerSize=d,c._setContainerMeasure=function(t,e){if(void 0!==t){var i=this.size;i.isBorderBox&&(t+=e?i.paddingLeft+i.paddingRight+i.borderLeftWidth+i.borderRightWidth:i.paddingBottom+i.paddingTop+i.borderTopWidth+i.borderBottomWidth),t=Math.max(t,0),this.element.style[e?"width":"height"]=t+"px"}},c._emitCompleteOnItems=function(t,e){function i(){n.dispatchEvent(t+"Complete",null,[e])}function o(){r++,r==s&&i()}var n=this,s=e.length;if(!e||!s)return void i();var r=0;e.forEach(function(e){e.once(t,o)})},c.dispatchEvent=function(t,e,i){var o=e?[e].concat(i):i;if(this.emitEvent(t,o),h)if(this.$element=this.$element||h(this.element),e){var n=h.Event(e);n.type=t,this.$element.trigger(n,i)}else this.$element.trigger(t,i)},c.ignore=function(t){var e=this.getItem(t);e&&(e.isIgnored=!0)},c.unignore=function(t){var e=this.getItem(t);e&&delete e.isIgnored},c.stamp=function(t){t=this._find(t),t&&(this.stamps=this.stamps.concat(t),t.forEach(this.ignore,this))},c.unstamp=function(t){t=this._find(t),t&&t.forEach(function(t){o.removeFrom(this.stamps,t),this.unignore(t)},this)},c._find=function(t){if(t)return"string"==typeof t&&(t=this.element.querySelectorAll(t)),t=o.makeArray(t)},c._manageStamps=function(){this.stamps&&this.stamps.length&&(this._getBoundingRect(),this.stamps.forEach(this._manageStamp,this))},c._getBoundingRect=function(){var t=this.element.getBoundingClientRect(),e=this.size;this._boundingRect={left:t.left+e.paddingLeft+e.borderLeftWidth,top:t.top+e.paddingTop+e.borderTopWidth,right:t.right-(e.paddingRight+e.borderRightWidth),bottom:t.bottom-(e.paddingBottom+e.borderBottomWidth)}},c._manageStamp=d,c._getElementOffset=function(t){var e=t.getBoundingClientRect(),o=this._boundingRect,n=i(t),s={left:e.left-o.left-n.marginLeft,top:e.top-o.top-n.marginTop,right:o.right-e.right-n.marginRight,bottom:o.bottom-e.bottom-n.marginBottom};return s},c.handleEvent=o.handleEvent,c.bindResize=function(){t.addEventListener("resize",this),this.isResizeBound=!0},c.unbindResize=function(){t.removeEventListener("resize",this),this.isResizeBound=!1},c.onresize=function(){this.resize()},o.debounceMethod(s,"onresize",100),c.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout()},c.needsResizeLayout=function(){var t=i(this.element),e=this.size&&t;return e&&t.innerWidth!==this.size.innerWidth},c.addItems=function(t){var e=this._itemize(t);return e.length&&(this.items=this.items.concat(e)),e},c.appended=function(t){var e=this.addItems(t);e.length&&(this.layoutItems(e,!0),this.reveal(e))},c.prepended=function(t){var e=this._itemize(t);if(e.length){var i=this.items.slice(0);this.items=e.concat(i),this._resetLayout(),this._manageStamps(),this.layoutItems(e,!0),this.reveal(e),this.layoutItems(i)}},c.reveal=function(t){if(this._emitCompleteOnItems("reveal",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.reveal()})}},c.hide=function(t){if(this._emitCompleteOnItems("hide",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.hide()})}},c.revealItemElements=function(t){var e=this.getItems(t);this.reveal(e)},c.hideItemElements=function(t){var e=this.getItems(t);this.hide(e)},c.getItem=function(t){for(var e=0;e<this.items.length;e++){var i=this.items[e];if(i.element==t)return i}},c.getItems=function(t){t=o.makeArray(t);var e=[];return t.forEach(function(t){var i=this.getItem(t);i&&e.push(i)},this),e},c.remove=function(t){var e=this.getItems(t);this._emitCompleteOnItems("remove",e),e&&e.length&&e.forEach(function(t){t.remove(),o.removeFrom(this.items,t)},this)},c.destroy=function(){var t=this.element.style;t.height="",t.position="",t.width="",this.items.forEach(function(t){t.destroy()}),this.unbindResize();var e=this.element.outlayerGUID;delete f[e],delete this.element.outlayerGUID,h&&h.removeData(this.element,this.constructor.namespace)},s.data=function(t){t=o.getQueryElement(t);var e=t&&t.outlayerGUID;return e&&f[e]},s.create=function(t,e){var i=r(s);return i.defaults=o.extend({},s.defaults),o.extend(i.defaults,e),i.compatOptions=o.extend({},s.compatOptions),i.namespace=t,i.data=s.data,i.Item=r(n),o.htmlInit(i,t),h&&h.bridget&&h.bridget(t,i),i};var m={ms:1,s:1e3};return s.Item=n,s}),function(t,e){"function"==typeof define&&define.amd?define("isotope-layout/js/item",["outlayer/outlayer"],e):"object"==typeof module&&module.exports?module.exports=e(require("outlayer")):(t.Isotope=t.Isotope||{},t.Isotope.Item=e(t.Outlayer))}(window,function(t){"use strict";function e(){t.Item.apply(this,arguments)}var i=e.prototype=Object.create(t.Item.prototype),o=i._create;i._create=function(){this.id=this.layout.itemGUID++,o.call(this),this.sortData={}},i.updateSortData=function(){if(!this.isIgnored){this.sortData.id=this.id,this.sortData["original-order"]=this.id,this.sortData.random=Math.random();var t=this.layout.options.getSortData,e=this.layout._sorters;for(var i in t){var o=e[i];this.sortData[i]=o(this.element,this)}}};var n=i.destroy;return i.destroy=function(){n.apply(this,arguments),this.css({display:""})},e}),function(t,e){"function"==typeof define&&define.amd?define("isotope-layout/js/layout-mode",["get-size/get-size","outlayer/outlayer"],e):"object"==typeof module&&module.exports?module.exports=e(require("get-size"),require("outlayer")):(t.Isotope=t.Isotope||{},t.Isotope.LayoutMode=e(t.getSize,t.Outlayer))}(window,function(t,e){"use strict";function i(t){this.isotope=t,t&&(this.options=t.options[this.namespace],this.element=t.element,this.items=t.filteredItems,this.size=t.size)}var o=i.prototype,n=["_resetLayout","_getItemLayoutPosition","_manageStamp","_getContainerSize","_getElementOffset","needsResizeLayout","_getOption"];return n.forEach(function(t){o[t]=function(){return e.prototype[t].apply(this.isotope,arguments)}}),o.needsVerticalResizeLayout=function(){var e=t(this.isotope.element),i=this.isotope.size&&e;return i&&e.innerHeight!=this.isotope.size.innerHeight},o._getMeasurement=function(){this.isotope._getMeasurement.apply(this,arguments)},o.getColumnWidth=function(){this.getSegmentSize("column","Width")},o.getRowHeight=function(){this.getSegmentSize("row","Height")},o.getSegmentSize=function(t,e){var i=t+e,o="outer"+e;if(this._getMeasurement(i,o),!this[i]){var n=this.getFirstItemSize();this[i]=n&&n[o]||this.isotope.size["inner"+e]}},o.getFirstItemSize=function(){var e=this.isotope.filteredItems[0];return e&&e.element&&t(e.element)},o.layout=function(){this.isotope.layout.apply(this.isotope,arguments)},o.getSize=function(){this.isotope.getSize(),this.size=this.isotope.size},i.modes={},i.create=function(t,e){function n(){i.apply(this,arguments)}return n.prototype=Object.create(o),n.prototype.constructor=n,e&&(n.options=e),n.prototype.namespace=t,i.modes[t]=n,n},i}),function(t,e){"function"==typeof define&&define.amd?define("masonry-layout/masonry",["outlayer/outlayer","get-size/get-size"],e):"object"==typeof module&&module.exports?module.exports=e(require("outlayer"),require("get-size")):t.Masonry=e(t.Outlayer,t.getSize)}(window,function(t,e){var i=t.create("masonry");i.compatOptions.fitWidth="isFitWidth";var o=i.prototype;return o._resetLayout=function(){this.getSize(),this._getMeasurement("columnWidth","outerWidth"),this._getMeasurement("gutter","outerWidth"),this.measureColumns(),this.colYs=[];for(var t=0;t<this.cols;t++)this.colYs.push(0);this.maxY=0,this.horizontalColIndex=0},o.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var t=this.items[0],i=t&&t.element;this.columnWidth=i&&e(i).outerWidth||this.containerWidth}var o=this.columnWidth+=this.gutter,n=this.containerWidth+this.gutter,s=n/o,r=o-n%o,a=r&&r<1?"round":"floor";s=Math[a](s),this.cols=Math.max(s,1)},o.getContainerWidth=function(){var t=this._getOption("fitWidth"),i=t?this.element.parentNode:this.element,o=e(i);this.containerWidth=o&&o.innerWidth},o._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth%this.columnWidth,i=e&&e<1?"round":"ceil",o=Math[i](t.size.outerWidth/this.columnWidth);o=Math.min(o,this.cols);for(var n=this.options.horizontalOrder?"_getHorizontalColPosition":"_getTopColPosition",s=this[n](o,t),r={x:this.columnWidth*s.col,y:s.y},a=s.y+t.size.outerHeight,u=o+s.col,h=s.col;h<u;h++)this.colYs[h]=a;return r},o._getTopColPosition=function(t){var e=this._getTopColGroup(t),i=Math.min.apply(Math,e);return{col:e.indexOf(i),y:i}},o._getTopColGroup=function(t){if(t<2)return this.colYs;for(var e=[],i=this.cols+1-t,o=0;o<i;o++)e[o]=this._getColGroupY(o,t);return e},o._getColGroupY=function(t,e){if(e<2)return this.colYs[t];var i=this.colYs.slice(t,t+e);return Math.max.apply(Math,i)},o._getHorizontalColPosition=function(t,e){var i=this.horizontalColIndex%this.cols,o=t>1&&i+t>this.cols;i=o?0:i;var n=e.size.outerWidth&&e.size.outerHeight;return this.horizontalColIndex=n?i+t:this.horizontalColIndex,{col:i,y:this._getColGroupY(i,t)}},o._manageStamp=function(t){var i=e(t),o=this._getElementOffset(t),n=this._getOption("originLeft"),s=n?o.left:o.right,r=s+i.outerWidth,a=Math.floor(s/this.columnWidth);a=Math.max(0,a);var u=Math.floor(r/this.columnWidth);u-=r%this.columnWidth?0:1,u=Math.min(this.cols-1,u);for(var h=this._getOption("originTop"),d=(h?o.top:o.bottom)+i.outerHeight,l=a;l<=u;l++)this.colYs[l]=Math.max(d,this.colYs[l])},o._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var t={height:this.maxY};return this._getOption("fitWidth")&&(t.width=this._getContainerFitWidth()),t},o._getContainerFitWidth=function(){for(var t=0,e=this.cols;--e&&0===this.colYs[e];)t++;return(this.cols-t)*this.columnWidth-this.gutter},o.needsResizeLayout=function(){var t=this.containerWidth;return this.getContainerWidth(),t!=this.containerWidth},i}),function(t,e){"function"==typeof define&&define.amd?define("isotope-layout/js/layout-modes/masonry",["../layout-mode","masonry-layout/masonry"],e):"object"==typeof module&&module.exports?module.exports=e(require("../layout-mode"),require("masonry-layout")):e(t.Isotope.LayoutMode,t.Masonry)}(window,function(t,e){"use strict";var i=t.create("masonry"),o=i.prototype,n={_getElementOffset:!0,layout:!0,_getMeasurement:!0};for(var s in e.prototype)n[s]||(o[s]=e.prototype[s]);var r=o.measureColumns;o.measureColumns=function(){this.items=this.isotope.filteredItems,r.call(this)};var a=o._getOption;return o._getOption=function(t){return"fitWidth"==t?void 0!==this.options.isFitWidth?this.options.isFitWidth:this.options.fitWidth:a.apply(this.isotope,arguments)},i}),function(t,e){"function"==typeof define&&define.amd?define("isotope-layout/js/layout-modes/fit-rows",["../layout-mode"],e):"object"==typeof exports?module.exports=e(require("../layout-mode")):e(t.Isotope.LayoutMode)}(window,function(t){"use strict";var e=t.create("fitRows"),i=e.prototype;return i._resetLayout=function(){this.x=0,this.y=0,this.maxY=0,this._getMeasurement("gutter","outerWidth")},i._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth+this.gutter,i=this.isotope.size.innerWidth+this.gutter;0!==this.x&&e+this.x>i&&(this.x=0,this.y=this.maxY);var o={x:this.x,y:this.y};return this.maxY=Math.max(this.maxY,this.y+t.size.outerHeight),this.x+=e,o},i._getContainerSize=function(){return{height:this.maxY}},e}),function(t,e){"function"==typeof define&&define.amd?define("isotope-layout/js/layout-modes/vertical",["../layout-mode"],e):"object"==typeof module&&module.exports?module.exports=e(require("../layout-mode")):e(t.Isotope.LayoutMode)}(window,function(t){"use strict";var e=t.create("vertical",{horizontalAlignment:0}),i=e.prototype;return i._resetLayout=function(){this.y=0},i._getItemLayoutPosition=function(t){t.getSize();var e=(this.isotope.size.innerWidth-t.size.outerWidth)*this.options.horizontalAlignment,i=this.y;return this.y+=t.size.outerHeight,{x:e,y:i}},i._getContainerSize=function(){return{height:this.y}},e}),function(t,e){"function"==typeof define&&define.amd?define(["outlayer/outlayer","get-size/get-size","desandro-matches-selector/matches-selector","fizzy-ui-utils/utils","isotope-layout/js/item","isotope-layout/js/layout-mode","isotope-layout/js/layout-modes/masonry","isotope-layout/js/layout-modes/fit-rows","isotope-layout/js/layout-modes/vertical"],function(i,o,n,s,r,a){return e(t,i,o,n,s,r,a)}):"object"==typeof module&&module.exports?module.exports=e(t,require("outlayer"),require("get-size"),require("desandro-matches-selector"),require("fizzy-ui-utils"),require("isotope-layout/js/item"),require("isotope-layout/js/layout-mode"),require("isotope-layout/js/layout-modes/masonry"),require("isotope-layout/js/layout-modes/fit-rows"),require("isotope-layout/js/layout-modes/vertical")):t.Isotope=e(t,t.Outlayer,t.getSize,t.matchesSelector,t.fizzyUIUtils,t.Isotope.Item,t.Isotope.LayoutMode)}(window,function(t,e,i,o,n,s,r){function a(t,e){return function(i,o){for(var n=0;n<t.length;n++){var s=t[n],r=i.sortData[s],a=o.sortData[s];if(r>a||r<a){var u=void 0!==e[s]?e[s]:e,h=u?1:-1;return(r>a?1:-1)*h}}return 0}}var u=t.jQuery,h=String.prototype.trim?function(t){return t.trim()}:function(t){return t.replace(/^\s+|\s+$/g,"")},d=e.create("isotope",{layoutMode:"masonry",isJQueryFiltering:!0,sortAscending:!0});d.Item=s,d.LayoutMode=r;var l=d.prototype;l._create=function(){this.itemGUID=0,this._sorters={},this._getSorters(),e.prototype._create.call(this),this.modes={},this.filteredItems=this.items,this.sortHistory=["original-order"];for(var t in r.modes)this._initLayoutMode(t)},l.reloadItems=function(){this.itemGUID=0,e.prototype.reloadItems.call(this)},l._itemize=function(){for(var t=e.prototype._itemize.apply(this,arguments),i=0;i<t.length;i++){var o=t[i];o.id=this.itemGUID++}return this._updateItemsSortData(t),t},l._initLayoutMode=function(t){var e=r.modes[t],i=this.options[t]||{};this.options[t]=e.options?n.extend(e.options,i):i,this.modes[t]=new e(this)},l.layout=function(){return!this._isLayoutInited&&this._getOption("initLayout")?void this.arrange():void this._layout()},l._layout=function(){var t=this._getIsInstant();this._resetLayout(),this._manageStamps(),this.layoutItems(this.filteredItems,t),this._isLayoutInited=!0},l.arrange=function(t){this.option(t),this._getIsInstant();var e=this._filter(this.items);this.filteredItems=e.matches,this._bindArrangeComplete(),this._isInstant?this._noTransition(this._hideReveal,[e]):this._hideReveal(e),this._sort(),this._layout()},l._init=l.arrange,l._hideReveal=function(t){this.reveal(t.needReveal),this.hide(t.needHide)},l._getIsInstant=function(){var t=this._getOption("layoutInstant"),e=void 0!==t?t:!this._isLayoutInited;return this._isInstant=e,e},l._bindArrangeComplete=function(){function t(){e&&i&&o&&n.dispatchEvent("arrangeComplete",null,[n.filteredItems])}var e,i,o,n=this;this.once("layoutComplete",function(){e=!0,t()}),this.once("hideComplete",function(){i=!0,t()}),this.once("revealComplete",function(){o=!0,t()})},l._filter=function(t){var e=this.options.filter;e=e||"*";for(var i=[],o=[],n=[],s=this._getFilterTest(e),r=0;r<t.length;r++){var a=t[r];if(!a.isIgnored){var u=s(a);u&&i.push(a),u&&a.isHidden?o.push(a):u||a.isHidden||n.push(a)}}return{matches:i,needReveal:o,needHide:n}},l._getFilterTest=function(t){return u&&this.options.isJQueryFiltering?function(e){return u(e.element).is(t);
}:"function"==typeof t?function(e){return t(e.element)}:function(e){return o(e.element,t)}},l.updateSortData=function(t){var e;t?(t=n.makeArray(t),e=this.getItems(t)):e=this.items,this._getSorters(),this._updateItemsSortData(e)},l._getSorters=function(){var t=this.options.getSortData;for(var e in t){var i=t[e];this._sorters[e]=f(i)}},l._updateItemsSortData=function(t){for(var e=t&&t.length,i=0;e&&i<e;i++){var o=t[i];o.updateSortData()}};var f=function(){function t(t){if("string"!=typeof t)return t;var i=h(t).split(" "),o=i[0],n=o.match(/^\[(.+)\]$/),s=n&&n[1],r=e(s,o),a=d.sortDataParsers[i[1]];return t=a?function(t){return t&&a(r(t))}:function(t){return t&&r(t)}}function e(t,e){return t?function(e){return e.getAttribute(t)}:function(t){var i=t.querySelector(e);return i&&i.textContent}}return t}();d.sortDataParsers={parseInt:function(t){return parseInt(t,10)},parseFloat:function(t){return parseFloat(t)}},l._sort=function(){if(this.options.sortBy){var t=n.makeArray(this.options.sortBy);this._getIsSameSortBy(t)||(this.sortHistory=t.concat(this.sortHistory));var e=a(this.sortHistory,this.options.sortAscending);this.filteredItems.sort(e)}},l._getIsSameSortBy=function(t){for(var e=0;e<t.length;e++)if(t[e]!=this.sortHistory[e])return!1;return!0},l._mode=function(){var t=this.options.layoutMode,e=this.modes[t];if(!e)throw new Error("No layout mode: "+t);return e.options=this.options[t],e},l._resetLayout=function(){e.prototype._resetLayout.call(this),this._mode()._resetLayout()},l._getItemLayoutPosition=function(t){return this._mode()._getItemLayoutPosition(t)},l._manageStamp=function(t){this._mode()._manageStamp(t)},l._getContainerSize=function(){return this._mode()._getContainerSize()},l.needsResizeLayout=function(){return this._mode().needsResizeLayout()},l.appended=function(t){var e=this.addItems(t);if(e.length){var i=this._filterRevealAdded(e);this.filteredItems=this.filteredItems.concat(i)}},l.prepended=function(t){var e=this._itemize(t);if(e.length){this._resetLayout(),this._manageStamps();var i=this._filterRevealAdded(e);this.layoutItems(this.filteredItems),this.filteredItems=i.concat(this.filteredItems),this.items=e.concat(this.items)}},l._filterRevealAdded=function(t){var e=this._filter(t);return this.hide(e.needHide),this.reveal(e.matches),this.layoutItems(e.matches,!0),e.matches},l.insert=function(t){var e=this.addItems(t);if(e.length){var i,o,n=e.length;for(i=0;i<n;i++)o=e[i],this.element.appendChild(o.element);var s=this._filter(e).matches;for(i=0;i<n;i++)e[i].isLayoutInstant=!0;for(this.arrange(),i=0;i<n;i++)delete e[i].isLayoutInstant;this.reveal(s)}};var c=l.remove;return l.remove=function(t){t=n.makeArray(t);var e=this.getItems(t);c.call(this,t);for(var i=e&&e.length,o=0;i&&o<i;o++){var s=e[o];n.removeFrom(this.filteredItems,s)}},l.shuffle=function(){for(var t=0;t<this.items.length;t++){var e=this.items[t];e.sortData.random=Math.random()}this.options.sortBy="random",this._sort(),this._layout()},l._noTransition=function(t,e){var i=this.options.transitionDuration;this.options.transitionDuration=0;var o=t.apply(this,e);return this.options.transitionDuration=i,o},l.getFilteredItemElements=function(){return this.filteredItems.map(function(t){return t.element})},d});
    
    
/*!
 * Packery layout mode PACKAGED v2.0.1
 * sub-classes Packery
 */

!function(a,b){"function"==typeof define&&define.amd?define("packery/js/rect",b):"object"==typeof module&&module.exports?module.exports=b():(a.Packery=a.Packery||{},a.Packery.Rect=b())}(window,function(){function a(b){for(var c in a.defaults)this[c]=a.defaults[c];for(c in b)this[c]=b[c]}a.defaults={x:0,y:0,width:0,height:0};var b=a.prototype;return b.contains=function(a){var b=a.width||0,c=a.height||0;return this.x<=a.x&&this.y<=a.y&&this.x+this.width>=a.x+b&&this.y+this.height>=a.y+c},b.overlaps=function(a){var b=this.x+this.width,c=this.y+this.height,d=a.x+a.width,e=a.y+a.height;return this.x<d&&b>a.x&&this.y<e&&c>a.y},b.getMaximalFreeRects=function(b){if(!this.overlaps(b))return!1;var c,d=[],e=this.x+this.width,f=this.y+this.height,g=b.x+b.width,h=b.y+b.height;return this.y<b.y&&(c=new a({x:this.x,y:this.y,width:this.width,height:b.y-this.y}),d.push(c)),e>g&&(c=new a({x:g,y:this.y,width:e-g,height:this.height}),d.push(c)),f>h&&(c=new a({x:this.x,y:h,width:this.width,height:f-h}),d.push(c)),this.x<b.x&&(c=new a({x:this.x,y:this.y,width:b.x-this.x,height:this.height}),d.push(c)),d},b.canFit=function(a){return this.width>=a.width&&this.height>=a.height},a}),function(a,b){if("function"==typeof define&&define.amd)define("packery/js/packer",["./rect"],b);else if("object"==typeof module&&module.exports)module.exports=b(require("./rect"));else{var c=a.Packery=a.Packery||{};c.Packer=b(c.Rect)}}(window,function(a){function b(a,b,c){this.width=a||0,this.height=b||0,this.sortDirection=c||"downwardLeftToRight",this.reset()}var c=b.prototype;c.reset=function(){this.spaces=[];var b=new a({x:0,y:0,width:this.width,height:this.height});this.spaces.push(b),this.sorter=d[this.sortDirection]||d.downwardLeftToRight},c.pack=function(a){for(var b=0;b<this.spaces.length;b++){var c=this.spaces[b];if(c.canFit(a)){this.placeInSpace(a,c);break}}},c.columnPack=function(a){for(var b=0;b<this.spaces.length;b++){var c=this.spaces[b],d=c.x<=a.x&&c.x+c.width>=a.x+a.width&&c.height>=a.height-.01;if(d){a.y=c.y,this.placed(a);break}}},c.rowPack=function(a){for(var b=0;b<this.spaces.length;b++){var c=this.spaces[b],d=c.y<=a.y&&c.y+c.height>=a.y+a.height&&c.width>=a.width-.01;if(d){a.x=c.x,this.placed(a);break}}},c.placeInSpace=function(a,b){a.x=b.x,a.y=b.y,this.placed(a)},c.placed=function(a){for(var b=[],c=0;c<this.spaces.length;c++){var d=this.spaces[c],e=d.getMaximalFreeRects(a);e?b.push.apply(b,e):b.push(d)}this.spaces=b,this.mergeSortSpaces()},c.mergeSortSpaces=function(){b.mergeRects(this.spaces),this.spaces.sort(this.sorter)},c.addSpace=function(a){this.spaces.push(a),this.mergeSortSpaces()},b.mergeRects=function(a){var b=0,c=a[b];a:for(;c;){for(var d=0,e=a[b+d];e;){if(e==c)d++;else{if(e.contains(c)){a.splice(b,1),c=a[b];continue a}c.contains(e)?a.splice(b+d,1):d++}e=a[b+d]}b++,c=a[b]}return a};var d={downwardLeftToRight:function(a,b){return a.y-b.y||a.x-b.x},rightwardTopToBottom:function(a,b){return a.x-b.x||a.y-b.y}};return b}),function(a,b){"function"==typeof define&&define.amd?define("packery/js/item",["outlayer/outlayer","./rect"],b):"object"==typeof module&&module.exports?module.exports=b(require("outlayer"),require("./rect")):a.Packery.Item=b(a.Outlayer,a.Packery.Rect)}(window,function(a,b){var c=document.documentElement.style,d="string"==typeof c.transform?"transform":"WebkitTransform",e=function(){a.Item.apply(this,arguments)},f=e.prototype=Object.create(a.Item.prototype),g=f._create;f._create=function(){g.call(this),this.rect=new b};var h=f.moveTo;return f.moveTo=function(a,b){var c=Math.abs(this.position.x-a),d=Math.abs(this.position.y-b),e=this.layout.dragItemCount&&!this.isPlacing&&!this.isTransitioning&&1>c&&1>d;return e?void this.goTo(a,b):void h.apply(this,arguments)},f.enablePlacing=function(){this.removeTransitionStyles(),this.isTransitioning&&d&&(this.element.style[d]="none"),this.isTransitioning=!1,this.getSize(),this.layout._setRectSize(this.element,this.rect),this.isPlacing=!0},f.disablePlacing=function(){this.isPlacing=!1},f.removeElem=function(){this.element.parentNode.removeChild(this.element),this.layout.packer.addSpace(this.rect),this.emitEvent("remove",[this])},f.showDropPlaceholder=function(){var a=this.dropPlaceholder;a||(a=this.dropPlaceholder=document.createElement("div"),a.className="packery-drop-placeholder",a.style.position="absolute"),a.style.width=this.size.width+"px",a.style.height=this.size.height+"px",this.positionDropPlaceholder(),this.layout.element.appendChild(a)},f.positionDropPlaceholder=function(){this.dropPlaceholder.style[d]="translate("+this.rect.x+"px, "+this.rect.y+"px)"},f.hideDropPlaceholder=function(){this.layout.element.removeChild(this.dropPlaceholder)},e}),function(a,b){"function"==typeof define&&define.amd?define("packery/js/packery",["get-size/get-size","outlayer/outlayer","./rect","./packer","./item"],b):"object"==typeof module&&module.exports?module.exports=b(require("get-size"),require("outlayer"),require("./rect"),require("./packer"),require("./item")):a.Packery=b(a.getSize,a.Outlayer,a.Packery.Rect,a.Packery.Packer,a.Packery.Item)}(window,function(a,b,c,d,e){function f(a,b){return a.position.y-b.position.y||a.position.x-b.position.x}function g(a,b){return a.position.x-b.position.x||a.position.y-b.position.y}function h(a,b){var c=b.x-a.x,d=b.y-a.y;return Math.sqrt(c*c+d*d)}c.prototype.canFit=function(a){return this.width>=a.width-1&&this.height>=a.height-1};var i=b.create("packery");i.Item=e;var j=i.prototype;j._create=function(){b.prototype._create.call(this),this.packer=new d,this.shiftPacker=new d,this.isEnabled=!0,this.dragItemCount=0;var a=this;this.handleDraggabilly={dragStart:function(){a.itemDragStart(this.element)},dragMove:function(){a.itemDragMove(this.element,this.position.x,this.position.y)},dragEnd:function(){a.itemDragEnd(this.element)}},this.handleUIDraggable={start:function(b,c){c&&a.itemDragStart(b.currentTarget)},drag:function(b,c){c&&a.itemDragMove(b.currentTarget,c.position.left,c.position.top)},stop:function(b,c){c&&a.itemDragEnd(b.currentTarget)}}},j._resetLayout=function(){this.getSize(),this._getMeasurements();var a,b,c;this._getOption("horizontal")?(a=1/0,b=this.size.innerHeight+this.gutter,c="rightwardTopToBottom"):(a=this.size.innerWidth+this.gutter,b=1/0,c="downwardLeftToRight"),this.packer.width=this.shiftPacker.width=a,this.packer.height=this.shiftPacker.height=b,this.packer.sortDirection=this.shiftPacker.sortDirection=c,this.packer.reset(),this.maxY=0,this.maxX=0},j._getMeasurements=function(){this._getMeasurement("columnWidth","width"),this._getMeasurement("rowHeight","height"),this._getMeasurement("gutter","width")},j._getItemLayoutPosition=function(a){if(this._setRectSize(a.element,a.rect),this.isShifting||this.dragItemCount>0){var b=this._getPackMethod();this.packer[b](a.rect)}else this.packer.pack(a.rect);return this._setMaxXY(a.rect),a.rect},j.shiftLayout=function(){this.isShifting=!0,this.layout(),delete this.isShifting},j._getPackMethod=function(){return this._getOption("horizontal")?"rowPack":"columnPack"},j._setMaxXY=function(a){this.maxX=Math.max(a.x+a.width,this.maxX),this.maxY=Math.max(a.y+a.height,this.maxY)},j._setRectSize=function(b,c){var d=a(b),e=d.outerWidth,f=d.outerHeight;(e||f)&&(e=this._applyGridGutter(e,this.columnWidth),f=this._applyGridGutter(f,this.rowHeight)),c.width=Math.min(e,this.packer.width),c.height=Math.min(f,this.packer.height)},j._applyGridGutter=function(a,b){if(!b)return a+this.gutter;b+=this.gutter;var c=a%b,d=c&&1>c?"round":"ceil";return a=Math[d](a/b)*b},j._getContainerSize=function(){return this._getOption("horizontal")?{width:this.maxX-this.gutter}:{height:this.maxY-this.gutter}},j._manageStamp=function(a){var b,d=this.getItem(a);if(d&&d.isPlacing)b=d.rect;else{var e=this._getElementOffset(a);b=new c({x:this._getOption("originLeft")?e.left:e.right,y:this._getOption("originTop")?e.top:e.bottom})}this._setRectSize(a,b),this.packer.placed(b),this._setMaxXY(b)},j.sortItemsByPosition=function(){var a=this._getOption("horizontal")?g:f;this.items.sort(a)},j.fit=function(a,b,c){var d=this.getItem(a);d&&(this.stamp(d.element),d.enablePlacing(),this.updateShiftTargets(d),b=void 0===b?d.rect.x:b,c=void 0===c?d.rect.y:c,this.shift(d,b,c),this._bindFitEvents(d),d.moveTo(d.rect.x,d.rect.y),this.shiftLayout(),this.unstamp(d.element),this.sortItemsByPosition(),d.disablePlacing())},j._bindFitEvents=function(a){function b(){d++,2==d&&c.dispatchEvent("fitComplete",null,[a])}var c=this,d=0;a.once("layout",b),this.once("layoutComplete",b)},j.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&(this.options.shiftPercentResize?this.resizeShiftPercentLayout():this.layout())},j.needsResizeLayout=function(){var b=a(this.element),c=this._getOption("horizontal")?"innerHeight":"innerWidth";return b[c]!=this.size[c]},j.resizeShiftPercentLayout=function(){var b=this._getItemsForLayout(this.items),c=this._getOption("horizontal"),d=c?"y":"x",e=c?"height":"width",f=c?"rowHeight":"columnWidth",g=c?"innerHeight":"innerWidth",h=this[f];if(h=h&&h+this.gutter){this._getMeasurements();var i=this[f]+this.gutter;b.forEach(function(a){var b=Math.round(a.rect[d]/h);a.rect[d]=b*i})}else{var j=a(this.element)[g]+this.gutter,k=this.packer[e];b.forEach(function(a){a.rect[d]=a.rect[d]/k*j})}this.shiftLayout()},j.itemDragStart=function(a){if(this.isEnabled){this.stamp(a);var b=this.getItem(a);b&&(b.enablePlacing(),b.showDropPlaceholder(),this.dragItemCount++,this.updateShiftTargets(b))}},j.updateShiftTargets=function(a){this.shiftPacker.reset(),this._getBoundingRect();var b=this._getOption("originLeft"),d=this._getOption("originTop");this.stamps.forEach(function(a){var e=this.getItem(a);if(!e||!e.isPlacing){var f=this._getElementOffset(a),g=new c({x:b?f.left:f.right,y:d?f.top:f.bottom});this._setRectSize(a,g),this.shiftPacker.placed(g)}},this);var e=this._getOption("horizontal"),f=e?"rowHeight":"columnWidth",g=e?"height":"width";this.shiftTargetKeys=[],this.shiftTargets=[];var h,i=this[f];if(i=i&&i+this.gutter){var j=Math.ceil(a.rect[g]/i),k=Math.floor((this.shiftPacker[g]+this.gutter)/i);h=(k-j)*i;for(var l=0;k>l;l++)this._addShiftTarget(l*i,0,h)}else h=this.shiftPacker[g]+this.gutter-a.rect[g],this._addShiftTarget(0,0,h);var m=this._getItemsForLayout(this.items),n=this._getPackMethod();m.forEach(function(a){var b=a.rect;this._setRectSize(a.element,b),this.shiftPacker[n](b),this._addShiftTarget(b.x,b.y,h);var c=e?b.x+b.width:b.x,d=e?b.y:b.y+b.height;if(this._addShiftTarget(c,d,h),i)for(var f=Math.round(b[g]/i),j=1;f>j;j++){var k=e?c:b.x+i*j,l=e?b.y+i*j:d;this._addShiftTarget(k,l,h)}},this)},j._addShiftTarget=function(a,b,c){var d=this._getOption("horizontal")?b:a;if(!(0!==d&&d>c)){var e=a+","+b,f=-1!=this.shiftTargetKeys.indexOf(e);f||(this.shiftTargetKeys.push(e),this.shiftTargets.push({x:a,y:b}))}},j.shift=function(a,b,c){var d,e=1/0,f={x:b,y:c};this.shiftTargets.forEach(function(a){var b=h(a,f);e>b&&(d=a,e=b)}),a.rect.x=d.x,a.rect.y=d.y};var k=120;j.itemDragMove=function(a,b,c){function d(){f.shift(e,b,c),e.positionDropPlaceholder(),f.layout()}var e=this.isEnabled&&this.getItem(a);if(e){b-=this.size.paddingLeft,c-=this.size.paddingTop;var f=this,g=new Date;this._itemDragTime&&g-this._itemDragTime<k?(clearTimeout(this.dragTimeout),this.dragTimeout=setTimeout(d,k)):(d(),this._itemDragTime=g)}},j.itemDragEnd=function(a){function b(){d++,2==d&&(c.element.classList.remove("is-positioning-post-drag"),c.hideDropPlaceholder(),e.dispatchEvent("dragItemPositioned",null,[c]))}var c=this.isEnabled&&this.getItem(a);if(c){clearTimeout(this.dragTimeout),c.element.classList.add("is-positioning-post-drag");var d=0,e=this;c.once("layout",b),this.once("layoutComplete",b),c.moveTo(c.rect.x,c.rect.y),this.layout(),this.dragItemCount=Math.max(0,this.dragItemCount-1),this.sortItemsByPosition(),c.disablePlacing(),this.unstamp(c.element)}},j.bindDraggabillyEvents=function(a){this._bindDraggabillyEvents(a,"on")},j.unbindDraggabillyEvents=function(a){this._bindDraggabillyEvents(a,"off")},j._bindDraggabillyEvents=function(a,b){var c=this.handleDraggabilly;a[b]("dragStart",c.dragStart),a[b]("dragMove",c.dragMove),a[b]("dragEnd",c.dragEnd)},j.bindUIDraggableEvents=function(a){this._bindUIDraggableEvents(a,"on")},j.unbindUIDraggableEvents=function(a){this._bindUIDraggableEvents(a,"off")},j._bindUIDraggableEvents=function(a,b){var c=this.handleUIDraggable;a[b]("dragstart",c.start)[b]("drag",c.drag)[b]("dragstop",c.stop)};var l=j.destroy;return j.destroy=function(){l.apply(this,arguments),this.isEnabled=!1},i.Rect=c,i.Packer=d,i}),function(a,b){"function"==typeof define&&define.amd?define(["isotope-layout/js/layout-mode","packery/js/packery"],b):"object"==typeof module&&module.exports?module.exports=b(require("isotope-layout/js/layout-mode"),require("packery")):b(a.Isotope.LayoutMode,a.Packery)}(window,function(a,b){var c=a.create("packery"),d=c.prototype,e={_getElementOffset:!0,_getMeasurement:!0};for(var f in b.prototype)e[f]||(d[f]=b.prototype[f]);var g=d._resetLayout;d._resetLayout=function(){this.packer=this.packer||new b.Packer,this.shiftPacker=this.shiftPacker||new b.Packer,g.apply(this,arguments)};var h=d._getItemLayoutPosition;d._getItemLayoutPosition=function(a){return a.rect=a.rect||new b.Rect,h.call(this,a)};var i=d.needsResizeLayout;d.needsResizeLayout=function(){return this._getOption("horizontal")?this.needsVerticalResizeLayout():i.call(this)};var j=d._getOption;return d._getOption=function(a){return"horizontal"==a?void 0!==this.options.isHorizontal?this.options.isHorizontal:this.options.horizontal:j.apply(this.isotope,arguments)},c});(function(i){'use strict';i.fn.avia_masonry=function(a){if(!this.length){return this};var s=i('body'),e=i(window),n=i.avia_utilities.isMobile,l=i.avia_utilities.isTouchDevice,r=s.hasClass('avia-mobile-no-animations'),o=!1,t={masonry_filter:function(){var a=i(this),l=a.html(),n=a.data('filter'),o=a.parents('.av-masonry').eq(0),s=o.find('.av-masonry-container').eq(0),d=o.find('.av-masonry-sort a'),r=o.find('.av-current-sort-title');d.removeClass('active_sort');a.addClass('active_sort');s.attr('id','masonry_id_'+n);if(r.length){r.html(l)};t.applyMasonry(s,n,function(){s.css({overflow:'visible'})});setTimeout(function(){e.trigger('debouncedresize')},500);return!1},applyMasonry:function(a,o,s){var t=o?{filter:'.'+o}:{};t['layoutMode']='packery';t['packery']={gutter:0};t['percentPosition']=!0;t['itemSelector']='a.isotope-item, div.isotope-item';t['originLeft']=i('body').hasClass('rtl')?!1:!0;a.isotope(t,function(){e.trigger('av-height-change')});if(typeof s==='function'){setTimeout(s,0)}},show_bricks:function(a,t){var s=i.avia_utilities.supports('transition'),o=n&&r?0:100;a.each(function(n){var r=i(this),l=r.find('.avia-curtain-reveal-overlay');if(l.length>0){o=500;l.on('animationstart',function(i){r.css({visibility:'visible'})});l.on('animationend',function(a){i(this).remove()})};setTimeout(function(){if(s===!1){r.css({visibility:'visible',opacity:0}).animate({opacity:1},1500)}
else{r.addClass('av-masonry-item-loaded');l.addClass('avia_start_delayed_animation')};if(n==a.length-1&&typeof t=='function'){t.call();e.trigger('av-height-change')}},(o*n))})},loadMore:function(a){a.preventDefault();if(o){return!1};o=!0;var l=i(this),n=l.data(),r=l.parents('.av-masonry').eq(0),f=r.data('post_id'),c=r.find('.av-masonry-container'),u=r.find('.av-masonry-entry'),d=i.avia_utilities.loading(),v=function(){o=!1;d.hide();s.trigger('av_resize_finished')};if('undefined'!=typeof f){n.post_id=f};if(!n.offset){n.offset=0};n.offset+=n.items;n.action='avia_ajax_masonry_more';n.loaded=[];u.each(function(){var a=i(this).data('av-masonry-item');if(a){n.loaded.push(a)}});i.ajax({url:avia_framework_globals.ajaxurl,type:'POST',data:n,beforeSend:function(){d.show()},success:function(a){if(a.indexOf('{av-masonry-loaded}')!==-1){var a=a.split('{av-masonry-loaded}'),o=i(a.pop()).filter('.isotope-item');if(o.length>n.items){o=o.not(o.last())}
else{l.addClass('av-masonry-no-more-items')};o.find('.avia-animate-admin-preview').removeClass('avia-animate-admin-preview');if(o.find('.avia-curtain-reveal-overlay').length>0){o.css({visibility:'hidden'})};var s=i('<div class="loadcontainer"></div>').append(o);i.avia_utilities.preload({container:s,single_callback:function(){var s=r.find('.av-masonry-sort a'),a=r.find('.av-sort-by-term'),n=a.data('av-allowed-sort');a.hide();d.hide();c.isotope('insert',o);i.avia_utilities.avia_ajax_call(r);setTimeout(function(){t.show_bricks(o,v)},150);setTimeout(function(){e.trigger('av-height-change')},550);if(s){i(s).each(function(a){var t=i(this),e=t.data('filter');if(o){i(o).each(function(a){var s=i(this);if(s.hasClass(e)&&n.indexOf(e)!==-1){var o=t.find('.avia-term-count').text();t.find('.avia-term-count').text(' '+(parseInt(o)+1)+' ');if(t.hasClass('avia_hide_sort')){t.removeClass('avia_hide_sort').addClass('avia_show_sort');r.find('.av-masonry-sort .'+e+'_sep').removeClass('avia_hide_sort').addClass('avia_show_sort');r.find('.av-masonry-sort .av-sort-by-term').removeClass('hidden')}}})}})};a.fadeIn()}})}
else{v()}},error:v,complete:function(){setTimeout(function(){e.trigger('debouncedresize')},500)}})}};return this.each(function(){var a=i(this),e=a.find('.av-masonry-container'),o=a.find('.isotope-item'),s=a.find('.av-masonry-sort').css({visibility:'visible',opacity:0}).on('click','a',t.masonry_filter),l=a.find('.av-masonry-load-more').css({visibility:'visible',opacity:0});if(o.find('.avia-curtain-reveal-overlay').length>0){o.css({visibility:'hidden'})};i.avia_utilities.preload({container:e,single_callback:function(){var d=function(){s.animate({opacity:1},400);if(e.outerHeight()+e.offset().top+i('#footer').outerHeight()>i(window).height()){i('html').css({'overflow-y':'scroll'})};t.applyMasonry(e,!1,function(){a.addClass('avia_sortable_active');e.removeClass('av-js-disabled')});t.show_bricks(o,function(){l.css({opacity:1}).on('click',t.loadMore)})};if(n&&r){d()}
else{a.waypoint(d,{offset:'80%'})};i(window).on('debouncedresize',function(){t.applyMasonry(e,!1,function(){a.addClass('avia_sortable_active')})})}})})}}(jQuery));(function(t){t.fn.avia_sc_animated_number=function(a){if(!this.length)return;if(this.is('.avia_sc_animated_number_active'))return;this.addClass('avia_sc_animated_number_active');var e=(a&&a.simple_up)?!0:!1,r=(a&&a.start_timer)?a.start_timer:300,n=function(t,a,n){var r='',s=n.toString().length-t.toString().length;for(var i=s;i>0;i--){r+='0'};t=(e)?t.toString():r+t.toString();if(''==a){return t};return t.split(/(?=(?:...)*$)/).join(a)},i=function(t,a,r,u,f,s){var o=u+r,final='';if(o>=f){final=n(a,s,a);t.text(final)}
else{final=n(o,s,a);t.text(final);window.requestAnimationFrame(function(){i(t,a,r,o,f,s)})}};return this.each(function(){var n=t(this),e=n.find('.__av-single-number'),s=n.data('timer')||3000;e.each(function(a){var n=t(this),i=n.text();if(window.addEventListener)n.text(i.replace(/./g,'0'))});n.addClass('number_prepared').on('avia_start_animation',function(){if(n.is('.avia_animation_done'))return;n.addClass('avia_animation_done');e.each(function(n){var a=t(this),e=a.data('number'),f=e,u=parseInt(a.text(),10),m=/^0+$/.test(e),o=0,d='';if('undefined'!=typeof a.data('start_from')){u=a.data('start_from')};if('undefined'!=typeof a.data('number_format')){d=a.data('number_format')};if(m&&e!==0){f=e.replace(/0/g,'9')};o=Math.round(f*32/s);if(o==0||o%10==0)o+=1;setTimeout(function(){i(a,e,o,u,f,d)},r)})});if(a&&a.instant_start==!0){n.trigger('avia_start_animation')}})}})(jQuery);(function(i){'use strict';i.AviaSlider=function(s,t){var e=this;this.$win=i(window);this.$slider=i(t);this.isMobile=i.avia_utilities.isMobile;this.isTouchDevice=i.avia_utilities.isTouchDevice,this._prepareSlides(s);i.avia_utilities.preload({container:this.$slider,single_callback:function(){e._init(s)}})};i.AviaSlider.defaults={interval:5,autoplay:!1,autoplay_stopper:!1,loop_autoplay:'once',loop_manual:'manual-endless',stopinfiniteloop:!1,noNavigation:!1,animation:'slide',transitionSpeed:900,easing:'easeInOutQuart',wrapElement:'>ul',slideElement:'>li',hoverpause:!1,bg_slider:!1,show_slide_delay:0,fullfade:!1,keep_padding:!1,carousel:'no',carouselSlidesToShow:3,carouselSlidesToScroll:1,carouselResponsive:[]};i.AviaSlider.prototype={_init:function(s){this.options=this._setOptions(s);this.$sliderUl=this.$slider.find(this.options.wrapElement);this.$slides=this.$sliderUl.find(this.options.slideElement);this.slide_arrows=this.$slider.find('.avia-slideshow-arrows');this.gotoButtons=this.$slider.find('.avia-slideshow-dots a');this.permaCaption=this.$slider.find('>.av-slideshow-caption');this.itemsCount=this.$slides.length;this.current=0;this.currentCarousel=0;this.slideWidthCarousel='240';this.loopCount=0;this.isAnimating=!1;this.browserPrefix=i.avia_utilities.supports('transition');this.cssActive=this.browserPrefix!==!1?!0:!1;this.css3DActive=document.documentElement.className.indexOf('avia_transform3d')!==-1?!0:!1;if(this.options.bg_slider==!0){this.imageUrls=[];this.loader=i.avia_utilities.loading(this.$slider);this._bgPreloadImages()}
else{this._kickOff()};if(this.options.carousel==='yes'){this.options.animation='carouselslide'}},_setOptions:function(s){var o=this.$slider.data('slideshow-options');if('object'==typeof o){var t=i.extend({},i.AviaSlider.defaults,s,o);if('undefined'!=typeof t.transition_speed){t.transitionSpeed=t.transition_speed};return t};var t=i.extend(!0,{},i.AviaSlider.defaults,s),a=this.$slider.data();for(var e in a){var n=('transition_speed'!=e)?e:'transitionSpeed';if(typeof a[e]==='string'||typeof a[e]==='number'||typeof a[e]==='boolean'){t[n]=a[e]};if('undefined'!=typeof t.autoplay_stopper&&t.autoplay_stopper==1){t.autoplay_stopper=!0}};return t},_prepareSlides:function(s){var t=this.$slider.find('.avia-multi-slideshow-button');if(t.length){t.on('click',function(s){s.stopPropagation();var t=i.avia_utilities.loading(i(this));t.show()})};if(this.isMobile){var e=this.$slider.find('.av-mobile-fallback-image');e.each(function(){var t=i(this).removeClass('av-video-slide').data({'avia_video_events':!0,'video-ratio':0}),n=t.data('mobile-img'),e=t.data('fallback-link'),a=t.find('.avia-slide-wrap');t.find('.av-click-overlay, .mejs-mediaelement, .mejs-container').remove();if(!n){i('<p class="av-fallback-message"><span>Please set a mobile device fallback image for this video in your wordpress backend</span></p>').appendTo(a)};if(s&&s.bg_slider){t.data('img-url',n);if(e!=''){if(a.is('a')){a.attr('href',e)}
else{a.replaceWith(function(){var s=i(this);return i('<a>').attr({'data-rel':s.data('rel'),'class':s.attr('class'),'href':e}).append(i(this).contents())});a=t.find('.avia-slide-wrap')};if(i.fn.avia_activate_lightbox){t.parents('#main').avia_activate_lightbox()}}}
else{var o='<img src="'+n+'" alt="" title="" />',l=!1;if('string'==typeof e&&e.trim()!=''){if(a.is('a')){a.attr('href',e)}
else{var r=e.match(/\.(jpg|jpeg|gif|png)$/i)!=null?' rel="lightbox" ':'';o='<a href="'+e.trim()+'"'+r+'>'+o+'</a>'};l=!0};t.find('.avia-slide-wrap').append(o);if(l&&i.fn.avia_activate_lightbox){t.parents('#main').avia_activate_lightbox()}}})};if(i('html').is('.pointer-device-fine')){if(i('body').is('.avia-slider-video-controls-fix-support')){avia_slider_video_controls_fix(this)}}},_bgPreloadImages:function(i){this._getImageURLS();this._preloadSingle(0,function(){this._kickOff();this._preloadNext(1)})},_getImageURLS:function(){var s=this;this.$slides.each(function(t){s.imageUrls[t]=[];s.imageUrls[t]['url']=i(this).data('img-url');if(typeof s.imageUrls[t]['url']=='string'){s.imageUrls[t]['status']=!1}
else{s.imageUrls[t]['status']=!0}})},_preloadSingle:function(s,t){var e=this,a=new Image();if(typeof e.imageUrls[s]['url']=='string'){i(a).on('load error',function(){e.imageUrls[s]['status']=!0;e.$slides.eq(s).css('background-image','url('+e.imageUrls[s]['url']+')');if(typeof t=='function'){t.apply(e,[a,s])}});if(e.imageUrls[s]['url']!=''){a.src=e.imageUrls[s]['url']}
else{i(a).trigger('error')}}
else{if(typeof t=='function'){t.apply(e,[a,s])}}},_preloadNext:function(i){if(typeof this.imageUrls[i]!='undefined'){this._preloadSingle(i,function(){this._preloadNext(i+1)})}},_bindEvents:function(){var t=this,s=i(window);this.$slider.on('click','.next-slide',this.next.bind(this));this.$slider.on('click','.prev-slide',this.previous.bind(this));this.$slider.on('click','.goto-slide',this.go2.bind(this));if(this.options.hoverpause){this.$slider.on('mouseenter',this.pause.bind(this));this.$slider.on('mouseleave',this.resume.bind(this))};if(this.permaCaption.length){this.permaCaption.on('click',this._routePermaCaptionClick);this.$slider.on('avia_slider_first_slide avia_slider_last_slide avia_slider_navigate_slide',this._setPermaCaptionPointer.bind(this))};if(this.options.stopinfiniteloop&&this.options.autoplay){if(this.options.stopinfiniteloop=='last'){this.$slider.on('avia_slider_last_slide',this._stopSlideshow.bind(this))}
else if(this.options.stopinfiniteloop=='first'){this.$slider.on('avia_slider_first_slide',this._stopSlideshow.bind(this))}};if(this.options.carousel==='yes'){if(!this.isMobile){s.on('debouncedresize',this._buildCarousel.bind(this))}}
else{s.on('debouncedresize.aviaSlider',this._setSize.bind(this))};if(!this.options.noNavigation){if(!this.isMobile){this.$slider.avia_keyboard_controls()};if(this.isMobile||this.isTouchDevice){this.$slider.avia_swipe_trigger()}};t._attach_video_events()},_kickOff:function(){var s=this,t=s.$slides.eq(0),e=t.data('video-ratio');s._bindEvents();s._set_slide_arrows_visibility();this.$slider.removeClass('av-default-height-applied');if(e){s._setSize(!0)}
else{if(this.options.keep_padding!=!0){s.$sliderUl.css('padding',0);s.$win.trigger('av-height-change')}};s._setCenter();if(this.options.carousel==='no'){t.addClass('next-active-slide');t.css({visibility:'visible',opacity:0}).avia_animate({opacity:1},function(){var t=i(this).addClass('active-slide');if(s.permaCaption.length){s.permaCaption.addClass('active-slide')}})};s.$slider.trigger('avia_slider_first_slide');if(s.options.autoplay){s._startSlideshow()};if(s.options.carousel==='yes'){s._buildCarousel()};s.$slider.trigger('_kickOff')},_set_slide_arrows_visibility:function(){if(this.options.carousel=='yes'){if(0==this.currentCarousel){this.slide_arrows.removeClass('av-visible-prev');this.slide_arrows.addClass('av-visible-next')}
else if(this.currentCarousel+this.options.carouselSlidesToShow>=this.itemsCount){this.slide_arrows.addClass('av-visible-prev');this.slide_arrows.removeClass('av-visible-next')}
else{this.slide_arrows.addClass('av-visible-prev');this.slide_arrows.addClass('av-visible-next')};return};if('endless'==this.options.loop_autoplay||'manual-endless'==this.options.loop_manual){this.slide_arrows.addClass('av-visible-prev');this.slide_arrows.addClass('av-visible-next')}
else if(0==this.current){this.slide_arrows.removeClass('av-visible-prev');this.slide_arrows.addClass('av-visible-next')}
else if(this.current+1>=this.itemsCount){this.slide_arrows.addClass('av-visible-prev');this.slide_arrows.removeClass('av-visible-next')}
else{this.slide_arrows.addClass('av-visible-prev');this.slide_arrows.addClass('av-visible-next')}},_buildCarousel:function(){var r=this,a=this.$slider.outerWidth(),s=parseInt(a/this.options.carouselSlidesToShow),l=window.innerWidth||i(window).width();if(this.options.carouselResponsive&&this.options.carouselResponsive.length&&this.options.carouselResponsive!==null){for(var e in this.options.carouselResponsive){var n=this.options.carouselResponsive[e]['breakpoint'],t=this.options.carouselResponsive[e]['settings']['carouselSlidesToShow'];if(n>=l){s=parseInt(a/t);this.options.carouselSlidesToShow=t}}};this.slideWidthCarousel=s;this.$slides.each(function(t){i(this).width(s)});var o=s*this.itemsCount;this.$sliderUl.width(o).css('transform','translateX(0px)');if(this.options.carouselSlidesToShow>=this.itemsCount){this.$slider.find('.av-timeline-nav').hide()}},_navigate:function(i,s){if(this.isAnimating||this.itemsCount<2 ||!this.$slider.is(':visible')){return!1};this.isAnimating=!0;this.prev=this.current;if(s!==undefined){this.current=s;i=this.current>this.prev?'next':'prev'}
else if(i==='next'){this.current=this.current<this.itemsCount-1?this.current+1:0;if(this.current===0&&this.options.autoplay_stopper&&this.options.autoplay){this.isAnimating=!1;this.current=this.prev;this._stopSlideshow();return!1};if(0===this.current){if('endless'!=this.options.loop_autoplay&&'manual-endless'!=this.options.loop_manual){this.isAnimating=!1;this.current=this.prev;return!1}}}
else if(i==='prev'){this.current=this.current>0?this.current-1:this.itemsCount-1;if(this.itemsCount-1===this.current){if('endless'!=this.options.loop_autoplay&&'manual-endless'!=this.options.loop_manual){this.isAnimating=!1;this.current=this.prev;return!1}}};this.gotoButtons.removeClass('active').eq(this.current).addClass('active');this._set_slide_arrows_visibility();if(this.options.carousel==='no'){this._setSize()};if(this.options.bg_slider==!0){if(this.imageUrls[this.current]['status']==!0){this['_'+this.options.animation].call(this,i)}
else{this.loader.show();this._preloadSingle(this.current,function(){this['_'+this.options.animation].call(this,i);this.loader.hide()})}}
else{this['_'+this.options.animation].call(this,i)};if(this.current==0){this.loopCount++;this.$slider.trigger('avia_slider_first_slide')}
else if(this.current==this.itemsCount-1){this.$slider.trigger('avia_slider_last_slide')}
else{this.$slider.trigger('avia_slider_navigate_slide')}},_setSize:function(i){if(this.options.bg_slider==!0){return};var n=this,s=this.$slides.eq(this.current),r=s.find('img'),a=Math.floor(this.$sliderUl.height()),o=s.data('video-ratio'),t=o?this.$sliderUl.width()/o:Math.floor(s.height()),e=s.data('video-height'),l=s.data('video-toppos');this.$sliderUl.height(a).css('padding',0);if(t!=a){if(i==!0){this.$sliderUl.css({height:t});this.$win.trigger('av-height-change')}
else{this.$sliderUl.avia_animate({height:t},function(){n.$win.trigger('av-height-change')})}};this._setCenter();if(e&&e!='set'){s.find('iframe, embed, video, object, .av_youtube_frame').css({height:e+'%',top:l+'%'});s.data('video-height','set')}},_setCenter:function(){var e=this.$slides.eq(this.current),o=e.find('img'),i=parseInt(o.css('min-width'),10),s=e.width(),a=e.find('.av-slideshow-caption'),t=((s-i)/2);if(a.length){if(a.is('.caption_left')){t=((s-i)/1.5)}
else if(a.is('.caption_right')){t=((s-i)/2.5)}};if(s>=i){t=0};o.css({left:t})},_carouselmove:function(){var i=this.slideWidthCarousel*this.currentCarousel;this.$sliderUl.css('transform','translateX(-'+i+'px)')},_carouselslide:function(i){console.log('_carouselslide:',i,this.currentCarousel);if(i==='next'){if(this.options.carouselSlidesToShow+this.currentCarousel<this.itemsCount){this.currentCarousel++;this._carouselmove()}}
else if(i==='prev'){if(this.currentCarousel>0){this.currentCarousel--;this._carouselmove()}};this._set_slide_arrows_visibility();this.isAnimating=!1},_slide:function(i){var l=!1,h=l==!0?2:1,r=this.$slider.width(),d=i==='next'?-1:1,s=this.browserPrefix+'transform',a={},t={},e={},o=(r*d*-1),n=(r*d)/h;if(this.cssActive){s=this.browserPrefix+'transform';if(this.css3DActive){a[s]='translate3d('+o+'px, 0, 0)';t[s]='translate3d('+n+'px, 0, 0)';e[s]='translate3d(0,0,0)'}
else{a[s]='translate('+o+'px,0)';t[s]='translate('+n+'px,0)';e[s]='translate(0,0)'}}
else{a.left=o;t.left=n;e.left=0};if(l){t['z-index']='1';e['z-index']='2'};this._slide_animate(a,t,e)},_slide_up:function(i){var l=!0,h=l==!0?2:1,r=this.$slider.height(),d=i==='next'?-1:1,s=this.browserPrefix+'transform',a={},t={},e={},o=(r*d*-1),n=(r*d)/h;if(this.cssActive){s=this.browserPrefix+'transform';if(this.css3DActive){a[s]='translate3d( 0,'+o+'px, 0)';t[s]='translate3d( 0,'+n+'px, 0)';e[s]='translate3d(0,0,0)'}
else{a[s]='translate( 0,'+o+'px)';t[s]='translate( 0,'+n+'px)';e[s]='translate(0,0)'}}
else{a.top=o;t.top=n;e.top=0};if(l){t['z-index']='1';e['z-index']='2'};this._slide_animate(a,t,e)},_slide_animate:function(i,e,a){var t=this,s=this.$slides.eq(this.current),o=this.$slides.eq(this.prev);o.trigger('pause');if(!s.data('disableAutoplay')){if(s.hasClass('av-video-lazyload')&&!s.hasClass('av-video-lazyload-complete')){s.find('.av-click-to-play-overlay').trigger('click')}
else{s.trigger('play')}};s.css({visibility:'visible',zIndex:4,opacity:1,left:0,top:0});s.css(i);o.avia_animate(e,this.options.transitionSpeed,this.options.easing);var n=function(){t.isAnimating=!1;s.addClass('active-slide');o.css({visibility:'hidden'}).removeClass('active-slide next-active-slide');t.$slider.trigger('avia-transition-done')};if(t.options.show_slide_delay>0){setTimeout(function(){s.addClass('next-active-slide');s.avia_animate(a,t.options.transitionSpeed,t.options.easing,n)},t.options.show_slide_delay)}
else{s.addClass('next-active-slide');s.avia_animate(a,t.options.transitionSpeed,t.options.easing,n)}},_fade:function(){var s=this,i=this.$slides.eq(this.current),t=this.$slides.eq(this.prev),e={visibility:'visible',zIndex:3,opacity:0},a=function(){s.isAnimating=!1;i.addClass('active-slide');t.css({visibility:'hidden',zIndex:2}).removeClass('active-slide next-active-slide');s.$slider.trigger('avia-transition-done')};t.trigger('pause');if(!i.data('disableAutoplay')){if(i.hasClass('av-video-lazyload')&&!i.hasClass('av-video-lazyload-complete')){i.find('.av-click-to-play-overlay').trigger('click')}
else{i.trigger('play')}};i.addClass('next-active-slide');if(s.options.fullfade==!0){t.avia_animate({opacity:0},200,'linear',function(){i.css(e).avia_animate({opacity:1},s.options.transitionSpeed,'linear',a)})}
else{if(s.current===0){t.avia_animate({opacity:0},s.options.transitionSpeed/2,'linear');i.css(e).avia_animate({opacity:1},s.options.transitionSpeed/2,'linear',a)}
else{i.css(e).avia_animate({opacity:1},s.options.transitionSpeed/2,'linear',function(){t.avia_animate({opacity:0},200,'linear',a)})}}},_attach_video_events:function(){var s=this,t=i('html');s.$slides.each(function(t){var n=i(this),r=n.find('.caption_fullwidth, .av-click-overlay'),d=n.find('.mejs-mediaelement'),l=n.hasClass('av-video-lazyload')?!0:!1;if(n.data('avia_video_events')!=!0){n.data('avia_video_events',!0);n.on('av-video-events-bound',{slide:n,wrap:d,iteration:t,self:s,lazyload:l},e);n.on('av-video-ended',{slide:n,self:s},a);n.on('av-video-play-executed',function(){setTimeout(function(){s.pause()},100)});r.on('click',{slide:n},o);if(n.is('.av-video-events-bound')){n.trigger('av-video-events-bound')};if(l&&t===0&&!n.data('disableAutoplay')){n.find('.av-click-to-play-overlay').trigger('click')}}});function e(i){if(i.data.iteration===0){i.data.wrap.css('opacity',0);if(!i.data.self.isMobile&&!i.data.slide.data('disableAutoplay')){i.data.slide.trigger('play')}; ;setTimeout(function(){i.data.wrap.avia_animate({opacity:1},400)},50)}
else if(t.is('.avia-msie')&&!i.data.slide.is('.av-video-service-html5')){if(!i.data.slide.data('disableAutoplay')){i.data.slide.trigger('play')}};if(i.data.slide.is('.av-video-service-html5')&&i.data.iteration!==0){i.data.slide.trigger('pause')};if(i.data.lazyload){i.data.slide.addClass('av-video-lazyload-complete');i.data.slide.trigger('play')}};function a(i){if(!i.data.slide.is('.av-single-slide')&&!i.data.slide.is('.av-loop-video')){i.data.slide.trigger('reset');s._navigate('next');s.resume()};if(i.data.slide.is('.av-loop-video')&&i.data.slide.is('.av-video-service-html5')){if(t.is('.avia-safari-8')){setTimeout(function(){i.data.slide.trigger('play')},1)}}};function o(i){if(i.target.tagName!='A'){i.data.slide.trigger('toggle')}}},_timer:function(i,s,o){var t=this,e,a=s;t.timerId=0;this.pause=function(){window.clearTimeout(t.timerId);a-=new Date()-e};this.resume=function(){e=new Date();t.timerId=window.setTimeout(i,a)};this.destroy=function(){window.clearTimeout(t.timerId)};this.resume(!0)},_startSlideshow:function(){var i=this;this.isPlaying=!0;this.slideshow=new this._timer(function(){i._navigate('next');if(i.options.autoplay){i._startSlideshow()}},(this.options.interval*1000))},_stopSlideshow:function(){if(this.options.autoplay){this.slideshow.destroy();this.isPlaying=!1;this.options.autoplay=!1};this.options.autoplay=!1;this.options.loop_autoplay='once';this.$slider.removeClass('av-slideshow-autoplay').addClass('av-slideshow-manual');this.$slider.removeClass('av-loop-endless').addClass('av-loop-once')},_setPermaCaptionPointer:function(s){if(!this.permaCaption.length){return};var t=i(this.$slides[this.current]).find('a').length;this.permaCaption.css('cursor',t?'pointer':'default')},_routePermaCaptionClick:function(s){var t=i(this).siblings('.avia-slideshow-inner').find('>.active-slide a');if(t.length){s.preventDefault();t[0].click()}},next:function(i){i.preventDefault();this._stopSlideshow();this._navigate('next')},previous:function(i){i.preventDefault();this._stopSlideshow();this._navigate('prev')},go2:function(i){if(isNaN(i)){i.preventDefault();i=i.currentTarget.hash.replace('#','')};i-=1;if(i===this.current||i>=this.itemsCount||i<0){return!1};this._stopSlideshow();this._navigate(!1,i)},play:function(){if(!this.isPlaying){this.isPlaying=!0;this._navigate('next');this.options.autoplay=!0;this._startSlideshow()}},pause:function(){if(this.isPlaying){this.slideshow.pause()}},resume:function(){if(this.isPlaying){this.slideshow.resume()}},destroy:function(i){this.slideshow.destroy(i)}};i.fn.aviaSlider=function(s){return this.each(function(){var t=i.data(this,'aviaSlider');if(!t){t=i.data(this,'aviaSlider',new i.AviaSlider(s,this))}})}})(jQuery);(function(e){'use strict';e.AviaVideoAPI=function(i,t,o){this.videoElement=t;this.$video=e(t);this.$option_container=o?e(o):this.$video;this.load_btn=this.$option_container.find('.av-click-to-play-overlay');this.video_wrapper=this.$video.parents('ul').eq(0);this.lazy_load=this.video_wrapper.hasClass('av-show-video-on-click')?!0:!1;this.isMobile=e.avia_utilities.isMobile;this.fallback=this.isMobile?this.$option_container.is('.av-mobile-fallback-image'):!1;if(this.fallback){return};this._init(i)};e.AviaVideoAPI.defaults={loop:!1,mute:!1,controls:!1,events:'play pause mute unmute loop toggle reset unload'};e.AviaVideoAPI.apiFiles={youtube:{loaded:!1,src:'https://www.youtube.com/iframe_api'}};e.AviaVideoAPI.players={};e.AviaVideoAPI.prototype={_init:function(i){this.options=this._setOptions(i);this.type=this._getPlayerType();this.player=!1;this._bind_player();this.eventsBound=!1;this.playing=!1;this.$option_container.addClass('av-video-paused');this.pp=e.avia_utilities.playpause(this.$option_container)},_setOptions:function(i){var n=e.extend(!0,{},e.AviaVideoAPI.defaults,i),o=this.$option_container.data(),t='';for(t in o){if(o.hasOwnProperty(t)&&(typeof o[t]==='string'||typeof o[t]==='number'||typeof o[t]==='boolean')){n[t]=o[t]}};return n},_getPlayerType:function(){var e=this.$video.get(0).src||this.$video.data('src');if(this.$video.is('video')){return'html5'};if(this.$video.is('.av_youtube_frame')){return'youtube'};if(e.indexOf('vimeo.com')!=-1){return'vimeo'};if(e.indexOf('youtube.com')!=-1){return'youtube'}},_bind_player:function(){var t=this,o=e('html').hasClass('av-cookies-needs-opt-in')||e('html').hasClass('av-cookies-can-opt-out'),i=!0,n=e('html').hasClass('av-cookies-user-silent-accept'),a='html5'==this.type;if(o&&!n&&!a){if(!document.cookie.match(/aviaCookieConsent/)||e('html').hasClass('av-cookies-session-refused')){i=!1}
else{if(!document.cookie.match(/aviaPrivacyRefuseCookiesHideBar/)){i=!1}
else if(!document.cookie.match(/aviaPrivacyEssentialCookiesEnabled/)){i=!1}
else if(document.cookie.match(/aviaPrivacyVideoEmbedsDisabled/)){i=!1}}};if(window['wp']&&wp.hooks){i=wp.hooks.applyFilters('aviaCookieConsent_allow_continue',i)};let allow_class=i?'avia-video-cookie-allowed':'avia-video-cookie-not-allowed';e('html').addClass(allow_class);if(!i){this._use_external_link();return};if(this.lazy_load&&this.load_btn.length&&this.type!='html5'){this.$option_container.addClass('av-video-lazyload');this.load_btn.on('click',function(){t.load_btn.remove();t._setPlayer()})}
else{this.lazy_load=!1;this._setPlayer()}},_use_external_link:function(){this.$option_container.addClass('av-video-lazyload');this.load_btn.on('click',function(i){if(i.originalEvent===undefined)return;var t=e(this).parents('.avia-slide-wrap').find('div[data-original_url]').data('original_url');if(t)window.open(t,'_blank')})},_setPlayer:function(){var t=this;switch(this.type){case'html5':this.player=this.$video.data('mediaelementplayer');if(!this.player){this.$video.data('mediaelementplayer',e.AviaVideoAPI.players[this.$video.attr('id').replace(/_html5/,'')]);this.player=this.$video.data('mediaelementplayer')};this._playerReady();break;case'vimeo':var i=document.createElement('iframe');var o=e(i);i.onload=function(){t.player=Froogaloop(i);t._playerReady();t.$option_container.trigger('av-video-loaded')};i.setAttribute('src',this.$video.data('src'));o.insertAfter(this.$video);this.$video.remove();this.$video=i;break;case'youtube':this._getAPI(this.type);e('body').on('av-youtube-iframe-api-loaded',function(){t._playerReady()});break}},_getAPI:function(i){if(e.AviaVideoAPI.apiFiles[i].loaded===!1){e.AviaVideoAPI.apiFiles[i].loaded=!0;var t=document.createElement('script'),o=document.getElementsByTagName('script')[0];t.src=e.AviaVideoAPI.apiFiles[i].src;o.parentNode.insertBefore(t,o)}},_playerReady:function(){var i=this;this.$option_container.on('av-video-loaded',function(){i._bindEvents()});switch(this.type){case'html5':this.$video.on('av-mediajs-loaded',function(){i.$option_container.trigger('av-video-loaded')});this.$video.on('av-mediajs-ended',function(){i.$option_container.trigger('av-video-ended')});break;case'vimeo':i.player.addEvent('ready',function(){i.$option_container.trigger('av-video-loaded');i.player.addEvent('finish',function(){i.$option_container.trigger('av-video-ended')})});break;case'youtube':var t=i.$video.data();if(i._supports_video()){t.html5=1};i.player=new YT.Player(i.$video.attr('id'),{videoId:t.videoid,height:i.$video.attr('height'),width:i.$video.attr('width'),playerVars:t,events:{'onReady':function(){i.$option_container.trigger('av-video-loaded')},'onError':function(i){e.avia_utilities.log('YOUTUBE ERROR:','error',i)},'onStateChange':function(e){if(e.data===YT.PlayerState.ENDED){var t=i.options.loop!=!1?'loop':'av-video-ended';i.$option_container.trigger(t)}}}});break};setTimeout(function(){if(i.eventsBound==!0||typeof i.eventsBound=='undefined'||i.type=='youtube'){return};e.avia_utilities.log('Fallback Video Trigger "'+i.type+'":','log',i);i.$option_container.trigger('av-video-loaded')},2000)},_bindEvents:function(){if(this.eventsBound==!0||typeof this.eventsBound=='undefined'){return};var e=this,i='unmute';this.eventsBound=!0;this.$option_container.on(this.options.events,function(i){e.api(i.type)});if(!e.isMobile){if(this.options.mute!=!1){i='mute'};if(this.options.loop!=!1){e.api('loop')};e.api(i)};setTimeout(function(){e.$option_container.trigger('av-video-events-bound').addClass('av-video-events-bound')},50)},_supports_video:function(){return!!document.createElement('video').canPlayType},api:function(e){if(this.isMobile&&!this.was_started())return;if(this.options.events.indexOf(e)===-1)return;this.$option_container.trigger('av-video-'+e+'-executed');if(typeof this['_'+this.type+'_'+e]=='function'){this['_'+this.type+'_'+e].call(this)};if(typeof this['_'+e]=='function'){this['_'+e].call(this)}},was_started:function(){if(!this.player)return!1;switch(this.type){case'html5':if(this.player.getCurrentTime()>0){return!0};break;case'vimeo':if(this.player.api('getCurrentTime')>0){return!0};break;case'youtube':if(this.player.getPlayerState()!==-1){return!0};break};return!1},_play:function(){this.playing=!0;this.$option_container.addClass('av-video-playing').removeClass('av-video-paused')},_pause:function(){this.playing=!1;this.$option_container.removeClass('av-video-playing').addClass('av-video-paused')},_loop:function(){this.options.loop=!0},_toggle:function(){var e=this.playing==!0?'pause':'play';this.api(e);this.pp.set(e)},_vimeo_play:function(){this.player.api('play')},_vimeo_pause:function(){this.player.api('pause')},_vimeo_mute:function(){this.player.api('setVolume',0)},_vimeo_unmute:function(){this.player.api('setVolume',0.7)},_vimeo_loop:function(){},_vimeo_reset:function(){this.player.api('seekTo',0)},_vimeo_unload:function(){this.player.api('unload')},_youtube_play:function(){this.player.playVideo()},_youtube_pause:function(){this.player.pauseVideo()},_youtube_mute:function(){this.player.mute()},_youtube_unmute:function(){this.player.unMute()},_youtube_loop:function(){if(this.playing==!0)this.player.seekTo(0)},_youtube_reset:function(){this.player.stopVideo()},_youtube_unload:function(){this.player.clearVideo()},_html5_play:function(){if(this.player){this.player.options.pauseOtherPlayers=!1;this.player.play()}},_html5_pause:function(){if(this.player)this.player.pause()},_html5_mute:function(){if(this.player)this.player.setMuted(!0)},_html5_unmute:function(){if(this.player)this.player.setVolume(0.7)},_html5_loop:function(){if(this.player)this.player.options.loop=!0},_html5_reset:function(){if(this.player)this.player.setCurrentTime(0)},_html5_unload:function(){this._html5_pause();this._html5_reset()}};e.fn.aviaVideoApi=function(i,t){return this.each(function(){var o=this;if(t){o=e(this).parents(t).get(0)};var n=e.data(o,'aviaVideoApi');if(!n){n=e.data(o,'aviaVideoApi',new e.AviaVideoAPI(i,this,o))}})}})(jQuery);window.onYouTubeIframeAPIReady=function(){jQuery('body').trigger('av-youtube-iframe-api-loaded')};var Froogaloop=(function(){function i(e){return new i.fn.init(e)};var e={},d=!1,t=!1,p=Array.prototype.slice,o='*';i.fn=i.prototype={element:null,init:function(e){if(typeof e==='string'){e=document.getElementById(e)};this.element=e;return this},api:function(e,i){if(!this.element||!e){return!1};var o=this,t=o.element,l=t.id!==''?t.id:null,u=!r(i)?i:null,a=r(i)?i:null;if(a){s(e,a,l)};n(e,u,t);return o},addEvent:function(e,i){if(!this.element){return!1};var a=this,o=a.element,r=o.id!==''?o.id:null;s(e,i,r);if(e!='ready'){n('addEventListener',e,o)}
else if(e=='ready'&&t){i.call(null,r)};return a},removeEvent:function(e){if(!this.element){return!1};var t=this,i=t.element,o=i.id!==''?i.id:null,a=u(e,o);if(e!='ready'&&a){n('removeEventListener',e,i)}}};function n(e,i,t){if(!t.contentWindow.postMessage){return!1};var n=JSON.stringify({method:e,value:i});t.contentWindow.postMessage(n,o)};function a(e){var i,r;try{i=JSON.parse(e.data);r=i.event||i.method}catch(p){};if(r=='ready'&&!t){t=!0};if(!(/^https?:\/\/player.vimeo.com/).test(e.origin)){return!1};if(o==='*'){o=e.origin};var u=i.value,d=i.data,a=a===''?null:i.player_id,s=l(r,a),n=[];if(!s){return!1};if(u!==undefined){n.push(u)};if(d){n.push(d)};if(a){n.push(a)};return n.length>0?s.apply(null,n):s.call()};function s(i,t,o){if(o){if(!e[o]){e[o]={}};e[o][i]=t}
else{e[i]=t}};function l(i,t){if(t&&e[t]&&e[t][i]){return e[t][i]}
else{return e[i]}};function u(i,t){if(t&&e[t]){if(!e[t][i]){return!1};e[t][i]=null}
else{if(!e[i]){return!1};e[i]=null};return!0};function r(e){return!!(e&&e.constructor&&e.call&&e.apply)};function h(e){return toString.call(e)==='[object Array]'};i.fn.init.prototype=i.fn;if(window.addEventListener){window.addEventListener('message',a,!1)}
else{window.attachEvent('onmessage',a)};return(window.Froogaloop=window.$f=i)})();(function(t){'use strict';t.fn.avia_sc_tabs=function(e){var a={heading:'.tab',content:'.tab_content',active:'active_tab',sidebar:!1};var i=t(window),e=t.extend(a,e);return this.each(function(){var a=t(this),c=t('<div class="tab_titles" role="tablist"></div>').prependTo(a),n=t(e.heading,a),r=t(e.content,a),o=!1,d=!1;o=n.clone();d=n.addClass('fullsize-tab').attr({'aria-hidden':!0,'aria-selected':!1,id:'',role:'','aria-controls':'',tabindex:0});n=o;n.prependTo(c).each(function(e){var a=t(this),i=!1;if(o){i=d.eq(e)};a.addClass('tab_counter_'+e).attr({tab_counter:e}).on('click',function(){l(a,e,i);return!1});a.on('keydown',function(t){if(t.keyCode===13){a.trigger('click')}});if(o){i.on('click',function(){l(i,e,a);return!1});i.on('keydown',function(t){if(t.keyCode===13){i.trigger('click')}})}});s();f(!1);i.on('debouncedresize',s);t('a').on('click',function(){var e=t(this).attr('href');if(typeof e!='undefined'&&e){e=e.replace(/^.*?#/,'');f('#'+e)}});function s(){if(!e.sidebar){return};r.css({'min-height':c.outerHeight()+1})};function l(n,l,o){if(!n.is('.'+e.active)){t('.'+e.active,a).removeClass(e.active).attr({'aria-selected':!1,tabindex:0});t('.'+e.active+'_content',a).removeClass(e.active+'_content').attr('aria-hidden',!0);n.addClass(e.active).attr({'aria-selected':!0,tabindex:0});var s=n.data('fake-id');if(typeof s=='string'){window.location.replace(s)};if(o){o.addClass(e.active)};var d=r.eq(l).addClass(e.active+'_content').attr('aria-hidden',!1);if(typeof click_container!='undefined'&&click_container.length){sidebar_shadow.height(d.outerHeight())};var c=d.offset().top,f=c-50-parseInt(t('html').css('margin-top'),10);if(i.scrollTop()>c){t('html:not(:animated),body:not(:animated)').scrollTop(f)}};i.trigger('av-content-el-height-changed',n)};function f(t){if(!t&&window.location.hash){t=window.location.hash};if(!t){return};var e=n.filter('[data-fake-id="'+t+'"]');if(e.length){if(!e.is('.active_tab')){e.trigger('click')};window.scrollTo(0,a.offset().top-70)}}})}}(jQuery));(function(i){'use strict';i('body').on('click','.av-lazyload-video-embed .av-click-to-play-overlay',function(l){var n=i(this),d=i('html').hasClass('av-cookies-needs-opt-in')||i('html').hasClass('av-cookies-can-opt-out'),e=!0,c=i('html').hasClass('av-cookies-user-silent-accept');if(d&&!c){if(!document.cookie.match(/aviaCookieConsent/)||i('html').hasClass('av-cookies-session-refused')){e=!1}
else{if(!document.cookie.match(/aviaPrivacyRefuseCookiesHideBar/)){e=!1}
else if(!document.cookie.match(/aviaPrivacyEssentialCookiesEnabled/)){e=!1}
else if(document.cookie.match(/aviaPrivacyVideoEmbedsDisabled/)){e=!1}}};if(window['wp']&&wp.hooks){e=wp.hooks.applyFilters('aviaCookieConsent_allow_continue',e)};var a=n.parents('.av-lazyload-video-embed');if(a.hasClass('avia-video-lightbox')&&a.hasClass('avia-video-standard-html')){e=!0};if(!e){if(typeof l.originalEvent=='undefined'){return};var t=a.data('original_url');if(t)window.open(t,'_blank','noreferrer noopener');return};var s=a.find('.av-video-tmpl').html(),o='';if(a.hasClass('avia-video-lightbox')){o=a.find('a.lightbox-link');if(o.length==0){a.append(s);setTimeout(function(){o=a.find('a.lightbox-link');if(i('html').hasClass('av-default-lightbox')){o.addClass('lightbox-added').magnificPopup(i.avia_utilities.av_popup);o.trigger('click')}
else{o.trigger('avia-open-video-in-lightbox')}},100)}
else{o.trigger('click')}}
else{a.html(s)}});i('.av-lazyload-immediate .av-click-to-play-overlay').trigger('click')}(jQuery));(function(e){'use strict';e(function(){e.avia_utilities=e.avia_utilities||{};if('undefined'==typeof e.avia_utilities.isMobile){if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)&&'ontouchstart' in document.documentElement){e.avia_utilities.isMobile=!0}
else{e.avia_utilities.isMobile=!1}};i();e(window).trigger('resize')});e.avia_utilities=e.avia_utilities||{};function i(){var m=e('#header'),u=e('#main .av-logo-container'),h=e('#avia-menu'),l=e('.av-burger-menu-main a'),a=e('html').eq(0),n=e('<div class="av-burger-overlay" role="menu" aria-orientation="vertical"></div>'),p=e('<div class="av-burger-overlay-scroll"></div>').appendTo(n),g=e('<div class="av-burger-overlay-inner"></div>').appendTo(p),k=e('<div class="av-burger-overlay-bg"></div>').appendTo(n),r=!1,v={},b=e('.av-logo-container .inner-container'),C=b.find('.main_menu'),d=a.is('.html_av-submenu-display-click.html_av-submenu-clone, .html_av-submenu-display-hover.html_av-submenu-clone'),y=!1,T=0;if(!a.hasClass('html_av-submenu-hidden')){a.addClass('html_av-submenu-visible')};var f=e('#avia_alternate_menu');if(f.length>0){h=f};var c=function(){if(e.avia_utilities.isMobile){p.outerHeight(window.innerHeight)}},o=function(i,u){if(!i){return};var c,s,t,r,v,f,m,a,n;i.each(function(){t=e(this);r=t.find(' > .sub-menu > li');if(r.length==0){r=t.find(' > .children > li')};v=t.find('.avia_mega_div > .sub-menu > li.menu-item');var i=t.find('>a'),c=!0;if(i.length){if(i.get(0).hash=='#'||'undefined'==typeof i.attr('href')||i.attr('href')=='#'){if(r.length>0||v.length>0){c=!1}}};s=i.clone(c).attr('style','');if('undefined'==typeof i.attr('href')){s.attr('href','#')};a=e('<li>').append(s);a.attr('role','menuitem');var l=[];if('undefined'!=typeof t.attr('class')){l=t.attr('class').split(/\s+/);e.each(l,function(e,i){if((i.indexOf('menu-item')!=0)&&(i.indexOf('page-item')<0)&&(i.indexOf('page_item')!=0)&&(i.indexOf('dropdown_ul')<0)){a.addClass(i)};return!0})};if('undefined'!=typeof t.attr('id')&&''!=t.attr('id')){a.addClass(t.attr('id'))}
else{e.each(l,function(e,i){if(i.indexOf('page-item-')>=0){a.addClass(i);return!1}})};u.append(a);if(r.length){n=e('<ul class="sub-menu">').appendTo(a);if(d&&(s.get(0).hash!='#'&&s.attr('href')!='#')){a.clone(!0).prependTo(n)};a.addClass('av-width-submenu').find('>a').append('<span class="av-submenu-indicator">');o(r,n)}
else if(v.length){n=e('<ul class="sub-menu">').appendTo(a);if(d&&(s.get(0).hash!='#'&&s.attr('href')!='#')){a.clone(!0).prependTo(n)};v.each(function(i){var v=e(this),t=v.find('> .sub-menu'),s=v.find('> .mega_menu_title'),c=s.find('a').attr('href')||'#',r=t.length>0?t.find('>li'):null,f=!1,l=a.find('>a'),m='';if((r===null)||(r.length==0)){if(c=='#'){m=' style="display: none;"'}};if(i==0)a.addClass('av-width-submenu').find('>a').append('<span class="av-submenu-indicator">');if(s.length&&s.text()!=''){f=!0;if(i>0){var u=a.parents('li').eq(0);if(u.length)a=u;n=e('<ul class="sub-menu">').appendTo(a)};a=e('<li'+m+'>').appendTo(n);n=e('<ul class="sub-menu">').appendTo(a);e('<a href="'+c+'"><span class="avia-bullet"></span><span class="avia-menu-text">'+s.text()+'</span></a>').insertBefore(n);l=a.find('>a');if(d&&(t.length>0)&&(l.length&&l.get(0).hash!='#'&&l.attr('href')!='#')){a.clone(!0).addClass('av-cloned-title').prependTo(n)}};if(f&&(t.length>0)){a.addClass('av-width-submenu').find('>a').append('<span class="av-submenu-indicator">')};o(r,n)})}});l.trigger('avia_burger_list_created');return c},s,i;e('body').on('mousewheel DOMMouseScroll touchmove','.av-burger-overlay-scroll',function(e){var n=this.offsetHeight,i=this.scrollHeight,a=e.originalEvent.wheelDelta;if(i!=this.clientHeight){if((this.scrollTop>=(i-n)&&a<0)||(this.scrollTop<=0&&a>0)){e.preventDefault()}}
else{e.preventDefault()}});e(document).on('mousewheel DOMMouseScroll touchmove','.av-burger-overlay-bg, .av-burger-overlay-active .av-burger-menu-main',function(e){e.preventDefault()});var t={};e(document).on('touchstart','.av-burger-overlay-scroll',function(e){t.Y=e.originalEvent.touches[0].clientY});e(document).on('touchend','.av-burger-overlay-scroll',function(e){t={}});e(document).on('touchmove','.av-burger-overlay-scroll',function(i){if(!t.Y){t.Y=i.originalEvent.touches[0].clientY};var l=i.originalEvent.touches[0].clientY-t.Y,a=this,n=a.scrollTop,r=a.scrollHeight,o=n+a.offsetHeight,s=l>0?'up':'down';e('body').get(0).scrollTop=t.body;if(n<=0){if(s=='up'){i.preventDefault()}}
else if(o>=r){if(s=='down'){i.preventDefault()}}});e(window).on('debouncedresize',function(n){var s=!0;if(e.avia_utilities.isMobile&&a.hasClass('av-mobile-menu-switch-portrait')&&a.hasClass('html_text_menu_active')){var t=e(window).height(),o=e(window).width();if(o<=t){a.removeClass('html_burger_menu')}
else{var r=a.hasClass('html_mobile_menu_phone')?768:990;if(t<r){a.addClass('html_burger_menu');s=!1}
else{a.removeClass('html_burger_menu')}}};if(s&&i&&i.length){if(!l.is(':visible')){i.filter('.is-active').parents('a').eq(0).trigger('click')}};c()});e('.html_av-overlay-side').on('click','.av-burger-overlay-bg',function(e){e.preventDefault();i.parents('a').eq(0).trigger('click')});e(window).on('avia_smooth_scroll_start',function(){if(i&&i.length){i.filter('.is-active').parents('a').eq(0).trigger('click')}});e('.html_av-submenu-display-hover').on('mouseenter','.av-width-submenu',function(i){e(this).children('ul.sub-menu').slideDown('fast')});e('.html_av-submenu-display-hover').on('mouseleave','.av-width-submenu',function(i){e(this).children('ul.sub-menu').slideUp('fast')});e('.html_av-submenu-display-hover').on('click','.av-width-submenu > a',function(e){e.preventDefault();e.stopImmediatePropagation()});e('.html_av-submenu-display-hover').on('touchstart','.av-width-submenu > a',function(i){var a=e(this);w(a,i)});e('.html_av-submenu-display-click').on('click','.av-width-submenu > a',function(i){var a=e(this);w(a,i)});e('.html_av-submenu-display-click, .html_av-submenu-visible').on('click','.av-burger-overlay a',function(a){var n=window.location.href.match(/(^[^#]*)/)[0],t=e(this).attr('href').match(/(^[^#]*)/)[0];if(t==n){a.preventDefault();a.stopImmediatePropagation();i.parents('a').eq(0).trigger('click');return!1};return!0});function w(e,i){i.preventDefault();i.stopImmediatePropagation();var a=e.parents('li').eq(0);a.toggleClass('av-show-submenu');if(a.is('.av-show-submenu')){a.children('ul.sub-menu').slideDown('fast')}
else{a.children('ul.sub-menu').slideUp('fast')}};(function(){if(C.length){return};var i=e('#header .main_menu').clone(!0),t=i.find('ul.av-main-nav'),n=t.attr('id');if('string'==typeof n&&''!=n.trim()){t.attr('id',n+'-'+T++)};i.find('.menu-item:not(.menu-item-avia-special)').remove();i.insertAfter(b.find('.logo').first());var a=e('#header .social_bookmarks').clone(!0);if(!a.length){a=e('.av-logo-container .social_bookmarks').clone(!0)};if(a.length){i.find('.avia-menu').addClass('av_menu_icon_beside');i.append(a)};l=e('.av-burger-menu-main a')}());l.on('click',function(t){if(r){return};i=e(this).find('.av-hamburger'),r=!0;if(!y){y=!0;i.addClass('av-inserted-main-menu');s=e('<ul>').attr({id:'av-burger-menu-ul',class:'','aria-haspopup':'true','aria-controls':'menu2'});var d=h.find('> li:not(.menu-item-avia-special)'),f=o(d,s);s.find('.noMobile').remove();s.appendTo(g);v=g.find('#av-burger-menu-ul > li');if(e.fn.avia_smoothscroll){e('a[href*="#"]',n).avia_smoothscroll(n)}};if(i.is('.is-active')){i.removeClass('is-active');a.removeClass('av-burger-overlay-active-delayed');n.animate({opacity:0},function(){n.css({display:'none'});a.removeClass('av-burger-overlay-active');r=!1})}
else{c();var l=u.length?u.outerHeight()+u.position().top:m.outerHeight()+m.position().top;n.appendTo(e(t.target).parents('.avia-menu'));s.css({padding:(l)+'px 0px'});v.removeClass('av-active-burger-items');i.addClass('is-active');a.addClass('av-burger-overlay-active');n.css({display:'block'}).animate({opacity:1},function(){r=!1});setTimeout(function(){a.addClass('av-burger-overlay-active-delayed')},100);v.each(function(i){var a=e(this);setTimeout(function(){a.addClass('av-active-burger-items')},(i+1)*125)})};t.preventDefault()})}})(jQuery);(function(t){'use strict';t.avia_utilities=t.avia_utilities||{};t(function(){if(t.fn.avia_parallax){t('.av-parallax,.av-parallax-object').avia_parallax()}});var i=function(i,e){if(!(this.transform||this.transform3d)){return};this.options=t.extend({},i);this.win=t(window);this.body=t('body');this.isMobile=t.avia_utilities.isMobile,this.winHeight=this.win.height();this.winWidth=this.win.width();this.el=t(e).addClass('active-parallax');this.objectType=this.el.hasClass('av-parallax-object')?'object':'background-image';this.elInner=this.el;this.elBackgroundParent=this.el.parent();this.elParallax=this.el.data('parallax')||{};this.direction='';this.speed=0.5;this.elProperty={};this.ticking=!1,this.isTransformed=!1;if(t.avia_utilities.supported.transition===undefined){t.avia_utilities.supported.transition=t.avia_utilities.supports('transition')};this._init(i)};i.prototype={mediaQueries:{'av-mini-':'(max-width: 479px)','av-small-':'(min-width: 480px) and (max-width: 767px)','av-medium-':'(min-width: 768px) and (max-width: 989px)','av-desktop-':'(min-width: 990px)'},transform:document.documentElement.className.indexOf('avia_transform')!==-1,transform3d:document.documentElement.className.indexOf('avia_transform3d')!==-1,mobileNoAnimation:t('body').hasClass('avia-mobile-no-animations'),defaultSpeed:0.5,defaultDirections:['bottom_top','left_right','right_left','no_parallax'],transformCSSProps:['transform','-webkit-transform','-moz-transform','-ms-transform','-o-transform'],matrixDef:[1,0,0,1,0,0],matrix3dDef:[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],_init:function(){var t=this;if(typeof this.el.data('parallax-selector')!='undefined'&&this.el.data('parallax-selector')!==''){this.elInner=this.el.find(this.el.data('parallax-selector'));if(this.elInner.length==0){this.elInner=this.el}};if('background-image'==this.objectType){if(this.isMobile&&this.mobileNoAnimation){return};this.elParallax.parallax='bottom_top';this.elParallax.parallax_speed=parseFloat(this.el.data('avia-parallax-ratio'))||0.5};setTimeout(function(){t._fetchProperties()},30);this.win.on('debouncedresize av-height-change',t._fetchProperties.bind(t));this.body.on('av_resize_finished',t._fetchProperties.bind(t));setTimeout(function(){t.win.on('scroll',t._onScroll.bind(t))},100)},_setParallaxProps:function(){if('background-image'==this.objectType){this.direction=this.elParallax.parallax;this.speed=this.elParallax.parallax_speed;return};var e=this.elParallax.parallax||'',s=this.elParallax.parallax_speed||'',i='',a='',r='all';if(this.defaultDirections.indexOf(e)<0){e='no_parallax'};if(typeof window.matchMedia=='function'){t.each(this.mediaQueries,function(t,i){var e=window.matchMedia(i);if(e.matches){r=t;return!1}})};if('all'==r){this.direction=e;this.speed=''==s?this.defaultSpeed:parseFloat(s)/100.0;return};i=this.elParallax[r+'parallax']||'';a=this.elParallax[r+'parallax_speed']||'';if('inherit'==i){i=e;a=s};if(this.defaultDirections.indexOf(i)<0){i='no_parallax'};this.direction=i;this.speed=''==a?this.defaultSpeed:parseFloat(a)/100.0},_getTranslateObject:function(e){var i={type:'',matrix:[],x:0,y:0,z:0};t.each(this.transformCSSProps,function(t,s){var r=e.css(s);if('string'!=typeof r||'none'==r){return};if(r.indexOf('matrix')>=0){var a=r.match(/matrix.*\((.+)\)/)[1].split(', ');if(r.indexOf('matrix3d')>=0){i.type='3d';i.matrix=a;i.x=a[12];i.y=a[13];i.z=a[14]}
else{i.type='2d';i.matrix=a;i.x=a[4];i.y=a[5]};return!1}
else{i.type='';var n=r.match(/translateX\((-?\d+\.?\d*px)\)/);if(n){i.x=parseInt(n[1],10)};var l=r.match(/translateY\((-?\d+\.?\d*px)\)/);if(l){i.y=parseInt(l[1],10)}}});return i},_getTranslateMatrix:function(i,r){var s='';t.each(r,function(t,e){i[t]=e});if(this.transform3d){var e=this.matrix3dDef.slice(0);switch(i.type){case'2d':e[0]=i.matrix[0];e[1]=i.matrix[1];e[4]=i.matrix[2];e[5]=i.matrix[3];e[12]=i.x;e[13]=i.y;break;case'3d':e=i.matrix.slice(0);e[12]=i.x;e[13]=i.y;e[14]=i.z;break;default:e[12]=i.x;e[13]=i.y;break};s='matrix3d('+e.join(', ')+')'}
else if(this.transform){var a=this.matrixDef.slice(0);switch(i.type){case'2d':a=i.matrix.slice(0);a[4]=i.x;a[5]=i.y;break;case'3d':a[0]=i.matrix[0];a[1]=i.matrix[1];a[2]=i.matrix[4];a[3]=i.matrix[5];a[4]=i.x;a[5]=i.y;break;default:a[4]=i.x;a[5]=i.y;break};s='matrix('+a.join(', ')+')'};return s},_fetchProperties:function(){this._setParallaxProps();this.el.css(t.avia_utilities.supported.transition+'transform','');this.winHeight=this.win.height();this.winWidth=this.win.width();if('background-image'==this.objectType){this.elProperty.top=this.elBackgroundParent.offset().top;this.elProperty.height=this.elBackgroundParent.outerHeight();this.el.height(Math.ceil((this.winHeight*Math.abs(this.speed))+this.elProperty.height))}
else{this.elProperty.top=this.elInner.offset().top;this.elProperty.left=this.elInner.offset().left;this.elProperty.height=this.elInner.outerHeight();this.elProperty.width=this.elInner.outerWidth();this.elProperty.bottom=this.elProperty.top+this.elProperty.height;this.elProperty.right=this.elProperty.left+this.elProperty.width;this.elProperty.distanceLeft=this.elProperty.right;this.elProperty.distanceRight=this.winWidth-this.elProperty.left};this.elProperty.translateObj=this._getTranslateObject(this.el);this._parallaxScroll()},_onScroll:function(t){var i=this;if(!i.ticking){i.ticking=!0;window.requestAnimationFrame(i._parallaxRequest.bind(i))}},_inViewport:function(t,i,e,a,r,s,l,n){return!(t>s+10||e<r-10||a>n+10||i<l-10)},_parallaxRequest:function(t){var i=this;setTimeout(i._parallaxScroll.bind(i),0)},_parallaxScroll:function(i){if(('no_parallax'==this.direction||''==this.direction)&&!this.isTransformed){this.ticking=!1;return};var l=this.win.scrollTop(),o=this.win.scrollLeft(),d=o+this.winWidth,s=l+this.winHeight,e=0,a='';if('background-image'==this.objectType){if(this.elProperty.top<s&&l<=this.elProperty.top+this.elProperty.height){e=Math.ceil((s-this.elProperty.top)*this.speed);a=this._getTranslateMatrix(this.elProperty.translateObj,{y:e});this.el.css(t.avia_utilities.supported.transition+'transform',a)};this.ticking=!1;return};if(('no_parallax'==this.direction||''==this.direction)){a=this._getTranslateMatrix(this.elProperty.translateObj,{x:0,y:0});this.el.css(t.avia_utilities.supported.transition+'transform',a);this.ticking=!1;this.isTransformed=!1;return};var x=Math.ceil(this.elProperty.top-l),p=Math.ceil(s-this.elProperty.top),n=0,h=0,r={x:0,y:0};if(this.elProperty.top<this.winHeight){h=Math.ceil(this.winHeight-this.elProperty.top)};if(this.elProperty.top>s){n=0;p=0}
else{n=1-(x+h)/this.winHeight};switch(this.direction){case'bottom_top':e=Math.ceil((p-h)*this.speed);r.y=-e;a=this._getTranslateMatrix(this.elProperty.translateObj,{y:-e});break;case'left_right':e=Math.ceil(this.elProperty.distanceRight*n*this.speed);r.x=e;a=this._getTranslateMatrix(this.elProperty.translateObj,{x:e});break;case'right_left':e=Math.ceil(this.elProperty.distanceLeft*n*this.speed);r.x=-e;a=this._getTranslateMatrix(this.elProperty.translateObj,{x:-e});break;default:break};var f=this._inViewport(this.elProperty.top,this.elProperty.right,this.elProperty.bottom,this.elProperty.left,l,s,o,d),c=this._inViewport(this.elProperty.top+r.y,this.elProperty.right+r.x,this.elProperty.bottom+r.y,this.elProperty.left+r.x,l,s,o,d);if(f||c){this.el.css(t.avia_utilities.supported.transition+'transform',a)};this.ticking=!1;this.isTransformed=!0}};t.fn.avia_parallax=function(e){return this.each(function(){var a=t(this),r=a.data('aviaParallax');if(!r){r=a.data('aviaParallax',new i(e,this))}})}})(jQuery);'use strict';var avia_js_shortcodes=avia_js_shortcodes||{};var aviaJS=aviaJS||{};(function(){if(!avia_js_shortcodes.aviaFoldUnfoldSection){class avFoldUnfoldSection{container=null;id='';settings={};button=[];foldContainer=[];folded=!1;preview=!1;innerDimension={};textblock=[];multiColumsTextblock=!1;gridRow=[];colorSection=[];column=[];constructor(container){this.container=container;this.container.avFoldUnfoldSection=this;this.id=container.getAttribute('id');this.init()};init(){this.settings=JSON.parse(this.container.dataset.fold_unfold);this.preview=document.getElementById('av-admin-preview')!=null;this.moveIntoFoldContainer();if(!this.button.length||!this.foldContainer.length||this.checkMissingInnerContainers()){return};if(this.isNested()){this.container.classList.remove('avia-fold-init');this.foldContainer[0].classList.remove('unfolded','folded');this.foldContainer[0].style['max-height']='unset';this.button[0].remove();return};this.foldContainer[0].style['max-height']=this.settings.height+'px';this.foldContainer[0].classList.add('folded');this.foldContainer[0].classList.remove('unfolded');this.folded=!0;this.container.classList.add('avia-fold-init-done');this.getMaxHeight();this.foldChanged();this.bindEvents();this.container.classList.remove('avia-fold-init')};moveIntoFoldContainer(){if(this.container.hasChildNodes()){let children=this.container.childNodes;for(const child of children){if(child.classList){if(child.classList.contains('av-fold-unfold-container')){this.foldContainer[0]=child};if(child.classList.contains('av-fold-button-wrapper')){const btn=child.getElementsByClassName('av-fold-button-container');if(btn.length){this.button[0]=btn[0]}}}}};let move=null;if(this.settings.context=='avia_sc_text'){let el=this.foldContainer[0].nextSibling;while(el){if(el.classList&&el.classList.contains('avia_textblock')){move=el;break};el=el.nextSibling}}
else if(this.settings.context=='avia_sc_columns'){let el=this.foldContainer[0].nextSibling;this.column=this.foldContainer[0].getElementsByClassName('av-fold-unfold-inner');if(this.column.length){while(el){if(el.classList&&el.classList.contains('av-fold-button-wrapper')){el=el.nextSibling}
else{const next=el.nextSibling;this.column[0].append(el);el=next}}}}
else{const el=this.container.nextSibling;if(el){move=el}};if(move){this.foldContainer[0].append(move)}};checkMissingInnerContainers(){let retVal=!1;switch(this.settings.context){case'avia_sc_text':this.textblock=this.container.getElementsByClassName('avia_textblock');if(this.textblock.length==0){retVal=!0}
else{this.multiColumsTextblock=this.textblock[0].classList.contains('av_multi_colums')};break;case'avia_sc_grid_row':this.gridRow=this.container.getElementsByClassName('av-layout-grid-container');if(this.gridRow.length==0){retVal=!0};break;case'avia_sc_section':this.colorSection=this.container.getElementsByClassName('avia-section');if(this.colorSection.length==0){retVal=!0};break;case'avia_sc_columns':if(!this.column[0].childNodes.length){retVal=!0};break;default:retVal=!0};return retVal};isNested(){const parent=this.container.parentElement;if(null==parent){return!1};let closest=parent.closest('.avia-fold-unfold-section');if(closest==parent){closest=null};return closest!=null};bindEvents(){this.container.addEventListener('transitionend',this.onTransitionEnd.bind(this));this.container.addEventListener('webkitTransitionEnd',this.onTransitionEnd.bind(this));this.button[0].addEventListener('click',this.onClickFoldUnfold.bind(this));window.addEventListener('avia_fold_unfold_changed',this.onFoldUnfoldChanged.bind(this));window.addEventListener('resize',aviaJS.aviaJSHelpers.debounce(this.onResize.bind(this),200))};getMaxHeight(){switch(this.settings.context){case'avia_sc_text':this.innerDimension=this.textblock[0].getBoundingClientRect();break;case'avia_sc_grid_row':this.innerDimension=this.gridRow[0].getBoundingClientRect();break;case'avia_sc_section':this.innerDimension=this.colorSection[0].getBoundingClientRect();break;case'avia_sc_columns':this.innerDimension=this.column[0].getBoundingClientRect();break}};foldChanged(){let btnText='',btnLink='';if(this.folded){this.foldContainer[0].style['max-height']=this.settings.height+'px';btnText=this.settings.more;btnLink='#'}
else{this.getMaxHeight();this.foldContainer[0].style['max-height']=Math.ceil(this.innerDimension.height)+200+'px';btnText=this.settings.less;btnLink+='#'+this.id};this.button[0].setAttribute('href',btnLink);this.button[0].textContent=btnText;this.triggerHeightChange()};onClickFoldUnfold(event){event.preventDefault();event.stopPropagation();if(this.foldContainer[0].classList.contains('folded')){this.foldContainer[0].classList.remove('folded');this.foldContainer[0].classList.add('unfolded');this.folded=!1}
else{this.foldContainer[0].classList.remove('unfolded');this.foldContainer[0].classList.add('folded');this.folded=!0};this.foldChanged();let obj=this;setTimeout(function(){const opt={'bubbles':!0,'cancelable':!0,detail:{caller:obj}};const event=new CustomEvent('avia_fold_unfold_changed',opt);obj.container.dispatchEvent(event)},500)};onTransitionEnd(event){this.container.classList.remove('avia-fold-init-done');this.triggerHeightChange()};onResize(event){this.foldChanged()};onFoldUnfoldChanged(event){this.foldChanged()};triggerHeightChange(){const opt={'bubbles':!0,'cancelable':!0};const event=new CustomEvent('avia_height_change',opt);window.dispatchEvent(event)}};avia_js_shortcodes.aviaFoldUnfoldSection=function(t){return new avFoldUnfoldSection(t)};aviaJS.aviaPlugins.register(avia_js_shortcodes.aviaFoldUnfoldSection,'.avia-fold-unfold-section')}})();/*! Magnific Popup - v1.3 - 2022-09-14
* http://dimsemenov.com/plugins/magnific-popup/
* Copyright (c) 2016 Dmitry Semenov; */
!function(e){var t,i,n,o,a,r,s="Close",l="BeforeClose",c="MarkupParse",d="Open",p="Change",u="mfp",f="."+u,m="mfp-ready",g="mfp-removing",v="mfp-prevent-close",h=function(){},y=!!window.jQuery,C=e(window),b=function(e,i){t.ev.on(u+e+f,i)},w=function(t,i,n,o){var a=document.createElement("div");return a.className="mfp-"+t,n&&(a.innerHTML=n),o?i&&i.appendChild(a):(a=e(a),i&&a.appendTo(i)),a},I=function(e,i){t.ev.triggerHandler(u+e,i),t.st.callbacks&&(e=e.charAt(0).toLowerCase()+e.slice(1),t.st.callbacks[e]&&t.st.callbacks[e].apply(t,Array.isArray(i)?i:[i]))},x=function(i){return i===r&&t.currTemplate.closeBtn||(t.currTemplate.closeBtn=e(t.st.closeMarkup.replace("%title%",t.st.tClose)),r=i),t.currTemplate.closeBtn},k=function(){e.magnificPopup.instance||((t=new h).init(),e.magnificPopup.instance=t)};h.prototype={constructor:h,init:function(){var i=navigator.appVersion;t.isLowIE=t.isIE8=document.all&&!document.addEventListener,t.isAndroid=/android/gi.test(i),t.isIOS=/iphone|ipad|ipod/gi.test(i),t.supportsTransition=function(){var e=document.createElement("p").style,t=["ms","O","Moz","Webkit"];if(void 0!==e.transition)return!0;for(;t.length;)if(t.pop()+"Transition"in e)return!0;return!1}(),t.probablyMobile=t.isAndroid||t.isIOS||/(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent),n=e(document),t.popupsCache={}},open:function(i){var o;if(!1===i.isObj){t.items=i.items.toArray(),t.index=0;var r,s=i.items;for(o=0;o<s.length;o++)if((r=s[o]).parsed&&(r=r.el[0]),r===i.el[0]){t.index=o;break}}else t.items=Array.isArray(i.items)?i.items:[i.items],t.index=i.index||0;if(!t.isOpen){t.types=[],a="",i.mainEl&&i.mainEl.length?t.ev=i.mainEl.eq(0):t.ev=n,i.key?(t.popupsCache[i.key]||(t.popupsCache[i.key]={}),t.currTemplate=t.popupsCache[i.key]):t.currTemplate={},t.st=e.extend(!0,{},e.magnificPopup.defaults,i),t.fixedContentPos="auto"===t.st.fixedContentPos?!t.probablyMobile:t.st.fixedContentPos,t.st.modal&&(t.st.closeOnContentClick=!1,t.st.closeOnBgClick=!1,t.st.showCloseBtn=!1,t.st.enableEscapeKey=!1),t.bgOverlay||(t.bgOverlay=w("bg").on("click"+f,(function(){t.close()})),t.wrap=w("wrap").attr("tabindex",-1).on("click"+f,(function(e){t._checkIfClose(e.target)&&t.close()})),t.container=w("container",t.wrap)),t.contentContainer=w("content"),t.st.preloader&&(t.preloader=w("preloader",t.container,t.st.tLoading));var l=e.magnificPopup.modules;for(o=0;o<l.length;o++){var p=l[o];p=p.charAt(0).toUpperCase()+p.slice(1),t["init"+p].call(t)}I("BeforeOpen"),t.st.showCloseBtn&&(t.st.closeBtnInside?(b(c,(function(e,t,i,n){i.close_replaceWith=x(n.type)})),a+=" mfp-close-btn-in"):t.wrap.append(x())),t.st.alignTop&&(a+=" mfp-align-top"),t.fixedContentPos?t.wrap.css({overflow:t.st.overflowY,overflowX:"hidden",overflowY:t.st.overflowY}):t.wrap.css({top:C.scrollTop(),position:"absolute"}),(!1===t.st.fixedBgPos||"auto"===t.st.fixedBgPos&&!t.fixedContentPos)&&t.bgOverlay.css({height:n.height(),position:"absolute"}),t.st.enableEscapeKey&&n.on("keyup"+f,(function(e){27===e.keyCode&&t.close()})),C.on("resize"+f,(function(){t.updateSize()})),t.st.closeOnContentClick||(a+=" mfp-auto-cursor"),a&&t.wrap.addClass(a);var u=t.wH=C.height(),g={};if(t.fixedContentPos&&t._hasScrollBar(u)){var v=t._getScrollbarSize();v&&(g.marginRight=v)}t.fixedContentPos&&(t.isIE7?e("body, html").css("overflow","hidden"):g.overflow="hidden");var h=t.st.mainClass;return t.isIE7&&(h+=" mfp-ie7"),h&&t._addClassToMFP(h),t.updateItemHTML(),I("BuildControls"),e("html").css(g),t.bgOverlay.add(t.wrap).prependTo(t.st.prependTo||e(document.body)),t._lastFocusedEl=document.activeElement,setTimeout((function(){t.content?(t._addClassToMFP(m),t._setFocus()):t.bgOverlay.addClass(m),n.on("focusin"+f,t._onFocusIn)}),16),t.isOpen=!0,t.updateSize(u),I(d),i}t.updateItemHTML()},close:function(){t.isOpen&&(I(l),t.isOpen=!1,t.st.removalDelay&&!t.isLowIE&&t.supportsTransition?(t._addClassToMFP(g),setTimeout((function(){t._close()}),t.st.removalDelay)):t._close())},_close:function(){I(s);var i=g+" "+m+" ";if(t.bgOverlay.detach(),t.wrap.detach(),t.container.empty(),t.st.mainClass&&(i+=t.st.mainClass+" "),t._removeClassFromMFP(i),t.fixedContentPos){var o={marginRight:""};t.isIE7?e("body, html").css("overflow",""):o.overflow="",e("html").css(o)}n.off("keyup.mfp focusin"+f),t.ev.off(f),t.wrap.attr("class","mfp-wrap").removeAttr("style"),t.bgOverlay.attr("class","mfp-bg"),t.container.attr("class","mfp-container"),!t.st.showCloseBtn||t.st.closeBtnInside&&!0!==t.currTemplate[t.currItem.type]||t.currTemplate.closeBtn&&t.currTemplate.closeBtn.detach(),t.st.autoFocusLast&&t._lastFocusedEl&&e(t._lastFocusedEl).trigger("focus"),t.currItem=null,t.content=null,t.currTemplate=null,t.prevHeight=0,I("AfterClose")},updateSize:function(e){if(t.isIOS){var i=document.documentElement.clientWidth/window.innerWidth,n=window.innerHeight*i;t.wrap.css("height",n),t.wH=n}else t.wH=e||C.height();t.fixedContentPos||t.wrap.css("height",t.wH),I("Resize")},updateItemHTML:function(){var i=t.items[t.index];t.contentContainer.detach(),t.content&&t.content.detach(),i.parsed||(i=t.parseEl(t.index));var n=i.type;if(I("BeforeChange",[t.currItem?t.currItem.type:"",n]),t.currItem=i,!t.currTemplate[n]){var a=!!t.st[n]&&t.st[n].markup;I("FirstMarkupParse",a),t.currTemplate[n]=!a||e(a)}o&&o!==i.type&&t.container.removeClass("mfp-"+o+"-holder");var r=t["get"+n.charAt(0).toUpperCase()+n.slice(1)](i,t.currTemplate[n]);t.appendContent(r,n),i.preloaded=!0,I(p,i),o=i.type,t.container.prepend(t.contentContainer),I("AfterChange")},appendContent:function(e,i){t.content=e,e?t.st.showCloseBtn&&t.st.closeBtnInside&&!0===t.currTemplate[i]?t.content.find(".mfp-close").length||t.content.append(x()):t.content=e:t.content="",I("BeforeAppend"),t.container.addClass("mfp-"+i+"-holder"),t.contentContainer.append(t.content)},parseEl:function(i){var n,o=t.items[i];if(o.tagName?o={el:e(o)}:(n=o.type,o={data:o,src:o.src}),o.el){for(var a=t.types,r=0;r<a.length;r++)if(o.el.hasClass("mfp-"+a[r])){n=a[r];break}o.src=o.el.attr("data-mfp-src"),o.src||(o.src=o.el.attr("href"))}return o.type=n||t.st.type||"inline",o.index=i,o.parsed=!0,t.items[i]=o,I("ElementParse",o),t.items[i]},addGroup:function(e,i){var n=function(n){n.mfpEl=this,t._openClick(n,e,i)};i||(i={});var o="click.magnificPopup";i.mainEl=e,i.items?(i.isObj=!0,e.off(o).on(o,n)):(i.isObj=!1,i.delegate?e.off(o).on(o,i.delegate,n):(i.items=e,e.off(o).on(o,n)))},_openClick:function(i,n,o){if((void 0!==o.midClick?o.midClick:e.magnificPopup.defaults.midClick)||!(2===i.which||i.ctrlKey||i.metaKey||i.altKey||i.shiftKey)){var a=void 0!==o.disableOn?o.disableOn:e.magnificPopup.defaults.disableOn;if(a)if("function"==typeof a){if(!a.call(t))return!0}else if(C.width()<a)return!0;i.type&&(i.preventDefault(),t.isOpen&&i.stopPropagation()),o.el=e(i.mfpEl),o.delegate&&(o.items=n.find(o.delegate)),t.open(o)}},updateStatus:function(e,n){if(t.preloader){i!==e&&t.container.removeClass("mfp-s-"+i),n||"loading"!==e||(n=t.st.tLoading);var o={status:e,text:n};I("UpdateStatus",o),e=o.status,n=o.text,t.preloader.html(n),t.preloader.find("a").on("click",(function(e){e.stopImmediatePropagation()})),t.container.addClass("mfp-s-"+e),i=e}},_checkIfClose:function(i){if(!e(i).hasClass(v)){var n=t.st.closeOnContentClick,o=t.st.closeOnBgClick;if(n&&o)return!0;if(!t.content||e(i).hasClass("mfp-close")||t.preloader&&i===t.preloader[0])return!0;if(i===t.content[0]||e.contains(t.content[0],i)){if(n)return!0}else if(o&&e.contains(document,i))return!0;return!1}},_addClassToMFP:function(e){t.bgOverlay.addClass(e),t.wrap.addClass(e)},_removeClassFromMFP:function(e){this.bgOverlay.removeClass(e),t.wrap.removeClass(e)},_hasScrollBar:function(e){return(t.isIE7?n.height():document.body.scrollHeight)>(e||C.height())},_setFocus:function(){(t.st.focus?t.content.find(t.st.focus).eq(0):t.wrap).trigger("focus")},_onFocusIn:function(i){if(i.target!==t.wrap[0]&&!e.contains(t.wrap[0],i.target))return t._setFocus(),!1},_parseMarkup:function(t,i,n){var o;n.data&&(i=e.extend(n.data,i)),I(c,[t,i,n]),e.each(i,(function(i,n){if(void 0===n||!1===n)return!0;if((o=i.split("_")).length>1){var a=t.find(f+"-"+o[0]);if(a.length>0){var r=o[1];"replaceWith"===r?a[0]!==n[0]&&a.replaceWith(n):"img"===r?a.is("img")?a.attr("src",n):a.replaceWith(e("<img>").attr("src",n).attr("class",a.attr("class"))):a.attr(o[1],n)}}else t.find(f+"-"+i).html(n)}))},_getScrollbarSize:function(){if(void 0===t.scrollbarSize){var e=document.createElement("div");e.style.cssText="width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;",document.body.appendChild(e),t.scrollbarSize=e.offsetWidth-e.clientWidth,document.body.removeChild(e)}return t.scrollbarSize}},e.magnificPopup={instance:null,proto:h.prototype,modules:[],open:function(t,i){return k(),(t=t?e.extend(!0,{},t):{}).isObj=!0,t.index=i||0,this.instance.open(t)},close:function(){return e.magnificPopup.instance&&e.magnificPopup.instance.close()},registerModule:function(t,i){i.options&&(e.magnificPopup.defaults[t]=i.options),e.extend(this.proto,i.proto),this.modules.push(t)},defaults:{disableOn:0,key:null,midClick:!1,mainClass:"",preloader:!0,focus:"",closeOnContentClick:!1,closeOnBgClick:!0,closeBtnInside:!0,showCloseBtn:!0,enableEscapeKey:!0,modal:!1,alignTop:!1,removalDelay:0,prependTo:null,fixedContentPos:"auto",fixedBgPos:"auto",overflowY:"auto",closeMarkup:'<button title="%title%" type="button" class="mfp-close">&#215;</button>',tClose:"Close (Esc)",tLoading:"Loading...",autoFocusLast:!0}},e.fn.magnificPopup=function(i){k();var n=e(this);if("string"==typeof i)if("open"===i){var o,a=y?n.data("magnificPopup"):n[0].magnificPopup,r=parseInt(arguments[1],10)||0;a.items?o=a.items[r]:(o=n,a.delegate&&(o=o.find(a.delegate)),o=o.eq(r)),t._openClick({mfpEl:o},n,a)}else t.isOpen&&t[i].apply(t,Array.prototype.slice.call(arguments,1));else i=e.extend(!0,{},i),y?n.data("magnificPopup",i):n[0].magnificPopup=i,t.addGroup(n,i);return n};var T,_,z,P="inline",S=function(){z&&(_.after(z.addClass(T)).detach(),z=null)};e.magnificPopup.registerModule(P,{options:{hiddenClass:"hide",markup:"",tNotFound:"Content not found"},proto:{initInline:function(){t.types.push(P),b(s+"."+P,(function(){S()}))},getInline:function(i,n){if(S(),i.src){var o=t.st.inline,a=e(i.src);if(a.length){var r=a[0].parentNode;r&&r.tagName&&(_||(T=o.hiddenClass,_=w(T),T="mfp-"+T),z=a.after(_).detach().removeClass(T)),t.updateStatus("ready")}else t.updateStatus("error",o.tNotFound),a=e("<div>");return i.inlineElement=a,a}return t.updateStatus("ready"),t._parseMarkup(n,{},i),n}}});var E,O="ajax",M=function(){E&&e(document.body).removeClass(E)},B=function(){M(),t.req&&t.req.abort()};e.magnificPopup.registerModule(O,{options:{settings:null,cursor:"mfp-ajax-cur",tError:'<a href="%url%">The content</a> could not be loaded.'},proto:{initAjax:function(){t.types.push(O),E=t.st.ajax.cursor,b(s+"."+O,B),b("BeforeChange."+O,B)},getAjax:function(i){E&&e(document.body).addClass(E),t.updateStatus("loading");var n=e.extend({url:i.src,success:function(n,o,a){var r={data:n,xhr:a};I("ParseAjax",r),t.appendContent(e(r.data),O),i.finished=!0,M(),t._setFocus(),setTimeout((function(){t.wrap.addClass(m)}),16),t.updateStatus("ready"),I("AjaxContentAdded")},error:function(){M(),i.finished=i.loadError=!0,t.updateStatus("error",t.st.ajax.tError.replace("%url%",i.src))}},t.st.ajax.settings);return t.req=e.ajax(n),""}}});var A,L=function(e){if(e.data&&void 0!==e.data.title)return e.data.title;var i=t.st.image.titleSrc;if(i){if("function"==typeof i)return i.call(t,e);if(e.el)return e.el.attr(i)||""}return""};e.magnificPopup.registerModule("image",{options:{markup:'<div class="mfp-figure"><div class="mfp-close"></div><figure><div class="mfp-img"></div><figcaption><div class="mfp-bottom-bar"><div class="mfp-title"></div><div class="mfp-counter"></div></div></figcaption></figure></div>',cursor:"mfp-zoom-out-cur",titleSrc:"title",verticalFit:!0,tError:'<a href="%url%">The image</a> could not be loaded.'},proto:{initImage:function(){var i=t.st.image,n=".image";t.types.push("image"),b(d+n,(function(){"image"===t.currItem.type&&i.cursor&&e(document.body).addClass(i.cursor)})),b(s+n,(function(){i.cursor&&e(document.body).removeClass(i.cursor),C.off("resize"+f)})),b("Resize"+n,t.resizeImage),t.isLowIE&&b("AfterChange",t.resizeImage)},resizeImage:function(){var e=t.currItem;if(e&&e.img&&t.st.image.verticalFit){var i=0;t.isLowIE&&(i=parseInt(e.img.css("padding-top"),10)+parseInt(e.img.css("padding-bottom"),10)),e.img.css("max-height",t.wH-i)}},_onImageHasSize:function(e){e.img&&(e.hasSize=!0,A&&clearInterval(A),e.isCheckingImgSize=!1,I("ImageHasSize",e),e.imgHidden&&(t.content&&t.content.removeClass("mfp-loading"),e.imgHidden=!1))},findImageSize:function(e){var i=0,n=e.img[0],o=function(a){A&&clearInterval(A),A=setInterval((function(){n.naturalWidth>0?t._onImageHasSize(e):(i>200&&clearInterval(A),3===++i?o(10):40===i?o(50):100===i&&o(500))}),a)};o(1)},getImage:function(i,n){var o=0,a=function(){i&&(i.img[0].complete?(i.img.off(".mfploader"),i===t.currItem&&(t._onImageHasSize(i),t.updateStatus("ready")),i.hasSize=!0,i.loaded=!0,I("ImageLoadComplete")):++o<200?setTimeout(a,100):r())},r=function(){i&&(i.img.off(".mfploader"),i===t.currItem&&(t._onImageHasSize(i),t.updateStatus("error",s.tError.replace("%url%",i.src))),i.hasSize=!0,i.loaded=!0,i.loadError=!0)},s=t.st.image,l=n.find(".mfp-img");if(l.length){var c=document.createElement("img");if(c.className="mfp-img",i.el&&i.el.find("img").length&&(c.alt=i.el.find("img").attr("alt")),i.img=e(c).on("load.mfploader",a).on("error.mfploader",r),c.src=i.src,e("body").hasClass("responsive-images-lightbox-support")){var d=i.el.data("srcset"),p=i.el.data("sizes");void 0!==d?(c.srcset=d,void 0!==p&&(c.sizes=p)):(void 0!==(d=i.el.find("img").attr("srcset"))&&(c.srcset=d),void 0!==(p=i.el.find("img").attr("sizes"))&&(c.sizes=p))}l.is("img")&&(i.img=i.img.clone()),(c=i.img[0]).naturalWidth>0?i.hasSize=!0:c.width||(i.hasSize=!1)}return t._parseMarkup(n,{title:L(i),img_replaceWith:i.img},i),t.resizeImage(),i.hasSize?(A&&clearInterval(A),i.loadError?(n.addClass("mfp-loading"),t.updateStatus("error",s.tError.replace("%url%",i.src))):(n.removeClass("mfp-loading"),t.updateStatus("ready")),n):(t.updateStatus("loading"),i.loading=!0,i.hasSize||(i.imgHidden=!0,n.addClass("mfp-loading"),t.findImageSize(i)),n)}}});var H;e.magnificPopup.registerModule("zoom",{options:{enabled:!1,easing:"ease-in-out",duration:300,opener:function(e){return e.is("img")?e:e.find("img")}},proto:{initZoom:function(){var e,i=t.st.zoom,n=".zoom";if(i.enabled&&t.supportsTransition){var o,a,r=i.duration,c=function(e){var t=e.clone().removeAttr("style").removeAttr("class").addClass("mfp-animated-image"),n="all "+i.duration/1e3+"s "+i.easing,o={position:"fixed",zIndex:9999,left:0,top:0,"-webkit-backface-visibility":"hidden"},a="transition";return o["-webkit-"+a]=o["-moz-"+a]=o["-o-"+a]=o[a]=n,t.css(o),t},d=function(){t.content.css("visibility","visible")};b("BuildControls"+n,(function(){if(t._allowZoom()){if(clearTimeout(o),t.content.css("visibility","hidden"),!(e=t._getItemToZoom()))return void d();(a=c(e)).css(t._getOffset()),t.wrap.append(a),o=setTimeout((function(){a.css(t._getOffset(!0)),o=setTimeout((function(){d(),setTimeout((function(){a.remove(),e=a=null,I("ZoomAnimationEnded")}),16)}),r)}),16)}})),b(l+n,(function(){if(t._allowZoom()){if(clearTimeout(o),t.st.removalDelay=r,!e){if(!(e=t._getItemToZoom()))return;a=c(e)}a.css(t._getOffset(!0)),t.wrap.append(a),t.content.css("visibility","hidden"),setTimeout((function(){a.css(t._getOffset())}),16)}})),b(s+n,(function(){t._allowZoom()&&(d(),a&&a.remove(),e=null)}))}},_allowZoom:function(){return"image"===t.currItem.type},_getItemToZoom:function(){return!!t.currItem.hasSize&&t.currItem.img},_getOffset:function(i){var n,o=(n=i?t.currItem.img:t.st.zoom.opener(t.currItem.el||t.currItem)).offset(),a=parseInt(n.css("padding-top"),10),r=parseInt(n.css("padding-bottom"),10);o.top-=e(window).scrollTop()-a;var s={width:n.width(),height:(y?n.innerHeight():n[0].offsetHeight)-r-a};return void 0===H&&(H=void 0!==document.createElement("p").style.MozTransform),H?s["-moz-transform"]=s.transform="translate("+o.left+"px,"+o.top+"px)":(s.left=o.left,s.top=o.top),s}}});var F="iframe",j=function(e){if(t.currTemplate[F]){var i=t.currTemplate[F].find("iframe");i.length&&(e||(i[0].src="//about:blank"),t.isIE8&&i.css("display",e?"block":"none"))}};e.magnificPopup.registerModule(F,{options:{markup:'<div class="mfp-iframe-scaler"><div class="mfp-close"></div><iframe class="mfp-iframe" src="//about:blank" frameborder="0" allowfullscreen allow="autoplay; encrypted-media" ></iframe></div>',srcAction:"iframe_src",patterns:{youtube:{index:"youtube.com",id:"v=",src:"//www.youtube.com/embed/%id%?autoplay=1"},vimeo:{index:"vimeo.com/",id:"/",src:"//player.vimeo.com/video/%id%?autoplay=1"},gmaps:{index:"//maps.google.",src:"%id%&output=embed"}}},proto:{initIframe:function(){t.types.push(F),b("BeforeChange",(function(e,t,i){t!==i&&(t===F?j():i===F&&j(!0))})),b(s+"."+F,(function(){j()}))},getIframe:function(i,n){var o=i.src,a=t.st.iframe;e.each(a.patterns,(function(){if(o.indexOf(this.index)>-1)return this.id&&(o="string"==typeof this.id?o.substr(o.lastIndexOf(this.id)+this.id.length,o.length):this.id.call(this,o)),o=this.src.replace("%id%",o),!1}));var r={};return a.srcAction&&(r[a.srcAction]=o),t._parseMarkup(n,r,i),t.updateStatus("ready"),n}}});var N=function(e){var i=t.items.length;return e>i-1?e-i:e<0?i+e:e},W=function(e,t,i){return e.replace(/%curr%/gi,t+1).replace(/%total%/gi,i)};e.magnificPopup.registerModule("gallery",{options:{enabled:!1,arrowMarkup:'<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%"></button>',preload:[0,2],navigateByImgClick:!0,arrows:!0,tPrev:"Previous (Left arrow key)",tNext:"Next (Right arrow key)",tCounter:"%curr% of %total%"},proto:{initGallery:function(){var i=t.st.gallery,o=".mfp-gallery";if(t.direction=!0,!i||!i.enabled)return!1;a+=" mfp-gallery",b(d+o,(function(){i.navigateByImgClick&&t.wrap.on("click"+o,".mfp-img",(function(){if(t.items.length>1)return t.next(),!1})),n.on("keydown"+o,(function(e){37===e.keyCode?t.prev():39===e.keyCode&&t.next()}))})),b("UpdateStatus"+o,(function(e,i){i.text&&(i.text=W(i.text,t.currItem.index,t.items.length))})),b(c+o,(function(e,n,o,a){var r=t.items.length;o.counter=r>1?W(i.tCounter,a.index,r):""})),b("BuildControls"+o,(function(){if(t.items.length>1&&i.arrows&&!t.arrowLeft){var n=i.arrowMarkup,o=t.arrowLeft=e(n.replace(/%title%/gi,i.tPrev).replace(/%dir%/gi,"left")).addClass(v),a=t.arrowRight=e(n.replace(/%title%/gi,i.tNext).replace(/%dir%/gi,"right")).addClass(v);o.on("click",(function(){t.prev()})),a.on("click",(function(){t.next()})),t.container.append(o.add(a))}})),b(p+o,(function(){t._preloadTimeout&&clearTimeout(t._preloadTimeout),t._preloadTimeout=setTimeout((function(){t.preloadNearbyImages(),t._preloadTimeout=null}),16)})),b(s+o,(function(){n.off(o),t.wrap.off("click"+o),t.arrowRight=t.arrowLeft=null}))},next:function(){t.direction=!0,t.index=N(t.index+1),t.updateItemHTML()},prev:function(){t.direction=!1,t.index=N(t.index-1),t.updateItemHTML()},goTo:function(e){t.direction=e>=t.index,t.index=e,t.updateItemHTML()},preloadNearbyImages:function(){var e,i=t.st.gallery.preload,n=Math.min(i[0],t.items.length),o=Math.min(i[1],t.items.length);for(e=1;e<=(t.direction?o:n);e++)t._preloadItem(t.index+e);for(e=1;e<=(t.direction?n:o);e++)t._preloadItem(t.index-e)},_preloadItem:function(i){if(i=N(i),!t.items[i].preloaded){var n=t.items[i];if(n.parsed||(n=t.parseEl(i)),I("LazyLoad",n),"image"===n.type&&(n.img=e('<img class="mfp-img" />').on("load.mfploader",(function(){n.hasSize=!0})).on("error.mfploader",(function(){n.hasSize=!0,n.loadError=!0,I("LazyLoadError",n)})).attr("src",n.src),e("body").hasClass("responsive-images-lightbox-support")&&n.el.length>0)){var o=e(n.el[0]),a=o.data("srcset"),r=o.data("sizes");if(void 0!==a)n.img.attr("srcset",a),void 0!==r&&n.img.attr("sizes",r);else{var s=e(n.el[0]).find("img");void 0!==(a=s.attr("srcset"))&&n.img.attr("srcset",a),void 0!==(r=s.attr("sizes"))&&n.img.attr("sizes",r)}}n.preloaded=!0}}}});var R="retina";e.magnificPopup.registerModule(R,{options:{replaceSrc:function(e){return e.src.replace(/\.\w+$/,(function(e){return"@2x"+e}))},ratio:1},proto:{initRetina:function(){if(window.devicePixelRatio>1){var e=t.st.retina,i=e.ratio;(i=isNaN(i)?i():i)>1&&(b("ImageHasSize."+R,(function(e,t){t.img.css({"max-width":t.img[0].naturalWidth/i,width:"100%"})})),b("ElementParse."+R,(function(t,n){n.src=e.replaceSrc(n,i)})))}}}}),k()}(jQuery);(function(e){'use strict';e.avia_utilities=e.avia_utilities||{};e.avia_utilities.av_popup={type:'image',mainClass:'avia-popup mfp-zoom-in',tLoading:'',tClose:'',removalDelay:300,closeBtnInside:!0,closeOnContentClick:!1,midClick:!0,autoFocusLast:!1,fixedContentPos:e('html').hasClass('av-default-lightbox-no-scroll'),iframe:{patterns:{youtube:{index:'youtube.com/watch',id:function(e){let m=e.match(/[\\?\\&]v=([^\\?\\&]+)/),id,params;if(!m||!m[1]){return null};id=m[1];params=e.split('/watch');params=params[1];return id+params},src:'//www.youtube.com/embed/%id%'},youtube_shorts:{index:'youtube.com/shorts',id:function(e){let m=e.match(/(?:youtube\.com\/shorts\/)([a-zA-Z0-9_-]*)/),id,params;if(!m||!m[1]){return null};id=m[1];params=e.split('/shorts');params=params[1];return id+params},src:'//www.youtube.com/embed/%id%'},vimeo:{index:'vimeo.com/',id:function(e){let m=e.match(/(https?:\/\/)?(www.)?(player.)?vimeo.com\/([a-z]*\/)*([0-9]{6,11})\/(\w{6,11})[?]?.*/),params,vid;m=m?m:e.match(/(https?:\/\/)?(www.)?(player.)?vimeo.com\/([a-z]*\/)*([0-9]{6,11})[?]?.*/);if(!m||!m[5]){return null};vid=m[5];params=e.split('?');params=params[1]?'?'+params[1]:'';if(m[6]){vid=vid+(params?params+'&h=':'?h=')+m[6]}
else{vid=vid+params};return vid},src:'//player.vimeo.com/video/%id%'}}},image:{titleSrc:function(t){var a=t.el.attr('title');if(!a){a=t.el.find('img').attr('title')};if(!a){a=t.el.parent().next('.wp-caption-text').html()};if(typeof a!='undefined'){return a};if(!e('body').hasClass('avia-mfp-show-alt-text')){return''};var i=t.el.attr('alt');if(typeof i!='undefined'){return i};i=t.el.find('img').attr('alt');if(typeof i!='undefined'){return i};return''}},gallery:{tPrev:'',tNext:'',tCounter:'%curr% / %total%',enabled:!0,preload:[1,1]},callbacks:{beforeOpen:function(){if(this.st.el&&this.st.el.data('fixed-content')){this.fixedContentPos=!0};let elementCustomClass='';if(this.st.el&&this.st.el.data('custom_class')){elementCustomClass=this.st.el.data('custom_class').trim()}
else if(this.st.el){let element=e(this.st.el),href=element.attr('href');if((href.indexOf('youtube.com')>=0)&&(href.indexOf('/shorts/')>=0)){elementCustomClass='avia-mfp-is-video avia-mfp-video-9-16'}};if(elementCustomClass){this.st.mainClass+=' '+elementCustomClass}},open:function(){e.magnificPopup.instance.next=function(){var t=this;t.wrap.removeClass('mfp-image-loaded');setTimeout(function(){e.magnificPopup.proto.next.call(t)},120)};e.magnificPopup.instance.prev=function(){var t=this;t.wrap.removeClass('mfp-image-loaded');setTimeout(function(){e.magnificPopup.proto.prev.call(t)},120)};if(this.st.el&&this.st.el.data('av-extra-class')){this.wrap.addClass(this.currItem.el.data('av-extra-class'))};this.wrap.avia_swipe_trigger({prev:'.mfp-arrow-left',next:'.mfp-arrow-right'})},markupParse:function(t,a,r){if(typeof a.img_replaceWith=='undefined'||typeof a.img_replaceWith.length=='undefined'||a.img_replaceWith.length==0){return};var o=e(a.img_replaceWith[0]);if(typeof o.attr('alt')!='undefined'){return};var i=r.el.attr('alt');if(typeof i=='undefined'){i=r.el.find('img').attr('alt')};if(typeof i!='undefined'){o.attr('alt',i)};return},imageLoadComplete:function(){var e=this;setTimeout(function(){e.wrap.addClass('mfp-image-loaded')},16)},change:function(){if(this.currItem.el){var e=this.currItem.el;this.content.find('.av-extra-modal-content, .av-extra-modal-markup').remove();if(e.data('av-extra-content')){var a=e.data('av-extra-content');this.content.append('<div class=\'av-extra-modal-content\'>'+a+'</div>')};if(e.data('av-extra-markup')){var t=e.data('av-extra-markup');this.wrap.append('<div class=\'av-extra-modal-markup\'>'+t+'</div>')}}}}};e.fn.avia_activate_lightbox=function(t){var i={groups:['.avia-slideshow','.avia-gallery','.av-horizontal-gallery','.av-instagram-pics','.portfolio-preview-image','.portfolio-preview-content','.isotope','.post-entry','.sidebar','#main','.main_menu','.woocommerce-product-gallery'],autolinkElements:'a.lightbox, a[rel^="prettyPhoto"], a[rel^="lightbox"], a[href$=jpg], a[href$=webp], a[href$=png], a[href$=gif], a[href$=jpeg], a[href*=".jpg?"], a[href*=".png?"], a[href*=".gif?"], a[href*=".jpeg?"], a[href$=".mov"] , a[href$=".swf"] , a:regex(href, .vimeo\.com/[0-9]) , a[href*="youtube.com/watch"] , a[href*="youtube.com/shorts"] , a[href*="screenr.com"], a[href*="iframe=true"]',videoElements:'a[href$=".mov"] , a[href$=".swf"] , a:regex(href, .vimeo\.com/[0-9]) , a[href*="youtube.com/watch"] , a[href*="youtube.com/shorts"] , a[href*="screenr.com"], a[href*="iframe=true"]',exclude:'.noLightbox, .noLightbox a, .fakeLightbox, .lightbox-added, a[href*="dropbox.com"], .pagination a'},a=e.extend({},i,t),r=!e('html').is('.av-custom-lightbox');if(!r){return this};return this.each(function(){var i=e(this),o=e(a.videoElements,this).not(a.exclude).addClass('mfp-iframe'),r=!i.is('body')&&!i.is('.ajax_slide');for(var t=0;t<a.groups.length;t++){i.find(a.groups[t]).each(function(){var t=e(a.autolinkElements,this);if(r){t.removeClass('lightbox-added')};t.not(a.exclude).addClass('lightbox-added').magnificPopup(e.avia_utilities.av_popup)})}})}})(jQuery);(function(i){'use strict';i(function(){if(i.fn.aviaMegamenu){i('.main_menu .menu').aviaMegamenu({modify_position:!0})}});i.fn.aviaMegamenu=function(n){var e={modify_position:!0,delay:300};var t=i.extend(e,n);return this.each(function(){var f=i('html').first(),g=i('#main .container').first(),l=f.filter('.html_menu_left, .html_logo_center').length,r=i.avia_utilities.isMobile,o=i(this),s=o.find('>li:not(.ignore_menu)'),n=s.find('>div').parent().css({overflow:'hidden'}),d=o.find('>.current-menu-item>a, >.current_page_item>a'),h=s.find('>ul').parent(),p=o.parent(),m=o.parents('.main_menu').eq(0),v=p.width(),e={},a=[];if(!d.length){o.find('.current-menu-ancestor, .current_page_ancestor').eq(0).find('a').eq(0).parent().addClass('active-parent-item')};if(!f.is('.html_header_top')){t.modify_position=!1};s.on('click','a',function(i){if(this.href==window.location.href+'#'||this.href==window.location.href+'/#'){i.preventDefault()}});s.each(function(){var n=i(this),a=n.position(),o=n.find('div').first().css({opacity:0,display:'none'}),s='';if(!o.length){s=n.find('>ul').css({display:'none'})};if(o.length||s.length){var e=n.addClass('dropdown_ul_available').find('>a');e.append('<span class="dropdown_available"></span>');if(typeof e.attr('href')!='string'||e.attr('href')=='#'){e.css('cursor','default').on('click',function(i){i.preventDefault()})}};if(t.modify_position&&o.length){n.on('mouseenter focusin',function(){y(n,a,o,v)})}});function y(i,t,n,e){t=i.position();if(!l){if(t.left+n.width()<e){n.css({right:-n.outerWidth()+i.outerWidth()})}
else if(t.left+n.width()>e){n.css({right:-m.outerWidth()+(t.left+i.outerWidth())})}}
else{if(n.width()>t.left+i.outerWidth()){n.css({left:(t.left*-1)})}
else if(t.left+n.width()>e){n.css({left:(n.width()-t.left)*-1})}}};function c(i){if(e[i]==!0){var t=n.eq(i).css({overflow:'visible'}).find('div').first(),o=n.eq(i).find('a').first();a['check'+i]=!0;t.stop().css('display','block').animate({opacity:1},300);if(t.length){o.addClass('open-mega-a')}}};function u(t){if(e[t]==!1){n.eq(t).find('>a').removeClass('open-mega-a');var o=n.eq(t),s=o.find('div').first();s.stop().css('display','block').animate({opacity:0},300,function(){i(this).css('display','none');o.css({overflow:'hidden'});a['check'+t]=!1})}};if(r){n.each(function(n){i(this).on('click',function(){if(a['check'+n]!=!0){return!1}})})};n.each(function(n){i(this).on('mouseenter',function(){e[n]=!0;setTimeout(function(){c(n)},t.delay)}).on('mouseleave',function(){e[n]=!1;setTimeout(function(){u(n)},t.delay)});i(this).find('a').on('focus',function(){e[n]=!0;setTimeout(function(){c(n)},50)}).on('blur',function(){e[n]=!1;setTimeout(function(){u(n)},50)})});h.find('li').addBack().each(function(){var t=i(this),n=t.find('ul').first(),o=!1;if(n.length){n.css({display:'block',opacity:0,visibility:'hidden'});var e=t.find('>a');e.on('mouseenter',function(){n.stop().css({visibility:'visible'}).animate({opacity:1})});e.on('focus',function(){n.stop().css({visibility:'visible'}).animate({opacity:1});n.find('li').on('focusin',function(){n.stop().css({visibility:'visible'}).animate({opacity:1})}).on('focusout',function(){n.stop().animate({opacity:0},function(){n.css({visibility:'hidden'})})})}).on('focusout',function(){i(this).trigger('mouseleave')});t.on('mouseleave',function(){n.stop().animate({opacity:0},function(){n.css({visibility:'hidden'})})})}})})}})(jQuery);(function(e){'use strict';e(function(){i()});function a(e,i,a){if(e[0].classList){if(i=='add'){e[0].classList.add(a)}
else{e[0].classList.remove(a)}}
else{if(i=='add'){e.addClass(a)}
else{e.removeClass(a)}}};function i(){var h=e(window),i=e('.html_header_top.html_header_sticky #header'),r=e('.av_header_unstick_top');if(!i.length&&!r.length){return};var u=e('#header_main .container .logo img, #header_main .container .logo svg, #header_main .container .logo a'),o=e('#header_main .container:not(#header_main_alternate>.container), #header_main .main_menu ul:first-child > li > a:not(.avia_mega_div a, #header_main_alternate a), #header_main #menu-item-shop .cart_dropdown_link'),t=e(o).first().height(),v=e.avia_utilities.isMobile,H=e('#scroll-top-link'),f=i.is('.av_header_transparency'),s=i.is('.av_header_shrinking'),c=i.data('av_shrink_factor'),l=t/2.0,g=t/2.0,p=i.find('#header_meta'),n=p.length?p.outerHeight():0,m=i.find('#header_main_alternate'),y=m.length?m.outerHeight():0,d=function(){var d=h.scrollTop(),c=0,p=d;if(r){d-=n};if(d<0){d=0};if(s&&!v){if(d<l){c=t-d;if(d<=0){c=t};a(i,'remove','header-scrolled')}
else{c=g;a(i,'add','header-scrolled')};if(d-30<t){a(i,'remove','header-scrolled-full')}
else{a(i,'add','header-scrolled-full')};o.css({'height':c+'px','lineHeight':c+'px'});u.css({'maxHeight':c+'px'});let propHeight=c+y;if(i.length){if(!r.length){propHeight+=n}
else{if(d<=n){propHeight=propHeight+n-p}}};e(':root')[0].style.setProperty('--enfold-header-height',Math.round(propHeight)+'px')};if(r.length){if(d<=0){if(p<=0){p=0};r.css({'margin-top':'-'+p+'px'})}
else{r.css({'margin-top':'-'+n+'px'})}};if(f){if(d>50){a(i,'remove','av_header_transparency')}
else{a(i,'add','av_header_transparency')}}};if(typeof c!='undefined'){const value=parseInt(c);if(!isNaN(value)){l=t*(value/100.0);g=t-l}};if(e('body').is('.avia_deactivate_menu_resize')){s=!1};if(!f&&!s&&!r.length){return};h.on('debouncedresize',function(){t=e(o).attr('style','').first().height();d()});h.on('scroll',function(){window.requestAnimationFrame(d)});d()}})(jQuery);(function(n){'use strict';var r=null,a=null,t=null,i=null,e=null;n(function(){r=n(window);a=n('body');if(a.hasClass('av-curtain-footer')){o();return};return});function o(){i=a.find('.av-curtain-footer-container');if(i.length==0){a.removeClass('av-curtain-footer av-curtain-activated av-curtain-numeric av-curtain-screen');return};t=n('<div id="av-curtain-footer-placeholder"></div>');i.before(t);if(a.hasClass('av-curtain-numeric')){e=i.data('footer_max_height');if('undefined'==typeof e){e=70}
else{e=parseInt(e,10);if(isNaN(e)){e=70}}};u();r.on('debouncedresize',u)};function u(){var n=Math.floor(i.outerHeight()),o=r.innerHeight();if(null==e){t.css({height:n+'px'})}
else{var u=Math.floor(o*(e/100.0));if(n>u){a.removeClass('av-curtain-activated');t.css({height:''})}
else{a.addClass('av-curtain-activated');t.css({height:n+'px'})}}}})(jQuery);(function(t){'use strict';t(function(){t('.avia_auto_toc').each(function(){var s=t(this).attr('id'),n='h1',c=[],a='',r=t(this).find('.avia-toc-container');if(r.length){var i=r.attr('data-level'),o=r.attr('data-exclude');if(typeof i!='undefined'){n=i};if(typeof o!='undefined'){a=o.trim()}};c=n.split(',');t('.entry-content-wrapper').find(n).each(function(){var n=t(this);if(n.hasClass('av-no-toc')){return};if(a!=''&&(n.hasClass(a)||n.parent().hasClass(a))){return};var i=n.attr('id'),l=n.prop('tagName').toLowerCase(),s=n.text(),h=c.indexOf(l);if(typeof i=='undefined'){var o=e(s);n.attr('id',o);i=o};var f='<a href="#'+i+'" class="avia-toc-link avia-toc-level-'+h+'"><span>'+s+'</span></a>';r.append(f)});t('.avia-toc-smoothscroll .avia-toc-link').on('click',function(e){e.preventDefault();var n=t(this).attr('href'),a=50,r=t('.html_header_top.html_header_sticky #header');if(r.length){a=r.outerHeight()+50};t('html,body').animate({scrollTop:t(n).offset().top-a})})})});function e(t){return t.replace(/[ÄÖÜäöüß]/g,function(t){return{'Ä':'Ae','Ö':'Oe','Ü':'Ue','ä':'ae','ö':'oe','ü':'ue','ß':'ss'}[t]}).toLowerCase().replace(/[^a-z0-9]+/g,'-').replace(/^-+|-+$/g,'-').replace(/^-+|-+$/g,'')}})(jQuery);(function(e){'use strict';var t=e('.has-background, .has-text-color');t.each(function(s){var t=e(this);if(!(t.hasClass('has-background')||t.hasClass('has-text-color'))){return};var o=t.attr('class').split(/\s+/),a='',r='';if(t.hasClass('has-background')){e.each(o,function(s,e){e=e.trim().toLowerCase();if(0==e.indexOf('has-col-')&&-1!=e.indexOf('-background-color')){a=e.replace('has-col-','');a=a.replace('-background-color','');a=a.replace(/-|[^0-9a-fA-F]/g,'');if(a.length==3||a.length==6){t.css({'background-color':'','border-color':''});r='undefined'!=typeof t.attr('style')?t.attr('style')+';':'';t.attr('style',r+' background-color: #'+a+'; border-color: #'+a+';')}}})};if(t.hasClass('has-text-color')){e.each(o,function(s,e){e=e.trim().toLowerCase();if(0==e.indexOf('has-col-')&&-1==e.indexOf('-background-color')&&-1!=e.indexOf('-color')){var a=e.replace('has-col-','');a=a.replace('-color','');a=a.replace(/-|[^0-9a-fA-F]/g,'');if(a.length==3||a.length==6){t.css('color','');r='undefined'!=typeof t.attr('style')?t.attr('style')+';':'';t.attr('style',r+' color: #'+a+';')}}})}});t=e('[class^="has-fs-"], [class$="-font-size"]');t.each(function(t){var a=e(this),s=a.attr('class').split(/\s+/);e.each(s,function(t,e){e=e.trim().toLowerCase();if(0==e.indexOf('has-fs-')&&-1!=e.indexOf('-font-size')){e=e.replace('has-fs-','');e=e.replace('-font-size','');e=e.split('-');if(e.length!=2){return};var s='undefined'!=typeof a.attr('style')?a.attr('style')+';':'';a.attr('style',s+' font-size:'+e[0]+e[1]+';')}})})})(jQuery);