<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use Exception;

class Homecontroller extends Controller
{
    public function index(){

        return view('index');
    }
    public function about_us(){
        return view('about_us');
    }
    public function contact_us(){
        return view('contact_us');
    }
    public function save_contact_us(Request $request){
        $postdata = array(
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'subject' => $request->subject,
            'message' => $request->message,
            'created_at' => date('Y-m-d H:i:s')
        );
        $insert = DB::table('tbl_contact_us')
        ->insert($postdata);
        if($insert){
            $res = array(
                'status'=>true,
                'color'=>'reverse',
                'message'=>'Your request was sent, We will contact you soon.',
            );
        }else{
            $res = array(
                'status'=>false,
                'color'=>'white',
                'message'=>'Something went wrong, Please try again.',
            );
        }
        echo json_encode($res);
    }
    public function armed_off_road(){

        return view('armed_off_road');
    }
    public function armed_street(){

        return view('armed_street');
    }
    public function armed_syndicate(){

        return view('armed_syndicate');
    }
    public function all_tires(){

        return view('all_tires');
    }
    public function wheel_accessories(){

        return view('wheel_accessories');
    }
    public function track_order(){

        return view('track_order');
    }
    public function warranty_return()
    {
        return view('order/warranty_return');
    }
    public function get_warranty_return_form(Request $request)
    {
        $type = $request->type;
        if($type == 'return')
        {
            $html = view('order/return_form')->render();
        }
        else
        {
            $html = view('order/warranty_form')->render();
        }
        return response()->json(['html' => $html]);
    }
    public function save_warranty_form(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'account_no' => 'required',
            'account_name' => 'required',
            'product_type' => 'required',
            'claim_category' => 'required',
            'qty' => 'required',
            'item_number' => 'required',
            'manufacturer' => 'required',
            'invoice_no' => 'required',
            'purchased_date' => 'required',
            'reason' => 'required',
            'make' => 'required',
            'model' => 'required',
            'year' => 'required',
            'first_name' => 'required',
            'email' => 'required',
            'phone' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('return-warranty')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'account_no' => $request->account_no,
                'account_name' => $request->account_name,
                'address' => $request->address,
                'product_type' => $request->product_type,
                'claim_category' => $request->claim_category,
                'qty' => $request->qty,
                'item_number' => $request->item_number,
                'manufacturer' => $request->manufacturer,
                'invoice_no' => $request->invoice_no,
                'purchased_date' => $request->purchased_date,
                'reason' => $request->reason,
                'make' => $request->make,
                'model' => $request->model,
                'year' => $request->year,
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'phone' => $request->phone,
                'created_at' => date('Y-m-d H:i:s'),
                'user_id' => Session::get('user_data')->id,
            );
            $insertid = DB::table('tbl_warranty_request')
            ->insertGetId($postdata);
            if($insertid)
            {
                return redirect('return-warranty')->with('success', 'Warranty request submitted.');
            }
            else
            {
                return redirect('return-warranty')->with('error', 'Something went wrong, Please try again.');
            }
        }
    }
    public function save_return_form(Request $request)
    {
            // echo "<pre>";
            // print_r($_FILES);
            // echo "</pre>";
            // die;
        $validateUser = Validator::make($request->all(), [
            'account_no' => 'required',
            'account_name' => 'required',
            'is_account_address_as_shipping' => 'required',
            'delivery_method' => 'required',
            'first_name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'qty' => 'required',
            'item_number' => 'required',
            'manufacturer' => 'required',
            'invoice_no' => 'required',
            'purchase_date' => 'required',
            'purchase_date' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            dd($validateUser->errors());
            return redirect('return-warranty')->with('error',$validateUser->errors());
        }
        else
        {
            try 
            {
                DB::beginTransaction();
                $postdata = array(
                    'account_no' => $request->account_no,
                    'account_name' => $request->account_name,
                    'is_account_address_as_shipping' => $request->is_account_address_as_shipping,
                    'vrma' => $request->vrma,
                    'address' => $request->address,
                    'city' => $request->city,
                    'postal_code' => $request->postal_code,
                    'delivery_method' => $request->delivery_method,
                    'first_name' => $request->first_name,
                    'last_name' => $request->last_name,
                    'email' => $request->email,
                    'phone' => $request->phone,
                    'created_at' => date('Y-m-d H:i:s'),
                    'user_id' => Session::get('user_data')->id
                );
                $insertid = DB::table('tbl_return_request')
                ->insertGetId($postdata);
                if($insertid)
                {
                    for($i=0;$i<$request->no_of_product;$i++)
                    {
                        $product_arr = array(
                            'user_id'=>Session::get('user_data')->id,
                            'return_id' => $insertid,
                            'qty' => $request->qty[$i],
                            'item_number' => $request->item_number[$i],
                            'manufacturer' => $request->manufacturer[$i],
                            'invoice_no' => $request->invoice_no[$i],
                            'purchase_date' => $request->purchase_date[$i],
                            'reason' => $request->reason[$i],
                            'created_at' => date('Y-m-d H:i:s')
                        );
                        $product_insert_id = DB::table('tbl_return_request_product')
                        ->insertGetId($product_arr);
                        $uploadedPaths = [];
                        $count = $i+1;
                        if($request->hasFile('file'.$count)) {
                            foreach ($request->file('file'.$count) as $image) {

                                $imageName = time().'.'.$image->extension();
                                $image->move(base_path('uploads/return'), $imageName);
                                $image_name = 'uploads/return/'.$imageName;

                                $product_image_arr = array(
                                    'user_id'=>Session::get('user_data')->id,
                                    'return_id' => $insertid,
                                    'product_id' => $product_insert_id,
                                    'product_image' => $image_name,
                                    'created_at' => date('Y-m-d H:i:s')
                                );
                                DB::table('tbl_return_request_product_image')->insert($product_image_arr);
                            }
                        }

                    }
                    DB::commit();
                    return redirect('return-warranty')->with('success', 'Retun request submitted.');
                }
                else
                {
                    dd("sdfsf");
                    return redirect('return-warranty')->with('error', 'Something went wrong, Please try again.');
                }
            } 
            catch (\Exception $e)
            {
                DB::rollback();
                dd($e);
                throw $e;
            }
        }

    }
}