<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use Exception;

class Usercontroller extends Controller
{
    public function signin(){
        return view('admin/userlogin');
    }
    public function signup(){
        return view('signup');
    }

    public function forgot_password(){
        return view('forgot_password');
    }
    public function reset_password(){
        return view('reset_password');
    }
    public function send_reset_email(Request $request){
        $email = $request->email;
        $userdetail = DB::table('tbl_users')
        ->select('id')
        ->where('email',$email)
        ->where('status','active')
        ->where('role','business_owner')
        ->first();
        if($userdetail)
        {
            $otp = rand(1234,9999);
            $res = array(
                'status'=>true,
                'msg'=>'Success',
                'otp'=>$otp,
            );
        }
        else
        {
            $res = array(
                'status'=>true,
                'msg'=>'Invalid user',
            );
        }
        echo json_encode($res);
    }
    public function login(Request $request)
    {

        $validateUser = Validator::make($request->all(), [
            'email' => 'required',
            'password' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('signin')->with('error',$validateUser->errors());
        }
        else
        {
            $userdata = DB::table('tbl_dealer')
            ->where('email',$request->email)
            ->where('status','active')
            ->where('role','dealer')
            ->where('password',md5($request->password))
            ->select('*')
            ->first();
            if($userdata)
            {
                Session::put('user_data', $userdata);
                return redirect('web-order');
            }
            else
            {
                return redirect('signin')->with('error', 'Invalid credential');;
            }
        }
    }
    public function logout(){
        Session::forget('user_data');
        return redirect('signin');
    }
    public function save_dealer(Request $request){
        $validateUser = Validator::make($request->all(), [
            'business_name' => 'required',
            'primary_business' => 'required',
            'company_size' => 'required',
            'position' => 'required',
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'password' => 'required',
            'address' => 'required',
            'city' => 'required',
            'postal_code' => 'required',
            'province' => 'required',
            'message' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('signup')->with('error',$validateUser->errors());
        }
        else
        {
            try 
            {
                $postdata = array(
                    'business_name' => $request->business_name,
                    'primary_business' => $request->primary_business,
                    'company_size' => $request->company_size,
                    'position' => $request->position,
                    'name' => $request->name,
                    'email' => $request->email,
                    'password' => md5($request->password),
                    'text_password' => $request->password,
                    'phone' => $request->phone,
                    'address' => $request->address,
                    'city' => $request->city,
                    'postal_code' => $request->postal_code,
                    'province' => $request->province,
                    'message' => $request->message,
                    'role' => 'dealer',
                    'status' => 'active',
                    'created_at' => date('Y-m-d H:i:s'),
                );
                $insertid = DB::table('tbl_dealer')
                ->insertGetId($postdata);
                if($insertid)
                {
                    $userdata = DB::table('tbl_dealer')
                    ->where('id',$insertid)
                    ->where('status','active')
                    ->where('role','dealer')
                    ->select('*')
                    ->first();
                    Session::put('user_data', $userdata);
                    return redirect('web-order');
                }
                else
                {
                    return redirect('signup')->with('error', 'Something went wrong');
                }
            }
            catch (Exception $e) {
                return redirect('signup')->with('error',$e->getMessage());
            }
        }
    }

    public function remove_business_image(Request $request){
        if($request->segment(3))
        {
            $id = $request->segment(3);
            $deletimage = DB::table('tbl_business_image')
            ->where('id',$id)
            ->delete();
            if($deletimage){
                return redirect('user/user-profile')->with('success','Business image deleted');
            }else{
                return redirect('user/user-profile')->with('error', 'Unable to delete image');
            }
        }else{
            return redirect('user/user-profile')->with('error', 'Invalid request');
        }
    }
    public function save_enquiry(Request $request){
        $postdata = array(
            'name' => $request->name,
            'email' => $request->email,
            'vehicle_information' => $request->vehicle_information,
            'subject' => $request->subject,
            'message' => $request->message,
            'created_at' => date('Y-m-d H:i:s')
        );
        $insert = DB::table('tbl_inquiry')
        ->insert($postdata);
        if($insert){
            $res = array(
                'status'=>true,
                'color'=>'success',
                'message'=>'Enquiry sent, We will contact you soon.',
            );
        }else{
            $res = array(
                'status'=>false,
                'color'=>'danger',
                'message'=>'Something went wrong, Please try again.',
            );
        }
        echo json_encode($res);
    }

    public function save_review(Request $request){
        $postdata = array(
            'user_id' => Session::get('user_data')->id,
            'product_id' => $request->product_id,
            'rating' => $request->rating,
            'review' => $request->review,
            'created_at' => date('Y-m-d H:i:s')
        );
        $insert = DB::table('tbl_product_rating')
        ->insert($postdata);
        if($insert){
            return redirect('dealer/product-detail/'.$request->slug)->with('success', 'Review sent');
        }else{
            return redirect('dealer/product-detail/'.$request->slug)->with('error', 'Something went wrong');
        }
    }
    public function edit_business(Request $request){
        $categorylist = DB::table('tbl_master_category')
        ->select('*')
        ->where('status','active')
        ->get();
        $business_detail = DB::table('tbl_business_listing')
        ->select('tbl_business_listing.*','tbl_master_category.category_name')
        ->join('tbl_master_category', 'tbl_master_category.id', '=', 'tbl_business_listing.category')
        ->where('tbl_business_listing.slug',$request->slug)
        ->first();
        $opening_time = DB::table('tbl_business_opening_time')
        ->select('*')
        ->where('business_id',$business_detail->id)
        ->get();
        return view('edit_business')
        ->with('opening_time',$opening_time)
        ->with('business_detail',$business_detail)
        ->with('categorylist',$categorylist);
    }
    public function product_list(){
        return view('product_list');
    }
    public function get_product_list(Request $request){

        $product_type = $request->type;
        $title = $request->title;
        $price = $request->price;
        $productlist = DB::table('tbl_product_listing')
        ->select('*')
        ->where('status','active')
        ->when(!empty($product_type), function ($query) use ($product_type) {
            return $query->where('product_type', $product_type);
        })
        ->when(!empty($title), function ($query) use ($title) {
            return $query->where('title', 'like', '%' . $title . '%');
        })
        ->when(!empty($price), function ($query) use ($price) {
            return $query->whereBetween('price', [0,$price]);
        })
        ->get();
        // dd([
        //     'sql' => $productlist->toSql(),
        //     'bindings' => $productlist->getBindings()
        // ]);
        $res = array(
            'status'=>true,
            'data'=> $productlist
        );
        echo json_encode($res);
    }
    public function product_detail(Request $request){
        $slug = $request->slug;
        $product_detail = DB::table('tbl_product_listing')
        ->select(DB::raw('*, (SELECT ROUND(AVG(rating), 0) FROM tbl_product_rating) as average_rating'))
        ->where('status','active')
        ->where('slug',$slug)
        ->first();

        $review_list = DB::table('tbl_product_rating')
        ->select('tbl_product_rating.*','tbl_dealer.name')
        ->join('tbl_dealer', 'tbl_dealer.id', '=', 'tbl_product_rating.user_id')
        ->where('product_id',$product_detail->id)
        ->get();

        return view('product_detail')
        ->with('review_list',$review_list)
        ->with('product_detail',$product_detail);
    }
}
