<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\admin\stdClass;

class Admincontroller extends Controller
{
    public function index(){
        return view('admin/login');
    }
    public function login(Request $request)
    {

        $validateUser = Validator::make($request->all(), [
            'email' => 'required',
            'password' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin')->with('error',$validateUser->errors());
        }
        else
        {
            $admindata = DB::table('tbl_admin')
            ->where('email',$request->email)
            ->where('status','active')
            ->where('password',md5($request->password))
            ->select('*')
            ->first();
            if($admindata)
            {
                Session::put('admin_data', $admindata);
                return redirect('admin/dashboard');
            }
            else
            {
                return redirect('admin')->with('error', 'Invalid credential');;
            }
        }

    }
    public function logout(){
        Session::forget('admin_data');
        return redirect('admin');
    }
    public function dashboard()
    {
        $tire_count = DB::table('tbl_products')
        ->select('id')
        ->where('product_category',1)
        ->count();
        $wheel_count = DB::table('tbl_products')
        ->select('id')
        ->where('product_category',2)
        ->count();
        $all_product = DB::table('tbl_products')
        ->select('id')
        ->count();
        $new_order = DB::table('tbl_order')
        ->select('id')
        ->where('status','received')
        ->count();
        $low_stock = DB::table('tbl_products')
        ->select('id')
        ->where('stock_qty','<=',10)
        ->count();
        $top_product = DB::table('tbl_order_product')
        ->select('product_name', DB::raw('SUM(qty) as total_qty'))
        ->groupBy('product_id')
        ->groupBy('product_name')
        ->limit(3)
        ->orderBy('total_qty','desc')
        ->get();
        $recent_order = DB::table('tbl_order_product')
        ->select('tbl_order_product.id','tbl_order.status','tbl_order_product.product_name','tbl_order_product.order_id','tbl_order_product.product_category','tbl_order_product.qty')
        ->join('tbl_order', 'tbl_order.order_id', '=', 'tbl_order_product.order_id')
        ->limit(3)
        ->orderBy('tbl_order_product.id','desc')
        ->get();
        $productdata = DB::table('tbl_products')
        ->select('tbl_products.id','tbl_products.title','tbl_products.main_price','tbl_products.offer_price',
        'tbl_products.sku','tbl_products.offer_price','tbl_products.stock_qty','tbl_product_category.category','tbl_product_type.product_type','tbl_vehicle_type.vehicle_type','tbl_products.size','tbl_products.rim_size')
        ->join('tbl_vehicle_type', 'tbl_vehicle_type.id', '=', 'tbl_products.vehicle_type')
        ->join('tbl_product_type', 'tbl_product_type.id', '=', 'tbl_products.product_type')
        ->join('tbl_product_category', 'tbl_product_category.id', '=', 'tbl_products.product_category')
        ->orderBy('id','DESC')
        ->limit(5)
        ->orderBy('tbl_products.id','desc')
        ->get();
        return view('admin/dashboard')
        ->with('tire_count',$tire_count)
        ->with('wheel_count',$wheel_count)
        ->with('all_product',$all_product)
        ->with('new_order',$new_order)
        ->with('low_stock',$low_stock)
        ->with('top_product',$top_product)
        ->with('recent_order',$recent_order)
        ->with('productdata',$productdata);
    }

    public function manage_order()
    {
        $orderdata = DB::table('tbl_order')
        ->select('tbl_order.*','tbl_dealer.business_name','tbl_dealer.name')
        ->join('tbl_dealer', 'tbl_dealer.id', '=', 'tbl_order.user_id')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/order')->with('orderdata',$orderdata);
    }

    public function manage_dealer(Request $request)
    {
        if($request->id)
        {
            $dealer_detail = DB::table('tbl_dealer')
            ->select('*')
            ->where('id',$request->id)
            ->first();
        }
        else
        {
            $dealer_detail = (object) array();
        }
        $dealerdata = DB::table('tbl_dealer')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/dealer')->with('dealerdata',$dealerdata)->with('dealer_detail',$dealer_detail);
    }
    public function save_dealer(Request $request){
        $validateUser = Validator::make($request->all(), [
            'business_name' => 'required',
            'primary_business' => 'required',
            'company_size' => 'required',
            'position' => 'required',
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'password' => 'required',
            'address' => 'required',
            'city' => 'required',
            'postal_code' => 'required',
            'province' => 'required',
            'message' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-dealer')->with('error',$validateUser->errors());
        }
        else
        {
            try 
            {
                $postdata = array(
                    'business_name' => $request->business_name,
                    'primary_business' => $request->primary_business,
                    'company_size' => $request->company_size,
                    'position' => $request->position,
                    'name' => $request->name,
                    'email' => $request->email,
                    'password' => md5($request->password),
                    'text_password' => $request->password,
                    'phone' => $request->phone,
                    'address' => $request->address,
                    'city' => $request->city,
                    'postal_code' => $request->postal_code,
                    'province' => $request->province,
                    'message' => $request->message,
                    'role' => 'dealer',
                    'status' => 'active',
                    'created_at' => date('Y-m-d H:i:s'),
                );
                $insertid = DB::table('tbl_dealer')
                ->insertGetId($postdata);
                if($insertid)
                {
                    return redirect('admin/manage-dealer')->with('success', 'Dealer account created');
                }
                else
                {
                    return redirect('admin/manage-dealer')->with('error', 'Something went wrong');
                }
            }
            catch (Exception $e) {
                return redirect('admin/manage-dealer')->with('error',$e->getMessage());
            }
        }
    }
    public function update_dealer(Request $request){
        $validateUser = Validator::make($request->all(), [
            'business_name' => 'required',
            'primary_business' => 'required',
            'company_size' => 'required',
            'position' => 'required',
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'password' => 'required',
            'address' => 'required',
            'city' => 'required',
            'postal_code' => 'required',
            'province' => 'required',
            'message' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-product/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'business_name' => $request->business_name,
                'primary_business' => $request->primary_business,
                'company_size' => $request->company_size,
                'position' => $request->position,
                'name' => $request->name,
                'email' => $request->email,
                'password' => md5($request->password),
                'text_password' => $request->password,
                'phone' => $request->phone,
                'address' => $request->address,
                'city' => $request->city,
                'postal_code' => $request->postal_code,
                'province' => $request->province,
                'message' => $request->message,
                'status' => $request->status,
                'updated_at' => date('Y-m-d H:i:s'),
            );
            $updatedata = DB::table('tbl_dealer')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-dealer/'.$request->id)->with('success','Dealer updated');
            }
            else
            {
                return redirect('admin/edit-dealer/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_dealer(Request $request){
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_dealer')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Dealer deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete dealer',
                );
            }
            echo json_encode($res);
        }
    }
    public function get_order_product(Request $request)
    {
        $orderdata = DB::table('tbl_order_product')
        ->select('tbl_order_product.*')
        ->where('order_id',$request->order_id)
        ->orderBy('id','DESC')
        ->get();
        return $orderdata;
    }
    public function product_return_request()
    {
        $returndata = DB::table('tbl_return_request')
        ->select('tbl_return_request.*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/return_request')->with('returndata',$returndata);
    }
    public function get_return_product(Request $request)
    {
        $return_id = $request->return_id;
        $productdata = DB::table('tbl_return_request_product')
        ->select('tbl_return_request_product.*')
        ->where('return_id',$return_id)
        ->orderBy('id','DESC')
        ->get()
        ->map(function ($product_image) use ($return_id) {
        $product_image->image = DB::table('tbl_return_request_product_image')
            ->select('tbl_return_request_product_image.product_image')
            ->where('return_id', $return_id)
            ->where('product_id', $product_image->id)
            ->orderBy('id', 'ASC')
            ->get() 
            ->map(function ($image) {
                $image->product_image = url('/')."/".$image->product_image;
                return $image;
            });
        return $product_image;
        });
        return $productdata;
    }
    public function product_warranty_request()
    {
        $warrantydata = DB::table('tbl_warranty_request')
        ->select('tbl_warranty_request.*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/warranty_request')->with('warrantydata',$warrantydata);
    }
}
