<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class Businesscontroller extends Controller
{
    public function index()
    {
        $businessdata = DB::table('tbl_business_listing')
        ->join('tbl_master_category', 'tbl_business_listing.category', '=', 'tbl_master_category.id')
        ->select('tbl_business_listing.*','tbl_master_category.category_name')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/business_list')->with('businessdata',$businessdata);
    }
    public function new_business(Request $request)
    {
        $userlist = DB::table('tbl_users')
        ->select('*')
        ->where('status','active')
        ->get();

        $categorylist = DB::table('tbl_master_category')
        ->select('*')
        ->where('status','active')
        ->get();

        if(!empty(request()->segment(3))){
            $id = request()->segment(3);
            $business_data = DB::table('tbl_business_listing')
            ->select('*')
            ->where('id',$id)
            ->first();
        }else{
            $business_data = (object)[];
        }
        return view('admin/new_business')->with('business_data',$business_data)->with('userlist',$userlist)->with('categorylist',$categorylist);
    }
    public function save_business(Request $request){
        $validateUser = Validator::make($request->all(), [
            'user_id' => 'required',
            'title' => 'required',
            'slug' => 'required',
            'category' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'city' => 'required',
            'state' => 'required',
            'zip_code' => 'required',
            'description'=>'required',
            'status' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/new-business')->with('error',$validateUser->errors());
        }
        else
        {
            if($request->hasFile('image')){
                $image = $request->file('image');
                $imageName = time().'.'.$image->extension();
                $image->move(public_path('uploads/business'), $imageName);
                $image_name = 'uploads/business/'.$imageName;
            }else{
                $image_name = '';
            }

            $postdata = array(
                'user_id' => $request->user_id,
                'title' => $request->title,
                'slug' => $request->slug,
                'category' => $request->category,
                'subcategory' => $request->subcategory,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'city' => $request->city,
                'state' => $request->state,
                'zip_code' => $request->zip_code,
                'description' => $request->description,
                'website' => $request->website,
                'meta_title' => $request->meta_title,
                'meta_desc' => $request->meta_description,
                'keywords' => $request->meta_keyword,
                'status' => $request->status,
                'image' => $image_name,
                'created_at' => date('Y-m-d H:i:s'),
            );
            $savedata = DB::table('tbl_business_listing')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/new-business')->with('success','Business saved');
            }
            else
            {
                return redirect('admin/new-business')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_business(Request $request){
        $validateUser = Validator::make($request->all(), [
            'user_id' => 'required',
            'title' => 'required',
            'slug' => 'required',
            'category' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'city' => 'required',
            'state' => 'required',
            'zip_code' => 'required',
            'description'=>'required',
            'status' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-business/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            if($request->hasFile('image')){
                $image = $request->file('image');
                $imageName = time().'.'.$image->extension();
                $image->move(public_path('uploads/business'), $imageName);
                $imageName = 'uploads/business/'.$imageName;
            }else{
                $imageName = $request->hidden_image;
            }
            $postdata = array(
                'user_id' => $request->user_id,
                'title' => $request->title,
                'slug' => $request->slug,
                'category' => $request->category,
                'subcategory' => $request->subcategory,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'city' => $request->city,
                'state' => $request->state,
                'zip_code' => $request->zip_code,
                'description' => $request->description,
                'website' => $request->website,
                'meta_title' => $request->meta_title,
                'meta_desc' => $request->meta_description,
                'keywords' => $request->meta_keyword,
                'status' => $request->status,
                'image' => $imageName,
                'updated_at' => date('Y-m-d H:i:s'),
            );
            $updatedata = DB::table('tbl_business_listing')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-business/'.$request->id)->with('success','Business updated');
            }
            else
            {
                return redirect('admin/edit-business/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function remove_business(Request $request){
        if($request->segment(3))
        {
            $id = $request->segment(3);
            $deleteblog = DB::table('tbl_business_listing')
            ->where('id',$id)
            ->delete();
            if($deleteblog){
                return redirect('admin/business-list')->with('success','Business deleted');
            }else{
                return redirect('admin/business-list')->with('error', 'Unable to delete user');
            }
        }else{
            return redirect('admin/business-list')->with('error', 'Invalid request');
        }
    }
    public function getSubcategories($category_id)
    {
        $subcategories = DB::table('tbl_master_subcategory')->where('category_id', $category_id)->get();
        return response()->json($subcategories);
    }
    public function change_listing_status(Request $request){
            
            $id = $request->id;
            $status = $request->status;
            $deleteblog = DB::table('tbl_business_listing')
            ->where('id',$id)
            ->update(array('status'=>$status));
            if($deleteblog){
                $res = array(
                    'status' => true,
                    'msg'=>'Business status change to '.$status
                );
                echo json_encode($res);
            }else{
                $res = array(
                    'status' => false,
                    'msg'=>'Unable to change status'
                );
                echo json_encode($res);
            }
    }

    public function package_list()
    {
        $packagedata = DB::table('tbl_subscription_plans')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/package_list')->with('packagedata',$packagedata);
    }
    public function new_package(Request $request)
    {
        if(!empty(request()->segment(3))){
            $id = request()->segment(3);
            $package_data = DB::table('tbl_subscription_plans')
            ->select('*')
            ->where('id',$id)
            ->first();
        }else{
            $package_data = (object)[];
        }
        return view('admin/new_package')->with('package_data',$package_data);
    }
    public function save_package(Request $request){
        $validateUser = Validator::make($request->all(), [
            'name' => 'required',
            'price' => 'required',
            'duration' => 'required',
            'max_listing' => 'required',
            'status' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/new-package')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'name' => $request->name,
                'price' => $request->price,
                'duration' => $request->duration,
                'max_listing' => $request->max_listing,
                'feature_listing' => $request->feature_listing,
                'status' => $request->status,
                'created_at' => date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_subscription_plans')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/new-package')->with('success','Package saved');
            }
            else
            {
                return redirect('admin/new-package')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_package(Request $request){
        $validateUser = Validator::make($request->all(), [
            'name' => 'required',
            'price' => 'required',
            'duration' => 'required',
            'max_listing' => 'required',
            'status' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-category/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'name' => $request->name,
                'price' => $request->price,
                'duration' => $request->duration,
                'max_listing' => $request->max_listing,
                'feature_listing' => $request->feature_listing,
                'status' => $request->status,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_subscription_plans')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-package/'.$request->id)->with('success','Package updated');
            }
            else
            {
                return redirect('admin/edit-package/'.$request->id)->with('error', 'Unable to update data');
            }
        }
    }
    public function remove_package(Request $request){
        if($request->segment(3))
        {
            $id = $request->segment(3);
            $deleteblog = DB::table('tbl_subscription_plans')
            ->where('id',$id)
            ->delete();
            if($deleteblog){
                return redirect('admin/package-list')->with('success','Package deleted');
            }else{
                return redirect('admin/package-list')->with('error', 'Unable to delete package');
            }
        }else{
            return redirect('admin/package-list')->with('error', 'Invalid request');
        }
    }
}
