<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Session;

class Businessownercontroller extends Controller
{
    public function index()
    {
        $id = Session::get('admin_data')->id;
        $businessdata = DB::table('tbl_business_listing')
        ->join('tbl_master_category', 'tbl_business_listing.category', '=', 'tbl_master_category.id')
        ->select('tbl_business_listing.*','tbl_master_category.category_name')
        ->orderBy('id','DESC')
        ->where('user_id',$id)
        ->get();
        return view('business_owner/business_list')->with('businessdata',$businessdata);
    }
    public function new_business(Request $request)
    {
        $userlist = DB::table('tbl_users')
        ->select('*')
        ->where('status','active')
        ->get();

        $categorylist = DB::table('tbl_master_category')
        ->select('*')
        ->where('status','active')
        ->get();

        if(!empty(request()->segment(3))){
            $id = request()->segment(3);
            $business_data = DB::table('tbl_business_listing')
            ->select('*')
            ->where('id',$id)
            ->first();
        }else{
            $business_data = (object)[];
        }
        return view('business_owner/new_business')->with('business_data',$business_data)->with('userlist',$userlist)->with('categorylist',$categorylist);
    }
    public function save_business(Request $request){
        $validateUser = Validator::make($request->all(), [
            'title' => 'required',
            'slug' => 'required',
            'category' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'city' => 'required',
            'state' => 'required',
            'zip_code' => 'required',
            'description'=>'required',
            'status' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('business-owner/new-business')->with('error',$validateUser->errors());
        }
        else
        {
            if($request->hasFile('image')){
                $image = $request->file('image');
                $imageName = time().'.'.$image->extension();
                $image->move(public_path('uploads/business'), $imageName);
                $image_name = 'uploads/business/'.$imageName;
            }else{
                $image_name = '';
            }

            $postdata = array(
                'user_id' => Session::get('admin_data')->id,
                'title' => $request->title,
                'slug' => $request->slug,
                'category' => $request->category,
                'subcategory' => $request->subcategory,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'city' => $request->city,
                'state' => $request->state,
                'zip_code' => $request->zip_code,
                'description' => $request->description,
                'website' => $request->website,
                'meta_title' => $request->meta_title,
                'meta_desc' => $request->meta_description,
                'keywords' => $request->meta_keyword,
                'status' => $request->status,
                'image' => $image_name,
                'created_at' => date('Y-m-d H:i:s'),
            );
            $savedata = DB::table('tbl_business_listing')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('business-owner/new-business')->with('success','Business saved');
            }
            else
            {
                return redirect('business-owner/new-business')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_business(Request $request){
        $validateUser = Validator::make($request->all(), [
            'title' => 'required',
            'slug' => 'required',
            'category' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'city' => 'required',
            'state' => 'required',
            'zip_code' => 'required',
            'description'=>'required',
            'status' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('business-owner/edit-business/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            if($request->hasFile('image')){
                $image = $request->file('image');
                $imageName = time().'.'.$image->extension();
                $image->move(public_path('uploads/business'), $imageName);
                $imageName = 'uploads/business/'.$imageName;
            }else{
                $imageName = $request->hidden_image;
            }
            $postdata = array(
                'title' => $request->title,
                'slug' => $request->slug,
                'category' => $request->category,
                'subcategory' => $request->subcategory,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'city' => $request->city,
                'state' => $request->state,
                'zip_code' => $request->zip_code,
                'description' => $request->description,
                'website' => $request->website,
                'meta_title' => $request->meta_title,
                'meta_desc' => $request->meta_description,
                'keywords' => $request->meta_keyword,
                'status' => $request->status,
                'image' => $imageName,
                'updated_at' => date('Y-m-d H:i:s'),
            );
            $updatedata = DB::table('tbl_business_listing')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('business-owner/edit-business/'.$request->id)->with('success','Business updated');
            }
            else
            {
                return redirect('business-owner/edit-business/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function remove_business(Request $request){
        if($request->segment(3))
        {
            $id = $request->segment(3);
            $deleteblog = DB::table('tbl_business_listing')
            ->where('id',$id)
            ->delete();
            if($deleteblog){
                return redirect('business-owner/business-list')->with('success','Business deleted');
            }else{
                return redirect('business-owner/business-list')->with('error', 'Unable to delete user');
            }
        }else{
            return redirect('business-owner/business-list')->with('error', 'Invalid request');
        }
    }
}
