<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;

class Productcontroller extends Controller
{
    public function manage_product(){
        $productdata = DB::table('tbl_products')
        ->select('tbl_products.id','tbl_products.title','tbl_products.main_price','tbl_products.offer_price',
        'tbl_products.sku','tbl_products.offer_price','tbl_products.stock_qty','tbl_product_category.category','tbl_product_type.product_type','tbl_vehicle_type.vehicle_type','tbl_products.size','tbl_products.rim_size')
        ->join('tbl_vehicle_type', 'tbl_vehicle_type.id', '=', 'tbl_products.vehicle_type')
        ->join('tbl_product_type', 'tbl_product_type.id', '=', 'tbl_products.product_type')
        ->join('tbl_product_category', 'tbl_product_category.id', '=', 'tbl_products.product_category')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/product')->with('productdata',$productdata);
    }
    public function manage_inventory(Request $request)
    {
        $product_category_list = DB::table('tbl_product_category')
        ->select('*')
        ->where('status','active')
        ->orderBy('id','DESC')
        ->get();

        $vehicle_type_list = DB::table('tbl_vehicle_type')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();

        $rim_width_list = DB::table('tbl_rim_width')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();

        $speed_rating_list = DB::table('tbl_speed_rating')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();

        $load_index_list = DB::table('tbl_load_index')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();

        $diameter_list = DB::table('tbl_diameter')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();

        $product_type_list = DB::table('tbl_product_type')
        ->select('*')
        ->where('status','active')
        ->orderBy('id','DESC')
        ->get();


        if($request->id)
        {
            $product_detail = DB::table('tbl_products')
            ->select('tbl_products.*','tbl_product_category.category')
            ->join('tbl_product_category', 'tbl_product_category.id', '=', 'tbl_products.product_category')
            ->where('tbl_products.id',$request->id)
            ->orderBy('tbl_products.id','DESC')
            ->first();
            $product_image = DB::table('tbl_product_image')
            ->select('*')
            ->where('product_id',$request->id)
            ->get();

        }
        else
        {
            $product_detail = (object) array();
            $product_image = array();
        }
        $productdata = DB::table('tbl_products')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/inventory')
        ->with('product_type_list',$product_type_list)
        ->with('product_category_list',$product_category_list)
        ->with('vehicle_type_list',$vehicle_type_list)
        ->with('rim_width_list',$rim_width_list)
        ->with('speed_rating_list',$speed_rating_list)
        ->with('load_index_list',$load_index_list)
        ->with('diameter_list',$diameter_list)
        ->with('productdata',$productdata)
        ->with('product_image',$product_image)
        ->with('product_detail',$product_detail);
    }
    public function save_product(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'title' => 'required',
            'stock_qty' => 'required',
            'main_price' => 'required',
            'offer_price' => 'required',
            'status' => 'required',
            'product_category' => 'required',
            'vehicle_type' => 'required',
            'product_type' => 'required',
            'onsale_only' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-inventory')->with('error',$validateUser->errors());
        }
        else
        {
            $image_arr = [];
            $main_image = '';

            if ($request->hasFile('image')) {
                foreach ($request->file('image') as $key => $imgFile) {
                    $imageName = time().'_'.$key.'.'.$imgFile->extension();
                    $imgFile->move(base_path('uploads/product'), $imageName);
                    $imgPath = 'uploads/product/' . $imageName;
                    if ($key == 0) {
                        $main_image = $imgPath;
                    } else {
                        $image_arr[] = $imgPath;
                    }
                }
            }
            $postdata = array(
                'sku' => $request->sku,
                'title' => $request->title,
                'stock_qty' => $request->stock_qty,
                'status' => $request->status,
                'main_price' => $request->main_price,
                'offer_price' => $request->offer_price,
                'product_category' => $request->product_category,
                'vehicle_type' => $request->vehicle_type,
                'product_type' => $request->product_type,
                'onsale_only' => $request->onsale_only,
                'size' => $request->size,
                'rim_size' => $request->rim_size,
                'bolt_circle' => $request->bolt_circle,
                'offset_distance' => $request->offset_distance,
                'center_hub_diameter' => $request->center_hub_diameter,
                'load_speed' => $request->load_speed,
                'od_value' => $request->od_value,
                'load_index' => $request->load_index,
                'speed_rating' => $request->speed_rating,
                'rim_width_range' => $request->rim_width_range,
                'overall_diameter' => $request->overall_diameter,
                'aspect_ratio' => $request->aspect_ratio,
                'run_flat' => $request->run_flat,
                'image' => $main_image,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $insertid = DB::table('tbl_products')
            ->insertGetId($postdata);
            if($insertid)
            {
                if(count($image_arr) > 0)
                {
                    foreach ($image_arr as $im) {
                        $imagepost = array(
                        'product_id' => $insertid,
                        'image' => $im,
                        );
                        DB::table('tbl_product_image')
                        ->insert($imagepost);
                    }
                }
                return redirect('admin/manage-inventory')->with('success','Product saved');
            }
            else
            {
                return redirect('admin/manage-inventory')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_product(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'sku' => 'required',
            'title' => 'required',
            'stock_qty' => 'required',
            'main_price' => 'required',
            'offer_price' => 'required',
            'status' => 'required',
            'product_category' => 'required',
            'vehicle_type' => 'required',
            'product_type' => 'required',
            'onsale_only' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-product/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            if($request->hidden_image == '')
            {
                $image = '';
            }
            else
            {
                $image = $request->hidden_image;
            }
            $image_arr = [];
            $main_image = '';

            if ($request->hasFile('image')) {
                foreach ($request->file('image') as $key => $imgFile) {
                    $imageName = time().'_'.$key.'.'.$imgFile->extension();
                    $imgFile->move(base_path('uploads/product'), $imageName);
                    $imgPath = 'uploads/product/' . $imageName;
                    if ($key == 0 && empty($request->hidden_image)) {
                        $main_image = $imgPath;
                    } else {
                        $image_arr[] = $imgPath;
                    }
                }
            }
            $postdata = array(
                'sku' => $request->sku,
                'title' => $request->title,
                'stock_qty' => $request->stock_qty,
                'status' => $request->status,
                'main_price' => $request->main_price,
                'offer_price' => $request->offer_price,
                'product_category' => $request->product_category,
                'vehicle_type' => $request->vehicle_type,
                'product_type' => $request->product_type,
                'onsale_only' => $request->onsale_only,
                'size' => $request->size,
                'rim_size' => $request->rim_size,
                'bolt_circle' => $request->bolt_circle,
                'offset_distance' => $request->offset_distance,
                'center_hub_diameter' => $request->center_hub_diameter,
                'load_speed' => $request->load_speed,
                'od_value' => $request->od_value,
                'load_index' => $request->load_index,
                'speed_rating' => $request->speed_rating,
                'rim_width_range' => $request->rim_width_range,
                'overall_diameter' => $request->overall_diameter,
                'aspect_ratio' => $request->aspect_ratio,
                'run_flat' => $request->run_flat,
                'image' => $main_image,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_products')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                if(count($image_arr) > 0)
                {
                    foreach ($image_arr as $im) {
                        $imagepost = array(
                        'product_id' => $request->id,
                        'image' => $im,
                        );
                        DB::table('tbl_product_image')
                        ->insert($imagepost);
                    }
                }
                return redirect('admin/edit-product/'.$request->id)->with('success','Product updated');
            }
            else
            {
                return redirect('admin/edit-product/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_product(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_products')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Product deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete product',
                );
            }
            echo json_encode($res);
        }
    }
    public function manage_brand(Request $request)
    {
        if($request->id)
        {
            $brand_detail = DB::table('tbl_brand')
            ->select('*')
            ->where('id',$request->id)
            ->orderBy('id','DESC')
            ->first();
        }
        else
        {
            $brand_detail = (object) array();
        }
        $branddata = DB::table('tbl_brand')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/brand')->with('branddata',$branddata)->with('brand_detail',$brand_detail);
    }
    public function save_brand(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'brand_name' => 'required',
            'status' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-brand')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'brand_name' => $request->brand_name,
                'status' => $request->status,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_brand')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-brand')->with('success','Brand saved');
            }
            else
            {
                return redirect('admin/manage-brand')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_brand(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'brand_name' => 'required',
            'status' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-brand/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'brand_name' => $request->brand_name,
                'status' => $request->status,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_brand')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-brand/'.$request->id)->with('success','Brand updated');
            }
            else
            {
                return redirect('admin/edit-brand/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_brand(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_brand')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Brand deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete brand',
                );
            }
            echo json_encode($res);
        }
    }
    public function manage_model(Request $request)
    {
        $branddata = DB::table('tbl_brand')
        ->select('*')
        ->where('status','active')
        ->orderBy('id','DESC')
        ->get();
        if($request->id)
        {
            $model_detail = DB::table('tbl_model')
            ->select('*')
            ->where('id',$request->id)
            ->orderBy('id','DESC')
            ->first();
        }
        else
        {
            $model_detail = (object) array();
        }
        $modeldata = DB::table('tbl_model')
        ->select('tbl_model.*','tbl_brand.brand_name')
        ->join('tbl_brand', 'tbl_brand.id', '=', 'tbl_model.brand_id')
        ->orderBy('tbl_model.id','DESC')
        ->get();
        $vehicle_type_list = DB::table('tbl_vehicle_type')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/model')->with('vehicle_type_list',$vehicle_type_list)->with('modeldata',$modeldata)->with('model_detail',$model_detail)->with('branddata',$branddata);
    }
    public function save_model(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'brand' => 'required',
            'model_name' => 'required',
            'vehicle_type' => 'required',
            'status' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-brand')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'model_name' => $request->model_name,
                'brand_id' => $request->brand,
                'vehicle_type' => $request->vehicle_type,
                'status' => $request->status,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_model')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-model')->with('success','Model saved');
            }
            else
            {
                return redirect('admin/manage-model')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_model(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'brand' => 'required',
            'model_name' => 'required',
            'vehicle_type' => 'required',
            'status' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-model/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'model_name' => $request->model_name,
                'brand_id' => $request->brand,
                'vehicle_type' => $request->vehicle_type,
                'status' => $request->status,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_model')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-model/'.$request->id)->with('success','Model updated');
            }
            else
            {
                return redirect('admin/edit-model/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_model(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_model')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Model deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete model',
                );
            }
            echo json_encode($res);
        }
    }
    public function manage_product_type(Request $request)
    {
        if($request->id)
        {
            $product_type_detail = DB::table('tbl_product_type')
            ->select('*')
            ->where('id',$request->id)
            ->orderBy('id','DESC')
            ->first();
        }
        else
        {
            $product_type_detail = (object) array();
        }
        $producttypedata = DB::table('tbl_product_type')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/product_type')->with('producttypedata',$producttypedata)->with('product_type_detail',$product_type_detail);
    }
    public function save_product_type(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'product_type' => 'required',
            'status' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-product-type')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'product_type' => $request->product_type,
                'status' => $request->status,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_product_type')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-product-type')->with('success','Product type saved');
            }
            else
            {
                return redirect('admin/manage-product-type')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_product_type(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'product_type' => 'required',
            'status' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-product-type/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'product_type' => $request->product_type,
                'status' => $request->status,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_product_type')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-product-type/'.$request->id)->with('success','Product type updated');
            }
            else
            {
                return redirect('admin/edit-product-type/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_product_type(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_product_type')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Product type deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete product type',
                );
            }
            echo json_encode($res);
        }
    }

    public function manage_vehicle_type(Request $request)
    {
        if($request->id)
        {
            $vehicle_type_detail = DB::table('tbl_vehicle_type')
            ->select('*')
            ->where('id',$request->id)
            ->orderBy('id','DESC')
            ->first();
        }
        else
        {
            $vehicle_type_detail = (object) array();
        }
        $vehicletypedata = DB::table('tbl_vehicle_type')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/vehicle_type')->with('vehicletypedata',$vehicletypedata)->with('vehicle_type_detail',$vehicle_type_detail);
    }
    public function save_vehicle_type(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'vehicle_type' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-vehicle-type')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'vehicle_type' => $request->vehicle_type,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_vehicle_type')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-vehicle-type')->with('success','Vehicle type saved');
            }
            else
            {
                return redirect('admin/manage-vehicle-type')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_vehicle_type(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'vehicle_type' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-vehicle-type/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'vehicle_type' => $request->vehicle_type,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_vehicle_type')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-vehicle-type/'.$request->id)->with('success','Vehicle type updated');
            }
            else
            {
                return redirect('admin/edit-vehicle-type/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_vehicle_type(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_vehicle_type')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Vehicle type deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete product type',
                );
            }
            echo json_encode($res);
        }
    }

    public function manage_rim_width(Request $request)
    {
        if($request->id)
        {
            $rim_width_detail = DB::table('tbl_rim_width')
            ->select('*')
            ->where('id',$request->id)
            ->orderBy('id','DESC')
            ->first();
        }
        else
        {
            $rim_width_detail = (object) array();
        }
        $rimwidthdata = DB::table('tbl_rim_width')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/rim_width')->with('rimwidthdata',$rimwidthdata)->with('rim_width_detail',$rim_width_detail);
    }
    public function save_rim_width(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'rim_width' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-rim-width')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'rim_width' => $request->rim_width,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_rim_width')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-rim-width')->with('success','Rim width saved');
            }
            else
            {
                return redirect('admin/manage-rim-width')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_rim_width(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'rim_width' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-rim-width/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'rim_width' => $request->rim_width,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_rim_width')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-rim-width/'.$request->id)->with('success','Rim width updated');
            }
            else
            {
                return redirect('admin/edit-rim-width/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_rim_width(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_rim_width')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Rim width deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete product type',
                );
            }
            echo json_encode($res);
        }
    }

    public function manage_speed_rating(Request $request)
    {
        if($request->id)
        {
            $speed_rating_detail = DB::table('tbl_speed_rating')
            ->select('*')
            ->where('id',$request->id)
            ->orderBy('id','DESC')
            ->first();
        }
        else
        {
            $speed_rating_detail = (object) array();
        }
        $speedratingdata = DB::table('tbl_speed_rating')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/speed_rating')->with('speedratingdata',$speedratingdata)->with('speed_rating_detail',$speed_rating_detail);
    }
    public function save_speed_rating(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'rating_in_mph' => 'required',
            'rating_in_kmph' => 'required',
            'rating' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-speed-rating')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'rating_in_mph' => $request->rating_in_mph,
                'rating_in_kmph' => $request->rating_in_kmph,
                'rating' => $request->rating,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_speed_rating')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-speed-rating')->with('success','Speed rating saved saved');
            }
            else
            {
                return redirect('admin/manage-speed-rating')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_speed_rating(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'rating_in_mph' => 'required',
            'rating_in_kmph' => 'required',
            'rating' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-speed-rating/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'rating_in_mph' => $request->rating_in_mph,
                'rating_in_kmph' => $request->rating_in_kmph,
                'rating' => $request->rating,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_speed_rating')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-speed-rating/'.$request->id)->with('success','Rim width updated');
            }
            else
            {
                return redirect('admin/edit-speed-rating/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_speed_rating(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_speed_rating')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Speed rating width deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete product type',
                );
            }
            echo json_encode($res);
        }
    }

    public function manage_load_index(Request $request)
    {
        if($request->id)
        {
            $load_index_detail = DB::table('tbl_load_index')
            ->select('*')
            ->where('id',$request->id)
            ->orderBy('id','DESC')
            ->first();
        }
        else
        {
            $load_index_detail = (object) array();
        }
        $loadindexdata = DB::table('tbl_load_index')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/load_index')->with('loadindexdata',$loadindexdata)->with('load_index_detail',$load_index_detail);
    }
    public function save_load_index(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'load_in_kg' => 'required',
            'load_in_lbs' => 'required',
            'load_index' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-load-index')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'load_in_kg' => $request->load_in_kg,
                'load_in_lbs' => $request->load_in_lbs,
                'load_index' => $request->load_index,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_load_index')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-load-index')->with('success','Load index saved saved');
            }
            else
            {
                return redirect('admin/manage-load-index')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_load_index(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'load_in_kg' => 'required',
            'load_in_lbs' => 'required',
            'load_index' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-load-index/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'load_in_kg' => $request->load_in_kg,
                'load_in_lbs' => $request->load_in_lbs,
                'load_index' => $request->load_index,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_load_index')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-load-index/'.$request->id)->with('success','Load index updated');
            }
            else
            {
                return redirect('admin/edit-load-index/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_load_index(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_load_index')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Load index deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete product type',
                );
            }
            echo json_encode($res);
        }
    }

    public function manage_diameter(Request $request)
    {
        if($request->id)
        {
            $diameter_detail = DB::table('tbl_diameter')
            ->select('*')
            ->where('id',$request->id)
            ->orderBy('id','DESC')
            ->first();
        }
        else
        {
            $diameter_detail = (object) array();
        }
        $diameterdata = DB::table('tbl_diameter')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/diameter')->with('diameterdata',$diameterdata)->with('diameter_detail',$diameter_detail);
    }
    public function save_diameter(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'diameter' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-diameter')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'diameter' => $request->diameter,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_diameter')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-diameter')->with('success','Diameter saved');
            }
            else
            {
                return redirect('admin/manage-diameter')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_diameter(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'diameter' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-diameter/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'diameter' => $request->diameter,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_diameter')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-diameter/'.$request->id)->with('success','Diameter updated');
            }
            else
            {
                return redirect('admin/edit-diameter/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_diameter(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_diameter')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Diameter deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete diameter',
                );
            }
            echo json_encode($res);
        }
    }
    public function get_model_by_brand(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'brand_id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Brand is required',
            );
            echo json_encode($res);
        }
        else
        {
            $model_list = DB::table('tbl_model')
            ->where('brand_id',$request->brand_id)
            ->get();
            $res = array(
                'status' => true,
                'data'=>$model_list
            );
            echo json_encode($res);
        }
    }
    public function get_vehicle_variant(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'year' => 'required',
            'brand' => 'required',
            'model' => 'required',
            'vehicle_type' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => $validateUser->errors(),
            );
            echo json_encode($res);
        }
        else
        {
            $variant_list = DB::table('tbl_vehicle_info')
            ->where('year',$request->year)
            ->where('brand',$request->brand)
            ->where('model',$request->model)
            ->where('vehicle_type',$request->vehicle_type)
            ->get();
            $res = array(
                'status' => true,
                'data'=>$variant_list
            );
            echo json_encode($res);
        }
    }

    public function manage_vehicle_info(Request $request)
    {

        $vehicle_type_list = DB::table('tbl_vehicle_type')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();

        $brand_list = DB::table('tbl_brand')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();

        $rim_width_list = DB::table('tbl_rim_width')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();

        $diameter_list = DB::table('tbl_diameter')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();


        if($request->id)
        {
            $vehicle_info_detail = DB::table('tbl_vehicle_info')
            ->select('tbl_vehicle_info.*')
            ->where('tbl_vehicle_info.id',$request->id)
            ->orderBy('tbl_vehicle_info.id','DESC')
            ->first();
        }
        else
        {
            $vehicle_info_detail = (object) array();
        }
        $productdata = DB::table('tbl_vehicle_info')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/vehicle_info')
        ->with('diameter_list',$diameter_list)
        ->with('brand_list',$brand_list)
        ->with('vehicle_type_list',$vehicle_type_list)
        ->with('rim_width_list',$rim_width_list)
        ->with('productdata',$productdata)
        ->with('vehicle_info_detail',$vehicle_info_detail);
    }
    public function manage_vehicle_list()
    {
        $vehicle_list = DB::table('tbl_vehicle_info')
        ->select('tbl_vehicle_info.*','tbl_vehicle_type.vehicle_type','tbl_rim_width.rim_width','tbl_brand.brand_name','tbl_model.model_name','tbl_diameter.diameter')
        ->join('tbl_brand', 'tbl_brand.id', '=', 'tbl_vehicle_info.brand')
        ->join('tbl_model', 'tbl_model.id', '=', 'tbl_vehicle_info.model')
        ->join('tbl_rim_width', 'tbl_rim_width.id', '=', 'tbl_vehicle_info.rim_width_range')
        ->join('tbl_vehicle_type', 'tbl_vehicle_type.id', '=', 'tbl_vehicle_info.vehicle_type')
        ->join('tbl_diameter', 'tbl_diameter.id', '=', 'tbl_vehicle_info.center_hub_diameter')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/vehicle_list')->with('vehicle_list',$vehicle_list);
    }
    public function save_vehicle_info(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'year' => 'required',
            'brand' => 'required',
            'model' => 'required',
            'vehicle_variant' => 'required',
            'tire_size' => 'required',
            'vehicle_type' => 'required',
            'status' => 'required',
            'rim_size' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/manage-vehicle-info')->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'year' => $request->year,
                'brand' => $request->brand,
                'model' => $request->model,
                'vehicle_variant' => $request->vehicle_variant,
                'vehicle_type' => $request->vehicle_type,
                'size' => $request->tire_size,
                'rim_size' => $request->rim_size,
                'bolt_circle' => $request->bolt_circle,
                'offset_distance' => $request->offset_distance,
                'load_speed' => $request->load_speed,
                'od_value' => $request->od_value,
                'rim_width_range' => $request->rim_width_range,
                'inflation_front' => $request->inflation_front,
                'inflation_rear' => $request->inflation_rear,
                'center_hub_diameter' => $request->center_hub_diameter,
                'status' => $request->status,
                'created_at'=>date('Y-m-d H:i:s')
            );
            $savedata = DB::table('tbl_vehicle_info')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/manage-vehicle-info')->with('success','Vehicle info saved');
            }
            else
            {
                return redirect('admin/manage-vehicle-info')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_vehicle_info(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'year' => 'required',
            'brand' => 'required',
            'model' => 'required',
            'vehicle_variant' => 'required',
            'tire_size' => 'required',
            'vehicle_type' => 'required',
            'status' => 'required',
            'rim_size' => 'required'
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-vehicle-info/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            $postdata = array(
                'year' => $request->year,
                'brand' => $request->brand,
                'model' => $request->model,
                'vehicle_variant' => $request->vehicle_variant,
                'vehicle_type' => $request->vehicle_type,
                'size' => $request->tire_size,
                'rim_size' => $request->rim_size,
                'bolt_circle' => $request->bolt_circle,
                'offset_distance' => $request->offset_distance,
                'load_speed' => $request->load_speed,
                'od_value' => $request->od_value,
                'rim_width_range' => $request->rim_width_range,
                'inflation_front' => $request->inflation_front,
                'inflation_rear' => $request->inflation_rear,
                'center_hub_diameter' => $request->center_hub_diameter,
                'status' => $request->status,
                'updated_at' => date('Y-m-d H:i:s')
            );
            $updatedata = DB::table('tbl_vehicle_info')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-vehicle-info/'.$request->id)->with('success','Vehicle info updated');
            }
            else
            {
                return redirect('admin/edit-vehicle-info/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function delete_vehicle_info(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            $delete = DB::table('tbl_vehicle_info')
            ->where('id',$request->id)
            ->delete();
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Vehicle info deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete vehicle info',
                );
            }
            echo json_encode($res);
        }
    }
    public function delete_product_image(Request $request)
    {
        $validateUser = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            $res = array(
                'status' => false,
                'msg' => 'Id is required',
            );
            echo json_encode($res);
        }
        else
        {
            if($request->type == 'image')
            {
                $delete = DB::table('tbl_product_image')
                ->where('id',$request->id)
                ->delete();
            }
            else
            {
                $delete = DB::table('tbl_products')
                ->where('id',$request->id)
                ->update(array('image'=>''));
            }
            if($delete)
            {
                $res = array(
                    'status' => true,
                    'msg' => 'Image deleted',
                );
            }
            else
            {
                $res = array(
                    'status' => false,
                    'msg' => 'Unable to delete image',
                );
            }
            echo json_encode($res);
        }
    }
}
