<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class Usercontroller extends Controller
{
    public function index()
    {
        $userdata = DB::table('tbl_users')
        ->select('*')
        ->orderBy('id','DESC')
        ->get();
        return view('admin/user_list')->with('userdata',$userdata);
    }
    public function new_user(Request $request)
    {
        if(!empty(request()->segment(3))){
            $id = request()->segment(3);
            $user_data = DB::table('tbl_users')
            ->select('*')
            ->where('id',$id)
            ->first();
        }else{
            $user_data = (object)[];
        }
        return view('admin/new_user')->with('user_data',$user_data);
    }
    public function save_user(Request $request){
        $validateUser = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required',
            'password' => 'required',
            'phone' => 'required',
            'role' => 'required',
            'status' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/new-user')->with('error',$validateUser->errors());
        }
        else
        {
            if($request->hasFile('image')){
                $image = $request->file('image');
                $imageName = time().'.'.$image->extension();
                $image->move(base_path('uploads/user'), $imageName);
                $image_name = 'uploads/user/'.$imageName;
            }else{
                $image_name = '';
            }

            $postdata = array(
                'name' => $request->name,
                'email' => $request->email,
                'password' => md5($request->password),
                'text_password' => $request->password,
                'phone' => $request->phone,
                'role' => $request->role,
                'status' => $request->status,
                'image' => $image_name,
                'created_at' => date('Y-m-d H:i:s'),
            );
            $savedata = DB::table('tbl_users')
            ->insert($postdata);
            if($savedata)
            {
                return redirect('admin/new-user')->with('success','User saved');
            }
            else
            {
                return redirect('admin/new-user')->with('error', 'Unable to save data');
            }
        }
    }
    public function update_user(Request $request){
        $validateUser = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required',
            'password' => 'required',
            'phone' => 'required',
            'role' => 'required',
            'status' => 'required',
        ]);
        if ($validateUser->fails()) 
        {
            return redirect('admin/edit-user/'.$request->id)->with('error',$validateUser->errors());
        }
        else
        {
            if($request->hasFile('image')){
                $image = $request->file('image');
                $imageName = time().'.'.$image->extension();
                $image->move(base_path('uploads/user'), $imageName);
                $imageName = 'uploads/user/'.$imageName;
            }else{
                $imageName = $request->hidden_image;
            }
            $postdata = array(
                'name' => $request->name,
                'email' => $request->email,
                'password' => md5($request->password),
                'text_password' => $request->password,
                'phone' => $request->phone,
                'role' => $request->role,
                'status' => $request->status,
                'image' => $imageName,
                'updated_at' => date('Y-m-d H:i:s'),
            );
            $updatedata = DB::table('tbl_users')
            ->where('id',$request->id)
            ->update($postdata);
            if($updatedata)
            {
                return redirect('admin/edit-user/'.$request->id)->with('success','User updated');
            }
            else
            {
                return redirect('admin/edit-user/'.$request->id)->with('error', 'Unable to update data');;
            }
        }
    }
    public function remove_user(Request $request){
        if($request->segment(3))
        {
            $id = $request->segment(3);
            $deleteblog = DB::table('tbl_users')
            ->where('id',$id)
            ->delete();
            if($deleteblog){
                return redirect('admin/user-list')->with('success','User deleted');
            }else{
                return redirect('admin/user-list')->with('error', 'Unable to delete user');
            }
        }else{
            return redirect('admin/user-list')->with('error', 'Invalid request');
        }
    }
}
