<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_product_listing', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('title');
            $table->string('meta_title')->nullable();
            $table->string('keywords')->nullable();
            $table->string('meta_desc')->nullable();
            $table->string('slug');
            $table->integer('stock');
            $table->string('stock_status');
            $table->string('description');
            $table->float('price', 8, 2);
            $table->string('product_type');
            $table->unsignedBigInteger('user_id');
            $table->string('image')->nullable();
            $table->enum('status', ['active','inactive'])->default('inactive');
            $table->foreign('user_id')->references('id')->on('tbl_users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_business_listing');
    }
};
