<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_order', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->string('order_id');
            $table->string('shipping_address');
            $table->string('shipping_contact');
            $table->string('shipping_name');
            $table->string('order_date');
            $table->string('special_instruction')->nullable();
            $table->float('hst_amount', 8, 2)->default(0);
            $table->float('sub_total_amount', 8, 2)->default(0);
            $table->float('total_amount', 8, 2)->default(0);
            $table->integer('total_item')->default(0);
            $table->enum('status', ['received','shipped','delivered'])->default('received');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_order');
    }
};
