<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_dealer', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('business_name');
            $table->string('primary_business');
            $table->string('company_size');
            $table->string('position');
            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone');
            $table->string('password');
            $table->string('text_password');
            $table->string('image')->nullable();
            $table->string('address');
            $table->string('city');
            $table->string('postal_code');
            $table->string('province');
            $table->string('message');
            $table->enum('role', ['dealer'])->default('dealer');
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_dealer');
    }
};
