<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_products', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('sku');
            $table->integer('vehicle_type');
            $table->integer('product_category');
            $table->integer('product_type');
            $table->string('size')->nullable();
            $table->string('rim_size')->nullable();
            $table->string('bolt_circle')->nullable();
            $table->string('offset_distance')->nullable();
            $table->string('center_hub_diameter')->nullable();
            $table->string('load_speed')->nullable();
            $table->string('od_value')->nullable();
            $table->integer('stock_qty')->nullable();
            $table->float('main_price', 8, 2);
            $table->float('offer_price', 8, 2);
            $table->integer('load_index')->nullable();
            $table->integer('speed_rating')->nullable();
            $table->string('rim_width_range')->nullable();
            $table->integer('overall_diameter')->nullable();
            $table->string('aspect_ratio')->nullable();
            $table->string('image')->nullable();
            $table->enum('run_flat', ['Yes','No'])->default('Yes');
            $table->enum('onsale_only', ['Yes','No'])->default('Yes');
            $table->enum('status', ['active','inactive'])->default('inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_products');
    }
};
