<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_order_product', function (Blueprint $table) {
            $table->id();
            $table->integer('product_id');
            $table->integer('user_id');
            $table->string('order_id');
            $table->string('product_name');
            $table->string('size')->nullable();
            $table->string('rim_size')->nullable();
            $table->string('sku');
            $table->integer('qty');
            $table->float('otsf_fee', 8, 2)->default(0);
            $table->float('price', 8, 2);
            $table->float('total_price', 8, 2);
            $table->string('product_category');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_order_product');
    }
};
