<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_products', function (Blueprint $table) {
            $table->enum('not_for_winter', ['Yes','No'])->default('No')->after('onsale_only');
            $table->enum('for_winter_only', ['Yes','No'])->default('No')->after('not_for_winter');
            $table->enum('for_all_weather', ['Yes','No'])->default('No')->after('for_winter_only');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_products', function (Blueprint $table) {
            $table->dropColumn('not_for_winter');
            $table->dropColumn('for_winter_only');
            $table->dropColumn('for_all_weather');
        });
    }
};
