<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_warranty_request', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->string('account_no');
            $table->string('account_name');
            $table->string('address')->nullable();
            $table->string('product_type');
            $table->string('claim_category');
            $table->string('qty');
            $table->string('item_number');
            $table->string('manufacturer');
            $table->string('invoice_no');
            $table->string('purchased_date');
            $table->string('reason');
            $table->string('make');
            $table->string('model');
            $table->string('year');
            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->string('email');
            $table->string('phone');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_warranty_request');
    }
};
