<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_vehicle_info', function (Blueprint $table) {
            $table->id();
            $table->integer('year');
            $table->integer('brand');
            $table->integer('model');
            $table->string('vehicle_variant');
            $table->integer('vehicle_type');
            $table->string('size')->nullable();
            $table->string('rim_size')->nullable();
            $table->string('load_speed')->nullable();
            $table->string('rim_width_range')->nullable();
            $table->string('od_value')->nullable();
            $table->string('inflation_front')->nullable();
            $table->string('inflation_rear')->nullable();
            $table->string('bolt_circle')->nullable();
            $table->string('offset_distance')->nullable();
            $table->string('center_hub_diameter')->nullable();
            $table->enum('status', ['active','inactive'])->default('inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_vehicle_info');
    }
};
