if (
  location.hostname === "localhost" ||
  location.hostname === "127.0.0.1" ||
  location.hostname === ""
) {
  var base_url = 'http://localhost/thetireshop/';
} else {
  var base_url = "https://ecommerceseo.us/thetireshop/";
}
var search_product_category = '';
var selected_aspect_ratio = '';
var selected_tire_width = '';
var selected_rim_diameter = '';
var selected_brand = '';
var enable_search = '';
var selected_bolt_pattern = '';
var selected_rim_width = '';
var selected_diameter = '';

var load_index_filter = '';
var speed_rating_filter = '';
var product_type_filter = '';

var diameter_filter = '';
var offset_filter = '';
var rim_width_filter = '';
var overall_diameter_filter = '';

var rim_width_min_selected = false;
var rim_width_max_selected = false;

function get_all_brand(year){

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-all-brand",
        data: {},
        success: function (res, status, xhr) {
            if(res.length > 0)
            {
                var html = ``;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-1 cursor bg-white text-center m-2" style="width: auto;padding-top: 10px;padding-bottom: 10px;">
                    <a onclick="get_all_model(`+year+`,`+val.id+`,'`+val.brand_name+`');">`+val.brand_name+`</a></div>`;
                });
                $("#brand_data").html(html);
            }
            else
            {
                var html = `No data available`;
                $("#brand_data").html(html);
            }
            $("#year_tab").text(year);
            $(".tab-pane").removeClass('active');
            $("#brand_content").addClass('active');
            set_search_input(year);
        },
    });
}

function get_all_model(year,brand_id,brand_name){

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-all-model",
        data: {brand_id:brand_id},
        success: function (res, status, xhr) {
            if(res.length > 0)
            {
                var html = `<div class="row mt-3 ms-0 p-0">`;
                $.each(res, function (key, val) {

                    html += `<div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        <ul class="nav nav-tabs">
                                            <li class="col-sm-12 text-center bg-white text-dark border-end" style="text-align:left!important;"><a data-toggle="tab" id="year_tab">`+val.vehicle_type+`</a></li>
                                        </ul>
                                    </div>`;
                    $.each(val.model, function (key1, val1) {
                        html += `<div class="col-md-12">
                                    <div class="row">
                                        <div class="col-sm-1 cursor bg-white text-center m-3" style="width: auto;padding-top: 10px;padding-bottom: 10px;"><a onclick="get_all_variant(`+year+`,`+brand_id+`,`+val.id+`,`+val1.id+`,'`+val1.model_name+`');">`+val1.model_name+`</a></div>
                                    </div>
                                </div>`;
                    });
                    html += `</div>                            
                        </div>`;

                });
                html += `</div>`;
                $("#model_data").html(html);
            }
            else
            {
                var html = `No data available`;
                $("#model_data").html(html);
            }
            $("#brand_tab").text(brand_name);
            $(".tab-pane").removeClass('active');
            $("#model_content").addClass('active');
            set_search_input(brand_name);
        },
    });
}

function get_all_variant(year,brand_id,vehicle_type,model_id,model_name){

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-all-variant",
        data: {model_id:model_id,year:year,brand_id:brand_id,vehicle_type:vehicle_type},
        success: function (res, status, xhr) {
            if(res.length > 0)
            {
                var html = ``;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-1 cursor bg-white text-center mt-2 mb-2" style="width: auto;padding-top: 10px;padding-bottom: 10px;"><a onclick="get_variant_detail(`+val.id+`,'`+val.vehicle_variant+`');">`+val.vehicle_variant+`</a></div>`;
                });
                $("#variant_data").html(html);
            }
            else
            {
                var html = `No data available`;
                $("#variant_data").html(html);
            }
            $("#model_tab").text(model_name);
            $(".tab-pane").removeClass('active');
            $("#variant_content").addClass('active');
            set_search_input(model_name);
        },
    });
}

function get_variant_detail(variant_id,variant_name){

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-variant-detail",
        data: {variant_id:variant_id},
        success: function (res, status, xhr) {
            if(res.length > 0)
            {
                $("#variant_tab").text(variant_name);
                set_search_input(variant_name);
                var html = ``;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-12 cursor bg-white text-left mt-2 mb-2" style="width: 100%;padding-top: 10px;padding-bottom: 10px;">
                    <div class="row">
                        <div class="col-md-6">`+$("#inputsearch").val()+`</div>
                        <div class="col-md-6" style="text-align:right;">`;
                            $.each(val.category, function (key1, val1) {
                                if(key1 == 0){
                                    search_product_category = val1.id;
                                    var active = 'active';
                                }
                            html += `<button class="btn btn-default catbtn `+active+`" type="button" onclick="show_hide('`+val1.category+`',this,`+val1.id+`);">`+val1.category+`</button>`;
                            });
                    html += `</div>
                    </div></div>
                    <div class="col-md-12 p-0">
                        <table class="table table-bordered bg-white">
                            <thead>
                            <tr>
                                <th class="tirehead">Size</th>
                                <th class="tirehead">Load Speed</th>
                                <th class="tirehead">Rim Width</th>
                                <th class="tirehead">OD</th>
                                <th class="tirehead">Inflation</th>

                                <th class="wheelhead d-none">Rim Size</th>
                                <th class="wheelhead d-none">Bolt Circle</th>
                                <th class="wheelhead d-none">Offset</th>
                                <th class="wheelhead d-none">Center Hub</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr style="vertical-align:middle;">
                                <td class="tirehead">`+val.size+`</td>
                                <td class="tirehead">`+val.load_speed+`</td>
                                <td class="tirehead">`+val.rim_width+`</td>
                                <td class="tirehead">`+val.od_value+`</td>
                                <td class="tirehead"><p style="margin-bottom:0px;">Front:`+val.inflation_front+`</p><p>Rear:`+val.inflation_rear+`</p></td>

                                <td class="wheelhead d-none">`+val.rim_size+`</td>
                                <td class="wheelhead d-none">`+val.bolt_circle+`</td>
                                <td class="wheelhead d-none">`+val.offset_distance+`</td>
                                <td class="wheelhead d-none">`+val.diameter+`</td>


                                <td style="width:300px;">
                                <button class="btn btn-danger tirehead" onclick="product_search_by_variant('`+val.size+`');">Search Tires</button>
                                <button class="btn btn-danger wheelhead d-none" onclick="product_search_by_variant('`+val.rim_size+`');">Search Wheels</button>
                                <button class="btn btn-danger">Fitment Details</button></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>`;
                });
                $("#variant_summary_data").html(html);
            }
            else
            {
                var html = `No data available`;
                $("#variant_summary_data").html(html);
            }
            $(".tab-pane").removeClass('active');
            $("#variant_summary_content").addClass('active');
        },
    });
}

function set_search_input(val)
{
    var current_value = $("#inputsearch").val();
    var final_search_val = current_value+" "+val;
    $("#inputsearch").val(final_search_val);
}

function show_hide(type,e,id)
{
    if(type == 'Tire')
    {
        $(".tirehead").removeClass('d-none');
        $(".wheelhead").addClass('d-none');
    }
    else
    {
        $(".tirehead").addClass('d-none');
        $(".wheelhead").removeClass('d-none');
    }
    search_product_category = id;
    $(".catbtn").removeClass('active');
    $(e).addClass('active');
}

function product_search_by_variant(size)
{
        $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-variant-product",
        data: {size:size,product_category:search_product_category},
        success: function (res, status, xhr) {
            if(res.length > 0)
            {
                var html = ``;
                $.each(res, function (key, val) {
                    html += `<div class="col-md-12 p-0">
                        <table class="table table-bordered bg-white text-center">
                            <thead>
                            <tr>
                                <th>Size</th>
                                <th>Description</th>
                                <th>Price</th>
                                <th>On Hand</th>
                                <th>Qty</th>
                                <th>Ordered</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr style="vertical-align:middle;">`;
                                if(val.category == 'Tire')
                                {
                                    html += `<td><p style="margin-bottom:0px;">`+val.size+`</p><p>SKU: `+val.sku+`</p></td>`;
                                }
                                else
                                {
                                    html += `<td><p style="margin-bottom:0px;">`+val.rim_size+`</p><p>SKU: `+val.sku+`</p></td>`;
                                }
                                html += `<td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                if(val.stock_qty > 0)
                                {
                                    html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                }
                                else
                                {
                                    html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                }
                                html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                <td id="carttd`+val.id+`">`;
                                if(val.added_to_cart == 0)
                                {
                                
                                html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                }
                                else
                                {
                                    html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                }
                            html += `</td></tr>
                            </tbody>
                        </table>
                    </div>`;
                });
                $("#variant_product_data").html(html);
                $("#variant_product_list").addClass('active');
            }
            else
            {
                var html = `No data available`;
                $("#variant_product_data").html(html);
                $("#variant_product_list").addClass('active');
            }
        },
    });
}

function add_to_cart(product_id)
{
    var product_qty = $("#product_qty"+product_id).val();
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/add-to-cart",
        data: {product_id:product_id,product_qty:product_qty},
        success: function (res, status, xhr) {
            if(res.status == true)
            {
                var html = `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                $("#carttd"+product_id).html(html);
                Swal.fire({
                title: 'Success!',
                text: res.msg,
                icon: 'success',
                confirmButtonText: 'OK'
                });
            }
            else
            {
                Swal.fire({
                title: 'Error!',
                text: res.msg,
                icon: 'danger',
                confirmButtonText: 'OK'
                });
            }
        },
    });
}

function get_cart_list()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-cart-list",
        data: {},
        success: function (res, status, xhr) {
            var html = ``;
            var sub_total = 0;
            if(res.length > 0)
            {
                $(".submitorder").removeAttr('disabled');
                $.each(res, function (key, val) {
                    var offer_price = parseFloat(val.offer_price);
                    var qty = parseFloat(val.qty);
                    var otsf = 4.5*qty;
                    if(val.category == 'Tire'){
                        var price_plus_otsf = offer_price+otsf;
                    }else{
                        var price_plus_otsf = offer_price;
                    }
                    var total_offer_price = price_plus_otsf*qty;
                    sub_total = sub_total + total_offer_price;
                    html += `<tr>
                                <td class="product_remove">
                                    <a style="cursor:pointer;" onclick="delete_cart_item(`+val.id+`);">
                                        <i class="pe-7s-trash" data-tippy="Remove" data-tippy-inertia="true" data-tippy-animation="shift-away" data-tippy-delay="50" data-tippy-arrow="true" data-tippy-theme="sharpborder"></i>
                                    </a>
                                </td>
                                <td class="product-name">`;
                                    if(val.category == 'Tire')
                                    {
                                        html += `<p>`+val.size+`</p>
                                        <p>SKU:`+val.sku+`</p>`;
                                    }
                                    else if(val.category == 'Wheels')
                                    {
                                        html += `<p>`+val.rim_size+`</p>
                                        <p>SKU:`+val.sku+`</p>`;
                                    }
                                    else
                                    {
                                        html += `<p></p>
                                        <p>SKU:`+val.sku+`</p>`;
                                    }
                                html += `</td><td class="product-price">`+val.title+`</td>
                                <td class="quantity">
                                    <div class="cart-plus-minus">
                                        <input class="cart-plus-minus-box" min="1" max="`+val.stock_qty+`" id="cart_qty`+val.id+`" value="`+val.qty+`" type="text" readonly>
                                        <div class="dec qtybutton" onclick="update_cart_qty(`+val.id+`,'minus',`+val.stock_qty+`);">
                                            <i class="fa fa-minus"></i>
                                        </div>
                                        <div class="inc qtybutton" onclick="update_cart_qty(`+val.id+`,'plus',`+val.stock_qty+`);">
                                            <i class="fa fa-plus"></i>
                                        </div>
                                    </div>
                                </td>
                                <td class="product-subtotal"><span class="amount">$`+val.offer_price+`</span></td>`;
                                if(val.category == 'Tire')
                                {
                                    html +=`<td class="product-subtotal"><span class="amount">$`+otsf+`</span></td>`;
                                }
                                else
                                {
                                    html +=`<td class="product-subtotal"><span class="amount">$0</span></td>`;
                                }
                                html += `<td class="product-subtotal"><span class="amount">$`+total_offer_price+`</span></td>
                            </tr>`;
                });
            }
            else
            {
                html += '<tr><td colspan="6">No data available</td></tr>';
                $('.submitorder').attr('disabled', true); 
            }
            $("#cart_list").html(html);
            $(".sub_total_amount").text("$"+sub_total);
            var hst_amount = (13 / 100) * parseFloat(sub_total);
            $(".hst_amount").text("$"+roundTo(hst_amount,2));
            $(".total_amount").text("$"+roundTo(sub_total+hst_amount,2));

        },
    });
}

function get_cart_count()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-cart-count",
        data: {},
        success: function (res, status, xhr) {
            $(".cart_qty").text(res);
        },
    });
}

function update_cart_qty(cart_id,type,max_qty)
{
    var qty = $("#cart_qty"+cart_id).val();
    if(type == 'minus')
    {
        if(qty == 1)
        {
            qty = qty;
            return;
        }
        else
        {
            qty = parseInt(qty)-1;
        }
    }
    else
    {
        qty = parseInt(qty)+1;
    }
    if(qty > max_qty){
        Swal.fire({
        title: 'Error!',
        text: 'Max qty can be '+max_qty,
        icon: 'danger',
        confirmButtonText: 'OK'
        });
        return;
    }
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/update-cart-qty",
        data: {cart_id:cart_id,qty:qty},
        success: function (res, status, xhr) {
            
            get_cart_list();
            
        },
    });
}

function delete_cart_item(cart_id)
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/delete-cart-item",
        data: {cart_id:cart_id},
        success: function (res, status, xhr) {
            
            get_cart_list();
            
        },
    });
}

function submit_order()
{
    var special_msg = $("#special_msg").val();
    var po = $("#po").val();
    var shipping_address = $("#shipping_address").text();
    var shipping_contact = $("#shipping_contact").text();
    var shipping_name = $("#shipping_name").text();
    var total_item = $("#total_item").text();
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/save-order",
        data: {po:po,special_msg:special_msg,shipping_address:shipping_address,shipping_contact:shipping_contact,shipping_name:shipping_name,total_item:total_item},
        success: function (res, status, xhr) {
            if(res.status == true)
            {
                Swal.fire({
                title: 'Success!',
                text: res.msg,
                icon: 'success',
                confirmButtonText: 'OK'
                });
                location.href=""+base_url+"web-order/track-order"
            }
            else
            {
                Swal.fire({
                title: 'Error!',
                text: res.msg,
                icon: 'danger',
                confirmButtonText: 'OK'
                });
                location.reload();
            }
        },
    });
}

function roundTo(value, decimals) {
    return Math.round(value * Math.pow(10, decimals)) / Math.pow(10, decimals);
}

function open_quick_size()
{
    selected_aspect_ratio = '';
    selected_tire_width = '';
    selected_rim_diameter = '';
    $("#inputsearch").val('');

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-tire-quick-size",
        data: {},
        success: function (res, status, xhr) {
            console.log(res);
            var html = `<div class="row">
            <div class="col-md-4" style="padding-left: 0;margin-bottom: 5px;">
            <button type="button" class="btn btn-danger" onclick="add_to_search();">Add To Search</button>
            </div>
            <ul class="nav nav-tabs bg-secondary">`;
                $.each(res, function (key, val) {
                    html += `<li class="col-sm-4 text-center bg-secondary text-white border-end">
                                <div class="row" style="padding-bottom: 15px;border-bottom: 1px solid;">
                                    <a data-toggle="tab" href="#">`+val.title+`</a>
                                </div>
                                <div class="row mt-5">`;
                                    $.each(val.data, function (key1, val1) {
                                    var dataattr = val1.value;
                                    html += `<div class="col-sm-2 bg-white text-center text-black spaceing cursor searhdata`+key+`" id="searhdata`+key+``+key1+`" data-type="`+val.type+`" data-attr="`+dataattr+`" onclick="set_selected(`+key+`,`+key1+`,'`+dataattr+`','`+val.type+`');">`+val1.value+`</div>`;
                                    });
                                html += `</div>
                            </li>`;
                });
            html += `</ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Quick Size (0-9 Only)');
            $("#variant_product_data").html('');
        },
    });
}

function set_selected(headkey,datakey,datavalue,type)
{
    $(".searhdata"+headkey).removeClass('selecteddata');
    $("#searhdata"+headkey+datakey).addClass('selecteddata');
    if(type == 'tire_width')
    {
        selected_tire_width = datavalue;
    }
    else if(type == 'aspect_ratio')
    {
        selected_aspect_ratio = datavalue;
    }
    else
    {
        selected_rim_diameter = datavalue;
    }
    if(selected_tire_width != '' && selected_aspect_ratio != '' && selected_rim_diameter != '')
    {
        add_to_search();
    }
}

function add_to_search()
{
    var search_text = '';
    $('.selecteddata').each(function(key,val) {
        search_text += $(this).data('attr');
        var data_type = $(this).data('type');
        if(data_type == 'tire_width')
        {
            selected_tire_width = $(this).data('attr');
        }
        else if(data_type == 'aspect_ratio')
        {
            selected_aspect_ratio = $(this).data('attr');
        }
        else
        {
            selected_rim_diameter = $(this).data('attr');
        }
    });
    $("#inputsearch").val(search_text);
    $("#tireModal").modal('hide');
    enable_search = 'size';
}

function clear_tire_search()
{
    $("#variant_product_data").html('');
    selected_aspect_ratio = '';
    selected_tire_width = '';
    selected_rim_diameter = '';
    $("#inputsearch").val('');
}
function clear_wheel_search()
{
    $("#variant_product_data").html('');
    selected_aspect_ratio = '';
    selected_tire_width = '';
    selected_rim_diameter = '';
    $("#inputsearch").val('');
}
function clear_other_search()
{
    $("#variant_product_data").html('');
    selected_aspect_ratio = '';
    selected_tire_width = '';
    selected_rim_diameter = '';
    $("#inputsearch").val('');
}

function open_manufacturer()
{
    selected_aspect_ratio = '';
    selected_tire_width = '';
    selected_rim_diameter = '';
    selected_brand = '';
    $("#inputsearch").val('');

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-tire-by-brand",
        data: {},
        success: function (res, status, xhr) {
            console.log(res);
            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary row">`;
                $.each(res, function (key, val) {
                    html += `<li class="col-sm-2 text-center bg-secondary text-white border-end">`;
                    var dataattr = val.value;
                    html += `<div class=" bg-white text-center text-black spaceing cursor searhdata`+key+`" id="searhdata`+key+`" data-id="`+val.id+`" data-attr="`+dataattr+`" onclick="set_brand_selected(`+key+`,'`+dataattr+`',`+val.id+`);">`+val.value+`</div>`;
                    html += `</li>`;
                });
            html += `</ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Manufacturer');
            $("#variant_product_data").html('');
        },
    });
}

function set_brand_selected(headkey,datavalue,id)
{
    $(".searhdata"+headkey).removeClass('selecteddata');
    $("#searhdata"+headkey).addClass('selecteddata');
    selected_brand = id;
    $("#inputsearch").val(datavalue);
    $("#tireModal").modal('hide');
    enable_search = 'brand';
}

function set_wheel_brand_selected(headkey,datavalue,id)
{
    $(".searhdata"+headkey).removeClass('selecteddata');
    $("#searhdata"+headkey).addClass('selecteddata');
    selected_brand = id;
    $("#inputsearch").val(datavalue);
    $("#tireModal").modal('hide');
    enable_search = 'wheel_brand';
}

function search_product_by_tire()
{
    if(enable_search == 'size')
    {
        search_by_tire();
    }
    else if(enable_search == 'brand')
    {
        search_by_brand();
    }
    else
    {
        if($("#inputsearch").val() != '')
        {
            product_search_by_search_key('Tire');
        }
    }
}

function search_by_tire()
{
    if(selected_tire_width != '' || selected_aspect_ratio != '' || selected_rim_diameter != '')
    {
        if ($('input[name="hide_winter"]:checked').length > 0) { hide_winter = true; } else { hide_winter = ''; }
        if ($('input[name="winter_only"]:checked').length > 0) { winter_only = true; } else { winter_only = ''; }
        if ($('input[name="all_weather_only"]:checked').length > 0) { all_weather_only = true; } else { all_weather_only = ''; }
        if ($('input[name="on_sale_only"]:checked').length > 0) { on_sale_only = true; } else { on_sale_only = ''; }

        $.ajax({
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            url: ""+base_url+"web-order/search-product-by-size",
            data: {
                aspect_ratio:selected_aspect_ratio,
                tire_width:selected_tire_width,
                rim_diameter:selected_rim_diameter,
                load_index:load_index_filter,
                speed_rating:speed_rating_filter,
                product_type:product_type_filter,
                hide_winter:hide_winter,
                winter_only:winter_only,
                all_weather_only:all_weather_only,
                on_sale_only:on_sale_only,
            },
            success: function (res, status, xhr) {
                if(res.length > 0)
                {
                    var html = ``;
                    $.each(res, function (key, val) {
                        html += `<div class="col-md-12">
                            <table class="table table-bordered bg-white">
                                <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>On Hand</th>
                                    <th>Qty</th>
                                    <th>Ordered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr style="vertical-align:middle;">`;
                                    html += `<td><p style="margin-bottom:0px;">`+val.size+`</p><p>SKU: `+val.sku+`</p></td>
                                    <td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                    <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                    if(val.stock_qty > 0)
                                    {
                                        html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                    }
                                    html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                    <td id="carttd`+val.id+`">`;
                                    if(val.added_to_cart == 0)
                                    {
                                    
                                    html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                    }
                                    else
                                    {
                                        html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                    }
                                html += `</td></tr>
                                </tbody>
                            </table>
                        </div>`;
                    });
                    $("#variant_product_data").html(html);
                }
                else
                {
                    var html = `<div class="col-md-12 text-danger text-center">No data available</div>`;
                    $("#variant_product_data").html(html);
                }
            },
        });
    }
    else
    {
        $("#variant_product_data").html('');
        return;
    }
}

function search_by_brand()
{
    if(selected_brand != '')
    {
        if ($('input[name="hide_winter"]:checked').length > 0) { hide_winter = true; } else { hide_winter = ''; }
        if ($('input[name="winter_only"]:checked').length > 0) { winter_only = true; } else { winter_only = ''; }
        if ($('input[name="all_weather_only"]:checked').length > 0) { all_weather_only = true; } else { all_weather_only = ''; }
        if ($('input[name="on_sale_only"]:checked').length > 0) { on_sale_only = true; } else { on_sale_only = ''; }

        $.ajax({
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            url: ""+base_url+"web-order/search-product-by-brand",
            data: {
                brand:selected_brand,
                load_index:load_index_filter,
                speed_rating:speed_rating_filter,
                product_type:product_type_filter,
                hide_winter:hide_winter,
                winter_only:winter_only,
                all_weather_only:all_weather_only,
                on_sale_only:on_sale_only,
            },
            success: function (res, status, xhr) {
                if(res.length > 0)
                {
                    var html = ``;
                    $.each(res, function (key, val) {
                        html += `<div class="col-md-12">
                            <table class="table table-bordered bg-white">
                                <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>On Hand</th>
                                    <th>Qty</th>
                                    <th>Ordered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr style="vertical-align:middle;">`;
                                    html += `<td><p style="margin-bottom:0px;">`+val.size+`</p><p>SKU: `+val.sku+`</p></td>
                                    <td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                    <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                    if(val.stock_qty > 0)
                                    {
                                        html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                    }
                                    html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                    <td id="carttd`+val.id+`">`;
                                    if(val.added_to_cart == 0)
                                    {
                                    
                                    html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                    }
                                    else
                                    {
                                        html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                    }
                                html += `</td></tr>
                                </tbody>
                            </table>
                        </div>`;
                    });
                    $("#variant_product_data").html(html);
                }
                else
                {
                    var html = `<div class="col-md-12 text-danger text-center">No data available</div>`;
                    $("#variant_product_data").html(html);
                }
            },
        });
    }
    else
    {
        $("#variant_product_data").html('');
        return;
    }
}
function vehicle_product_search_by_search_key()
{
    var search_input = $("#inputsearch").val();
    if(search_input != '')
    {
        $.ajax({
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            url: ""+base_url+"web-order/vehicle-product-search-by-search-key",
            data: {
                search_key:search_input
            },
            success: function (res, status, xhr) {
                $(".tablist").removeClass('active');
                if(res.length > 0)
                {
                    var html = ``;
                    $.each(res, function (key, val) {
                        html += `<div class="col-md-12">
                            <table class="table table-bordered bg-white">
                                <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>On Hand</th>
                                    <th>Qty</th>
                                    <th>Ordered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr style="vertical-align:middle;">`;
                                    if(val.category == 'Tire')
                                    {
                                        html += `<td><p style="margin-bottom:0px;">`+val.size+`</p><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    else if(val.category == 'Wheels')
                                    {
                                        html += `<td><p style="margin-bottom:0px;">`+val.rim_size+`</p><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    html += `<td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                    <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                    if(val.stock_qty > 0)
                                    {
                                        html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                    }
                                    html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                    <td id="carttd`+val.id+`">`;
                                    if(val.added_to_cart == 0)
                                    {
                                    
                                    html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                    }
                                    else
                                    {
                                        html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                    }
                                html += `</td></tr>
                                </tbody>
                            </table>
                        </div>`;
                    });
                    $("#variant_product_data").html(html);
                    $("#variant_product_list").addClass('active');
                }
                else
                {
                    var html = `No data available`;
                    $("#variant_product_data").html(html);
                    $("#variant_product_list").addClass('active');
                }
            },
        });
    }
    else
    {
        return false;
    }
}
function product_search_by_search_key(category='')
{
    var search_input = $("#inputsearch").val();
    if(search_input != '')
    {
        if ($('input[name="hide_winter"]:checked').length > 0) { hide_winter = true; } else { hide_winter = ''; }
        if ($('input[name="winter_only"]:checked').length > 0) { winter_only = true; } else { winter_only = ''; }
        if ($('input[name="all_weather_only"]:checked').length > 0) { all_weather_only = true; } else { all_weather_only = ''; }
        if ($('input[name="on_sale_only"]:checked').length > 0) { on_sale_only = true; } else { on_sale_only = ''; }

        $.ajax({
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            url: ""+base_url+"web-order/product-search-by-search-key",
            data: {
                search_key:search_input,
                category:category,
                hide_winter:hide_winter,
                winter_only:winter_only,
                all_weather_only:all_weather_only,
                on_sale_only:on_sale_only,
            },
            success: function (res, status, xhr) {
                $(".tablist").removeClass('active');
                if(res.length > 0)
                {
                    var html = ``;
                    $.each(res, function (key, val) {
                        html += `<div class="col-md-12">
                            <table class="table table-bordered bg-white">
                                <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>On Hand</th>
                                    <th>Qty</th>
                                    <th>Ordered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr style="vertical-align:middle;">`;
                                    if(val.category == 'Tire')
                                    {
                                        html += `<td><p style="margin-bottom:0px;">`+val.size+`</p><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    else if(val.category == 'Wheels')
                                    {
                                        html += `<td><p style="margin-bottom:0px;">`+val.rim_size+`</p><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    html += `<td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                    <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                    if(val.stock_qty > 0)
                                    {
                                        html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                    }
                                    html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                    <td id="carttd`+val.id+`">`;
                                    if(val.added_to_cart == 0)
                                    {
                                    
                                    html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                    }
                                    else
                                    {
                                        html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                    }
                                html += `</td></tr>
                                </tbody>
                            </table>
                        </div>`;
                    });
                    $("#variant_product_data").html(html);
                    $("#variant_product_list").addClass('active');
                }
                else
                {
                    var html = `No data available`;
                    $("#variant_product_data").html(html);
                    $("#variant_product_list").addClass('active');
                }
            },
        });
    }
    else
    {
        return false;
    }
}

function open_wheel_quick_size()
{
    selected_bolt_pattern = '';
    selected_rim_width = '';
    selected_diameter = '';
    $("#inputsearch").val('');

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-wheel-quick-size",
        data: {},
        success: function (res, status, xhr) {
            console.log(res);
            var html = `<div class="row">
            <div class="col-md-4" style="padding-left: 0;margin-bottom: 5px;">
            <button type="button" class="btn btn-danger" onclick="add_wheel_to_search();">Add To Search</button>
            </div>
            <ul class="nav nav-tabs bg-secondary">`;
                $.each(res, function (key, val) {
                    html += `<li class="col-sm-4 text-center bg-secondary text-white border-end">
                                <div class="row" style="padding-bottom: 15px;border-bottom: 1px solid;">
                                    <a data-toggle="tab" href="#">`+val.title+`</a>
                                </div>
                                <div class="row mt-5">`;
                                    $.each(val.data, function (key1, val1) {
                                    var dataattr = val1.value;
                                    html += `<div class="col-sm-3 bg-white text-center text-black spaceing cursor searhdata`+key+`" id="searhdata`+key+``+key1+`" data-type="`+val.type+`" data-attr="`+dataattr+`" onclick="set_wheel_selected(`+key+`,`+key1+`,'`+dataattr+`','`+val.type+`');">`+val1.value+`</div>`;
                                    });
                                html += `</div>
                            </li>`;
                });
            html += `</ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Quick Size (0-9 Only)');
            $("#variant_product_data").html('');
        },
    });
}

function set_wheel_selected(headkey,datakey,datavalue,type)
{
    $(".searhdata"+headkey).removeClass('selecteddata');
    $("#searhdata"+headkey+datakey).addClass('selecteddata');
    if(type == 'rim_width')
    {
        selected_rim_width = datavalue;
    }
    else if(type == 'bolt_pattern')
    {
        selected_bolt_pattern = datavalue;
    }
    else
    {
        selected_diameter = datavalue;
    }
    if(selected_rim_width != '' && selected_bolt_pattern != '' && selected_diameter != '')
    {
        add_to_wheel_search();
    }
}

function add_wheel_to_search()
{
    var search_text = '';
    $('.selecteddata').each(function(key,val) {
        search_text += $(this).data('attr');
        var data_type = $(this).data('type');
        if(data_type == 'rim_width')
        {
            selected_rim_width = $(this).data('attr');
        }
        else if(data_type == 'bolt_pattern')
        {
            selected_bolt_pattern = $(this).data('attr');
        }
        else
        {
            selected_diameter = $(this).data('attr');
        }
    });
    $("#inputsearch").val(search_text);
    $("#tireModal").modal('hide');
    enable_search = 'wheel_size';
}

function search_product_by_wheel()
{
    if(enable_search == 'wheel_size')
    {
        search_by_wheel();
    }
    else if(enable_search == 'wheel_brand')
    {
        search_by_wheel_brand();
    }
    else
    {
        if($("#inputsearch").val() != '')
        {
            wheel_product_search_by_search_key('Wheels');
        }
    }
}

function search_by_wheel()
{
    if(selected_rim_width != '' || selected_bolt_pattern != '' || selected_diameter != '')
    {
        if(diameter_filter != '')
        {
            selected_diameter = diameter_filter;
        }
        if(rim_width_filter != '')
        {
            rim_width = rim_width_filter;
        }
        if ($('input[name="on_sale_only"]:checked').length > 0) { on_sale_only = true; } else { on_sale_only = ''; }
        $.ajax({
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            url: ""+base_url+"web-order/search-product-by-wheel-size",
            data: {
                bolt_pattern:selected_bolt_pattern,
                rim_width:selected_rim_width,
                diameter:selected_diameter,
                offset:offset_filter,
                overall_diameter:overall_diameter_filter,
                on_sale_only:on_sale_only
            },
            success: function (res, status, xhr) {
                if(res.length > 0)
                {
                    var html = ``;
                    $.each(res, function (key, val) {
                        html += `<div class="col-md-12">
                            <table class="table table-bordered bg-white">
                                <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>On Hand</th>
                                    <th>Qty</th>
                                    <th>Ordered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr style="vertical-align:middle;">`;
                                    html += `<td><p style="margin-bottom:0px;">`+val.rim_size+`</p><p>SKU: `+val.sku+`</p></td>
                                    <td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                    <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                    if(val.stock_qty > 0)
                                    {
                                        html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                    }
                                    html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                    <td id="carttd`+val.id+`">`;
                                    if(val.added_to_cart == 0)
                                    {
                                    
                                    html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                    }
                                    else
                                    {
                                        html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                    }
                                html += `</td></tr>
                                </tbody>
                            </table>
                        </div>`;
                    });
                    $("#variant_product_data").html(html);
                }
                else
                {
                    var html = `<div class="col-md-12 text-danger text-center">No data available</div>`;
                    $("#variant_product_data").html(html);
                }
            },
        });
    }
    else
    {
        $("#variant_product_data").html('');
        return;
    }
}

function search_by_wheel_brand()
{
    if(selected_brand != '')
    {
        if ($('input[name="on_sale_only"]:checked').length > 0) { on_sale_only = true; } else { on_sale_only = ''; }
        $.ajax({
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            url: ""+base_url+"web-order/search-product-by-wheel-brand",
            data: {
                brand:selected_brand,
                diameter:diameter_filter,
                rim_width:rim_width_filter,
                offset:offset_filter,
                overall_diameter:overall_diameter_filter,
                on_sale_only:on_sale_only
            },
            success: function (res, status, xhr) {
                if(res.length > 0)
                {
                    var html = ``;
                    $.each(res, function (key, val) {
                        html += `<div class="col-md-12">
                            <table class="table table-bordered bg-white">
                                <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>On Hand</th>
                                    <th>Qty</th>
                                    <th>Ordered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr style="vertical-align:middle;">`;
                                    html += `<td><p style="margin-bottom:0px;">`+val.rim_size+`</p><p>SKU: `+val.sku+`</p></td>
                                    <td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                    <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                    if(val.stock_qty > 0)
                                    {
                                        html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                    }
                                    html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                    <td id="carttd`+val.id+`">`;
                                    if(val.added_to_cart == 0)
                                    {
                                    
                                    html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                    }
                                    else
                                    {
                                        html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                    }
                                html += `</td></tr>
                                </tbody>
                            </table>
                        </div>`;
                    });
                    $("#variant_product_data").html(html);
                }
                else
                {
                    var html = `<div class="col-md-12 text-danger text-center">No data available</div>`;
                    $("#variant_product_data").html(html);
                }
            },
        });
    }
    else
    {
        $("#variant_product_data").html('');
        return;
    }
}

function wheel_product_search_by_search_key(category='')
{
    var search_input = $("#inputsearch").val();
    if(search_input != '')
    {
        if ($('input[name="hide_winter"]:checked').length > 0) { hide_winter = true; } else { hide_winter = ''; }
        if ($('input[name="winter_only"]:checked').length > 0) { winter_only = true; } else { winter_only = ''; }
        if ($('input[name="all_weather_only"]:checked').length > 0) { all_weather_only = true; } else { all_weather_only = ''; }
        if ($('input[name="on_sale_only"]:checked').length > 0) { on_sale_only = true; } else { on_sale_only = ''; }

        $.ajax({
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            url: ""+base_url+"web-order/wheel-product-search-by-search-key",
            data: {
                search_key:search_input,
                category:category,
                hide_winter:hide_winter,
                winter_only:winter_only,
                all_weather_only:all_weather_only,
                on_sale_only:on_sale_only,
            },
            success: function (res, status, xhr) {
                $(".tablist").removeClass('active');
                if(res.length > 0)
                {
                    var html = ``;
                    $.each(res, function (key, val) {
                        html += `<div class="col-md-12">
                            <table class="table table-bordered bg-white">
                                <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>On Hand</th>
                                    <th>Qty</th>
                                    <th>Ordered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr style="vertical-align:middle;">`;
                                    if(val.category == 'Tire')
                                    {
                                        html += `<td><p style="margin-bottom:0px;">`+val.size+`</p><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    else if(val.category == 'Wheels')
                                    {
                                        html += `<td><p style="margin-bottom:0px;">`+val.rim_size+`</p><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><p>SKU: `+val.sku+`</p></td>`;
                                    }
                                    html += `<td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                    <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                    if(val.stock_qty > 0)
                                    {
                                        html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                    }
                                    html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                    <td id="carttd`+val.id+`">`;
                                    if(val.added_to_cart == 0)
                                    {
                                    
                                    html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                    }
                                    else
                                    {
                                        html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                    }
                                html += `</td></tr>
                                </tbody>
                            </table>
                        </div>`;
                    });
                    $("#variant_product_data").html(html);
                    $("#variant_product_list").addClass('active');
                }
                else
                {
                    var html = `No data available`;
                    $("#variant_product_data").html(html);
                    $("#variant_product_list").addClass('active');
                }
            },
        });
    }
    else
    {
        return false;
    }
}

function open_wheel_manufacturer()
{
    selected_diameter = '';
    selected_rim_width = '';
    selected_bolt_pattern = '';
    selected_brand = '';
    $("#inputsearch").val('');

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-wheel-by-brand",
        data: {},
        success: function (res, status, xhr) {
            console.log(res);
            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary row">`;
                $.each(res, function (key, val) {
                    html += `<li class="col-sm-2 text-center bg-secondary text-white border-end">`;
                    var dataattr = val.value;
                    html += `<div class=" bg-white text-center text-black spaceing cursor searhdata`+key+`" id="searhdata`+key+`" data-id="`+val.id+`" data-attr="`+dataattr+`" onclick="set_wheel_brand_selected(`+key+`,'`+dataattr+`',`+val.id+`);">`+val.value+`</div>`;
                    html += `</li>`;
                });
            html += `</ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Manufacturer');
            $("#variant_product_data").html('');
        },
    });
}


function open_other_manufacturer()
{
    selected_brand = '';
    $("#inputsearch").val('');

    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-other-brand",
        data: {},
        success: function (res, status, xhr) {
            console.log(res);
            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary row">`;
                $.each(res, function (key, val) {
                    html += `<li class="col-sm-2 text-center bg-secondary text-white border-end">`;
                            var dataattr = val.value;
                            html += `<div class="bg-white text-center text-black spaceing cursor searhdata`+key+`" id="searhdata`+key+`" data-id="`+val.id+`" data-attr="`+dataattr+`" onclick="set_brand_selected(`+key+`,'`+dataattr+`',`+val.id+`);">`+val.value+`</div>`;
                        html += `</li>`;
                });
            html += `</ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Manufacturer');
            $("#variant_product_data").html('');
        },
    });
}

function search_other_product()
{
    selected_brand = $("#inputsearch").val();
    if ($('input[name="on_sale_only"]:checked').length > 0) { on_sale_only = true; } else { on_sale_only = ''; }
    if(selected_brand != '')
    {
        $.ajax({
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            url: ""+base_url+"web-order/search-other-product",
            data: {brand:selected_brand,on_sale_only:on_sale_only},
            success: function (res, status, xhr) {
                if(res.length > 0)
                {
                    var html = ``;
                    $.each(res, function (key, val) {
                        html += `<div class="col-md-12">
                            <table class="table table-bordered bg-white">
                                <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>On Hand</th>
                                    <th>Qty</th>
                                    <th>Ordered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr style="vertical-align:middle;">`;
                                    html += `<td><p style="margin-bottom:0px;">`+val.rim_size+`</p><p>SKU: `+val.sku+`</p></td>
                                    <td style="width: 36%;"><p style="margin-bottom:0px;">`+val.title+`</p></td>
                                    <td><p style="margin-bottom:0px;">$`+val.main_price+`</p><p style="font-size:13px;">$`+val.offer_price+`</p></td>`;
                                    if(val.stock_qty > 0)
                                    {
                                        html += `<td><button class="btn btn-success">`+val.stock_qty+` more available</button></td>`;
                                    }
                                    else
                                    {
                                        html += `<td><button class="btn btn-danger">Call for availability</button></td>`;
                                    }
                                    html += `<td><input type="number" id="product_qty`+val.id+`" value="1" style="width: 48px;text-align: center;"></td>
                                    <td id="carttd`+val.id+`">`;
                                    if(val.added_to_cart == 0)
                                    {
                                    
                                    html += `<button class="btn btn-danger" id="cartbtn`+val.id+`" onclick="add_to_cart(`+val.id+`);">Add to order</button>`;
                                    }
                                    else
                                    {
                                        html += `<a class="btn btn-success" href="`+base_url+`web-order/cart">Go to cart</a>`;
                                    }
                                html += `</td></tr>
                                </tbody>
                            </table>
                        </div>`;
                    });
                    $("#variant_product_data").html(html);
                }
                else
                {
                    var html = `<div class="col-md-12 text-danger text-center">No data available</div>`;
                    $("#variant_product_data").html(html);
                }
            },
        });
    }
    else
    {
        $("#variant_product_data").html('');
        return;
    }
}

function get_load_index()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-load-index",
        data: {},
        success: function (res, status, xhr) {

            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary"><li class="col-sm-12 text-center bg-secondary border-end">
            <div class="row mt-5">`;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-2 bg-white text-center text-black spaceing cursor" data-id="`+val.id+`"
                    data-load_in_lbs="`+val.load_in_lbs+`" data-load_in_kg="`+val.load_in_kg+`"  onclick="set_extra_filter('load_index',this);">
                        <div class="row">
                            <div class="col-md-6" style="margin-top: 5%;">`+val.load_index+`</div>
                            <div class="col-md-6">
                                <p class="mb-0">`+val.load_in_lbs+` lbs</p>
                                <p class="mb-0">`+val.load_in_kg+` kg</p>
                            </div>
                        </div>
                    </div>`;
                });
            html += `</div></li></ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Load Index');
            $("#variant_product_data").html('');

        },
    });
}

function get_speed_rating()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-speed-rating",
        data: {},
        success: function (res, status, xhr) {

            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary">
            <li class="col-sm-12 text-center bg-secondary border-end"><div class="row mt-5">`;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-2 bg-white text-center text-black spaceing cursor" 
                    data-id="`+val.id+`" data-rating_in_mph="`+val.rating_in_mph+`" data-rating_in_kmph="`+val.rating_in_kmph+`"
                      onclick="set_extra_filter('speed_rating',this);">
                        <div class="row">
                            <div class="col-md-6" style="margin-top: 5%;">`+val.rating+`</div>
                            <div class="col-md-6">
                            <p class="mb-0">`+val.rating_in_mph+` MPH</p>
                            <p class="mb-0">`+val.rating_in_kmph+` KM/H</p>
                            </div>
                        </div>
                    </div>`;
                });
            html += `</div></li></ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Speed Rating');
            $("#variant_product_data").html('');

        },
    });
}

function get_product_type()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-product-type",
        data: {},
        success: function (res, status, xhr) {

            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary">
            <li class="col-sm-12 text-center bg-secondary text-white border-end">
            <div class="row mt-5">`;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-2 bg-white text-center text-black spaceing cursor"
                    data-id="`+val.id+`" data-product_type="`+val.product_type+`" onclick="set_extra_filter('product_type',this);">`+val.product_type+`</div>`;
                });
            html += `</div></li></ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Load Index');
            $("#variant_product_data").html('');

        },
    });
}

function get_all_diameter()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-all-diameter",
        data: {},
        success: function (res, status, xhr) {

            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary">
            <li class="col-sm-12 text-center bg-secondary text-white border-end"><div class="row mt-5">`;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-2 bg-white text-center text-black spaceing cursor" 
                    data-id="`+val.id+`" data-diameter="`+val.diameter+`" onclick="set_extra_filter('diameter',this);">`+val.diameter+`</div>`;
                });
            html += `</div></li></ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Diameter');
            $("#variant_product_data").html('');

        },
    });
}

function get_all_rim_width()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-all-rim-width",
        data: {},
        success: function (res, status, xhr) {
            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary">
            <li class="col-sm-12 text-center bg-secondary text-white border-end">
            <div class="row mt-5">
                <div class="row mb-2" style="text-align: left;"><div class="col-md-12">Rim Width</div></div>`;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-2 minimum bg-white text-center text-black spaceing cursor" 
                    onclick="rim_width_filters(this,`+val.id+`);" id="rimwidthmin`+val.id+`">`+val.rim_width+`</div>`;
                });
                html += `</div>
            </div>
            </li>
            </ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Load Index');
            $("#variant_product_data").html('');

        },
    });
}

function get_all_offset()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-all-offset",
        data: {},
        success: function (res, status, xhr) {

            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary">
            <li class="col-sm-12 text-center bg-secondary text-white border-end"><div class="row mt-5">`;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-2 bg-white text-center text-black spaceing cursor" 
                    onclick="set_extra_filter('offset',this);" data-id="`+val.offset_distance+`" data-offset="`+val.offset_distance+`">`+val.offset_distance+`</div>`;
                });
            html += `</div></li></ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Offset');
            $("#variant_product_data").html('');

        },
    });
}

function get_all_overall_diameter()
{
    $.ajax({
        type: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        dataType: "json",
        url: ""+base_url+"web-order/get-all-overall-diameter",
        data: {},
        success: function (res, status, xhr) {

            var html = `<div class="row">
            <ul class="nav nav-tabs bg-secondary"><li class="col-sm-12 text-center bg-secondary text-white border-end"><div class="row mt-5">`;
                $.each(res, function (key, val) {
                    html += `<div class="col-sm-2 bg-white text-center text-black spaceing cursor" 
                    onclick="set_extra_filter('overall_diameter',this);" data-id="`+val.overall_diameter+`" data-overall_diameter="`+val.overall_diameter+`">`+val.overall_diameter+`</div>`;
                });
            html += `</div></li></ul>
            </div>`;
            $("#tire_html").html(html);
            $("#tireModal").modal('show');
            $("#modal-title").text('Center Hub');
            $("#variant_product_data").html('');

        },
    });
}

function set_extra_filter(type,e)
{
    if(type == 'load_index')
    {
        var load_in_lbs = $(e).data('load_in_lbs');
        var load_in_kg = $(e).data('load_in_kg');
        $("#load_in_lbs").text(load_in_lbs);
        $("#load_in_kg").text(load_in_kg);
        var id = $(e).data('id');
        load_index_filter = id;
    }
    else if(type == 'speed_rating')
    {
        var rating_in_mph = $(e).data('rating_in_mph');
        var rating_in_kmph = $(e).data('rating_in_kmph');
        $("#rating_in_mph").text(rating_in_mph);
        $("#rating_in_kmph").text(rating_in_kmph);
        var id = $(e).data('id');
        speed_rating_filter = id;
    }
    else if(type == 'product_type')
    {
        var product_type = $(e).data('product_type');
        $("#product_type").text(product_type);
        var id = $(e).data('id');
        product_type_filter = id;
    }
    else if(type == 'diameter')
    {
        var diameter = $(e).data('diameter');
        $("#diameter").text(diameter);
        var id = $(e).data('id');
        diameter_filter = id;
    }
    else if(type == 'offset')
    {
        var offset = $(e).data('offset');
        $("#offset").text(offset);
        var id = $(e).data('id');
        offset_filter = id;
    }
    else if(type == 'overall_diameter')
    {
        var overall_diameter = $(e).data('overall_diameter');
        $("#overall_diameter").text(overall_diameter);
        var id = $(e).data('id');
        overall_diameter_filter = id;
    }
    $("#tireModal").modal('hide');
}

function clear_extra_filter(type)
{
    if(type == 'load_index')
    {
        $("#load_in_lbs").text('');
        $("#load_in_kg").text('');
        load_index_filter = '';
    }
    else if(type == 'speed_rating')
    {
        $("#rating_in_mph").text('');
        $("#rating_in_kmph").text('');
        speed_rating_filter = '';
    }
    else if(type == 'product_type')
    {
        $("#product_type").text('');
        product_type_filter = '';
    }
    else if(type == 'diameter')
    {
        $("#diameter").text('');
        diameter_filter = '';
    }
    else if(type == 'offset')
    {
        $("#offset").text('');
        offset_filter = '';
    }
    else if(type == 'center_hub')
    {
        $("#center_hub").text('');
        center_hub_filter = '';
    }
}

function rim_width_filters(e,id)
{

        rim_width_min_selected = true;
        $(".minimum").removeClass('active');
        $(e).addClass('active');

    if(rim_width_min_selected == true)
    {
        rim_width_filter = id;
        var rimwidthtext = $("#rimwidthmin"+id).text();
        $("#rim_width").text(rimwidthtext);
        $("#tireModal").modal('hide');
    }
}