@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->

    <div class="container-fluid px-4 py-4">
        <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Brand Dashboard</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-brand') }}" class="btn btn-primary">Add new brand</a>
            </div>
        </div>
    <!-- Add Inventory Form -->
    <div class="form-container mb-5">
    @if (session('error'))
    <div class="alert alert-danger alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('error') }}
        </div>
    @endif
    @if (session('success'))
    <div class="alert alert-success alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('success') }}
        </div>
  @endif
      
      @if(Request::segment(3))
      <h5 class="mb-3">Add New Brand</h5>
      <form action="{{ route('update-brand') }}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="{{ $brand_detail->id }}">
      @else
      <h5 class="mb-3">Update Brand</h5>
      <form action="{{ route('save-brand') }}" method="post" enctype="multipart/form-data">
        @endif
      @csrf
        <div class="row g-3">
          <!-- Product Name -->
          <div class="col-md-6">
            <label class="form-label">Brand Name</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-card-text"></i></span>
              <input type="text" class="form-control" name="brand_name" placeholder="e.g. Hundai" value="@if(Request::segment(3)){{ $brand_detail->brand_name }}@endif" required>
            </div>
          </div>

          <div class="col-md-6">
            <label class="form-label">Status</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="status" required>
                <option value="" selected disabled>Select status</option>
                <option value="active" @if(Request::segment(3) && $brand_detail->status == 'active') selected  @endif>Active</option>
                <option value="inactive" @if(Request::segment(3) && $brand_detail->status == 'inactive') selected  @endif>Inactive</option>
              </select>
            </div>
          </div>

          <div class="col-12 text-end">
          @if(Request::segment(3))
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Brand</span></button>
          @else
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Brand</span></button>
          @endif
          </div>
        </div>
      </form>
    </div>

    <!-- Inventory Table -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Brand</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>Brand Name</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           @foreach($branddata as $key => $p)
          <tr>
            <td>{{ $key+1 }}</td>
            <td>{{ $p->brand_name }}</td>
            <td>
                <span class="badge @if($p->status == 'active') bg-primary @else bg-warning @endif"><i class="bi bi-circle-fill me-1"></i>{{ $p->status }}</span>
            </td>
            <td>
              <a href="{{ url('/') }}/admin/edit-brand/{{ $p->id }}" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $p->id }})"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>

</div>
</div>
@include('includes.admin_footer')

<script>
  $('#productImageInput').on('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();

        reader.onload = function(e) {
            $('#imagePreview').attr('src', e.target.result).show();
        };

        reader.readAsDataURL(file);
    }
});



function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-brand',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                  location.href = '{{ url('/') }}/admin/manage-brand';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }

</script>